/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractConstantKeysObjectFactory;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public abstract class AbstractConstantKeysObject
extends AbstractRegexObject {
    public abstract TruffleReadOnlyKeysArray getKeys();

    public abstract Object readMemberImpl(String var1) throws UnknownIdentifierException;

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return this.getKeys();
    }

    @ExportMessage
    public boolean isMemberReadable(String member, @Cached IsReadableCacheNode cache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) {
        return cache.execute((AbstractConstantKeysObject)receiverProfile.profile((Object)this), member);
    }

    @ExportMessage
    public Object readMember(String member, @Cached ReadCacheNode readCache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) throws UnknownIdentifierException {
        return readCache.execute((AbstractConstantKeysObject)receiverProfile.profile((Object)this), member);
    }

    @GenerateUncached
    public static abstract class ReadCacheNode
    extends Node {
        public abstract Object execute(AbstractConstantKeysObject var1, String var2) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol"}, limit="8")
        Object readIdentity(AbstractConstantKeysObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol) throws UnknownIdentifierException {
            return ReadCacheNode.read(receiver, cachedSymbol);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)"}, limit="8", replaces={"readIdentity"})
        Object readEquals(AbstractConstantKeysObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol) throws UnknownIdentifierException {
            return ReadCacheNode.read(receiver, cachedSymbol);
        }

        @Specialization(replaces={"readEquals"})
        static Object read(AbstractConstantKeysObject receiver, String symbol) throws UnknownIdentifierException {
            return receiver.readMemberImpl(symbol);
        }

        public static ReadCacheNode create() {
            return AbstractConstantKeysObjectFactory.ReadCacheNodeGen.create();
        }

        public static ReadCacheNode getUncached() {
            return AbstractConstantKeysObjectFactory.ReadCacheNodeGen.getUncached();
        }
    }

    @GenerateUncached
    public static abstract class IsReadableCacheNode
    extends Node {
        public abstract boolean execute(AbstractConstantKeysObject var1, String var2);

        @Specialization(guards={"symbol == cachedSymbol"}, limit="8")
        static boolean cacheIdentity(AbstractConstantKeysObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)"}, limit="8", replaces={"cacheIdentity"})
        static boolean cacheEquals(AbstractConstantKeysObject receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isReadable(AbstractConstantKeysObject receiver, String symbol) {
            return receiver.getKeys().contains(symbol);
        }

        public static IsReadableCacheNode create() {
            return AbstractConstantKeysObjectFactory.IsReadableCacheNodeGen.create();
        }

        public static IsReadableCacheNode getUncached() {
            return AbstractConstantKeysObjectFactory.IsReadableCacheNodeGen.getUncached();
        }
    }
}

