/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.io.JAXPHelper;
import org.dom4j.io.aelfred.SAXDriver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class SAXHelper {
    private static boolean loggedWarning = false;
    static /* synthetic */ Class class$org$dom4j$io$SAXHelper;

    SAXHelper() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected static boolean classNameAvailable(String className) {
        try {
            Class.forName(className, true, (class$org$dom4j$io$SAXHelper != null ? class$org$dom4j$io$SAXHelper : (class$org$dom4j$io$SAXHelper = SAXHelper.class$("org.dom4j.io.SAXHelper"))).getClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static XMLReader createXMLReader(boolean validating) throws SAXException {
        XMLReader reader = SAXHelper.createXMLReaderViaJAXP(validating, true);
        if (reader == null) {
            String className = null;
            try {
                className = System.getProperty("org.xml.sax.driver");
            }
            catch (Exception exception) {}
            if (className != null && className.trim().length() > 0 && SAXHelper.classNameAvailable(className)) {
                reader = XMLReaderFactory.createXMLReader();
            }
            if (reader == null) {
                reader = new SAXDriver();
            }
        }
        return reader;
    }

    protected static XMLReader createXMLReaderViaJAXP(boolean validating, boolean namespaceAware) {
        if (!SAXHelper.classNameAvailable("javax.xml.parsers.SAXParserFactory")) {
            return null;
        }
        try {
            return JAXPHelper.createXMLReader(validating, namespaceAware);
        }
        catch (Throwable e) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to load a SAX XMLReader ");
                    System.out.println("Warning: Exception was: " + e);
                    System.out.println("Warning: I will print the stack trace then carry on using the default SAX parser");
                    e.printStackTrace();
                } else {
                    System.out.println("Warning: Error occurred using JAXP to load a SAXParser. Will use Aelfred instead");
                }
            }
            return null;
        }
    }

    protected static boolean isVerboseErrorReporting() {
        try {
            String flag = System.getProperty("org.dom4j.verbose");
            if (flag != null && flag.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean setParserFeature(XMLReader reader, String featureName, boolean value) {
        try {
            reader.setFeature(featureName, value);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        return false;
    }

    public static boolean setParserProperty(XMLReader reader, String propertyName, Object value) {
        try {
            reader.setProperty(propertyName, value);
            return true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
        return false;
    }
}

