/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class Image
extends InlineLinkNode {
    private BasedSequence urlContent = BasedSequence.NULL;

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.textOpeningMarker, this.text, this.textClosingMarker, this.linkOpeningMarker, this.urlOpeningMarker, this.url, this.pageRef, this.anchorMarker, this.anchorRef, this.urlClosingMarker, this.urlContent, this.titleOpeningMarker, this.titleOpeningMarker, this.title, this.titleClosingMarker, this.linkClosingMarker};
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        Image.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.textOpeningMarker, (BasedSequence)this.text, (BasedSequence)this.textClosingMarker, (String)"text");
        Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.linkOpeningMarker, (String)"linkOpen");
        Image.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.urlOpeningMarker, (BasedSequence)this.url, (BasedSequence)this.urlClosingMarker, (String)"url");
        if (this.pageRef.isNotNull()) {
            Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.pageRef, (String)"pageRef");
        }
        if (this.anchorMarker.isNotNull()) {
            Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorMarker, (String)"anchorMarker");
        }
        if (this.anchorRef.isNotNull()) {
            Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorRef, (String)"anchorRef");
        }
        if (this.urlContent.isNotNull()) {
            Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.urlContent, (String)"urlContent");
        }
        Image.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.titleOpeningMarker, (BasedSequence)this.title, (BasedSequence)this.titleClosingMarker, (String)"title");
        Image.segmentSpanChars((StringBuilder)out, (BasedSequence)this.linkClosingMarker, (String)"linkClose");
    }

    public Image() {
    }

    public Image(BasedSequence chars) {
        super(chars);
    }

    public Image(BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence titleOpenMarker, BasedSequence title, BasedSequence titleCloseMarker, BasedSequence linkCloseMarker) {
        super(textOpenMarker, text, textCloseMarker, linkOpenMarker, url, titleOpenMarker, title, titleCloseMarker, linkCloseMarker);
    }

    public Image(BasedSequence chars, BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence titleOpenMarker, BasedSequence title, BasedSequence titleCloseMarker, BasedSequence linkCloseMarker) {
        super(chars, textOpenMarker, text, textCloseMarker, linkOpenMarker, url, titleOpenMarker, title, titleCloseMarker, linkCloseMarker);
    }

    public Image(BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence linkCloseMarker) {
        super(textOpenMarker, text, textCloseMarker, linkOpenMarker, url, linkCloseMarker);
    }

    public Image(BasedSequence chars, BasedSequence textOpenMarker, BasedSequence text, BasedSequence textCloseMarker, BasedSequence linkOpenMarker, BasedSequence url, BasedSequence linkCloseMarker) {
        super(chars, textOpenMarker, text, textCloseMarker, linkOpenMarker, url, linkCloseMarker);
    }

    @Override
    public void setTextChars(BasedSequence textChars) {
        int textCharsLength = textChars.length();
        this.textOpeningMarker = textChars.subSequence(0, 2);
        this.text = textChars.subSequence(2, textCharsLength - 1).trim();
        this.textClosingMarker = textChars.subSequence(textCharsLength - 1, textCharsLength);
    }

    public void setUrlContent(BasedSequence urlContent) {
        this.urlContent = urlContent;
    }

    public BasedSequence getUrlContent() {
        return this.urlContent;
    }
}

