/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.DateTimeFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDateTimeFormat;

public final class DateTimeFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DateTimeFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DateTimeFormatPrototypeBuiltins();

    protected DateTimeFormatPrototypeBuiltins() {
        super("DateTimeFormat.prototype", DateTimeFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DateTimeFormatPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatResolvedOptionsNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case formatToParts: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatFormatToPartsNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSDateTimeFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSDateTimeFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSDateTimeFormat(dateTimeFormat)"})
        public Object doFormatToParts(DynamicObject dateTimeFormat, Object value) {
            return JSDateTimeFormat.formatToParts(this.getContext(), dateTimeFormat, value);
        }

        @Fallback
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected("DateTimeFormat");
        }
    }

    public static abstract class JSDateTimeFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSDateTimeFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSDateTimeFormat(dateTimeFormat)"})
        public Object doResolvedOptions(DynamicObject dateTimeFormat) {
            return JSDateTimeFormat.resolvedOptions(this.getContext(), dateTimeFormat);
        }

        @Fallback
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected("DateTimeFormat");
        }
    }

    public static enum DateTimeFormatPrototype implements BuiltinEnum<DateTimeFormatPrototype>
    {
        resolvedOptions(0),
        formatToParts(1);

        private final int length;

        private DateTimeFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

