/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.runtime.BigInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSLeftShiftNode.class)
public final class JSLeftShiftNodeGen
extends JSLeftShiftNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private DoubleData double_cache;
    @Node.Child
    private GenericData generic_cache;

    private JSLeftShiftNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object executeObject(Object leftNodeValue, Object rightNodeValue) {
        GenericData s5_;
        int state = this.state_;
        if ((state & 3) != 0 && leftNodeValue instanceof Integer) {
            double rightNodeValue_;
            int leftNodeValue_ = (Integer)leftNodeValue;
            if ((state & 1) != 0 && rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                return this.doInteger(leftNodeValue_, rightNodeValue_2);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue) && !JSBinaryNode.largerThan2e32(rightNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue))) {
                return this.doIntegerDouble(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue);
                DoubleData s3_ = this.double_cache;
                if (s3_ != null) {
                    return this.doDouble(leftNodeValue_, rightNodeValue_, s3_.leftShift_, s3_.leftInt32_, s3_.rightUInt32_);
                }
            }
        }
        if ((state & 8) != 0 && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue, rightNodeValue, s5_.leftShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x1E) == 0 && (state & 0x1F) != 0) {
            return this.execute_int_int0(frameValue, state);
        }
        if ((state & 0x1D) == 0 && (state & 0x1F) != 0) {
            return this.execute_int_double1(frameValue, state);
        }
        if ((state & 0x1B) == 0 && (state & 0x1F) != 0) {
            return this.execute_double_double2(frameValue, state);
        }
        return this.execute_generic3(frameValue, state);
    }

    private Object execute_int_int0(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int_double1(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
            return this.doIntegerDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private Object execute_double_double2(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C00) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A00) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x1600) == 0 && (state & 0x1F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x1A00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 4) != 0);
        DoubleData s3_ = this.double_cache;
        if (s3_ != null) {
            return this.doDouble(leftNodeValue_, rightNodeValue_, s3_.leftShift_, s3_.leftInt32_, s3_.rightUInt32_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x1C00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x1A00) == 0 && (state & 0x1F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private Object execute_generic3(VirtualFrame frameValue, int state) {
        GenericData s5_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3) != 0 && leftNodeValue_ instanceof Integer) {
            double rightNodeValue__;
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if ((state & 1) != 0 && rightNodeValue_ instanceof Integer) {
                int rightNodeValue__2 = (Integer)rightNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__2);
            }
            if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_) && !JSBinaryNode.largerThan2e32(rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_))) {
                return this.doIntegerDouble(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_);
                DoubleData s3_ = this.double_cache;
                if (s3_ != null) {
                    return this.doDouble(leftNodeValue__, rightNodeValue__, s3_.leftShift_, s3_.leftInt32_, s3_.rightUInt32_);
                }
            }
        }
        if ((state & 8) != 0 && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x10) != 0 && (s5_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue_, rightNodeValue_, s5_.leftShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int leftNodeValue_;
        int state = this.state_;
        if ((state & 0x14) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        if ((state & 2) == 0 && (state & 3) != 0) {
            return this.executeInt_int4(frameValue, state, leftNodeValue_);
        }
        if ((state & 1) == 0 && (state & 3) != 0) {
            return this.executeInt_double5(frameValue, state, leftNodeValue_);
        }
        return this.executeInt_generic6(frameValue, state, leftNodeValue_);
    }

    private int executeInt_int4(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        int rightNodeValue_;
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private int executeInt_double5(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        double rightNodeValue_;
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160) == 0 && (state & 0x1F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 2) != 0);
        if (!JSBinaryNode.largerThan2e32(rightNodeValue_)) {
            return this.doIntegerDouble(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_long : (Number)((state & 0x1A0) == 0 && (state & 0x1F) != 0 ? (Number)rightNodeValue_int : (Number)rightNodeValue_)));
    }

    private int executeInt_generic6(VirtualFrame frameValue, int state, int leftNodeValue_) throws UnexpectedResultException {
        double rightNodeValue__;
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 1) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__2 = (Integer)rightNodeValue_;
            return this.doInteger(leftNodeValue_, rightNodeValue__2);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_) && !JSBinaryNode.largerThan2e32(rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, rightNodeValue_))) {
            return this.doIntegerDouble(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x1C) == 0 && (state & 0x1F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast0;
            if (leftNodeValue instanceof Integer) {
                double rightNodeValue_;
                int doubleCast1;
                int leftNodeValue_ = (Integer)leftNodeValue;
                if ((exclude & 1) == 0 && rightNodeValue instanceof Integer) {
                    int rightNodeValue_2 = (Integer)rightNodeValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(leftNodeValue_, rightNodeValue_2);
                    return n;
                }
                if ((exclude & 2) == 0 && (doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue)) != 0 && !JSBinaryNode.largerThan2e32(rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue))) {
                    state |= doubleCast1 << 5;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doIntegerDouble(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if ((exclude & 4) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    DoubleData s3_ = (DoubleData)super.insert((Node)new DoubleData());
                    s3_.leftShift_ = s3_.insertAccessor(JSLeftShiftNode.create());
                    s3_.leftInt32_ = s3_.insertAccessor(JSToInt32Node.create());
                    s3_.rightUInt32_ = s3_.insertAccessor(JSToUInt32Node.create());
                    this.double_cache = s3_;
                    state |= doubleCast0 << 9;
                    state |= doubleCast1 << 5;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doDouble(leftNodeValue_, rightNodeValue_, s3_.leftShift_, s3_.leftInt32_, s3_.rightUInt32_);
                    return object;
                }
            }
            if ((exclude & 8) == 0 && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    BigInt bigInt = this.doBigInt(leftNodeValue_, rightNodeValue_);
                    return bigInt;
                }
            }
            GenericData s5_ = (GenericData)super.insert((Node)new GenericData());
            s5_.leftShift_ = s5_.insertAccessor(JSLeftShiftNode.create());
            s5_.leftToNumeric_ = s5_.insertAccessor(JSToNumericNode.create());
            s5_.rightToNumeric_ = s5_.insertAccessor(JSToNumericNode.create());
            s5_.mixedNumericTypes_ = BranchProfile.create();
            this.generic_cache = s5_;
            this.exclude_ = exclude |= 0xF;
            this.double_cache = null;
            state &= 0xFFFFFFF0;
            this.state_ = state |= 0x10;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(leftNodeValue, rightNodeValue, s5_.leftShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1F & (state & 0x1F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doIntegerDouble";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            DoubleData s3_ = this.double_cache;
            if (s3_ != null) {
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{s3_.leftShift_, s3_.leftInt32_, s3_.rightUInt32_}));
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s5_ = this.generic_cache;
            if (s5_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s5_.leftShift_, s5_.leftToNumeric_, s5_.rightToNumeric_, s5_.mixedNumericTypes_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSLeftShiftNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSLeftShiftNodeGen(left, right);
    }

    @GeneratedBy(value=JSLeftShiftNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        JSLeftShiftNode leftShift_;
        @Node.Child
        JSToNumericNode leftToNumeric_;
        @Node.Child
        JSToNumericNode rightToNumeric_;
        @CompilerDirectives.CompilationFinal
        BranchProfile mixedNumericTypes_;

        GenericData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSLeftShiftNode.class)
    private static final class DoubleData
    extends Node {
        @Node.Child
        JSLeftShiftNode leftShift_;
        @Node.Child
        JSToInt32Node leftInt32_;
        @Node.Child
        JSToUInt32Node rightUInt32_;

        DoubleData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

