/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

class InternalFetchConnection<C>
extends BasePackFetchConnection {
    private Thread worker;

    public InternalFetchConnection(PackTransport transport, final UploadPackFactory<C> uploadPackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream(){
                {
                    this.buffer = new byte[2952];
                }
            };
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Upload-Pack"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    UploadPack rp = uploadPackFactory.create(req, remote);
                    rp.upload(out_r, in_w, null);
                }
                catch (ServiceNotEnabledException e) {
                }
                catch (ServiceNotAuthorizedException e) {
                }
                catch (IOException err) {
                    err.printStackTrace();
                }
                catch (RuntimeException err) {
                    err.printStackTrace();
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException e2) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException e2) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            if (this.worker != null) {
                this.worker.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.worker = null;
        }
    }
}

