/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSSlowArgumentsObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;

public final class JSArgumentsObject
extends JSAbstractArgumentsObject {
    public static final JSArgumentsObject INSTANCE = new JSArgumentsObject();

    private JSArgumentsObject() {
    }

    public static DynamicObject createStrict(JSContext context, JSRealm realm, Object[] elements) {
        if (context.getEcmaScriptVersion() < 8) {
            return JSObject.createWithPrototype(context, context.getStrictArgumentsFactory(), realm, realm.getObjectPrototype(), elements, ScriptArray.createConstantArray(elements), null, elements.length, 0, 0, 0, 0, elements.length, elements.length, realm.getArrayProtoValuesIterator(), realm.getThrowerAccessor(), realm.getThrowerAccessor());
        }
        return JSObject.createWithPrototype(context, context.getStrictArgumentsFactory(), realm, realm.getObjectPrototype(), elements, ScriptArray.createConstantArray(elements), null, elements.length, 0, 0, 0, 0, elements.length, elements.length, realm.getArrayProtoValuesIterator(), realm.getThrowerAccessor());
    }

    public static DynamicObject createNonStrict(JSContext context, JSRealm realm, Object[] elements, DynamicObject callee) {
        return JSObject.createWithPrototype(context, context.getNonStrictArgumentsFactory(), realm, realm.getObjectPrototype(), elements, ScriptArray.createConstantArray(elements), null, elements.length, 0, 0, 0, 0, elements.length, elements.length, realm.getArrayProtoValuesIterator(), callee);
    }

    public static Shape makeInitialNonStrictArgumentsShape(JSContext context, DynamicObject objectPrototype) {
        DynamicObject dummyArray = JSObject.createInit(JSObjectUtil.getProtoChildShape(objectPrototype, INSTANCE, context));
        JSArgumentsObject.putArrayProperties(dummyArray, ScriptArray.createConstantEmptyArray());
        JSObjectUtil.putHiddenProperty(dummyArray, CONNECTED_ARGUMENT_COUNT_PROPERTY, 0);
        Property lengthProperty = JSObjectUtil.makeDataProperty("length", dummyArray.getShape().allocator().locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.configurableNotEnumerableWritable());
        JSObjectUtil.putDataProperty(context, dummyArray, lengthProperty, (Object)0);
        JSArgumentsObject.putIteratorProperty(context, dummyArray);
        Property calleeProperty = JSObjectUtil.makeDataProperty("callee", dummyArray.getShape().allocator().locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.configurableNotEnumerableWritable());
        JSObjectUtil.putDataProperty(context, dummyArray, calleeProperty, (Object)Undefined.instance);
        return dummyArray.getShape();
    }

    public static Shape makeInitialStrictArgumentsShape(JSContext context, DynamicObject objectPrototype) {
        DynamicObject dummyArray = JSObject.createInit(JSObjectUtil.getProtoChildShape(objectPrototype, INSTANCE, context));
        JSArgumentsObject.putArrayProperties(dummyArray, ScriptArray.createConstantEmptyArray());
        JSObjectUtil.putHiddenProperty(dummyArray, CONNECTED_ARGUMENT_COUNT_PROPERTY, 0);
        Property lengthProperty = JSObjectUtil.makeDataProperty("length", dummyArray.getShape().allocator().locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.configurableNotEnumerableWritable());
        JSObjectUtil.putDataProperty(context, dummyArray, lengthProperty, (Object)0);
        JSArgumentsObject.putIteratorProperty(context, dummyArray);
        Accessor throwerAccessor = new Accessor(Undefined.instance, Undefined.instance);
        JSObjectUtil.putAccessorProperty(context, dummyArray, "callee", throwerAccessor, JSAttributes.notConfigurableNotEnumerable());
        if (context.getEcmaScriptVersion() < 8) {
            JSObjectUtil.putAccessorProperty(context, dummyArray, "caller", throwerAccessor, JSAttributes.notConfigurableNotEnumerable());
        }
        return dummyArray.getShape();
    }

    public static boolean isJSArgumentsObject(DynamicObject obj) {
        return JSArgumentsObject.isInstance(obj, (JSClass)INSTANCE) || JSArgumentsObject.isInstance(obj, (JSClass)JSSlowArgumentsObject.INSTANCE);
    }

    public static boolean isJSArgumentsObject(Object obj) {
        return JSArgumentsObject.isInstance(obj, (JSClass)INSTANCE) || JSArgumentsObject.isInstance(obj, (JSClass)JSSlowArgumentsObject.INSTANCE);
    }

    public static boolean isJSFastArgumentsObject(DynamicObject obj) {
        return JSArgumentsObject.isInstance(obj, (JSClass)INSTANCE);
    }

    public static boolean isJSFastArgumentsObject(Object obj) {
        return JSArgumentsObject.isInstance(obj, (JSClass)INSTANCE);
    }

    private static void putIteratorProperty(JSContext context, DynamicObject dummyArray) {
        Property iteratorProperty = JSObjectUtil.makeDataProperty(Symbol.SYMBOL_ITERATOR, dummyArray.getShape().allocator().locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.configurableNotEnumerableWritable());
        JSObjectUtil.putDataProperty(context, dummyArray, iteratorProperty, (Object)Undefined.instance);
    }
}

