/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsArrayNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@ImportStatic(value={JSGuards.class})
public abstract class IsArrayNode
extends JavaScriptBaseNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_JSCLASS_COUNT = 1;
    private final boolean onlyArray;
    private final boolean fastArray;
    private final boolean fastAndTypedArray;

    protected IsArrayNode(boolean onlyArray, boolean fastArray, boolean fastAndTypedArray) {
        this.onlyArray = onlyArray;
        this.fastArray = fastArray;
        this.fastAndTypedArray = fastAndTypedArray;
    }

    public abstract boolean execute(Object var1);

    @Specialization(guards={"cachedShape.check(object)"}, limit="MAX_SHAPE_COUNT")
    protected static boolean doIsArrayShape(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isArray(object)") boolean cachedResult) {
        return cachedResult && cachedShape.check(object);
    }

    @Specialization(replaces={"doIsArrayShape"}, guards={"cachedClass != null", "cachedClass.isInstance(object)"}, limit="MAX_JSCLASS_COUNT")
    protected static boolean doIsArrayJSClass(DynamicObject object, @Cached(value="isArray(object)") boolean cachedResult, @Cached(value="getJSClassChecked(object)") JSClass cachedClass) {
        return cachedResult;
    }

    @Specialization(replaces={"doIsArrayJSClass"})
    protected final boolean isArray(DynamicObject object) {
        if (this.fastAndTypedArray) {
            return JSArray.isJSFastArray(object) || JSArgumentsObject.isJSFastArgumentsObject(object) || JSArrayBufferView.isJSArrayBufferView(object);
        }
        if (this.fastArray) {
            return JSArray.isJSFastArray(object);
        }
        if (this.onlyArray) {
            return JSArray.isJSArray(object);
        }
        return JSObject.hasArray(object);
    }

    @Specialization(guards={"!isDynamicObject(object)"})
    protected static boolean isNotDynamicObject(Object object) {
        return false;
    }

    public static IsArrayNode createIsAnyArray() {
        return IsArrayNodeGen.create(false, false, false);
    }

    public static IsArrayNode createIsArray() {
        return IsArrayNodeGen.create(true, false, false);
    }

    public static IsArrayNode createIsFastArray() {
        return IsArrayNodeGen.create(true, true, false);
    }

    public static IsArrayNode createIsFastOrTypedArray() {
        return IsArrayNodeGen.create(true, true, true);
    }

    public static abstract class IsArrayWrappedNode
    extends JSUnaryNode {
        @Node.Child
        private IsArrayNode isArrayNode;

        protected IsArrayWrappedNode(JavaScriptNode operandNode, IsArrayNode isArrayNode) {
            super(operandNode);
            this.isArrayNode = isArrayNode;
        }

        @Specialization
        protected boolean doObject(Object operand) {
            return this.isArrayNode.execute(operand);
        }

        public static JavaScriptNode createIsArray(JavaScriptNode operand) {
            return IsArrayNodeGen.IsArrayWrappedNodeGen.create(operand, IsArrayNode.createIsArray());
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return IsArrayWrappedNode.createIsArray(IsArrayWrappedNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

