/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.surefire.common.junit4.MatchDescriptions;
import org.apache.maven.surefire.util.internal.ClassMethod;
import org.apache.maven.surefire.util.internal.TestClassMethodNameUtils;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;

public final class JUnit4ProviderUtil {
    private JUnit4ProviderUtil() {
        throw new IllegalStateException("Cannot instantiate.");
    }

    public static Set<Description> generateFailingTestDescriptions(List<Failure> allFailures) {
        HashSet<Description> failingTestDescriptions = new HashSet<Description>();
        for (Failure failure : allFailures) {
            Description description = failure.getDescription();
            if (!description.isTest() || JUnit4ProviderUtil.isFailureInsideJUnitItself(description)) continue;
            failingTestDescriptions.add(description);
        }
        return failingTestDescriptions;
    }

    public static boolean isFailureInsideJUnitItself(Description failure) {
        return Description.TEST_MECHANISM.equals((Object)failure);
    }

    public static ClassMethod toClassMethod(Description description) {
        String clazz = TestClassMethodNameUtils.extractClassName((String)description.getDisplayName());
        if (clazz == null || JUnit4ProviderUtil.isInsaneJunitNullString(clazz)) {
            Iterator it = description.getChildren().iterator();
            if (it.hasNext()) {
                description = (Description)it.next();
                clazz = TestClassMethodNameUtils.extractClassName((String)description.getDisplayName());
            }
            if (clazz == null) {
                clazz = "Test Instantiation Error";
            }
        }
        String method = TestClassMethodNameUtils.extractMethodName((String)description.getDisplayName());
        return new ClassMethod(clazz, method);
    }

    private static boolean isInsaneJunitNullString(String value) {
        return "null".equals(value);
    }

    public static Filter createMatchAnyDescriptionFilter(Iterable<Description> descriptions) {
        return new MatchDescriptions(descriptions);
    }
}

