import Postgres, unittest, struct, sys
UTTTR = unittest.TextTestRunner

class runner(UTTTR):
	def __init__(self, stream=Postgres.pgerr, descriptions=1, verbosity=2):
		UTTTR.__init__(self, stream, descriptions, verbosity)
	
	def run(self, test):
		write = self.stream.write
		writeln = self.stream.writeln
		result = self._makeResult()
		test(result)
		result.printErrors()

		if not result.wasSuccessful():
			write("FAILED (")
			failed = len(result.failures)
			errored = len(result.errors)
			if failed:
				fstr = "failures="+str(failed)
				if errored: fstr += ", "
				write(fstr)
			if errored:
				write("errors="+str(errored))
			writeln(")")

		return result
