<?php // $Id: maintenance-reports.php,v 1.2 2001/07/09 16:43:06 ciaccia Exp $ - #phpAdsNew Revision: 1.2 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Include required files
require	("../lib-reports.inc.php"); 



/*********************************************************/
/* Mail clients and check for activation  				 */
/* and expiration dates					 				 */
/*********************************************************/
/*                                                       */
/* Some extra info: The client interval is the number of */
/* days between reports and thus also the maximum number */
/* of day of statistics of this report. The report       */
/* last date is the date on which the last report was    */
/* generated. A report never included the current date   */
/* because the statistics are not completely collected   */
/* for the current day. The last date therefor must be   */
/* included in the statistics for today.                 */
/*                                                       */
/*********************************************************/

$res_clients = db_query("
	SELECT
		clientid,
		report,
		reportinterval,
		reportlastdate,
		UNIX_TIMESTAMP(reportlastdate) AS reportlastdate_t,
		(reportlastdate + (reportinterval || ' days')::interval) <= NOW() AS send_report,
		UNIX_TIMESTAMP(NOW()) AS now_t
	FROM
		$phpAds_tbl_clients
	WHERE
		parent = 0 AND report='t'
	");

for ($pgc = 0; $client = @pg_fetch_array($res_clients, $pgc); $pgc++)
{
	if ($client['send_report'] == 't')
	{
		// Determine first and last date
		$last_unixtimestamp   = $client['now_t'];
		$first_unixtimestamp  = $client['reportlastdate_t'];
		
		// Sent report
		$result = phpAds_SendMaintenanceReport ($client['clientid'], $first_unixtimestamp, $last_unixtimestamp, true);
		
		if ($result)
			echo "[id".$client['clientid']."] Statistics report sent!<br>";
	}
}

?>