/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/server/ReplicationRunnable.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2003/12/03 12:48:01 $
 *
 */

package com.postgres.replic.server;

import com.postgres.replic.server.props.ConnectionPoolProps;
import com.postgres.replic.server.props.ServerProps;
import com.postgres.util.jdbc.ConnectionPool;

public class ReplicationRunnable extends AbstractReplicationRunnable
		implements Runnable {

	public ReplicationRunnable(ServerProps serverProps,
							   ConnectionPoolProps connPoolProps,
							   ConnectionPool masterPool,
							   ConnectionPool slavePool) throws ReplicationException {
		super(serverProps, connPoolProps, masterPool, slavePool);
	}


	public void run() {
		try {
			getLogger().debug("ReplicationRunnable::run: BEGIN");
			getLogger().debug("ReplicationRunnable::run: BEGIN: sleep interval:" + getServerProps().getReplicIntervals()[getServerId()]);
			getLogger().debug("ReplicationRunnable::run: BEGIN: sleep interval: getSignal()" + getSignal());
			while (getSignal() != STOP)
				while (true && !(getSignal() == STOP)) {
					getRserv().replicate();
					getLogger().debug("ReplicationRunnable::run: BEGIN: inside the while loop");

					Thread.sleep(getServerProps().getReplicIntervals()
							[getServerId()]);
				}
		} catch (InterruptedException ie) {
			getLogger().error("ReplicationRunnable::run: InterruptedException: calling destroy");
			destroy();
		} catch (Exception e) {
			String slaveURL = null;
			try {
				slaveURL = getSlaveURL();
			} catch (Exception ex) {
				getLogger().error("ReplicationRunnable::run: cannot get slaveURL ", ex);
			}
			getLogger().error("ReplicationRunnable::run: STOPPING THREAD URL: " + slaveURL + " BECAUSE OF ERROR:" + e.toString());
		} finally {

		}
	}
}
