#!/bin/sh
#(c) copyright Barry Kauler 2004 www.puppylinux.org
#Puppy ethernet network setup script.
#I got some bits of code from:
# trivial-net-setup, by Seth David Schoen <schoen@linuxcare.com> (c)2002
# and the little executables and, or, dotquad from the
# lnx-bbx Linux project. ipcalc app from Redhat 7.
# Thanks to GuestToo and other guys on the Puppy Forum for bug finding.
# Rarsa (Raul Suarez) reorganized the code and cleaned up the user interface
## Ported to gtkdialog3 and abused by Dougal, June 2007
## Update: July 4th (redesign main dialog, change "Load module" dialog)
## Update: July 10th (change INTERFACEBUTTONS format, add findInterfaceInfo function)
## Update: July 11th (move findLoadedModules into tryLoadModule)
## Update: July 12th (move "save" and "unload" buttons out of main dialog)
## Update: July 13th (add "sleep 3" after loading usb modules, fixed bug in findInterfaceInfo)
## Update: July 13th (fix problem with tree height)
## Update: July 19th (add recognition of prism2_usb interfaces as wireless)
## Update: August 1st (fix spelling...)

# v2.21 BK updated 12 Sept 2007, updated 13 Sept 2007.

BIGGESTCNT=0 #v2.21 BK

CURDIR="`pwd`"
APPDIR="`dirname "$0"`"
cd "${APPDIR}"
APPDIR="`pwd`"
cd "${CURDIR}"

# Check if output should go to the console
if [ "${1}" == "-d" ] ; then
	DEBUG_OUTPUT=/dev/stdout
else
	DEBUG_OUTPUT=/dev/null
fi

## Dougal: put this into a variable
BLANK_IMAGE=/usr/share/pixmaps/net-setup_btnsize.png

#=============================================================================
#============= FUNCTIONS USED IN THE SCRIPT ==============
#=============================================================================
. ${APPDIR}/ndiswrapperGUI.sh
. ${APPDIR}/wag-profiles.sh

showMainWindow()
{
	MAIN_RESPONSE=""

	while true
	do

		buildMainWindow
		I=$IFS; IFS="" #v2.21 BK window size...
		WINHEIGHT=400
		WINWIDTH=540
		EXTRAHEIGHT=`echo "$INTERFACE_INTERFACE" | wc -l`
		WINHEIGHT=`expr $EXTRAHEIGHT \* 10 + $WINHEIGHT`
		if [ $BIGGESTCNT -gt 40 ];then
		 WIDTHEXTRA=`expr $BIGGESTCNT - 40`
		 WIDTHEXTRA=`expr $WIDTHEXTRA \* 8`
		 WINWIDTH=`expr $WINWIDTH + $WIDTHEXTRA`
		fi
		WINGEOM="${WINWIDTH}x${WINHEIGHT}"
		
		#BK: important gtkdialog v0.7.20 or later needed...
		for STATEMENTS in  $(gtkdialog3 --geometry=$WINGEOM --program Puppy_Network_Setup); do
			eval $STATEMENTS 2>/dev/null
		done
		IFS=$I
		unset Puppy_Network_Setup

		# Dougal: this is simpler than all the grep business.
		# Could integrate into main case-structure, but not sure about MAIN_RESPONSE
		case "$EXIT" in 
		  Interface_*) INTERFACE=${EXIT#Interface_} ; MAIN_RESPONSE=13 ;;
		  *) MAIN_RESPONSE=${EXIT} ;;
		esac
		
		# Dougal: blank the "Done" button, in case we go to 13 and back
		DONEBUTTON=""
			
		case $MAIN_RESPONSE in
			10) showLoadModuleWindow ;;
			17) saveNewModule ;;
			18) unloadNewModule ;;
			19) break ;;
			13) showConfigureInterfaceWindow ${INTERFACE} ;;
			66) AutoloadUSBmodules ;;
			#21) showHelp  ;;
			abort) break ;;
		esac

	done

} # end of showMainWindow


#=============================================================================
refreshMainWindowInfo ()
{
	# Dougal: comment out and move to the showLoadModuleWindow -- only used there...
	#findLoadedModules

  #we need to know what ethernet interfaces are there...
  INTERFACE_NUM=`ifconfig -a | grep -Fc 'Link encap:Ethernet'`
  INTERFACES="`ifconfig -a | grep -F 'Link encap:Ethernet' | cut -f1 -d' ' | tr '\n' ' '`"
  INTERFACEBUTTONS=""
  INTERFACE_DATA=""
  INTERFACE_INTERFACE="" #v2.21
  INTERFACE_INTTYPE="" #v2.21
  INTERFACE_FI_DRIVER="" #v2.21
  INTERFACE_BUS="" #v2.21
  INTERFACE_INFO="" #v2.21
  #rm -f /tmp/interface-modules

  for INTERFACE in ${INTERFACES}
  do
    [ "$INTERFACE" ] || continue
    # Dougal: use function for finding/setting info to be used in tree (below) 
    findInterfaceInfo $INTERFACE
    
    ## Dougal: use a tree to display interface info
    INTERFACE_DATA="$INTERFACE_DATA <item>$INTERFACE|$INTTYPE|$FI_DRIVER|$TYPE: $INFO</item>"
    #v2.21 BK...
    INTERFACE_INTERFACE="${INTERFACE_INTERFACE}${INTERFACE}
"
    INTERFACE_INTTYPE="${INTERFACE_INTTYPE}${INTTYPE}
"
    INTERFACE_FI_DRIVER="${INTERFACE_FI_DRIVER}${FI_DRIVER}
"
    INTERFACE_BUS="${INTERFACE_BUS}${TYPE}
"
    INTERFACE_INFO="${INTERFACE_INFO}${INFO}
"
    # add to display list
    INTERFACEBUTTONS="
${INTERFACEBUTTONS}
<vbox>
	<pixmap><input file>$BLANK_IMAGE</input></pixmap>
	<button>
		<label>${INTERFACE}</label>
		<action>EXIT:Interface_${INTERFACE}</action>
	</button>	
</vbox>"
  done

  if [ "$INTERFACE_DATA" ] ; then
    # Get the right height for the tree...
    case "$INTERFACE_NUM" in
     1) HEIGHT=65 ;;
     2) HEIGHT=100 ;;
     3) HEIGHT=125 ;;
     4) HEIGHT=150 ;;
     5) HEIGHT=175 ;;
     6) HEIGHT=200 ;;
    esac
    
    
#    <tree>
#    	<label>Interface|Type|Module|Device description</label>
#    	$INTERFACE_DATA
#    	<height>$HEIGHT</height><width>350</width>
#    	<variable>SELECTED_INTERFACE</variable>
#  	</tree>
    
    INTERFACEDESCRS="
    <hbox spacing=\"10\">
      <text use-markup=\"true\"><label>\"<b>インターフェース</b>
$INTERFACE_INTERFACE\"</label></text>
      <text use-markup=\"true\"><label>\"<b>タイプ</b>
$INTERFACE_INTTYPE\"</label></text>
      <text use-markup=\"true\"><label>\"<b>モジュール</b>
$INTERFACE_FI_DRIVER\"</label></text>
      <text use-markup=\"true\"><label>\"<b>バス</b>
$INTERFACE_BUS\"</label></text>
      <text use-markup=\"true\"><label>\"<b>説明</b>
$INTERFACE_INFO\"</label></text>
    </hbox>
"
    INTERFACEBUTTONS="
  	<hbox>
  		$INTERFACEBUTTONS
  	</hbox>"
  fi

  if [ $INTERFACE_NUM -eq 0 ];then
    echo "パピーは、アクティブなネットワークインターフェースが見えません。

あなたのPCに１つ以上のネットワークアダプタ（インターフェース）があってそれらを使いたいなら、ドライバ・モジュールをロードする必要があります。パピーが起動するときに自動的に検出され、正しいドライバーがロードされると思いますが、この場合はそうなりませんでした。でも大丈夫、手動でできます！" > /tmp/net-setup_MSGINTERFACES.txt

  fi
  if [ $INTERFACE_NUM -eq 1 ];then
    echo "パピーはコンピュータ内に次のネットワークインターフェースを見つけました、しかしまだ設定する必要があります。
テストや設定をするには、そのボタンをクリックして下さい。"  > /tmp/net-setup_MSGINTERFACES.txt
  fi
  if [ $INTERFACE_NUM -gt 1 ];then
    echo "パピーはコンピュータ内に次のネットワークインターフェースを見つけました、しかしまだ設定する必要があります。
インターフェースのテストや設定は、そのボタンをクリックして下さい。"  > /tmp/net-setup_MSGINTERFACES.txt
  fi

	#echo "Puppy has done a quick check to see which network driver modules are currently loaded. Here they are (the relevant interface is in brackets):
 #${LOADEDETH}" > /tmp/net-setup_MSGMODULES.txt

} # end refreshMainWindowInfo

#=============================================================================
buildMainWindow ()
{
	echo "${TOPMSG}" > /tmp/net-setup_TOPMSG.txt


	export Puppy_Network_Setup="<window title=\"Puppy Network Wizard\" icon-name=\"gtk-network\" window-position=\"1\">
<vbox>
	
	<text><label>\"
`cat /tmp/net-setup_TOPMSG.txt`
\"</label></text>
	
	<frame  Interfaces >
		<vbox>
			<text>
				<label>\"`cat /tmp/net-setup_MSGINTERFACES.txt`\"</label>
			</text>
			${INTERFACEDESCRS}
			${INTERFACEBUTTONS}
		</vbox>
	</frame>
	
	<frame  Network modules >
	  ${USB_MODULE_BUTTON}
	  ${MODULEBUTTONS}
	</frame>
	<hbox>
		<button help>
			<action>man 'net_setup' &> /dev/null & </action>
		</button>
		<button>
			 <label>終了</label>
			 <input file icon=\"gtk-quit\"></input>
			 <action>EXIT:19</action>
		</button>
	</hbox>
</vbox>
</window>"
}

#=============================================================================
showLoadModuleWindow()
{
	findLoadedModules
	echo -n "" > /tmp/ethmoduleyesload.txt
	MODULELIST=`cat /etc/networkmodules | sort | tr "\n" " "`
	# Dougal: create list of modules (pipe delimited)
sort /etc/networkmodules | tr '"' '|' | tr ':' '|' | sed 's%|$%%g' | tr -s ' ' >/tmp/module-list

 export LOAD_MODULE_DIALOG="<window title=\"ネットワークモジュールのロード\" icon-name=\"gtk-execute\" window-position=\"1\">
<vbox>
 <notebook labels=\"モジュールの選択|さらに\">
 <vbox>
  <pixmap><input file>$BLANK_IMAGE</input></pixmap>
  <hbox>
   <text><label>\"（まだロードされていなくて）ハードウェアに合うモジュールが以下にあれば、そのモジュールを選択して「ロード」ボタンを押して下さい。
モジュールがなかったり、自信がなかったら「さらに」タブへ行って下さい。\"</label></text>
   <text><label>\"     \"</label></text>
   <vbox>
    <pixmap><input file>$BLANK_IMAGE</input></pixmap>
    <button>
   	 <label>ロード</label>
	 <input file stock=\"gtk-apply\"></input>
	 <action>EXIT:load</action>
    </button>
   </vbox>
  </hbox>
  <pixmap><input file>$BLANK_IMAGE</input></pixmap>
  <tree>
    <label>モジュール|バス|説明</label>
    <input>cat /tmp/module-list</input>
    <height>200</height><width>550</width>
    <variable>NEW_MODULE</variable>
  </tree>
  
 </vbox>
 <vbox>
 <text><label>\"     \"</label></text>
 <hbox>
  <text use-markup=\"true\">
   <label>\"一覧にないモジュールを選択するには「<b>指定</b>」をクリックするか、パラメータを付けてモジュールを指定します（ISAカードには必須です、下の例をご覧下さい）。
Windowsドライバを使うには「 <b>Ndiswrapper</b>」 をクリック。
一覧の全モジュールをロードするには「 <b>自動検出</b> 」をクリック。

例１: ne io=0x000, 
例２: arlan  io=0x300 irq=11
（例１はほとんどのISAカードで動きます。IO と IRQ が自動検出されるカードもあります）\"</label>
  </text>
  <text>
   <label>\"     \"</label>
  </text>
  <vbox>
   <text>
    <label>\"     \"</label>
   </text>
   <button>
	<label>指定</label>
	<input file icon=\"gtk-index\"></input>
	<action>EXIT:specify</action>
   </button>
   <button>
	<label>Ndiswrapper</label>
	<input file icon=\"gtk-execute\"></input>
	<action>EXIT:ndiswrapper</action>
   </button>
   <button>
	<label>自動検出</label>
	<input file icon=\"gtk-refresh\"></input>
	<action>EXIT:auto</action>
   </button>
  </vbox>
  </hbox>
  </vbox>
  
  </notebook>
  <hbox>
   <button cancel></button>
  </hbox> 
 </vbox>
</window>"

  I=$IFS; IFS=""
  for STATEMENTS in  $(gtkdialog3 --program LOAD_MODULE_DIALOG); do
	eval $STATEMENTS 2>/dev/null
  done
  IFS=$I
  unset LOAD_MODULE_DIALOG
  
  case "$EXIT" in
    auto)	autoLoadModule ;;
    ndiswrapper)	loadNdiswrapperModule ;;
    specify)	loadSpecificModule ;;
    load)	if [ "$NEW_MODULE" ] ; then
    		  tryLoadModule ${NEW_MODULE} 
    		else
    		  TOPMSG="REPORT ON LOADING OF MODULE: No module was selected" 
    		fi ;;
    cancel) TOPMSG="REPORT ON LOADING OF MODULE: No module was loaded"  ;;
  esac

  NEWLOADED="`cat /tmp/ethmoduleyesload.txt`"
  NEWLOADf1=${NEWLOADED%% *} #remove any extra params.
  if [ "${NEWLOADED}" ];then
	##### add new code here: find new interface, then give window naming it
	##### and offering to save/unload
	##### ONLY AFTER that refresh main window   
	NEW_NUM=`ifconfig -a | grep -Fc "Link encap:Ethernet"`
	NEW_INTERFACES=""
	NEW_DATA=""
	NEW_INTERFACES_FRAME=""
	if [ $NEW_NUM -gt $INTERFACE_NUM ] ; then # got a new interface
	  let DIFF=NEW_NUM-INTERFACE_NUM
	  
	  for ANEW in `ifconfig -a | grep -F 'Link encap:Ethernet' |cut -f1 -d' '`
	  do 
	    case "$INTERFACES" in *$ANEW*) continue ;; esac
	    # If we got here, it's a new one
	    NEW_INTERFACES="$NEW_INTERFACES $ANEW"
	  done
	  
	  for ANEW in $NEW_INTERFACES
	  do
	    # get info for it
	    findInterfaceInfo $ANEW
	    # add to code for new interface dialog
	    NEW_DATA="$NEW_DATA <item>$ANEW|$INTTYPE|$FI_DRIVER|$TYPE: $INFO</item>"
	  done
	  # Set message telling about new interfaces
	  if [ $DIFF -eq 1 ] ; then
	    NEW_MESSAGE="The following new interface has been found"
	  else
	    NEW_MESSAGE="The following new interfaces have been found"
	  fi
	  # create the frame with the new interfaces
	  case "$DIFF" in
       1) HEIGHT=65 ;;
       2) HEIGHT=100 ;;
       3) HEIGHT=125 ;;
       4) HEIGHT=150 ;;
       5) HEIGHT=175 ;;
       6) HEIGHT=200 ;;
      esac
      NEW_INTERFACES_CODE="
  <frame  新しいインターフェース >
    <text><label>$NEW_MESSAGE</label></text>
    <tree>
    	<label>インターフェース|タイプ|モジュール|デバイスの説明</label>
    	$NEW_DATA
    	<height>$HEIGHT</height><width>400</width>
    	<variable>SELECTED_INTERFACE</variable>
  	</tree>
  </frame>
  
    <text>
      <label>\"選択を保存するには「保存」ボタンをクリック、これでパピーは起動時に $NEWLOADf1 を自動的にロードします。
新しいインターフェースの設定に戻るには「Cancel」を押して下さい。\"</label>
    </text>
    <hbox>
	  
	  <button>
		<label>保存</label>
		<input file icon=\"gtk-save\"></input>
		<action>EXIT:save</action>
	  </button>
    
  "
	
	else
	  NEW_INTERFACES_CODE="
  <text><label>新しいインターフェースは検出されませんでした。</label></text>
  <text><label>\" \"</label></text>
  
    <text>
      <label>\"新しいモジュールをロードしなくて、違うモジュールのロードを試すには「ロードしない」ボタンをクリックして下さい。\"</label>
    </text>    
    <hbox>
	  <button>
	    <label>ロードしない</label>
	    <input file stock=\"gtk-undo\"></input>
	    <action>EXIT:unload</action>
	  </button>
    "
	fi #if [ $NEW_NUM -gt $INTERFACE_NUM ] 
	# give dialog with two buttons and appropriate message
	export NEW_MODULE_DIALOG="<window title=\"新しくロードされたモジュール\" icon-name=\"gtk-execute\" window-position=\"1\">
<vbox>
  <pixmap><input file>$BLANK_IMAGE</input></pixmap>
  <text><label>次の新しいモジュールがロードされました: $NEWLOADf1</label></text>
  <pixmap><input file>$BLANK_IMAGE</input></pixmap>
  $NEW_INTERFACES_CODE
  
   <button cancel></button>
  </hbox> 
</vbox>
</window>"
	
	# Run new dialog
	I=$IFS; IFS=""
    for STATEMENTS in  $(gtkdialog3 --program NEW_MODULE_DIALOG); do
	  eval $STATEMENTS 2>/dev/null
    done
    IFS=$I
    unset NEW_MODULE_DIALOG
    
    # Do what we're asked
    case "$EXIT" in
     save) 
       saveNewModule 
       TOPMSG="New module information saved"
       ;;
     unload) 
       unloadNewModule 
       TOPMSG="New module unloaded"
       ;;
     *) TOPMSG="Cancelled"
       ;;
    esac
	
	# refresh main
	refreshMainWindowInfo
	# set new message for main dialog
	#TOPMSG="REPORT ON LOADING OF MODULE: Module '$NEWLOADf1' successfully loaded"
	
    else
      BGCOLOR="#ffc0c0"
      TOPMSG="モジュールのロード報告: モジュールはロードされていません"
    fi
} # end of showLoadModuleWindow

#=============================================================================
tryLoadModule ()
{
	MODULE_NAME="$1"
	if grep -q "$MODULE_NAME" /tmp/loadedeth.txt ; then
		Xdialog --screen-center --title "Puppy Network Wizard: hardware" \
		        --msgbox "ドライバはすでにロードされています。\nでも実際に正常に動いていると言う事ではありません！\n「OK」をクリック後、新しいインターフェースが検出されたかどうか\n確認して下さい。" 0 0
		echo -n "${MODULE_NAME}" > /tmp/ethmoduleyesload.txt
		return 0
	else
		if modprobe ${MODULE_NAME}
		then
			echo -n "${MODULE_NAME}" > /tmp/ethmoduleyesload.txt
			case "$NETWORK_MODULES" in *" $MODULE_NAME "*) ;;
			 *) echo "${MODULE_NAME}" >> /etc/networkusermodules ;;
			esac
			Xdialog --left --wrap --stdout --title "Puppy Network Wizard: hardware" --msgbox "モジュール ${MODULE_NAME} のロードは成功しました。\nでも実際に正常に動いていると言う事ではありません！\n「OK」をクリック後、新しいインターフェースが検出されたかどうか\n確認して下さい。" 0 0
			return 0
		else
			Xdialog --stdout --msgbox "「 ${MODULE_NAME} 」のロードに失敗しました。別のドライバを試して下さい。" 0 0
			return 1
		fi
	fi
} # end tryLoadModule

#=============================================================================
loadNdiswrapperModule ()
{
	showNdiswrapperGUI
	if [ $? -eq 0 ] ; then
	    ndiswrapper -m
		tryLoadModule "ndiswrapper"
	fi
} # end loadNdiswrapperModule

#=============================================================================
loadSpecificModule ()
{
	RESPONSE=$(Xdialog --stdout --title "Puppy Network Wizard: hardware" --inputbox "ロードする指定のモジュール名を入力して下さい。\n(特別なパラメータは使えますがタブ文字は入力しないで下さい)" 0 0 "" 2> /dev/null)
	if [ $? -eq 0 ];then
		tryLoadModule "${RESPONSE}"
	fi
} # end loadSpecificModule

#=============================================================================
autoLoadModule ()
{
	#this is the autoloading...
	SOMETHINGWORKED=false
	#clear
	for CANDIDATE in $NETWORK_MODULES
	do

		#if have pcmcia, do not try loading the others...
		MDOIT="no"
		case "$CANDIDATE" in 
		 *_cs*)	[ "$MPCMCIA" = "yes" ] && MDOIT="yes" ;;
		 *)		[ "$MPCMCIA" = "yes" ] || MDOIT="yes" ;;
		esac
		
		#also, do not try if it is already loaded...?
		grep -q "$CANDIDATE" /tmp/loadedeth.txt && MDOIT="no"

		#in case of false-hits, ignore anything already tried this session...
		grep -q "$CANDIDATE" /tmp/logethtries.txt && MDOIT="no"

		if [ "$MDOIT" = "yes" ];then
			echo; echo "*** Trying $CANDIDATE."
			if modprobe $CANDIDATE
			then
				SOMETHINGWORKED=true
				WHATWORKED=$CANDIDATE
				#add it to the log for this session...
				echo "$CANDIDATE" >> /tmp/logethtries.txt
				break
			fi
		fi

	done
	sleep 2
	if $SOMETHINGWORKED
	then
		Xdialog --left --wrap --msgbox "モジュール「 $WHATWORKED 」のロードに成功しました。でも実際に正常に動いていると言う事ではありません！\n「OK」をクリック後、新しいアクティブなインターフェースが見つかったらメインウィンドウに戻って\n設定を続けて下さい。\n\n注釈: モジュールがOKでロードしても、誤って検出する事もあります。というのは、\nあなたのネットワークアダプタと実際に連動しないのです。その場合は、もう一度自動検出を試して下さい。\nこのスクリプトは前回の試行を覚えています。（あなたがこのスクリプトを終了するまで）\nそしてそれを飛び越える事もできます。\nもし誤った検出をしたらPuppy Discussion Forumにその事を知らせて下さい！" 0 0
		echo -n "$WHATWORKED" > /tmp/ethmoduleyesload.txt
	else
		MALREADY="`cat /tmp/loadedeth.txt`"
		Xdialog --msgbox "モジュールは何もロードされませんでした。\n\n注釈: けれども以下のモジュールはすでにロードされています。:\n${MALREADY}" 0 0
		return 1
	fi
} # end autoLoadModule

#=============================================================================
findLoadedModules ()
{
  echo -n " " > /tmp/loadedeth.txt

	LOADED_MODULES="$(lsmod | cut -f1 -d' ' | sort)"
	NETWORK_MODULES=" $(cat /etc/networkmodules /etc/networkusermodules  2> ${DEBUG_OUTPUT} | cut -f1 -d' ' | tr '\n' ' ') "

  COUNT_MOD=0
  for MOD in $LOADED_MODULES
  do	let COUNT_MOD=COUNT_MOD+1
  done

  (
		for AMOD in $LOADED_MODULES
		do
			echo "X"
			# Dougal: use a case structure for globbing
			# Also try and retain original module names (removed "tr '-' '_')
			case "$NETWORK_MODULES" in 
			 *" $AMOD "*)
			   echo "$AMOD" >> /tmp/loadedeth.txt
			   echo -n " " >> /tmp/loadedeth.txt #space separation
			   ;;
			 *" ${AMOD/_/-} "*) # kernel shows module with underscore...
			  echo "${AMOD/_/-}" >> /tmp/loadedeth.txt
			  echo -n " " >> /tmp/loadedeth.txt #space separation
			  ;;
			esac
		done
  ) | Xdialog --title "Puppy Network Wizard" --progress "ロードされたモジュールをチェックしています" 0 0 $COUNT_MOD

} # end of findLoadedModules

#=============================================================================
testInterface()
{
  INTERFACE=$1

	(
		UNPLUGGED="false"
		ifconfig $INTERFACE | grep " UP " &> ${DEBUG_OUTPUT}
		if [ ! $? -eq 0 ];then #=0 if found
			ifconfig $INTERFACE up
		fi
		#BK1.0.7 improved link-beat detection...
		echo "X"
		if ! ifplugstatus ${INTERFACE} | grep -F -q 'link beat detected' ;then
		  sleep 2
		  echo "X"
		  if ! ifplugstatus-0.25 ${INTERFACE} | grep -F -q 'link beat detected' ;then
			sleep 2
			echo "X"
			if ! ifplugstatus ${INTERFACE} | grep -F -q 'link beat detected' ;then
			  sleep 2
			  echo "X"
			  if ! ifplugstatus-0.25 ${INTERFACE} | grep -F -q 'link beat detected' ;then
			    UNPLUGGED="true"
			  fi
			fi
		  fi
		fi
		echo "${UNPLUGGED}" > /tmp/net-setup_UNPLUGGED.txt
  ) | Xdialog --title "Puppy Network Wizard" --progress "インターフェース「 ${INTERFACE} 」をテストしています" 0 0 4

  UNPLUGGED=$(cat /tmp/net-setup_UNPLUGGED.txt)

  if [ "$UNPLUGGED" != "false" ];then #BK1.0.7
    #no cable plugged in, no network connection possible...
    ifconfig $INTERFACE down
    BGCOLOR="#ffc0c0"
    if [ "${IS_WIRELESS}" ] ; then
      TOPMSG="「 $INTERFACE 」接続テストの報告:
'ワイヤレスネットワークに接続できませんでした'

ワイヤレスネットワークが利用できるかどうか、
そして正しいワイヤレスパラメータが提供されているか確認して下さい。"
    else
      TOPMSG="「 $INTERFACE 」接続テストの報告:
'ネットワークに接続できませんでした'

ネットワークが利用できるか、そしてイーサネット
ケーブルが接続されているか確認して下さい。"
    RETTEST=1
    fi
  else
    BGCOLOR="#e0ffe0"
    TOPMSG="「 $INTERFACE 」接続テストの報告:
'パピーは活動中のネットワークを見つけました'

続行してIPアドレスを取得できます。"
		RETTEST=0
  fi

  return ${RETTEST}
} # end of testInterface

#=============================================================================
showConfigureInterfaceWindow()
{
  INTERFACE=$1

  initializeConfigureInterfaceWindow

  RETVALUE=""
  # 1=Close window 19=Back Button 22=Save configuration
   while true
  do

    buildConfigureInterfaceWindow

    I=$IFS; IFS=""
    for STATEMENTS in  $(gtkdialog3 --program Puppy_Network_Setup); do
      eval $STATEMENTS
    done
    IFS=$I
    unset Puppy_Network_Setup

    RETVALUE=${EXIT}
    [ "${RETVALUE}" = "abort" ] && RETVALUE=1

    RETSETUP=99
    case $RETVALUE in
       1 | 19) # close window
        #v2.21 BK...
        LASTTOPMSGA="「 $INTERFACE 」のネットワーク設定は成功しました"
        LASTTOPMSGB="設定はファイルに保存されました"
        if [ "`echo "$TOPMSG" | grep "$LASTTOPMSGB"`" = "" ];then
         TOPMSG="「 $INTERFACE 」のネットワーク設定はキャンセルされました！"
        else
         TOPMSG="「 $INTERFACE 」のネットワーク設定は完了しました"
        fi
       
		  break
          ;;
      66) # Dougal: add "Done" button to exit (there was a wrong message) 
          exit
          ;;
      10) # AutoDHCP
          setupDHCP
          RETSETUP=$?
          ;;
      11) # StaticIP
          showStaticIPWindow
          RETSETUP=$?
          ;;
      13) # Test
          testInterface ${INTERFACE}
          RETSETUP=$?
          ;;
      14) # Wireless
          configureWireless ${INTERFACE}
          ;;
      #21) # Help
          #showHelp
          #;;
      22) # Save configuration
          break
          ;;
    esac
	
	# Dougal: define the "Done" button here, so it doesn't appear the first time around...
	DONEBUTTON="<button>
					<label>終了</label>
					<input file stock=\"gtk-apply\"></input>
					<action>EXIT:66</action>
				</button>"
	
    if [ $RETVALUE -eq 10 ] || [ $RETVALUE -eq 11 ] ; then
      if [ $RETSETUP -ne 0 ] ; then
        TOPMSG="「 $INTERFACE 」のネットワーク設定は不成功です！
再試行します。別のインターフェースを試すには「戻る」をクリック、今の所はあきらめるなら「終了」をクリックして下さい。"
      else
        RETVALUE=1
        Xdialog --yesno "「 $INTERFACE 」のネットワーク設定に成功しました！

この設定を保存しますか？

次回の起動用にこの設定を保存したいなら: 「Yes」をクリック。
このセッション用にこの設定を使いたいだけなら: 「No」をクリック。" 0 0
		if [ $? -eq 0 ] ; then
          saveInterfaceSetup ${INTERFACE}
          TOPMSG="「 $INTERFACE 」のネットワーク設定に成功しました！
設定は、 /etc/${INTERFACE}mode ファイルに保存されます。
このファイルは起動時に /etc/rc.d/rc.network によって読み込まれます。

これ以上、設定をするインターフェースがなければ、「終了」をクリックして出て下さい。"
        else
          TOPMSG="「 $INTERFACE 」のネットワーク設定に成功しました！
設定は、次回の起動用に保存されませんでした。

これ以上、設定をするインターフェースがなければ、「終了」をクリックして出て下さい。"
        fi
      fi
    fi

  done

} # end showConfigureInterfaceWindow

#=============================================================================
buildConfigureInterfaceWindow ()
{
	export Puppy_Network_Setup="<window title=\"Configure network interface ${INTERFACE}\" icon-name=\"gtk-network\" window-position=\"1\">
<vbox>
	<pixmap><input file>$BLANK_IMAGE</input></pixmap>
	<text><label>\"${TOPMSG}\"</label></text>
	${WIRELESSSECTION}
	<frame  Test interface >
		<hbox>
			<text><label>\"${TESTMSG}\"</label></text>
			<vbox>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
				<button>
					<label>Test ${INTERFACE}</label>
					<action>EXIT:13</action>
				</button>
			</vbox>
		</hbox>
	</frame>
	<frame  Configure interface >
		<hbox>
			<text><label>\"${DHCPMSG}\"</label></text>
			<vbox>
				<text><label>\" \"</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
				<button>
					<label>Auto DHCP</label>
					<action>EXIT:10</action>
				</button>
			</vbox>
		</hbox>
		<pixmap><input file>$BLANK_IMAGE</input></pixmap>
		<hbox>
			<text><label>\"${STATICMSG}\"</label></text>
			<vbox>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
				<button>
					<label>Static IP</label>
					<action>EXIT:11</action>
				</button>
			</vbox>
		</hbox>
	</frame>
	<hbox>
		$DONEBUTTON
		<button help>
			<action>man 'net_setup' &> /dev/null & </action>
		</button>
		${SAVE_SETUP_BUTTON}
		<button>
			<label>戻る</label>
			<input file stock=\"gtk-go-back\"></input>
			<action>EXIT:19</action>
		</button>
	</hbox>
</vbox>
</window>"
}

#=============================================================================
initializeConfigureInterfaceWindow ()
{
	TOPMSG="オーケー、 ${INTERFACE} の設定にトライしましょう。"

	TESTMSG="インターフェース ${INTERFACE} が「生きている」ネットワークにつながっているか確認して下さい。
確認後、インターフェースの設定ができます。"

	DHCPMSG="ネットワークを構築する一番簡単な方法は（ネットワークで通常提供されている）DHPCサーバを使う事です。これで、パピーが起動時にサーバに問い合わせ、自動的にIPアドレスが割り当てられるようになります。「dhcpd」というクライアント・デーモン・プログラムが立ち上がり、ネットワークへのアクセスが自動的に起こります。"

	STATICMSG="DHCPサーバが利用できない時は、固定IPを設定して全部手動でやらなければなりません。でもこのスクリプトが設定を簡単にしてくれます。"

	checkIfIsWireless ${INTERFACE}

	if [ "$IS_WIRELESS" ] ; then
		WIRELESSSECTION="<frame  Configure wireless network >
<hbox>
	<text><label>\"パピーはワイヤレス・インターフェース「 ${INTERFACE} 」を検出しました。
ワイヤレスネットワークに接続するには、最初に「ワイアレス」ボタンをクリックして、ワイアレスネットワークパラメータを設定し、その後DHCPか固定IPでIPアドレスを割り当てます（下をご覧下さい）。\"</label></text>
	<vbox>
		<text><label>\" \"</label></text>
		<pixmap><input file>$BLANK_IMAGE</input></pixmap>
		<button>
			<label>ワイアレス</label>
			<action>EXIT:14</action>
		</button>
	</vbox>
</hbox>
</frame>"
	else
		WIRELESSSECTION=""
	fi
	SAVE_SETUP_BUTTON=""
}

#=============================================================================
checkIfIsWireless ()
{
  INTERFACE=$1
  IS_WIRELESS=""
  INTMODULE=`readlink /sys/class/net/$INTERFACE/device/driver`
  INTMODULE=${INTMODULE##*/}

  if grep -q "${INTERFACE}" /proc/net/wireless || [ "$INTMODULE" = "prism2_usb" ] ; then
    IS_WIRELESS="true"
  fi
}

#=============================================================================
configureWireless()
{
	INTERFACE=$1
	showProfilesWindow ${INTERFACE}
	if [ $? -eq 0 ] ; then
		testInterface ${INTERFACE}
	else
		TOPMSG="「 $INTERFACE 」のワイアレス設定はキャンセルされました！
ワイアレス・ネットワークに接続するには、使用するプロファイルを選択しなければなりません。"
	fi
}

#=============================================================================
setupDHCP()
{
	{
		# Must kill old dhcpcd first
		dhcpcd -k "$INTERFACE"
		rm /etc/dhcpc/dhcpcd-${INTERFACE}.* &>/dev/null #if left over from last session, causes trouble.
		sleep 5
		if dhcpcd -d "$INTERFACE"
		then
			HAS_ERROR=0
		else
			HAS_ERROR=1
		fi
		echo "${HAS_ERROR}" > /tmp/net-setup_HAS_ERROR.txt
		echo "XXXX"
	} | Xdialog --no-buttons --title "Puppy Network Wizard: DHCP" --infobox "パピーがDHCPサーバから応答を待つ間、最高で60秒まで遅れがあります。
気長に待って下さい..." 0 0 0

  HAS_ERROR=$(cat /tmp/net-setup_HAS_ERROR.txt)

  if [ ${HAS_ERROR} -eq 0 ]
  then
    MODECOMMANDS="
echo \"Trying to get IP address from DHCP server (60sec timeout)...\"
echo \"Trying to get IP address from DHCP server (60sec timeout)...\" > /dev/console
rm /etc/dhcpc/dhcpcd-${INTERFACE}.pid 2>/dev/null #if left over from last session, causes trouble.
rm /etc/dhcpc/dhcpcd-${INTERFACE}.cache 2>/dev/null #ditto
rm /etc/dhcpc/dhcpcd-${INTERFACE}.info 2>/dev/null #ditto
dhcpcd ${INTERFACE}
"
  else
    MODECOMMANDS=""
  fi

	return ${HAS_ERROR}
} #end of setupDHCP

#=============================================================================
showStaticIPWindow()
{
	IP_ADDRESS="`ifconfig ${INTERFACE} | grep 'inet addr' | sed 's/.*inet addr://' | cut -d" " -f1`"
	NETMASK="`ifconfig ${INTERFACE} | grep 'inet addr' | sed 's/.*Mask://'`"
	GATEWAY="`iproute | grep default | cut -d" " -f3`"
	DNS_SERVER1="`grep nameserver /etc/resolv.conf | head -n1 | cut -d" " -f2`"
	DNS_SERVER2="`grep nameserver /etc/resolv.conf | tail -n1 | cut -d" " -f2`"
	
	EXIT=""
	while true
	do

		buildStaticIPWindow
		I=$IFS; IFS=""
		for STATEMENTS in  $(gtkdialog3 --program Puppy_Network_Setup); do
			eval $STATEMENTS
		done
		IFS=$I
		unset Puppy_Network_Setup

		case "$EXIT" in
			abort|Cancel) # close window
				break
				;; # Do Nothing, It will exit without doing anything
			#"21" ) # Help
				#showHelp
				#;;
			"OK" ) # OK
				validateStaticIP
				if [ $? -eq 0 ] ; then
					setupStaticIP
					[ $? -ne 0 ] && EXIT=""
				else
					EXIT=""
				fi
				break
				;;
		esac
	done
	
	if [ "${EXIT}" = "OK" ] ; then
		return 0
	else
		return 1
	fi
}

#=============================================================================
buildStaticIPWindow()
{
	[ -z "$IP_ADDRESS" ] && IP_ADDRESS="0.0.0.0"
	[ -z "$NETMASK" ] && NETMASK="255.255.255.0"
	[ -z "$GATEWAY" ] && GATEWAY="0.0.0.0"
	[ -z "$DNS_SERVER1" ] && DNS_SERVER1="0.0.0.0"
	[ -z "$DNS_SERVER2" ] && DNS_SERVER2="0.0.0.0"

	export Puppy_Network_Setup="<window title=\"固定IPの設定\" icon-name=\"gtk-network\" window-position=\"1\">
<vbox>
	<text><label>\"固定IPパラメータを入力して下さい：
- もしルータを使っていれば、そのルータの状態ページを
チェックしてその値を得て下さい。 
- もしモデムで直接接続していれば、その値を
利用しているISPから得る必要があります。

全てのアドレスは、ドットで区切った10進法(xxx.xxx.xxx.xxx)
で入力して下さい。
他のフォーマットは承認されません。
\"</label></text>
	<frame  Static IP parameters >
		<hbox>
			<vbox>
				<text><label>IP address:</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			</vbox>
			<entry>
				<variable>IP_ADDRESS</variable>
				<default>${IP_ADDRESS}</default>
			</entry>
		</hbox>
		<hbox>
			<vbox>
				<text><label>Net Mask:</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			</vbox>
			<entry>
				<variable>NETMASK</variable>
				<default>${NETMASK}</default>
			</entry>
		</hbox>
		<hbox>
			<vbox>
				<text><label>Gateway:</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			</vbox>
			<entry>
				<variable>GATEWAY</variable>
				<default>${GATEWAY}</default>
			</entry>
		</hbox>
	</frame>
	<frame  DNS parameters >
		<hbox>
			<vbox>
				<text><label>Primary:</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			</vbox>
			<entry>
				<variable>DNS_SERVER1</variable>
				<default>${DNS_SERVER1}</default>
			</entry>
		</hbox>
		<hbox>
			<vbox>
				<text><label>Secondary:</label></text>
				<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			</vbox>
			<entry>
				<variable>DNS_SERVER2</variable>
				<default>${DNS_SERVER2}</default>
			</entry>
		</hbox>
	</frame>
	<hbox>
		<button help>
			<action>man 'net_setup' &> /dev/null & </action>
		</button>
		<button ok></button>
		<button cancel></button>
	</hbox>
</vbox>
</window>"
}

#=============================================================================
validateStaticIP()
{
	ERROR_MSG=""
	if ! validip "${IP_ADDRESS}" ; then
		ERROR_MSG="${ERROR_MSG}\n- 無効なIPアドレスです"
	fi
	if ! validip "${NETMASK}" ; then
		ERROR_MSG="${ERROR_MSG}\n- 無効なネットマスクです"
	fi
	if [ ! -z "$GATEWAY" ] ; then
		if ! validip "${GATEWAY}"  ; then
			ERROR_MSG="${ERROR_MSG}\n- 無効なゲートウェイアドレスです"
		fi
	fi
	if ! validip "${DNS_SERVER1}"  ; then
		ERROR_MSG="${ERROR_MSG}\n- 無効なDNSサーバ1のアドレスです"
	fi
	if ! validip "${DNS_SERVER2}"  ; then
		ERROR_MSG="${ERROR_MSG}\n- 無効なDNSサーバ2のアドレスです"
	fi
	
	if [ "x${ERROR_MSG}" != "x" ] ; then
	  Xdialog --left --title "Puppy Network Wizard: Static IP" \
	  				--msgbox "与えられたいくつかのアドレスが無効です\n${ERROR_MSG}" 0 0
	  return 1
	fi	

  DEFAULTMASK=$(ipcalc --netmask "${IP_ADDRESS}" | cut -d= -f2)
  
  if [ "x${NETMASK}" != "x${DEFAULTMASK}" ] ; then
	  Xdialog --center --title "Puppy Network Wizard: Static IP" \
	  				--yesno "警告:\nあなたのネットマスクはあなたのネットワークアドレスクラスと一致しません。\n\n正しいか確認しますか？" 0 0
	  if [ $? -eq 1 ] ; then
	  	return 1
	  fi
  fi

	# Check that network is right
	if [ -z "$GATEWAY" ];then
		# It is legitimate not to have a gateway at all.  In that case, it
		# doesn't have a network. :-)
		unset HOSTNET
		unset GATENET
  else
		HOSTNUM=$(dotquad "$IP_ADDRESS") 
		MASKNUM=$(dotquad "$NETMASK")
		GATENUM=$(dotquad "$GATEWAY")
		HOSTNET=$(and "$MASKNUM" "$HOSTNUM")
		GATENET=$(and "$MASKNUM" "$GATENUM")
 fi

	if [ "x${HOSTNET}" != "x${GATENET}" ] ; then
  	Xdialog --center --wrap --title "Puppy Network Wizard: Static IP" \
  					--msgbox "あなたのゲートウェイ「 $GATEWAY 」はこのネットワーク上にありません！再試行して下さい。\n（アドレス、ゲートウェイ、ネットマスクを間違って入れたのかも知れません。）" 0 0  0 0
  	return 1
	fi
	
	return 0
} #end of staticIPSetup

#=============================================================================
setupStaticIP()
{
	BROADCAST=$(ipcalc -b ${IP_ADDRESS} ${NETMASK} | cut -d= -f2)

	ifconfig ${INTERFACE} down

	CONVO="ifconfig ${INTERFACE} ${IP_ADDRESS} netmask ${NETMASK} broadcast ${BROADCAST} up"
	CONVG="route add -net default gw ${GATEWAY}"

  # do the work
  ifconfig ${INTERFACE} ${IP_ADDRESS} netmask ${NETMASK} broadcast ${BROADCAST} up
  
  if [ $? -eq 0 ];then
		MODECOMMANDS="${CONVO}"
		# Configure a nameserver, if we're supposed to.
		# This now replaces any existing resolv.conf, which
		# we will try to back up.
		if [ "${DNS_SERVER1}" != "0.0.0.0" ] ; then
			mv -f /etc/resolv.conf /etc/resolv.conf.$$
			echo "nameserver ${DNS_SERVER1}" > /etc/resolv.conf
			if [ "${DNS_SERVER2}" != "0.0.0.0" ] ; then
				echo "nameserver ${DNS_SERVER2}" >> /etc/resolv.conf
			fi
		fi

   # add default route, if we're supposed to
		if [ "$GATEWAY" ] ; then
			route add -net default gw "$GATEWAY"
			if [ $? -eq 0 ];then #0=ok.
				Xdialog --center --title "Puppy Network Wizard: Static IP" --msgbox "「 $GATEWAY 」を通してデフォルトのルートをセットします。" 0 0
				MODECOMMANDS="${MODECOMMANDS}\n${CONVG}"
			else
				Xdialog --center --title "Puppy Network Wizard: Static IP" --msgbox "「 $GATEWAY 」を通してデフォルトのルートをセットできません。再試行して下さい。\n\n注釈 Puppyはこれを試してみました:\n${CONVG}" 0 0
				ifconfig "$INTERFACE" down
				return 1
			fi
		fi

  	return 0
  else
		Xdialog --center --title "Puppy Network Wizard: Static IP" --msgbox "インターフェースの設定に失敗しました。再試行して下さい。\n\nPuppyが今、再試行したのはこれです:\n${CONVO} \n\nもしこれがあなたのシステムに間違っていると思い,何か他の機能するものを\n考え出したら、私に知らせて下さい。おそらく私はこのネットワーク設定\nスクリプトを修正できます。" 0 0
		ifconfig "$INTERFACE" down
		MODECOMMANDS=""
		return 1
	fi
} #end of setupStaticIP

#=============================================================================
saveNewModule()
{
  # save newly loaded module
  if ! grep "$NEWLOADED" /etc/ethernetmodules ;then
    echo "$NEWLOADED" >> /etc/ethernetmodules
  fi
  TOPMSG="モジュール「 '$NEWLOADED' 」は /etc/ethernetmodules に記録されました。
パピーは起動時にこのファイルを読みます。"
	setDefaultMODULEBUTTONS
}


#=============================================================================
unloadNewModule()
{
  # unload newly loaded module
  modprobe -r $NEWLOADED
  grep -v "$NEWLOADED" /etc/ethernetmodules > /etc/ethernetmodules.tmp
  sync
  mv -f /etc/ethernetmodules.tmp /etc/ethernetmodules
  TOPMSG="MODULE '$NEWLOADED' UNLOADED.
Also, '$NEWLOADED' removed from /etc/ethernetmodules (if it was there)."

  setDefaultMODULEBUTTONS

	refreshMainWindowInfo

}

#=============================================================================
validip() {
# uses dotquad.c to parse $1 as a dotted-quad IP address
if dotquad "$1" &> /dev/null
then
 return 0
else
 return 1
fi
} #end of validip function

#=============================================================================
setDefaultMODULEBUTTONS ()
{
  MODULEBUTTONS="
<hbox>
	<text>
		<label>\"もしネットワーク・アダプタのドライバ・モジュールがロードされていないように見えるなら、「モジュールのロード」ボタンをクリックして下さい。\"</label>
	</text>
	<vbox>
		<pixmap><input file>$BLANK_IMAGE</input></pixmap>
		<button>
			<label>モジュールのロード</label>
			<action>EXIT:10</action>
		</button>
	</vbox>
</hbox>"
}

#=============================================================================
# Dougal: created this, so can give an option to autoload usb modules
setDefaultUSB_MODULE_BUTTON()
{
  USB_MODULE_BUTTON="
  	<hbox>
		<text>
			<label>\"起動後にUSBネットワークデバイスを接続すると、適切なモジュールはたぶんロードされません。
「USBの自動ロード」を押して、そのデバイス用モジュールの自動ロードを試して下さい。\"</label>
		</text>
		<vbox>
			<pixmap><input file>$BLANK_IMAGE</input></pixmap>
			<button>
				<label>USBの自動ロード</label>
				<action>EXIT:66</action>
			</button>
		</vbox>
	</hbox>"
}

#=============================================================================
# Dougal: run the script autoloading usb modules
AutoloadUSBmodules()
{
 NEWMODULES=""
 # Run the script

 #load-usb-modules.sh	v2.21 Bk...
[ -s /tmp/new-usb-modules ] && rm -f /tmp/new-usb-modules
KERNELVER="`uname -r`"
. /etc/rc.d/MODULESCONFIG
USBMODINFO="`cat /lib/modules/modules.usbmap.$KERNELVER | tr -s " " | cut -f 1,3,4 -d " " | tr [A-Z] [a-z]`"
#...returns module-name vendor-id product-id
USBNUMS="`cat /proc/bus/usb/devices | grep '^P: ' | tr -s ' ' | cut -f 2-3 -d ' ' | tr ' ' '|' | tr [A-Z] [a-z] | tr '\n' ' '`"
for ONENUM in $USBNUMS
do
 VENDOR="`echo -n "$ONENUM" | cut -f 1 -d '|' | cut -f 2 -d '='`"
 PRODUCT="`echo -n "$ONENUM" | cut -f 2 -d '|' | cut -f 2 -d '='`"
 ONEUSB="0x${VENDOR} 0x${PRODUCT}"
 [ "$ONEUSB" = "0x0000 0x0000" ] && continue
 USBMODULE="`echo "$USBMODINFO" | grep "$ONEUSB" | cut -f 1 -d ' ' | head -n 1`"
 #pickup cases where more than one module has same IDs...
 USBMODULE2="`echo "$USBMODINFO" | grep "$ONEUSB" | cut -f 1 -d ' ' | tail -n 1`"
 if [ "$USBMODULE" != "" ];then
  #skip some modules... SKIPLIST is in /etc/rc.d/MODULESCONFIG
  SKIPPATTERN=" $USBMODULE "
  [ "`echo -n "$SKIPLIST" | grep "$SKIPPATTERN"`" != "" ] && continue
  #rt73 module gets picked but in some cases rt2570 has same IDs and should be used...
  [ "$USBMODULE" = "rt73" ] && [ "$USBMODULE2" = "rt2570" ] && USBMODULE="rt2570"
  modprobe $USBMODULE  
  [ $? -eq 0 ] && echo -n "$USBMODULE " >> /tmp/new-usb-modules
 fi
done
 
 
 #sleep 1
 NONE_MESSAGE="新しいUSBモジュールはロードされません。「モジュールのロード」ボタンで、手動でデバイスのモジュールを選択して試して下さい。"
 # Check for new modules
 if [ -s /tmp/new-usb-modules ] ; then
   # check if new modules are actually for network devices...
   for AMOD in `cat /tmp/new-usb-modules`
   do grep -q "^$AMOD" /etc/networkmodules && NEWMODULES="$NEWMODULES $AMOD"
   done
   # now see if there's really a new one
   if [ "$NEWMODULES" ] ; then
     # need to wait for interfaces to initialize...
     sleep 3
     TOPMSG="次のUSBモジュールがロードされました:
   $NEWMODULES
   新しいインターフェースが以下に表示されているか確認して下さい..."
   else
     TOPMSG="$NONE_MESSAGE"
   fi
 else
   TOPMSG="$NONE_MESSAGE"
 fi
 # Remove the usb-modules frame
 USB_MODULE_BUTTON=""
 # refresh the main window (find new interfaces)
 refreshMainWindowInfo
}

#=============================================================================
# Dougal: a function to find info about interface: 
#v2.21 BK modified...
findInterfaceInfo()
{
  local INT="$1"
  TYPE="" 
  INFO=""
  
  FI_DRIVER="`readlink /sys/class/net/$INT/device/driver`"
  FI_DRIVER="`basename "$FI_DRIVER"`"
  FIPATTERN="^$FI_DRIVER "
  WHATWEWANT="`grep "$FIPATTERN" /etc/networkmodules | tr '|' '_' | tr '"' '|'`" #'geany
  TYPE="`echo -n "$WHATWEWANT" | cut -f 2 -d '|' | cut -f 1 -d ':'`"
  INFO="`echo -n "$WHATWEWANT" | cut -f 2 -d '|' | tr -s ' ' | cut -f 2-29 -d ' '`"
  [ "$TYPE" = "" ] && TYPE="x"
  [ "$INFO" = "" ] && INFO="x"

  #want to manipulate the info string for display purposes...
  CNTLINE=0;FINALINFO=""
  for ONEWORD in $INFO
  do
   CNTWORD=`echo "$ONEWORD" | wc -c`
   CNTLINE=`expr $CNTLINE + $CNTWORD`
   [ $CNTLINE -gt $BIGGESTCNT ] && BIGGESTCNT=$CNTLINE #use for window width.
   [ $CNTLINE -gt 50 ] && break
   FINALINFO="${FINALINFO}${ONEWORD} " #ensures whole words only in string.
  done
  INFO="$FINALINFO "

  if grep -q "$INT" /proc/net/wireless || [ "$FI_DRIVER" = "prism2_usb" ] ; then
    INTTYPE="Wireless"
  else
    INTTYPE="Ethernet"
  fi

} # end findInterfaceInfo

#=============================================================================
saveInterfaceSetup()
{
  INTERFACE=$1

  if [ ! "$IS_WIRELESS" ] ; then
    rm -f /etc/${INTERFACE}wireless
  fi

  if [ -e "/tmp/wag-profiles_iwconfig.sh" ] ; then
    cp /tmp/wag-profiles_iwconfig.sh /etc/${INTERFACE}wireless
  fi

  echo -e "${MODECOMMANDS}" > /etc/${INTERFACE}mode

}

#=============================================================================
#showHelp()
#{
  #man "net_setup" &> /dev/null & 
#}


#=============================================================================
#=============== START OF SCRIPT BODY ====================
#=============================================================================


# Cleanup older temp files
rm -f /tmp/ethmoduleyesload.txt
rm -f /tmp/loadedeth.txt
rm -f /tmp/wag-profiles_iwconfig.sh

> /tmp/logethtries.txt

# Do we have pcmcia hardware?... v2.21 BK...
[ "`lsmod | grep -E '^i82365|^tcic|^yenta_socket'`" != "" ] && MPCMCIA="yes"

setDefaultMODULEBUTTONS

# Dougal: add this for usb modules:
setDefaultUSB_MODULE_BUTTON

refreshMainWindowInfo

BGCOLOR="#ffe0e0" #light red.
TOPMSG="やぁ！昔からネットワークの設定は簡単じゃない、でも一丁やってみよう！"

showMainWindow

#=============================================================================
#================ END OF SCRIPT BODY =====================
#=============================================================================
