#!/usr/bin/wish

##################################
#Xwget 0.5 a tcl/Tk GUI for wget 
# Ian Mulgrew 2005 - 2006
##################################

wm title . "Xwget 0.5 for Puppy"


# Frame for buttons & entry

frame .top  

pack .top -fill both

#Menu Bar

frame .top.menubar -relief raised -bd 2 -bg "#F3F2DF"
pack .top.menubar -in .top -fill x

menubutton .top.menubar.file -text File(ファイル) -underline 0 -menu .top.menubar.file.menu -bg "#F3F2DF"
menubutton .top.menubar.edit -text Edit(編集) -underline 0 -menu .top.menubar.edit.menu -bg "#F3F2DF"
pack .top.menubar.file .top.menubar.edit -side left

menubutton .top.menubar.help -text Help -underline 0 -menu .top.menubar.help.menu -bg "#F3F2DF"
pack .top.menubar.help -side right

menu .top.menubar.file.menu -tearoff 0
.top.menubar.file.menu add command -label 終了 -command exit

menu .top.menubar.edit.menu -tearoff 0
.top.menubar.edit.menu add command -label 取込 -command grabSel

menu .top.menubar.help.menu -tearoff 0
.top.menubar.help.menu add command -label Help -command {exec defaulthtmlviewer /usr/local/xwget/xwget_help.html &}
.top.menubar.help.menu add command -label About -command {exec defaulthtmlviewer /usr/local/xwget/xwget_about.html &}

##########################
#Proc for Menus

proc grabSel {} {
CopySelection
PasteSelection
}

proc CopySelection {} {
global seltxt
set seltxt [selection get STRING]
}

proc PasteSelection {} {
global seltxt
.en.filAdres insert insert $seltxt
}

#Space

frame .sp -height 10 
pack .sp -in .top -after .top.menubar
########################################

#Message frame

label .m1 -text "クイックスタート :-                                                                                                 " -fg blue 
label .m11 -text "1. アドレスフィールドにダウンロードサイトを入力します。
     例えば、 http://www.xxx とか ftp://xxx  " -fg blue

label .m3 -text "2. ディレクトリフィールドにディレクトリを入力します。
例えば、/root/my-documents あるいはそのままにします。        " -fg blue
label .m31 -text "空きディレクトリかデフォルトディレクトリ ( /root ) が使われます。" -fg blue
label .m4 -text "3. 「ファイルをダウンロード」ボタンをクリックします。               " -fg blue
label .m5 -text "*                                                                                                                          *" -fg red
label .m6 -text "使い方についてさらに詳しい内容のヘルプファイルをお読み下さい" -fg blue
label .m7 -text "Xwget.                                                                                                                " -fg blue
label .m8 -text "*                                                                                                                          *" -fg red
pack .m1 .m11 .m3 .m31 .m4 .m5 .m6 .m7 .m8 -in .top -after .sp -fill both

frame .spa -height 10  
pack .spa -in .top -after .m8

frame .en -height 10 
pack .en -after .spa

########################################

#Address entry label & field

label .en.l -text "アドレスを入力:" -padx 6
entry .en.filAdres -width 50 -bg white -bd 2

pack .en.l -side left
pack .en.filAdres -side left -padx 4 -expand true 

focus .en.filAdres
#Space
frame .spac -height 10
pack .spac -in .top -after .en

########################################

#Directory entry label & field

frame .di -height 10 
pack .di -in .top -after .spac
 
label .di.d -text "ディレクトリを入力:  " -padx 0
entry .di.dir -width 50 -bg white -bd 2

pack .di.d -side left
pack .di.dir -side left -fill x -expand true

focus .en.filAdres

#Space
frame .spacr -width 17c -height 1.5c 
pack .spacr -in .top -after .di -fill both
###############################################

#Download Button

button .down -text "ファイルをダウンロード" -command {
    
      set fle [.en.filAdres get]
      set ddr [.di.dir get]
 	
 if {$fle <=0} {
tk_messageBox -message "This field is blank. \nYou must enter a valid address to download from." -icon error 
focus .en.filAdres} else {
 
dnldf
}
}

proc dnldf {} {
 
global ddr fle 

if {[string match /* $ddr] == 1} {set dld $ddr} else {set dld /root}

	exec rxvt -name Xwget -bg "#F3F2DF" -e wget -c -P $dld $fle

cd $dld
exec /usr/local/bin/rox        
}

place .down -in .spacr -x 200 -y 11

###############################
