/* Generated by wbuild from "Common.w"
** (generator version $Revision: 2.0 $ of $Date: 93/07/06 16:08:04 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <ctype.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/CharSet.h>
#include "Converters.h"
#include "CommonP.h"
#define focus_detail(detail) (detail ==NotifyAncestor ?"NotifyAncestor":detail ==NotifyVirtual ?"NotifyVirtual":detail ==NotifyInferior ?"NotifyInferior":detail ==NotifyNonlinear ?"NotifyNonlinear":detail ==NotifyNonlinearVirtual ?"NotifyNonlinearVirtual":detail ==NotifyPointer ?"NotifyPointer":detail ==NotifyPointerRoot ?"NotifyPointerRoot":detail ==NotifyDetailNone ?"NotifyDetailNone":"???")


static void focusIn(Widget,XEvent*,String*,Cardinal*);
static void focusOut(Widget,XEvent*,String*,Cardinal*);
static void traverseDown(Widget,XEvent*,String*,Cardinal*);
static void traverseUp(Widget,XEvent*,String*,Cardinal*);
static void traverseLeft(Widget,XEvent*,String*,Cardinal*);
static void traverseRight(Widget,XEvent*,String*,Cardinal*);
static void traverseNext(Widget,XEvent*,String*,Cardinal*);
static void traversePrev(Widget,XEvent*,String*,Cardinal*);
static void traverseNextTop(Widget,XEvent*,String*,Cardinal*);
static void traverseHome(Widget,XEvent*,String*,Cardinal*);
static void traverseCurrent(Widget,XEvent*,String*,Cardinal*);

static XtActionsRec actionsList[] = {
{"focusIn", focusIn},
{"focusOut", focusOut},
{"traverseDown", traverseDown},
{"traverseUp", traverseUp},
{"traverseLeft", traverseLeft},
{"traverseRight", traverseRight},
{"traverseNext", traverseNext},
{"traversePrev", traversePrev},
{"traverseNextTop", traverseNextTop},
{"traverseHome", traverseHome},
{"traverseCurrent", traverseCurrent},
};
static void _resolve_inheritance(WidgetClass);
static void class_initialize(void);
static void initialize(Widget ,Widget,ArgList ,Cardinal *);
static Boolean  set_values(Widget ,Widget ,Widget,ArgList ,Cardinal *);
static void compute_inside(Widget,Position *,Position *,Dimension *,Dimension *);
static void expose(Widget,XEvent *,Region );
static void destroy(Widget);
static void highlight_border(Widget);
static void unhighlight_border(Widget);
static Boolean  accept_focus(Widget,Time *);
static Boolean  would_accept_focus(Widget);
static void traverse(Widget,TraversalDirection ,Widget ,Time *);
static Boolean  choose_color(Widget,double ,Pixel ,Pixel *);
static Boolean  lighter_color(Widget,Pixel ,Pixel *);
static Boolean  darker_color(Widget,Pixel ,Pixel *);
#define done(type, value) do {\
	if (to->addr != NULL) {\
	    if (to->size < sizeof(type)) {\
	        to->size = sizeof(type);\
	        return False;\
	    }\
	    *(type*)(to->addr) = (value);\
        } else {\
	    static type static_val;\
	    static_val = (value);\
	    to->addr = (XtPointer)&static_val;\
        }\
        to->size = sizeof(type);\
        return True;\
    }while (0 )


static Boolean  cvtStringToAlignment(Display *,XrmValuePtr ,Cardinal *,XrmValuePtr ,XrmValuePtr ,XtPointer *);
static Boolean  cvtAlignmentToString(Display *,XrmValuePtr ,Cardinal *,XrmValuePtr ,XrmValuePtr ,XtPointer *);
static char  extraTranslations[] = "\
	<FocusIn>: focusIn()\n\
	<FocusOut>: focusOut()\n\
	<Key>Up: traverseUp()\n\
	<Key>Down: traverseDown()\n\
	<Key>Left: traverseLeft()\n\
	<Key>Right: traverseRight()\n\
	<Key>Next: traverseNext()\n\
	~Shift<Key>Tab: traverseNext()\n\
	<Key>Prior: traversePrev()\n\
	Shift<Key>Tab: traversePrev()\n\
	<Key>KP_Enter: traverseNextTop()\n\
	<Key>Home: traverseHome()";
static void create_bordergc(Widget);
static Boolean  traverse_to_direction(Widget,TraversalDirection ,int ,int ,Widget *,int *);
static void traverse_to_next(Widget,Widget ,Time *);
static void traverse_to_prev(Widget,Widget ,Time *);
static void traverse_to_next_top(Widget,Widget ,Time *);

/*ARGSUSED*/static Boolean  cvtStringToAlignment(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    Alignment a = 0;
    char c, *t, *s = (char*) from->addr;

    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtStringToAlignment", "wrongParameters",
		      "XtToolkitError",
		      "String to Alignment conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);

    while (*s) {
	for (; isspace(*s); s++) ;
	for (t = s; *t && ! isspace(*t); t++) ;
	c = *t;
	*t = '\0';
	if (XmuCompareISOLatin1(s, "top") == 0) a |= XfwfTop;
	else if (XmuCompareISOLatin1(s, "bottom") == 0) a |= XfwfBottom;
	else if (XmuCompareISOLatin1(s, "center") == 0) ; /* skip */
	else if (XmuCompareISOLatin1(s, "left") == 0) a |= XfwfLeft;
	else if (XmuCompareISOLatin1(s, "right") == 0) a |= XfwfRight;
	else {
	    XtDisplayStringConversionWarning(display, (char*) from->addr, 
					     "Alignment");
	    break;
	}
	*t = c;
	s = t;
    }
    done(Alignment, a);
}
/*ARGSUSED*/static Boolean  cvtAlignmentToString(Display *display, XrmValuePtr args, Cardinal *num_args, XrmValuePtr from, XrmValuePtr to, XtPointer *converter_data)
{
    Alignment *a = (Alignment*) from->addr;

    if (*num_args != 0)
	XtAppErrorMsg(XtDisplayToApplicationContext(display),
		      "cvtAlignmentToString", "wrongParameters",
		      "XtToolkitError",
		      "Alignment to String conversion needs no arguments",
		      (String*) NULL, (Cardinal*) NULL);
    switch (*a) {
    case XfwfCenter: done(String, "center");
    case XfwfBottom: done(String, "bottom");
    case XfwfTop: done(String, "top");
    case XfwfLeft: done(String, "left");
    case XfwfRight: done(String, "right");
    case XfwfBottom + XfwfLeft: done(String, "bottom left");
    case XfwfBottom + XfwfRight: done(String, "bottom right");
    case XfwfTop + XfwfLeft: done(String, "top left");
    case XfwfTop + XfwfRight: done(String, "top right");
    default: done(String, "unknown");
    }
}
/*ARGSUSED*/static void create_bordergc(Widget self)
{
    XtGCMask mask;
    XGCValues values;

    if (((XfwfCommonWidget)self)->xfwfCommon.bordergc) XtReleaseGC(self, ((XfwfCommonWidget)self)->xfwfCommon.bordergc);
    if (((XfwfCommonWidget)self)->xfwfCommon.highlightPixmap != None) {
	mask = GCFillStyle | GCTile;
	values.fill_style = FillTiled;
	values.tile = ((XfwfCommonWidget)self)->xfwfCommon.highlightPixmap;
    } else {
	mask = GCFillStyle | GCForeground;
	values.fill_style = FillSolid;
	values.foreground = ((XfwfCommonWidget)self)->xfwfCommon.highlightColor;
    }
    ((XfwfCommonWidget)self)->xfwfCommon.bordergc = XtGetGC(self, mask, &values);
}
/*ARGSUSED*/static Boolean  traverse_to_direction(Widget self, TraversalDirection dir, int x, int y, Widget *found, int *distance)
{
    int i;
    Widget child, w;
    Position rx, ry;
    int dist;
    Boolean found_child = False;

    if (! ((XfwfCommonWidget)self)->xfwfCommon.traversalOn) return False;
    /*
     * First recurse to all descendants
     */
    for (i = 0; i < ((XfwfCommonWidget)self)->composite.num_children; i++)
        if (XtIsSubclass(((XfwfCommonWidget)self)->composite.children[i], xfwfCommonWidgetClass)
            && traverse_to_direction(((XfwfCommonWidget)self)->composite.children[i], dir, x, y, found, distance))
            found_child = True;
    if (found_child) return True;
    /*
     * No child found, now check own position and distance
     */
    switch (dir) {
    case TraverseHome: rx = 0; ry = 0; break;
    case TraverseLeft: rx = ((XfwfCommonWidget)self)->core.width; ry = ((XfwfCommonWidget)self)->core.height/2; break;
    case TraverseDown: rx = ((XfwfCommonWidget)self)->core.width/2; ry = 0; break;
    case TraverseRight: rx = 0; ry = ((XfwfCommonWidget)self)->core.height/2; break;
    case TraverseUp: rx = ((XfwfCommonWidget)self)->core.width/2; ry = ((XfwfCommonWidget)self)->core.height; break;
    }
    XtTranslateCoords(self, rx, ry, &rx, &ry);
    if ((dir == TraverseUp && ry > y)
        || (dir == TraverseLeft && rx > x)
        || (dir == TraverseDown && ry < y)
        || (dir == TraverseRight && rx < x)) return False;
    dist = (rx - x)*(rx - x) + (ry - y)*(ry - y);
    if (dist >= *distance) return False;
    /*
     * We are the best so far, but do we want the focus?
     */
    if (! ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.would_accept_focus(self)) return False;
    *distance = dist;
    *found = self;
    return True;
}
/*ARGSUSED*/static void traverse_to_next(Widget self, Widget current, Time *time)
{
    int i = 0;
    Widget parent = XtParent(self);

    while (i < ((XfwfCommonWidget)self)->composite.num_children && ((XfwfCommonWidget)self)->composite.children[i] != current) i++;
    for (i++; i < ((XfwfCommonWidget)self)->composite.num_children; i++)
        if (XtCallAcceptFocus(((XfwfCommonWidget)self)->composite.children[i], time)) return;
    if (XtIsSubclass(parent, xfwfCommonWidgetClass))
        ((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, TraverseNext, self, time);
}
/*ARGSUSED*/static void traverse_to_prev(Widget self, Widget current, Time *time)
{
    int i = 0;
    Widget parent = XtParent(self);

    while (i < ((XfwfCommonWidget)self)->composite.num_children && ((XfwfCommonWidget)self)->composite.children[i] != current) i++;
    for (i--; i >= 0; i--)
        if (XtCallAcceptFocus(((XfwfCommonWidget)self)->composite.children[i], time)) return;
    if (XtIsSubclass(parent, xfwfCommonWidgetClass))
        ((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, TraversePrev, self, time);
}
/*ARGSUSED*/static void traverse_to_next_top(Widget self, Widget current, Time *time)
{
    Widget parent = XtParent(self);

    if (XtIsSubclass(parent, xfwfCommonWidgetClass))
	((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, TraverseNextTop, current, time);
    else
	XtCallCallbackList(self, ((XfwfCommonWidget)self)->xfwfCommon.nextTop, NULL);
}

static XtResource resources[] = {
{XtNtraversalOn,XtCTraversalOn,XtRBoolean,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.traversalOn),XtOffsetOf(XfwfCommonRec,xfwfCommon.traversalOn),XtRImmediate,(XtPointer)True },
{XtNhighlightThickness,XtCHighlightThickness,XtRDimension,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.highlightThickness),XtOffsetOf(XfwfCommonRec,xfwfCommon.highlightThickness),XtRImmediate,(XtPointer)2 },
{XtNhighlightColor,XtCHighlightColor,XtRPixel,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.highlightColor),XtOffsetOf(XfwfCommonRec,xfwfCommon.highlightColor),XtRString,(XtPointer)XtDefaultForeground },
{XtNhighlightPixmap,XtCHighlightPixmap,XtRPixmap,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.highlightPixmap),XtOffsetOf(XfwfCommonRec,xfwfCommon.highlightPixmap),XtRImmediate,(XtPointer)None },
{XtNnextTop,XtCNextTop,XtRCallback,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.nextTop),XtOffsetOf(XfwfCommonRec,xfwfCommon.nextTop),XtRImmediate,(XtPointer)NULL },
{XtNuserData,XtCUserData,XtRPointer,sizeof(((XfwfCommonRec*)NULL)->xfwfCommon.userData),XtOffsetOf(XfwfCommonRec,xfwfCommon.userData),XtRImmediate,(XtPointer)NULL },
};

XfwfCommonClassRec xfwfCommonClassRec = {
{ /* core_class part */
(WidgetClass) &compositeClassRec,
"XfwfCommon",
sizeof(XfwfCommonRec),
class_initialize,
_resolve_inheritance,
FALSE,
initialize,
NULL,
XtInheritRealize,
actionsList,
11,
resources,
6,
NULLQUARK,
False ,
FALSE ,
False ,
False ,
destroy,
XtInheritResize,
expose,
set_values,
NULL,
XtInheritSetValuesAlmost,
NULL,
accept_focus,
XtVersion,
NULL,
NULL,
XtInheritQueryGeometry,
XtInheritDisplayAccelerator,
NULL 
},
{ /* composite_class part */
XtInheritGeometryManager,
XtInheritChangeManaged,
XtInheritInsertChild,
XtInheritDeleteChild,
NULL
},
{ /* XfwfCommon_class part */
compute_inside,
highlight_border,
unhighlight_border,
would_accept_focus,
traverse,
choose_color,
lighter_color,
darker_color,
NULL ,
},
};
WidgetClass xfwfCommonWidgetClass = (WidgetClass) &xfwfCommonClassRec;
/*ARGSUSED*/
static void focusIn(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    Time time = CurrentTime;

    if (event->type != FocusIn)
	XtError("focusIn action may only be bound to FocusIn events");
    if (! ((XfwfCommonWidget)self)->xfwfCommon.traversalOn)
	return;
    if (event->xfocus.detail == NotifyAncestor
	|| event->xfocus.detail == NotifyInferior
	|| event->xfocus.detail == NotifyNonlinear) {
	if (! ((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) (void) ((XfwfCommonWidgetClass)self->core.widget_class)->core_class.accept_focus(self, &time);
    } else if (((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) {
	((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.unhighlight_border(self);
	((XfwfCommonWidget)self)->xfwfCommon.traversal_focus = False;
    }
}

/*ARGSUSED*/
static void focusOut(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    if (event->type != FocusOut)
	XtError("focusOut action may only be bound to FocusOut events");
    if (((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) {
	((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.unhighlight_border(self);
	((XfwfCommonWidget)self)->xfwfCommon.traversal_focus = False;
    }
}

/*ARGSUSED*/
static void traverseDown(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseDown, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseUp(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseUp, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseLeft(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseLeft, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseRight(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseRight, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseNext(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseNext, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traversePrev(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraversePrev, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseNextTop(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseNextTop, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseHome(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traverse(self, TraverseHome, self, &event->xkey.time);
}

/*ARGSUSED*/
static void traverseCurrent(Widget self, XEvent *event, String *params, Cardinal *num_params)
{
    Time time = CurrentTime;

    if (((XfwfCommonWidget)self)->xfwfCommon.traversalOn) (void) ((XfwfCommonWidgetClass)self->core.widget_class)->core_class.accept_focus(self, &time);
}

static void _resolve_inheritance(WidgetClass class)
{
  XfwfCommonWidgetClass c = (XfwfCommonWidgetClass) class;
  XfwfCommonWidgetClass super;
  static CompositeClassExtensionRec extension_rec = {
    NULL, NULLQUARK, XtCompositeExtensionVersion,
    sizeof(CompositeClassExtensionRec), True};
  CompositeClassExtensionRec *ext;
  ext = (XtPointer)XtMalloc(sizeof(*ext));
  *ext = extension_rec;
  ext->next_extension = c->composite_class.extension;
  c->composite_class.extension = ext;
  if (class == xfwfCommonWidgetClass) return;
  super = (XfwfCommonWidgetClass)class->core_class.superclass;
  if (c->xfwfCommon_class.compute_inside == XtInherit_compute_inside)
    c->xfwfCommon_class.compute_inside = super->xfwfCommon_class.compute_inside;
  if (c->xfwfCommon_class.highlight_border == XtInherit_highlight_border)
    c->xfwfCommon_class.highlight_border = super->xfwfCommon_class.highlight_border;
  if (c->xfwfCommon_class.unhighlight_border == XtInherit_unhighlight_border)
    c->xfwfCommon_class.unhighlight_border = super->xfwfCommon_class.unhighlight_border;
  if (c->xfwfCommon_class.would_accept_focus == XtInherit_would_accept_focus)
    c->xfwfCommon_class.would_accept_focus = super->xfwfCommon_class.would_accept_focus;
  if (c->xfwfCommon_class.traverse == XtInherit_traverse)
    c->xfwfCommon_class.traverse = super->xfwfCommon_class.traverse;
  if (c->xfwfCommon_class.choose_color == XtInherit_choose_color)
    c->xfwfCommon_class.choose_color = super->xfwfCommon_class.choose_color;
  if (c->xfwfCommon_class.lighter_color == XtInherit_lighter_color)
    c->xfwfCommon_class.lighter_color = super->xfwfCommon_class.lighter_color;
  if (c->xfwfCommon_class.darker_color == XtInherit_darker_color)
    c->xfwfCommon_class.darker_color = super->xfwfCommon_class.darker_color;
}
/*ARGSUSED*/static void class_initialize(void)
{
    static XtConvertArgRec args[] = {
    { XtWidgetBaseOffset, 0, sizeof(Widget) } };

    XtSetTypeConverter(XtRString, "Alignment", cvtStringToAlignment,
		       NULL, 0, XtCacheNone, NULL);
    XtSetTypeConverter("Alignment", XtRString, cvtAlignmentToString,
		       NULL, 0, XtCacheNone, NULL);
    /* init_icon_quarks(); */
    XtSetTypeConverter(XtRString, "Icon", cvtStringToIcon,
		       args, XtNumber(args), XtCacheNone, NULL);
}
/*ARGSUSED*/static void initialize(Widget request, Widget self, ArgList args, Cardinal *num_args)
{
    if (((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traversal_trans == NULL)
	((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traversal_trans = XtParseTranslationTable(extraTranslations);
    if (((XfwfCommonWidget)self)->xfwfCommon.traversalOn) {
	XtAugmentTranslations(self, ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traversal_trans);
	((XfwfCommonWidgetClass)self->core.widget_class)->core_class.visible_interest = True;
    }
    ((XfwfCommonWidget)self)->xfwfCommon.traversal_focus = False;
    ((XfwfCommonWidget)self)->xfwfCommon.bordergc = NULL;
    create_bordergc(self);
}
/*ARGSUSED*/static Boolean  set_values(Widget old, Widget request, Widget self, ArgList args, Cardinal *num_args)
{
    Boolean need_redraw = False;
    Widget parent = XtParent(self);
    Time time = CurrentTime;

    if (((XfwfCommonWidget)self)->xfwfCommon.traversalOn != ((XfwfCommonWidget)old)->xfwfCommon.traversalOn && ((XfwfCommonWidget)self)->xfwfCommon.traversalOn) {
	XtAugmentTranslations(self, ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.traversal_trans); 
	((XfwfCommonWidgetClass)self->core.widget_class)->core_class.visible_interest = True;
    }
    if ((((XfwfCommonWidget)self)->core.sensitive != ((XfwfCommonWidget)old)->core.sensitive
	 || ((XfwfCommonWidget)self)->core.ancestor_sensitive != ((XfwfCommonWidget)old)->core.ancestor_sensitive
	 || ((XfwfCommonWidget)self)->xfwfCommon.traversalOn != ((XfwfCommonWidget)old)->xfwfCommon.traversalOn)
	&& ((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) {
	if (XtIsSubclass(parent, xfwfCommonWidgetClass))
	    ((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, TraverseHome, self, &time);
    }
    if (((XfwfCommonWidget)self)->xfwfCommon.highlightThickness != ((XfwfCommonWidget)old)->xfwfCommon.highlightThickness)
	need_redraw = True;
    if (((XfwfCommonWidget)self)->xfwfCommon.highlightPixmap != ((XfwfCommonWidget)old)->xfwfCommon.highlightPixmap) {
	create_bordergc(self);
	need_redraw = True;
    } else if (((XfwfCommonWidget)self)->xfwfCommon.highlightColor != ((XfwfCommonWidget)old)->xfwfCommon.highlightColor) {
	((XfwfCommonWidget)self)->xfwfCommon.highlightPixmap = None;
	create_bordergc(self);
	need_redraw = True;
    }
    return need_redraw;
}
/*ARGSUSED*/static void compute_inside(Widget self, Position *x, Position *y, Dimension *w, Dimension *h)
{
    *x = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;
    *y = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;

    /* 09Mar94 DCT - max(0) applied to width and height. */
    *w = max(0,((XfwfCommonWidget)self)->core.width - 2 * ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness);
    *h = max(0,((XfwfCommonWidget)self)->core.height - 2 * ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness);
}

/*ARGSUSED*/static void expose(Widget self, XEvent *event, Region region)
{
    if (! XtIsRealized(self)) return;
    if (region != NULL) XSetRegion(XtDisplay(self), ((XfwfCommonWidget)self)->xfwfCommon.bordergc, region);
    if (((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.highlight_border(self);
    if (region != NULL) XSetClipMask(XtDisplay(self), ((XfwfCommonWidget)self)->xfwfCommon.bordergc, None);
}
/*ARGSUSED*/static void destroy(Widget self)
{
    Widget parent = XtParent(self);
    Time time = CurrentTime;

    if (((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) {
	((XfwfCommonWidget)self)->core.sensitive = False;
	if (XtIsSubclass(parent, xfwfCommonWidgetClass))
	    ((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, TraverseHome, self, &time);
    }
}
/*ARGSUSED*/static void highlight_border(Widget self)
{
    XRectangle rect[4];

    if (((XfwfCommonWidget)self)->xfwfCommon.highlightThickness == 0) return;

    rect[0].x = 0;
    rect[0].y = 0;
    rect[0].width = ((XfwfCommonWidget)self)->core.width;
    rect[0].height = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;

    rect[1].x = 0;
    rect[1].y = 0;
    rect[1].width = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;
    rect[1].height = ((XfwfCommonWidget)self)->core.height;

    rect[2].x = ((XfwfCommonWidget)self)->core.width - ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;
    rect[2].y = 0;
    rect[2].width = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;
    rect[2].height = ((XfwfCommonWidget)self)->core.height;

    rect[3].x = 0;
    rect[3].y = ((XfwfCommonWidget)self)->core.height - ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;
    rect[3].width = ((XfwfCommonWidget)self)->core.width;
    rect[3].height = ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness;

    XFillRectangles(XtDisplay(self), XtWindow(self), ((XfwfCommonWidget)self)->xfwfCommon.bordergc, &rect[0], 4);
}
/*ARGSUSED*/static void unhighlight_border(Widget self)
{
    if (((XfwfCommonWidget)self)->xfwfCommon.highlightThickness == 0) return;

    XClearArea(XtDisplay(self), XtWindow(self), 
	       0, 0, ((XfwfCommonWidget)self)->core.width, ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness, False);
    XClearArea(XtDisplay(self), XtWindow(self),
	       0, 0, ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness, ((XfwfCommonWidget)self)->core.height, False);
    XClearArea(XtDisplay(self), XtWindow(self),
	       ((XfwfCommonWidget)self)->core.width - ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness, 0, 
	       ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness, ((XfwfCommonWidget)self)->core.height, False);
    XClearArea(XtDisplay(self), XtWindow(self),
	       0, ((XfwfCommonWidget)self)->core.height - ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness,
	       ((XfwfCommonWidget)self)->core.width, ((XfwfCommonWidget)self)->xfwfCommon.highlightThickness, False);
}
/*ARGSUSED*/static Boolean  accept_focus(Widget self, Time *time)
{
    int i;

    if (! XtIsRealized(self) || ! ((XfwfCommonWidget)self)->core.sensitive || ! ((XfwfCommonWidget)self)->xfwfCommon.traversalOn
	|| ! ((XfwfCommonWidget)self)->core.visible || ! ((XfwfCommonWidget)self)->core.ancestor_sensitive || ! ((XfwfCommonWidget)self)->core.managed
	|| ! ((XfwfCommonWidget)self)->core.mapped_when_managed || ((XfwfCommonWidget)self)->core.being_destroyed) return False;
    for (i = 0; i < ((XfwfCommonWidget)self)->composite.num_children; i++)
        if (XtCallAcceptFocus(((XfwfCommonWidget)self)->composite.children[i], time)) return True;
    if (! ((XfwfCommonWidget)self)->xfwfCommon.traversal_focus) {
	XSetInputFocus(XtDisplay(self), XtWindow(self), RevertToParent, *time);
	((XfwfCommonWidget)self)->xfwfCommon.traversal_focus = True;
	((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.highlight_border(self);
    }
    return True;
}
/*ARGSUSED*/static Boolean  would_accept_focus(Widget self)
{
    int i;
    Widget child;

    if (! XtIsRealized(self) || ! ((XfwfCommonWidget)self)->core.sensitive || ! ((XfwfCommonWidget)self)->core.visible || ! ((XfwfCommonWidget)self)->xfwfCommon.traversalOn)
        return False;
    else {
        for (i = 0; i < ((XfwfCommonWidget)self)->composite.num_children; i++) {
            child = ((XfwfCommonWidget)self)->composite.children[i];
            if (XtIsSubclass(child, xfwfCommonWidgetClass)
                && ((XfwfCommonWidgetClass)child->core.widget_class)->xfwfCommon_class.would_accept_focus(child))
                return False;
	}
        return True;
    }
}
/*ARGSUSED*/static void traverse(Widget self, TraversalDirection dir, Widget current, Time *time)
{
    Widget w, parent = XtParent(self);
    Position x, y;
    int distance = LARGE_NUMBER;

    if (dir == TraverseNextTop)
	traverse_to_next_top(self, current, time);
    else if (dir == TraverseNext)
        traverse_to_next(self, current, time);
    else if (dir == TraversePrev)
        traverse_to_prev(self, current, time);
    else if (XtIsSubclass(parent, xfwfCommonWidgetClass))
        ((XfwfCommonWidgetClass)parent->core.widget_class)->xfwfCommon_class.traverse(parent, dir, current, time);
    else {
        switch (dir) {
        case TraverseHome: x = 0; y = 0; break;
        case TraverseLeft: x = 0; y = ((XfwfCommonWidget)current)->core.height/2; break;
        case TraverseDown: x = ((XfwfCommonWidget)current)->core.width/2; y = ((XfwfCommonWidget)current)->core.height; break;
        case TraverseRight: x = ((XfwfCommonWidget)current)->core.width; y = ((XfwfCommonWidget)current)->core.height/2; break;
        case TraverseUp: x = ((XfwfCommonWidget)current)->core.width/2; y = 0; break;
        }
        if (dir != TraverseHome) XtTranslateCoords(current, x, y, &x, &y);
        if (traverse_to_direction(self, dir, x, y, &w, &distance))
            XtCallAcceptFocus(w, time);
    }
}
/*ARGSUSED*/static Boolean  choose_color(Widget self, double factor, Pixel base, Pixel *result)
{
    XColor color1, color2, dummy;

    color1.pixel = base;
    XQueryColor(XtDisplay(self), DefaultColormapOfScreen(XtScreen(self)), &color1);
    color2.red = min(65535, factor * color1.red);
    color2.green = min(65535, factor * color1.green);
    color2.blue = min(65535, factor * color1.blue);
    if (! XAllocColor(XtDisplay(self),
		      DefaultColormapOfScreen(XtScreen(self)), &color2))
	return False;
    if (base == color2.pixel) {
	if (! XAllocNamedColor(XtDisplay(self),
			       DefaultColormapOfScreen(XtScreen(self)), "gray75",
			       &color2, &dummy))
	    return False;
    }
    *result = color2.pixel;
    return True;
}
/*ARGSUSED*/static Boolean  lighter_color(Widget self, Pixel base, Pixel *result)
{
    /* return choose_color(self, 1.5, base, result); */
    return choose_color(self, 1.25, base, result);
}
/*ARGSUSED*/static Boolean  darker_color(Widget self, Pixel base, Pixel *result)
{
    /* return choose_color(self, 0.667, base, result); */
    return choose_color(self, 0.500, base, result);
}
/*ARGSUSED*/void XfwfCallComputeInside(Widget self, Position *x, Position *y, Dimension *w, Dimension *h)
{
    if (XtIsSubclass(self, xfwfCommonWidgetClass) && ((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside)
	((XfwfCommonWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, x, y, w, h);
}
