# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AnalysisCreate(_serialization.Model):
    """The request body for creating an analysis for an NGINX configuration.

    All required parameters must be populated in order to send to server.

    :ivar config: Required.
    :vartype config: ~azure.mgmt.nginx.models.AnalysisCreateConfig
    """

    _validation = {
        "config": {"required": True},
    }

    _attribute_map = {
        "config": {"key": "config", "type": "AnalysisCreateConfig"},
    }

    def __init__(self, *, config: "_models.AnalysisCreateConfig", **kwargs: Any) -> None:
        """
        :keyword config: Required.
        :paramtype config: ~azure.mgmt.nginx.models.AnalysisCreateConfig
        """
        super().__init__(**kwargs)
        self.config = config


class AnalysisCreateConfig(_serialization.Model):
    """AnalysisCreateConfig.

    :ivar root_file: The root file of the NGINX config file(s). It must match one of the files'
     filepath.
    :vartype root_file: str
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files: list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
    :ivar package:
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    """

    _attribute_map = {
        "root_file": {"key": "rootFile", "type": "str"},
        "files": {"key": "files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "protectedFiles", "type": "[NginxConfigurationProtectedFileRequest]"},
        "package": {"key": "package", "type": "NginxConfigurationPackage"},
    }

    def __init__(
        self,
        *,
        root_file: Optional[str] = None,
        files: Optional[List["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[List["_models.NginxConfigurationProtectedFileRequest"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword root_file: The root file of the NGINX config file(s). It must match one of the files'
         filepath.
        :paramtype root_file: str
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
        :keyword package:
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        """
        super().__init__(**kwargs)
        self.root_file = root_file
        self.files = files
        self.protected_files = protected_files
        self.package = package


class AnalysisDiagnostic(_serialization.Model):
    """An error object found during the analysis of an NGINX configuration.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique identifier for the error.
    :vartype id: str
    :ivar directive: Required.
    :vartype directive: str
    :ivar description: Required.
    :vartype description: str
    :ivar file: the filepath of the most relevant config file. Required.
    :vartype file: str
    :ivar line: Required.
    :vartype line: float
    :ivar message: Required.
    :vartype message: str
    :ivar rule: Required.
    :vartype rule: str
    """

    _validation = {
        "directive": {"required": True},
        "description": {"required": True},
        "file": {"required": True},
        "line": {"required": True},
        "message": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "directive": {"key": "directive", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "line": {"key": "line", "type": "float"},
        "message": {"key": "message", "type": "str"},
        "rule": {"key": "rule", "type": "str"},
    }

    def __init__(
        self,
        *,
        directive: str,
        description: str,
        file: str,
        line: float,
        message: str,
        rule: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the error.
        :paramtype id: str
        :keyword directive: Required.
        :paramtype directive: str
        :keyword description: Required.
        :paramtype description: str
        :keyword file: the filepath of the most relevant config file. Required.
        :paramtype file: str
        :keyword line: Required.
        :paramtype line: float
        :keyword message: Required.
        :paramtype message: str
        :keyword rule: Required.
        :paramtype rule: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.directive = directive
        self.description = description
        self.file = file
        self.line = line
        self.message = message
        self.rule = rule


class AnalysisResult(_serialization.Model):
    """The response body for an analysis request. Contains the status of the analysis and any errors.

    All required parameters must be populated in order to send to server.

    :ivar status: The status of the analysis. Required.
    :vartype status: str
    :ivar data:
    :vartype data: ~azure.mgmt.nginx.models.AnalysisResultData
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "data": {"key": "data", "type": "AnalysisResultData"},
    }

    def __init__(self, *, status: str, data: Optional["_models.AnalysisResultData"] = None, **kwargs: Any) -> None:
        """
        :keyword status: The status of the analysis. Required.
        :paramtype status: str
        :keyword data:
        :paramtype data: ~azure.mgmt.nginx.models.AnalysisResultData
        """
        super().__init__(**kwargs)
        self.status = status
        self.data = data


class AnalysisResultData(_serialization.Model):
    """AnalysisResultData.

    :ivar errors:
    :vartype errors: list[~azure.mgmt.nginx.models.AnalysisDiagnostic]
    :ivar diagnostics:
    :vartype diagnostics: list[~azure.mgmt.nginx.models.DiagnosticItem]
    """

    _attribute_map = {
        "errors": {"key": "errors", "type": "[AnalysisDiagnostic]"},
        "diagnostics": {"key": "diagnostics", "type": "[DiagnosticItem]"},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["_models.AnalysisDiagnostic"]] = None,
        diagnostics: Optional[List["_models.DiagnosticItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword errors:
        :paramtype errors: list[~azure.mgmt.nginx.models.AnalysisDiagnostic]
        :keyword diagnostics:
        :paramtype diagnostics: list[~azure.mgmt.nginx.models.DiagnosticItem]
        """
        super().__init__(**kwargs)
        self.errors = errors
        self.diagnostics = diagnostics


class AutoUpgradeProfile(_serialization.Model):
    """Autoupgrade settings of a deployment.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_channel: Channel used for autoupgrade. Required.
    :vartype upgrade_channel: str
    """

    _validation = {
        "upgrade_channel": {"required": True},
    }

    _attribute_map = {
        "upgrade_channel": {"key": "upgradeChannel", "type": "str"},
    }

    def __init__(self, *, upgrade_channel: str, **kwargs: Any) -> None:
        """
        :keyword upgrade_channel: Channel used for autoupgrade. Required.
        :paramtype upgrade_channel: str
        """
        super().__init__(**kwargs)
        self.upgrade_channel = upgrade_channel


class DiagnosticItem(_serialization.Model):
    """A diagnostic is a message associated with an NGINX config. The Analyzer returns diagnostics
    with a level indicating the importance of the diagnostic with optional category.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique identifier for the diagnostic.
    :vartype id: str
    :ivar directive: Required.
    :vartype directive: str
    :ivar description: Required.
    :vartype description: str
    :ivar file: The filepath of the most relevant config file. Required.
    :vartype file: str
    :ivar line: Required.
    :vartype line: float
    :ivar message: Required.
    :vartype message: str
    :ivar rule: Required.
    :vartype rule: str
    :ivar level: Warning or Info. Required. Known values are: "Info" and "Warning".
    :vartype level: str or ~azure.mgmt.nginx.models.Level
    :ivar category: Category of warning like Best-practices, Recommendation, Security etc.
    :vartype category: str
    """

    _validation = {
        "directive": {"required": True},
        "description": {"required": True},
        "file": {"required": True},
        "line": {"required": True},
        "message": {"required": True},
        "rule": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "directive": {"key": "directive", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "line": {"key": "line", "type": "float"},
        "message": {"key": "message", "type": "str"},
        "rule": {"key": "rule", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "category": {"key": "category", "type": "str"},
    }

    def __init__(
        self,
        *,
        directive: str,
        description: str,
        file: str,
        line: float,
        message: str,
        rule: str,
        level: Union[str, "_models.Level"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        category: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the diagnostic.
        :paramtype id: str
        :keyword directive: Required.
        :paramtype directive: str
        :keyword description: Required.
        :paramtype description: str
        :keyword file: The filepath of the most relevant config file. Required.
        :paramtype file: str
        :keyword line: Required.
        :paramtype line: float
        :keyword message: Required.
        :paramtype message: str
        :keyword rule: Required.
        :paramtype rule: str
        :keyword level: Warning or Info. Required. Known values are: "Info" and "Warning".
        :paramtype level: str or ~azure.mgmt.nginx.models.Level
        :keyword category: Category of warning like Best-practices, Recommendation, Security etc.
        :paramtype category: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.directive = directive
        self.description = description
        self.file = file
        self.line = line
        self.message = message
        self.rule = rule
        self.level = level
        self.category = category


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.nginx.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.nginx.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.nginx.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.nginx.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class IdentityProperties(_serialization.Model):
    """IdentityProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar type: Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned",
     and "None".
    :vartype type: str or ~azure.mgmt.nginx.models.IdentityType
    :ivar user_assigned_identities: Dictionary of :code:`<UserIdentityProperties>`.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.nginx.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned,
         UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.nginx.models.IdentityType
        :keyword user_assigned_identities: Dictionary of :code:`<UserIdentityProperties>`.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.nginx.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NginxCertificate(_serialization.Model):
    """NginxCertificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxCertificateProperties
    :ivar location:
    :vartype location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxCertificateProperties"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.NginxCertificateProperties"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxCertificateProperties
        :keyword location:
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.location = location
        self.system_data = None


class NginxCertificateErrorResponseBody(_serialization.Model):
    """NginxCertificateErrorResponseBody.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class NginxCertificateListResponse(_serialization.Model):
    """NginxCertificateListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.nginx.models.NginxCertificate]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NginxCertificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.nginx.models.NginxCertificate]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxCertificateProperties(_serialization.Model):
    """NginxCertificateProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar key_virtual_path:
    :vartype key_virtual_path: str
    :ivar certificate_virtual_path:
    :vartype certificate_virtual_path: str
    :ivar key_vault_secret_id:
    :vartype key_vault_secret_id: str
    :ivar sha1_thumbprint:
    :vartype sha1_thumbprint: str
    :ivar key_vault_secret_version:
    :vartype key_vault_secret_version: str
    :ivar key_vault_secret_created:
    :vartype key_vault_secret_created: ~datetime.datetime
    :ivar certificate_error:
    :vartype certificate_error: ~azure.mgmt.nginx.models.NginxCertificateErrorResponseBody
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sha1_thumbprint": {"readonly": True},
        "key_vault_secret_version": {"readonly": True},
        "key_vault_secret_created": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "key_virtual_path": {"key": "keyVirtualPath", "type": "str"},
        "certificate_virtual_path": {"key": "certificateVirtualPath", "type": "str"},
        "key_vault_secret_id": {"key": "keyVaultSecretId", "type": "str"},
        "sha1_thumbprint": {"key": "sha1Thumbprint", "type": "str"},
        "key_vault_secret_version": {"key": "keyVaultSecretVersion", "type": "str"},
        "key_vault_secret_created": {"key": "keyVaultSecretCreated", "type": "iso-8601"},
        "certificate_error": {"key": "certificateError", "type": "NginxCertificateErrorResponseBody"},
    }

    def __init__(
        self,
        *,
        key_virtual_path: Optional[str] = None,
        certificate_virtual_path: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        certificate_error: Optional["_models.NginxCertificateErrorResponseBody"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_virtual_path:
        :paramtype key_virtual_path: str
        :keyword certificate_virtual_path:
        :paramtype certificate_virtual_path: str
        :keyword key_vault_secret_id:
        :paramtype key_vault_secret_id: str
        :keyword certificate_error:
        :paramtype certificate_error: ~azure.mgmt.nginx.models.NginxCertificateErrorResponseBody
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.key_virtual_path = key_virtual_path
        self.certificate_virtual_path = certificate_virtual_path
        self.key_vault_secret_id = key_vault_secret_id
        self.sha1_thumbprint = None
        self.key_vault_secret_version = None
        self.key_vault_secret_created = None
        self.certificate_error = certificate_error


class NginxConfigurationFile(_serialization.Model):
    """NginxConfigurationFile.

    :ivar content:
    :vartype content: str
    :ivar virtual_path:
    :vartype virtual_path: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "virtual_path": {"key": "virtualPath", "type": "str"},
    }

    def __init__(self, *, content: Optional[str] = None, virtual_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content:
        :paramtype content: str
        :keyword virtual_path:
        :paramtype virtual_path: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.virtual_path = virtual_path


class NginxConfigurationListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.nginx.models.NginxConfigurationResponse]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxConfigurationResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NginxConfigurationResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxConfigurationResponse]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxConfigurationPackage(_serialization.Model):
    """NginxConfigurationPackage.

    :ivar data:
    :vartype data: str
    :ivar protected_files:
    :vartype protected_files: list[str]
    """

    _attribute_map = {
        "data": {"key": "data", "type": "str"},
        "protected_files": {"key": "protectedFiles", "type": "[str]"},
    }

    def __init__(
        self, *, data: Optional[str] = None, protected_files: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword data:
        :paramtype data: str
        :keyword protected_files:
        :paramtype protected_files: list[str]
        """
        super().__init__(**kwargs)
        self.data = data
        self.protected_files = protected_files


class NginxConfigurationProtectedFileRequest(_serialization.Model):
    """NginxConfigurationProtectedFileRequest.

    :ivar content: The content of the protected file. This value is a PUT only value. If you
     perform a GET request on this value, it will be empty because it is a protected file.
    :vartype content: str
    :ivar virtual_path: The virtual path of the protected file.
    :vartype virtual_path: str
    :ivar content_hash: The hash of the content of the file. This value is used to determine if the
     file has changed.
    :vartype content_hash: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "content_hash": {"key": "contentHash", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        virtual_path: Optional[str] = None,
        content_hash: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the protected file. This value is a PUT only value. If you
         perform a GET request on this value, it will be empty because it is a protected file.
        :paramtype content: str
        :keyword virtual_path: The virtual path of the protected file.
        :paramtype virtual_path: str
        :keyword content_hash: The hash of the content of the file. This value is used to determine if
         the file has changed.
        :paramtype content_hash: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.virtual_path = virtual_path
        self.content_hash = content_hash


class NginxConfigurationProtectedFileResponse(_serialization.Model):
    """NginxConfigurationProtectedFileResponse.

    :ivar virtual_path: The virtual path of the protected file.
    :vartype virtual_path: str
    :ivar content_hash: The hash of the content of the file. This value is used to determine if the
     file has changed.
    :vartype content_hash: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "content_hash": {"key": "contentHash", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, content_hash: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: The virtual path of the protected file.
        :paramtype virtual_path: str
        :keyword content_hash: The hash of the content of the file. This value is used to determine if
         the file has changed.
        :paramtype content_hash: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.content_hash = content_hash


class NginxConfigurationRequest(_serialization.Model):
    """NginxConfigurationRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxConfigurationRequestProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxConfigurationRequestProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxConfigurationRequestProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxConfigurationRequestProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class NginxConfigurationRequestProperties(_serialization.Model):
    """NginxConfigurationRequestProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files: list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
    :ivar package:
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    :ivar root_file:
    :vartype root_file: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "files": {"key": "files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "protectedFiles", "type": "[NginxConfigurationProtectedFileRequest]"},
        "package": {"key": "package", "type": "NginxConfigurationPackage"},
        "root_file": {"key": "rootFile", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: Optional[List["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[List["_models.NginxConfigurationProtectedFileRequest"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        root_file: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
        :keyword package:
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        :keyword root_file:
        :paramtype root_file: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.files = files
        self.protected_files = protected_files
        self.package = package
        self.root_file = root_file


class NginxConfigurationResponse(_serialization.Model):
    """NginxConfigurationResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxConfigurationResponseProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxConfigurationResponseProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxConfigurationResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxConfigurationResponseProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class NginxConfigurationResponseProperties(_serialization.Model):
    """NginxConfigurationResponseProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files:
     list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileResponse]
    :ivar package:
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    :ivar root_file:
    :vartype root_file: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "files": {"key": "files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "protectedFiles", "type": "[NginxConfigurationProtectedFileResponse]"},
        "package": {"key": "package", "type": "NginxConfigurationPackage"},
        "root_file": {"key": "rootFile", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: Optional[List["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[List["_models.NginxConfigurationProtectedFileResponse"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        root_file: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileResponse]
        :keyword package:
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        :keyword root_file:
        :paramtype root_file: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.files = files
        self.protected_files = protected_files
        self.package = package
        self.root_file = root_file


class NginxDeployment(_serialization.Model):
    """NginxDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar identity:
    :vartype identity: ~azure.mgmt.nginx.models.IdentityProperties
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentProperties
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.nginx.models.ResourceSku
    :ivar location:
    :vartype location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "properties": {"key": "properties", "type": "NginxDeploymentProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        properties: Optional["_models.NginxDeploymentProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ResourceSku"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity:
        :paramtype identity: ~azure.mgmt.nginx.models.IdentityProperties
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentProperties
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.nginx.models.ResourceSku
        :keyword location:
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.identity = identity
        self.properties = properties
        self.tags = tags
        self.sku = sku
        self.location = location
        self.system_data = None


class NginxDeploymentApiKeyListResponse(_serialization.Model):
    """NginxDeploymentApiKeyListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponse]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeploymentApiKeyResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NginxDeploymentApiKeyResponse"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponse]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentApiKeyRequest(_serialization.Model):
    """NginxDeploymentApiKeyRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyRequestProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentApiKeyRequestProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentApiKeyRequestProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyRequestProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class NginxDeploymentApiKeyRequestProperties(_serialization.Model):
    """NginxDeploymentApiKeyRequestProperties.

    :ivar secret_text: Secret text to be used as a Dataplane API Key. This is a write only property
     that can never be read back, but the first three characters will be returned in the 'hint'
     property.
    :vartype secret_text: str
    :ivar end_date_time: The time after which this Dataplane API Key is no longer valid.
    :vartype end_date_time: ~datetime.datetime
    """

    _attribute_map = {
        "secret_text": {"key": "secretText", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, secret_text: Optional[str] = None, end_date_time: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_text: Secret text to be used as a Dataplane API Key. This is a write only
         property that can never be read back, but the first three characters will be returned in the
         'hint' property.
        :paramtype secret_text: str
        :keyword end_date_time: The time after which this Dataplane API Key is no longer valid.
        :paramtype end_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.secret_text = secret_text
        self.end_date_time = end_date_time


class NginxDeploymentApiKeyResponse(_serialization.Model):
    """NginxDeploymentApiKeyResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentApiKeyResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentApiKeyResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponseProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class NginxDeploymentApiKeyResponseProperties(_serialization.Model):
    """NginxDeploymentApiKeyResponseProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hint: The first three characters of the secret text to help identify it in use. This
     property is read-only.
    :vartype hint: str
    :ivar end_date_time: The time after which this Dataplane API Key is no longer valid.
    :vartype end_date_time: ~datetime.datetime
    """

    _validation = {
        "hint": {"readonly": True},
    }

    _attribute_map = {
        "hint": {"key": "hint", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
    }

    def __init__(self, *, end_date_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword end_date_time: The time after which this Dataplane API Key is no longer valid.
        :paramtype end_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.hint = None
        self.end_date_time = end_date_time


class NginxDeploymentListResponse(_serialization.Model):
    """NginxDeploymentListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeployment]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NginxDeployment"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeployment]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentProperties(_serialization.Model):
    """NginxDeploymentProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar nginx_version:
    :vartype nginx_version: str
    :ivar network_profile:
    :vartype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
    :ivar ip_address: The IP address of the deployment.
    :vartype ip_address: str
    :ivar enable_diagnostics_support:
    :vartype enable_diagnostics_support: bool
    :ivar logging:
    :vartype logging: ~azure.mgmt.nginx.models.NginxLogging
    :ivar scaling_properties: Information on how the deployment will be scaled.
    :vartype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
    :ivar auto_upgrade_profile: Autoupgrade settings of a deployment.
    :vartype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
    :ivar user_profile:
    :vartype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
    :ivar nginx_app_protect: Settings for NGINX App Protect (NAP).
    :vartype nginx_app_protect: ~azure.mgmt.nginx.models.NginxDeploymentPropertiesNginxAppProtect
    :ivar dataplane_api_endpoint: Dataplane API endpoint for the caller to update the NGINX state
     of the deployment.
    :vartype dataplane_api_endpoint: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "nginx_version": {"readonly": True},
        "ip_address": {"readonly": True},
        "dataplane_api_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "nginx_version": {"key": "nginxVersion", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NginxNetworkProfile"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "enable_diagnostics_support": {"key": "enableDiagnosticsSupport", "type": "bool"},
        "logging": {"key": "logging", "type": "NginxLogging"},
        "scaling_properties": {"key": "scalingProperties", "type": "NginxDeploymentScalingProperties"},
        "auto_upgrade_profile": {"key": "autoUpgradeProfile", "type": "AutoUpgradeProfile"},
        "user_profile": {"key": "userProfile", "type": "NginxDeploymentUserProfile"},
        "nginx_app_protect": {"key": "nginxAppProtect", "type": "NginxDeploymentPropertiesNginxAppProtect"},
        "dataplane_api_endpoint": {"key": "dataplaneApiEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.NginxNetworkProfile"] = None,
        enable_diagnostics_support: Optional[bool] = None,
        logging: Optional["_models.NginxLogging"] = None,
        scaling_properties: Optional["_models.NginxDeploymentScalingProperties"] = None,
        auto_upgrade_profile: Optional["_models.AutoUpgradeProfile"] = None,
        user_profile: Optional["_models.NginxDeploymentUserProfile"] = None,
        nginx_app_protect: Optional["_models.NginxDeploymentPropertiesNginxAppProtect"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile:
        :paramtype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
        :keyword enable_diagnostics_support:
        :paramtype enable_diagnostics_support: bool
        :keyword logging:
        :paramtype logging: ~azure.mgmt.nginx.models.NginxLogging
        :keyword scaling_properties: Information on how the deployment will be scaled.
        :paramtype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
        :keyword auto_upgrade_profile: Autoupgrade settings of a deployment.
        :paramtype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
        :keyword user_profile:
        :paramtype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
        :keyword nginx_app_protect: Settings for NGINX App Protect (NAP).
        :paramtype nginx_app_protect: ~azure.mgmt.nginx.models.NginxDeploymentPropertiesNginxAppProtect
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.nginx_version = None
        self.network_profile = network_profile
        self.ip_address = None
        self.enable_diagnostics_support = enable_diagnostics_support
        self.logging = logging
        self.scaling_properties = scaling_properties
        self.auto_upgrade_profile = auto_upgrade_profile
        self.user_profile = user_profile
        self.nginx_app_protect = nginx_app_protect
        self.dataplane_api_endpoint = None


class NginxDeploymentPropertiesNginxAppProtect(_serialization.Model):
    """Settings for NGINX App Protect (NAP).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar web_application_firewall_settings: Settings for the NGINX App Protect Web Application
     Firewall (WAF). Required.
    :vartype web_application_firewall_settings:
     ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
    :ivar web_application_firewall_status: The status of the NGINX App Protect Web Application
     Firewall.
    :vartype web_application_firewall_status: ~azure.mgmt.nginx.models.WebApplicationFirewallStatus
    """

    _validation = {
        "web_application_firewall_settings": {"required": True},
        "web_application_firewall_status": {"readonly": True},
    }

    _attribute_map = {
        "web_application_firewall_settings": {
            "key": "webApplicationFirewallSettings",
            "type": "WebApplicationFirewallSettings",
        },
        "web_application_firewall_status": {
            "key": "webApplicationFirewallStatus",
            "type": "WebApplicationFirewallStatus",
        },
    }

    def __init__(
        self, *, web_application_firewall_settings: "_models.WebApplicationFirewallSettings", **kwargs: Any
    ) -> None:
        """
        :keyword web_application_firewall_settings: Settings for the NGINX App Protect Web Application
         Firewall (WAF). Required.
        :paramtype web_application_firewall_settings:
         ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
        """
        super().__init__(**kwargs)
        self.web_application_firewall_settings = web_application_firewall_settings
        self.web_application_firewall_status = None


class NginxDeploymentScalingProperties(_serialization.Model):
    """Information on how the deployment will be scaled.

    :ivar capacity:
    :vartype capacity: int
    :ivar profiles:
    :vartype profiles: list[~azure.mgmt.nginx.models.ScaleProfile]
    """

    _attribute_map = {
        "capacity": {"key": "capacity", "type": "int"},
        "profiles": {"key": "autoScaleSettings.profiles", "type": "[ScaleProfile]"},
    }

    def __init__(
        self, *, capacity: Optional[int] = None, profiles: Optional[List["_models.ScaleProfile"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword capacity:
        :paramtype capacity: int
        :keyword profiles:
        :paramtype profiles: list[~azure.mgmt.nginx.models.ScaleProfile]
        """
        super().__init__(**kwargs)
        self.capacity = capacity
        self.profiles = profiles


class NginxDeploymentUpdateParameters(_serialization.Model):
    """NginxDeploymentUpdateParameters.

    :ivar identity:
    :vartype identity: ~azure.mgmt.nginx.models.IdentityProperties
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.nginx.models.ResourceSku
    :ivar location:
    :vartype location: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ResourceSku"] = None,
        location: Optional[str] = None,
        properties: Optional["_models.NginxDeploymentUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity:
        :paramtype identity: ~azure.mgmt.nginx.models.IdentityProperties
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.nginx.models.ResourceSku
        :keyword location:
        :paramtype location: str
        :keyword properties:
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.sku = sku
        self.location = location
        self.properties = properties


class NginxDeploymentUpdateProperties(_serialization.Model):
    """NginxDeploymentUpdateProperties.

    :ivar enable_diagnostics_support:
    :vartype enable_diagnostics_support: bool
    :ivar logging:
    :vartype logging: ~azure.mgmt.nginx.models.NginxLogging
    :ivar scaling_properties: Information on how the deployment will be scaled.
    :vartype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
    :ivar user_profile:
    :vartype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
    :ivar network_profile:
    :vartype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
    :ivar auto_upgrade_profile: Autoupgrade settings of a deployment.
    :vartype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
    :ivar nginx_app_protect: Update settings for NGINX App Protect (NAP).
    :vartype nginx_app_protect:
     ~azure.mgmt.nginx.models.NginxDeploymentUpdatePropertiesNginxAppProtect
    """

    _attribute_map = {
        "enable_diagnostics_support": {"key": "enableDiagnosticsSupport", "type": "bool"},
        "logging": {"key": "logging", "type": "NginxLogging"},
        "scaling_properties": {"key": "scalingProperties", "type": "NginxDeploymentScalingProperties"},
        "user_profile": {"key": "userProfile", "type": "NginxDeploymentUserProfile"},
        "network_profile": {"key": "networkProfile", "type": "NginxNetworkProfile"},
        "auto_upgrade_profile": {"key": "autoUpgradeProfile", "type": "AutoUpgradeProfile"},
        "nginx_app_protect": {"key": "nginxAppProtect", "type": "NginxDeploymentUpdatePropertiesNginxAppProtect"},
    }

    def __init__(
        self,
        *,
        enable_diagnostics_support: Optional[bool] = None,
        logging: Optional["_models.NginxLogging"] = None,
        scaling_properties: Optional["_models.NginxDeploymentScalingProperties"] = None,
        user_profile: Optional["_models.NginxDeploymentUserProfile"] = None,
        network_profile: Optional["_models.NginxNetworkProfile"] = None,
        auto_upgrade_profile: Optional["_models.AutoUpgradeProfile"] = None,
        nginx_app_protect: Optional["_models.NginxDeploymentUpdatePropertiesNginxAppProtect"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_diagnostics_support:
        :paramtype enable_diagnostics_support: bool
        :keyword logging:
        :paramtype logging: ~azure.mgmt.nginx.models.NginxLogging
        :keyword scaling_properties: Information on how the deployment will be scaled.
        :paramtype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
        :keyword user_profile:
        :paramtype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
        :keyword network_profile:
        :paramtype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
        :keyword auto_upgrade_profile: Autoupgrade settings of a deployment.
        :paramtype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
        :keyword nginx_app_protect: Update settings for NGINX App Protect (NAP).
        :paramtype nginx_app_protect:
         ~azure.mgmt.nginx.models.NginxDeploymentUpdatePropertiesNginxAppProtect
        """
        super().__init__(**kwargs)
        self.enable_diagnostics_support = enable_diagnostics_support
        self.logging = logging
        self.scaling_properties = scaling_properties
        self.user_profile = user_profile
        self.network_profile = network_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.nginx_app_protect = nginx_app_protect


class NginxDeploymentUpdatePropertiesNginxAppProtect(_serialization.Model):  # pylint: disable=name-too-long
    """Update settings for NGINX App Protect (NAP).

    :ivar web_application_firewall_settings: Settings for the NGINX App Protect Web Application
     Firewall (WAF).
    :vartype web_application_firewall_settings:
     ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
    """

    _attribute_map = {
        "web_application_firewall_settings": {
            "key": "webApplicationFirewallSettings",
            "type": "WebApplicationFirewallSettings",
        },
    }

    def __init__(
        self,
        *,
        web_application_firewall_settings: Optional["_models.WebApplicationFirewallSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword web_application_firewall_settings: Settings for the NGINX App Protect Web Application
         Firewall (WAF).
        :paramtype web_application_firewall_settings:
         ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
        """
        super().__init__(**kwargs)
        self.web_application_firewall_settings = web_application_firewall_settings


class NginxDeploymentUserProfile(_serialization.Model):
    """NginxDeploymentUserProfile.

    :ivar preferred_email: The preferred support contact email address of the user used for sending
     alerts and notification. Can be an empty string or a valid email address.
    :vartype preferred_email: str
    """

    _validation = {
        "preferred_email": {"pattern": r"^$|^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "preferred_email": {"key": "preferredEmail", "type": "str"},
    }

    def __init__(self, *, preferred_email: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword preferred_email: The preferred support contact email address of the user used for
         sending alerts and notification. Can be an empty string or a valid email address.
        :paramtype preferred_email: str
        """
        super().__init__(**kwargs)
        self.preferred_email = preferred_email


class NginxFrontendIPConfiguration(_serialization.Model):
    """NginxFrontendIPConfiguration.

    :ivar public_ip_addresses:
    :vartype public_ip_addresses: list[~azure.mgmt.nginx.models.NginxPublicIPAddress]
    :ivar private_ip_addresses:
    :vartype private_ip_addresses: list[~azure.mgmt.nginx.models.NginxPrivateIPAddress]
    """

    _attribute_map = {
        "public_ip_addresses": {"key": "publicIPAddresses", "type": "[NginxPublicIPAddress]"},
        "private_ip_addresses": {"key": "privateIPAddresses", "type": "[NginxPrivateIPAddress]"},
    }

    def __init__(
        self,
        *,
        public_ip_addresses: Optional[List["_models.NginxPublicIPAddress"]] = None,
        private_ip_addresses: Optional[List["_models.NginxPrivateIPAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_addresses:
        :paramtype public_ip_addresses: list[~azure.mgmt.nginx.models.NginxPublicIPAddress]
        :keyword private_ip_addresses:
        :paramtype private_ip_addresses: list[~azure.mgmt.nginx.models.NginxPrivateIPAddress]
        """
        super().__init__(**kwargs)
        self.public_ip_addresses = public_ip_addresses
        self.private_ip_addresses = private_ip_addresses


class NginxLogging(_serialization.Model):
    """NginxLogging.

    :ivar storage_account:
    :vartype storage_account: ~azure.mgmt.nginx.models.NginxStorageAccount
    """

    _attribute_map = {
        "storage_account": {"key": "storageAccount", "type": "NginxStorageAccount"},
    }

    def __init__(self, *, storage_account: Optional["_models.NginxStorageAccount"] = None, **kwargs: Any) -> None:
        """
        :keyword storage_account:
        :paramtype storage_account: ~azure.mgmt.nginx.models.NginxStorageAccount
        """
        super().__init__(**kwargs)
        self.storage_account = storage_account


class NginxNetworkInterfaceConfiguration(_serialization.Model):
    """NginxNetworkInterfaceConfiguration.

    :ivar subnet_id:
    :vartype subnet_id: str
    """

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
    }

    def __init__(self, *, subnet_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword subnet_id:
        :paramtype subnet_id: str
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id


class NginxNetworkProfile(_serialization.Model):
    """NginxNetworkProfile.

    :ivar front_end_ip_configuration:
    :vartype front_end_ip_configuration: ~azure.mgmt.nginx.models.NginxFrontendIPConfiguration
    :ivar network_interface_configuration:
    :vartype network_interface_configuration:
     ~azure.mgmt.nginx.models.NginxNetworkInterfaceConfiguration
    """

    _attribute_map = {
        "front_end_ip_configuration": {"key": "frontEndIPConfiguration", "type": "NginxFrontendIPConfiguration"},
        "network_interface_configuration": {
            "key": "networkInterfaceConfiguration",
            "type": "NginxNetworkInterfaceConfiguration",
        },
    }

    def __init__(
        self,
        *,
        front_end_ip_configuration: Optional["_models.NginxFrontendIPConfiguration"] = None,
        network_interface_configuration: Optional["_models.NginxNetworkInterfaceConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword front_end_ip_configuration:
        :paramtype front_end_ip_configuration: ~azure.mgmt.nginx.models.NginxFrontendIPConfiguration
        :keyword network_interface_configuration:
        :paramtype network_interface_configuration:
         ~azure.mgmt.nginx.models.NginxNetworkInterfaceConfiguration
        """
        super().__init__(**kwargs)
        self.front_end_ip_configuration = front_end_ip_configuration
        self.network_interface_configuration = network_interface_configuration


class NginxPrivateIPAddress(_serialization.Model):
    """NginxPrivateIPAddress.

    :ivar private_ip_address:
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.nginx.models.NginxPrivateIPAllocationMethod
    :ivar subnet_id:
    :vartype subnet_id: str
    """

    _attribute_map = {
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "privateIPAllocationMethod", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.NginxPrivateIPAllocationMethod"]] = None,
        subnet_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_ip_address:
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.nginx.models.NginxPrivateIPAllocationMethod
        :keyword subnet_id:
        :paramtype subnet_id: str
        """
        super().__init__(**kwargs)
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet_id = subnet_id


class NginxPublicIPAddress(_serialization.Model):
    """NginxPublicIPAddress.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class NginxStorageAccount(_serialization.Model):
    """NginxStorageAccount.

    :ivar account_name:
    :vartype account_name: str
    :ivar container_name:
    :vartype container_name: str
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
    }

    def __init__(
        self, *, account_name: Optional[str] = None, container_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword account_name:
        :paramtype account_name: str
        :keyword container_name:
        :paramtype container_name: str
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.container_name = container_name


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Nginx.NginxPlus.
    :vartype provider: str
    :ivar resource: Type on which the operation is performed, e.g., 'deployments'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Write deployments'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Nginx.NginxPlus.
        :paramtype provider: str
        :keyword resource: Type on which the operation is performed, e.g., 'deployments'.
        :paramtype resource: str
        :keyword operation: Operation type, e.g., read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation, e.g., 'Write deployments'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of GET request to list Nginx.NginxPlus operations.

    :ivar value: List of operations supported by the Nginx.NginxPlus provider.
    :vartype value: list[~azure.mgmt.nginx.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Nginx.NginxPlus provider.
        :paramtype value: list[~azure.mgmt.nginx.models.OperationResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResult(_serialization.Model):
    """A Nginx.NginxPlus REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.nginx.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.nginx.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action


class ResourceSku(_serialization.Model):
    """ResourceSku.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the SKU. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the SKU. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class ScaleProfile(_serialization.Model):
    """The autoscale profile.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar capacity: The capacity parameters of the profile. Required.
    :vartype capacity: ~azure.mgmt.nginx.models.ScaleProfileCapacity
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "ScaleProfileCapacity"},
    }

    def __init__(self, *, name: str, capacity: "_models.ScaleProfileCapacity", **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword capacity: The capacity parameters of the profile. Required.
        :paramtype capacity: ~azure.mgmt.nginx.models.ScaleProfileCapacity
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ScaleProfileCapacity(_serialization.Model):
    """The capacity parameters of the profile.

    All required parameters must be populated in order to send to server.

    :ivar min: The minimum number of NCUs the deployment can be autoscaled to. Required.
    :vartype min: int
    :ivar max: The maximum number of NCUs the deployment can be autoscaled to. Required.
    :vartype max: int
    """

    _validation = {
        "min": {"required": True, "minimum": 0},
        "max": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: The minimum number of NCUs the deployment can be autoscaled to. Required.
        :paramtype min: int
        :keyword max: The maximum number of NCUs the deployment can be autoscaled to. Required.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserIdentityProperties(_serialization.Model):
    """UserIdentityProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar client_id:
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class WebApplicationFirewallComponentVersions(_serialization.Model):
    """Versions of the NGINX App Protect Web Application Firewall (WAF) components.

    All required parameters must be populated in order to send to server.

    :ivar waf_engine_version: The version of the NGINX App Protect Web Application Firewall (WAF)
     engine. Required.
    :vartype waf_engine_version: str
    :ivar waf_nginx_version: The version of the NGINX App Protect Web Application Firewall (WAF)
     module for NGINX. Required.
    :vartype waf_nginx_version: str
    """

    _validation = {
        "waf_engine_version": {"required": True},
        "waf_nginx_version": {"required": True},
    }

    _attribute_map = {
        "waf_engine_version": {"key": "wafEngineVersion", "type": "str"},
        "waf_nginx_version": {"key": "wafNginxVersion", "type": "str"},
    }

    def __init__(self, *, waf_engine_version: str, waf_nginx_version: str, **kwargs: Any) -> None:
        """
        :keyword waf_engine_version: The version of the NGINX App Protect Web Application Firewall
         (WAF) engine. Required.
        :paramtype waf_engine_version: str
        :keyword waf_nginx_version: The version of the NGINX App Protect Web Application Firewall (WAF)
         module for NGINX. Required.
        :paramtype waf_nginx_version: str
        """
        super().__init__(**kwargs)
        self.waf_engine_version = waf_engine_version
        self.waf_nginx_version = waf_nginx_version


class WebApplicationFirewallPackage(_serialization.Model):
    """NGINX App Protect Web Application Firewall (WAF) Package. Contains the version and revision
    date of the package.

    All required parameters must be populated in order to send to server.

    :ivar version: The version of the NGINX App Protect Web Application Firewall (WAF) package.
     Required.
    :vartype version: str
    :ivar revision_datetime: The date and time of the package revision. Required.
    :vartype revision_datetime: ~datetime.datetime
    """

    _validation = {
        "version": {"required": True},
        "revision_datetime": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "revision_datetime": {"key": "revisionDatetime", "type": "iso-8601"},
    }

    def __init__(self, *, version: str, revision_datetime: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword version: The version of the NGINX App Protect Web Application Firewall (WAF) package.
         Required.
        :paramtype version: str
        :keyword revision_datetime: The date and time of the package revision. Required.
        :paramtype revision_datetime: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.version = version
        self.revision_datetime = revision_datetime


class WebApplicationFirewallSettings(_serialization.Model):
    """Settings for the NGINX App Protect Web Application Firewall (WAF).

    :ivar activation_state: The activation state of the WAF. Use 'Enabled' to enable the WAF and
     'Disabled' to disable it. Known values are: "Enabled" and "Disabled".
    :vartype activation_state: str or ~azure.mgmt.nginx.models.ActivationState
    """

    _attribute_map = {
        "activation_state": {"key": "activationState", "type": "str"},
    }

    def __init__(
        self, *, activation_state: Optional[Union[str, "_models.ActivationState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword activation_state: The activation state of the WAF. Use 'Enabled' to enable the WAF and
         'Disabled' to disable it. Known values are: "Enabled" and "Disabled".
        :paramtype activation_state: str or ~azure.mgmt.nginx.models.ActivationState
        """
        super().__init__(**kwargs)
        self.activation_state = activation_state


class WebApplicationFirewallStatus(_serialization.Model):
    """The status of the NGINX App Protect Web Application Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar attack_signatures_package: Package containing attack signatures for the NGINX App Protect
     Web Application Firewall (WAF).
    :vartype attack_signatures_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar bot_signatures_package: Package containing bot signatures for the NGINX App Protect Web
     Application Firewall (WAF).
    :vartype bot_signatures_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar threat_campaigns_package: Package containing threat campaigns for the NGINX App Protect
     Web Application Firewall (WAF).
    :vartype threat_campaigns_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar component_versions: Versions of the NGINX App Protect Web Application Firewall (WAF)
     components.
    :vartype component_versions: ~azure.mgmt.nginx.models.WebApplicationFirewallComponentVersions
    """

    _validation = {
        "attack_signatures_package": {"readonly": True},
        "bot_signatures_package": {"readonly": True},
        "threat_campaigns_package": {"readonly": True},
        "component_versions": {"readonly": True},
    }

    _attribute_map = {
        "attack_signatures_package": {"key": "attackSignaturesPackage", "type": "WebApplicationFirewallPackage"},
        "bot_signatures_package": {"key": "botSignaturesPackage", "type": "WebApplicationFirewallPackage"},
        "threat_campaigns_package": {"key": "threatCampaignsPackage", "type": "WebApplicationFirewallPackage"},
        "component_versions": {"key": "componentVersions", "type": "WebApplicationFirewallComponentVersions"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.attack_signatures_package = None
        self.bot_signatures_package = None
        self.threat_campaigns_package = None
        self.component_versions = None
