# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .catalog_item import CatalogItem


class USqlType(CatalogItem):
    """A Data Lake Analytics catalog U-SQL type item.

    :param compute_account_name: the name of the Data Lake Analytics account.
    :type compute_account_name: str
    :param version: the version of the catalog item.
    :type version: str
    :param database_name: the name of the database.
    :type database_name: str
    :param schema_name: the name of the schema associated with this table and
     database.
    :type schema_name: str
    :param name: the name of type for this type.
    :type name: str
    :param type_family: the type family for this type.
    :type type_family: str
    :param c_sharp_name: the C# name for this type.
    :type c_sharp_name: str
    :param full_csharp_name: the fully qualified C# name for this type.
    :type full_csharp_name: str
    :param system_type_id: the system type ID for this type.
    :type system_type_id: int
    :param user_type_id: the user type ID for this type.
    :type user_type_id: int
    :param schema_id: the schema ID for this type.
    :type schema_id: int
    :param principal_id: the principal ID for this type.
    :type principal_id: int
    :param is_nullable: the the switch indicating if this type is nullable.
    :type is_nullable: bool
    :param is_user_defined: the the switch indicating if this type is user
     defined.
    :type is_user_defined: bool
    :param is_assembly_type: the the switch indicating if this type is an
     assembly type.
    :type is_assembly_type: bool
    :param is_table_type: the the switch indicating if this type is a table
     type.
    :type is_table_type: bool
    :param is_complex_type: the the switch indicating if this type is a
     complex type.
    :type is_complex_type: bool
    """

    _attribute_map = {
        'compute_account_name': {'key': 'computeAccountName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'name': {'key': 'typeName', 'type': 'str'},
        'type_family': {'key': 'typeFamily', 'type': 'str'},
        'c_sharp_name': {'key': 'cSharpName', 'type': 'str'},
        'full_csharp_name': {'key': 'fullCSharpName', 'type': 'str'},
        'system_type_id': {'key': 'systemTypeId', 'type': 'int'},
        'user_type_id': {'key': 'userTypeId', 'type': 'int'},
        'schema_id': {'key': 'schemaId', 'type': 'int'},
        'principal_id': {'key': 'principalId', 'type': 'int'},
        'is_nullable': {'key': 'isNullable', 'type': 'bool'},
        'is_user_defined': {'key': 'isUserDefined', 'type': 'bool'},
        'is_assembly_type': {'key': 'isAssemblyType', 'type': 'bool'},
        'is_table_type': {'key': 'isTableType', 'type': 'bool'},
        'is_complex_type': {'key': 'isComplexType', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(USqlType, self).__init__(**kwargs)
        self.database_name = kwargs.get('database_name', None)
        self.schema_name = kwargs.get('schema_name', None)
        self.name = kwargs.get('name', None)
        self.type_family = kwargs.get('type_family', None)
        self.c_sharp_name = kwargs.get('c_sharp_name', None)
        self.full_csharp_name = kwargs.get('full_csharp_name', None)
        self.system_type_id = kwargs.get('system_type_id', None)
        self.user_type_id = kwargs.get('user_type_id', None)
        self.schema_id = kwargs.get('schema_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.is_nullable = kwargs.get('is_nullable', None)
        self.is_user_defined = kwargs.get('is_user_defined', None)
        self.is_assembly_type = kwargs.get('is_assembly_type', None)
        self.is_table_type = kwargs.get('is_table_type', None)
        self.is_complex_type = kwargs.get('is_complex_type', None)
