(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    459494,       7431]
NotebookOptionsPosition[    458342,       7393]
NotebookOutlinePosition[    458679,       7408]
CellTagsIndexPosition[    458636,       7405]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Create masses.h using online isotope data from wolfram.com", "Title",
 CellChangeTimes->{{3.4135852563406*^9, 3.413585275286303*^9}, {
  3.41358542206135*^9, 3.41358546024609*^9}}],

Cell["Author : Martin Torheyden (mtorhey at vt period edu)", "Subsubtitle",
 CellChangeTimes->{{3.413585547167658*^9, 3.413585566334443*^9}}],

Cell["\<\
The sources of data are described at \
http://reference.wolfram.com/mathematica/note/IsotopeDataSourceInformation.\
html

The sources of data as listed on March 3, 2008:

Atomic Mass Data Center.\"NUBASE.\" 2003. \[RightGuillemet]
Firestone, R.B.\"The Berkeley Laboratory Isotopes Project's: Exploring the \
Table of Isotopes.\" 2000. \[RightGuillemet]
Raghavan, P.\"Table of Nuclear Moments.\" Atomic Data and Nuclear Data Tables \
42, no.2 (1989) : 189 - 291.
Sansonetti, J.E.and W.C.Martin.\"NIST Handbook of Basic Atomic Spectroscopic \
Data.\" 2005. \[RightGuillemet]
United States National Institute of Standards and Technology.\"Atomic Weights \
and Isotopic Compositions Elements.\" 2005. \[RightGuillemet]
United States National Nuclear Data Center, Brookhaven National \
Laboratory.\"Nuclear Wallet Cards\" 2007. \[RightGuillemet]
United States National Nuclear Data Center, Brookhaven National \
Laboratory.\"NuDat 2.3.\" 2007. \[RightGuillemet]\
\>", "Text",
 CellChangeTimes->{{3.413585477583881*^9, 3.413585533365624*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"extractPsiSymbol", "[", "isotopesymbol_", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"chemsymb", ",", "massnumber", ",", "psisymbol"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"chemsymb", "=", 
        RowBox[{"ToUpperCase", "[", 
         RowBox[{"isotopesymbol", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"massnumber", "=", 
        RowBox[{"isotopesymbol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"psisymbol", "=", 
        RowBox[{"StringJoin", "[", 
         RowBox[{"chemsymb", ",", 
          RowBox[{"ToString", "[", "massnumber", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "psisymbol", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getIsotopeData", "[", "atomname_", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "atomsymbol", ",", "isotopename", ",", "i", ",", "isotopesymbol", ",", 
        "psisymbol", ",", "isotopemass", ",", "isotopeabundance", ",", 
        "isotopeHalfLife", ",", "isotopedata"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"atomsymbol", "=", 
        RowBox[{"ToUpperCase", "[", 
         RowBox[{"ElementData", "[", 
          RowBox[{"atomname", ",", "\"\<Symbol\>\""}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<atomsymbol=\>\"", ",", "atomsymbol"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"isotopename", "=", 
        RowBox[{"IsotopeData", "[", "atomname", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"isotopedata", "=", 
        RowBox[{"{", 
         RowBox[{"atomsymbol", ",", 
          RowBox[{"{", "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "isotopename", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"isotopesymbol", "=", 
           RowBox[{"IsotopeData", "[", 
            RowBox[{
             RowBox[{"isotopename", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<Symbol\>\""}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<isotopesymbol=\>\"", ",", "isotopesymbol"}], "]"}], 
            ";"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"psisymbol", "=", 
           RowBox[{"extractPsiSymbol", "[", "isotopesymbol", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<psisymbol=\>\"", ",", "psisymbol"}], "]"}], ";"}], 
           "*)"}], "\[IndentingNewLine]", 
          RowBox[{"isotopemass", "=", 
           RowBox[{"IsotopeData", "[", 
            RowBox[{
             RowBox[{"isotopename", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<AtomicMass\>\""}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<isotopemass=\>\"", ",", "isotopemass"}], "]"}], 
            ";"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"isotopeabundance", "=", 
           RowBox[{"IsotopeData", "[", 
            RowBox[{
             RowBox[{"isotopename", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             "\"\<IsotopeAbundance\>\""}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<isotopeabundance=\>\"", ",", "isotopeabundance"}], 
             "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"isotopeHalfLife", "=", 
           RowBox[{"IsotopeData", "[", 
            RowBox[{
             RowBox[{"isotopename", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<HalfLife\>\""}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{"\"\<isotopeHalfLife=\>\"", ",", "isotopeHalfLife"}], 
             "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NumberQ", "[", "isotopemass", "]"}], "&&", 
             RowBox[{"NumberQ", "[", "isotopeabundance", "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"isotopedata", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "=", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"isotopedata", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                 "psisymbol", ",", "isotopemass", ",", "isotopeabundance", 
                  ",", "isotopeHalfLife"}], "}"}]}], "]"}]}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<isotopedata=\>\"", ",", "isotopedata"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "isotopedata", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getIsotopes", "[", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"atomname", ",", "atomsymbol", ",", "i", ",", "isotopes"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"atomname", "=", 
        RowBox[{"ElementData", "[", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<atomname=\>\"", ",", "atomname"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"isotopes", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "atomname", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"getIsotopeData", "[", 
            RowBox[{"atomname", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"isotopes", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"isotopes", ",", 
             RowBox[{"getIsotopeData", "[", 
              RowBox[{"atomname", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "isotopes", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InsertListintoListofLists", "[", 
     RowBox[{"OldlistofLists_List", ",", "ToInsert_List", ",", "pos_"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"NewlistofLists", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NewlistofLists", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"pos", "-", "1"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"NewlistofLists", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"NewlistofLists", ",", 
             RowBox[{"OldlistofLists", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"NewlistofLists", "=", 
        RowBox[{"Append", "[", 
         RowBox[{"NewlistofLists", ",", "ToInsert"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "pos"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "OldlistofLists", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"NewlistofLists", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"NewlistofLists", ",", 
             RowBox[{"OldlistofLists", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "NewlistofLists", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"isstableIsotope", "[", "isotope_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"isstable", ",", "i"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"isstable", "=", "False"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", 
           RowBox[{"isotope", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"isotope", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "i", ",", "4"}], "]"}], "]"}], "===", 
             "Infinity"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"isstable", "=", "True"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "isstable", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"isnaturallyoccurringIsotope", "[", "isotope_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sum", ",", "isnaturallyoccurring", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sum", "=", "0.0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", 
           RowBox[{"isotope", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"sum", "=", 
           RowBox[{"sum", "+", 
            RowBox[{"isotope", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "i", ",", "3"}], "]"}], "]"}]}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<sum=\>\"", ",", "sum"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"sum", ">", "0.1"}], ",", "\[IndentingNewLine]", 
         RowBox[{"isnaturallyoccurring", "=", "True"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"isnaturallyoccurring", "=", "False"}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "isnaturallyoccurring", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getMostStableIsotope", "[", "isotope_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"moststableindex", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"moststableindex", "=", "1"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "2"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", 
           RowBox[{"isotope", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"isotope", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "i", ",", "4"}], "]"}], "]"}], ">", 
             RowBox[{"isotope", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "moststableindex", ",", "4"}], "]"}], 
              "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"moststableindex", "=", "i"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"isotope", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "moststableindex"}], "]"}], "]"}], "]"}], ";"}]}],
      "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getMostAbundantIsotope", "[", "isotope_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"mostabundantindex", ",", "i"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"mostabundantindex", "=", "1"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "2"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", 
           RowBox[{"isotope", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"isotope", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "i", ",", "3"}], "]"}], "]"}], ">", 
             RowBox[{"isotope", "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "mostabundantindex", ",", "3"}], "]"}], 
              "]"}]}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"mostabundantindex", "=", "i"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"isotope", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "mostabundantindex"}], "]"}], "]"}], "]"}], 
       ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getMostCommonIsotope", "[", "isotope_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "mostcommonisotope", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"isnaturallyoccurringIsotope", "[", "isotope", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"mostcommonisotope", "=", 
          RowBox[{"getMostAbundantIsotope", "[", "isotope", "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"mostcommonisotope", "=", 
           RowBox[{"getMostStableIsotope", "[", "isotope", "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "mostcommonisotope", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getTotalNumberofIsotopes", "[", "isotopes_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "numofisotopes"}], "}"}], ",", "\[IndentingNewLine]",
       
      RowBox[{
       RowBox[{"numofisotopes", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "isotopes", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"numofisotopes", "=", 
           RowBox[{"numofisotopes", "+", 
            RowBox[{"Length", "[", 
             RowBox[{"isotopes", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}]}], ";"}]}], 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{
            RowBox[{"isotopes", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
            "\"\< Number of isotopes =\>\"", ",", 
            RowBox[{"Length", "[", 
             RowBox[{"isotopes", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}], ";"}], 
         "*)"}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "numofisotopes", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getMostCommonIsotopeMassList", "[", "isotopes_List", "]"}], ":=",
     
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"masslist", ",", "i"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"masslist", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", " ", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "isotopes", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"masslist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"masslist", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"isotopes", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"getMostCommonIsotope", "[", 
                 RowBox[{"isotopes", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", "masslist", "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "masslist", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"getIsotopeMassList", "[", "isotopes_List", "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"masslist", ",", "i", ",", "j", ",", "mostcommonisotope"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"masslist", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", " ", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "isotopes", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"mostcommonisotope", "=", 
           RowBox[{"getMostCommonIsotope", "[", 
            RowBox[{"isotopes", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"masslist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"masslist", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"isotopes", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"mostcommonisotope", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", 
             RowBox[{"Length", "[", 
              RowBox[{"isotopes", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"masslist", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"masslist", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"isotopes", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2", ",", "j", ",", "1"}], "]"}], "]"}],
                   ",", 
                  RowBox[{"isotopes", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2", ",", "j", ",", "2"}], "]"}], 
                   "]"}]}], "}"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", "masslist", "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<Length[masslist]=\>\"", ",", 
           RowBox[{"Length", "[", "masslist", "]"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "masslist", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"createIsotopeAliases", "[", 
     RowBox[{"isotopes_List", ",", "aliases_List"}], "]"}], ":=", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "j", ",", "k", ",", "subst", ",", "isot", ",", 
        "isotopesnew"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"isotopesnew", "=", "isotopes"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", 
          RowBox[{"Length", "[", "aliases", "]"}]}], ",", 
         RowBox[{"i", "++"}], ",", "  ", 
         RowBox[{"(*", " ", 
          RowBox[{"loop", " ", "over", " ", "different", " ", "aliases"}], 
          " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "1"}], ",", 
            RowBox[{"j", "\[LessEqual]", 
             RowBox[{"Length", "[", "isotopesnew", "]"}]}], ",", " ", 
            RowBox[{"j", "++"}], ",", "  ", 
            RowBox[{"(*", " ", 
             RowBox[{
             "loop", " ", "over", " ", "different", " ", "atomtypes"}], " ", 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"For", "[", 
              RowBox[{
               RowBox[{"k", "=", "1"}], ",", 
               RowBox[{"k", "\[LessEqual]", 
                RowBox[{"Length", "[", 
                 RowBox[{"isotopesnew", "[", 
                  RowBox[{"[", 
                   RowBox[{"j", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
               RowBox[{"k", "++"}], ",", " ", 
               RowBox[{"(*", " ", 
                RowBox[{
                "loop", " ", "over", " ", "different", " ", "isotopesnew"}], 
                " ", "*)"}], "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"Print", "[", 
                  RowBox[{"isotopesnew", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "k"}], "]"}], "]"}], "]"}], 
                 ";"}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"aliases", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "===", 
                   RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "k", ",", "1"}], "]"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"isot", "=", 
                    RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<isot=\>\"", ",", "isot"}], "]"}], ";"}], 
                    "*)"}], "\[IndentingNewLine]", 
                   RowBox[{"subst", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"aliases", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "k", ",", "2"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "k", ",", "3"}], "]"}], "]"}],
                     ",", 
                    RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "2", ",", "k", ",", "4"}], "]"}], 
                    "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<subst=\>\"", ",", "subst"}], "]"}], ";"}], 
                    "*)"}], "\[IndentingNewLine]", "  ", 
                   RowBox[{
                    RowBox[{"isot", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "=", 
                    RowBox[{"InsertListintoListofLists", "[", 
                    RowBox[{
                    RowBox[{"isot", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "subst", ",", 
                    RowBox[{"k", "+", "1"}]}], "]"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<isot=\>\"", ",", "isot"}], "]"}], ";"}], 
                    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                   RowBox[{"isotopesnew", "=", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"isotopesnew", ",", 
                    RowBox[{"{", "j", "}"}]}], "]"}]}], ";", 
                   "\[IndentingNewLine]", 
                   RowBox[{"isotopesnew", "=", 
                    RowBox[{"InsertListintoListofLists", "[", 
                    RowBox[{"isotopesnew", ",", "isot", ",", "j"}], "]"}]}], 
                   ";", "\[IndentingNewLine]", 
                   RowBox[{"(*", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    RowBox[{"\"\<isotopesnew[[j]]=\>\"", ",", 
                    RowBox[{"isotopesnew", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ";"}], "*)"}], 
                   "\[IndentingNewLine]", 
                   RowBox[{"j", "=", 
                    RowBox[{"j", "+", "1"}]}], ";"}]}], "\[IndentingNewLine]",
                  "]"}], ";"}]}], "\[IndentingNewLine]", 
              "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "isotopesnew", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"printPsiElementData", "[", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "isotopes", ",", "mostcommonisotopemasslist", ",", "isotopemasslist", 
       ",", "mostcommonisotopemasslistLabels", ",", 
       "mostcommonisotopemasslistValues", ",", "isotopemasslistLabels", ",", 
       "isotopemasslistValues", ",", "i", ",", "j", ",", 
       "labelstoberemoved"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"isotopes", "=", 
       RowBox[{"getIsotopes", "[", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"isotopes", "=", 
       RowBox[{"createIsotopeAliases", "[", 
        RowBox[{"isotopes", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<H2\>\"", ",", "\"\<D\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<H3\>\"", ",", "\"\<T\>\""}], "}"}]}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"isotopes", "=", 
       RowBox[{"InsertListintoListofLists", "[", 
        RowBox[{"isotopes", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<X\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
             "\"\<X0\>\"", ",", "0.0000", ",", "1.0", ",", "Infinity"}], 
             "}"}], "}"}]}], "}"}], ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"mostcommonisotopemasslist", "=", 
       RowBox[{"getMostCommonIsotopeMassList", "[", "isotopes", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<mostcommonisotopemasslist=\>\"", ",", 
          "mostcommonisotopemasslist"}], "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"isotopemasslist", "=", 
       RowBox[{"getIsotopeMassList", "[", "isotopes", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Isotope", " ", "X", " ", "and", " ", "X0", " ", "should", " ", "not", 
        " ", "be", " ", "in", " ", "the", " ", "isotopemasslist"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"labelstoberemoved", "=", 
       RowBox[{"{", 
        RowBox[{"\"\<X\>\"", ",", "\"\<X0\>\""}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length before X removal = \>\"", ",", 
        RowBox[{"Length", "[", "isotopemasslist", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", "1"}], ",", 
        RowBox[{"j", "\[LessEqual]", 
         RowBox[{"Length", "[", "labelstoberemoved", "]"}]}], ",", " ", 
        RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"i", "=", "1"}], ",", 
           RowBox[{"i", "\[LessEqual]", 
            RowBox[{"Length", "[", "isotopemasslist", "]"}]}], ",", 
           RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"isotopemasslist", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "===", 
               RowBox[{"labelstoberemoved", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              
              RowBox[{
               RowBox[{"isotopemasslist", "=", 
                RowBox[{"Drop", "[", 
                 RowBox[{"isotopemasslist", ",", 
                  RowBox[{"{", "i", "}"}]}], "]"}]}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length after X removal = \>\"", ",", 
        RowBox[{"Length", "[", "isotopemasslist", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<isotopemasslist=\>\"", ",", "isotopemasslist"}], "]"}], 
        ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Now", " ", "all", " ", "the", " ", "necessary", " ", "data", " ", 
        "are", " ", "in", " ", "mostcommonisotopemasslist", " ", "and", " ", 
        RowBox[{"isotopemasslist", ".", " ", "Printing"}], " ", 
        RowBox[{"out", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"mostcommonisotopemasslistLabels", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mostcommonisotopemasslistValues", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "mostcommonisotopemasslist", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mostcommonisotopemasslistLabels", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"mostcommonisotopemasslistLabels", ",", 
            RowBox[{"mostcommonisotopemasslist", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"mostcommonisotopemasslistLabels", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<\\\"\>\"", ",", 
            RowBox[{"mostcommonisotopemasslistLabels", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<\\\"\>\""}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{"StringJoin", "["}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"mostcommonisotopemasslistValues", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"mostcommonisotopemasslistValues", ",", 
            RowBox[{"mostcommonisotopemasslist", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<#define LAST_ATOMIC_INDEX (\>\"", ",", 
        RowBox[{
         RowBox[{"Length", "[", "mostcommonisotopemasslist", "]"}], "-", 
         "1"}], ",", "\"\<)\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<static const char *atomic_labels[] =\>\"", ",", 
        "mostcommonisotopemasslistLabels"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<static double an2masses[] =\>\"", ",", 
        "mostcommonisotopemasslistValues"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"isotopemasslistLabels", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"isotopemasslistValues", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "isotopemasslist", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"isotopemasslistLabels", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"isotopemasslistLabels", ",", 
            RowBox[{"isotopemasslist", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"isotopemasslistLabels", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "=", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<\\\"\>\"", ",", 
            RowBox[{"isotopemasslistLabels", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "\"\<\\\"\>\""}], "]"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"isotopemasslistValues", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"isotopemasslistValues", ",", 
            RowBox[{"isotopemasslist", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<#define LAST_MASS_INDEX (\>\"", ",", 
        RowBox[{
         RowBox[{"Length", "[", "isotopemasslist", "]"}], "-", "1"}], ",", 
        "\"\<)\>\""}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<static const char *mass_labels[] =\>\"", ",", "isotopemasslistLabels"}],
        "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<static double atomic_masses[] =\>\"", ",", 
        "isotopemasslistValues"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "\"\<\>\"", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[mostcommonisotopemasslist]=\>\"", ",", 
        RowBox[{"Length", "[", "mostcommonisotopemasslist", "]"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[mostcommonisotopemasslistLabels]=\>\"", ",", 
        RowBox[{"Length", "[", "mostcommonisotopemasslistLabels", "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[mostcommonisotopemasslistValues]=\>\"", ",", 
        RowBox[{"Length", "[", "mostcommonisotopemasslistValues", "]"}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[isotopemasslist]=\>\"", ",", 
        RowBox[{"Length", "[", "isotopemasslist", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[isotopemasslistLabels]=\>\"", ",", 
        RowBox[{"Length", "[", "isotopemasslistLabels", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length[isotopemasslistValues]=\>\"", ",", 
        RowBox[{"Length", "[", "isotopemasslistValues", "]"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4131393673688517`*^9, 3.41313941916416*^9}, {
   3.413139569804329*^9, 3.413139610716476*^9}, {3.4131397475123787`*^9, 
   3.4131399373914003`*^9}, {3.413140525355842*^9, 3.4131406417694197`*^9}, {
   3.413140783058135*^9, 3.413140784849597*^9}, {3.413140825530065*^9, 
   3.413140828329575*^9}, {3.413140874953827*^9, 3.413140973738509*^9}, {
   3.4131410362776747`*^9, 3.413141047299595*^9}, {3.413141142837582*^9, 
   3.413141207547532*^9}, {3.4131412416150703`*^9, 3.4131413005551233`*^9}, {
   3.4131413485571327`*^9, 3.413141397963377*^9}, {3.41314142847215*^9, 
   3.413141435379178*^9}, {3.4131415093358183`*^9, 3.413141574427257*^9}, {
   3.413141692987729*^9, 3.4131418873287992`*^9}, {3.413141921815049*^9, 
   3.413141948964773*^9}, {3.413141988632128*^9, 3.4131421330638027`*^9}, {
   3.413142342539447*^9, 3.413142436647648*^9}, {3.413475004662019*^9, 
   3.413475046730441*^9}, {3.4134750892543907`*^9, 3.413475094029565*^9}, {
   3.413475343363826*^9, 3.413475354514701*^9}, {3.413475536240918*^9, 
   3.413475577043065*^9}, {3.41347571850375*^9, 3.413475722748588*^9}, {
   3.413478555957595*^9, 3.413478556393615*^9}, {3.4134786143800087`*^9, 
   3.413478788532113*^9}, {3.413478835002716*^9, 3.413478880602845*^9}, {
   3.413478935484145*^9, 3.413479036902149*^9}, {3.413479161692285*^9, 
   3.413479200223113*^9}, {3.413479243254827*^9, 3.413479260622363*^9}, {
   3.413479430593487*^9, 3.413479435487073*^9}, {3.413479475710033*^9, 
   3.413479502517375*^9}, {3.413479585023543*^9, 3.413479616407411*^9}, {
   3.413479761683825*^9, 3.413479772587543*^9}, {3.413479810827602*^9, 
   3.413479924472815*^9}, {3.413479960859565*^9, 3.413480055229439*^9}, {
   3.413480102879628*^9, 3.4134801372099533`*^9}, {3.413480296951331*^9, 
   3.413480418112471*^9}, {3.413480496217235*^9, 3.413480561832039*^9}, {
   3.413480617535014*^9, 3.413480674990498*^9}, {3.413480705362397*^9, 
   3.4134808736760607`*^9}, {3.4134809604981937`*^9, 3.413481050304886*^9}, {
   3.413481168157864*^9, 3.4134812377995443`*^9}, {3.413481278611644*^9, 
   3.413481330306196*^9}, {3.413481399799945*^9, 3.413481415599234*^9}, {
   3.4134816141006613`*^9, 3.413481704961832*^9}, {3.413481921708015*^9, 
   3.413481955152872*^9}, {3.413482479393309*^9, 3.4134825687273293`*^9}, {
   3.413482628258396*^9, 3.413482679345809*^9}, {3.413482717789613*^9, 
   3.4134827658341503`*^9}, {3.4134828065647078`*^9, 3.41348290191521*^9}, 
   3.413482988923567*^9, {3.413483121500041*^9, 3.4134831545622063`*^9}, {
   3.4134833026527653`*^9, 3.41348338552398*^9}, {3.413484048884914*^9, 
   3.413484081888625*^9}, {3.413484135683403*^9, 3.413484267621097*^9}, {
   3.413484367872499*^9, 3.413484515886063*^9}, {3.413484560399414*^9, 
   3.413484611165732*^9}, {3.413484766729349*^9, 3.4134847689430656`*^9}, {
   3.4134848166134253`*^9, 3.41348483079416*^9}, {3.413484889890603*^9, 
   3.413484998143979*^9}, {3.413485049471938*^9, 3.413485052805813*^9}, {
   3.413485090016687*^9, 3.4134851348464317`*^9}, {3.413485192402025*^9, 
   3.413485251143078*^9}, {3.4134853306026983`*^9, 3.413485332543037*^9}, {
   3.4134853849601107`*^9, 3.413485632752931*^9}, {3.4134857489081993`*^9, 
   3.413485764336113*^9}, {3.413486592761751*^9, 3.4134870275552883`*^9}, {
   3.4134870818173847`*^9, 3.4134870949524927`*^9}, {3.413489586176055*^9, 
   3.413489601648313*^9}, {3.413489641846491*^9, 3.413489651321068*^9}, {
   3.413489687827881*^9, 3.413489796515791*^9}, {3.413489869500197*^9, 
   3.413489890534243*^9}, {3.413546058890954*^9, 3.413546061619802*^9}, {
   3.413546623281167*^9, 3.413546750343981*^9}, {3.413546907874934*^9, 
   3.413546998900835*^9}, {3.413547048871574*^9, 3.413547116469769*^9}, {
   3.413547151714353*^9, 3.413547166660715*^9}, {3.413547300794478*^9, 
   3.413547305073135*^9}, {3.413547590124029*^9, 3.413547652867084*^9}, {
   3.4135478484501963`*^9, 3.4135478534258547`*^9}, {3.41354792643921*^9, 
   3.4135479438097143`*^9}, {3.4135479938151627`*^9, 3.413548022941702*^9}, {
   3.4135481232819767`*^9, 3.4135481307084913`*^9}, {3.413548365531704*^9, 
   3.41354836859851*^9}, 3.413548484443288*^9, 3.413548548064204*^9, {
   3.4135485869065447`*^9, 3.413548600669506*^9}, {3.4135486394182587`*^9, 
   3.413548721720171*^9}, {3.413548760682548*^9, 3.413548839625416*^9}, {
   3.413548957181341*^9, 3.413548991272584*^9}, {3.41354912749089*^9, 
   3.41354914003295*^9}, {3.4135491976604958`*^9, 3.413549223576086*^9}, {
   3.4135493726057863`*^9, 3.413549446868451*^9}, {3.413549555126693*^9, 
   3.413549556236909*^9}, {3.413549979042234*^9, 3.413549990451598*^9}, {
   3.4135509070883408`*^9, 3.413550915428265*^9}, {3.413550951207329*^9, 
   3.4135510028711367`*^9}, {3.413551073058528*^9, 3.413551140208913*^9}, {
   3.413551178029686*^9, 3.4135512689265223`*^9}, {3.4135516708935204`*^9, 
   3.4135516749892893`*^9}, {3.4135517966130247`*^9, 
   3.4135517996769247`*^9}, {3.4135518611036177`*^9, 3.413551869649075*^9}, {
   3.413552324223509*^9, 3.41355234439401*^9}, {3.413552432199007*^9, 
   3.413552443795348*^9}, {3.41355277677043*^9, 3.413552813038274*^9}, {
   3.413552851953198*^9, 3.413552868463477*^9}, {3.413552931526065*^9, 
   3.413552939977234*^9}, {3.413558712486709*^9, 3.413558726755106*^9}, {
   3.413558790743857*^9, 3.413558822836842*^9}, {3.41355918626306*^9, 
   3.413559191107547*^9}, {3.413559232855653*^9, 3.4135592640239887`*^9}, {
   3.4135593044037247`*^9, 3.41355940656597*^9}, {3.413559465421845*^9, 
   3.413559557321834*^9}, {3.413559734825375*^9, 3.4135597918712187`*^9}, {
   3.4135598466431713`*^9, 3.413559862645578*^9}, {3.413559922721602*^9, 
   3.4135599230948963`*^9}, {3.413560338269308*^9, 3.4135605702425327`*^9}, {
   3.4135606246757517`*^9, 3.413560686062182*^9}, {3.4135614714705753`*^9, 
   3.4135616157664957`*^9}, {3.413561647527377*^9, 3.413561839207988*^9}, {
   3.413561978133854*^9, 3.413561985221634*^9}, {3.413562018455887*^9, 
   3.413562141704179*^9}, {3.413562643556477*^9, 3.413562716202118*^9}, {
   3.413562747655981*^9, 3.413562892362095*^9}, {3.413563616217396*^9, 
   3.4135636171831427`*^9}, {3.4135637317113647`*^9, 3.413563734551166*^9}, 
   3.413563802086363*^9, {3.4135640772546873`*^9, 3.4135640853890867`*^9}, {
   3.4135643549279118`*^9, 3.413564646644898*^9}, {3.4135647418697968`*^9, 
   3.4135647448759003`*^9}, {3.413564805198477*^9, 3.413564824516077*^9}, {
   3.413564951708799*^9, 3.413564969397382*^9}, {3.413565015443989*^9, 
   3.413565018833145*^9}, {3.413565622930808*^9, 3.413565920720792*^9}, {
   3.4135660105333*^9, 3.413566034978591*^9}, {3.413566159730139*^9, 
   3.413566227223329*^9}, {3.413566269212123*^9, 3.413566411042747*^9}, {
   3.413566442600657*^9, 3.4135664519173393`*^9}, {3.41356649279576*^9, 
   3.4135665600354557`*^9}, {3.413566668045795*^9, 3.4135666791171494`*^9}, {
   3.413566773065806*^9, 3.413566803966066*^9}, {3.413566997138301*^9, 
   3.413567074855006*^9}, {3.413567154873065*^9, 3.41356716728621*^9}, {
   3.413567329071445*^9, 3.413567430179702*^9}, {3.413567472964242*^9, 
   3.413567538463979*^9}, {3.4135676137172832`*^9, 3.4135677913247337`*^9}, {
   3.413567865439507*^9, 3.413567881936265*^9}, {3.413567913206581*^9, 
   3.413567969867784*^9}, {3.41356845508742*^9, 3.413568639532349*^9}, {
   3.413568697589072*^9, 3.413568704981916*^9}, {3.41356980857857*^9, 
   3.413570039521883*^9}, {3.413570139428604*^9, 3.413570423155883*^9}, {
   3.413570472520732*^9, 3.413570678560197*^9}, 3.4135709205645*^9, 
   3.413571027813122*^9, 3.413571084599846*^9, 3.41357113141431*^9, {
   3.4135713199124117`*^9, 3.413571368377575*^9}, {3.413571415310601*^9, 
   3.413571416946505*^9}, {3.413571484909307*^9, 3.41357149805282*^9}, {
   3.413571540862545*^9, 3.413571541364448*^9}, {3.413571615593464*^9, 
   3.413571680510373*^9}, {3.41357173798699*^9, 3.413571787287669*^9}, {
   3.413571905166071*^9, 3.413571947683629*^9}, {3.413572127165402*^9, 
   3.413572197644837*^9}, {3.4135722511384687`*^9, 3.413572481585951*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"printPsiElementData", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.413141617863195*^9, 3.4131416202199793`*^9}, 
   3.413141971392407*^9, {3.4134787989894447`*^9, 3.413478816935302*^9}, {
   3.413483401889043*^9, 3.413483435368001*^9}, {3.413484275201057*^9, 
   3.413484356041068*^9}, {3.413484718596257*^9, 3.413484724257*^9}, 
   3.413549244409225*^9, {3.413549472273233*^9, 3.413549489521262*^9}, {
   3.413549708814275*^9, 3.413549723168865*^9}, {3.41354976990886*^9, 
   3.4135498498096237`*^9}, 3.4135501790608892`*^9, {3.413551284069042*^9, 
   3.413551288391345*^9}, {3.413551846884149*^9, 3.413551848210005*^9}, {
   3.413551973988432*^9, 3.4135519844171133`*^9}, {3.4135595730685368`*^9, 
   3.413559691194442*^9}, 3.413560034042862*^9, {3.4135602738694887`*^9, 
   3.4135602851864443`*^9}, {3.41356071706796*^9, 3.4135607850751133`*^9}, {
   3.413560897222191*^9, 3.4135609385946903`*^9}, {3.413561215670702*^9, 
   3.413561234122511*^9}, {3.413561296573495*^9, 3.4135613166747093`*^9}, {
   3.41356135002186*^9, 3.41356137837409*^9}, {3.413561861595727*^9, 
   3.413561898466165*^9}, {3.41356216536779*^9, 3.413562182115737*^9}, {
   3.4135622400863657`*^9, 3.413562254800729*^9}, {3.413562377366222*^9, 
   3.413562392971683*^9}, {3.413562433904014*^9, 3.413562445867895*^9}, {
   3.413562504180849*^9, 3.413562508259063*^9}, 3.413562923085012*^9, {
   3.413563020982358*^9, 3.413563038395566*^9}, {3.413563204017761*^9, 
   3.413563211013069*^9}, {3.4135632814810266`*^9, 3.413563286516513*^9}, {
   3.413563533701682*^9, 3.413563563623125*^9}, {3.413563627820689*^9, 
   3.413563640483642*^9}, 3.413563860009501*^9, {3.413564660571954*^9, 
   3.413564685768498*^9}, 3.413565036273573*^9, {3.4135659358045177`*^9, 
   3.413565954203712*^9}, 3.413566580518095*^9, {3.413566877471837*^9, 
   3.413566887228496*^9}, {3.413566933856913*^9, 3.413566950917994*^9}, {
   3.413567184595811*^9, 3.413567227561339*^9}, {3.413567570721279*^9, 
   3.413567572089267*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length before X removal = \"\>", "\[InvisibleSpace]", "3300"}],
  
  SequenceForm["Length before X removal = ", 3300],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.4135812355177107`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length after X removal = \"\>", "\[InvisibleSpace]", "3298"}],
  SequenceForm["Length after X removal = ", 3298],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581235570957*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"#define LAST_ATOMIC_INDEX (\"\>", "\[InvisibleSpace]", "118", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["#define LAST_ATOMIC_INDEX (", 118, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581235620777*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"static const char *atomic_labels[] =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"\\\"X\\\"\"\>", ",", "\<\"\\\"H\\\"\"\>", 
     ",", "\<\"\\\"HE\\\"\"\>", ",", "\<\"\\\"LI\\\"\"\>", 
     ",", "\<\"\\\"BE\\\"\"\>", ",", "\<\"\\\"B\\\"\"\>", 
     ",", "\<\"\\\"C\\\"\"\>", ",", "\<\"\\\"N\\\"\"\>", 
     ",", "\<\"\\\"O\\\"\"\>", ",", "\<\"\\\"F\\\"\"\>", 
     ",", "\<\"\\\"NE\\\"\"\>", ",", "\<\"\\\"NA\\\"\"\>", 
     ",", "\<\"\\\"MG\\\"\"\>", ",", "\<\"\\\"AL\\\"\"\>", 
     ",", "\<\"\\\"SI\\\"\"\>", ",", "\<\"\\\"P\\\"\"\>", 
     ",", "\<\"\\\"S\\\"\"\>", ",", "\<\"\\\"CL\\\"\"\>", 
     ",", "\<\"\\\"AR\\\"\"\>", ",", "\<\"\\\"K\\\"\"\>", 
     ",", "\<\"\\\"CA\\\"\"\>", ",", "\<\"\\\"SC\\\"\"\>", 
     ",", "\<\"\\\"TI\\\"\"\>", ",", "\<\"\\\"V\\\"\"\>", 
     ",", "\<\"\\\"CR\\\"\"\>", ",", "\<\"\\\"MN\\\"\"\>", 
     ",", "\<\"\\\"FE\\\"\"\>", ",", "\<\"\\\"CO\\\"\"\>", 
     ",", "\<\"\\\"NI\\\"\"\>", ",", "\<\"\\\"CU\\\"\"\>", 
     ",", "\<\"\\\"ZN\\\"\"\>", ",", "\<\"\\\"GA\\\"\"\>", 
     ",", "\<\"\\\"GE\\\"\"\>", ",", "\<\"\\\"AS\\\"\"\>", 
     ",", "\<\"\\\"SE\\\"\"\>", ",", "\<\"\\\"BR\\\"\"\>", 
     ",", "\<\"\\\"KR\\\"\"\>", ",", "\<\"\\\"RB\\\"\"\>", 
     ",", "\<\"\\\"SR\\\"\"\>", ",", "\<\"\\\"Y\\\"\"\>", 
     ",", "\<\"\\\"ZR\\\"\"\>", ",", "\<\"\\\"NB\\\"\"\>", 
     ",", "\<\"\\\"MO\\\"\"\>", ",", "\<\"\\\"TC\\\"\"\>", 
     ",", "\<\"\\\"RU\\\"\"\>", ",", "\<\"\\\"RH\\\"\"\>", 
     ",", "\<\"\\\"PD\\\"\"\>", ",", "\<\"\\\"AG\\\"\"\>", 
     ",", "\<\"\\\"CD\\\"\"\>", ",", "\<\"\\\"IN\\\"\"\>", 
     ",", "\<\"\\\"SN\\\"\"\>", ",", "\<\"\\\"SB\\\"\"\>", 
     ",", "\<\"\\\"TE\\\"\"\>", ",", "\<\"\\\"I\\\"\"\>", 
     ",", "\<\"\\\"XE\\\"\"\>", ",", "\<\"\\\"CS\\\"\"\>", 
     ",", "\<\"\\\"BA\\\"\"\>", ",", "\<\"\\\"LA\\\"\"\>", 
     ",", "\<\"\\\"CE\\\"\"\>", ",", "\<\"\\\"PR\\\"\"\>", 
     ",", "\<\"\\\"ND\\\"\"\>", ",", "\<\"\\\"PM\\\"\"\>", 
     ",", "\<\"\\\"SM\\\"\"\>", ",", "\<\"\\\"EU\\\"\"\>", 
     ",", "\<\"\\\"GD\\\"\"\>", ",", "\<\"\\\"TB\\\"\"\>", 
     ",", "\<\"\\\"DY\\\"\"\>", ",", "\<\"\\\"HO\\\"\"\>", 
     ",", "\<\"\\\"ER\\\"\"\>", ",", "\<\"\\\"TM\\\"\"\>", 
     ",", "\<\"\\\"YB\\\"\"\>", ",", "\<\"\\\"LU\\\"\"\>", 
     ",", "\<\"\\\"HF\\\"\"\>", ",", "\<\"\\\"TA\\\"\"\>", 
     ",", "\<\"\\\"W\\\"\"\>", ",", "\<\"\\\"RE\\\"\"\>", 
     ",", "\<\"\\\"OS\\\"\"\>", ",", "\<\"\\\"IR\\\"\"\>", 
     ",", "\<\"\\\"PT\\\"\"\>", ",", "\<\"\\\"AU\\\"\"\>", 
     ",", "\<\"\\\"HG\\\"\"\>", ",", "\<\"\\\"TL\\\"\"\>", 
     ",", "\<\"\\\"PB\\\"\"\>", ",", "\<\"\\\"BI\\\"\"\>", 
     ",", "\<\"\\\"PO\\\"\"\>", ",", "\<\"\\\"AT\\\"\"\>", 
     ",", "\<\"\\\"RN\\\"\"\>", ",", "\<\"\\\"FR\\\"\"\>", 
     ",", "\<\"\\\"RA\\\"\"\>", ",", "\<\"\\\"AC\\\"\"\>", 
     ",", "\<\"\\\"TH\\\"\"\>", ",", "\<\"\\\"PA\\\"\"\>", 
     ",", "\<\"\\\"U\\\"\"\>", ",", "\<\"\\\"NP\\\"\"\>", 
     ",", "\<\"\\\"PU\\\"\"\>", ",", "\<\"\\\"AM\\\"\"\>", 
     ",", "\<\"\\\"CM\\\"\"\>", ",", "\<\"\\\"BK\\\"\"\>", 
     ",", "\<\"\\\"CF\\\"\"\>", ",", "\<\"\\\"ES\\\"\"\>", 
     ",", "\<\"\\\"FM\\\"\"\>", ",", "\<\"\\\"MD\\\"\"\>", 
     ",", "\<\"\\\"NO\\\"\"\>", ",", "\<\"\\\"LR\\\"\"\>", 
     ",", "\<\"\\\"RF\\\"\"\>", ",", "\<\"\\\"DB\\\"\"\>", 
     ",", "\<\"\\\"SG\\\"\"\>", ",", "\<\"\\\"BH\\\"\"\>", 
     ",", "\<\"\\\"HS\\\"\"\>", ",", "\<\"\\\"MT\\\"\"\>", 
     ",", "\<\"\\\"DS\\\"\"\>", ",", "\<\"\\\"RG\\\"\"\>", 
     ",", "\<\"\\\"UUB\\\"\"\>", ",", "\<\"\\\"UUT\\\"\"\>", 
     ",", "\<\"\\\"UUQ\\\"\"\>", ",", "\<\"\\\"UUP\\\"\"\>", 
     ",", "\<\"\\\"UUH\\\"\"\>", ",", "\<\"\\\"UUS\\\"\"\>", 
     ",", "\<\"\\\"UUO\\\"\"\>"}], "}"}]}],
  SequenceForm[
  "static const char *atomic_labels[] =", {
   "\"X\"", "\"H\"", "\"HE\"", "\"LI\"", "\"BE\"", "\"B\"", "\"C\"", "\"N\"", 
    "\"O\"", "\"F\"", "\"NE\"", "\"NA\"", "\"MG\"", "\"AL\"", "\"SI\"", 
    "\"P\"", "\"S\"", "\"CL\"", "\"AR\"", "\"K\"", "\"CA\"", "\"SC\"", 
    "\"TI\"", "\"V\"", "\"CR\"", "\"MN\"", "\"FE\"", "\"CO\"", "\"NI\"", 
    "\"CU\"", "\"ZN\"", "\"GA\"", "\"GE\"", "\"AS\"", "\"SE\"", "\"BR\"", 
    "\"KR\"", "\"RB\"", "\"SR\"", "\"Y\"", "\"ZR\"", "\"NB\"", "\"MO\"", 
    "\"TC\"", "\"RU\"", "\"RH\"", "\"PD\"", "\"AG\"", "\"CD\"", "\"IN\"", 
    "\"SN\"", "\"SB\"", "\"TE\"", "\"I\"", "\"XE\"", "\"CS\"", "\"BA\"", 
    "\"LA\"", "\"CE\"", "\"PR\"", "\"ND\"", "\"PM\"", "\"SM\"", "\"EU\"", 
    "\"GD\"", "\"TB\"", "\"DY\"", "\"HO\"", "\"ER\"", "\"TM\"", "\"YB\"", 
    "\"LU\"", "\"HF\"", "\"TA\"", "\"W\"", "\"RE\"", "\"OS\"", "\"IR\"", 
    "\"PT\"", "\"AU\"", "\"HG\"", "\"TL\"", "\"PB\"", "\"BI\"", "\"PO\"", 
    "\"AT\"", "\"RN\"", "\"FR\"", "\"RA\"", "\"AC\"", "\"TH\"", "\"PA\"", 
    "\"U\"", "\"NP\"", "\"PU\"", "\"AM\"", "\"CM\"", "\"BK\"", "\"CF\"", 
    "\"ES\"", "\"FM\"", "\"MD\"", "\"NO\"", "\"LR\"", "\"RF\"", "\"DB\"", 
    "\"SG\"", "\"BH\"", "\"HS\"", "\"MT\"", "\"DS\"", "\"RG\"", "\"UUB\"", 
    "\"UUT\"", "\"UUQ\"", "\"UUP\"", "\"UUH\"", "\"UUS\"", "\"UUO\""}],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581235672765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"static double an2masses[] =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "1.00782503207`12.000000000000004", ",", 
     "4.00260325415`12.000000000000004", ",", 
     "7.016004548`10.000000000000004", ",", "9.012182201`9.999999999999998", 
     ",", "11.009305406`11.", ",", "12", ",", 
     "14.00307400477999999999999999999`13.", ",", "15.99491461956`13.", ",", 
     "18.998403224`10.999999999999998", ",", "19.99244017542`13.", ",", 
     "22.98976928087`13.", ",", "23.985041699`11.000000000000005", ",", 
     "26.981538627`11.", ",", "27.97692653246`13.", ",", 
     "30.973761629`10.999999999999996", ",", "31.972070999`11.", ",", 
     "34.968852682`10.999999999999996", ",", "39.96238312251`13.", ",", 
     "38.963706679`11.", ",", "39.962590983`11.", ",", "44.955911909`11.", 
     ",", "47.947946281`11.", ",", "50.943959507`11.", ",", 
     "51.940507472`11.", ",", "54.938045141`11.000000000000005", ",", 
     "55.934937475`11.", ",", "58.933195048`11.", ",", "57.935342907`11.", 
     ",", "62.929597474`11.000000000000005", ",", "63.929142222`11.", ",", 
     "68.925573587`11.", ",", "73.921177767`11.", ",", "74.921596478`11.", 
     ",", "79.916521271`11.", ",", "78.918337087`11.", ",", 
     "85.910610729`11.", ",", "84.911789737`11.", ",", "87.905612124`11.", 
     ",", "88.905848295`11.", ",", "89.904704416`11.", ",", 
     "92.906378058`11.", ",", "97.905408169`11.000000000000005", ",", 
     "98.906254747`11.", ",", "101.904349312`12.000000000000004", ",", 
     "102.905504292`11.999999999999998", ",", 
     "105.903485715`12.000000000000004", ",", 
     "106.90509682`11.000000000000005", ",", "113.90335854`11.", ",", 
     "114.903878484`12.000000000000004", ",", 
     "119.902194676`11.999999999999998", ",", 
     "120.903815686`12.000000000000004", ",", 
     "129.906224399`11.999999999999998", ",", 
     "126.904472681`11.999999999999998", ",", 
     "131.904153457`11.999999999999996", ",", "132.905451932`12.", ",", 
     "137.905247237`12.000000000000004", ",", 
     "138.906353267`11.999999999999998", ",", 
     "139.905438706`11.999999999999996", ",", 
     "140.907652769`11.999999999999996", ",", 
     "141.907723297`12.000000000000004", ",", 
     "144.912749023`12.000000000000004", ",", 
     "151.919732425`12.000000000000004", ",", "152.921230339`12.", ",", 
     "157.924103912`11.999999999999998", ",", 
     "158.925346757`11.999999999999998", ",", 
     "163.929174751`11.999999999999998", ",", "164.93032207`11.", ",", 
     "165.930293061`12.", ",", "168.93421325`11.000000000000005", ",", 
     "173.938862089`11.999999999999996", ",", 
     "174.940771819`12.000000000000004", ",", 
     "179.946549953`12.000000000000004", ",", 
     "180.947995763`12.000000000000004", ",", 
     "183.950931188`12.000000000000004", ",", "186.955753109`12.", ",", 
     "191.96148069`11.", ",", "192.96292643`11.000000000000005", ",", 
     "194.964791134`11.999999999999998", ",", 
     "196.966568662`12.000000000000004", ",", 
     "201.970643011`12.000000000000004", ",", 
     "204.974427541`11.999999999999996", ",", 
     "207.976652071`11.999999999999996", ",", "208.980398734`12.", ",", 
     "208.982430435`12.000000000000004", ",", "210.987496271`12.", ",", 
     "222.017577738`12.000000000000004", ",", 
     "222.01755173`11.000000000000005", ",", 
     "228.031070292`11.999999999999998", ",", 
     "227.027752127`11.999999999999998", ",", 
     "232.038055325`11.999999999999998", ",", 
     "231.03588399`11.000000000000005", ",", 
     "238.050788247`11.999999999999998", ",", 
     "237.048173444`12.000000000000004", ",", 
     "242.058742611`11.999999999999998", ",", 
     "243.06138108`10.999999999999996", ",", "247.07035354`11.", ",", 
     "247.07030708`10.999999999999996", ",", 
     "251.079586788`12.000000000000004", ",", 
     "252.082978512`11.999999999999998", ",", 
     "257.095104724`12.000000000000004", ",", 
     "258.098431319`11.999999999999998", ",", 
     "255.093241131`12.000000000000004", ",", "260.105504`9.000000000000002", 
     ",", "263.112547`9.000000000000002", ",", "255.107398`9.000000000000002",
      ",", "259.1145`9.000000000000002", ",", "262.122892`9.000000000000002", 
     ",", "263.128558`9.000000000000002", ",", "265.136151`9.000000000000002",
      ",", "281.162061`9.000000000000002", ",", 
     "272.153615`9.000000000000002", ",", "283.171792`9.000000000000002", ",",
      "283.176451`9.000000000000002", ",", "285.183698`9.000000000000002", 
     ",", "287.191186`9.000000000000002", ",", "292.199786`9.000000000000002",
      ",", "291.206564`9.000000000000002", ",", 
     "293.21467`9.000000000000002"}], "}"}]}],
  SequenceForm[
  "static double an2masses[] =", {
   0., 1.00782503207`12.000000000000004, 4.00260325415`12.000000000000004, 
    7.016004548`10.000000000000004, 9.012182201`9.999999999999998, 
    11.009305406`11., 12, 14.00307400478`13., 15.99491461956`13., 
    18.998403224`10.999999999999998, 19.99244017542`13., 22.98976928087`13., 
    23.985041699`11.000000000000005, 26.981538627`11., 27.97692653246`13., 
    30.973761629`10.999999999999996, 31.972070999`11., 
    34.968852682`10.999999999999996, 39.96238312251`13., 38.963706679`11., 
    39.962590983`11., 44.955911909`11., 47.947946281`11., 50.943959507`11., 
    51.940507472`11., 54.938045141`11.000000000000005, 55.934937475`11., 
    58.933195048`11., 57.935342907`11., 62.929597474`11.000000000000005, 
    63.929142222`11., 68.925573587`11., 73.921177767`11., 74.921596478`11., 
    79.916521271`11., 78.918337087`11., 85.910610729`11., 84.911789737`11., 
    87.905612124`11., 88.905848295`11., 89.904704416`11., 92.906378058`11., 
    97.905408169`11.000000000000005, 98.906254747`11., 
    101.904349312`12.000000000000004, 102.905504292`11.999999999999998, 
    105.903485715`12.000000000000004, 106.90509682`11.000000000000005, 
    113.90335854`11., 114.903878484`12.000000000000004, 
    119.902194676`11.999999999999998, 120.903815686`12.000000000000004, 
    129.906224399`11.999999999999998, 126.904472681`11.999999999999998, 
    131.904153457`11.999999999999996, 132.905451932`12., 
    137.905247237`12.000000000000004, 138.906353267`11.999999999999998, 
    139.905438706`11.999999999999996, 140.907652769`11.999999999999996, 
    141.907723297`12.000000000000004, 144.912749023`12.000000000000004, 
    151.919732425`12.000000000000004, 152.921230339`12., 
    157.924103912`11.999999999999998, 158.925346757`11.999999999999998, 
    163.929174751`11.999999999999998, 164.93032207`11., 165.930293061`12., 
    168.93421325`11.000000000000005, 173.938862089`11.999999999999996, 
    174.940771819`12.000000000000004, 179.946549953`12.000000000000004, 
    180.947995763`12.000000000000004, 183.950931188`12.000000000000004, 
    186.955753109`12., 191.96148069`11., 192.96292643`11.000000000000005, 
    194.964791134`11.999999999999998, 196.966568662`12.000000000000004, 
    201.970643011`12.000000000000004, 204.974427541`11.999999999999996, 
    207.976652071`11.999999999999996, 208.980398734`12., 
    208.982430435`12.000000000000004, 210.987496271`12., 
    222.017577738`12.000000000000004, 222.01755173`11.000000000000005, 
    228.031070292`11.999999999999998, 227.027752127`11.999999999999998, 
    232.038055325`11.999999999999998, 231.03588399`11.000000000000005, 
    238.050788247`11.999999999999998, 237.048173444`12.000000000000004, 
    242.058742611`11.999999999999998, 243.06138108`10.999999999999996, 
    247.07035354`11., 247.07030708`10.999999999999996, 
    251.079586788`12.000000000000004, 252.082978512`11.999999999999998, 
    257.095104724`12.000000000000004, 258.098431319`11.999999999999998, 
    255.093241131`12.000000000000004, 260.105504`9.000000000000002, 
    263.112547`9.000000000000002, 255.107398`9.000000000000002, 
    259.1145`9.000000000000002, 262.122892`9.000000000000002, 
    263.128558`9.000000000000002, 265.136151`9.000000000000002, 
    281.162061`9.000000000000002, 272.153615`9.000000000000002, 
    283.171792`9.000000000000002, 283.176451`9.000000000000002, 
    285.183698`9.000000000000002, 287.191186`9.000000000000002, 
    292.199786`9.000000000000002, 291.206564`9.000000000000002, 
    293.21467`9.000000000000002}],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.4135812357236032`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"#define LAST_MASS_INDEX (\"\>", "\[InvisibleSpace]", "3297", 
   "\[InvisibleSpace]", "\<\")\"\>"}],
  SequenceForm["#define LAST_MASS_INDEX (", 3297, ")"],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581235772338*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"static const char *mass_labels[] =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"\\\"H\\\"\"\>", ",", "\<\"\\\"H1\\\"\"\>", 
     ",", "\<\"\\\"H2\\\"\"\>", ",", "\<\"\\\"D\\\"\"\>", 
     ",", "\<\"\\\"H3\\\"\"\>", ",", "\<\"\\\"T\\\"\"\>", 
     ",", "\<\"\\\"H4\\\"\"\>", ",", "\<\"\\\"H5\\\"\"\>", 
     ",", "\<\"\\\"H6\\\"\"\>", ",", "\<\"\\\"H7\\\"\"\>", 
     ",", "\<\"\\\"HE\\\"\"\>", ",", "\<\"\\\"HE3\\\"\"\>", 
     ",", "\<\"\\\"HE4\\\"\"\>", ",", "\<\"\\\"HE5\\\"\"\>", 
     ",", "\<\"\\\"HE6\\\"\"\>", ",", "\<\"\\\"HE7\\\"\"\>", 
     ",", "\<\"\\\"HE8\\\"\"\>", ",", "\<\"\\\"HE9\\\"\"\>", 
     ",", "\<\"\\\"HE10\\\"\"\>", ",", "\<\"\\\"LI\\\"\"\>", 
     ",", "\<\"\\\"LI3\\\"\"\>", ",", "\<\"\\\"LI4\\\"\"\>", 
     ",", "\<\"\\\"LI5\\\"\"\>", ",", "\<\"\\\"LI6\\\"\"\>", 
     ",", "\<\"\\\"LI7\\\"\"\>", ",", "\<\"\\\"LI8\\\"\"\>", 
     ",", "\<\"\\\"LI9\\\"\"\>", ",", "\<\"\\\"LI10\\\"\"\>", 
     ",", "\<\"\\\"LI11\\\"\"\>", ",", "\<\"\\\"LI12\\\"\"\>", 
     ",", "\<\"\\\"BE\\\"\"\>", ",", "\<\"\\\"BE5\\\"\"\>", 
     ",", "\<\"\\\"BE6\\\"\"\>", ",", "\<\"\\\"BE7\\\"\"\>", 
     ",", "\<\"\\\"BE8\\\"\"\>", ",", "\<\"\\\"BE9\\\"\"\>", 
     ",", "\<\"\\\"BE10\\\"\"\>", ",", "\<\"\\\"BE11\\\"\"\>", 
     ",", "\<\"\\\"BE12\\\"\"\>", ",", "\<\"\\\"BE13\\\"\"\>", 
     ",", "\<\"\\\"BE14\\\"\"\>", ",", "\<\"\\\"BE15\\\"\"\>", 
     ",", "\<\"\\\"BE16\\\"\"\>", ",", "\<\"\\\"B\\\"\"\>", 
     ",", "\<\"\\\"B6\\\"\"\>", ",", "\<\"\\\"B7\\\"\"\>", 
     ",", "\<\"\\\"B8\\\"\"\>", ",", "\<\"\\\"B9\\\"\"\>", 
     ",", "\<\"\\\"B10\\\"\"\>", ",", "\<\"\\\"B11\\\"\"\>", 
     ",", "\<\"\\\"B12\\\"\"\>", ",", "\<\"\\\"B13\\\"\"\>", 
     ",", "\<\"\\\"B14\\\"\"\>", ",", "\<\"\\\"B15\\\"\"\>", 
     ",", "\<\"\\\"B16\\\"\"\>", ",", "\<\"\\\"B17\\\"\"\>", 
     ",", "\<\"\\\"B18\\\"\"\>", ",", "\<\"\\\"B19\\\"\"\>", 
     ",", "\<\"\\\"C\\\"\"\>", ",", "\<\"\\\"C8\\\"\"\>", 
     ",", "\<\"\\\"C9\\\"\"\>", ",", "\<\"\\\"C10\\\"\"\>", 
     ",", "\<\"\\\"C11\\\"\"\>", ",", "\<\"\\\"C12\\\"\"\>", 
     ",", "\<\"\\\"C13\\\"\"\>", ",", "\<\"\\\"C14\\\"\"\>", 
     ",", "\<\"\\\"C15\\\"\"\>", ",", "\<\"\\\"C16\\\"\"\>", 
     ",", "\<\"\\\"C17\\\"\"\>", ",", "\<\"\\\"C18\\\"\"\>", 
     ",", "\<\"\\\"C19\\\"\"\>", ",", "\<\"\\\"C20\\\"\"\>", 
     ",", "\<\"\\\"C21\\\"\"\>", ",", "\<\"\\\"C22\\\"\"\>", 
     ",", "\<\"\\\"N\\\"\"\>", ",", "\<\"\\\"N10\\\"\"\>", 
     ",", "\<\"\\\"N11\\\"\"\>", ",", "\<\"\\\"N12\\\"\"\>", 
     ",", "\<\"\\\"N13\\\"\"\>", ",", "\<\"\\\"N14\\\"\"\>", 
     ",", "\<\"\\\"N15\\\"\"\>", ",", "\<\"\\\"N16\\\"\"\>", 
     ",", "\<\"\\\"N17\\\"\"\>", ",", "\<\"\\\"N18\\\"\"\>", 
     ",", "\<\"\\\"N19\\\"\"\>", ",", "\<\"\\\"N20\\\"\"\>", 
     ",", "\<\"\\\"N21\\\"\"\>", ",", "\<\"\\\"N22\\\"\"\>", 
     ",", "\<\"\\\"N23\\\"\"\>", ",", "\<\"\\\"N24\\\"\"\>", 
     ",", "\<\"\\\"N25\\\"\"\>", ",", "\<\"\\\"O\\\"\"\>", 
     ",", "\<\"\\\"O12\\\"\"\>", ",", "\<\"\\\"O13\\\"\"\>", 
     ",", "\<\"\\\"O14\\\"\"\>", ",", "\<\"\\\"O15\\\"\"\>", 
     ",", "\<\"\\\"O16\\\"\"\>", ",", "\<\"\\\"O17\\\"\"\>", 
     ",", "\<\"\\\"O18\\\"\"\>", ",", "\<\"\\\"O19\\\"\"\>", 
     ",", "\<\"\\\"O20\\\"\"\>", ",", "\<\"\\\"O21\\\"\"\>", 
     ",", "\<\"\\\"O22\\\"\"\>", ",", "\<\"\\\"O23\\\"\"\>", 
     ",", "\<\"\\\"O24\\\"\"\>", ",", "\<\"\\\"O25\\\"\"\>", 
     ",", "\<\"\\\"O26\\\"\"\>", ",", "\<\"\\\"O27\\\"\"\>", 
     ",", "\<\"\\\"O28\\\"\"\>", ",", "\<\"\\\"F\\\"\"\>", 
     ",", "\<\"\\\"F14\\\"\"\>", ",", "\<\"\\\"F15\\\"\"\>", 
     ",", "\<\"\\\"F16\\\"\"\>", ",", "\<\"\\\"F17\\\"\"\>", 
     ",", "\<\"\\\"F18\\\"\"\>", ",", "\<\"\\\"F19\\\"\"\>", 
     ",", "\<\"\\\"F20\\\"\"\>", ",", "\<\"\\\"F21\\\"\"\>", 
     ",", "\<\"\\\"F22\\\"\"\>", ",", "\<\"\\\"F23\\\"\"\>", 
     ",", "\<\"\\\"F24\\\"\"\>", ",", "\<\"\\\"F25\\\"\"\>", 
     ",", "\<\"\\\"F26\\\"\"\>", ",", "\<\"\\\"F27\\\"\"\>", 
     ",", "\<\"\\\"F28\\\"\"\>", ",", "\<\"\\\"F29\\\"\"\>", 
     ",", "\<\"\\\"F30\\\"\"\>", ",", "\<\"\\\"F31\\\"\"\>", 
     ",", "\<\"\\\"NE\\\"\"\>", ",", "\<\"\\\"NE16\\\"\"\>", 
     ",", "\<\"\\\"NE17\\\"\"\>", ",", "\<\"\\\"NE18\\\"\"\>", 
     ",", "\<\"\\\"NE19\\\"\"\>", ",", "\<\"\\\"NE20\\\"\"\>", 
     ",", "\<\"\\\"NE21\\\"\"\>", ",", "\<\"\\\"NE22\\\"\"\>", 
     ",", "\<\"\\\"NE23\\\"\"\>", ",", "\<\"\\\"NE24\\\"\"\>", 
     ",", "\<\"\\\"NE25\\\"\"\>", ",", "\<\"\\\"NE26\\\"\"\>", 
     ",", "\<\"\\\"NE27\\\"\"\>", ",", "\<\"\\\"NE28\\\"\"\>", 
     ",", "\<\"\\\"NE29\\\"\"\>", ",", "\<\"\\\"NE30\\\"\"\>", 
     ",", "\<\"\\\"NE31\\\"\"\>", ",", "\<\"\\\"NE32\\\"\"\>", 
     ",", "\<\"\\\"NE33\\\"\"\>", ",", "\<\"\\\"NE34\\\"\"\>", 
     ",", "\<\"\\\"NA\\\"\"\>", ",", "\<\"\\\"NA18\\\"\"\>", 
     ",", "\<\"\\\"NA19\\\"\"\>", ",", "\<\"\\\"NA20\\\"\"\>", 
     ",", "\<\"\\\"NA21\\\"\"\>", ",", "\<\"\\\"NA22\\\"\"\>", 
     ",", "\<\"\\\"NA23\\\"\"\>", ",", "\<\"\\\"NA24\\\"\"\>", 
     ",", "\<\"\\\"NA25\\\"\"\>", ",", "\<\"\\\"NA26\\\"\"\>", 
     ",", "\<\"\\\"NA27\\\"\"\>", ",", "\<\"\\\"NA28\\\"\"\>", 
     ",", "\<\"\\\"NA29\\\"\"\>", ",", "\<\"\\\"NA30\\\"\"\>", 
     ",", "\<\"\\\"NA31\\\"\"\>", ",", "\<\"\\\"NA32\\\"\"\>", 
     ",", "\<\"\\\"NA33\\\"\"\>", ",", "\<\"\\\"NA34\\\"\"\>", 
     ",", "\<\"\\\"NA35\\\"\"\>", ",", "\<\"\\\"NA36\\\"\"\>", 
     ",", "\<\"\\\"NA37\\\"\"\>", ",", "\<\"\\\"MG\\\"\"\>", 
     ",", "\<\"\\\"MG19\\\"\"\>", ",", "\<\"\\\"MG20\\\"\"\>", 
     ",", "\<\"\\\"MG21\\\"\"\>", ",", "\<\"\\\"MG22\\\"\"\>", 
     ",", "\<\"\\\"MG23\\\"\"\>", ",", "\<\"\\\"MG24\\\"\"\>", 
     ",", "\<\"\\\"MG25\\\"\"\>", ",", "\<\"\\\"MG26\\\"\"\>", 
     ",", "\<\"\\\"MG27\\\"\"\>", ",", "\<\"\\\"MG28\\\"\"\>", 
     ",", "\<\"\\\"MG29\\\"\"\>", ",", "\<\"\\\"MG30\\\"\"\>", 
     ",", "\<\"\\\"MG31\\\"\"\>", ",", "\<\"\\\"MG32\\\"\"\>", 
     ",", "\<\"\\\"MG33\\\"\"\>", ",", "\<\"\\\"MG34\\\"\"\>", 
     ",", "\<\"\\\"MG35\\\"\"\>", ",", "\<\"\\\"MG36\\\"\"\>", 
     ",", "\<\"\\\"MG37\\\"\"\>", ",", "\<\"\\\"MG38\\\"\"\>", 
     ",", "\<\"\\\"MG39\\\"\"\>", ",", "\<\"\\\"MG40\\\"\"\>", 
     ",", "\<\"\\\"AL\\\"\"\>", ",", "\<\"\\\"AL21\\\"\"\>", 
     ",", "\<\"\\\"AL22\\\"\"\>", ",", "\<\"\\\"AL23\\\"\"\>", 
     ",", "\<\"\\\"AL24\\\"\"\>", ",", "\<\"\\\"AL25\\\"\"\>", 
     ",", "\<\"\\\"AL26\\\"\"\>", ",", "\<\"\\\"AL27\\\"\"\>", 
     ",", "\<\"\\\"AL28\\\"\"\>", ",", "\<\"\\\"AL29\\\"\"\>", 
     ",", "\<\"\\\"AL30\\\"\"\>", ",", "\<\"\\\"AL31\\\"\"\>", 
     ",", "\<\"\\\"AL32\\\"\"\>", ",", "\<\"\\\"AL33\\\"\"\>", 
     ",", "\<\"\\\"AL34\\\"\"\>", ",", "\<\"\\\"AL35\\\"\"\>", 
     ",", "\<\"\\\"AL36\\\"\"\>", ",", "\<\"\\\"AL37\\\"\"\>", 
     ",", "\<\"\\\"AL38\\\"\"\>", ",", "\<\"\\\"AL39\\\"\"\>", 
     ",", "\<\"\\\"AL40\\\"\"\>", ",", "\<\"\\\"AL41\\\"\"\>", 
     ",", "\<\"\\\"AL42\\\"\"\>", ",", "\<\"\\\"SI\\\"\"\>", 
     ",", "\<\"\\\"SI22\\\"\"\>", ",", "\<\"\\\"SI23\\\"\"\>", 
     ",", "\<\"\\\"SI24\\\"\"\>", ",", "\<\"\\\"SI25\\\"\"\>", 
     ",", "\<\"\\\"SI26\\\"\"\>", ",", "\<\"\\\"SI27\\\"\"\>", 
     ",", "\<\"\\\"SI28\\\"\"\>", ",", "\<\"\\\"SI29\\\"\"\>", 
     ",", "\<\"\\\"SI30\\\"\"\>", ",", "\<\"\\\"SI31\\\"\"\>", 
     ",", "\<\"\\\"SI32\\\"\"\>", ",", "\<\"\\\"SI33\\\"\"\>", 
     ",", "\<\"\\\"SI34\\\"\"\>", ",", "\<\"\\\"SI35\\\"\"\>", 
     ",", "\<\"\\\"SI36\\\"\"\>", ",", "\<\"\\\"SI37\\\"\"\>", 
     ",", "\<\"\\\"SI38\\\"\"\>", ",", "\<\"\\\"SI39\\\"\"\>", 
     ",", "\<\"\\\"SI40\\\"\"\>", ",", "\<\"\\\"SI41\\\"\"\>", 
     ",", "\<\"\\\"SI42\\\"\"\>", ",", "\<\"\\\"SI43\\\"\"\>", 
     ",", "\<\"\\\"SI44\\\"\"\>", ",", "\<\"\\\"P\\\"\"\>", 
     ",", "\<\"\\\"P24\\\"\"\>", ",", "\<\"\\\"P25\\\"\"\>", 
     ",", "\<\"\\\"P26\\\"\"\>", ",", "\<\"\\\"P27\\\"\"\>", 
     ",", "\<\"\\\"P28\\\"\"\>", ",", "\<\"\\\"P29\\\"\"\>", 
     ",", "\<\"\\\"P30\\\"\"\>", ",", "\<\"\\\"P31\\\"\"\>", 
     ",", "\<\"\\\"P32\\\"\"\>", ",", "\<\"\\\"P33\\\"\"\>", 
     ",", "\<\"\\\"P34\\\"\"\>", ",", "\<\"\\\"P35\\\"\"\>", 
     ",", "\<\"\\\"P36\\\"\"\>", ",", "\<\"\\\"P37\\\"\"\>", 
     ",", "\<\"\\\"P38\\\"\"\>", ",", "\<\"\\\"P39\\\"\"\>", 
     ",", "\<\"\\\"P40\\\"\"\>", ",", "\<\"\\\"P41\\\"\"\>", 
     ",", "\<\"\\\"P42\\\"\"\>", ",", "\<\"\\\"P43\\\"\"\>", 
     ",", "\<\"\\\"P44\\\"\"\>", ",", "\<\"\\\"P45\\\"\"\>", 
     ",", "\<\"\\\"P46\\\"\"\>", ",", "\<\"\\\"S\\\"\"\>", 
     ",", "\<\"\\\"S26\\\"\"\>", ",", "\<\"\\\"S27\\\"\"\>", 
     ",", "\<\"\\\"S28\\\"\"\>", ",", "\<\"\\\"S29\\\"\"\>", 
     ",", "\<\"\\\"S30\\\"\"\>", ",", "\<\"\\\"S31\\\"\"\>", 
     ",", "\<\"\\\"S32\\\"\"\>", ",", "\<\"\\\"S33\\\"\"\>", 
     ",", "\<\"\\\"S34\\\"\"\>", ",", "\<\"\\\"S35\\\"\"\>", 
     ",", "\<\"\\\"S36\\\"\"\>", ",", "\<\"\\\"S37\\\"\"\>", 
     ",", "\<\"\\\"S38\\\"\"\>", ",", "\<\"\\\"S39\\\"\"\>", 
     ",", "\<\"\\\"S40\\\"\"\>", ",", "\<\"\\\"S41\\\"\"\>", 
     ",", "\<\"\\\"S42\\\"\"\>", ",", "\<\"\\\"S43\\\"\"\>", 
     ",", "\<\"\\\"S44\\\"\"\>", ",", "\<\"\\\"S45\\\"\"\>", 
     ",", "\<\"\\\"S46\\\"\"\>", ",", "\<\"\\\"S47\\\"\"\>", 
     ",", "\<\"\\\"S48\\\"\"\>", ",", "\<\"\\\"S49\\\"\"\>", 
     ",", "\<\"\\\"CL\\\"\"\>", ",", "\<\"\\\"CL28\\\"\"\>", 
     ",", "\<\"\\\"CL29\\\"\"\>", ",", "\<\"\\\"CL30\\\"\"\>", 
     ",", "\<\"\\\"CL31\\\"\"\>", ",", "\<\"\\\"CL32\\\"\"\>", 
     ",", "\<\"\\\"CL33\\\"\"\>", ",", "\<\"\\\"CL34\\\"\"\>", 
     ",", "\<\"\\\"CL35\\\"\"\>", ",", "\<\"\\\"CL36\\\"\"\>", 
     ",", "\<\"\\\"CL37\\\"\"\>", ",", "\<\"\\\"CL38\\\"\"\>", 
     ",", "\<\"\\\"CL39\\\"\"\>", ",", "\<\"\\\"CL40\\\"\"\>", 
     ",", "\<\"\\\"CL41\\\"\"\>", ",", "\<\"\\\"CL42\\\"\"\>", 
     ",", "\<\"\\\"CL43\\\"\"\>", ",", "\<\"\\\"CL44\\\"\"\>", 
     ",", "\<\"\\\"CL45\\\"\"\>", ",", "\<\"\\\"CL46\\\"\"\>", 
     ",", "\<\"\\\"CL47\\\"\"\>", ",", "\<\"\\\"CL48\\\"\"\>", 
     ",", "\<\"\\\"CL49\\\"\"\>", ",", "\<\"\\\"CL50\\\"\"\>", 
     ",", "\<\"\\\"CL51\\\"\"\>", ",", "\<\"\\\"AR\\\"\"\>", 
     ",", "\<\"\\\"AR30\\\"\"\>", ",", "\<\"\\\"AR31\\\"\"\>", 
     ",", "\<\"\\\"AR32\\\"\"\>", ",", "\<\"\\\"AR33\\\"\"\>", 
     ",", "\<\"\\\"AR34\\\"\"\>", ",", "\<\"\\\"AR35\\\"\"\>", 
     ",", "\<\"\\\"AR36\\\"\"\>", ",", "\<\"\\\"AR37\\\"\"\>", 
     ",", "\<\"\\\"AR38\\\"\"\>", ",", "\<\"\\\"AR39\\\"\"\>", 
     ",", "\<\"\\\"AR40\\\"\"\>", ",", "\<\"\\\"AR41\\\"\"\>", 
     ",", "\<\"\\\"AR42\\\"\"\>", ",", "\<\"\\\"AR43\\\"\"\>", 
     ",", "\<\"\\\"AR44\\\"\"\>", ",", "\<\"\\\"AR45\\\"\"\>", 
     ",", "\<\"\\\"AR46\\\"\"\>", ",", "\<\"\\\"AR47\\\"\"\>", 
     ",", "\<\"\\\"AR48\\\"\"\>", ",", "\<\"\\\"AR49\\\"\"\>", 
     ",", "\<\"\\\"AR50\\\"\"\>", ",", "\<\"\\\"AR51\\\"\"\>", 
     ",", "\<\"\\\"AR52\\\"\"\>", ",", "\<\"\\\"AR53\\\"\"\>", 
     ",", "\<\"\\\"K\\\"\"\>", ",", "\<\"\\\"K32\\\"\"\>", 
     ",", "\<\"\\\"K33\\\"\"\>", ",", "\<\"\\\"K34\\\"\"\>", 
     ",", "\<\"\\\"K35\\\"\"\>", ",", "\<\"\\\"K36\\\"\"\>", 
     ",", "\<\"\\\"K37\\\"\"\>", ",", "\<\"\\\"K38\\\"\"\>", 
     ",", "\<\"\\\"K39\\\"\"\>", ",", "\<\"\\\"K40\\\"\"\>", 
     ",", "\<\"\\\"K41\\\"\"\>", ",", "\<\"\\\"K42\\\"\"\>", 
     ",", "\<\"\\\"K43\\\"\"\>", ",", "\<\"\\\"K44\\\"\"\>", 
     ",", "\<\"\\\"K45\\\"\"\>", ",", "\<\"\\\"K46\\\"\"\>", 
     ",", "\<\"\\\"K47\\\"\"\>", ",", "\<\"\\\"K48\\\"\"\>", 
     ",", "\<\"\\\"K49\\\"\"\>", ",", "\<\"\\\"K50\\\"\"\>", 
     ",", "\<\"\\\"K51\\\"\"\>", ",", "\<\"\\\"K52\\\"\"\>", 
     ",", "\<\"\\\"K53\\\"\"\>", ",", "\<\"\\\"K54\\\"\"\>", 
     ",", "\<\"\\\"K55\\\"\"\>", ",", "\<\"\\\"CA\\\"\"\>", 
     ",", "\<\"\\\"CA34\\\"\"\>", ",", "\<\"\\\"CA35\\\"\"\>", 
     ",", "\<\"\\\"CA36\\\"\"\>", ",", "\<\"\\\"CA37\\\"\"\>", 
     ",", "\<\"\\\"CA38\\\"\"\>", ",", "\<\"\\\"CA39\\\"\"\>", 
     ",", "\<\"\\\"CA40\\\"\"\>", ",", "\<\"\\\"CA41\\\"\"\>", 
     ",", "\<\"\\\"CA42\\\"\"\>", ",", "\<\"\\\"CA43\\\"\"\>", 
     ",", "\<\"\\\"CA44\\\"\"\>", ",", "\<\"\\\"CA45\\\"\"\>", 
     ",", "\<\"\\\"CA46\\\"\"\>", ",", "\<\"\\\"CA47\\\"\"\>", 
     ",", "\<\"\\\"CA48\\\"\"\>", ",", "\<\"\\\"CA49\\\"\"\>", 
     ",", "\<\"\\\"CA50\\\"\"\>", ",", "\<\"\\\"CA51\\\"\"\>", 
     ",", "\<\"\\\"CA52\\\"\"\>", ",", "\<\"\\\"CA53\\\"\"\>", 
     ",", "\<\"\\\"CA54\\\"\"\>", ",", "\<\"\\\"CA55\\\"\"\>", 
     ",", "\<\"\\\"CA56\\\"\"\>", ",", "\<\"\\\"CA57\\\"\"\>", 
     ",", "\<\"\\\"SC\\\"\"\>", ",", "\<\"\\\"SC36\\\"\"\>", 
     ",", "\<\"\\\"SC37\\\"\"\>", ",", "\<\"\\\"SC38\\\"\"\>", 
     ",", "\<\"\\\"SC39\\\"\"\>", ",", "\<\"\\\"SC40\\\"\"\>", 
     ",", "\<\"\\\"SC41\\\"\"\>", ",", "\<\"\\\"SC42\\\"\"\>", 
     ",", "\<\"\\\"SC43\\\"\"\>", ",", "\<\"\\\"SC44\\\"\"\>", 
     ",", "\<\"\\\"SC45\\\"\"\>", ",", "\<\"\\\"SC46\\\"\"\>", 
     ",", "\<\"\\\"SC47\\\"\"\>", ",", "\<\"\\\"SC48\\\"\"\>", 
     ",", "\<\"\\\"SC49\\\"\"\>", ",", "\<\"\\\"SC50\\\"\"\>", 
     ",", "\<\"\\\"SC51\\\"\"\>", ",", "\<\"\\\"SC52\\\"\"\>", 
     ",", "\<\"\\\"SC53\\\"\"\>", ",", "\<\"\\\"SC54\\\"\"\>", 
     ",", "\<\"\\\"SC55\\\"\"\>", ",", "\<\"\\\"SC56\\\"\"\>", 
     ",", "\<\"\\\"SC57\\\"\"\>", ",", "\<\"\\\"SC58\\\"\"\>", 
     ",", "\<\"\\\"SC59\\\"\"\>", ",", "\<\"\\\"SC60\\\"\"\>", 
     ",", "\<\"\\\"TI\\\"\"\>", ",", "\<\"\\\"TI38\\\"\"\>", 
     ",", "\<\"\\\"TI39\\\"\"\>", ",", "\<\"\\\"TI40\\\"\"\>", 
     ",", "\<\"\\\"TI41\\\"\"\>", ",", "\<\"\\\"TI42\\\"\"\>", 
     ",", "\<\"\\\"TI43\\\"\"\>", ",", "\<\"\\\"TI44\\\"\"\>", 
     ",", "\<\"\\\"TI45\\\"\"\>", ",", "\<\"\\\"TI46\\\"\"\>", 
     ",", "\<\"\\\"TI47\\\"\"\>", ",", "\<\"\\\"TI48\\\"\"\>", 
     ",", "\<\"\\\"TI49\\\"\"\>", ",", "\<\"\\\"TI50\\\"\"\>", 
     ",", "\<\"\\\"TI51\\\"\"\>", ",", "\<\"\\\"TI52\\\"\"\>", 
     ",", "\<\"\\\"TI53\\\"\"\>", ",", "\<\"\\\"TI54\\\"\"\>", 
     ",", "\<\"\\\"TI55\\\"\"\>", ",", "\<\"\\\"TI56\\\"\"\>", 
     ",", "\<\"\\\"TI57\\\"\"\>", ",", "\<\"\\\"TI58\\\"\"\>", 
     ",", "\<\"\\\"TI59\\\"\"\>", ",", "\<\"\\\"TI60\\\"\"\>", 
     ",", "\<\"\\\"TI61\\\"\"\>", ",", "\<\"\\\"TI62\\\"\"\>", 
     ",", "\<\"\\\"TI63\\\"\"\>", ",", "\<\"\\\"V\\\"\"\>", 
     ",", "\<\"\\\"V40\\\"\"\>", ",", "\<\"\\\"V41\\\"\"\>", 
     ",", "\<\"\\\"V42\\\"\"\>", ",", "\<\"\\\"V43\\\"\"\>", 
     ",", "\<\"\\\"V44\\\"\"\>", ",", "\<\"\\\"V45\\\"\"\>", 
     ",", "\<\"\\\"V46\\\"\"\>", ",", "\<\"\\\"V47\\\"\"\>", 
     ",", "\<\"\\\"V48\\\"\"\>", ",", "\<\"\\\"V49\\\"\"\>", 
     ",", "\<\"\\\"V50\\\"\"\>", ",", "\<\"\\\"V51\\\"\"\>", 
     ",", "\<\"\\\"V52\\\"\"\>", ",", "\<\"\\\"V53\\\"\"\>", 
     ",", "\<\"\\\"V54\\\"\"\>", ",", "\<\"\\\"V55\\\"\"\>", 
     ",", "\<\"\\\"V56\\\"\"\>", ",", "\<\"\\\"V57\\\"\"\>", 
     ",", "\<\"\\\"V58\\\"\"\>", ",", "\<\"\\\"V59\\\"\"\>", 
     ",", "\<\"\\\"V60\\\"\"\>", ",", "\<\"\\\"V61\\\"\"\>", 
     ",", "\<\"\\\"V62\\\"\"\>", ",", "\<\"\\\"V63\\\"\"\>", 
     ",", "\<\"\\\"V64\\\"\"\>", ",", "\<\"\\\"V65\\\"\"\>", 
     ",", "\<\"\\\"CR\\\"\"\>", ",", "\<\"\\\"CR42\\\"\"\>", 
     ",", "\<\"\\\"CR43\\\"\"\>", ",", "\<\"\\\"CR44\\\"\"\>", 
     ",", "\<\"\\\"CR45\\\"\"\>", ",", "\<\"\\\"CR46\\\"\"\>", 
     ",", "\<\"\\\"CR47\\\"\"\>", ",", "\<\"\\\"CR48\\\"\"\>", 
     ",", "\<\"\\\"CR49\\\"\"\>", ",", "\<\"\\\"CR50\\\"\"\>", 
     ",", "\<\"\\\"CR51\\\"\"\>", ",", "\<\"\\\"CR52\\\"\"\>", 
     ",", "\<\"\\\"CR53\\\"\"\>", ",", "\<\"\\\"CR54\\\"\"\>", 
     ",", "\<\"\\\"CR55\\\"\"\>", ",", "\<\"\\\"CR56\\\"\"\>", 
     ",", "\<\"\\\"CR57\\\"\"\>", ",", "\<\"\\\"CR58\\\"\"\>", 
     ",", "\<\"\\\"CR59\\\"\"\>", ",", "\<\"\\\"CR60\\\"\"\>", 
     ",", "\<\"\\\"CR61\\\"\"\>", ",", "\<\"\\\"CR62\\\"\"\>", 
     ",", "\<\"\\\"CR63\\\"\"\>", ",", "\<\"\\\"CR64\\\"\"\>", 
     ",", "\<\"\\\"CR65\\\"\"\>", ",", "\<\"\\\"CR66\\\"\"\>", 
     ",", "\<\"\\\"CR67\\\"\"\>", ",", "\<\"\\\"MN\\\"\"\>", 
     ",", "\<\"\\\"MN44\\\"\"\>", ",", "\<\"\\\"MN45\\\"\"\>", 
     ",", "\<\"\\\"MN46\\\"\"\>", ",", "\<\"\\\"MN47\\\"\"\>", 
     ",", "\<\"\\\"MN48\\\"\"\>", ",", "\<\"\\\"MN49\\\"\"\>", 
     ",", "\<\"\\\"MN50\\\"\"\>", ",", "\<\"\\\"MN51\\\"\"\>", 
     ",", "\<\"\\\"MN52\\\"\"\>", ",", "\<\"\\\"MN53\\\"\"\>", 
     ",", "\<\"\\\"MN54\\\"\"\>", ",", "\<\"\\\"MN55\\\"\"\>", 
     ",", "\<\"\\\"MN56\\\"\"\>", ",", "\<\"\\\"MN57\\\"\"\>", 
     ",", "\<\"\\\"MN58\\\"\"\>", ",", "\<\"\\\"MN59\\\"\"\>", 
     ",", "\<\"\\\"MN60\\\"\"\>", ",", "\<\"\\\"MN61\\\"\"\>", 
     ",", "\<\"\\\"MN62\\\"\"\>", ",", "\<\"\\\"MN63\\\"\"\>", 
     ",", "\<\"\\\"MN64\\\"\"\>", ",", "\<\"\\\"MN65\\\"\"\>", 
     ",", "\<\"\\\"MN66\\\"\"\>", ",", "\<\"\\\"MN67\\\"\"\>", 
     ",", "\<\"\\\"MN68\\\"\"\>", ",", "\<\"\\\"MN69\\\"\"\>", 
     ",", "\<\"\\\"FE\\\"\"\>", ",", "\<\"\\\"FE45\\\"\"\>", 
     ",", "\<\"\\\"FE46\\\"\"\>", ",", "\<\"\\\"FE47\\\"\"\>", 
     ",", "\<\"\\\"FE48\\\"\"\>", ",", "\<\"\\\"FE49\\\"\"\>", 
     ",", "\<\"\\\"FE50\\\"\"\>", ",", "\<\"\\\"FE51\\\"\"\>", 
     ",", "\<\"\\\"FE52\\\"\"\>", ",", "\<\"\\\"FE53\\\"\"\>", 
     ",", "\<\"\\\"FE54\\\"\"\>", ",", "\<\"\\\"FE55\\\"\"\>", 
     ",", "\<\"\\\"FE56\\\"\"\>", ",", "\<\"\\\"FE57\\\"\"\>", 
     ",", "\<\"\\\"FE58\\\"\"\>", ",", "\<\"\\\"FE59\\\"\"\>", 
     ",", "\<\"\\\"FE60\\\"\"\>", ",", "\<\"\\\"FE61\\\"\"\>", 
     ",", "\<\"\\\"FE62\\\"\"\>", ",", "\<\"\\\"FE63\\\"\"\>", 
     ",", "\<\"\\\"FE64\\\"\"\>", ",", "\<\"\\\"FE65\\\"\"\>", 
     ",", "\<\"\\\"FE66\\\"\"\>", ",", "\<\"\\\"FE67\\\"\"\>", 
     ",", "\<\"\\\"FE68\\\"\"\>", ",", "\<\"\\\"FE69\\\"\"\>", 
     ",", "\<\"\\\"FE70\\\"\"\>", ",", "\<\"\\\"FE71\\\"\"\>", 
     ",", "\<\"\\\"FE72\\\"\"\>", ",", "\<\"\\\"CO\\\"\"\>", 
     ",", "\<\"\\\"CO47\\\"\"\>", ",", "\<\"\\\"CO48\\\"\"\>", 
     ",", "\<\"\\\"CO49\\\"\"\>", ",", "\<\"\\\"CO50\\\"\"\>", 
     ",", "\<\"\\\"CO51\\\"\"\>", ",", "\<\"\\\"CO52\\\"\"\>", 
     ",", "\<\"\\\"CO53\\\"\"\>", ",", "\<\"\\\"CO54\\\"\"\>", 
     ",", "\<\"\\\"CO55\\\"\"\>", ",", "\<\"\\\"CO56\\\"\"\>", 
     ",", "\<\"\\\"CO57\\\"\"\>", ",", "\<\"\\\"CO58\\\"\"\>", 
     ",", "\<\"\\\"CO59\\\"\"\>", ",", "\<\"\\\"CO60\\\"\"\>", 
     ",", "\<\"\\\"CO61\\\"\"\>", ",", "\<\"\\\"CO62\\\"\"\>", 
     ",", "\<\"\\\"CO63\\\"\"\>", ",", "\<\"\\\"CO64\\\"\"\>", 
     ",", "\<\"\\\"CO65\\\"\"\>", ",", "\<\"\\\"CO66\\\"\"\>", 
     ",", "\<\"\\\"CO67\\\"\"\>", ",", "\<\"\\\"CO68\\\"\"\>", 
     ",", "\<\"\\\"CO69\\\"\"\>", ",", "\<\"\\\"CO70\\\"\"\>", 
     ",", "\<\"\\\"CO71\\\"\"\>", ",", "\<\"\\\"CO72\\\"\"\>", 
     ",", "\<\"\\\"CO73\\\"\"\>", ",", "\<\"\\\"CO74\\\"\"\>", 
     ",", "\<\"\\\"CO75\\\"\"\>", ",", "\<\"\\\"NI\\\"\"\>", 
     ",", "\<\"\\\"NI48\\\"\"\>", ",", "\<\"\\\"NI49\\\"\"\>", 
     ",", "\<\"\\\"NI50\\\"\"\>", ",", "\<\"\\\"NI51\\\"\"\>", 
     ",", "\<\"\\\"NI52\\\"\"\>", ",", "\<\"\\\"NI53\\\"\"\>", 
     ",", "\<\"\\\"NI54\\\"\"\>", ",", "\<\"\\\"NI55\\\"\"\>", 
     ",", "\<\"\\\"NI56\\\"\"\>", ",", "\<\"\\\"NI57\\\"\"\>", 
     ",", "\<\"\\\"NI58\\\"\"\>", ",", "\<\"\\\"NI59\\\"\"\>", 
     ",", "\<\"\\\"NI60\\\"\"\>", ",", "\<\"\\\"NI61\\\"\"\>", 
     ",", "\<\"\\\"NI62\\\"\"\>", ",", "\<\"\\\"NI63\\\"\"\>", 
     ",", "\<\"\\\"NI64\\\"\"\>", ",", "\<\"\\\"NI65\\\"\"\>", 
     ",", "\<\"\\\"NI66\\\"\"\>", ",", "\<\"\\\"NI67\\\"\"\>", 
     ",", "\<\"\\\"NI68\\\"\"\>", ",", "\<\"\\\"NI69\\\"\"\>", 
     ",", "\<\"\\\"NI70\\\"\"\>", ",", "\<\"\\\"NI71\\\"\"\>", 
     ",", "\<\"\\\"NI72\\\"\"\>", ",", "\<\"\\\"NI73\\\"\"\>", 
     ",", "\<\"\\\"NI74\\\"\"\>", ",", "\<\"\\\"NI75\\\"\"\>", 
     ",", "\<\"\\\"NI76\\\"\"\>", ",", "\<\"\\\"NI77\\\"\"\>", 
     ",", "\<\"\\\"NI78\\\"\"\>", ",", "\<\"\\\"CU\\\"\"\>", 
     ",", "\<\"\\\"CU52\\\"\"\>", ",", "\<\"\\\"CU53\\\"\"\>", 
     ",", "\<\"\\\"CU54\\\"\"\>", ",", "\<\"\\\"CU55\\\"\"\>", 
     ",", "\<\"\\\"CU56\\\"\"\>", ",", "\<\"\\\"CU57\\\"\"\>", 
     ",", "\<\"\\\"CU58\\\"\"\>", ",", "\<\"\\\"CU59\\\"\"\>", 
     ",", "\<\"\\\"CU60\\\"\"\>", ",", "\<\"\\\"CU61\\\"\"\>", 
     ",", "\<\"\\\"CU62\\\"\"\>", ",", "\<\"\\\"CU63\\\"\"\>", 
     ",", "\<\"\\\"CU64\\\"\"\>", ",", "\<\"\\\"CU65\\\"\"\>", 
     ",", "\<\"\\\"CU66\\\"\"\>", ",", "\<\"\\\"CU67\\\"\"\>", 
     ",", "\<\"\\\"CU68\\\"\"\>", ",", "\<\"\\\"CU69\\\"\"\>", 
     ",", "\<\"\\\"CU70\\\"\"\>", ",", "\<\"\\\"CU71\\\"\"\>", 
     ",", "\<\"\\\"CU72\\\"\"\>", ",", "\<\"\\\"CU73\\\"\"\>", 
     ",", "\<\"\\\"CU74\\\"\"\>", ",", "\<\"\\\"CU75\\\"\"\>", 
     ",", "\<\"\\\"CU76\\\"\"\>", ",", "\<\"\\\"CU77\\\"\"\>", 
     ",", "\<\"\\\"CU78\\\"\"\>", ",", "\<\"\\\"CU79\\\"\"\>", 
     ",", "\<\"\\\"CU80\\\"\"\>", ",", "\<\"\\\"ZN\\\"\"\>", 
     ",", "\<\"\\\"ZN54\\\"\"\>", ",", "\<\"\\\"ZN55\\\"\"\>", 
     ",", "\<\"\\\"ZN56\\\"\"\>", ",", "\<\"\\\"ZN57\\\"\"\>", 
     ",", "\<\"\\\"ZN58\\\"\"\>", ",", "\<\"\\\"ZN59\\\"\"\>", 
     ",", "\<\"\\\"ZN60\\\"\"\>", ",", "\<\"\\\"ZN61\\\"\"\>", 
     ",", "\<\"\\\"ZN62\\\"\"\>", ",", "\<\"\\\"ZN63\\\"\"\>", 
     ",", "\<\"\\\"ZN64\\\"\"\>", ",", "\<\"\\\"ZN65\\\"\"\>", 
     ",", "\<\"\\\"ZN66\\\"\"\>", ",", "\<\"\\\"ZN67\\\"\"\>", 
     ",", "\<\"\\\"ZN68\\\"\"\>", ",", "\<\"\\\"ZN69\\\"\"\>", 
     ",", "\<\"\\\"ZN70\\\"\"\>", ",", "\<\"\\\"ZN71\\\"\"\>", 
     ",", "\<\"\\\"ZN72\\\"\"\>", ",", "\<\"\\\"ZN73\\\"\"\>", 
     ",", "\<\"\\\"ZN74\\\"\"\>", ",", "\<\"\\\"ZN75\\\"\"\>", 
     ",", "\<\"\\\"ZN76\\\"\"\>", ",", "\<\"\\\"ZN77\\\"\"\>", 
     ",", "\<\"\\\"ZN78\\\"\"\>", ",", "\<\"\\\"ZN79\\\"\"\>", 
     ",", "\<\"\\\"ZN80\\\"\"\>", ",", "\<\"\\\"ZN81\\\"\"\>", 
     ",", "\<\"\\\"ZN82\\\"\"\>", ",", "\<\"\\\"ZN83\\\"\"\>", 
     ",", "\<\"\\\"GA\\\"\"\>", ",", "\<\"\\\"GA56\\\"\"\>", 
     ",", "\<\"\\\"GA57\\\"\"\>", ",", "\<\"\\\"GA58\\\"\"\>", 
     ",", "\<\"\\\"GA59\\\"\"\>", ",", "\<\"\\\"GA60\\\"\"\>", 
     ",", "\<\"\\\"GA61\\\"\"\>", ",", "\<\"\\\"GA62\\\"\"\>", 
     ",", "\<\"\\\"GA63\\\"\"\>", ",", "\<\"\\\"GA64\\\"\"\>", 
     ",", "\<\"\\\"GA65\\\"\"\>", ",", "\<\"\\\"GA66\\\"\"\>", 
     ",", "\<\"\\\"GA67\\\"\"\>", ",", "\<\"\\\"GA68\\\"\"\>", 
     ",", "\<\"\\\"GA69\\\"\"\>", ",", "\<\"\\\"GA70\\\"\"\>", 
     ",", "\<\"\\\"GA71\\\"\"\>", ",", "\<\"\\\"GA72\\\"\"\>", 
     ",", "\<\"\\\"GA73\\\"\"\>", ",", "\<\"\\\"GA74\\\"\"\>", 
     ",", "\<\"\\\"GA75\\\"\"\>", ",", "\<\"\\\"GA76\\\"\"\>", 
     ",", "\<\"\\\"GA77\\\"\"\>", ",", "\<\"\\\"GA78\\\"\"\>", 
     ",", "\<\"\\\"GA79\\\"\"\>", ",", "\<\"\\\"GA80\\\"\"\>", 
     ",", "\<\"\\\"GA81\\\"\"\>", ",", "\<\"\\\"GA82\\\"\"\>", 
     ",", "\<\"\\\"GA83\\\"\"\>", ",", "\<\"\\\"GA84\\\"\"\>", 
     ",", "\<\"\\\"GA85\\\"\"\>", ",", "\<\"\\\"GA86\\\"\"\>", 
     ",", "\<\"\\\"GE\\\"\"\>", ",", "\<\"\\\"GE58\\\"\"\>", 
     ",", "\<\"\\\"GE59\\\"\"\>", ",", "\<\"\\\"GE60\\\"\"\>", 
     ",", "\<\"\\\"GE61\\\"\"\>", ",", "\<\"\\\"GE62\\\"\"\>", 
     ",", "\<\"\\\"GE63\\\"\"\>", ",", "\<\"\\\"GE64\\\"\"\>", 
     ",", "\<\"\\\"GE65\\\"\"\>", ",", "\<\"\\\"GE66\\\"\"\>", 
     ",", "\<\"\\\"GE67\\\"\"\>", ",", "\<\"\\\"GE68\\\"\"\>", 
     ",", "\<\"\\\"GE69\\\"\"\>", ",", "\<\"\\\"GE70\\\"\"\>", 
     ",", "\<\"\\\"GE71\\\"\"\>", ",", "\<\"\\\"GE72\\\"\"\>", 
     ",", "\<\"\\\"GE73\\\"\"\>", ",", "\<\"\\\"GE74\\\"\"\>", 
     ",", "\<\"\\\"GE75\\\"\"\>", ",", "\<\"\\\"GE76\\\"\"\>", 
     ",", "\<\"\\\"GE77\\\"\"\>", ",", "\<\"\\\"GE78\\\"\"\>", 
     ",", "\<\"\\\"GE79\\\"\"\>", ",", "\<\"\\\"GE80\\\"\"\>", 
     ",", "\<\"\\\"GE81\\\"\"\>", ",", "\<\"\\\"GE82\\\"\"\>", 
     ",", "\<\"\\\"GE83\\\"\"\>", ",", "\<\"\\\"GE84\\\"\"\>", 
     ",", "\<\"\\\"GE85\\\"\"\>", ",", "\<\"\\\"GE86\\\"\"\>", 
     ",", "\<\"\\\"GE87\\\"\"\>", ",", "\<\"\\\"GE88\\\"\"\>", 
     ",", "\<\"\\\"GE89\\\"\"\>", ",", "\<\"\\\"AS\\\"\"\>", 
     ",", "\<\"\\\"AS60\\\"\"\>", ",", "\<\"\\\"AS61\\\"\"\>", 
     ",", "\<\"\\\"AS62\\\"\"\>", ",", "\<\"\\\"AS63\\\"\"\>", 
     ",", "\<\"\\\"AS64\\\"\"\>", ",", "\<\"\\\"AS65\\\"\"\>", 
     ",", "\<\"\\\"AS66\\\"\"\>", ",", "\<\"\\\"AS67\\\"\"\>", 
     ",", "\<\"\\\"AS68\\\"\"\>", ",", "\<\"\\\"AS69\\\"\"\>", 
     ",", "\<\"\\\"AS70\\\"\"\>", ",", "\<\"\\\"AS71\\\"\"\>", 
     ",", "\<\"\\\"AS72\\\"\"\>", ",", "\<\"\\\"AS73\\\"\"\>", 
     ",", "\<\"\\\"AS74\\\"\"\>", ",", "\<\"\\\"AS75\\\"\"\>", 
     ",", "\<\"\\\"AS76\\\"\"\>", ",", "\<\"\\\"AS77\\\"\"\>", 
     ",", "\<\"\\\"AS78\\\"\"\>", ",", "\<\"\\\"AS79\\\"\"\>", 
     ",", "\<\"\\\"AS80\\\"\"\>", ",", "\<\"\\\"AS81\\\"\"\>", 
     ",", "\<\"\\\"AS82\\\"\"\>", ",", "\<\"\\\"AS83\\\"\"\>", 
     ",", "\<\"\\\"AS84\\\"\"\>", ",", "\<\"\\\"AS85\\\"\"\>", 
     ",", "\<\"\\\"AS86\\\"\"\>", ",", "\<\"\\\"AS87\\\"\"\>", 
     ",", "\<\"\\\"AS88\\\"\"\>", ",", "\<\"\\\"AS89\\\"\"\>", 
     ",", "\<\"\\\"AS90\\\"\"\>", ",", "\<\"\\\"AS91\\\"\"\>", 
     ",", "\<\"\\\"AS92\\\"\"\>", ",", "\<\"\\\"SE\\\"\"\>", 
     ",", "\<\"\\\"SE65\\\"\"\>", ",", "\<\"\\\"SE66\\\"\"\>", 
     ",", "\<\"\\\"SE67\\\"\"\>", ",", "\<\"\\\"SE68\\\"\"\>", 
     ",", "\<\"\\\"SE69\\\"\"\>", ",", "\<\"\\\"SE70\\\"\"\>", 
     ",", "\<\"\\\"SE71\\\"\"\>", ",", "\<\"\\\"SE72\\\"\"\>", 
     ",", "\<\"\\\"SE73\\\"\"\>", ",", "\<\"\\\"SE74\\\"\"\>", 
     ",", "\<\"\\\"SE75\\\"\"\>", ",", "\<\"\\\"SE76\\\"\"\>", 
     ",", "\<\"\\\"SE77\\\"\"\>", ",", "\<\"\\\"SE78\\\"\"\>", 
     ",", "\<\"\\\"SE79\\\"\"\>", ",", "\<\"\\\"SE80\\\"\"\>", 
     ",", "\<\"\\\"SE81\\\"\"\>", ",", "\<\"\\\"SE82\\\"\"\>", 
     ",", "\<\"\\\"SE83\\\"\"\>", ",", "\<\"\\\"SE84\\\"\"\>", 
     ",", "\<\"\\\"SE85\\\"\"\>", ",", "\<\"\\\"SE86\\\"\"\>", 
     ",", "\<\"\\\"SE87\\\"\"\>", ",", "\<\"\\\"SE88\\\"\"\>", 
     ",", "\<\"\\\"SE89\\\"\"\>", ",", "\<\"\\\"SE90\\\"\"\>", 
     ",", "\<\"\\\"SE91\\\"\"\>", ",", "\<\"\\\"SE92\\\"\"\>", 
     ",", "\<\"\\\"SE93\\\"\"\>", ",", "\<\"\\\"SE94\\\"\"\>", 
     ",", "\<\"\\\"BR\\\"\"\>", ",", "\<\"\\\"BR67\\\"\"\>", 
     ",", "\<\"\\\"BR68\\\"\"\>", ",", "\<\"\\\"BR69\\\"\"\>", 
     ",", "\<\"\\\"BR70\\\"\"\>", ",", "\<\"\\\"BR71\\\"\"\>", 
     ",", "\<\"\\\"BR72\\\"\"\>", ",", "\<\"\\\"BR73\\\"\"\>", 
     ",", "\<\"\\\"BR74\\\"\"\>", ",", "\<\"\\\"BR75\\\"\"\>", 
     ",", "\<\"\\\"BR76\\\"\"\>", ",", "\<\"\\\"BR77\\\"\"\>", 
     ",", "\<\"\\\"BR78\\\"\"\>", ",", "\<\"\\\"BR79\\\"\"\>", 
     ",", "\<\"\\\"BR80\\\"\"\>", ",", "\<\"\\\"BR81\\\"\"\>", 
     ",", "\<\"\\\"BR82\\\"\"\>", ",", "\<\"\\\"BR83\\\"\"\>", 
     ",", "\<\"\\\"BR84\\\"\"\>", ",", "\<\"\\\"BR85\\\"\"\>", 
     ",", "\<\"\\\"BR86\\\"\"\>", ",", "\<\"\\\"BR87\\\"\"\>", 
     ",", "\<\"\\\"BR88\\\"\"\>", ",", "\<\"\\\"BR89\\\"\"\>", 
     ",", "\<\"\\\"BR90\\\"\"\>", ",", "\<\"\\\"BR91\\\"\"\>", 
     ",", "\<\"\\\"BR92\\\"\"\>", ",", "\<\"\\\"BR93\\\"\"\>", 
     ",", "\<\"\\\"BR94\\\"\"\>", ",", "\<\"\\\"BR95\\\"\"\>", 
     ",", "\<\"\\\"BR96\\\"\"\>", ",", "\<\"\\\"BR97\\\"\"\>", 
     ",", "\<\"\\\"KR\\\"\"\>", ",", "\<\"\\\"KR69\\\"\"\>", 
     ",", "\<\"\\\"KR70\\\"\"\>", ",", "\<\"\\\"KR71\\\"\"\>", 
     ",", "\<\"\\\"KR72\\\"\"\>", ",", "\<\"\\\"KR73\\\"\"\>", 
     ",", "\<\"\\\"KR74\\\"\"\>", ",", "\<\"\\\"KR75\\\"\"\>", 
     ",", "\<\"\\\"KR76\\\"\"\>", ",", "\<\"\\\"KR77\\\"\"\>", 
     ",", "\<\"\\\"KR78\\\"\"\>", ",", "\<\"\\\"KR79\\\"\"\>", 
     ",", "\<\"\\\"KR80\\\"\"\>", ",", "\<\"\\\"KR81\\\"\"\>", 
     ",", "\<\"\\\"KR82\\\"\"\>", ",", "\<\"\\\"KR83\\\"\"\>", 
     ",", "\<\"\\\"KR84\\\"\"\>", ",", "\<\"\\\"KR85\\\"\"\>", 
     ",", "\<\"\\\"KR86\\\"\"\>", ",", "\<\"\\\"KR87\\\"\"\>", 
     ",", "\<\"\\\"KR88\\\"\"\>", ",", "\<\"\\\"KR89\\\"\"\>", 
     ",", "\<\"\\\"KR90\\\"\"\>", ",", "\<\"\\\"KR91\\\"\"\>", 
     ",", "\<\"\\\"KR92\\\"\"\>", ",", "\<\"\\\"KR93\\\"\"\>", 
     ",", "\<\"\\\"KR94\\\"\"\>", ",", "\<\"\\\"KR95\\\"\"\>", 
     ",", "\<\"\\\"KR96\\\"\"\>", ",", "\<\"\\\"KR97\\\"\"\>", 
     ",", "\<\"\\\"KR98\\\"\"\>", ",", "\<\"\\\"KR99\\\"\"\>", 
     ",", "\<\"\\\"KR100\\\"\"\>", ",", "\<\"\\\"RB\\\"\"\>", 
     ",", "\<\"\\\"RB71\\\"\"\>", ",", "\<\"\\\"RB72\\\"\"\>", 
     ",", "\<\"\\\"RB73\\\"\"\>", ",", "\<\"\\\"RB74\\\"\"\>", 
     ",", "\<\"\\\"RB75\\\"\"\>", ",", "\<\"\\\"RB76\\\"\"\>", 
     ",", "\<\"\\\"RB77\\\"\"\>", ",", "\<\"\\\"RB78\\\"\"\>", 
     ",", "\<\"\\\"RB79\\\"\"\>", ",", "\<\"\\\"RB80\\\"\"\>", 
     ",", "\<\"\\\"RB81\\\"\"\>", ",", "\<\"\\\"RB82\\\"\"\>", 
     ",", "\<\"\\\"RB83\\\"\"\>", ",", "\<\"\\\"RB84\\\"\"\>", 
     ",", "\<\"\\\"RB85\\\"\"\>", ",", "\<\"\\\"RB86\\\"\"\>", 
     ",", "\<\"\\\"RB87\\\"\"\>", ",", "\<\"\\\"RB88\\\"\"\>", 
     ",", "\<\"\\\"RB89\\\"\"\>", ",", "\<\"\\\"RB90\\\"\"\>", 
     ",", "\<\"\\\"RB91\\\"\"\>", ",", "\<\"\\\"RB92\\\"\"\>", 
     ",", "\<\"\\\"RB93\\\"\"\>", ",", "\<\"\\\"RB94\\\"\"\>", 
     ",", "\<\"\\\"RB95\\\"\"\>", ",", "\<\"\\\"RB96\\\"\"\>", 
     ",", "\<\"\\\"RB97\\\"\"\>", ",", "\<\"\\\"RB98\\\"\"\>", 
     ",", "\<\"\\\"RB99\\\"\"\>", ",", "\<\"\\\"RB100\\\"\"\>", 
     ",", "\<\"\\\"RB101\\\"\"\>", ",", "\<\"\\\"RB102\\\"\"\>", 
     ",", "\<\"\\\"SR\\\"\"\>", ",", "\<\"\\\"SR73\\\"\"\>", 
     ",", "\<\"\\\"SR74\\\"\"\>", ",", "\<\"\\\"SR75\\\"\"\>", 
     ",", "\<\"\\\"SR76\\\"\"\>", ",", "\<\"\\\"SR77\\\"\"\>", 
     ",", "\<\"\\\"SR78\\\"\"\>", ",", "\<\"\\\"SR79\\\"\"\>", 
     ",", "\<\"\\\"SR80\\\"\"\>", ",", "\<\"\\\"SR81\\\"\"\>", 
     ",", "\<\"\\\"SR82\\\"\"\>", ",", "\<\"\\\"SR83\\\"\"\>", 
     ",", "\<\"\\\"SR84\\\"\"\>", ",", "\<\"\\\"SR85\\\"\"\>", 
     ",", "\<\"\\\"SR86\\\"\"\>", ",", "\<\"\\\"SR87\\\"\"\>", 
     ",", "\<\"\\\"SR88\\\"\"\>", ",", "\<\"\\\"SR89\\\"\"\>", 
     ",", "\<\"\\\"SR90\\\"\"\>", ",", "\<\"\\\"SR91\\\"\"\>", 
     ",", "\<\"\\\"SR92\\\"\"\>", ",", "\<\"\\\"SR93\\\"\"\>", 
     ",", "\<\"\\\"SR94\\\"\"\>", ",", "\<\"\\\"SR95\\\"\"\>", 
     ",", "\<\"\\\"SR96\\\"\"\>", ",", "\<\"\\\"SR97\\\"\"\>", 
     ",", "\<\"\\\"SR98\\\"\"\>", ",", "\<\"\\\"SR99\\\"\"\>", 
     ",", "\<\"\\\"SR100\\\"\"\>", ",", "\<\"\\\"SR101\\\"\"\>", 
     ",", "\<\"\\\"SR102\\\"\"\>", ",", "\<\"\\\"SR103\\\"\"\>", 
     ",", "\<\"\\\"SR104\\\"\"\>", ",", "\<\"\\\"SR105\\\"\"\>", 
     ",", "\<\"\\\"Y\\\"\"\>", ",", "\<\"\\\"Y76\\\"\"\>", 
     ",", "\<\"\\\"Y77\\\"\"\>", ",", "\<\"\\\"Y78\\\"\"\>", 
     ",", "\<\"\\\"Y79\\\"\"\>", ",", "\<\"\\\"Y80\\\"\"\>", 
     ",", "\<\"\\\"Y81\\\"\"\>", ",", "\<\"\\\"Y82\\\"\"\>", 
     ",", "\<\"\\\"Y83\\\"\"\>", ",", "\<\"\\\"Y84\\\"\"\>", 
     ",", "\<\"\\\"Y85\\\"\"\>", ",", "\<\"\\\"Y86\\\"\"\>", 
     ",", "\<\"\\\"Y87\\\"\"\>", ",", "\<\"\\\"Y88\\\"\"\>", 
     ",", "\<\"\\\"Y89\\\"\"\>", ",", "\<\"\\\"Y90\\\"\"\>", 
     ",", "\<\"\\\"Y91\\\"\"\>", ",", "\<\"\\\"Y92\\\"\"\>", 
     ",", "\<\"\\\"Y93\\\"\"\>", ",", "\<\"\\\"Y94\\\"\"\>", 
     ",", "\<\"\\\"Y95\\\"\"\>", ",", "\<\"\\\"Y96\\\"\"\>", 
     ",", "\<\"\\\"Y97\\\"\"\>", ",", "\<\"\\\"Y98\\\"\"\>", 
     ",", "\<\"\\\"Y99\\\"\"\>", ",", "\<\"\\\"Y100\\\"\"\>", 
     ",", "\<\"\\\"Y101\\\"\"\>", ",", "\<\"\\\"Y102\\\"\"\>", 
     ",", "\<\"\\\"Y103\\\"\"\>", ",", "\<\"\\\"Y104\\\"\"\>", 
     ",", "\<\"\\\"Y105\\\"\"\>", ",", "\<\"\\\"Y106\\\"\"\>", 
     ",", "\<\"\\\"Y107\\\"\"\>", ",", "\<\"\\\"Y108\\\"\"\>", 
     ",", "\<\"\\\"ZR\\\"\"\>", ",", "\<\"\\\"ZR78\\\"\"\>", 
     ",", "\<\"\\\"ZR79\\\"\"\>", ",", "\<\"\\\"ZR80\\\"\"\>", 
     ",", "\<\"\\\"ZR81\\\"\"\>", ",", "\<\"\\\"ZR82\\\"\"\>", 
     ",", "\<\"\\\"ZR83\\\"\"\>", ",", "\<\"\\\"ZR84\\\"\"\>", 
     ",", "\<\"\\\"ZR85\\\"\"\>", ",", "\<\"\\\"ZR86\\\"\"\>", 
     ",", "\<\"\\\"ZR87\\\"\"\>", ",", "\<\"\\\"ZR88\\\"\"\>", 
     ",", "\<\"\\\"ZR89\\\"\"\>", ",", "\<\"\\\"ZR90\\\"\"\>", 
     ",", "\<\"\\\"ZR91\\\"\"\>", ",", "\<\"\\\"ZR92\\\"\"\>", 
     ",", "\<\"\\\"ZR93\\\"\"\>", ",", "\<\"\\\"ZR94\\\"\"\>", 
     ",", "\<\"\\\"ZR95\\\"\"\>", ",", "\<\"\\\"ZR96\\\"\"\>", 
     ",", "\<\"\\\"ZR97\\\"\"\>", ",", "\<\"\\\"ZR98\\\"\"\>", 
     ",", "\<\"\\\"ZR99\\\"\"\>", ",", "\<\"\\\"ZR100\\\"\"\>", 
     ",", "\<\"\\\"ZR101\\\"\"\>", ",", "\<\"\\\"ZR102\\\"\"\>", 
     ",", "\<\"\\\"ZR103\\\"\"\>", ",", "\<\"\\\"ZR104\\\"\"\>", 
     ",", "\<\"\\\"ZR105\\\"\"\>", ",", "\<\"\\\"ZR106\\\"\"\>", 
     ",", "\<\"\\\"ZR107\\\"\"\>", ",", "\<\"\\\"ZR108\\\"\"\>", 
     ",", "\<\"\\\"ZR109\\\"\"\>", ",", "\<\"\\\"ZR110\\\"\"\>", 
     ",", "\<\"\\\"NB\\\"\"\>", ",", "\<\"\\\"NB81\\\"\"\>", 
     ",", "\<\"\\\"NB82\\\"\"\>", ",", "\<\"\\\"NB83\\\"\"\>", 
     ",", "\<\"\\\"NB84\\\"\"\>", ",", "\<\"\\\"NB85\\\"\"\>", 
     ",", "\<\"\\\"NB86\\\"\"\>", ",", "\<\"\\\"NB87\\\"\"\>", 
     ",", "\<\"\\\"NB88\\\"\"\>", ",", "\<\"\\\"NB89\\\"\"\>", 
     ",", "\<\"\\\"NB90\\\"\"\>", ",", "\<\"\\\"NB91\\\"\"\>", 
     ",", "\<\"\\\"NB92\\\"\"\>", ",", "\<\"\\\"NB93\\\"\"\>", 
     ",", "\<\"\\\"NB94\\\"\"\>", ",", "\<\"\\\"NB95\\\"\"\>", 
     ",", "\<\"\\\"NB96\\\"\"\>", ",", "\<\"\\\"NB97\\\"\"\>", 
     ",", "\<\"\\\"NB98\\\"\"\>", ",", "\<\"\\\"NB99\\\"\"\>", 
     ",", "\<\"\\\"NB100\\\"\"\>", ",", "\<\"\\\"NB101\\\"\"\>", 
     ",", "\<\"\\\"NB102\\\"\"\>", ",", "\<\"\\\"NB103\\\"\"\>", 
     ",", "\<\"\\\"NB104\\\"\"\>", ",", "\<\"\\\"NB105\\\"\"\>", 
     ",", "\<\"\\\"NB106\\\"\"\>", ",", "\<\"\\\"NB107\\\"\"\>", 
     ",", "\<\"\\\"NB108\\\"\"\>", ",", "\<\"\\\"NB109\\\"\"\>", 
     ",", "\<\"\\\"NB110\\\"\"\>", ",", "\<\"\\\"NB111\\\"\"\>", 
     ",", "\<\"\\\"NB112\\\"\"\>", ",", "\<\"\\\"NB113\\\"\"\>", 
     ",", "\<\"\\\"MO\\\"\"\>", ",", "\<\"\\\"MO83\\\"\"\>", 
     ",", "\<\"\\\"MO84\\\"\"\>", ",", "\<\"\\\"MO85\\\"\"\>", 
     ",", "\<\"\\\"MO86\\\"\"\>", ",", "\<\"\\\"MO87\\\"\"\>", 
     ",", "\<\"\\\"MO88\\\"\"\>", ",", "\<\"\\\"MO89\\\"\"\>", 
     ",", "\<\"\\\"MO90\\\"\"\>", ",", "\<\"\\\"MO91\\\"\"\>", 
     ",", "\<\"\\\"MO92\\\"\"\>", ",", "\<\"\\\"MO93\\\"\"\>", 
     ",", "\<\"\\\"MO94\\\"\"\>", ",", "\<\"\\\"MO95\\\"\"\>", 
     ",", "\<\"\\\"MO96\\\"\"\>", ",", "\<\"\\\"MO97\\\"\"\>", 
     ",", "\<\"\\\"MO98\\\"\"\>", ",", "\<\"\\\"MO99\\\"\"\>", 
     ",", "\<\"\\\"MO100\\\"\"\>", ",", "\<\"\\\"MO101\\\"\"\>", 
     ",", "\<\"\\\"MO102\\\"\"\>", ",", "\<\"\\\"MO103\\\"\"\>", 
     ",", "\<\"\\\"MO104\\\"\"\>", ",", "\<\"\\\"MO105\\\"\"\>", 
     ",", "\<\"\\\"MO106\\\"\"\>", ",", "\<\"\\\"MO107\\\"\"\>", 
     ",", "\<\"\\\"MO108\\\"\"\>", ",", "\<\"\\\"MO109\\\"\"\>", 
     ",", "\<\"\\\"MO110\\\"\"\>", ",", "\<\"\\\"MO111\\\"\"\>", 
     ",", "\<\"\\\"MO112\\\"\"\>", ",", "\<\"\\\"MO113\\\"\"\>", 
     ",", "\<\"\\\"MO114\\\"\"\>", ",", "\<\"\\\"MO115\\\"\"\>", 
     ",", "\<\"\\\"TC\\\"\"\>", ",", "\<\"\\\"TC85\\\"\"\>", 
     ",", "\<\"\\\"TC86\\\"\"\>", ",", "\<\"\\\"TC87\\\"\"\>", 
     ",", "\<\"\\\"TC88\\\"\"\>", ",", "\<\"\\\"TC89\\\"\"\>", 
     ",", "\<\"\\\"TC90\\\"\"\>", ",", "\<\"\\\"TC91\\\"\"\>", 
     ",", "\<\"\\\"TC92\\\"\"\>", ",", "\<\"\\\"TC93\\\"\"\>", 
     ",", "\<\"\\\"TC94\\\"\"\>", ",", "\<\"\\\"TC95\\\"\"\>", 
     ",", "\<\"\\\"TC96\\\"\"\>", ",", "\<\"\\\"TC97\\\"\"\>", 
     ",", "\<\"\\\"TC98\\\"\"\>", ",", "\<\"\\\"TC99\\\"\"\>", 
     ",", "\<\"\\\"TC100\\\"\"\>", ",", "\<\"\\\"TC101\\\"\"\>", 
     ",", "\<\"\\\"TC102\\\"\"\>", ",", "\<\"\\\"TC103\\\"\"\>", 
     ",", "\<\"\\\"TC104\\\"\"\>", ",", "\<\"\\\"TC105\\\"\"\>", 
     ",", "\<\"\\\"TC106\\\"\"\>", ",", "\<\"\\\"TC107\\\"\"\>", 
     ",", "\<\"\\\"TC108\\\"\"\>", ",", "\<\"\\\"TC109\\\"\"\>", 
     ",", "\<\"\\\"TC110\\\"\"\>", ",", "\<\"\\\"TC111\\\"\"\>", 
     ",", "\<\"\\\"TC112\\\"\"\>", ",", "\<\"\\\"TC113\\\"\"\>", 
     ",", "\<\"\\\"TC114\\\"\"\>", ",", "\<\"\\\"TC115\\\"\"\>", 
     ",", "\<\"\\\"TC116\\\"\"\>", ",", "\<\"\\\"TC117\\\"\"\>", 
     ",", "\<\"\\\"TC118\\\"\"\>", ",", "\<\"\\\"RU\\\"\"\>", 
     ",", "\<\"\\\"RU87\\\"\"\>", ",", "\<\"\\\"RU88\\\"\"\>", 
     ",", "\<\"\\\"RU89\\\"\"\>", ",", "\<\"\\\"RU90\\\"\"\>", 
     ",", "\<\"\\\"RU91\\\"\"\>", ",", "\<\"\\\"RU92\\\"\"\>", 
     ",", "\<\"\\\"RU93\\\"\"\>", ",", "\<\"\\\"RU94\\\"\"\>", 
     ",", "\<\"\\\"RU95\\\"\"\>", ",", "\<\"\\\"RU96\\\"\"\>", 
     ",", "\<\"\\\"RU97\\\"\"\>", ",", "\<\"\\\"RU98\\\"\"\>", 
     ",", "\<\"\\\"RU99\\\"\"\>", ",", "\<\"\\\"RU100\\\"\"\>", 
     ",", "\<\"\\\"RU101\\\"\"\>", ",", "\<\"\\\"RU102\\\"\"\>", 
     ",", "\<\"\\\"RU103\\\"\"\>", ",", "\<\"\\\"RU104\\\"\"\>", 
     ",", "\<\"\\\"RU105\\\"\"\>", ",", "\<\"\\\"RU106\\\"\"\>", 
     ",", "\<\"\\\"RU107\\\"\"\>", ",", "\<\"\\\"RU108\\\"\"\>", 
     ",", "\<\"\\\"RU109\\\"\"\>", ",", "\<\"\\\"RU110\\\"\"\>", 
     ",", "\<\"\\\"RU111\\\"\"\>", ",", "\<\"\\\"RU112\\\"\"\>", 
     ",", "\<\"\\\"RU113\\\"\"\>", ",", "\<\"\\\"RU114\\\"\"\>", 
     ",", "\<\"\\\"RU115\\\"\"\>", ",", "\<\"\\\"RU116\\\"\"\>", 
     ",", "\<\"\\\"RU117\\\"\"\>", ",", "\<\"\\\"RU118\\\"\"\>", 
     ",", "\<\"\\\"RU119\\\"\"\>", ",", "\<\"\\\"RU120\\\"\"\>", 
     ",", "\<\"\\\"RH\\\"\"\>", ",", "\<\"\\\"RH89\\\"\"\>", 
     ",", "\<\"\\\"RH90\\\"\"\>", ",", "\<\"\\\"RH91\\\"\"\>", 
     ",", "\<\"\\\"RH92\\\"\"\>", ",", "\<\"\\\"RH93\\\"\"\>", 
     ",", "\<\"\\\"RH94\\\"\"\>", ",", "\<\"\\\"RH95\\\"\"\>", 
     ",", "\<\"\\\"RH96\\\"\"\>", ",", "\<\"\\\"RH97\\\"\"\>", 
     ",", "\<\"\\\"RH98\\\"\"\>", ",", "\<\"\\\"RH99\\\"\"\>", 
     ",", "\<\"\\\"RH100\\\"\"\>", ",", "\<\"\\\"RH101\\\"\"\>", 
     ",", "\<\"\\\"RH102\\\"\"\>", ",", "\<\"\\\"RH103\\\"\"\>", 
     ",", "\<\"\\\"RH104\\\"\"\>", ",", "\<\"\\\"RH105\\\"\"\>", 
     ",", "\<\"\\\"RH106\\\"\"\>", ",", "\<\"\\\"RH107\\\"\"\>", 
     ",", "\<\"\\\"RH108\\\"\"\>", ",", "\<\"\\\"RH109\\\"\"\>", 
     ",", "\<\"\\\"RH110\\\"\"\>", ",", "\<\"\\\"RH111\\\"\"\>", 
     ",", "\<\"\\\"RH112\\\"\"\>", ",", "\<\"\\\"RH113\\\"\"\>", 
     ",", "\<\"\\\"RH114\\\"\"\>", ",", "\<\"\\\"RH115\\\"\"\>", 
     ",", "\<\"\\\"RH116\\\"\"\>", ",", "\<\"\\\"RH117\\\"\"\>", 
     ",", "\<\"\\\"RH118\\\"\"\>", ",", "\<\"\\\"RH119\\\"\"\>", 
     ",", "\<\"\\\"RH120\\\"\"\>", ",", "\<\"\\\"RH121\\\"\"\>", 
     ",", "\<\"\\\"RH122\\\"\"\>", ",", "\<\"\\\"PD\\\"\"\>", 
     ",", "\<\"\\\"PD91\\\"\"\>", ",", "\<\"\\\"PD92\\\"\"\>", 
     ",", "\<\"\\\"PD93\\\"\"\>", ",", "\<\"\\\"PD94\\\"\"\>", 
     ",", "\<\"\\\"PD95\\\"\"\>", ",", "\<\"\\\"PD96\\\"\"\>", 
     ",", "\<\"\\\"PD97\\\"\"\>", ",", "\<\"\\\"PD98\\\"\"\>", 
     ",", "\<\"\\\"PD99\\\"\"\>", ",", "\<\"\\\"PD100\\\"\"\>", 
     ",", "\<\"\\\"PD101\\\"\"\>", ",", "\<\"\\\"PD102\\\"\"\>", 
     ",", "\<\"\\\"PD103\\\"\"\>", ",", "\<\"\\\"PD104\\\"\"\>", 
     ",", "\<\"\\\"PD105\\\"\"\>", ",", "\<\"\\\"PD106\\\"\"\>", 
     ",", "\<\"\\\"PD107\\\"\"\>", ",", "\<\"\\\"PD108\\\"\"\>", 
     ",", "\<\"\\\"PD109\\\"\"\>", ",", "\<\"\\\"PD110\\\"\"\>", 
     ",", "\<\"\\\"PD111\\\"\"\>", ",", "\<\"\\\"PD112\\\"\"\>", 
     ",", "\<\"\\\"PD113\\\"\"\>", ",", "\<\"\\\"PD114\\\"\"\>", 
     ",", "\<\"\\\"PD115\\\"\"\>", ",", "\<\"\\\"PD116\\\"\"\>", 
     ",", "\<\"\\\"PD117\\\"\"\>", ",", "\<\"\\\"PD118\\\"\"\>", 
     ",", "\<\"\\\"PD119\\\"\"\>", ",", "\<\"\\\"PD120\\\"\"\>", 
     ",", "\<\"\\\"PD121\\\"\"\>", ",", "\<\"\\\"PD122\\\"\"\>", 
     ",", "\<\"\\\"PD123\\\"\"\>", ",", "\<\"\\\"PD124\\\"\"\>", 
     ",", "\<\"\\\"AG\\\"\"\>", ",", "\<\"\\\"AG93\\\"\"\>", 
     ",", "\<\"\\\"AG94\\\"\"\>", ",", "\<\"\\\"AG95\\\"\"\>", 
     ",", "\<\"\\\"AG96\\\"\"\>", ",", "\<\"\\\"AG97\\\"\"\>", 
     ",", "\<\"\\\"AG98\\\"\"\>", ",", "\<\"\\\"AG99\\\"\"\>", 
     ",", "\<\"\\\"AG100\\\"\"\>", ",", "\<\"\\\"AG101\\\"\"\>", 
     ",", "\<\"\\\"AG102\\\"\"\>", ",", "\<\"\\\"AG103\\\"\"\>", 
     ",", "\<\"\\\"AG104\\\"\"\>", ",", "\<\"\\\"AG105\\\"\"\>", 
     ",", "\<\"\\\"AG106\\\"\"\>", ",", "\<\"\\\"AG107\\\"\"\>", 
     ",", "\<\"\\\"AG108\\\"\"\>", ",", "\<\"\\\"AG109\\\"\"\>", 
     ",", "\<\"\\\"AG110\\\"\"\>", ",", "\<\"\\\"AG111\\\"\"\>", 
     ",", "\<\"\\\"AG112\\\"\"\>", ",", "\<\"\\\"AG113\\\"\"\>", 
     ",", "\<\"\\\"AG114\\\"\"\>", ",", "\<\"\\\"AG115\\\"\"\>", 
     ",", "\<\"\\\"AG116\\\"\"\>", ",", "\<\"\\\"AG117\\\"\"\>", 
     ",", "\<\"\\\"AG118\\\"\"\>", ",", "\<\"\\\"AG119\\\"\"\>", 
     ",", "\<\"\\\"AG120\\\"\"\>", ",", "\<\"\\\"AG121\\\"\"\>", 
     ",", "\<\"\\\"AG122\\\"\"\>", ",", "\<\"\\\"AG123\\\"\"\>", 
     ",", "\<\"\\\"AG124\\\"\"\>", ",", "\<\"\\\"AG125\\\"\"\>", 
     ",", "\<\"\\\"AG126\\\"\"\>", ",", "\<\"\\\"AG127\\\"\"\>", 
     ",", "\<\"\\\"AG128\\\"\"\>", ",", "\<\"\\\"AG129\\\"\"\>", 
     ",", "\<\"\\\"AG130\\\"\"\>", ",", "\<\"\\\"CD\\\"\"\>", 
     ",", "\<\"\\\"CD95\\\"\"\>", ",", "\<\"\\\"CD96\\\"\"\>", 
     ",", "\<\"\\\"CD97\\\"\"\>", ",", "\<\"\\\"CD98\\\"\"\>", 
     ",", "\<\"\\\"CD99\\\"\"\>", ",", "\<\"\\\"CD100\\\"\"\>", 
     ",", "\<\"\\\"CD101\\\"\"\>", ",", "\<\"\\\"CD102\\\"\"\>", 
     ",", "\<\"\\\"CD103\\\"\"\>", ",", "\<\"\\\"CD104\\\"\"\>", 
     ",", "\<\"\\\"CD105\\\"\"\>", ",", "\<\"\\\"CD106\\\"\"\>", 
     ",", "\<\"\\\"CD107\\\"\"\>", ",", "\<\"\\\"CD108\\\"\"\>", 
     ",", "\<\"\\\"CD109\\\"\"\>", ",", "\<\"\\\"CD110\\\"\"\>", 
     ",", "\<\"\\\"CD111\\\"\"\>", ",", "\<\"\\\"CD112\\\"\"\>", 
     ",", "\<\"\\\"CD113\\\"\"\>", ",", "\<\"\\\"CD114\\\"\"\>", 
     ",", "\<\"\\\"CD115\\\"\"\>", ",", "\<\"\\\"CD116\\\"\"\>", 
     ",", "\<\"\\\"CD117\\\"\"\>", ",", "\<\"\\\"CD118\\\"\"\>", 
     ",", "\<\"\\\"CD119\\\"\"\>", ",", "\<\"\\\"CD120\\\"\"\>", 
     ",", "\<\"\\\"CD121\\\"\"\>", ",", "\<\"\\\"CD122\\\"\"\>", 
     ",", "\<\"\\\"CD123\\\"\"\>", ",", "\<\"\\\"CD124\\\"\"\>", 
     ",", "\<\"\\\"CD125\\\"\"\>", ",", "\<\"\\\"CD126\\\"\"\>", 
     ",", "\<\"\\\"CD127\\\"\"\>", ",", "\<\"\\\"CD128\\\"\"\>", 
     ",", "\<\"\\\"CD129\\\"\"\>", ",", "\<\"\\\"CD130\\\"\"\>", 
     ",", "\<\"\\\"CD131\\\"\"\>", ",", "\<\"\\\"CD132\\\"\"\>", 
     ",", "\<\"\\\"IN\\\"\"\>", ",", "\<\"\\\"IN97\\\"\"\>", 
     ",", "\<\"\\\"IN98\\\"\"\>", ",", "\<\"\\\"IN99\\\"\"\>", 
     ",", "\<\"\\\"IN100\\\"\"\>", ",", "\<\"\\\"IN101\\\"\"\>", 
     ",", "\<\"\\\"IN102\\\"\"\>", ",", "\<\"\\\"IN103\\\"\"\>", 
     ",", "\<\"\\\"IN104\\\"\"\>", ",", "\<\"\\\"IN105\\\"\"\>", 
     ",", "\<\"\\\"IN106\\\"\"\>", ",", "\<\"\\\"IN107\\\"\"\>", 
     ",", "\<\"\\\"IN108\\\"\"\>", ",", "\<\"\\\"IN109\\\"\"\>", 
     ",", "\<\"\\\"IN110\\\"\"\>", ",", "\<\"\\\"IN111\\\"\"\>", 
     ",", "\<\"\\\"IN112\\\"\"\>", ",", "\<\"\\\"IN113\\\"\"\>", 
     ",", "\<\"\\\"IN114\\\"\"\>", ",", "\<\"\\\"IN115\\\"\"\>", 
     ",", "\<\"\\\"IN116\\\"\"\>", ",", "\<\"\\\"IN117\\\"\"\>", 
     ",", "\<\"\\\"IN118\\\"\"\>", ",", "\<\"\\\"IN119\\\"\"\>", 
     ",", "\<\"\\\"IN120\\\"\"\>", ",", "\<\"\\\"IN121\\\"\"\>", 
     ",", "\<\"\\\"IN122\\\"\"\>", ",", "\<\"\\\"IN123\\\"\"\>", 
     ",", "\<\"\\\"IN124\\\"\"\>", ",", "\<\"\\\"IN125\\\"\"\>", 
     ",", "\<\"\\\"IN126\\\"\"\>", ",", "\<\"\\\"IN127\\\"\"\>", 
     ",", "\<\"\\\"IN128\\\"\"\>", ",", "\<\"\\\"IN129\\\"\"\>", 
     ",", "\<\"\\\"IN130\\\"\"\>", ",", "\<\"\\\"IN131\\\"\"\>", 
     ",", "\<\"\\\"IN132\\\"\"\>", ",", "\<\"\\\"IN133\\\"\"\>", 
     ",", "\<\"\\\"IN134\\\"\"\>", ",", "\<\"\\\"IN135\\\"\"\>", 
     ",", "\<\"\\\"SN\\\"\"\>", ",", "\<\"\\\"SN99\\\"\"\>", 
     ",", "\<\"\\\"SN100\\\"\"\>", ",", "\<\"\\\"SN101\\\"\"\>", 
     ",", "\<\"\\\"SN102\\\"\"\>", ",", "\<\"\\\"SN103\\\"\"\>", 
     ",", "\<\"\\\"SN104\\\"\"\>", ",", "\<\"\\\"SN105\\\"\"\>", 
     ",", "\<\"\\\"SN106\\\"\"\>", ",", "\<\"\\\"SN107\\\"\"\>", 
     ",", "\<\"\\\"SN108\\\"\"\>", ",", "\<\"\\\"SN109\\\"\"\>", 
     ",", "\<\"\\\"SN110\\\"\"\>", ",", "\<\"\\\"SN111\\\"\"\>", 
     ",", "\<\"\\\"SN112\\\"\"\>", ",", "\<\"\\\"SN113\\\"\"\>", 
     ",", "\<\"\\\"SN114\\\"\"\>", ",", "\<\"\\\"SN115\\\"\"\>", 
     ",", "\<\"\\\"SN116\\\"\"\>", ",", "\<\"\\\"SN117\\\"\"\>", 
     ",", "\<\"\\\"SN118\\\"\"\>", ",", "\<\"\\\"SN119\\\"\"\>", 
     ",", "\<\"\\\"SN120\\\"\"\>", ",", "\<\"\\\"SN121\\\"\"\>", 
     ",", "\<\"\\\"SN122\\\"\"\>", ",", "\<\"\\\"SN123\\\"\"\>", 
     ",", "\<\"\\\"SN124\\\"\"\>", ",", "\<\"\\\"SN125\\\"\"\>", 
     ",", "\<\"\\\"SN126\\\"\"\>", ",", "\<\"\\\"SN127\\\"\"\>", 
     ",", "\<\"\\\"SN128\\\"\"\>", ",", "\<\"\\\"SN129\\\"\"\>", 
     ",", "\<\"\\\"SN130\\\"\"\>", ",", "\<\"\\\"SN131\\\"\"\>", 
     ",", "\<\"\\\"SN132\\\"\"\>", ",", "\<\"\\\"SN133\\\"\"\>", 
     ",", "\<\"\\\"SN134\\\"\"\>", ",", "\<\"\\\"SN135\\\"\"\>", 
     ",", "\<\"\\\"SN136\\\"\"\>", ",", "\<\"\\\"SN137\\\"\"\>", 
     ",", "\<\"\\\"SB\\\"\"\>", ",", "\<\"\\\"SB103\\\"\"\>", 
     ",", "\<\"\\\"SB104\\\"\"\>", ",", "\<\"\\\"SB105\\\"\"\>", 
     ",", "\<\"\\\"SB106\\\"\"\>", ",", "\<\"\\\"SB107\\\"\"\>", 
     ",", "\<\"\\\"SB108\\\"\"\>", ",", "\<\"\\\"SB109\\\"\"\>", 
     ",", "\<\"\\\"SB110\\\"\"\>", ",", "\<\"\\\"SB111\\\"\"\>", 
     ",", "\<\"\\\"SB112\\\"\"\>", ",", "\<\"\\\"SB113\\\"\"\>", 
     ",", "\<\"\\\"SB114\\\"\"\>", ",", "\<\"\\\"SB115\\\"\"\>", 
     ",", "\<\"\\\"SB116\\\"\"\>", ",", "\<\"\\\"SB117\\\"\"\>", 
     ",", "\<\"\\\"SB118\\\"\"\>", ",", "\<\"\\\"SB119\\\"\"\>", 
     ",", "\<\"\\\"SB120\\\"\"\>", ",", "\<\"\\\"SB121\\\"\"\>", 
     ",", "\<\"\\\"SB122\\\"\"\>", ",", "\<\"\\\"SB123\\\"\"\>", 
     ",", "\<\"\\\"SB124\\\"\"\>", ",", "\<\"\\\"SB125\\\"\"\>", 
     ",", "\<\"\\\"SB126\\\"\"\>", ",", "\<\"\\\"SB127\\\"\"\>", 
     ",", "\<\"\\\"SB128\\\"\"\>", ",", "\<\"\\\"SB129\\\"\"\>", 
     ",", "\<\"\\\"SB130\\\"\"\>", ",", "\<\"\\\"SB131\\\"\"\>", 
     ",", "\<\"\\\"SB132\\\"\"\>", ",", "\<\"\\\"SB133\\\"\"\>", 
     ",", "\<\"\\\"SB134\\\"\"\>", ",", "\<\"\\\"SB135\\\"\"\>", 
     ",", "\<\"\\\"SB136\\\"\"\>", ",", "\<\"\\\"SB137\\\"\"\>", 
     ",", "\<\"\\\"SB138\\\"\"\>", ",", "\<\"\\\"SB139\\\"\"\>", 
     ",", "\<\"\\\"TE\\\"\"\>", ",", "\<\"\\\"TE105\\\"\"\>", 
     ",", "\<\"\\\"TE106\\\"\"\>", ",", "\<\"\\\"TE107\\\"\"\>", 
     ",", "\<\"\\\"TE108\\\"\"\>", ",", "\<\"\\\"TE109\\\"\"\>", 
     ",", "\<\"\\\"TE110\\\"\"\>", ",", "\<\"\\\"TE111\\\"\"\>", 
     ",", "\<\"\\\"TE112\\\"\"\>", ",", "\<\"\\\"TE113\\\"\"\>", 
     ",", "\<\"\\\"TE114\\\"\"\>", ",", "\<\"\\\"TE115\\\"\"\>", 
     ",", "\<\"\\\"TE116\\\"\"\>", ",", "\<\"\\\"TE117\\\"\"\>", 
     ",", "\<\"\\\"TE118\\\"\"\>", ",", "\<\"\\\"TE119\\\"\"\>", 
     ",", "\<\"\\\"TE120\\\"\"\>", ",", "\<\"\\\"TE121\\\"\"\>", 
     ",", "\<\"\\\"TE122\\\"\"\>", ",", "\<\"\\\"TE123\\\"\"\>", 
     ",", "\<\"\\\"TE124\\\"\"\>", ",", "\<\"\\\"TE125\\\"\"\>", 
     ",", "\<\"\\\"TE126\\\"\"\>", ",", "\<\"\\\"TE127\\\"\"\>", 
     ",", "\<\"\\\"TE128\\\"\"\>", ",", "\<\"\\\"TE129\\\"\"\>", 
     ",", "\<\"\\\"TE130\\\"\"\>", ",", "\<\"\\\"TE131\\\"\"\>", 
     ",", "\<\"\\\"TE132\\\"\"\>", ",", "\<\"\\\"TE133\\\"\"\>", 
     ",", "\<\"\\\"TE134\\\"\"\>", ",", "\<\"\\\"TE135\\\"\"\>", 
     ",", "\<\"\\\"TE136\\\"\"\>", ",", "\<\"\\\"TE137\\\"\"\>", 
     ",", "\<\"\\\"TE138\\\"\"\>", ",", "\<\"\\\"TE139\\\"\"\>", 
     ",", "\<\"\\\"TE140\\\"\"\>", ",", "\<\"\\\"TE141\\\"\"\>", 
     ",", "\<\"\\\"TE142\\\"\"\>", ",", "\<\"\\\"I\\\"\"\>", 
     ",", "\<\"\\\"I108\\\"\"\>", ",", "\<\"\\\"I109\\\"\"\>", 
     ",", "\<\"\\\"I110\\\"\"\>", ",", "\<\"\\\"I111\\\"\"\>", 
     ",", "\<\"\\\"I112\\\"\"\>", ",", "\<\"\\\"I113\\\"\"\>", 
     ",", "\<\"\\\"I114\\\"\"\>", ",", "\<\"\\\"I115\\\"\"\>", 
     ",", "\<\"\\\"I116\\\"\"\>", ",", "\<\"\\\"I117\\\"\"\>", 
     ",", "\<\"\\\"I118\\\"\"\>", ",", "\<\"\\\"I119\\\"\"\>", 
     ",", "\<\"\\\"I120\\\"\"\>", ",", "\<\"\\\"I121\\\"\"\>", 
     ",", "\<\"\\\"I122\\\"\"\>", ",", "\<\"\\\"I123\\\"\"\>", 
     ",", "\<\"\\\"I124\\\"\"\>", ",", "\<\"\\\"I125\\\"\"\>", 
     ",", "\<\"\\\"I126\\\"\"\>", ",", "\<\"\\\"I127\\\"\"\>", 
     ",", "\<\"\\\"I128\\\"\"\>", ",", "\<\"\\\"I129\\\"\"\>", 
     ",", "\<\"\\\"I130\\\"\"\>", ",", "\<\"\\\"I131\\\"\"\>", 
     ",", "\<\"\\\"I132\\\"\"\>", ",", "\<\"\\\"I133\\\"\"\>", 
     ",", "\<\"\\\"I134\\\"\"\>", ",", "\<\"\\\"I135\\\"\"\>", 
     ",", "\<\"\\\"I136\\\"\"\>", ",", "\<\"\\\"I137\\\"\"\>", 
     ",", "\<\"\\\"I138\\\"\"\>", ",", "\<\"\\\"I139\\\"\"\>", 
     ",", "\<\"\\\"I140\\\"\"\>", ",", "\<\"\\\"I141\\\"\"\>", 
     ",", "\<\"\\\"I142\\\"\"\>", ",", "\<\"\\\"I143\\\"\"\>", 
     ",", "\<\"\\\"I144\\\"\"\>", ",", "\<\"\\\"XE\\\"\"\>", 
     ",", "\<\"\\\"XE110\\\"\"\>", ",", "\<\"\\\"XE111\\\"\"\>", 
     ",", "\<\"\\\"XE112\\\"\"\>", ",", "\<\"\\\"XE113\\\"\"\>", 
     ",", "\<\"\\\"XE114\\\"\"\>", ",", "\<\"\\\"XE115\\\"\"\>", 
     ",", "\<\"\\\"XE116\\\"\"\>", ",", "\<\"\\\"XE117\\\"\"\>", 
     ",", "\<\"\\\"XE118\\\"\"\>", ",", "\<\"\\\"XE119\\\"\"\>", 
     ",", "\<\"\\\"XE120\\\"\"\>", ",", "\<\"\\\"XE121\\\"\"\>", 
     ",", "\<\"\\\"XE122\\\"\"\>", ",", "\<\"\\\"XE123\\\"\"\>", 
     ",", "\<\"\\\"XE124\\\"\"\>", ",", "\<\"\\\"XE125\\\"\"\>", 
     ",", "\<\"\\\"XE126\\\"\"\>", ",", "\<\"\\\"XE127\\\"\"\>", 
     ",", "\<\"\\\"XE128\\\"\"\>", ",", "\<\"\\\"XE129\\\"\"\>", 
     ",", "\<\"\\\"XE130\\\"\"\>", ",", "\<\"\\\"XE131\\\"\"\>", 
     ",", "\<\"\\\"XE132\\\"\"\>", ",", "\<\"\\\"XE133\\\"\"\>", 
     ",", "\<\"\\\"XE134\\\"\"\>", ",", "\<\"\\\"XE135\\\"\"\>", 
     ",", "\<\"\\\"XE136\\\"\"\>", ",", "\<\"\\\"XE137\\\"\"\>", 
     ",", "\<\"\\\"XE138\\\"\"\>", ",", "\<\"\\\"XE139\\\"\"\>", 
     ",", "\<\"\\\"XE140\\\"\"\>", ",", "\<\"\\\"XE141\\\"\"\>", 
     ",", "\<\"\\\"XE142\\\"\"\>", ",", "\<\"\\\"XE143\\\"\"\>", 
     ",", "\<\"\\\"XE144\\\"\"\>", ",", "\<\"\\\"XE145\\\"\"\>", 
     ",", "\<\"\\\"XE146\\\"\"\>", ",", "\<\"\\\"XE147\\\"\"\>", 
     ",", "\<\"\\\"CS\\\"\"\>", ",", "\<\"\\\"CS112\\\"\"\>", 
     ",", "\<\"\\\"CS113\\\"\"\>", ",", "\<\"\\\"CS114\\\"\"\>", 
     ",", "\<\"\\\"CS115\\\"\"\>", ",", "\<\"\\\"CS116\\\"\"\>", 
     ",", "\<\"\\\"CS117\\\"\"\>", ",", "\<\"\\\"CS118\\\"\"\>", 
     ",", "\<\"\\\"CS119\\\"\"\>", ",", "\<\"\\\"CS120\\\"\"\>", 
     ",", "\<\"\\\"CS121\\\"\"\>", ",", "\<\"\\\"CS122\\\"\"\>", 
     ",", "\<\"\\\"CS123\\\"\"\>", ",", "\<\"\\\"CS124\\\"\"\>", 
     ",", "\<\"\\\"CS125\\\"\"\>", ",", "\<\"\\\"CS126\\\"\"\>", 
     ",", "\<\"\\\"CS127\\\"\"\>", ",", "\<\"\\\"CS128\\\"\"\>", 
     ",", "\<\"\\\"CS129\\\"\"\>", ",", "\<\"\\\"CS130\\\"\"\>", 
     ",", "\<\"\\\"CS131\\\"\"\>", ",", "\<\"\\\"CS132\\\"\"\>", 
     ",", "\<\"\\\"CS133\\\"\"\>", ",", "\<\"\\\"CS134\\\"\"\>", 
     ",", "\<\"\\\"CS135\\\"\"\>", ",", "\<\"\\\"CS136\\\"\"\>", 
     ",", "\<\"\\\"CS137\\\"\"\>", ",", "\<\"\\\"CS138\\\"\"\>", 
     ",", "\<\"\\\"CS139\\\"\"\>", ",", "\<\"\\\"CS140\\\"\"\>", 
     ",", "\<\"\\\"CS141\\\"\"\>", ",", "\<\"\\\"CS142\\\"\"\>", 
     ",", "\<\"\\\"CS143\\\"\"\>", ",", "\<\"\\\"CS144\\\"\"\>", 
     ",", "\<\"\\\"CS145\\\"\"\>", ",", "\<\"\\\"CS146\\\"\"\>", 
     ",", "\<\"\\\"CS147\\\"\"\>", ",", "\<\"\\\"CS148\\\"\"\>", 
     ",", "\<\"\\\"CS149\\\"\"\>", ",", "\<\"\\\"CS150\\\"\"\>", 
     ",", "\<\"\\\"CS151\\\"\"\>", ",", "\<\"\\\"BA\\\"\"\>", 
     ",", "\<\"\\\"BA114\\\"\"\>", ",", "\<\"\\\"BA115\\\"\"\>", 
     ",", "\<\"\\\"BA116\\\"\"\>", ",", "\<\"\\\"BA117\\\"\"\>", 
     ",", "\<\"\\\"BA118\\\"\"\>", ",", "\<\"\\\"BA119\\\"\"\>", 
     ",", "\<\"\\\"BA120\\\"\"\>", ",", "\<\"\\\"BA121\\\"\"\>", 
     ",", "\<\"\\\"BA122\\\"\"\>", ",", "\<\"\\\"BA123\\\"\"\>", 
     ",", "\<\"\\\"BA124\\\"\"\>", ",", "\<\"\\\"BA125\\\"\"\>", 
     ",", "\<\"\\\"BA126\\\"\"\>", ",", "\<\"\\\"BA127\\\"\"\>", 
     ",", "\<\"\\\"BA128\\\"\"\>", ",", "\<\"\\\"BA129\\\"\"\>", 
     ",", "\<\"\\\"BA130\\\"\"\>", ",", "\<\"\\\"BA131\\\"\"\>", 
     ",", "\<\"\\\"BA132\\\"\"\>", ",", "\<\"\\\"BA133\\\"\"\>", 
     ",", "\<\"\\\"BA134\\\"\"\>", ",", "\<\"\\\"BA135\\\"\"\>", 
     ",", "\<\"\\\"BA136\\\"\"\>", ",", "\<\"\\\"BA137\\\"\"\>", 
     ",", "\<\"\\\"BA138\\\"\"\>", ",", "\<\"\\\"BA139\\\"\"\>", 
     ",", "\<\"\\\"BA140\\\"\"\>", ",", "\<\"\\\"BA141\\\"\"\>", 
     ",", "\<\"\\\"BA142\\\"\"\>", ",", "\<\"\\\"BA143\\\"\"\>", 
     ",", "\<\"\\\"BA144\\\"\"\>", ",", "\<\"\\\"BA145\\\"\"\>", 
     ",", "\<\"\\\"BA146\\\"\"\>", ",", "\<\"\\\"BA147\\\"\"\>", 
     ",", "\<\"\\\"BA148\\\"\"\>", ",", "\<\"\\\"BA149\\\"\"\>", 
     ",", "\<\"\\\"BA150\\\"\"\>", ",", "\<\"\\\"BA151\\\"\"\>", 
     ",", "\<\"\\\"BA152\\\"\"\>", ",", "\<\"\\\"BA153\\\"\"\>", 
     ",", "\<\"\\\"LA\\\"\"\>", ",", "\<\"\\\"LA117\\\"\"\>", 
     ",", "\<\"\\\"LA118\\\"\"\>", ",", "\<\"\\\"LA119\\\"\"\>", 
     ",", "\<\"\\\"LA120\\\"\"\>", ",", "\<\"\\\"LA121\\\"\"\>", 
     ",", "\<\"\\\"LA122\\\"\"\>", ",", "\<\"\\\"LA123\\\"\"\>", 
     ",", "\<\"\\\"LA124\\\"\"\>", ",", "\<\"\\\"LA125\\\"\"\>", 
     ",", "\<\"\\\"LA126\\\"\"\>", ",", "\<\"\\\"LA127\\\"\"\>", 
     ",", "\<\"\\\"LA128\\\"\"\>", ",", "\<\"\\\"LA129\\\"\"\>", 
     ",", "\<\"\\\"LA130\\\"\"\>", ",", "\<\"\\\"LA131\\\"\"\>", 
     ",", "\<\"\\\"LA132\\\"\"\>", ",", "\<\"\\\"LA133\\\"\"\>", 
     ",", "\<\"\\\"LA134\\\"\"\>", ",", "\<\"\\\"LA135\\\"\"\>", 
     ",", "\<\"\\\"LA136\\\"\"\>", ",", "\<\"\\\"LA137\\\"\"\>", 
     ",", "\<\"\\\"LA138\\\"\"\>", ",", "\<\"\\\"LA139\\\"\"\>", 
     ",", "\<\"\\\"LA140\\\"\"\>", ",", "\<\"\\\"LA141\\\"\"\>", 
     ",", "\<\"\\\"LA142\\\"\"\>", ",", "\<\"\\\"LA143\\\"\"\>", 
     ",", "\<\"\\\"LA144\\\"\"\>", ",", "\<\"\\\"LA145\\\"\"\>", 
     ",", "\<\"\\\"LA146\\\"\"\>", ",", "\<\"\\\"LA147\\\"\"\>", 
     ",", "\<\"\\\"LA148\\\"\"\>", ",", "\<\"\\\"LA149\\\"\"\>", 
     ",", "\<\"\\\"LA150\\\"\"\>", ",", "\<\"\\\"LA151\\\"\"\>", 
     ",", "\<\"\\\"LA152\\\"\"\>", ",", "\<\"\\\"LA153\\\"\"\>", 
     ",", "\<\"\\\"LA154\\\"\"\>", ",", "\<\"\\\"LA155\\\"\"\>", 
     ",", "\<\"\\\"CE\\\"\"\>", ",", "\<\"\\\"CE119\\\"\"\>", 
     ",", "\<\"\\\"CE120\\\"\"\>", ",", "\<\"\\\"CE121\\\"\"\>", 
     ",", "\<\"\\\"CE122\\\"\"\>", ",", "\<\"\\\"CE123\\\"\"\>", 
     ",", "\<\"\\\"CE124\\\"\"\>", ",", "\<\"\\\"CE125\\\"\"\>", 
     ",", "\<\"\\\"CE126\\\"\"\>", ",", "\<\"\\\"CE127\\\"\"\>", 
     ",", "\<\"\\\"CE128\\\"\"\>", ",", "\<\"\\\"CE129\\\"\"\>", 
     ",", "\<\"\\\"CE130\\\"\"\>", ",", "\<\"\\\"CE131\\\"\"\>", 
     ",", "\<\"\\\"CE132\\\"\"\>", ",", "\<\"\\\"CE133\\\"\"\>", 
     ",", "\<\"\\\"CE134\\\"\"\>", ",", "\<\"\\\"CE135\\\"\"\>", 
     ",", "\<\"\\\"CE136\\\"\"\>", ",", "\<\"\\\"CE137\\\"\"\>", 
     ",", "\<\"\\\"CE138\\\"\"\>", ",", "\<\"\\\"CE139\\\"\"\>", 
     ",", "\<\"\\\"CE140\\\"\"\>", ",", "\<\"\\\"CE141\\\"\"\>", 
     ",", "\<\"\\\"CE142\\\"\"\>", ",", "\<\"\\\"CE143\\\"\"\>", 
     ",", "\<\"\\\"CE144\\\"\"\>", ",", "\<\"\\\"CE145\\\"\"\>", 
     ",", "\<\"\\\"CE146\\\"\"\>", ",", "\<\"\\\"CE147\\\"\"\>", 
     ",", "\<\"\\\"CE148\\\"\"\>", ",", "\<\"\\\"CE149\\\"\"\>", 
     ",", "\<\"\\\"CE150\\\"\"\>", ",", "\<\"\\\"CE151\\\"\"\>", 
     ",", "\<\"\\\"CE152\\\"\"\>", ",", "\<\"\\\"CE153\\\"\"\>", 
     ",", "\<\"\\\"CE154\\\"\"\>", ",", "\<\"\\\"CE155\\\"\"\>", 
     ",", "\<\"\\\"CE156\\\"\"\>", ",", "\<\"\\\"CE157\\\"\"\>", 
     ",", "\<\"\\\"PR\\\"\"\>", ",", "\<\"\\\"PR121\\\"\"\>", 
     ",", "\<\"\\\"PR122\\\"\"\>", ",", "\<\"\\\"PR123\\\"\"\>", 
     ",", "\<\"\\\"PR124\\\"\"\>", ",", "\<\"\\\"PR125\\\"\"\>", 
     ",", "\<\"\\\"PR126\\\"\"\>", ",", "\<\"\\\"PR127\\\"\"\>", 
     ",", "\<\"\\\"PR128\\\"\"\>", ",", "\<\"\\\"PR129\\\"\"\>", 
     ",", "\<\"\\\"PR130\\\"\"\>", ",", "\<\"\\\"PR131\\\"\"\>", 
     ",", "\<\"\\\"PR132\\\"\"\>", ",", "\<\"\\\"PR133\\\"\"\>", 
     ",", "\<\"\\\"PR134\\\"\"\>", ",", "\<\"\\\"PR135\\\"\"\>", 
     ",", "\<\"\\\"PR136\\\"\"\>", ",", "\<\"\\\"PR137\\\"\"\>", 
     ",", "\<\"\\\"PR138\\\"\"\>", ",", "\<\"\\\"PR139\\\"\"\>", 
     ",", "\<\"\\\"PR140\\\"\"\>", ",", "\<\"\\\"PR141\\\"\"\>", 
     ",", "\<\"\\\"PR142\\\"\"\>", ",", "\<\"\\\"PR143\\\"\"\>", 
     ",", "\<\"\\\"PR144\\\"\"\>", ",", "\<\"\\\"PR145\\\"\"\>", 
     ",", "\<\"\\\"PR146\\\"\"\>", ",", "\<\"\\\"PR147\\\"\"\>", 
     ",", "\<\"\\\"PR148\\\"\"\>", ",", "\<\"\\\"PR149\\\"\"\>", 
     ",", "\<\"\\\"PR150\\\"\"\>", ",", "\<\"\\\"PR151\\\"\"\>", 
     ",", "\<\"\\\"PR152\\\"\"\>", ",", "\<\"\\\"PR153\\\"\"\>", 
     ",", "\<\"\\\"PR154\\\"\"\>", ",", "\<\"\\\"PR155\\\"\"\>", 
     ",", "\<\"\\\"PR156\\\"\"\>", ",", "\<\"\\\"PR157\\\"\"\>", 
     ",", "\<\"\\\"PR158\\\"\"\>", ",", "\<\"\\\"PR159\\\"\"\>", 
     ",", "\<\"\\\"ND\\\"\"\>", ",", "\<\"\\\"ND124\\\"\"\>", 
     ",", "\<\"\\\"ND125\\\"\"\>", ",", "\<\"\\\"ND126\\\"\"\>", 
     ",", "\<\"\\\"ND127\\\"\"\>", ",", "\<\"\\\"ND128\\\"\"\>", 
     ",", "\<\"\\\"ND129\\\"\"\>", ",", "\<\"\\\"ND130\\\"\"\>", 
     ",", "\<\"\\\"ND131\\\"\"\>", ",", "\<\"\\\"ND132\\\"\"\>", 
     ",", "\<\"\\\"ND133\\\"\"\>", ",", "\<\"\\\"ND134\\\"\"\>", 
     ",", "\<\"\\\"ND135\\\"\"\>", ",", "\<\"\\\"ND136\\\"\"\>", 
     ",", "\<\"\\\"ND137\\\"\"\>", ",", "\<\"\\\"ND138\\\"\"\>", 
     ",", "\<\"\\\"ND139\\\"\"\>", ",", "\<\"\\\"ND140\\\"\"\>", 
     ",", "\<\"\\\"ND141\\\"\"\>", ",", "\<\"\\\"ND142\\\"\"\>", 
     ",", "\<\"\\\"ND143\\\"\"\>", ",", "\<\"\\\"ND144\\\"\"\>", 
     ",", "\<\"\\\"ND145\\\"\"\>", ",", "\<\"\\\"ND146\\\"\"\>", 
     ",", "\<\"\\\"ND147\\\"\"\>", ",", "\<\"\\\"ND148\\\"\"\>", 
     ",", "\<\"\\\"ND149\\\"\"\>", ",", "\<\"\\\"ND150\\\"\"\>", 
     ",", "\<\"\\\"ND151\\\"\"\>", ",", "\<\"\\\"ND152\\\"\"\>", 
     ",", "\<\"\\\"ND153\\\"\"\>", ",", "\<\"\\\"ND154\\\"\"\>", 
     ",", "\<\"\\\"ND155\\\"\"\>", ",", "\<\"\\\"ND156\\\"\"\>", 
     ",", "\<\"\\\"ND157\\\"\"\>", ",", "\<\"\\\"ND158\\\"\"\>", 
     ",", "\<\"\\\"ND159\\\"\"\>", ",", "\<\"\\\"ND160\\\"\"\>", 
     ",", "\<\"\\\"ND161\\\"\"\>", ",", "\<\"\\\"PM\\\"\"\>", 
     ",", "\<\"\\\"PM126\\\"\"\>", ",", "\<\"\\\"PM127\\\"\"\>", 
     ",", "\<\"\\\"PM128\\\"\"\>", ",", "\<\"\\\"PM129\\\"\"\>", 
     ",", "\<\"\\\"PM130\\\"\"\>", ",", "\<\"\\\"PM131\\\"\"\>", 
     ",", "\<\"\\\"PM132\\\"\"\>", ",", "\<\"\\\"PM133\\\"\"\>", 
     ",", "\<\"\\\"PM134\\\"\"\>", ",", "\<\"\\\"PM135\\\"\"\>", 
     ",", "\<\"\\\"PM136\\\"\"\>", ",", "\<\"\\\"PM137\\\"\"\>", 
     ",", "\<\"\\\"PM138\\\"\"\>", ",", "\<\"\\\"PM139\\\"\"\>", 
     ",", "\<\"\\\"PM140\\\"\"\>", ",", "\<\"\\\"PM141\\\"\"\>", 
     ",", "\<\"\\\"PM142\\\"\"\>", ",", "\<\"\\\"PM143\\\"\"\>", 
     ",", "\<\"\\\"PM144\\\"\"\>", ",", "\<\"\\\"PM145\\\"\"\>", 
     ",", "\<\"\\\"PM146\\\"\"\>", ",", "\<\"\\\"PM147\\\"\"\>", 
     ",", "\<\"\\\"PM148\\\"\"\>", ",", "\<\"\\\"PM149\\\"\"\>", 
     ",", "\<\"\\\"PM150\\\"\"\>", ",", "\<\"\\\"PM151\\\"\"\>", 
     ",", "\<\"\\\"PM152\\\"\"\>", ",", "\<\"\\\"PM153\\\"\"\>", 
     ",", "\<\"\\\"PM154\\\"\"\>", ",", "\<\"\\\"PM155\\\"\"\>", 
     ",", "\<\"\\\"PM156\\\"\"\>", ",", "\<\"\\\"PM157\\\"\"\>", 
     ",", "\<\"\\\"PM158\\\"\"\>", ",", "\<\"\\\"PM159\\\"\"\>", 
     ",", "\<\"\\\"PM160\\\"\"\>", ",", "\<\"\\\"PM161\\\"\"\>", 
     ",", "\<\"\\\"PM162\\\"\"\>", ",", "\<\"\\\"PM163\\\"\"\>", 
     ",", "\<\"\\\"SM\\\"\"\>", ",", "\<\"\\\"SM128\\\"\"\>", 
     ",", "\<\"\\\"SM129\\\"\"\>", ",", "\<\"\\\"SM130\\\"\"\>", 
     ",", "\<\"\\\"SM131\\\"\"\>", ",", "\<\"\\\"SM132\\\"\"\>", 
     ",", "\<\"\\\"SM133\\\"\"\>", ",", "\<\"\\\"SM134\\\"\"\>", 
     ",", "\<\"\\\"SM135\\\"\"\>", ",", "\<\"\\\"SM136\\\"\"\>", 
     ",", "\<\"\\\"SM137\\\"\"\>", ",", "\<\"\\\"SM138\\\"\"\>", 
     ",", "\<\"\\\"SM139\\\"\"\>", ",", "\<\"\\\"SM140\\\"\"\>", 
     ",", "\<\"\\\"SM141\\\"\"\>", ",", "\<\"\\\"SM142\\\"\"\>", 
     ",", "\<\"\\\"SM143\\\"\"\>", ",", "\<\"\\\"SM144\\\"\"\>", 
     ",", "\<\"\\\"SM145\\\"\"\>", ",", "\<\"\\\"SM146\\\"\"\>", 
     ",", "\<\"\\\"SM147\\\"\"\>", ",", "\<\"\\\"SM148\\\"\"\>", 
     ",", "\<\"\\\"SM149\\\"\"\>", ",", "\<\"\\\"SM150\\\"\"\>", 
     ",", "\<\"\\\"SM151\\\"\"\>", ",", "\<\"\\\"SM152\\\"\"\>", 
     ",", "\<\"\\\"SM153\\\"\"\>", ",", "\<\"\\\"SM154\\\"\"\>", 
     ",", "\<\"\\\"SM155\\\"\"\>", ",", "\<\"\\\"SM156\\\"\"\>", 
     ",", "\<\"\\\"SM157\\\"\"\>", ",", "\<\"\\\"SM158\\\"\"\>", 
     ",", "\<\"\\\"SM159\\\"\"\>", ",", "\<\"\\\"SM160\\\"\"\>", 
     ",", "\<\"\\\"SM161\\\"\"\>", ",", "\<\"\\\"SM162\\\"\"\>", 
     ",", "\<\"\\\"SM163\\\"\"\>", ",", "\<\"\\\"SM164\\\"\"\>", 
     ",", "\<\"\\\"SM165\\\"\"\>", ",", "\<\"\\\"EU\\\"\"\>", 
     ",", "\<\"\\\"EU130\\\"\"\>", ",", "\<\"\\\"EU131\\\"\"\>", 
     ",", "\<\"\\\"EU132\\\"\"\>", ",", "\<\"\\\"EU133\\\"\"\>", 
     ",", "\<\"\\\"EU134\\\"\"\>", ",", "\<\"\\\"EU135\\\"\"\>", 
     ",", "\<\"\\\"EU136\\\"\"\>", ",", "\<\"\\\"EU137\\\"\"\>", 
     ",", "\<\"\\\"EU138\\\"\"\>", ",", "\<\"\\\"EU139\\\"\"\>", 
     ",", "\<\"\\\"EU140\\\"\"\>", ",", "\<\"\\\"EU141\\\"\"\>", 
     ",", "\<\"\\\"EU142\\\"\"\>", ",", "\<\"\\\"EU143\\\"\"\>", 
     ",", "\<\"\\\"EU144\\\"\"\>", ",", "\<\"\\\"EU145\\\"\"\>", 
     ",", "\<\"\\\"EU146\\\"\"\>", ",", "\<\"\\\"EU147\\\"\"\>", 
     ",", "\<\"\\\"EU148\\\"\"\>", ",", "\<\"\\\"EU149\\\"\"\>", 
     ",", "\<\"\\\"EU150\\\"\"\>", ",", "\<\"\\\"EU151\\\"\"\>", 
     ",", "\<\"\\\"EU152\\\"\"\>", ",", "\<\"\\\"EU153\\\"\"\>", 
     ",", "\<\"\\\"EU154\\\"\"\>", ",", "\<\"\\\"EU155\\\"\"\>", 
     ",", "\<\"\\\"EU156\\\"\"\>", ",", "\<\"\\\"EU157\\\"\"\>", 
     ",", "\<\"\\\"EU158\\\"\"\>", ",", "\<\"\\\"EU159\\\"\"\>", 
     ",", "\<\"\\\"EU160\\\"\"\>", ",", "\<\"\\\"EU161\\\"\"\>", 
     ",", "\<\"\\\"EU162\\\"\"\>", ",", "\<\"\\\"EU163\\\"\"\>", 
     ",", "\<\"\\\"EU164\\\"\"\>", ",", "\<\"\\\"EU165\\\"\"\>", 
     ",", "\<\"\\\"EU166\\\"\"\>", ",", "\<\"\\\"EU167\\\"\"\>", 
     ",", "\<\"\\\"GD\\\"\"\>", ",", "\<\"\\\"GD134\\\"\"\>", 
     ",", "\<\"\\\"GD135\\\"\"\>", ",", "\<\"\\\"GD136\\\"\"\>", 
     ",", "\<\"\\\"GD137\\\"\"\>", ",", "\<\"\\\"GD138\\\"\"\>", 
     ",", "\<\"\\\"GD139\\\"\"\>", ",", "\<\"\\\"GD140\\\"\"\>", 
     ",", "\<\"\\\"GD141\\\"\"\>", ",", "\<\"\\\"GD142\\\"\"\>", 
     ",", "\<\"\\\"GD143\\\"\"\>", ",", "\<\"\\\"GD144\\\"\"\>", 
     ",", "\<\"\\\"GD145\\\"\"\>", ",", "\<\"\\\"GD146\\\"\"\>", 
     ",", "\<\"\\\"GD147\\\"\"\>", ",", "\<\"\\\"GD148\\\"\"\>", 
     ",", "\<\"\\\"GD149\\\"\"\>", ",", "\<\"\\\"GD150\\\"\"\>", 
     ",", "\<\"\\\"GD151\\\"\"\>", ",", "\<\"\\\"GD152\\\"\"\>", 
     ",", "\<\"\\\"GD153\\\"\"\>", ",", "\<\"\\\"GD154\\\"\"\>", 
     ",", "\<\"\\\"GD155\\\"\"\>", ",", "\<\"\\\"GD156\\\"\"\>", 
     ",", "\<\"\\\"GD157\\\"\"\>", ",", "\<\"\\\"GD158\\\"\"\>", 
     ",", "\<\"\\\"GD159\\\"\"\>", ",", "\<\"\\\"GD160\\\"\"\>", 
     ",", "\<\"\\\"GD161\\\"\"\>", ",", "\<\"\\\"GD162\\\"\"\>", 
     ",", "\<\"\\\"GD163\\\"\"\>", ",", "\<\"\\\"GD164\\\"\"\>", 
     ",", "\<\"\\\"GD165\\\"\"\>", ",", "\<\"\\\"GD166\\\"\"\>", 
     ",", "\<\"\\\"GD167\\\"\"\>", ",", "\<\"\\\"GD168\\\"\"\>", 
     ",", "\<\"\\\"GD169\\\"\"\>", ",", "\<\"\\\"TB\\\"\"\>", 
     ",", "\<\"\\\"TB136\\\"\"\>", ",", "\<\"\\\"TB137\\\"\"\>", 
     ",", "\<\"\\\"TB138\\\"\"\>", ",", "\<\"\\\"TB139\\\"\"\>", 
     ",", "\<\"\\\"TB140\\\"\"\>", ",", "\<\"\\\"TB141\\\"\"\>", 
     ",", "\<\"\\\"TB142\\\"\"\>", ",", "\<\"\\\"TB143\\\"\"\>", 
     ",", "\<\"\\\"TB144\\\"\"\>", ",", "\<\"\\\"TB145\\\"\"\>", 
     ",", "\<\"\\\"TB146\\\"\"\>", ",", "\<\"\\\"TB147\\\"\"\>", 
     ",", "\<\"\\\"TB148\\\"\"\>", ",", "\<\"\\\"TB149\\\"\"\>", 
     ",", "\<\"\\\"TB150\\\"\"\>", ",", "\<\"\\\"TB151\\\"\"\>", 
     ",", "\<\"\\\"TB152\\\"\"\>", ",", "\<\"\\\"TB153\\\"\"\>", 
     ",", "\<\"\\\"TB154\\\"\"\>", ",", "\<\"\\\"TB155\\\"\"\>", 
     ",", "\<\"\\\"TB156\\\"\"\>", ",", "\<\"\\\"TB157\\\"\"\>", 
     ",", "\<\"\\\"TB158\\\"\"\>", ",", "\<\"\\\"TB159\\\"\"\>", 
     ",", "\<\"\\\"TB160\\\"\"\>", ",", "\<\"\\\"TB161\\\"\"\>", 
     ",", "\<\"\\\"TB162\\\"\"\>", ",", "\<\"\\\"TB163\\\"\"\>", 
     ",", "\<\"\\\"TB164\\\"\"\>", ",", "\<\"\\\"TB165\\\"\"\>", 
     ",", "\<\"\\\"TB166\\\"\"\>", ",", "\<\"\\\"TB167\\\"\"\>", 
     ",", "\<\"\\\"TB168\\\"\"\>", ",", "\<\"\\\"TB169\\\"\"\>", 
     ",", "\<\"\\\"TB170\\\"\"\>", ",", "\<\"\\\"TB171\\\"\"\>", 
     ",", "\<\"\\\"DY\\\"\"\>", ",", "\<\"\\\"DY138\\\"\"\>", 
     ",", "\<\"\\\"DY139\\\"\"\>", ",", "\<\"\\\"DY140\\\"\"\>", 
     ",", "\<\"\\\"DY141\\\"\"\>", ",", "\<\"\\\"DY142\\\"\"\>", 
     ",", "\<\"\\\"DY143\\\"\"\>", ",", "\<\"\\\"DY144\\\"\"\>", 
     ",", "\<\"\\\"DY145\\\"\"\>", ",", "\<\"\\\"DY146\\\"\"\>", 
     ",", "\<\"\\\"DY147\\\"\"\>", ",", "\<\"\\\"DY148\\\"\"\>", 
     ",", "\<\"\\\"DY149\\\"\"\>", ",", "\<\"\\\"DY150\\\"\"\>", 
     ",", "\<\"\\\"DY151\\\"\"\>", ",", "\<\"\\\"DY152\\\"\"\>", 
     ",", "\<\"\\\"DY153\\\"\"\>", ",", "\<\"\\\"DY154\\\"\"\>", 
     ",", "\<\"\\\"DY155\\\"\"\>", ",", "\<\"\\\"DY156\\\"\"\>", 
     ",", "\<\"\\\"DY157\\\"\"\>", ",", "\<\"\\\"DY158\\\"\"\>", 
     ",", "\<\"\\\"DY159\\\"\"\>", ",", "\<\"\\\"DY160\\\"\"\>", 
     ",", "\<\"\\\"DY161\\\"\"\>", ",", "\<\"\\\"DY162\\\"\"\>", 
     ",", "\<\"\\\"DY163\\\"\"\>", ",", "\<\"\\\"DY164\\\"\"\>", 
     ",", "\<\"\\\"DY165\\\"\"\>", ",", "\<\"\\\"DY166\\\"\"\>", 
     ",", "\<\"\\\"DY167\\\"\"\>", ",", "\<\"\\\"DY168\\\"\"\>", 
     ",", "\<\"\\\"DY169\\\"\"\>", ",", "\<\"\\\"DY170\\\"\"\>", 
     ",", "\<\"\\\"DY171\\\"\"\>", ",", "\<\"\\\"DY172\\\"\"\>", 
     ",", "\<\"\\\"DY173\\\"\"\>", ",", "\<\"\\\"HO\\\"\"\>", 
     ",", "\<\"\\\"HO140\\\"\"\>", ",", "\<\"\\\"HO141\\\"\"\>", 
     ",", "\<\"\\\"HO142\\\"\"\>", ",", "\<\"\\\"HO143\\\"\"\>", 
     ",", "\<\"\\\"HO144\\\"\"\>", ",", "\<\"\\\"HO145\\\"\"\>", 
     ",", "\<\"\\\"HO146\\\"\"\>", ",", "\<\"\\\"HO147\\\"\"\>", 
     ",", "\<\"\\\"HO148\\\"\"\>", ",", "\<\"\\\"HO149\\\"\"\>", 
     ",", "\<\"\\\"HO150\\\"\"\>", ",", "\<\"\\\"HO151\\\"\"\>", 
     ",", "\<\"\\\"HO152\\\"\"\>", ",", "\<\"\\\"HO153\\\"\"\>", 
     ",", "\<\"\\\"HO154\\\"\"\>", ",", "\<\"\\\"HO155\\\"\"\>", 
     ",", "\<\"\\\"HO156\\\"\"\>", ",", "\<\"\\\"HO157\\\"\"\>", 
     ",", "\<\"\\\"HO158\\\"\"\>", ",", "\<\"\\\"HO159\\\"\"\>", 
     ",", "\<\"\\\"HO160\\\"\"\>", ",", "\<\"\\\"HO161\\\"\"\>", 
     ",", "\<\"\\\"HO162\\\"\"\>", ",", "\<\"\\\"HO163\\\"\"\>", 
     ",", "\<\"\\\"HO164\\\"\"\>", ",", "\<\"\\\"HO165\\\"\"\>", 
     ",", "\<\"\\\"HO166\\\"\"\>", ",", "\<\"\\\"HO167\\\"\"\>", 
     ",", "\<\"\\\"HO168\\\"\"\>", ",", "\<\"\\\"HO169\\\"\"\>", 
     ",", "\<\"\\\"HO170\\\"\"\>", ",", "\<\"\\\"HO171\\\"\"\>", 
     ",", "\<\"\\\"HO172\\\"\"\>", ",", "\<\"\\\"HO173\\\"\"\>", 
     ",", "\<\"\\\"HO174\\\"\"\>", ",", "\<\"\\\"HO175\\\"\"\>", 
     ",", "\<\"\\\"ER\\\"\"\>", ",", "\<\"\\\"ER143\\\"\"\>", 
     ",", "\<\"\\\"ER144\\\"\"\>", ",", "\<\"\\\"ER145\\\"\"\>", 
     ",", "\<\"\\\"ER146\\\"\"\>", ",", "\<\"\\\"ER147\\\"\"\>", 
     ",", "\<\"\\\"ER148\\\"\"\>", ",", "\<\"\\\"ER149\\\"\"\>", 
     ",", "\<\"\\\"ER150\\\"\"\>", ",", "\<\"\\\"ER151\\\"\"\>", 
     ",", "\<\"\\\"ER152\\\"\"\>", ",", "\<\"\\\"ER153\\\"\"\>", 
     ",", "\<\"\\\"ER154\\\"\"\>", ",", "\<\"\\\"ER155\\\"\"\>", 
     ",", "\<\"\\\"ER156\\\"\"\>", ",", "\<\"\\\"ER157\\\"\"\>", 
     ",", "\<\"\\\"ER158\\\"\"\>", ",", "\<\"\\\"ER159\\\"\"\>", 
     ",", "\<\"\\\"ER160\\\"\"\>", ",", "\<\"\\\"ER161\\\"\"\>", 
     ",", "\<\"\\\"ER162\\\"\"\>", ",", "\<\"\\\"ER163\\\"\"\>", 
     ",", "\<\"\\\"ER164\\\"\"\>", ",", "\<\"\\\"ER165\\\"\"\>", 
     ",", "\<\"\\\"ER166\\\"\"\>", ",", "\<\"\\\"ER167\\\"\"\>", 
     ",", "\<\"\\\"ER168\\\"\"\>", ",", "\<\"\\\"ER169\\\"\"\>", 
     ",", "\<\"\\\"ER170\\\"\"\>", ",", "\<\"\\\"ER171\\\"\"\>", 
     ",", "\<\"\\\"ER172\\\"\"\>", ",", "\<\"\\\"ER173\\\"\"\>", 
     ",", "\<\"\\\"ER174\\\"\"\>", ",", "\<\"\\\"ER175\\\"\"\>", 
     ",", "\<\"\\\"ER176\\\"\"\>", ",", "\<\"\\\"ER177\\\"\"\>", 
     ",", "\<\"\\\"TM\\\"\"\>", ",", "\<\"\\\"TM145\\\"\"\>", 
     ",", "\<\"\\\"TM146\\\"\"\>", ",", "\<\"\\\"TM147\\\"\"\>", 
     ",", "\<\"\\\"TM148\\\"\"\>", ",", "\<\"\\\"TM149\\\"\"\>", 
     ",", "\<\"\\\"TM150\\\"\"\>", ",", "\<\"\\\"TM151\\\"\"\>", 
     ",", "\<\"\\\"TM152\\\"\"\>", ",", "\<\"\\\"TM153\\\"\"\>", 
     ",", "\<\"\\\"TM154\\\"\"\>", ",", "\<\"\\\"TM155\\\"\"\>", 
     ",", "\<\"\\\"TM156\\\"\"\>", ",", "\<\"\\\"TM157\\\"\"\>", 
     ",", "\<\"\\\"TM158\\\"\"\>", ",", "\<\"\\\"TM159\\\"\"\>", 
     ",", "\<\"\\\"TM160\\\"\"\>", ",", "\<\"\\\"TM161\\\"\"\>", 
     ",", "\<\"\\\"TM162\\\"\"\>", ",", "\<\"\\\"TM163\\\"\"\>", 
     ",", "\<\"\\\"TM164\\\"\"\>", ",", "\<\"\\\"TM165\\\"\"\>", 
     ",", "\<\"\\\"TM166\\\"\"\>", ",", "\<\"\\\"TM167\\\"\"\>", 
     ",", "\<\"\\\"TM168\\\"\"\>", ",", "\<\"\\\"TM169\\\"\"\>", 
     ",", "\<\"\\\"TM170\\\"\"\>", ",", "\<\"\\\"TM171\\\"\"\>", 
     ",", "\<\"\\\"TM172\\\"\"\>", ",", "\<\"\\\"TM173\\\"\"\>", 
     ",", "\<\"\\\"TM174\\\"\"\>", ",", "\<\"\\\"TM175\\\"\"\>", 
     ",", "\<\"\\\"TM176\\\"\"\>", ",", "\<\"\\\"TM177\\\"\"\>", 
     ",", "\<\"\\\"TM178\\\"\"\>", ",", "\<\"\\\"TM179\\\"\"\>", 
     ",", "\<\"\\\"YB\\\"\"\>", ",", "\<\"\\\"YB148\\\"\"\>", 
     ",", "\<\"\\\"YB149\\\"\"\>", ",", "\<\"\\\"YB150\\\"\"\>", 
     ",", "\<\"\\\"YB151\\\"\"\>", ",", "\<\"\\\"YB152\\\"\"\>", 
     ",", "\<\"\\\"YB153\\\"\"\>", ",", "\<\"\\\"YB154\\\"\"\>", 
     ",", "\<\"\\\"YB155\\\"\"\>", ",", "\<\"\\\"YB156\\\"\"\>", 
     ",", "\<\"\\\"YB157\\\"\"\>", ",", "\<\"\\\"YB158\\\"\"\>", 
     ",", "\<\"\\\"YB159\\\"\"\>", ",", "\<\"\\\"YB160\\\"\"\>", 
     ",", "\<\"\\\"YB161\\\"\"\>", ",", "\<\"\\\"YB162\\\"\"\>", 
     ",", "\<\"\\\"YB163\\\"\"\>", ",", "\<\"\\\"YB164\\\"\"\>", 
     ",", "\<\"\\\"YB165\\\"\"\>", ",", "\<\"\\\"YB166\\\"\"\>", 
     ",", "\<\"\\\"YB167\\\"\"\>", ",", "\<\"\\\"YB168\\\"\"\>", 
     ",", "\<\"\\\"YB169\\\"\"\>", ",", "\<\"\\\"YB170\\\"\"\>", 
     ",", "\<\"\\\"YB171\\\"\"\>", ",", "\<\"\\\"YB172\\\"\"\>", 
     ",", "\<\"\\\"YB173\\\"\"\>", ",", "\<\"\\\"YB174\\\"\"\>", 
     ",", "\<\"\\\"YB175\\\"\"\>", ",", "\<\"\\\"YB176\\\"\"\>", 
     ",", "\<\"\\\"YB177\\\"\"\>", ",", "\<\"\\\"YB178\\\"\"\>", 
     ",", "\<\"\\\"YB179\\\"\"\>", ",", "\<\"\\\"YB180\\\"\"\>", 
     ",", "\<\"\\\"YB181\\\"\"\>", ",", "\<\"\\\"LU\\\"\"\>", 
     ",", "\<\"\\\"LU150\\\"\"\>", ",", "\<\"\\\"LU151\\\"\"\>", 
     ",", "\<\"\\\"LU152\\\"\"\>", ",", "\<\"\\\"LU153\\\"\"\>", 
     ",", "\<\"\\\"LU154\\\"\"\>", ",", "\<\"\\\"LU155\\\"\"\>", 
     ",", "\<\"\\\"LU156\\\"\"\>", ",", "\<\"\\\"LU157\\\"\"\>", 
     ",", "\<\"\\\"LU158\\\"\"\>", ",", "\<\"\\\"LU159\\\"\"\>", 
     ",", "\<\"\\\"LU160\\\"\"\>", ",", "\<\"\\\"LU161\\\"\"\>", 
     ",", "\<\"\\\"LU162\\\"\"\>", ",", "\<\"\\\"LU163\\\"\"\>", 
     ",", "\<\"\\\"LU164\\\"\"\>", ",", "\<\"\\\"LU165\\\"\"\>", 
     ",", "\<\"\\\"LU166\\\"\"\>", ",", "\<\"\\\"LU167\\\"\"\>", 
     ",", "\<\"\\\"LU168\\\"\"\>", ",", "\<\"\\\"LU169\\\"\"\>", 
     ",", "\<\"\\\"LU170\\\"\"\>", ",", "\<\"\\\"LU171\\\"\"\>", 
     ",", "\<\"\\\"LU172\\\"\"\>", ",", "\<\"\\\"LU173\\\"\"\>", 
     ",", "\<\"\\\"LU174\\\"\"\>", ",", "\<\"\\\"LU175\\\"\"\>", 
     ",", "\<\"\\\"LU176\\\"\"\>", ",", "\<\"\\\"LU177\\\"\"\>", 
     ",", "\<\"\\\"LU178\\\"\"\>", ",", "\<\"\\\"LU179\\\"\"\>", 
     ",", "\<\"\\\"LU180\\\"\"\>", ",", "\<\"\\\"LU181\\\"\"\>", 
     ",", "\<\"\\\"LU182\\\"\"\>", ",", "\<\"\\\"LU183\\\"\"\>", 
     ",", "\<\"\\\"LU184\\\"\"\>", ",", "\<\"\\\"HF\\\"\"\>", 
     ",", "\<\"\\\"HF153\\\"\"\>", ",", "\<\"\\\"HF154\\\"\"\>", 
     ",", "\<\"\\\"HF155\\\"\"\>", ",", "\<\"\\\"HF156\\\"\"\>", 
     ",", "\<\"\\\"HF157\\\"\"\>", ",", "\<\"\\\"HF158\\\"\"\>", 
     ",", "\<\"\\\"HF159\\\"\"\>", ",", "\<\"\\\"HF160\\\"\"\>", 
     ",", "\<\"\\\"HF161\\\"\"\>", ",", "\<\"\\\"HF162\\\"\"\>", 
     ",", "\<\"\\\"HF163\\\"\"\>", ",", "\<\"\\\"HF164\\\"\"\>", 
     ",", "\<\"\\\"HF165\\\"\"\>", ",", "\<\"\\\"HF166\\\"\"\>", 
     ",", "\<\"\\\"HF167\\\"\"\>", ",", "\<\"\\\"HF168\\\"\"\>", 
     ",", "\<\"\\\"HF169\\\"\"\>", ",", "\<\"\\\"HF170\\\"\"\>", 
     ",", "\<\"\\\"HF171\\\"\"\>", ",", "\<\"\\\"HF172\\\"\"\>", 
     ",", "\<\"\\\"HF173\\\"\"\>", ",", "\<\"\\\"HF174\\\"\"\>", 
     ",", "\<\"\\\"HF175\\\"\"\>", ",", "\<\"\\\"HF176\\\"\"\>", 
     ",", "\<\"\\\"HF177\\\"\"\>", ",", "\<\"\\\"HF178\\\"\"\>", 
     ",", "\<\"\\\"HF179\\\"\"\>", ",", "\<\"\\\"HF180\\\"\"\>", 
     ",", "\<\"\\\"HF181\\\"\"\>", ",", "\<\"\\\"HF182\\\"\"\>", 
     ",", "\<\"\\\"HF183\\\"\"\>", ",", "\<\"\\\"HF184\\\"\"\>", 
     ",", "\<\"\\\"HF185\\\"\"\>", ",", "\<\"\\\"HF186\\\"\"\>", 
     ",", "\<\"\\\"HF187\\\"\"\>", ",", "\<\"\\\"HF188\\\"\"\>", 
     ",", "\<\"\\\"TA\\\"\"\>", ",", "\<\"\\\"TA155\\\"\"\>", 
     ",", "\<\"\\\"TA156\\\"\"\>", ",", "\<\"\\\"TA157\\\"\"\>", 
     ",", "\<\"\\\"TA158\\\"\"\>", ",", "\<\"\\\"TA159\\\"\"\>", 
     ",", "\<\"\\\"TA160\\\"\"\>", ",", "\<\"\\\"TA161\\\"\"\>", 
     ",", "\<\"\\\"TA162\\\"\"\>", ",", "\<\"\\\"TA163\\\"\"\>", 
     ",", "\<\"\\\"TA164\\\"\"\>", ",", "\<\"\\\"TA165\\\"\"\>", 
     ",", "\<\"\\\"TA166\\\"\"\>", ",", "\<\"\\\"TA167\\\"\"\>", 
     ",", "\<\"\\\"TA168\\\"\"\>", ",", "\<\"\\\"TA169\\\"\"\>", 
     ",", "\<\"\\\"TA170\\\"\"\>", ",", "\<\"\\\"TA171\\\"\"\>", 
     ",", "\<\"\\\"TA172\\\"\"\>", ",", "\<\"\\\"TA173\\\"\"\>", 
     ",", "\<\"\\\"TA174\\\"\"\>", ",", "\<\"\\\"TA175\\\"\"\>", 
     ",", "\<\"\\\"TA176\\\"\"\>", ",", "\<\"\\\"TA177\\\"\"\>", 
     ",", "\<\"\\\"TA178\\\"\"\>", ",", "\<\"\\\"TA179\\\"\"\>", 
     ",", "\<\"\\\"TA180\\\"\"\>", ",", "\<\"\\\"TA181\\\"\"\>", 
     ",", "\<\"\\\"TA182\\\"\"\>", ",", "\<\"\\\"TA183\\\"\"\>", 
     ",", "\<\"\\\"TA184\\\"\"\>", ",", "\<\"\\\"TA185\\\"\"\>", 
     ",", "\<\"\\\"TA186\\\"\"\>", ",", "\<\"\\\"TA187\\\"\"\>", 
     ",", "\<\"\\\"TA188\\\"\"\>", ",", "\<\"\\\"TA189\\\"\"\>", 
     ",", "\<\"\\\"TA190\\\"\"\>", ",", "\<\"\\\"W\\\"\"\>", 
     ",", "\<\"\\\"W158\\\"\"\>", ",", "\<\"\\\"W159\\\"\"\>", 
     ",", "\<\"\\\"W160\\\"\"\>", ",", "\<\"\\\"W161\\\"\"\>", 
     ",", "\<\"\\\"W162\\\"\"\>", ",", "\<\"\\\"W163\\\"\"\>", 
     ",", "\<\"\\\"W164\\\"\"\>", ",", "\<\"\\\"W165\\\"\"\>", 
     ",", "\<\"\\\"W166\\\"\"\>", ",", "\<\"\\\"W167\\\"\"\>", 
     ",", "\<\"\\\"W168\\\"\"\>", ",", "\<\"\\\"W169\\\"\"\>", 
     ",", "\<\"\\\"W170\\\"\"\>", ",", "\<\"\\\"W171\\\"\"\>", 
     ",", "\<\"\\\"W172\\\"\"\>", ",", "\<\"\\\"W173\\\"\"\>", 
     ",", "\<\"\\\"W174\\\"\"\>", ",", "\<\"\\\"W175\\\"\"\>", 
     ",", "\<\"\\\"W176\\\"\"\>", ",", "\<\"\\\"W177\\\"\"\>", 
     ",", "\<\"\\\"W178\\\"\"\>", ",", "\<\"\\\"W179\\\"\"\>", 
     ",", "\<\"\\\"W180\\\"\"\>", ",", "\<\"\\\"W181\\\"\"\>", 
     ",", "\<\"\\\"W182\\\"\"\>", ",", "\<\"\\\"W183\\\"\"\>", 
     ",", "\<\"\\\"W184\\\"\"\>", ",", "\<\"\\\"W185\\\"\"\>", 
     ",", "\<\"\\\"W186\\\"\"\>", ",", "\<\"\\\"W187\\\"\"\>", 
     ",", "\<\"\\\"W188\\\"\"\>", ",", "\<\"\\\"W189\\\"\"\>", 
     ",", "\<\"\\\"W190\\\"\"\>", ",", "\<\"\\\"W191\\\"\"\>", 
     ",", "\<\"\\\"W192\\\"\"\>", ",", "\<\"\\\"RE\\\"\"\>", 
     ",", "\<\"\\\"RE160\\\"\"\>", ",", "\<\"\\\"RE161\\\"\"\>", 
     ",", "\<\"\\\"RE162\\\"\"\>", ",", "\<\"\\\"RE163\\\"\"\>", 
     ",", "\<\"\\\"RE164\\\"\"\>", ",", "\<\"\\\"RE165\\\"\"\>", 
     ",", "\<\"\\\"RE166\\\"\"\>", ",", "\<\"\\\"RE167\\\"\"\>", 
     ",", "\<\"\\\"RE168\\\"\"\>", ",", "\<\"\\\"RE169\\\"\"\>", 
     ",", "\<\"\\\"RE170\\\"\"\>", ",", "\<\"\\\"RE171\\\"\"\>", 
     ",", "\<\"\\\"RE172\\\"\"\>", ",", "\<\"\\\"RE173\\\"\"\>", 
     ",", "\<\"\\\"RE174\\\"\"\>", ",", "\<\"\\\"RE175\\\"\"\>", 
     ",", "\<\"\\\"RE176\\\"\"\>", ",", "\<\"\\\"RE177\\\"\"\>", 
     ",", "\<\"\\\"RE178\\\"\"\>", ",", "\<\"\\\"RE179\\\"\"\>", 
     ",", "\<\"\\\"RE180\\\"\"\>", ",", "\<\"\\\"RE181\\\"\"\>", 
     ",", "\<\"\\\"RE182\\\"\"\>", ",", "\<\"\\\"RE183\\\"\"\>", 
     ",", "\<\"\\\"RE184\\\"\"\>", ",", "\<\"\\\"RE185\\\"\"\>", 
     ",", "\<\"\\\"RE186\\\"\"\>", ",", "\<\"\\\"RE187\\\"\"\>", 
     ",", "\<\"\\\"RE188\\\"\"\>", ",", "\<\"\\\"RE189\\\"\"\>", 
     ",", "\<\"\\\"RE190\\\"\"\>", ",", "\<\"\\\"RE191\\\"\"\>", 
     ",", "\<\"\\\"RE192\\\"\"\>", ",", "\<\"\\\"RE193\\\"\"\>", 
     ",", "\<\"\\\"RE194\\\"\"\>", ",", "\<\"\\\"OS\\\"\"\>", 
     ",", "\<\"\\\"OS162\\\"\"\>", ",", "\<\"\\\"OS163\\\"\"\>", 
     ",", "\<\"\\\"OS164\\\"\"\>", ",", "\<\"\\\"OS165\\\"\"\>", 
     ",", "\<\"\\\"OS166\\\"\"\>", ",", "\<\"\\\"OS167\\\"\"\>", 
     ",", "\<\"\\\"OS168\\\"\"\>", ",", "\<\"\\\"OS169\\\"\"\>", 
     ",", "\<\"\\\"OS170\\\"\"\>", ",", "\<\"\\\"OS171\\\"\"\>", 
     ",", "\<\"\\\"OS172\\\"\"\>", ",", "\<\"\\\"OS173\\\"\"\>", 
     ",", "\<\"\\\"OS174\\\"\"\>", ",", "\<\"\\\"OS175\\\"\"\>", 
     ",", "\<\"\\\"OS176\\\"\"\>", ",", "\<\"\\\"OS177\\\"\"\>", 
     ",", "\<\"\\\"OS178\\\"\"\>", ",", "\<\"\\\"OS179\\\"\"\>", 
     ",", "\<\"\\\"OS180\\\"\"\>", ",", "\<\"\\\"OS181\\\"\"\>", 
     ",", "\<\"\\\"OS182\\\"\"\>", ",", "\<\"\\\"OS183\\\"\"\>", 
     ",", "\<\"\\\"OS184\\\"\"\>", ",", "\<\"\\\"OS185\\\"\"\>", 
     ",", "\<\"\\\"OS186\\\"\"\>", ",", "\<\"\\\"OS187\\\"\"\>", 
     ",", "\<\"\\\"OS188\\\"\"\>", ",", "\<\"\\\"OS189\\\"\"\>", 
     ",", "\<\"\\\"OS190\\\"\"\>", ",", "\<\"\\\"OS191\\\"\"\>", 
     ",", "\<\"\\\"OS192\\\"\"\>", ",", "\<\"\\\"OS193\\\"\"\>", 
     ",", "\<\"\\\"OS194\\\"\"\>", ",", "\<\"\\\"OS195\\\"\"\>", 
     ",", "\<\"\\\"OS196\\\"\"\>", ",", "\<\"\\\"IR\\\"\"\>", 
     ",", "\<\"\\\"IR164\\\"\"\>", ",", "\<\"\\\"IR165\\\"\"\>", 
     ",", "\<\"\\\"IR166\\\"\"\>", ",", "\<\"\\\"IR167\\\"\"\>", 
     ",", "\<\"\\\"IR168\\\"\"\>", ",", "\<\"\\\"IR169\\\"\"\>", 
     ",", "\<\"\\\"IR170\\\"\"\>", ",", "\<\"\\\"IR171\\\"\"\>", 
     ",", "\<\"\\\"IR172\\\"\"\>", ",", "\<\"\\\"IR173\\\"\"\>", 
     ",", "\<\"\\\"IR174\\\"\"\>", ",", "\<\"\\\"IR175\\\"\"\>", 
     ",", "\<\"\\\"IR176\\\"\"\>", ",", "\<\"\\\"IR177\\\"\"\>", 
     ",", "\<\"\\\"IR178\\\"\"\>", ",", "\<\"\\\"IR179\\\"\"\>", 
     ",", "\<\"\\\"IR180\\\"\"\>", ",", "\<\"\\\"IR181\\\"\"\>", 
     ",", "\<\"\\\"IR182\\\"\"\>", ",", "\<\"\\\"IR183\\\"\"\>", 
     ",", "\<\"\\\"IR184\\\"\"\>", ",", "\<\"\\\"IR185\\\"\"\>", 
     ",", "\<\"\\\"IR186\\\"\"\>", ",", "\<\"\\\"IR187\\\"\"\>", 
     ",", "\<\"\\\"IR188\\\"\"\>", ",", "\<\"\\\"IR189\\\"\"\>", 
     ",", "\<\"\\\"IR190\\\"\"\>", ",", "\<\"\\\"IR191\\\"\"\>", 
     ",", "\<\"\\\"IR192\\\"\"\>", ",", "\<\"\\\"IR193\\\"\"\>", 
     ",", "\<\"\\\"IR194\\\"\"\>", ",", "\<\"\\\"IR195\\\"\"\>", 
     ",", "\<\"\\\"IR196\\\"\"\>", ",", "\<\"\\\"IR197\\\"\"\>", 
     ",", "\<\"\\\"IR198\\\"\"\>", ",", "\<\"\\\"IR199\\\"\"\>", 
     ",", "\<\"\\\"PT\\\"\"\>", ",", "\<\"\\\"PT166\\\"\"\>", 
     ",", "\<\"\\\"PT167\\\"\"\>", ",", "\<\"\\\"PT168\\\"\"\>", 
     ",", "\<\"\\\"PT169\\\"\"\>", ",", "\<\"\\\"PT170\\\"\"\>", 
     ",", "\<\"\\\"PT171\\\"\"\>", ",", "\<\"\\\"PT172\\\"\"\>", 
     ",", "\<\"\\\"PT173\\\"\"\>", ",", "\<\"\\\"PT174\\\"\"\>", 
     ",", "\<\"\\\"PT175\\\"\"\>", ",", "\<\"\\\"PT176\\\"\"\>", 
     ",", "\<\"\\\"PT177\\\"\"\>", ",", "\<\"\\\"PT178\\\"\"\>", 
     ",", "\<\"\\\"PT179\\\"\"\>", ",", "\<\"\\\"PT180\\\"\"\>", 
     ",", "\<\"\\\"PT181\\\"\"\>", ",", "\<\"\\\"PT182\\\"\"\>", 
     ",", "\<\"\\\"PT183\\\"\"\>", ",", "\<\"\\\"PT184\\\"\"\>", 
     ",", "\<\"\\\"PT185\\\"\"\>", ",", "\<\"\\\"PT186\\\"\"\>", 
     ",", "\<\"\\\"PT187\\\"\"\>", ",", "\<\"\\\"PT188\\\"\"\>", 
     ",", "\<\"\\\"PT189\\\"\"\>", ",", "\<\"\\\"PT190\\\"\"\>", 
     ",", "\<\"\\\"PT191\\\"\"\>", ",", "\<\"\\\"PT192\\\"\"\>", 
     ",", "\<\"\\\"PT193\\\"\"\>", ",", "\<\"\\\"PT194\\\"\"\>", 
     ",", "\<\"\\\"PT195\\\"\"\>", ",", "\<\"\\\"PT196\\\"\"\>", 
     ",", "\<\"\\\"PT197\\\"\"\>", ",", "\<\"\\\"PT198\\\"\"\>", 
     ",", "\<\"\\\"PT199\\\"\"\>", ",", "\<\"\\\"PT200\\\"\"\>", 
     ",", "\<\"\\\"PT201\\\"\"\>", ",", "\<\"\\\"PT202\\\"\"\>", 
     ",", "\<\"\\\"AU\\\"\"\>", ",", "\<\"\\\"AU169\\\"\"\>", 
     ",", "\<\"\\\"AU170\\\"\"\>", ",", "\<\"\\\"AU171\\\"\"\>", 
     ",", "\<\"\\\"AU172\\\"\"\>", ",", "\<\"\\\"AU173\\\"\"\>", 
     ",", "\<\"\\\"AU174\\\"\"\>", ",", "\<\"\\\"AU175\\\"\"\>", 
     ",", "\<\"\\\"AU176\\\"\"\>", ",", "\<\"\\\"AU177\\\"\"\>", 
     ",", "\<\"\\\"AU178\\\"\"\>", ",", "\<\"\\\"AU179\\\"\"\>", 
     ",", "\<\"\\\"AU180\\\"\"\>", ",", "\<\"\\\"AU181\\\"\"\>", 
     ",", "\<\"\\\"AU182\\\"\"\>", ",", "\<\"\\\"AU183\\\"\"\>", 
     ",", "\<\"\\\"AU184\\\"\"\>", ",", "\<\"\\\"AU185\\\"\"\>", 
     ",", "\<\"\\\"AU186\\\"\"\>", ",", "\<\"\\\"AU187\\\"\"\>", 
     ",", "\<\"\\\"AU188\\\"\"\>", ",", "\<\"\\\"AU189\\\"\"\>", 
     ",", "\<\"\\\"AU190\\\"\"\>", ",", "\<\"\\\"AU191\\\"\"\>", 
     ",", "\<\"\\\"AU192\\\"\"\>", ",", "\<\"\\\"AU193\\\"\"\>", 
     ",", "\<\"\\\"AU194\\\"\"\>", ",", "\<\"\\\"AU195\\\"\"\>", 
     ",", "\<\"\\\"AU196\\\"\"\>", ",", "\<\"\\\"AU197\\\"\"\>", 
     ",", "\<\"\\\"AU198\\\"\"\>", ",", "\<\"\\\"AU199\\\"\"\>", 
     ",", "\<\"\\\"AU200\\\"\"\>", ",", "\<\"\\\"AU201\\\"\"\>", 
     ",", "\<\"\\\"AU202\\\"\"\>", ",", "\<\"\\\"AU203\\\"\"\>", 
     ",", "\<\"\\\"AU204\\\"\"\>", ",", "\<\"\\\"AU205\\\"\"\>", 
     ",", "\<\"\\\"HG\\\"\"\>", ",", "\<\"\\\"HG171\\\"\"\>", 
     ",", "\<\"\\\"HG172\\\"\"\>", ",", "\<\"\\\"HG173\\\"\"\>", 
     ",", "\<\"\\\"HG174\\\"\"\>", ",", "\<\"\\\"HG175\\\"\"\>", 
     ",", "\<\"\\\"HG176\\\"\"\>", ",", "\<\"\\\"HG177\\\"\"\>", 
     ",", "\<\"\\\"HG178\\\"\"\>", ",", "\<\"\\\"HG179\\\"\"\>", 
     ",", "\<\"\\\"HG180\\\"\"\>", ",", "\<\"\\\"HG181\\\"\"\>", 
     ",", "\<\"\\\"HG182\\\"\"\>", ",", "\<\"\\\"HG183\\\"\"\>", 
     ",", "\<\"\\\"HG184\\\"\"\>", ",", "\<\"\\\"HG185\\\"\"\>", 
     ",", "\<\"\\\"HG186\\\"\"\>", ",", "\<\"\\\"HG187\\\"\"\>", 
     ",", "\<\"\\\"HG188\\\"\"\>", ",", "\<\"\\\"HG189\\\"\"\>", 
     ",", "\<\"\\\"HG190\\\"\"\>", ",", "\<\"\\\"HG191\\\"\"\>", 
     ",", "\<\"\\\"HG192\\\"\"\>", ",", "\<\"\\\"HG193\\\"\"\>", 
     ",", "\<\"\\\"HG194\\\"\"\>", ",", "\<\"\\\"HG195\\\"\"\>", 
     ",", "\<\"\\\"HG196\\\"\"\>", ",", "\<\"\\\"HG197\\\"\"\>", 
     ",", "\<\"\\\"HG198\\\"\"\>", ",", "\<\"\\\"HG199\\\"\"\>", 
     ",", "\<\"\\\"HG200\\\"\"\>", ",", "\<\"\\\"HG201\\\"\"\>", 
     ",", "\<\"\\\"HG202\\\"\"\>", ",", "\<\"\\\"HG203\\\"\"\>", 
     ",", "\<\"\\\"HG204\\\"\"\>", ",", "\<\"\\\"HG205\\\"\"\>", 
     ",", "\<\"\\\"HG206\\\"\"\>", ",", "\<\"\\\"HG207\\\"\"\>", 
     ",", "\<\"\\\"HG208\\\"\"\>", ",", "\<\"\\\"HG209\\\"\"\>", 
     ",", "\<\"\\\"HG210\\\"\"\>", ",", "\<\"\\\"TL\\\"\"\>", 
     ",", "\<\"\\\"TL176\\\"\"\>", ",", "\<\"\\\"TL177\\\"\"\>", 
     ",", "\<\"\\\"TL178\\\"\"\>", ",", "\<\"\\\"TL179\\\"\"\>", 
     ",", "\<\"\\\"TL180\\\"\"\>", ",", "\<\"\\\"TL181\\\"\"\>", 
     ",", "\<\"\\\"TL182\\\"\"\>", ",", "\<\"\\\"TL183\\\"\"\>", 
     ",", "\<\"\\\"TL184\\\"\"\>", ",", "\<\"\\\"TL185\\\"\"\>", 
     ",", "\<\"\\\"TL186\\\"\"\>", ",", "\<\"\\\"TL187\\\"\"\>", 
     ",", "\<\"\\\"TL188\\\"\"\>", ",", "\<\"\\\"TL189\\\"\"\>", 
     ",", "\<\"\\\"TL190\\\"\"\>", ",", "\<\"\\\"TL191\\\"\"\>", 
     ",", "\<\"\\\"TL192\\\"\"\>", ",", "\<\"\\\"TL193\\\"\"\>", 
     ",", "\<\"\\\"TL194\\\"\"\>", ",", "\<\"\\\"TL195\\\"\"\>", 
     ",", "\<\"\\\"TL196\\\"\"\>", ",", "\<\"\\\"TL197\\\"\"\>", 
     ",", "\<\"\\\"TL198\\\"\"\>", ",", "\<\"\\\"TL199\\\"\"\>", 
     ",", "\<\"\\\"TL200\\\"\"\>", ",", "\<\"\\\"TL201\\\"\"\>", 
     ",", "\<\"\\\"TL202\\\"\"\>", ",", "\<\"\\\"TL203\\\"\"\>", 
     ",", "\<\"\\\"TL204\\\"\"\>", ",", "\<\"\\\"TL205\\\"\"\>", 
     ",", "\<\"\\\"TL206\\\"\"\>", ",", "\<\"\\\"TL207\\\"\"\>", 
     ",", "\<\"\\\"TL208\\\"\"\>", ",", "\<\"\\\"TL209\\\"\"\>", 
     ",", "\<\"\\\"TL210\\\"\"\>", ",", "\<\"\\\"TL211\\\"\"\>", 
     ",", "\<\"\\\"TL212\\\"\"\>", ",", "\<\"\\\"PB\\\"\"\>", 
     ",", "\<\"\\\"PB178\\\"\"\>", ",", "\<\"\\\"PB179\\\"\"\>", 
     ",", "\<\"\\\"PB180\\\"\"\>", ",", "\<\"\\\"PB181\\\"\"\>", 
     ",", "\<\"\\\"PB182\\\"\"\>", ",", "\<\"\\\"PB183\\\"\"\>", 
     ",", "\<\"\\\"PB184\\\"\"\>", ",", "\<\"\\\"PB185\\\"\"\>", 
     ",", "\<\"\\\"PB186\\\"\"\>", ",", "\<\"\\\"PB187\\\"\"\>", 
     ",", "\<\"\\\"PB188\\\"\"\>", ",", "\<\"\\\"PB189\\\"\"\>", 
     ",", "\<\"\\\"PB190\\\"\"\>", ",", "\<\"\\\"PB191\\\"\"\>", 
     ",", "\<\"\\\"PB192\\\"\"\>", ",", "\<\"\\\"PB193\\\"\"\>", 
     ",", "\<\"\\\"PB194\\\"\"\>", ",", "\<\"\\\"PB195\\\"\"\>", 
     ",", "\<\"\\\"PB196\\\"\"\>", ",", "\<\"\\\"PB197\\\"\"\>", 
     ",", "\<\"\\\"PB198\\\"\"\>", ",", "\<\"\\\"PB199\\\"\"\>", 
     ",", "\<\"\\\"PB200\\\"\"\>", ",", "\<\"\\\"PB201\\\"\"\>", 
     ",", "\<\"\\\"PB202\\\"\"\>", ",", "\<\"\\\"PB203\\\"\"\>", 
     ",", "\<\"\\\"PB204\\\"\"\>", ",", "\<\"\\\"PB205\\\"\"\>", 
     ",", "\<\"\\\"PB206\\\"\"\>", ",", "\<\"\\\"PB207\\\"\"\>", 
     ",", "\<\"\\\"PB208\\\"\"\>", ",", "\<\"\\\"PB209\\\"\"\>", 
     ",", "\<\"\\\"PB210\\\"\"\>", ",", "\<\"\\\"PB211\\\"\"\>", 
     ",", "\<\"\\\"PB212\\\"\"\>", ",", "\<\"\\\"PB213\\\"\"\>", 
     ",", "\<\"\\\"PB214\\\"\"\>", ",", "\<\"\\\"PB215\\\"\"\>", 
     ",", "\<\"\\\"BI\\\"\"\>", ",", "\<\"\\\"BI184\\\"\"\>", 
     ",", "\<\"\\\"BI185\\\"\"\>", ",", "\<\"\\\"BI186\\\"\"\>", 
     ",", "\<\"\\\"BI187\\\"\"\>", ",", "\<\"\\\"BI188\\\"\"\>", 
     ",", "\<\"\\\"BI189\\\"\"\>", ",", "\<\"\\\"BI190\\\"\"\>", 
     ",", "\<\"\\\"BI191\\\"\"\>", ",", "\<\"\\\"BI192\\\"\"\>", 
     ",", "\<\"\\\"BI193\\\"\"\>", ",", "\<\"\\\"BI194\\\"\"\>", 
     ",", "\<\"\\\"BI195\\\"\"\>", ",", "\<\"\\\"BI196\\\"\"\>", 
     ",", "\<\"\\\"BI197\\\"\"\>", ",", "\<\"\\\"BI198\\\"\"\>", 
     ",", "\<\"\\\"BI199\\\"\"\>", ",", "\<\"\\\"BI200\\\"\"\>", 
     ",", "\<\"\\\"BI201\\\"\"\>", ",", "\<\"\\\"BI202\\\"\"\>", 
     ",", "\<\"\\\"BI203\\\"\"\>", ",", "\<\"\\\"BI204\\\"\"\>", 
     ",", "\<\"\\\"BI205\\\"\"\>", ",", "\<\"\\\"BI206\\\"\"\>", 
     ",", "\<\"\\\"BI207\\\"\"\>", ",", "\<\"\\\"BI208\\\"\"\>", 
     ",", "\<\"\\\"BI209\\\"\"\>", ",", "\<\"\\\"BI210\\\"\"\>", 
     ",", "\<\"\\\"BI211\\\"\"\>", ",", "\<\"\\\"BI212\\\"\"\>", 
     ",", "\<\"\\\"BI213\\\"\"\>", ",", "\<\"\\\"BI214\\\"\"\>", 
     ",", "\<\"\\\"BI215\\\"\"\>", ",", "\<\"\\\"BI216\\\"\"\>", 
     ",", "\<\"\\\"BI217\\\"\"\>", ",", "\<\"\\\"BI218\\\"\"\>", 
     ",", "\<\"\\\"PO\\\"\"\>", ",", "\<\"\\\"PO188\\\"\"\>", 
     ",", "\<\"\\\"PO189\\\"\"\>", ",", "\<\"\\\"PO190\\\"\"\>", 
     ",", "\<\"\\\"PO191\\\"\"\>", ",", "\<\"\\\"PO192\\\"\"\>", 
     ",", "\<\"\\\"PO193\\\"\"\>", ",", "\<\"\\\"PO194\\\"\"\>", 
     ",", "\<\"\\\"PO195\\\"\"\>", ",", "\<\"\\\"PO196\\\"\"\>", 
     ",", "\<\"\\\"PO197\\\"\"\>", ",", "\<\"\\\"PO198\\\"\"\>", 
     ",", "\<\"\\\"PO199\\\"\"\>", ",", "\<\"\\\"PO200\\\"\"\>", 
     ",", "\<\"\\\"PO201\\\"\"\>", ",", "\<\"\\\"PO202\\\"\"\>", 
     ",", "\<\"\\\"PO203\\\"\"\>", ",", "\<\"\\\"PO204\\\"\"\>", 
     ",", "\<\"\\\"PO205\\\"\"\>", ",", "\<\"\\\"PO206\\\"\"\>", 
     ",", "\<\"\\\"PO207\\\"\"\>", ",", "\<\"\\\"PO208\\\"\"\>", 
     ",", "\<\"\\\"PO209\\\"\"\>", ",", "\<\"\\\"PO210\\\"\"\>", 
     ",", "\<\"\\\"PO211\\\"\"\>", ",", "\<\"\\\"PO212\\\"\"\>", 
     ",", "\<\"\\\"PO213\\\"\"\>", ",", "\<\"\\\"PO214\\\"\"\>", 
     ",", "\<\"\\\"PO215\\\"\"\>", ",", "\<\"\\\"PO216\\\"\"\>", 
     ",", "\<\"\\\"PO217\\\"\"\>", ",", "\<\"\\\"PO218\\\"\"\>", 
     ",", "\<\"\\\"PO219\\\"\"\>", ",", "\<\"\\\"PO220\\\"\"\>", 
     ",", "\<\"\\\"AT\\\"\"\>", ",", "\<\"\\\"AT193\\\"\"\>", 
     ",", "\<\"\\\"AT194\\\"\"\>", ",", "\<\"\\\"AT195\\\"\"\>", 
     ",", "\<\"\\\"AT196\\\"\"\>", ",", "\<\"\\\"AT197\\\"\"\>", 
     ",", "\<\"\\\"AT198\\\"\"\>", ",", "\<\"\\\"AT199\\\"\"\>", 
     ",", "\<\"\\\"AT200\\\"\"\>", ",", "\<\"\\\"AT201\\\"\"\>", 
     ",", "\<\"\\\"AT202\\\"\"\>", ",", "\<\"\\\"AT203\\\"\"\>", 
     ",", "\<\"\\\"AT204\\\"\"\>", ",", "\<\"\\\"AT205\\\"\"\>", 
     ",", "\<\"\\\"AT206\\\"\"\>", ",", "\<\"\\\"AT207\\\"\"\>", 
     ",", "\<\"\\\"AT208\\\"\"\>", ",", "\<\"\\\"AT209\\\"\"\>", 
     ",", "\<\"\\\"AT210\\\"\"\>", ",", "\<\"\\\"AT211\\\"\"\>", 
     ",", "\<\"\\\"AT212\\\"\"\>", ",", "\<\"\\\"AT213\\\"\"\>", 
     ",", "\<\"\\\"AT214\\\"\"\>", ",", "\<\"\\\"AT215\\\"\"\>", 
     ",", "\<\"\\\"AT216\\\"\"\>", ",", "\<\"\\\"AT217\\\"\"\>", 
     ",", "\<\"\\\"AT218\\\"\"\>", ",", "\<\"\\\"AT219\\\"\"\>", 
     ",", "\<\"\\\"AT220\\\"\"\>", ",", "\<\"\\\"AT221\\\"\"\>", 
     ",", "\<\"\\\"AT222\\\"\"\>", ",", "\<\"\\\"AT223\\\"\"\>", 
     ",", "\<\"\\\"RN\\\"\"\>", ",", "\<\"\\\"RN195\\\"\"\>", 
     ",", "\<\"\\\"RN196\\\"\"\>", ",", "\<\"\\\"RN197\\\"\"\>", 
     ",", "\<\"\\\"RN198\\\"\"\>", ",", "\<\"\\\"RN199\\\"\"\>", 
     ",", "\<\"\\\"RN200\\\"\"\>", ",", "\<\"\\\"RN201\\\"\"\>", 
     ",", "\<\"\\\"RN202\\\"\"\>", ",", "\<\"\\\"RN203\\\"\"\>", 
     ",", "\<\"\\\"RN204\\\"\"\>", ",", "\<\"\\\"RN205\\\"\"\>", 
     ",", "\<\"\\\"RN206\\\"\"\>", ",", "\<\"\\\"RN207\\\"\"\>", 
     ",", "\<\"\\\"RN208\\\"\"\>", ",", "\<\"\\\"RN209\\\"\"\>", 
     ",", "\<\"\\\"RN210\\\"\"\>", ",", "\<\"\\\"RN211\\\"\"\>", 
     ",", "\<\"\\\"RN212\\\"\"\>", ",", "\<\"\\\"RN213\\\"\"\>", 
     ",", "\<\"\\\"RN214\\\"\"\>", ",", "\<\"\\\"RN215\\\"\"\>", 
     ",", "\<\"\\\"RN216\\\"\"\>", ",", "\<\"\\\"RN217\\\"\"\>", 
     ",", "\<\"\\\"RN218\\\"\"\>", ",", "\<\"\\\"RN219\\\"\"\>", 
     ",", "\<\"\\\"RN220\\\"\"\>", ",", "\<\"\\\"RN221\\\"\"\>", 
     ",", "\<\"\\\"RN222\\\"\"\>", ",", "\<\"\\\"RN223\\\"\"\>", 
     ",", "\<\"\\\"RN224\\\"\"\>", ",", "\<\"\\\"RN225\\\"\"\>", 
     ",", "\<\"\\\"RN226\\\"\"\>", ",", "\<\"\\\"RN227\\\"\"\>", 
     ",", "\<\"\\\"RN228\\\"\"\>", ",", "\<\"\\\"FR\\\"\"\>", 
     ",", "\<\"\\\"FR199\\\"\"\>", ",", "\<\"\\\"FR200\\\"\"\>", 
     ",", "\<\"\\\"FR201\\\"\"\>", ",", "\<\"\\\"FR202\\\"\"\>", 
     ",", "\<\"\\\"FR203\\\"\"\>", ",", "\<\"\\\"FR204\\\"\"\>", 
     ",", "\<\"\\\"FR205\\\"\"\>", ",", "\<\"\\\"FR206\\\"\"\>", 
     ",", "\<\"\\\"FR207\\\"\"\>", ",", "\<\"\\\"FR208\\\"\"\>", 
     ",", "\<\"\\\"FR209\\\"\"\>", ",", "\<\"\\\"FR210\\\"\"\>", 
     ",", "\<\"\\\"FR211\\\"\"\>", ",", "\<\"\\\"FR212\\\"\"\>", 
     ",", "\<\"\\\"FR213\\\"\"\>", ",", "\<\"\\\"FR214\\\"\"\>", 
     ",", "\<\"\\\"FR215\\\"\"\>", ",", "\<\"\\\"FR216\\\"\"\>", 
     ",", "\<\"\\\"FR217\\\"\"\>", ",", "\<\"\\\"FR218\\\"\"\>", 
     ",", "\<\"\\\"FR219\\\"\"\>", ",", "\<\"\\\"FR220\\\"\"\>", 
     ",", "\<\"\\\"FR221\\\"\"\>", ",", "\<\"\\\"FR222\\\"\"\>", 
     ",", "\<\"\\\"FR223\\\"\"\>", ",", "\<\"\\\"FR224\\\"\"\>", 
     ",", "\<\"\\\"FR225\\\"\"\>", ",", "\<\"\\\"FR226\\\"\"\>", 
     ",", "\<\"\\\"FR227\\\"\"\>", ",", "\<\"\\\"FR228\\\"\"\>", 
     ",", "\<\"\\\"FR229\\\"\"\>", ",", "\<\"\\\"FR230\\\"\"\>", 
     ",", "\<\"\\\"FR231\\\"\"\>", ",", "\<\"\\\"FR232\\\"\"\>", 
     ",", "\<\"\\\"RA\\\"\"\>", ",", "\<\"\\\"RA202\\\"\"\>", 
     ",", "\<\"\\\"RA203\\\"\"\>", ",", "\<\"\\\"RA204\\\"\"\>", 
     ",", "\<\"\\\"RA205\\\"\"\>", ",", "\<\"\\\"RA206\\\"\"\>", 
     ",", "\<\"\\\"RA207\\\"\"\>", ",", "\<\"\\\"RA208\\\"\"\>", 
     ",", "\<\"\\\"RA209\\\"\"\>", ",", "\<\"\\\"RA210\\\"\"\>", 
     ",", "\<\"\\\"RA211\\\"\"\>", ",", "\<\"\\\"RA212\\\"\"\>", 
     ",", "\<\"\\\"RA213\\\"\"\>", ",", "\<\"\\\"RA214\\\"\"\>", 
     ",", "\<\"\\\"RA215\\\"\"\>", ",", "\<\"\\\"RA216\\\"\"\>", 
     ",", "\<\"\\\"RA217\\\"\"\>", ",", "\<\"\\\"RA218\\\"\"\>", 
     ",", "\<\"\\\"RA219\\\"\"\>", ",", "\<\"\\\"RA220\\\"\"\>", 
     ",", "\<\"\\\"RA221\\\"\"\>", ",", "\<\"\\\"RA222\\\"\"\>", 
     ",", "\<\"\\\"RA223\\\"\"\>", ",", "\<\"\\\"RA224\\\"\"\>", 
     ",", "\<\"\\\"RA225\\\"\"\>", ",", "\<\"\\\"RA226\\\"\"\>", 
     ",", "\<\"\\\"RA227\\\"\"\>", ",", "\<\"\\\"RA228\\\"\"\>", 
     ",", "\<\"\\\"RA229\\\"\"\>", ",", "\<\"\\\"RA230\\\"\"\>", 
     ",", "\<\"\\\"RA231\\\"\"\>", ",", "\<\"\\\"RA232\\\"\"\>", 
     ",", "\<\"\\\"RA233\\\"\"\>", ",", "\<\"\\\"RA234\\\"\"\>", 
     ",", "\<\"\\\"AC\\\"\"\>", ",", "\<\"\\\"AC206\\\"\"\>", 
     ",", "\<\"\\\"AC207\\\"\"\>", ",", "\<\"\\\"AC208\\\"\"\>", 
     ",", "\<\"\\\"AC209\\\"\"\>", ",", "\<\"\\\"AC210\\\"\"\>", 
     ",", "\<\"\\\"AC211\\\"\"\>", ",", "\<\"\\\"AC212\\\"\"\>", 
     ",", "\<\"\\\"AC213\\\"\"\>", ",", "\<\"\\\"AC214\\\"\"\>", 
     ",", "\<\"\\\"AC215\\\"\"\>", ",", "\<\"\\\"AC216\\\"\"\>", 
     ",", "\<\"\\\"AC217\\\"\"\>", ",", "\<\"\\\"AC218\\\"\"\>", 
     ",", "\<\"\\\"AC219\\\"\"\>", ",", "\<\"\\\"AC220\\\"\"\>", 
     ",", "\<\"\\\"AC221\\\"\"\>", ",", "\<\"\\\"AC222\\\"\"\>", 
     ",", "\<\"\\\"AC223\\\"\"\>", ",", "\<\"\\\"AC224\\\"\"\>", 
     ",", "\<\"\\\"AC225\\\"\"\>", ",", "\<\"\\\"AC226\\\"\"\>", 
     ",", "\<\"\\\"AC227\\\"\"\>", ",", "\<\"\\\"AC228\\\"\"\>", 
     ",", "\<\"\\\"AC229\\\"\"\>", ",", "\<\"\\\"AC230\\\"\"\>", 
     ",", "\<\"\\\"AC231\\\"\"\>", ",", "\<\"\\\"AC232\\\"\"\>", 
     ",", "\<\"\\\"AC233\\\"\"\>", ",", "\<\"\\\"AC234\\\"\"\>", 
     ",", "\<\"\\\"AC235\\\"\"\>", ",", "\<\"\\\"AC236\\\"\"\>", 
     ",", "\<\"\\\"TH\\\"\"\>", ",", "\<\"\\\"TH209\\\"\"\>", 
     ",", "\<\"\\\"TH210\\\"\"\>", ",", "\<\"\\\"TH211\\\"\"\>", 
     ",", "\<\"\\\"TH212\\\"\"\>", ",", "\<\"\\\"TH213\\\"\"\>", 
     ",", "\<\"\\\"TH214\\\"\"\>", ",", "\<\"\\\"TH215\\\"\"\>", 
     ",", "\<\"\\\"TH216\\\"\"\>", ",", "\<\"\\\"TH217\\\"\"\>", 
     ",", "\<\"\\\"TH218\\\"\"\>", ",", "\<\"\\\"TH219\\\"\"\>", 
     ",", "\<\"\\\"TH220\\\"\"\>", ",", "\<\"\\\"TH221\\\"\"\>", 
     ",", "\<\"\\\"TH222\\\"\"\>", ",", "\<\"\\\"TH223\\\"\"\>", 
     ",", "\<\"\\\"TH224\\\"\"\>", ",", "\<\"\\\"TH225\\\"\"\>", 
     ",", "\<\"\\\"TH226\\\"\"\>", ",", "\<\"\\\"TH227\\\"\"\>", 
     ",", "\<\"\\\"TH228\\\"\"\>", ",", "\<\"\\\"TH229\\\"\"\>", 
     ",", "\<\"\\\"TH230\\\"\"\>", ",", "\<\"\\\"TH231\\\"\"\>", 
     ",", "\<\"\\\"TH232\\\"\"\>", ",", "\<\"\\\"TH233\\\"\"\>", 
     ",", "\<\"\\\"TH234\\\"\"\>", ",", "\<\"\\\"TH235\\\"\"\>", 
     ",", "\<\"\\\"TH236\\\"\"\>", ",", "\<\"\\\"TH237\\\"\"\>", 
     ",", "\<\"\\\"TH238\\\"\"\>", ",", "\<\"\\\"PA\\\"\"\>", 
     ",", "\<\"\\\"PA212\\\"\"\>", ",", "\<\"\\\"PA213\\\"\"\>", 
     ",", "\<\"\\\"PA214\\\"\"\>", ",", "\<\"\\\"PA215\\\"\"\>", 
     ",", "\<\"\\\"PA216\\\"\"\>", ",", "\<\"\\\"PA217\\\"\"\>", 
     ",", "\<\"\\\"PA218\\\"\"\>", ",", "\<\"\\\"PA219\\\"\"\>", 
     ",", "\<\"\\\"PA220\\\"\"\>", ",", "\<\"\\\"PA221\\\"\"\>", 
     ",", "\<\"\\\"PA222\\\"\"\>", ",", "\<\"\\\"PA223\\\"\"\>", 
     ",", "\<\"\\\"PA224\\\"\"\>", ",", "\<\"\\\"PA225\\\"\"\>", 
     ",", "\<\"\\\"PA226\\\"\"\>", ",", "\<\"\\\"PA227\\\"\"\>", 
     ",", "\<\"\\\"PA228\\\"\"\>", ",", "\<\"\\\"PA229\\\"\"\>", 
     ",", "\<\"\\\"PA230\\\"\"\>", ",", "\<\"\\\"PA231\\\"\"\>", 
     ",", "\<\"\\\"PA232\\\"\"\>", ",", "\<\"\\\"PA233\\\"\"\>", 
     ",", "\<\"\\\"PA234\\\"\"\>", ",", "\<\"\\\"PA235\\\"\"\>", 
     ",", "\<\"\\\"PA236\\\"\"\>", ",", "\<\"\\\"PA237\\\"\"\>", 
     ",", "\<\"\\\"PA238\\\"\"\>", ",", "\<\"\\\"PA239\\\"\"\>", 
     ",", "\<\"\\\"PA240\\\"\"\>", ",", "\<\"\\\"U\\\"\"\>", 
     ",", "\<\"\\\"U217\\\"\"\>", ",", "\<\"\\\"U218\\\"\"\>", 
     ",", "\<\"\\\"U219\\\"\"\>", ",", "\<\"\\\"U220\\\"\"\>", 
     ",", "\<\"\\\"U221\\\"\"\>", ",", "\<\"\\\"U222\\\"\"\>", 
     ",", "\<\"\\\"U223\\\"\"\>", ",", "\<\"\\\"U224\\\"\"\>", 
     ",", "\<\"\\\"U225\\\"\"\>", ",", "\<\"\\\"U226\\\"\"\>", 
     ",", "\<\"\\\"U227\\\"\"\>", ",", "\<\"\\\"U228\\\"\"\>", 
     ",", "\<\"\\\"U229\\\"\"\>", ",", "\<\"\\\"U230\\\"\"\>", 
     ",", "\<\"\\\"U231\\\"\"\>", ",", "\<\"\\\"U232\\\"\"\>", 
     ",", "\<\"\\\"U233\\\"\"\>", ",", "\<\"\\\"U234\\\"\"\>", 
     ",", "\<\"\\\"U235\\\"\"\>", ",", "\<\"\\\"U236\\\"\"\>", 
     ",", "\<\"\\\"U237\\\"\"\>", ",", "\<\"\\\"U238\\\"\"\>", 
     ",", "\<\"\\\"U239\\\"\"\>", ",", "\<\"\\\"U240\\\"\"\>", 
     ",", "\<\"\\\"U241\\\"\"\>", ",", "\<\"\\\"U242\\\"\"\>", 
     ",", "\<\"\\\"NP\\\"\"\>", ",", "\<\"\\\"NP225\\\"\"\>", 
     ",", "\<\"\\\"NP226\\\"\"\>", ",", "\<\"\\\"NP227\\\"\"\>", 
     ",", "\<\"\\\"NP228\\\"\"\>", ",", "\<\"\\\"NP229\\\"\"\>", 
     ",", "\<\"\\\"NP230\\\"\"\>", ",", "\<\"\\\"NP231\\\"\"\>", 
     ",", "\<\"\\\"NP232\\\"\"\>", ",", "\<\"\\\"NP233\\\"\"\>", 
     ",", "\<\"\\\"NP234\\\"\"\>", ",", "\<\"\\\"NP235\\\"\"\>", 
     ",", "\<\"\\\"NP236\\\"\"\>", ",", "\<\"\\\"NP237\\\"\"\>", 
     ",", "\<\"\\\"NP238\\\"\"\>", ",", "\<\"\\\"NP239\\\"\"\>", 
     ",", "\<\"\\\"NP240\\\"\"\>", ",", "\<\"\\\"NP241\\\"\"\>", 
     ",", "\<\"\\\"NP242\\\"\"\>", ",", "\<\"\\\"NP243\\\"\"\>", 
     ",", "\<\"\\\"NP244\\\"\"\>", ",", "\<\"\\\"PU\\\"\"\>", 
     ",", "\<\"\\\"PU228\\\"\"\>", ",", "\<\"\\\"PU229\\\"\"\>", 
     ",", "\<\"\\\"PU230\\\"\"\>", ",", "\<\"\\\"PU231\\\"\"\>", 
     ",", "\<\"\\\"PU232\\\"\"\>", ",", "\<\"\\\"PU233\\\"\"\>", 
     ",", "\<\"\\\"PU234\\\"\"\>", ",", "\<\"\\\"PU235\\\"\"\>", 
     ",", "\<\"\\\"PU236\\\"\"\>", ",", "\<\"\\\"PU237\\\"\"\>", 
     ",", "\<\"\\\"PU238\\\"\"\>", ",", "\<\"\\\"PU239\\\"\"\>", 
     ",", "\<\"\\\"PU240\\\"\"\>", ",", "\<\"\\\"PU241\\\"\"\>", 
     ",", "\<\"\\\"PU242\\\"\"\>", ",", "\<\"\\\"PU243\\\"\"\>", 
     ",", "\<\"\\\"PU244\\\"\"\>", ",", "\<\"\\\"PU245\\\"\"\>", 
     ",", "\<\"\\\"PU246\\\"\"\>", ",", "\<\"\\\"PU247\\\"\"\>", 
     ",", "\<\"\\\"AM\\\"\"\>", ",", "\<\"\\\"AM231\\\"\"\>", 
     ",", "\<\"\\\"AM232\\\"\"\>", ",", "\<\"\\\"AM233\\\"\"\>", 
     ",", "\<\"\\\"AM234\\\"\"\>", ",", "\<\"\\\"AM235\\\"\"\>", 
     ",", "\<\"\\\"AM236\\\"\"\>", ",", "\<\"\\\"AM237\\\"\"\>", 
     ",", "\<\"\\\"AM238\\\"\"\>", ",", "\<\"\\\"AM239\\\"\"\>", 
     ",", "\<\"\\\"AM240\\\"\"\>", ",", "\<\"\\\"AM241\\\"\"\>", 
     ",", "\<\"\\\"AM242\\\"\"\>", ",", "\<\"\\\"AM243\\\"\"\>", 
     ",", "\<\"\\\"AM244\\\"\"\>", ",", "\<\"\\\"AM245\\\"\"\>", 
     ",", "\<\"\\\"AM246\\\"\"\>", ",", "\<\"\\\"AM247\\\"\"\>", 
     ",", "\<\"\\\"AM248\\\"\"\>", ",", "\<\"\\\"AM249\\\"\"\>", 
     ",", "\<\"\\\"CM\\\"\"\>", ",", "\<\"\\\"CM233\\\"\"\>", 
     ",", "\<\"\\\"CM234\\\"\"\>", ",", "\<\"\\\"CM235\\\"\"\>", 
     ",", "\<\"\\\"CM236\\\"\"\>", ",", "\<\"\\\"CM237\\\"\"\>", 
     ",", "\<\"\\\"CM238\\\"\"\>", ",", "\<\"\\\"CM239\\\"\"\>", 
     ",", "\<\"\\\"CM240\\\"\"\>", ",", "\<\"\\\"CM241\\\"\"\>", 
     ",", "\<\"\\\"CM242\\\"\"\>", ",", "\<\"\\\"CM243\\\"\"\>", 
     ",", "\<\"\\\"CM244\\\"\"\>", ",", "\<\"\\\"CM245\\\"\"\>", 
     ",", "\<\"\\\"CM246\\\"\"\>", ",", "\<\"\\\"CM247\\\"\"\>", 
     ",", "\<\"\\\"CM248\\\"\"\>", ",", "\<\"\\\"CM249\\\"\"\>", 
     ",", "\<\"\\\"CM250\\\"\"\>", ",", "\<\"\\\"CM251\\\"\"\>", 
     ",", "\<\"\\\"CM252\\\"\"\>", ",", "\<\"\\\"BK\\\"\"\>", 
     ",", "\<\"\\\"BK235\\\"\"\>", ",", "\<\"\\\"BK236\\\"\"\>", 
     ",", "\<\"\\\"BK237\\\"\"\>", ",", "\<\"\\\"BK238\\\"\"\>", 
     ",", "\<\"\\\"BK239\\\"\"\>", ",", "\<\"\\\"BK240\\\"\"\>", 
     ",", "\<\"\\\"BK241\\\"\"\>", ",", "\<\"\\\"BK242\\\"\"\>", 
     ",", "\<\"\\\"BK243\\\"\"\>", ",", "\<\"\\\"BK244\\\"\"\>", 
     ",", "\<\"\\\"BK245\\\"\"\>", ",", "\<\"\\\"BK246\\\"\"\>", 
     ",", "\<\"\\\"BK247\\\"\"\>", ",", "\<\"\\\"BK248\\\"\"\>", 
     ",", "\<\"\\\"BK249\\\"\"\>", ",", "\<\"\\\"BK250\\\"\"\>", 
     ",", "\<\"\\\"BK251\\\"\"\>", ",", "\<\"\\\"BK252\\\"\"\>", 
     ",", "\<\"\\\"BK253\\\"\"\>", ",", "\<\"\\\"BK254\\\"\"\>", 
     ",", "\<\"\\\"CF\\\"\"\>", ",", "\<\"\\\"CF237\\\"\"\>", 
     ",", "\<\"\\\"CF238\\\"\"\>", ",", "\<\"\\\"CF239\\\"\"\>", 
     ",", "\<\"\\\"CF240\\\"\"\>", ",", "\<\"\\\"CF241\\\"\"\>", 
     ",", "\<\"\\\"CF242\\\"\"\>", ",", "\<\"\\\"CF243\\\"\"\>", 
     ",", "\<\"\\\"CF244\\\"\"\>", ",", "\<\"\\\"CF245\\\"\"\>", 
     ",", "\<\"\\\"CF246\\\"\"\>", ",", "\<\"\\\"CF247\\\"\"\>", 
     ",", "\<\"\\\"CF248\\\"\"\>", ",", "\<\"\\\"CF249\\\"\"\>", 
     ",", "\<\"\\\"CF250\\\"\"\>", ",", "\<\"\\\"CF251\\\"\"\>", 
     ",", "\<\"\\\"CF252\\\"\"\>", ",", "\<\"\\\"CF253\\\"\"\>", 
     ",", "\<\"\\\"CF254\\\"\"\>", ",", "\<\"\\\"CF255\\\"\"\>", 
     ",", "\<\"\\\"CF256\\\"\"\>", ",", "\<\"\\\"ES\\\"\"\>", 
     ",", "\<\"\\\"ES240\\\"\"\>", ",", "\<\"\\\"ES241\\\"\"\>", 
     ",", "\<\"\\\"ES242\\\"\"\>", ",", "\<\"\\\"ES243\\\"\"\>", 
     ",", "\<\"\\\"ES244\\\"\"\>", ",", "\<\"\\\"ES245\\\"\"\>", 
     ",", "\<\"\\\"ES246\\\"\"\>", ",", "\<\"\\\"ES247\\\"\"\>", 
     ",", "\<\"\\\"ES248\\\"\"\>", ",", "\<\"\\\"ES249\\\"\"\>", 
     ",", "\<\"\\\"ES250\\\"\"\>", ",", "\<\"\\\"ES251\\\"\"\>", 
     ",", "\<\"\\\"ES252\\\"\"\>", ",", "\<\"\\\"ES253\\\"\"\>", 
     ",", "\<\"\\\"ES254\\\"\"\>", ",", "\<\"\\\"ES255\\\"\"\>", 
     ",", "\<\"\\\"ES256\\\"\"\>", ",", "\<\"\\\"ES257\\\"\"\>", 
     ",", "\<\"\\\"ES258\\\"\"\>", ",", "\<\"\\\"FM\\\"\"\>", 
     ",", "\<\"\\\"FM242\\\"\"\>", ",", "\<\"\\\"FM243\\\"\"\>", 
     ",", "\<\"\\\"FM244\\\"\"\>", ",", "\<\"\\\"FM245\\\"\"\>", 
     ",", "\<\"\\\"FM246\\\"\"\>", ",", "\<\"\\\"FM247\\\"\"\>", 
     ",", "\<\"\\\"FM248\\\"\"\>", ",", "\<\"\\\"FM249\\\"\"\>", 
     ",", "\<\"\\\"FM250\\\"\"\>", ",", "\<\"\\\"FM251\\\"\"\>", 
     ",", "\<\"\\\"FM252\\\"\"\>", ",", "\<\"\\\"FM253\\\"\"\>", 
     ",", "\<\"\\\"FM254\\\"\"\>", ",", "\<\"\\\"FM255\\\"\"\>", 
     ",", "\<\"\\\"FM256\\\"\"\>", ",", "\<\"\\\"FM257\\\"\"\>", 
     ",", "\<\"\\\"FM258\\\"\"\>", ",", "\<\"\\\"FM259\\\"\"\>", 
     ",", "\<\"\\\"FM260\\\"\"\>", ",", "\<\"\\\"MD\\\"\"\>", 
     ",", "\<\"\\\"MD245\\\"\"\>", ",", "\<\"\\\"MD246\\\"\"\>", 
     ",", "\<\"\\\"MD247\\\"\"\>", ",", "\<\"\\\"MD248\\\"\"\>", 
     ",", "\<\"\\\"MD249\\\"\"\>", ",", "\<\"\\\"MD250\\\"\"\>", 
     ",", "\<\"\\\"MD251\\\"\"\>", ",", "\<\"\\\"MD252\\\"\"\>", 
     ",", "\<\"\\\"MD253\\\"\"\>", ",", "\<\"\\\"MD254\\\"\"\>", 
     ",", "\<\"\\\"MD255\\\"\"\>", ",", "\<\"\\\"MD256\\\"\"\>", 
     ",", "\<\"\\\"MD257\\\"\"\>", ",", "\<\"\\\"MD258\\\"\"\>", 
     ",", "\<\"\\\"MD259\\\"\"\>", ",", "\<\"\\\"MD260\\\"\"\>", 
     ",", "\<\"\\\"MD261\\\"\"\>", ",", "\<\"\\\"MD262\\\"\"\>", 
     ",", "\<\"\\\"NO\\\"\"\>", ",", "\<\"\\\"NO248\\\"\"\>", 
     ",", "\<\"\\\"NO249\\\"\"\>", ",", "\<\"\\\"NO250\\\"\"\>", 
     ",", "\<\"\\\"NO251\\\"\"\>", ",", "\<\"\\\"NO252\\\"\"\>", 
     ",", "\<\"\\\"NO253\\\"\"\>", ",", "\<\"\\\"NO254\\\"\"\>", 
     ",", "\<\"\\\"NO255\\\"\"\>", ",", "\<\"\\\"NO256\\\"\"\>", 
     ",", "\<\"\\\"NO257\\\"\"\>", ",", "\<\"\\\"NO258\\\"\"\>", 
     ",", "\<\"\\\"NO259\\\"\"\>", ",", "\<\"\\\"NO260\\\"\"\>", 
     ",", "\<\"\\\"NO261\\\"\"\>", ",", "\<\"\\\"NO262\\\"\"\>", 
     ",", "\<\"\\\"NO263\\\"\"\>", ",", "\<\"\\\"NO264\\\"\"\>", 
     ",", "\<\"\\\"LR\\\"\"\>", ",", "\<\"\\\"LR251\\\"\"\>", 
     ",", "\<\"\\\"LR252\\\"\"\>", ",", "\<\"\\\"LR253\\\"\"\>", 
     ",", "\<\"\\\"LR254\\\"\"\>", ",", "\<\"\\\"LR255\\\"\"\>", 
     ",", "\<\"\\\"LR256\\\"\"\>", ",", "\<\"\\\"LR257\\\"\"\>", 
     ",", "\<\"\\\"LR258\\\"\"\>", ",", "\<\"\\\"LR259\\\"\"\>", 
     ",", "\<\"\\\"LR260\\\"\"\>", ",", "\<\"\\\"LR261\\\"\"\>", 
     ",", "\<\"\\\"LR262\\\"\"\>", ",", "\<\"\\\"LR263\\\"\"\>", 
     ",", "\<\"\\\"LR264\\\"\"\>", ",", "\<\"\\\"LR265\\\"\"\>", 
     ",", "\<\"\\\"LR266\\\"\"\>", ",", "\<\"\\\"RF\\\"\"\>", 
     ",", "\<\"\\\"RF253\\\"\"\>", ",", "\<\"\\\"RF254\\\"\"\>", 
     ",", "\<\"\\\"RF255\\\"\"\>", ",", "\<\"\\\"RF256\\\"\"\>", 
     ",", "\<\"\\\"RF257\\\"\"\>", ",", "\<\"\\\"RF258\\\"\"\>", 
     ",", "\<\"\\\"RF259\\\"\"\>", ",", "\<\"\\\"RF260\\\"\"\>", 
     ",", "\<\"\\\"RF261\\\"\"\>", ",", "\<\"\\\"RF262\\\"\"\>", 
     ",", "\<\"\\\"RF263\\\"\"\>", ",", "\<\"\\\"RF264\\\"\"\>", 
     ",", "\<\"\\\"RF265\\\"\"\>", ",", "\<\"\\\"RF266\\\"\"\>", 
     ",", "\<\"\\\"RF267\\\"\"\>", ",", "\<\"\\\"RF268\\\"\"\>", 
     ",", "\<\"\\\"DB\\\"\"\>", ",", "\<\"\\\"DB255\\\"\"\>", 
     ",", "\<\"\\\"DB256\\\"\"\>", ",", "\<\"\\\"DB257\\\"\"\>", 
     ",", "\<\"\\\"DB258\\\"\"\>", ",", "\<\"\\\"DB259\\\"\"\>", 
     ",", "\<\"\\\"DB260\\\"\"\>", ",", "\<\"\\\"DB261\\\"\"\>", 
     ",", "\<\"\\\"DB262\\\"\"\>", ",", "\<\"\\\"DB263\\\"\"\>", 
     ",", "\<\"\\\"DB264\\\"\"\>", ",", "\<\"\\\"DB265\\\"\"\>", 
     ",", "\<\"\\\"DB266\\\"\"\>", ",", "\<\"\\\"DB267\\\"\"\>", 
     ",", "\<\"\\\"DB268\\\"\"\>", ",", "\<\"\\\"DB269\\\"\"\>", 
     ",", "\<\"\\\"DB270\\\"\"\>", ",", "\<\"\\\"SG\\\"\"\>", 
     ",", "\<\"\\\"SG258\\\"\"\>", ",", "\<\"\\\"SG259\\\"\"\>", 
     ",", "\<\"\\\"SG260\\\"\"\>", ",", "\<\"\\\"SG261\\\"\"\>", 
     ",", "\<\"\\\"SG262\\\"\"\>", ",", "\<\"\\\"SG263\\\"\"\>", 
     ",", "\<\"\\\"SG264\\\"\"\>", ",", "\<\"\\\"SG265\\\"\"\>", 
     ",", "\<\"\\\"SG266\\\"\"\>", ",", "\<\"\\\"SG267\\\"\"\>", 
     ",", "\<\"\\\"SG268\\\"\"\>", ",", "\<\"\\\"SG269\\\"\"\>", 
     ",", "\<\"\\\"SG270\\\"\"\>", ",", "\<\"\\\"SG271\\\"\"\>", 
     ",", "\<\"\\\"SG272\\\"\"\>", ",", "\<\"\\\"SG273\\\"\"\>", 
     ",", "\<\"\\\"BH\\\"\"\>", ",", "\<\"\\\"BH260\\\"\"\>", 
     ",", "\<\"\\\"BH261\\\"\"\>", ",", "\<\"\\\"BH262\\\"\"\>", 
     ",", "\<\"\\\"BH263\\\"\"\>", ",", "\<\"\\\"BH264\\\"\"\>", 
     ",", "\<\"\\\"BH265\\\"\"\>", ",", "\<\"\\\"BH266\\\"\"\>", 
     ",", "\<\"\\\"BH267\\\"\"\>", ",", "\<\"\\\"BH268\\\"\"\>", 
     ",", "\<\"\\\"BH269\\\"\"\>", ",", "\<\"\\\"BH270\\\"\"\>", 
     ",", "\<\"\\\"BH271\\\"\"\>", ",", "\<\"\\\"BH272\\\"\"\>", 
     ",", "\<\"\\\"BH273\\\"\"\>", ",", "\<\"\\\"BH274\\\"\"\>", 
     ",", "\<\"\\\"BH275\\\"\"\>", ",", "\<\"\\\"HS\\\"\"\>", 
     ",", "\<\"\\\"HS263\\\"\"\>", ",", "\<\"\\\"HS264\\\"\"\>", 
     ",", "\<\"\\\"HS265\\\"\"\>", ",", "\<\"\\\"HS266\\\"\"\>", 
     ",", "\<\"\\\"HS267\\\"\"\>", ",", "\<\"\\\"HS268\\\"\"\>", 
     ",", "\<\"\\\"HS269\\\"\"\>", ",", "\<\"\\\"HS270\\\"\"\>", 
     ",", "\<\"\\\"HS271\\\"\"\>", ",", "\<\"\\\"HS272\\\"\"\>", 
     ",", "\<\"\\\"HS273\\\"\"\>", ",", "\<\"\\\"HS274\\\"\"\>", 
     ",", "\<\"\\\"HS275\\\"\"\>", ",", "\<\"\\\"HS276\\\"\"\>", 
     ",", "\<\"\\\"HS277\\\"\"\>", ",", "\<\"\\\"MT\\\"\"\>", 
     ",", "\<\"\\\"MT265\\\"\"\>", ",", "\<\"\\\"MT266\\\"\"\>", 
     ",", "\<\"\\\"MT267\\\"\"\>", ",", "\<\"\\\"MT268\\\"\"\>", 
     ",", "\<\"\\\"MT269\\\"\"\>", ",", "\<\"\\\"MT270\\\"\"\>", 
     ",", "\<\"\\\"MT271\\\"\"\>", ",", "\<\"\\\"MT272\\\"\"\>", 
     ",", "\<\"\\\"MT273\\\"\"\>", ",", "\<\"\\\"MT274\\\"\"\>", 
     ",", "\<\"\\\"MT275\\\"\"\>", ",", "\<\"\\\"MT276\\\"\"\>", 
     ",", "\<\"\\\"MT277\\\"\"\>", ",", "\<\"\\\"MT278\\\"\"\>", 
     ",", "\<\"\\\"MT279\\\"\"\>", ",", "\<\"\\\"DS\\\"\"\>", 
     ",", "\<\"\\\"DS267\\\"\"\>", ",", "\<\"\\\"DS268\\\"\"\>", 
     ",", "\<\"\\\"DS269\\\"\"\>", ",", "\<\"\\\"DS270\\\"\"\>", 
     ",", "\<\"\\\"DS271\\\"\"\>", ",", "\<\"\\\"DS272\\\"\"\>", 
     ",", "\<\"\\\"DS273\\\"\"\>", ",", "\<\"\\\"DS274\\\"\"\>", 
     ",", "\<\"\\\"DS275\\\"\"\>", ",", "\<\"\\\"DS276\\\"\"\>", 
     ",", "\<\"\\\"DS277\\\"\"\>", ",", "\<\"\\\"DS278\\\"\"\>", 
     ",", "\<\"\\\"DS279\\\"\"\>", ",", "\<\"\\\"DS280\\\"\"\>", 
     ",", "\<\"\\\"DS281\\\"\"\>", ",", "\<\"\\\"RG\\\"\"\>", 
     ",", "\<\"\\\"RG272\\\"\"\>", ",", "\<\"\\\"RG273\\\"\"\>", 
     ",", "\<\"\\\"RG274\\\"\"\>", ",", "\<\"\\\"RG275\\\"\"\>", 
     ",", "\<\"\\\"RG276\\\"\"\>", ",", "\<\"\\\"RG277\\\"\"\>", 
     ",", "\<\"\\\"RG278\\\"\"\>", ",", "\<\"\\\"RG279\\\"\"\>", 
     ",", "\<\"\\\"RG280\\\"\"\>", ",", "\<\"\\\"RG281\\\"\"\>", 
     ",", "\<\"\\\"RG282\\\"\"\>", ",", "\<\"\\\"RG283\\\"\"\>", 
     ",", "\<\"\\\"UUB\\\"\"\>", ",", "\<\"\\\"UUB277\\\"\"\>", 
     ",", "\<\"\\\"UUB278\\\"\"\>", ",", "\<\"\\\"UUB279\\\"\"\>", 
     ",", "\<\"\\\"UUB280\\\"\"\>", ",", "\<\"\\\"UUB281\\\"\"\>", 
     ",", "\<\"\\\"UUB282\\\"\"\>", ",", "\<\"\\\"UUB283\\\"\"\>", 
     ",", "\<\"\\\"UUB284\\\"\"\>", ",", "\<\"\\\"UUB285\\\"\"\>", 
     ",", "\<\"\\\"UUT\\\"\"\>", ",", "\<\"\\\"UUT283\\\"\"\>", 
     ",", "\<\"\\\"UUT284\\\"\"\>", ",", "\<\"\\\"UUT285\\\"\"\>", 
     ",", "\<\"\\\"UUT286\\\"\"\>", ",", "\<\"\\\"UUT287\\\"\"\>", 
     ",", "\<\"\\\"UUQ\\\"\"\>", ",", "\<\"\\\"UUQ285\\\"\"\>", 
     ",", "\<\"\\\"UUQ286\\\"\"\>", ",", "\<\"\\\"UUQ287\\\"\"\>", 
     ",", "\<\"\\\"UUQ288\\\"\"\>", ",", "\<\"\\\"UUQ289\\\"\"\>", 
     ",", "\<\"\\\"UUP\\\"\"\>", ",", "\<\"\\\"UUP287\\\"\"\>", 
     ",", "\<\"\\\"UUP288\\\"\"\>", ",", "\<\"\\\"UUP289\\\"\"\>", 
     ",", "\<\"\\\"UUP290\\\"\"\>", ",", "\<\"\\\"UUP291\\\"\"\>", 
     ",", "\<\"\\\"UUH\\\"\"\>", ",", "\<\"\\\"UUH289\\\"\"\>", 
     ",", "\<\"\\\"UUH290\\\"\"\>", ",", "\<\"\\\"UUH291\\\"\"\>", 
     ",", "\<\"\\\"UUH292\\\"\"\>", ",", "\<\"\\\"UUS\\\"\"\>", 
     ",", "\<\"\\\"UUS291\\\"\"\>", ",", "\<\"\\\"UUS292\\\"\"\>", 
     ",", "\<\"\\\"UUO\\\"\"\>", ",", "\<\"\\\"UUO293\\\"\"\>"}], "}"}]}],
  SequenceForm[
  "static const char *mass_labels[] =", {
   "\"H\"", "\"H1\"", "\"H2\"", "\"D\"", "\"H3\"", "\"T\"", "\"H4\"", 
    "\"H5\"", "\"H6\"", "\"H7\"", "\"HE\"", "\"HE3\"", "\"HE4\"", "\"HE5\"", 
    "\"HE6\"", "\"HE7\"", "\"HE8\"", "\"HE9\"", "\"HE10\"", "\"LI\"", 
    "\"LI3\"", "\"LI4\"", "\"LI5\"", "\"LI6\"", "\"LI7\"", "\"LI8\"", 
    "\"LI9\"", "\"LI10\"", "\"LI11\"", "\"LI12\"", "\"BE\"", "\"BE5\"", 
    "\"BE6\"", "\"BE7\"", "\"BE8\"", "\"BE9\"", "\"BE10\"", "\"BE11\"", 
    "\"BE12\"", "\"BE13\"", "\"BE14\"", "\"BE15\"", "\"BE16\"", "\"B\"", 
    "\"B6\"", "\"B7\"", "\"B8\"", "\"B9\"", "\"B10\"", "\"B11\"", "\"B12\"", 
    "\"B13\"", "\"B14\"", "\"B15\"", "\"B16\"", "\"B17\"", "\"B18\"", 
    "\"B19\"", "\"C\"", "\"C8\"", "\"C9\"", "\"C10\"", "\"C11\"", "\"C12\"", 
    "\"C13\"", "\"C14\"", "\"C15\"", "\"C16\"", "\"C17\"", "\"C18\"", 
    "\"C19\"", "\"C20\"", "\"C21\"", "\"C22\"", "\"N\"", "\"N10\"", "\"N11\"",
     "\"N12\"", "\"N13\"", "\"N14\"", "\"N15\"", "\"N16\"", "\"N17\"", 
    "\"N18\"", "\"N19\"", "\"N20\"", "\"N21\"", "\"N22\"", "\"N23\"", 
    "\"N24\"", "\"N25\"", "\"O\"", "\"O12\"", "\"O13\"", "\"O14\"", "\"O15\"",
     "\"O16\"", "\"O17\"", "\"O18\"", "\"O19\"", "\"O20\"", "\"O21\"", 
    "\"O22\"", "\"O23\"", "\"O24\"", "\"O25\"", "\"O26\"", "\"O27\"", 
    "\"O28\"", "\"F\"", "\"F14\"", "\"F15\"", "\"F16\"", "\"F17\"", "\"F18\"",
     "\"F19\"", "\"F20\"", "\"F21\"", "\"F22\"", "\"F23\"", "\"F24\"", 
    "\"F25\"", "\"F26\"", "\"F27\"", "\"F28\"", "\"F29\"", "\"F30\"", 
    "\"F31\"", "\"NE\"", "\"NE16\"", "\"NE17\"", "\"NE18\"", "\"NE19\"", 
    "\"NE20\"", "\"NE21\"", "\"NE22\"", "\"NE23\"", "\"NE24\"", "\"NE25\"", 
    "\"NE26\"", "\"NE27\"", "\"NE28\"", "\"NE29\"", "\"NE30\"", "\"NE31\"", 
    "\"NE32\"", "\"NE33\"", "\"NE34\"", "\"NA\"", "\"NA18\"", "\"NA19\"", 
    "\"NA20\"", "\"NA21\"", "\"NA22\"", "\"NA23\"", "\"NA24\"", "\"NA25\"", 
    "\"NA26\"", "\"NA27\"", "\"NA28\"", "\"NA29\"", "\"NA30\"", "\"NA31\"", 
    "\"NA32\"", "\"NA33\"", "\"NA34\"", "\"NA35\"", "\"NA36\"", "\"NA37\"", 
    "\"MG\"", "\"MG19\"", "\"MG20\"", "\"MG21\"", "\"MG22\"", "\"MG23\"", 
    "\"MG24\"", "\"MG25\"", "\"MG26\"", "\"MG27\"", "\"MG28\"", "\"MG29\"", 
    "\"MG30\"", "\"MG31\"", "\"MG32\"", "\"MG33\"", "\"MG34\"", "\"MG35\"", 
    "\"MG36\"", "\"MG37\"", "\"MG38\"", "\"MG39\"", "\"MG40\"", "\"AL\"", 
    "\"AL21\"", "\"AL22\"", "\"AL23\"", "\"AL24\"", "\"AL25\"", "\"AL26\"", 
    "\"AL27\"", "\"AL28\"", "\"AL29\"", "\"AL30\"", "\"AL31\"", "\"AL32\"", 
    "\"AL33\"", "\"AL34\"", "\"AL35\"", "\"AL36\"", "\"AL37\"", "\"AL38\"", 
    "\"AL39\"", "\"AL40\"", "\"AL41\"", "\"AL42\"", "\"SI\"", "\"SI22\"", 
    "\"SI23\"", "\"SI24\"", "\"SI25\"", "\"SI26\"", "\"SI27\"", "\"SI28\"", 
    "\"SI29\"", "\"SI30\"", "\"SI31\"", "\"SI32\"", "\"SI33\"", "\"SI34\"", 
    "\"SI35\"", "\"SI36\"", "\"SI37\"", "\"SI38\"", "\"SI39\"", "\"SI40\"", 
    "\"SI41\"", "\"SI42\"", "\"SI43\"", "\"SI44\"", "\"P\"", "\"P24\"", 
    "\"P25\"", "\"P26\"", "\"P27\"", "\"P28\"", "\"P29\"", "\"P30\"", 
    "\"P31\"", "\"P32\"", "\"P33\"", "\"P34\"", "\"P35\"", "\"P36\"", 
    "\"P37\"", "\"P38\"", "\"P39\"", "\"P40\"", "\"P41\"", "\"P42\"", 
    "\"P43\"", "\"P44\"", "\"P45\"", "\"P46\"", "\"S\"", "\"S26\"", "\"S27\"",
     "\"S28\"", "\"S29\"", "\"S30\"", "\"S31\"", "\"S32\"", "\"S33\"", 
    "\"S34\"", "\"S35\"", "\"S36\"", "\"S37\"", "\"S38\"", "\"S39\"", 
    "\"S40\"", "\"S41\"", "\"S42\"", "\"S43\"", "\"S44\"", "\"S45\"", 
    "\"S46\"", "\"S47\"", "\"S48\"", "\"S49\"", "\"CL\"", "\"CL28\"", 
    "\"CL29\"", "\"CL30\"", "\"CL31\"", "\"CL32\"", "\"CL33\"", "\"CL34\"", 
    "\"CL35\"", "\"CL36\"", "\"CL37\"", "\"CL38\"", "\"CL39\"", "\"CL40\"", 
    "\"CL41\"", "\"CL42\"", "\"CL43\"", "\"CL44\"", "\"CL45\"", "\"CL46\"", 
    "\"CL47\"", "\"CL48\"", "\"CL49\"", "\"CL50\"", "\"CL51\"", "\"AR\"", 
    "\"AR30\"", "\"AR31\"", "\"AR32\"", "\"AR33\"", "\"AR34\"", "\"AR35\"", 
    "\"AR36\"", "\"AR37\"", "\"AR38\"", "\"AR39\"", "\"AR40\"", "\"AR41\"", 
    "\"AR42\"", "\"AR43\"", "\"AR44\"", "\"AR45\"", "\"AR46\"", "\"AR47\"", 
    "\"AR48\"", "\"AR49\"", "\"AR50\"", "\"AR51\"", "\"AR52\"", "\"AR53\"", 
    "\"K\"", "\"K32\"", "\"K33\"", "\"K34\"", "\"K35\"", "\"K36\"", "\"K37\"",
     "\"K38\"", "\"K39\"", "\"K40\"", "\"K41\"", "\"K42\"", "\"K43\"", 
    "\"K44\"", "\"K45\"", "\"K46\"", "\"K47\"", "\"K48\"", "\"K49\"", 
    "\"K50\"", "\"K51\"", "\"K52\"", "\"K53\"", "\"K54\"", "\"K55\"", 
    "\"CA\"", "\"CA34\"", "\"CA35\"", "\"CA36\"", "\"CA37\"", "\"CA38\"", 
    "\"CA39\"", "\"CA40\"", "\"CA41\"", "\"CA42\"", "\"CA43\"", "\"CA44\"", 
    "\"CA45\"", "\"CA46\"", "\"CA47\"", "\"CA48\"", "\"CA49\"", "\"CA50\"", 
    "\"CA51\"", "\"CA52\"", "\"CA53\"", "\"CA54\"", "\"CA55\"", "\"CA56\"", 
    "\"CA57\"", "\"SC\"", "\"SC36\"", "\"SC37\"", "\"SC38\"", "\"SC39\"", 
    "\"SC40\"", "\"SC41\"", "\"SC42\"", "\"SC43\"", "\"SC44\"", "\"SC45\"", 
    "\"SC46\"", "\"SC47\"", "\"SC48\"", "\"SC49\"", "\"SC50\"", "\"SC51\"", 
    "\"SC52\"", "\"SC53\"", "\"SC54\"", "\"SC55\"", "\"SC56\"", "\"SC57\"", 
    "\"SC58\"", "\"SC59\"", "\"SC60\"", "\"TI\"", "\"TI38\"", "\"TI39\"", 
    "\"TI40\"", "\"TI41\"", "\"TI42\"", "\"TI43\"", "\"TI44\"", "\"TI45\"", 
    "\"TI46\"", "\"TI47\"", "\"TI48\"", "\"TI49\"", "\"TI50\"", "\"TI51\"", 
    "\"TI52\"", "\"TI53\"", "\"TI54\"", "\"TI55\"", "\"TI56\"", "\"TI57\"", 
    "\"TI58\"", "\"TI59\"", "\"TI60\"", "\"TI61\"", "\"TI62\"", "\"TI63\"", 
    "\"V\"", "\"V40\"", "\"V41\"", "\"V42\"", "\"V43\"", "\"V44\"", "\"V45\"",
     "\"V46\"", "\"V47\"", "\"V48\"", "\"V49\"", "\"V50\"", "\"V51\"", 
    "\"V52\"", "\"V53\"", "\"V54\"", "\"V55\"", "\"V56\"", "\"V57\"", 
    "\"V58\"", "\"V59\"", "\"V60\"", "\"V61\"", "\"V62\"", "\"V63\"", 
    "\"V64\"", "\"V65\"", "\"CR\"", "\"CR42\"", "\"CR43\"", "\"CR44\"", 
    "\"CR45\"", "\"CR46\"", "\"CR47\"", "\"CR48\"", "\"CR49\"", "\"CR50\"", 
    "\"CR51\"", "\"CR52\"", "\"CR53\"", "\"CR54\"", "\"CR55\"", "\"CR56\"", 
    "\"CR57\"", "\"CR58\"", "\"CR59\"", "\"CR60\"", "\"CR61\"", "\"CR62\"", 
    "\"CR63\"", "\"CR64\"", "\"CR65\"", "\"CR66\"", "\"CR67\"", "\"MN\"", 
    "\"MN44\"", "\"MN45\"", "\"MN46\"", "\"MN47\"", "\"MN48\"", "\"MN49\"", 
    "\"MN50\"", "\"MN51\"", "\"MN52\"", "\"MN53\"", "\"MN54\"", "\"MN55\"", 
    "\"MN56\"", "\"MN57\"", "\"MN58\"", "\"MN59\"", "\"MN60\"", "\"MN61\"", 
    "\"MN62\"", "\"MN63\"", "\"MN64\"", "\"MN65\"", "\"MN66\"", "\"MN67\"", 
    "\"MN68\"", "\"MN69\"", "\"FE\"", "\"FE45\"", "\"FE46\"", "\"FE47\"", 
    "\"FE48\"", "\"FE49\"", "\"FE50\"", "\"FE51\"", "\"FE52\"", "\"FE53\"", 
    "\"FE54\"", "\"FE55\"", "\"FE56\"", "\"FE57\"", "\"FE58\"", "\"FE59\"", 
    "\"FE60\"", "\"FE61\"", "\"FE62\"", "\"FE63\"", "\"FE64\"", "\"FE65\"", 
    "\"FE66\"", "\"FE67\"", "\"FE68\"", "\"FE69\"", "\"FE70\"", "\"FE71\"", 
    "\"FE72\"", "\"CO\"", "\"CO47\"", "\"CO48\"", "\"CO49\"", "\"CO50\"", 
    "\"CO51\"", "\"CO52\"", "\"CO53\"", "\"CO54\"", "\"CO55\"", "\"CO56\"", 
    "\"CO57\"", "\"CO58\"", "\"CO59\"", "\"CO60\"", "\"CO61\"", "\"CO62\"", 
    "\"CO63\"", "\"CO64\"", "\"CO65\"", "\"CO66\"", "\"CO67\"", "\"CO68\"", 
    "\"CO69\"", "\"CO70\"", "\"CO71\"", "\"CO72\"", "\"CO73\"", "\"CO74\"", 
    "\"CO75\"", "\"NI\"", "\"NI48\"", "\"NI49\"", "\"NI50\"", "\"NI51\"", 
    "\"NI52\"", "\"NI53\"", "\"NI54\"", "\"NI55\"", "\"NI56\"", "\"NI57\"", 
    "\"NI58\"", "\"NI59\"", "\"NI60\"", "\"NI61\"", "\"NI62\"", "\"NI63\"", 
    "\"NI64\"", "\"NI65\"", "\"NI66\"", "\"NI67\"", "\"NI68\"", "\"NI69\"", 
    "\"NI70\"", "\"NI71\"", "\"NI72\"", "\"NI73\"", "\"NI74\"", "\"NI75\"", 
    "\"NI76\"", "\"NI77\"", "\"NI78\"", "\"CU\"", "\"CU52\"", "\"CU53\"", 
    "\"CU54\"", "\"CU55\"", "\"CU56\"", "\"CU57\"", "\"CU58\"", "\"CU59\"", 
    "\"CU60\"", "\"CU61\"", "\"CU62\"", "\"CU63\"", "\"CU64\"", "\"CU65\"", 
    "\"CU66\"", "\"CU67\"", "\"CU68\"", "\"CU69\"", "\"CU70\"", "\"CU71\"", 
    "\"CU72\"", "\"CU73\"", "\"CU74\"", "\"CU75\"", "\"CU76\"", "\"CU77\"", 
    "\"CU78\"", "\"CU79\"", "\"CU80\"", "\"ZN\"", "\"ZN54\"", "\"ZN55\"", 
    "\"ZN56\"", "\"ZN57\"", "\"ZN58\"", "\"ZN59\"", "\"ZN60\"", "\"ZN61\"", 
    "\"ZN62\"", "\"ZN63\"", "\"ZN64\"", "\"ZN65\"", "\"ZN66\"", "\"ZN67\"", 
    "\"ZN68\"", "\"ZN69\"", "\"ZN70\"", "\"ZN71\"", "\"ZN72\"", "\"ZN73\"", 
    "\"ZN74\"", "\"ZN75\"", "\"ZN76\"", "\"ZN77\"", "\"ZN78\"", "\"ZN79\"", 
    "\"ZN80\"", "\"ZN81\"", "\"ZN82\"", "\"ZN83\"", "\"GA\"", "\"GA56\"", 
    "\"GA57\"", "\"GA58\"", "\"GA59\"", "\"GA60\"", "\"GA61\"", "\"GA62\"", 
    "\"GA63\"", "\"GA64\"", "\"GA65\"", "\"GA66\"", "\"GA67\"", "\"GA68\"", 
    "\"GA69\"", "\"GA70\"", "\"GA71\"", "\"GA72\"", "\"GA73\"", "\"GA74\"", 
    "\"GA75\"", "\"GA76\"", "\"GA77\"", "\"GA78\"", "\"GA79\"", "\"GA80\"", 
    "\"GA81\"", "\"GA82\"", "\"GA83\"", "\"GA84\"", "\"GA85\"", "\"GA86\"", 
    "\"GE\"", "\"GE58\"", "\"GE59\"", "\"GE60\"", "\"GE61\"", "\"GE62\"", 
    "\"GE63\"", "\"GE64\"", "\"GE65\"", "\"GE66\"", "\"GE67\"", "\"GE68\"", 
    "\"GE69\"", "\"GE70\"", "\"GE71\"", "\"GE72\"", "\"GE73\"", "\"GE74\"", 
    "\"GE75\"", "\"GE76\"", "\"GE77\"", "\"GE78\"", "\"GE79\"", "\"GE80\"", 
    "\"GE81\"", "\"GE82\"", "\"GE83\"", "\"GE84\"", "\"GE85\"", "\"GE86\"", 
    "\"GE87\"", "\"GE88\"", "\"GE89\"", "\"AS\"", "\"AS60\"", "\"AS61\"", 
    "\"AS62\"", "\"AS63\"", "\"AS64\"", "\"AS65\"", "\"AS66\"", "\"AS67\"", 
    "\"AS68\"", "\"AS69\"", "\"AS70\"", "\"AS71\"", "\"AS72\"", "\"AS73\"", 
    "\"AS74\"", "\"AS75\"", "\"AS76\"", "\"AS77\"", "\"AS78\"", "\"AS79\"", 
    "\"AS80\"", "\"AS81\"", "\"AS82\"", "\"AS83\"", "\"AS84\"", "\"AS85\"", 
    "\"AS86\"", "\"AS87\"", "\"AS88\"", "\"AS89\"", "\"AS90\"", "\"AS91\"", 
    "\"AS92\"", "\"SE\"", "\"SE65\"", "\"SE66\"", "\"SE67\"", "\"SE68\"", 
    "\"SE69\"", "\"SE70\"", "\"SE71\"", "\"SE72\"", "\"SE73\"", "\"SE74\"", 
    "\"SE75\"", "\"SE76\"", "\"SE77\"", "\"SE78\"", "\"SE79\"", "\"SE80\"", 
    "\"SE81\"", "\"SE82\"", "\"SE83\"", "\"SE84\"", "\"SE85\"", "\"SE86\"", 
    "\"SE87\"", "\"SE88\"", "\"SE89\"", "\"SE90\"", "\"SE91\"", "\"SE92\"", 
    "\"SE93\"", "\"SE94\"", "\"BR\"", "\"BR67\"", "\"BR68\"", "\"BR69\"", 
    "\"BR70\"", "\"BR71\"", "\"BR72\"", "\"BR73\"", "\"BR74\"", "\"BR75\"", 
    "\"BR76\"", "\"BR77\"", "\"BR78\"", "\"BR79\"", "\"BR80\"", "\"BR81\"", 
    "\"BR82\"", "\"BR83\"", "\"BR84\"", "\"BR85\"", "\"BR86\"", "\"BR87\"", 
    "\"BR88\"", "\"BR89\"", "\"BR90\"", "\"BR91\"", "\"BR92\"", "\"BR93\"", 
    "\"BR94\"", "\"BR95\"", "\"BR96\"", "\"BR97\"", "\"KR\"", "\"KR69\"", 
    "\"KR70\"", "\"KR71\"", "\"KR72\"", "\"KR73\"", "\"KR74\"", "\"KR75\"", 
    "\"KR76\"", "\"KR77\"", "\"KR78\"", "\"KR79\"", "\"KR80\"", "\"KR81\"", 
    "\"KR82\"", "\"KR83\"", "\"KR84\"", "\"KR85\"", "\"KR86\"", "\"KR87\"", 
    "\"KR88\"", "\"KR89\"", "\"KR90\"", "\"KR91\"", "\"KR92\"", "\"KR93\"", 
    "\"KR94\"", "\"KR95\"", "\"KR96\"", "\"KR97\"", "\"KR98\"", "\"KR99\"", 
    "\"KR100\"", "\"RB\"", "\"RB71\"", "\"RB72\"", "\"RB73\"", "\"RB74\"", 
    "\"RB75\"", "\"RB76\"", "\"RB77\"", "\"RB78\"", "\"RB79\"", "\"RB80\"", 
    "\"RB81\"", "\"RB82\"", "\"RB83\"", "\"RB84\"", "\"RB85\"", "\"RB86\"", 
    "\"RB87\"", "\"RB88\"", "\"RB89\"", "\"RB90\"", "\"RB91\"", "\"RB92\"", 
    "\"RB93\"", "\"RB94\"", "\"RB95\"", "\"RB96\"", "\"RB97\"", "\"RB98\"", 
    "\"RB99\"", "\"RB100\"", "\"RB101\"", "\"RB102\"", "\"SR\"", "\"SR73\"", 
    "\"SR74\"", "\"SR75\"", "\"SR76\"", "\"SR77\"", "\"SR78\"", "\"SR79\"", 
    "\"SR80\"", "\"SR81\"", "\"SR82\"", "\"SR83\"", "\"SR84\"", "\"SR85\"", 
    "\"SR86\"", "\"SR87\"", "\"SR88\"", "\"SR89\"", "\"SR90\"", "\"SR91\"", 
    "\"SR92\"", "\"SR93\"", "\"SR94\"", "\"SR95\"", "\"SR96\"", "\"SR97\"", 
    "\"SR98\"", "\"SR99\"", "\"SR100\"", "\"SR101\"", "\"SR102\"", 
    "\"SR103\"", "\"SR104\"", "\"SR105\"", "\"Y\"", "\"Y76\"", "\"Y77\"", 
    "\"Y78\"", "\"Y79\"", "\"Y80\"", "\"Y81\"", "\"Y82\"", "\"Y83\"", 
    "\"Y84\"", "\"Y85\"", "\"Y86\"", "\"Y87\"", "\"Y88\"", "\"Y89\"", 
    "\"Y90\"", "\"Y91\"", "\"Y92\"", "\"Y93\"", "\"Y94\"", "\"Y95\"", 
    "\"Y96\"", "\"Y97\"", "\"Y98\"", "\"Y99\"", "\"Y100\"", "\"Y101\"", 
    "\"Y102\"", "\"Y103\"", "\"Y104\"", "\"Y105\"", "\"Y106\"", "\"Y107\"", 
    "\"Y108\"", "\"ZR\"", "\"ZR78\"", "\"ZR79\"", "\"ZR80\"", "\"ZR81\"", 
    "\"ZR82\"", "\"ZR83\"", "\"ZR84\"", "\"ZR85\"", "\"ZR86\"", "\"ZR87\"", 
    "\"ZR88\"", "\"ZR89\"", "\"ZR90\"", "\"ZR91\"", "\"ZR92\"", "\"ZR93\"", 
    "\"ZR94\"", "\"ZR95\"", "\"ZR96\"", "\"ZR97\"", "\"ZR98\"", "\"ZR99\"", 
    "\"ZR100\"", "\"ZR101\"", "\"ZR102\"", "\"ZR103\"", "\"ZR104\"", 
    "\"ZR105\"", "\"ZR106\"", "\"ZR107\"", "\"ZR108\"", "\"ZR109\"", 
    "\"ZR110\"", "\"NB\"", "\"NB81\"", "\"NB82\"", "\"NB83\"", "\"NB84\"", 
    "\"NB85\"", "\"NB86\"", "\"NB87\"", "\"NB88\"", "\"NB89\"", "\"NB90\"", 
    "\"NB91\"", "\"NB92\"", "\"NB93\"", "\"NB94\"", "\"NB95\"", "\"NB96\"", 
    "\"NB97\"", "\"NB98\"", "\"NB99\"", "\"NB100\"", "\"NB101\"", "\"NB102\"",
     "\"NB103\"", "\"NB104\"", "\"NB105\"", "\"NB106\"", "\"NB107\"", 
    "\"NB108\"", "\"NB109\"", "\"NB110\"", "\"NB111\"", "\"NB112\"", 
    "\"NB113\"", "\"MO\"", "\"MO83\"", "\"MO84\"", "\"MO85\"", "\"MO86\"", 
    "\"MO87\"", "\"MO88\"", "\"MO89\"", "\"MO90\"", "\"MO91\"", "\"MO92\"", 
    "\"MO93\"", "\"MO94\"", "\"MO95\"", "\"MO96\"", "\"MO97\"", "\"MO98\"", 
    "\"MO99\"", "\"MO100\"", "\"MO101\"", "\"MO102\"", "\"MO103\"", 
    "\"MO104\"", "\"MO105\"", "\"MO106\"", "\"MO107\"", "\"MO108\"", 
    "\"MO109\"", "\"MO110\"", "\"MO111\"", "\"MO112\"", "\"MO113\"", 
    "\"MO114\"", "\"MO115\"", "\"TC\"", "\"TC85\"", "\"TC86\"", "\"TC87\"", 
    "\"TC88\"", "\"TC89\"", "\"TC90\"", "\"TC91\"", "\"TC92\"", "\"TC93\"", 
    "\"TC94\"", "\"TC95\"", "\"TC96\"", "\"TC97\"", "\"TC98\"", "\"TC99\"", 
    "\"TC100\"", "\"TC101\"", "\"TC102\"", "\"TC103\"", "\"TC104\"", 
    "\"TC105\"", "\"TC106\"", "\"TC107\"", "\"TC108\"", "\"TC109\"", 
    "\"TC110\"", "\"TC111\"", "\"TC112\"", "\"TC113\"", "\"TC114\"", 
    "\"TC115\"", "\"TC116\"", "\"TC117\"", "\"TC118\"", "\"RU\"", "\"RU87\"", 
    "\"RU88\"", "\"RU89\"", "\"RU90\"", "\"RU91\"", "\"RU92\"", "\"RU93\"", 
    "\"RU94\"", "\"RU95\"", "\"RU96\"", "\"RU97\"", "\"RU98\"", "\"RU99\"", 
    "\"RU100\"", "\"RU101\"", "\"RU102\"", "\"RU103\"", "\"RU104\"", 
    "\"RU105\"", "\"RU106\"", "\"RU107\"", "\"RU108\"", "\"RU109\"", 
    "\"RU110\"", "\"RU111\"", "\"RU112\"", "\"RU113\"", "\"RU114\"", 
    "\"RU115\"", "\"RU116\"", "\"RU117\"", "\"RU118\"", "\"RU119\"", 
    "\"RU120\"", "\"RH\"", "\"RH89\"", "\"RH90\"", "\"RH91\"", "\"RH92\"", 
    "\"RH93\"", "\"RH94\"", "\"RH95\"", "\"RH96\"", "\"RH97\"", "\"RH98\"", 
    "\"RH99\"", "\"RH100\"", "\"RH101\"", "\"RH102\"", "\"RH103\"", 
    "\"RH104\"", "\"RH105\"", "\"RH106\"", "\"RH107\"", "\"RH108\"", 
    "\"RH109\"", "\"RH110\"", "\"RH111\"", "\"RH112\"", "\"RH113\"", 
    "\"RH114\"", "\"RH115\"", "\"RH116\"", "\"RH117\"", "\"RH118\"", 
    "\"RH119\"", "\"RH120\"", "\"RH121\"", "\"RH122\"", "\"PD\"", "\"PD91\"", 
    "\"PD92\"", "\"PD93\"", "\"PD94\"", "\"PD95\"", "\"PD96\"", "\"PD97\"", 
    "\"PD98\"", "\"PD99\"", "\"PD100\"", "\"PD101\"", "\"PD102\"", 
    "\"PD103\"", "\"PD104\"", "\"PD105\"", "\"PD106\"", "\"PD107\"", 
    "\"PD108\"", "\"PD109\"", "\"PD110\"", "\"PD111\"", "\"PD112\"", 
    "\"PD113\"", "\"PD114\"", "\"PD115\"", "\"PD116\"", "\"PD117\"", 
    "\"PD118\"", "\"PD119\"", "\"PD120\"", "\"PD121\"", "\"PD122\"", 
    "\"PD123\"", "\"PD124\"", "\"AG\"", "\"AG93\"", "\"AG94\"", "\"AG95\"", 
    "\"AG96\"", "\"AG97\"", "\"AG98\"", "\"AG99\"", "\"AG100\"", "\"AG101\"", 
    "\"AG102\"", "\"AG103\"", "\"AG104\"", "\"AG105\"", "\"AG106\"", 
    "\"AG107\"", "\"AG108\"", "\"AG109\"", "\"AG110\"", "\"AG111\"", 
    "\"AG112\"", "\"AG113\"", "\"AG114\"", "\"AG115\"", "\"AG116\"", 
    "\"AG117\"", "\"AG118\"", "\"AG119\"", "\"AG120\"", "\"AG121\"", 
    "\"AG122\"", "\"AG123\"", "\"AG124\"", "\"AG125\"", "\"AG126\"", 
    "\"AG127\"", "\"AG128\"", "\"AG129\"", "\"AG130\"", "\"CD\"", "\"CD95\"", 
    "\"CD96\"", "\"CD97\"", "\"CD98\"", "\"CD99\"", "\"CD100\"", "\"CD101\"", 
    "\"CD102\"", "\"CD103\"", "\"CD104\"", "\"CD105\"", "\"CD106\"", 
    "\"CD107\"", "\"CD108\"", "\"CD109\"", "\"CD110\"", "\"CD111\"", 
    "\"CD112\"", "\"CD113\"", "\"CD114\"", "\"CD115\"", "\"CD116\"", 
    "\"CD117\"", "\"CD118\"", "\"CD119\"", "\"CD120\"", "\"CD121\"", 
    "\"CD122\"", "\"CD123\"", "\"CD124\"", "\"CD125\"", "\"CD126\"", 
    "\"CD127\"", "\"CD128\"", "\"CD129\"", "\"CD130\"", "\"CD131\"", 
    "\"CD132\"", "\"IN\"", "\"IN97\"", "\"IN98\"", "\"IN99\"", "\"IN100\"", 
    "\"IN101\"", "\"IN102\"", "\"IN103\"", "\"IN104\"", "\"IN105\"", 
    "\"IN106\"", "\"IN107\"", "\"IN108\"", "\"IN109\"", "\"IN110\"", 
    "\"IN111\"", "\"IN112\"", "\"IN113\"", "\"IN114\"", "\"IN115\"", 
    "\"IN116\"", "\"IN117\"", "\"IN118\"", "\"IN119\"", "\"IN120\"", 
    "\"IN121\"", "\"IN122\"", "\"IN123\"", "\"IN124\"", "\"IN125\"", 
    "\"IN126\"", "\"IN127\"", "\"IN128\"", "\"IN129\"", "\"IN130\"", 
    "\"IN131\"", "\"IN132\"", "\"IN133\"", "\"IN134\"", "\"IN135\"", "\"SN\"",
     "\"SN99\"", "\"SN100\"", "\"SN101\"", "\"SN102\"", "\"SN103\"", 
    "\"SN104\"", "\"SN105\"", "\"SN106\"", "\"SN107\"", "\"SN108\"", 
    "\"SN109\"", "\"SN110\"", "\"SN111\"", "\"SN112\"", "\"SN113\"", 
    "\"SN114\"", "\"SN115\"", "\"SN116\"", "\"SN117\"", "\"SN118\"", 
    "\"SN119\"", "\"SN120\"", "\"SN121\"", "\"SN122\"", "\"SN123\"", 
    "\"SN124\"", "\"SN125\"", "\"SN126\"", "\"SN127\"", "\"SN128\"", 
    "\"SN129\"", "\"SN130\"", "\"SN131\"", "\"SN132\"", "\"SN133\"", 
    "\"SN134\"", "\"SN135\"", "\"SN136\"", "\"SN137\"", "\"SB\"", "\"SB103\"",
     "\"SB104\"", "\"SB105\"", "\"SB106\"", "\"SB107\"", "\"SB108\"", 
    "\"SB109\"", "\"SB110\"", "\"SB111\"", "\"SB112\"", "\"SB113\"", 
    "\"SB114\"", "\"SB115\"", "\"SB116\"", "\"SB117\"", "\"SB118\"", 
    "\"SB119\"", "\"SB120\"", "\"SB121\"", "\"SB122\"", "\"SB123\"", 
    "\"SB124\"", "\"SB125\"", "\"SB126\"", "\"SB127\"", "\"SB128\"", 
    "\"SB129\"", "\"SB130\"", "\"SB131\"", "\"SB132\"", "\"SB133\"", 
    "\"SB134\"", "\"SB135\"", "\"SB136\"", "\"SB137\"", "\"SB138\"", 
    "\"SB139\"", "\"TE\"", "\"TE105\"", "\"TE106\"", "\"TE107\"", "\"TE108\"",
     "\"TE109\"", "\"TE110\"", "\"TE111\"", "\"TE112\"", "\"TE113\"", 
    "\"TE114\"", "\"TE115\"", "\"TE116\"", "\"TE117\"", "\"TE118\"", 
    "\"TE119\"", "\"TE120\"", "\"TE121\"", "\"TE122\"", "\"TE123\"", 
    "\"TE124\"", "\"TE125\"", "\"TE126\"", "\"TE127\"", "\"TE128\"", 
    "\"TE129\"", "\"TE130\"", "\"TE131\"", "\"TE132\"", "\"TE133\"", 
    "\"TE134\"", "\"TE135\"", "\"TE136\"", "\"TE137\"", "\"TE138\"", 
    "\"TE139\"", "\"TE140\"", "\"TE141\"", "\"TE142\"", "\"I\"", "\"I108\"", 
    "\"I109\"", "\"I110\"", "\"I111\"", "\"I112\"", "\"I113\"", "\"I114\"", 
    "\"I115\"", "\"I116\"", "\"I117\"", "\"I118\"", "\"I119\"", "\"I120\"", 
    "\"I121\"", "\"I122\"", "\"I123\"", "\"I124\"", "\"I125\"", "\"I126\"", 
    "\"I127\"", "\"I128\"", "\"I129\"", "\"I130\"", "\"I131\"", "\"I132\"", 
    "\"I133\"", "\"I134\"", "\"I135\"", "\"I136\"", "\"I137\"", "\"I138\"", 
    "\"I139\"", "\"I140\"", "\"I141\"", "\"I142\"", "\"I143\"", "\"I144\"", 
    "\"XE\"", "\"XE110\"", "\"XE111\"", "\"XE112\"", "\"XE113\"", "\"XE114\"",
     "\"XE115\"", "\"XE116\"", "\"XE117\"", "\"XE118\"", "\"XE119\"", 
    "\"XE120\"", "\"XE121\"", "\"XE122\"", "\"XE123\"", "\"XE124\"", 
    "\"XE125\"", "\"XE126\"", "\"XE127\"", "\"XE128\"", "\"XE129\"", 
    "\"XE130\"", "\"XE131\"", "\"XE132\"", "\"XE133\"", "\"XE134\"", 
    "\"XE135\"", "\"XE136\"", "\"XE137\"", "\"XE138\"", "\"XE139\"", 
    "\"XE140\"", "\"XE141\"", "\"XE142\"", "\"XE143\"", "\"XE144\"", 
    "\"XE145\"", "\"XE146\"", "\"XE147\"", "\"CS\"", "\"CS112\"", "\"CS113\"",
     "\"CS114\"", "\"CS115\"", "\"CS116\"", "\"CS117\"", "\"CS118\"", 
    "\"CS119\"", "\"CS120\"", "\"CS121\"", "\"CS122\"", "\"CS123\"", 
    "\"CS124\"", "\"CS125\"", "\"CS126\"", "\"CS127\"", "\"CS128\"", 
    "\"CS129\"", "\"CS130\"", "\"CS131\"", "\"CS132\"", "\"CS133\"", 
    "\"CS134\"", "\"CS135\"", "\"CS136\"", "\"CS137\"", "\"CS138\"", 
    "\"CS139\"", "\"CS140\"", "\"CS141\"", "\"CS142\"", "\"CS143\"", 
    "\"CS144\"", "\"CS145\"", "\"CS146\"", "\"CS147\"", "\"CS148\"", 
    "\"CS149\"", "\"CS150\"", "\"CS151\"", "\"BA\"", "\"BA114\"", "\"BA115\"",
     "\"BA116\"", "\"BA117\"", "\"BA118\"", "\"BA119\"", "\"BA120\"", 
    "\"BA121\"", "\"BA122\"", "\"BA123\"", "\"BA124\"", "\"BA125\"", 
    "\"BA126\"", "\"BA127\"", "\"BA128\"", "\"BA129\"", "\"BA130\"", 
    "\"BA131\"", "\"BA132\"", "\"BA133\"", "\"BA134\"", "\"BA135\"", 
    "\"BA136\"", "\"BA137\"", "\"BA138\"", "\"BA139\"", "\"BA140\"", 
    "\"BA141\"", "\"BA142\"", "\"BA143\"", "\"BA144\"", "\"BA145\"", 
    "\"BA146\"", "\"BA147\"", "\"BA148\"", "\"BA149\"", "\"BA150\"", 
    "\"BA151\"", "\"BA152\"", "\"BA153\"", "\"LA\"", "\"LA117\"", "\"LA118\"",
     "\"LA119\"", "\"LA120\"", "\"LA121\"", "\"LA122\"", "\"LA123\"", 
    "\"LA124\"", "\"LA125\"", "\"LA126\"", "\"LA127\"", "\"LA128\"", 
    "\"LA129\"", "\"LA130\"", "\"LA131\"", "\"LA132\"", "\"LA133\"", 
    "\"LA134\"", "\"LA135\"", "\"LA136\"", "\"LA137\"", "\"LA138\"", 
    "\"LA139\"", "\"LA140\"", "\"LA141\"", "\"LA142\"", "\"LA143\"", 
    "\"LA144\"", "\"LA145\"", "\"LA146\"", "\"LA147\"", "\"LA148\"", 
    "\"LA149\"", "\"LA150\"", "\"LA151\"", "\"LA152\"", "\"LA153\"", 
    "\"LA154\"", "\"LA155\"", "\"CE\"", "\"CE119\"", "\"CE120\"", "\"CE121\"",
     "\"CE122\"", "\"CE123\"", "\"CE124\"", "\"CE125\"", "\"CE126\"", 
    "\"CE127\"", "\"CE128\"", "\"CE129\"", "\"CE130\"", "\"CE131\"", 
    "\"CE132\"", "\"CE133\"", "\"CE134\"", "\"CE135\"", "\"CE136\"", 
    "\"CE137\"", "\"CE138\"", "\"CE139\"", "\"CE140\"", "\"CE141\"", 
    "\"CE142\"", "\"CE143\"", "\"CE144\"", "\"CE145\"", "\"CE146\"", 
    "\"CE147\"", "\"CE148\"", "\"CE149\"", "\"CE150\"", "\"CE151\"", 
    "\"CE152\"", "\"CE153\"", "\"CE154\"", "\"CE155\"", "\"CE156\"", 
    "\"CE157\"", "\"PR\"", "\"PR121\"", "\"PR122\"", "\"PR123\"", "\"PR124\"",
     "\"PR125\"", "\"PR126\"", "\"PR127\"", "\"PR128\"", "\"PR129\"", 
    "\"PR130\"", "\"PR131\"", "\"PR132\"", "\"PR133\"", "\"PR134\"", 
    "\"PR135\"", "\"PR136\"", "\"PR137\"", "\"PR138\"", "\"PR139\"", 
    "\"PR140\"", "\"PR141\"", "\"PR142\"", "\"PR143\"", "\"PR144\"", 
    "\"PR145\"", "\"PR146\"", "\"PR147\"", "\"PR148\"", "\"PR149\"", 
    "\"PR150\"", "\"PR151\"", "\"PR152\"", "\"PR153\"", "\"PR154\"", 
    "\"PR155\"", "\"PR156\"", "\"PR157\"", "\"PR158\"", "\"PR159\"", "\"ND\"",
     "\"ND124\"", "\"ND125\"", "\"ND126\"", "\"ND127\"", "\"ND128\"", 
    "\"ND129\"", "\"ND130\"", "\"ND131\"", "\"ND132\"", "\"ND133\"", 
    "\"ND134\"", "\"ND135\"", "\"ND136\"", "\"ND137\"", "\"ND138\"", 
    "\"ND139\"", "\"ND140\"", "\"ND141\"", "\"ND142\"", "\"ND143\"", 
    "\"ND144\"", "\"ND145\"", "\"ND146\"", "\"ND147\"", "\"ND148\"", 
    "\"ND149\"", "\"ND150\"", "\"ND151\"", "\"ND152\"", "\"ND153\"", 
    "\"ND154\"", "\"ND155\"", "\"ND156\"", "\"ND157\"", "\"ND158\"", 
    "\"ND159\"", "\"ND160\"", "\"ND161\"", "\"PM\"", "\"PM126\"", "\"PM127\"",
     "\"PM128\"", "\"PM129\"", "\"PM130\"", "\"PM131\"", "\"PM132\"", 
    "\"PM133\"", "\"PM134\"", "\"PM135\"", "\"PM136\"", "\"PM137\"", 
    "\"PM138\"", "\"PM139\"", "\"PM140\"", "\"PM141\"", "\"PM142\"", 
    "\"PM143\"", "\"PM144\"", "\"PM145\"", "\"PM146\"", "\"PM147\"", 
    "\"PM148\"", "\"PM149\"", "\"PM150\"", "\"PM151\"", "\"PM152\"", 
    "\"PM153\"", "\"PM154\"", "\"PM155\"", "\"PM156\"", "\"PM157\"", 
    "\"PM158\"", "\"PM159\"", "\"PM160\"", "\"PM161\"", "\"PM162\"", 
    "\"PM163\"", "\"SM\"", "\"SM128\"", "\"SM129\"", "\"SM130\"", "\"SM131\"",
     "\"SM132\"", "\"SM133\"", "\"SM134\"", "\"SM135\"", "\"SM136\"", 
    "\"SM137\"", "\"SM138\"", "\"SM139\"", "\"SM140\"", "\"SM141\"", 
    "\"SM142\"", "\"SM143\"", "\"SM144\"", "\"SM145\"", "\"SM146\"", 
    "\"SM147\"", "\"SM148\"", "\"SM149\"", "\"SM150\"", "\"SM151\"", 
    "\"SM152\"", "\"SM153\"", "\"SM154\"", "\"SM155\"", "\"SM156\"", 
    "\"SM157\"", "\"SM158\"", "\"SM159\"", "\"SM160\"", "\"SM161\"", 
    "\"SM162\"", "\"SM163\"", "\"SM164\"", "\"SM165\"", "\"EU\"", "\"EU130\"",
     "\"EU131\"", "\"EU132\"", "\"EU133\"", "\"EU134\"", "\"EU135\"", 
    "\"EU136\"", "\"EU137\"", "\"EU138\"", "\"EU139\"", "\"EU140\"", 
    "\"EU141\"", "\"EU142\"", "\"EU143\"", "\"EU144\"", "\"EU145\"", 
    "\"EU146\"", "\"EU147\"", "\"EU148\"", "\"EU149\"", "\"EU150\"", 
    "\"EU151\"", "\"EU152\"", "\"EU153\"", "\"EU154\"", "\"EU155\"", 
    "\"EU156\"", "\"EU157\"", "\"EU158\"", "\"EU159\"", "\"EU160\"", 
    "\"EU161\"", "\"EU162\"", "\"EU163\"", "\"EU164\"", "\"EU165\"", 
    "\"EU166\"", "\"EU167\"", "\"GD\"", "\"GD134\"", "\"GD135\"", "\"GD136\"",
     "\"GD137\"", "\"GD138\"", "\"GD139\"", "\"GD140\"", "\"GD141\"", 
    "\"GD142\"", "\"GD143\"", "\"GD144\"", "\"GD145\"", "\"GD146\"", 
    "\"GD147\"", "\"GD148\"", "\"GD149\"", "\"GD150\"", "\"GD151\"", 
    "\"GD152\"", "\"GD153\"", "\"GD154\"", "\"GD155\"", "\"GD156\"", 
    "\"GD157\"", "\"GD158\"", "\"GD159\"", "\"GD160\"", "\"GD161\"", 
    "\"GD162\"", "\"GD163\"", "\"GD164\"", "\"GD165\"", "\"GD166\"", 
    "\"GD167\"", "\"GD168\"", "\"GD169\"", "\"TB\"", "\"TB136\"", "\"TB137\"",
     "\"TB138\"", "\"TB139\"", "\"TB140\"", "\"TB141\"", "\"TB142\"", 
    "\"TB143\"", "\"TB144\"", "\"TB145\"", "\"TB146\"", "\"TB147\"", 
    "\"TB148\"", "\"TB149\"", "\"TB150\"", "\"TB151\"", "\"TB152\"", 
    "\"TB153\"", "\"TB154\"", "\"TB155\"", "\"TB156\"", "\"TB157\"", 
    "\"TB158\"", "\"TB159\"", "\"TB160\"", "\"TB161\"", "\"TB162\"", 
    "\"TB163\"", "\"TB164\"", "\"TB165\"", "\"TB166\"", "\"TB167\"", 
    "\"TB168\"", "\"TB169\"", "\"TB170\"", "\"TB171\"", "\"DY\"", "\"DY138\"",
     "\"DY139\"", "\"DY140\"", "\"DY141\"", "\"DY142\"", "\"DY143\"", 
    "\"DY144\"", "\"DY145\"", "\"DY146\"", "\"DY147\"", "\"DY148\"", 
    "\"DY149\"", "\"DY150\"", "\"DY151\"", "\"DY152\"", "\"DY153\"", 
    "\"DY154\"", "\"DY155\"", "\"DY156\"", "\"DY157\"", "\"DY158\"", 
    "\"DY159\"", "\"DY160\"", "\"DY161\"", "\"DY162\"", "\"DY163\"", 
    "\"DY164\"", "\"DY165\"", "\"DY166\"", "\"DY167\"", "\"DY168\"", 
    "\"DY169\"", "\"DY170\"", "\"DY171\"", "\"DY172\"", "\"DY173\"", "\"HO\"",
     "\"HO140\"", "\"HO141\"", "\"HO142\"", "\"HO143\"", "\"HO144\"", 
    "\"HO145\"", "\"HO146\"", "\"HO147\"", "\"HO148\"", "\"HO149\"", 
    "\"HO150\"", "\"HO151\"", "\"HO152\"", "\"HO153\"", "\"HO154\"", 
    "\"HO155\"", "\"HO156\"", "\"HO157\"", "\"HO158\"", "\"HO159\"", 
    "\"HO160\"", "\"HO161\"", "\"HO162\"", "\"HO163\"", "\"HO164\"", 
    "\"HO165\"", "\"HO166\"", "\"HO167\"", "\"HO168\"", "\"HO169\"", 
    "\"HO170\"", "\"HO171\"", "\"HO172\"", "\"HO173\"", "\"HO174\"", 
    "\"HO175\"", "\"ER\"", "\"ER143\"", "\"ER144\"", "\"ER145\"", "\"ER146\"",
     "\"ER147\"", "\"ER148\"", "\"ER149\"", "\"ER150\"", "\"ER151\"", 
    "\"ER152\"", "\"ER153\"", "\"ER154\"", "\"ER155\"", "\"ER156\"", 
    "\"ER157\"", "\"ER158\"", "\"ER159\"", "\"ER160\"", "\"ER161\"", 
    "\"ER162\"", "\"ER163\"", "\"ER164\"", "\"ER165\"", "\"ER166\"", 
    "\"ER167\"", "\"ER168\"", "\"ER169\"", "\"ER170\"", "\"ER171\"", 
    "\"ER172\"", "\"ER173\"", "\"ER174\"", "\"ER175\"", "\"ER176\"", 
    "\"ER177\"", "\"TM\"", "\"TM145\"", "\"TM146\"", "\"TM147\"", "\"TM148\"",
     "\"TM149\"", "\"TM150\"", "\"TM151\"", "\"TM152\"", "\"TM153\"", 
    "\"TM154\"", "\"TM155\"", "\"TM156\"", "\"TM157\"", "\"TM158\"", 
    "\"TM159\"", "\"TM160\"", "\"TM161\"", "\"TM162\"", "\"TM163\"", 
    "\"TM164\"", "\"TM165\"", "\"TM166\"", "\"TM167\"", "\"TM168\"", 
    "\"TM169\"", "\"TM170\"", "\"TM171\"", "\"TM172\"", "\"TM173\"", 
    "\"TM174\"", "\"TM175\"", "\"TM176\"", "\"TM177\"", "\"TM178\"", 
    "\"TM179\"", "\"YB\"", "\"YB148\"", "\"YB149\"", "\"YB150\"", "\"YB151\"",
     "\"YB152\"", "\"YB153\"", "\"YB154\"", "\"YB155\"", "\"YB156\"", 
    "\"YB157\"", "\"YB158\"", "\"YB159\"", "\"YB160\"", "\"YB161\"", 
    "\"YB162\"", "\"YB163\"", "\"YB164\"", "\"YB165\"", "\"YB166\"", 
    "\"YB167\"", "\"YB168\"", "\"YB169\"", "\"YB170\"", "\"YB171\"", 
    "\"YB172\"", "\"YB173\"", "\"YB174\"", "\"YB175\"", "\"YB176\"", 
    "\"YB177\"", "\"YB178\"", "\"YB179\"", "\"YB180\"", "\"YB181\"", "\"LU\"",
     "\"LU150\"", "\"LU151\"", "\"LU152\"", "\"LU153\"", "\"LU154\"", 
    "\"LU155\"", "\"LU156\"", "\"LU157\"", "\"LU158\"", "\"LU159\"", 
    "\"LU160\"", "\"LU161\"", "\"LU162\"", "\"LU163\"", "\"LU164\"", 
    "\"LU165\"", "\"LU166\"", "\"LU167\"", "\"LU168\"", "\"LU169\"", 
    "\"LU170\"", "\"LU171\"", "\"LU172\"", "\"LU173\"", "\"LU174\"", 
    "\"LU175\"", "\"LU176\"", "\"LU177\"", "\"LU178\"", "\"LU179\"", 
    "\"LU180\"", "\"LU181\"", "\"LU182\"", "\"LU183\"", "\"LU184\"", "\"HF\"",
     "\"HF153\"", "\"HF154\"", "\"HF155\"", "\"HF156\"", "\"HF157\"", 
    "\"HF158\"", "\"HF159\"", "\"HF160\"", "\"HF161\"", "\"HF162\"", 
    "\"HF163\"", "\"HF164\"", "\"HF165\"", "\"HF166\"", "\"HF167\"", 
    "\"HF168\"", "\"HF169\"", "\"HF170\"", "\"HF171\"", "\"HF172\"", 
    "\"HF173\"", "\"HF174\"", "\"HF175\"", "\"HF176\"", "\"HF177\"", 
    "\"HF178\"", "\"HF179\"", "\"HF180\"", "\"HF181\"", "\"HF182\"", 
    "\"HF183\"", "\"HF184\"", "\"HF185\"", "\"HF186\"", "\"HF187\"", 
    "\"HF188\"", "\"TA\"", "\"TA155\"", "\"TA156\"", "\"TA157\"", "\"TA158\"",
     "\"TA159\"", "\"TA160\"", "\"TA161\"", "\"TA162\"", "\"TA163\"", 
    "\"TA164\"", "\"TA165\"", "\"TA166\"", "\"TA167\"", "\"TA168\"", 
    "\"TA169\"", "\"TA170\"", "\"TA171\"", "\"TA172\"", "\"TA173\"", 
    "\"TA174\"", "\"TA175\"", "\"TA176\"", "\"TA177\"", "\"TA178\"", 
    "\"TA179\"", "\"TA180\"", "\"TA181\"", "\"TA182\"", "\"TA183\"", 
    "\"TA184\"", "\"TA185\"", "\"TA186\"", "\"TA187\"", "\"TA188\"", 
    "\"TA189\"", "\"TA190\"", "\"W\"", "\"W158\"", "\"W159\"", "\"W160\"", 
    "\"W161\"", "\"W162\"", "\"W163\"", "\"W164\"", "\"W165\"", "\"W166\"", 
    "\"W167\"", "\"W168\"", "\"W169\"", "\"W170\"", "\"W171\"", "\"W172\"", 
    "\"W173\"", "\"W174\"", "\"W175\"", "\"W176\"", "\"W177\"", "\"W178\"", 
    "\"W179\"", "\"W180\"", "\"W181\"", "\"W182\"", "\"W183\"", "\"W184\"", 
    "\"W185\"", "\"W186\"", "\"W187\"", "\"W188\"", "\"W189\"", "\"W190\"", 
    "\"W191\"", "\"W192\"", "\"RE\"", "\"RE160\"", "\"RE161\"", "\"RE162\"", 
    "\"RE163\"", "\"RE164\"", "\"RE165\"", "\"RE166\"", "\"RE167\"", 
    "\"RE168\"", "\"RE169\"", "\"RE170\"", "\"RE171\"", "\"RE172\"", 
    "\"RE173\"", "\"RE174\"", "\"RE175\"", "\"RE176\"", "\"RE177\"", 
    "\"RE178\"", "\"RE179\"", "\"RE180\"", "\"RE181\"", "\"RE182\"", 
    "\"RE183\"", "\"RE184\"", "\"RE185\"", "\"RE186\"", "\"RE187\"", 
    "\"RE188\"", "\"RE189\"", "\"RE190\"", "\"RE191\"", "\"RE192\"", 
    "\"RE193\"", "\"RE194\"", "\"OS\"", "\"OS162\"", "\"OS163\"", "\"OS164\"",
     "\"OS165\"", "\"OS166\"", "\"OS167\"", "\"OS168\"", "\"OS169\"", 
    "\"OS170\"", "\"OS171\"", "\"OS172\"", "\"OS173\"", "\"OS174\"", 
    "\"OS175\"", "\"OS176\"", "\"OS177\"", "\"OS178\"", "\"OS179\"", 
    "\"OS180\"", "\"OS181\"", "\"OS182\"", "\"OS183\"", "\"OS184\"", 
    "\"OS185\"", "\"OS186\"", "\"OS187\"", "\"OS188\"", "\"OS189\"", 
    "\"OS190\"", "\"OS191\"", "\"OS192\"", "\"OS193\"", "\"OS194\"", 
    "\"OS195\"", "\"OS196\"", "\"IR\"", "\"IR164\"", "\"IR165\"", "\"IR166\"",
     "\"IR167\"", "\"IR168\"", "\"IR169\"", "\"IR170\"", "\"IR171\"", 
    "\"IR172\"", "\"IR173\"", "\"IR174\"", "\"IR175\"", "\"IR176\"", 
    "\"IR177\"", "\"IR178\"", "\"IR179\"", "\"IR180\"", "\"IR181\"", 
    "\"IR182\"", "\"IR183\"", "\"IR184\"", "\"IR185\"", "\"IR186\"", 
    "\"IR187\"", "\"IR188\"", "\"IR189\"", "\"IR190\"", "\"IR191\"", 
    "\"IR192\"", "\"IR193\"", "\"IR194\"", "\"IR195\"", "\"IR196\"", 
    "\"IR197\"", "\"IR198\"", "\"IR199\"", "\"PT\"", "\"PT166\"", "\"PT167\"",
     "\"PT168\"", "\"PT169\"", "\"PT170\"", "\"PT171\"", "\"PT172\"", 
    "\"PT173\"", "\"PT174\"", "\"PT175\"", "\"PT176\"", "\"PT177\"", 
    "\"PT178\"", "\"PT179\"", "\"PT180\"", "\"PT181\"", "\"PT182\"", 
    "\"PT183\"", "\"PT184\"", "\"PT185\"", "\"PT186\"", "\"PT187\"", 
    "\"PT188\"", "\"PT189\"", "\"PT190\"", "\"PT191\"", "\"PT192\"", 
    "\"PT193\"", "\"PT194\"", "\"PT195\"", "\"PT196\"", "\"PT197\"", 
    "\"PT198\"", "\"PT199\"", "\"PT200\"", "\"PT201\"", "\"PT202\"", "\"AU\"",
     "\"AU169\"", "\"AU170\"", "\"AU171\"", "\"AU172\"", "\"AU173\"", 
    "\"AU174\"", "\"AU175\"", "\"AU176\"", "\"AU177\"", "\"AU178\"", 
    "\"AU179\"", "\"AU180\"", "\"AU181\"", "\"AU182\"", "\"AU183\"", 
    "\"AU184\"", "\"AU185\"", "\"AU186\"", "\"AU187\"", "\"AU188\"", 
    "\"AU189\"", "\"AU190\"", "\"AU191\"", "\"AU192\"", "\"AU193\"", 
    "\"AU194\"", "\"AU195\"", "\"AU196\"", "\"AU197\"", "\"AU198\"", 
    "\"AU199\"", "\"AU200\"", "\"AU201\"", "\"AU202\"", "\"AU203\"", 
    "\"AU204\"", "\"AU205\"", "\"HG\"", "\"HG171\"", "\"HG172\"", "\"HG173\"",
     "\"HG174\"", "\"HG175\"", "\"HG176\"", "\"HG177\"", "\"HG178\"", 
    "\"HG179\"", "\"HG180\"", "\"HG181\"", "\"HG182\"", "\"HG183\"", 
    "\"HG184\"", "\"HG185\"", "\"HG186\"", "\"HG187\"", "\"HG188\"", 
    "\"HG189\"", "\"HG190\"", "\"HG191\"", "\"HG192\"", "\"HG193\"", 
    "\"HG194\"", "\"HG195\"", "\"HG196\"", "\"HG197\"", "\"HG198\"", 
    "\"HG199\"", "\"HG200\"", "\"HG201\"", "\"HG202\"", "\"HG203\"", 
    "\"HG204\"", "\"HG205\"", "\"HG206\"", "\"HG207\"", "\"HG208\"", 
    "\"HG209\"", "\"HG210\"", "\"TL\"", "\"TL176\"", "\"TL177\"", "\"TL178\"",
     "\"TL179\"", "\"TL180\"", "\"TL181\"", "\"TL182\"", "\"TL183\"", 
    "\"TL184\"", "\"TL185\"", "\"TL186\"", "\"TL187\"", "\"TL188\"", 
    "\"TL189\"", "\"TL190\"", "\"TL191\"", "\"TL192\"", "\"TL193\"", 
    "\"TL194\"", "\"TL195\"", "\"TL196\"", "\"TL197\"", "\"TL198\"", 
    "\"TL199\"", "\"TL200\"", "\"TL201\"", "\"TL202\"", "\"TL203\"", 
    "\"TL204\"", "\"TL205\"", "\"TL206\"", "\"TL207\"", "\"TL208\"", 
    "\"TL209\"", "\"TL210\"", "\"TL211\"", "\"TL212\"", "\"PB\"", "\"PB178\"",
     "\"PB179\"", "\"PB180\"", "\"PB181\"", "\"PB182\"", "\"PB183\"", 
    "\"PB184\"", "\"PB185\"", "\"PB186\"", "\"PB187\"", "\"PB188\"", 
    "\"PB189\"", "\"PB190\"", "\"PB191\"", "\"PB192\"", "\"PB193\"", 
    "\"PB194\"", "\"PB195\"", "\"PB196\"", "\"PB197\"", "\"PB198\"", 
    "\"PB199\"", "\"PB200\"", "\"PB201\"", "\"PB202\"", "\"PB203\"", 
    "\"PB204\"", "\"PB205\"", "\"PB206\"", "\"PB207\"", "\"PB208\"", 
    "\"PB209\"", "\"PB210\"", "\"PB211\"", "\"PB212\"", "\"PB213\"", 
    "\"PB214\"", "\"PB215\"", "\"BI\"", "\"BI184\"", "\"BI185\"", "\"BI186\"",
     "\"BI187\"", "\"BI188\"", "\"BI189\"", "\"BI190\"", "\"BI191\"", 
    "\"BI192\"", "\"BI193\"", "\"BI194\"", "\"BI195\"", "\"BI196\"", 
    "\"BI197\"", "\"BI198\"", "\"BI199\"", "\"BI200\"", "\"BI201\"", 
    "\"BI202\"", "\"BI203\"", "\"BI204\"", "\"BI205\"", "\"BI206\"", 
    "\"BI207\"", "\"BI208\"", "\"BI209\"", "\"BI210\"", "\"BI211\"", 
    "\"BI212\"", "\"BI213\"", "\"BI214\"", "\"BI215\"", "\"BI216\"", 
    "\"BI217\"", "\"BI218\"", "\"PO\"", "\"PO188\"", "\"PO189\"", "\"PO190\"",
     "\"PO191\"", "\"PO192\"", "\"PO193\"", "\"PO194\"", "\"PO195\"", 
    "\"PO196\"", "\"PO197\"", "\"PO198\"", "\"PO199\"", "\"PO200\"", 
    "\"PO201\"", "\"PO202\"", "\"PO203\"", "\"PO204\"", "\"PO205\"", 
    "\"PO206\"", "\"PO207\"", "\"PO208\"", "\"PO209\"", "\"PO210\"", 
    "\"PO211\"", "\"PO212\"", "\"PO213\"", "\"PO214\"", "\"PO215\"", 
    "\"PO216\"", "\"PO217\"", "\"PO218\"", "\"PO219\"", "\"PO220\"", "\"AT\"",
     "\"AT193\"", "\"AT194\"", "\"AT195\"", "\"AT196\"", "\"AT197\"", 
    "\"AT198\"", "\"AT199\"", "\"AT200\"", "\"AT201\"", "\"AT202\"", 
    "\"AT203\"", "\"AT204\"", "\"AT205\"", "\"AT206\"", "\"AT207\"", 
    "\"AT208\"", "\"AT209\"", "\"AT210\"", "\"AT211\"", "\"AT212\"", 
    "\"AT213\"", "\"AT214\"", "\"AT215\"", "\"AT216\"", "\"AT217\"", 
    "\"AT218\"", "\"AT219\"", "\"AT220\"", "\"AT221\"", "\"AT222\"", 
    "\"AT223\"", "\"RN\"", "\"RN195\"", "\"RN196\"", "\"RN197\"", "\"RN198\"",
     "\"RN199\"", "\"RN200\"", "\"RN201\"", "\"RN202\"", "\"RN203\"", 
    "\"RN204\"", "\"RN205\"", "\"RN206\"", "\"RN207\"", "\"RN208\"", 
    "\"RN209\"", "\"RN210\"", "\"RN211\"", "\"RN212\"", "\"RN213\"", 
    "\"RN214\"", "\"RN215\"", "\"RN216\"", "\"RN217\"", "\"RN218\"", 
    "\"RN219\"", "\"RN220\"", "\"RN221\"", "\"RN222\"", "\"RN223\"", 
    "\"RN224\"", "\"RN225\"", "\"RN226\"", "\"RN227\"", "\"RN228\"", "\"FR\"",
     "\"FR199\"", "\"FR200\"", "\"FR201\"", "\"FR202\"", "\"FR203\"", 
    "\"FR204\"", "\"FR205\"", "\"FR206\"", "\"FR207\"", "\"FR208\"", 
    "\"FR209\"", "\"FR210\"", "\"FR211\"", "\"FR212\"", "\"FR213\"", 
    "\"FR214\"", "\"FR215\"", "\"FR216\"", "\"FR217\"", "\"FR218\"", 
    "\"FR219\"", "\"FR220\"", "\"FR221\"", "\"FR222\"", "\"FR223\"", 
    "\"FR224\"", "\"FR225\"", "\"FR226\"", "\"FR227\"", "\"FR228\"", 
    "\"FR229\"", "\"FR230\"", "\"FR231\"", "\"FR232\"", "\"RA\"", "\"RA202\"",
     "\"RA203\"", "\"RA204\"", "\"RA205\"", "\"RA206\"", "\"RA207\"", 
    "\"RA208\"", "\"RA209\"", "\"RA210\"", "\"RA211\"", "\"RA212\"", 
    "\"RA213\"", "\"RA214\"", "\"RA215\"", "\"RA216\"", "\"RA217\"", 
    "\"RA218\"", "\"RA219\"", "\"RA220\"", "\"RA221\"", "\"RA222\"", 
    "\"RA223\"", "\"RA224\"", "\"RA225\"", "\"RA226\"", "\"RA227\"", 
    "\"RA228\"", "\"RA229\"", "\"RA230\"", "\"RA231\"", "\"RA232\"", 
    "\"RA233\"", "\"RA234\"", "\"AC\"", "\"AC206\"", "\"AC207\"", "\"AC208\"",
     "\"AC209\"", "\"AC210\"", "\"AC211\"", "\"AC212\"", "\"AC213\"", 
    "\"AC214\"", "\"AC215\"", "\"AC216\"", "\"AC217\"", "\"AC218\"", 
    "\"AC219\"", "\"AC220\"", "\"AC221\"", "\"AC222\"", "\"AC223\"", 
    "\"AC224\"", "\"AC225\"", "\"AC226\"", "\"AC227\"", "\"AC228\"", 
    "\"AC229\"", "\"AC230\"", "\"AC231\"", "\"AC232\"", "\"AC233\"", 
    "\"AC234\"", "\"AC235\"", "\"AC236\"", "\"TH\"", "\"TH209\"", "\"TH210\"",
     "\"TH211\"", "\"TH212\"", "\"TH213\"", "\"TH214\"", "\"TH215\"", 
    "\"TH216\"", "\"TH217\"", "\"TH218\"", "\"TH219\"", "\"TH220\"", 
    "\"TH221\"", "\"TH222\"", "\"TH223\"", "\"TH224\"", "\"TH225\"", 
    "\"TH226\"", "\"TH227\"", "\"TH228\"", "\"TH229\"", "\"TH230\"", 
    "\"TH231\"", "\"TH232\"", "\"TH233\"", "\"TH234\"", "\"TH235\"", 
    "\"TH236\"", "\"TH237\"", "\"TH238\"", "\"PA\"", "\"PA212\"", "\"PA213\"",
     "\"PA214\"", "\"PA215\"", "\"PA216\"", "\"PA217\"", "\"PA218\"", 
    "\"PA219\"", "\"PA220\"", "\"PA221\"", "\"PA222\"", "\"PA223\"", 
    "\"PA224\"", "\"PA225\"", "\"PA226\"", "\"PA227\"", "\"PA228\"", 
    "\"PA229\"", "\"PA230\"", "\"PA231\"", "\"PA232\"", "\"PA233\"", 
    "\"PA234\"", "\"PA235\"", "\"PA236\"", "\"PA237\"", "\"PA238\"", 
    "\"PA239\"", "\"PA240\"", "\"U\"", "\"U217\"", "\"U218\"", "\"U219\"", 
    "\"U220\"", "\"U221\"", "\"U222\"", "\"U223\"", "\"U224\"", "\"U225\"", 
    "\"U226\"", "\"U227\"", "\"U228\"", "\"U229\"", "\"U230\"", "\"U231\"", 
    "\"U232\"", "\"U233\"", "\"U234\"", "\"U235\"", "\"U236\"", "\"U237\"", 
    "\"U238\"", "\"U239\"", "\"U240\"", "\"U241\"", "\"U242\"", "\"NP\"", 
    "\"NP225\"", "\"NP226\"", "\"NP227\"", "\"NP228\"", "\"NP229\"", 
    "\"NP230\"", "\"NP231\"", "\"NP232\"", "\"NP233\"", "\"NP234\"", 
    "\"NP235\"", "\"NP236\"", "\"NP237\"", "\"NP238\"", "\"NP239\"", 
    "\"NP240\"", "\"NP241\"", "\"NP242\"", "\"NP243\"", "\"NP244\"", "\"PU\"",
     "\"PU228\"", "\"PU229\"", "\"PU230\"", "\"PU231\"", "\"PU232\"", 
    "\"PU233\"", "\"PU234\"", "\"PU235\"", "\"PU236\"", "\"PU237\"", 
    "\"PU238\"", "\"PU239\"", "\"PU240\"", "\"PU241\"", "\"PU242\"", 
    "\"PU243\"", "\"PU244\"", "\"PU245\"", "\"PU246\"", "\"PU247\"", "\"AM\"",
     "\"AM231\"", "\"AM232\"", "\"AM233\"", "\"AM234\"", "\"AM235\"", 
    "\"AM236\"", "\"AM237\"", "\"AM238\"", "\"AM239\"", "\"AM240\"", 
    "\"AM241\"", "\"AM242\"", "\"AM243\"", "\"AM244\"", "\"AM245\"", 
    "\"AM246\"", "\"AM247\"", "\"AM248\"", "\"AM249\"", "\"CM\"", "\"CM233\"",
     "\"CM234\"", "\"CM235\"", "\"CM236\"", "\"CM237\"", "\"CM238\"", 
    "\"CM239\"", "\"CM240\"", "\"CM241\"", "\"CM242\"", "\"CM243\"", 
    "\"CM244\"", "\"CM245\"", "\"CM246\"", "\"CM247\"", "\"CM248\"", 
    "\"CM249\"", "\"CM250\"", "\"CM251\"", "\"CM252\"", "\"BK\"", "\"BK235\"",
     "\"BK236\"", "\"BK237\"", "\"BK238\"", "\"BK239\"", "\"BK240\"", 
    "\"BK241\"", "\"BK242\"", "\"BK243\"", "\"BK244\"", "\"BK245\"", 
    "\"BK246\"", "\"BK247\"", "\"BK248\"", "\"BK249\"", "\"BK250\"", 
    "\"BK251\"", "\"BK252\"", "\"BK253\"", "\"BK254\"", "\"CF\"", "\"CF237\"",
     "\"CF238\"", "\"CF239\"", "\"CF240\"", "\"CF241\"", "\"CF242\"", 
    "\"CF243\"", "\"CF244\"", "\"CF245\"", "\"CF246\"", "\"CF247\"", 
    "\"CF248\"", "\"CF249\"", "\"CF250\"", "\"CF251\"", "\"CF252\"", 
    "\"CF253\"", "\"CF254\"", "\"CF255\"", "\"CF256\"", "\"ES\"", "\"ES240\"",
     "\"ES241\"", "\"ES242\"", "\"ES243\"", "\"ES244\"", "\"ES245\"", 
    "\"ES246\"", "\"ES247\"", "\"ES248\"", "\"ES249\"", "\"ES250\"", 
    "\"ES251\"", "\"ES252\"", "\"ES253\"", "\"ES254\"", "\"ES255\"", 
    "\"ES256\"", "\"ES257\"", "\"ES258\"", "\"FM\"", "\"FM242\"", "\"FM243\"",
     "\"FM244\"", "\"FM245\"", "\"FM246\"", "\"FM247\"", "\"FM248\"", 
    "\"FM249\"", "\"FM250\"", "\"FM251\"", "\"FM252\"", "\"FM253\"", 
    "\"FM254\"", "\"FM255\"", "\"FM256\"", "\"FM257\"", "\"FM258\"", 
    "\"FM259\"", "\"FM260\"", "\"MD\"", "\"MD245\"", "\"MD246\"", "\"MD247\"",
     "\"MD248\"", "\"MD249\"", "\"MD250\"", "\"MD251\"", "\"MD252\"", 
    "\"MD253\"", "\"MD254\"", "\"MD255\"", "\"MD256\"", "\"MD257\"", 
    "\"MD258\"", "\"MD259\"", "\"MD260\"", "\"MD261\"", "\"MD262\"", "\"NO\"",
     "\"NO248\"", "\"NO249\"", "\"NO250\"", "\"NO251\"", "\"NO252\"", 
    "\"NO253\"", "\"NO254\"", "\"NO255\"", "\"NO256\"", "\"NO257\"", 
    "\"NO258\"", "\"NO259\"", "\"NO260\"", "\"NO261\"", "\"NO262\"", 
    "\"NO263\"", "\"NO264\"", "\"LR\"", "\"LR251\"", "\"LR252\"", "\"LR253\"",
     "\"LR254\"", "\"LR255\"", "\"LR256\"", "\"LR257\"", "\"LR258\"", 
    "\"LR259\"", "\"LR260\"", "\"LR261\"", "\"LR262\"", "\"LR263\"", 
    "\"LR264\"", "\"LR265\"", "\"LR266\"", "\"RF\"", "\"RF253\"", "\"RF254\"",
     "\"RF255\"", "\"RF256\"", "\"RF257\"", "\"RF258\"", "\"RF259\"", 
    "\"RF260\"", "\"RF261\"", "\"RF262\"", "\"RF263\"", "\"RF264\"", 
    "\"RF265\"", "\"RF266\"", "\"RF267\"", "\"RF268\"", "\"DB\"", "\"DB255\"",
     "\"DB256\"", "\"DB257\"", "\"DB258\"", "\"DB259\"", "\"DB260\"", 
    "\"DB261\"", "\"DB262\"", "\"DB263\"", "\"DB264\"", "\"DB265\"", 
    "\"DB266\"", "\"DB267\"", "\"DB268\"", "\"DB269\"", "\"DB270\"", "\"SG\"",
     "\"SG258\"", "\"SG259\"", "\"SG260\"", "\"SG261\"", "\"SG262\"", 
    "\"SG263\"", "\"SG264\"", "\"SG265\"", "\"SG266\"", "\"SG267\"", 
    "\"SG268\"", "\"SG269\"", "\"SG270\"", "\"SG271\"", "\"SG272\"", 
    "\"SG273\"", "\"BH\"", "\"BH260\"", "\"BH261\"", "\"BH262\"", "\"BH263\"",
     "\"BH264\"", "\"BH265\"", "\"BH266\"", "\"BH267\"", "\"BH268\"", 
    "\"BH269\"", "\"BH270\"", "\"BH271\"", "\"BH272\"", "\"BH273\"", 
    "\"BH274\"", "\"BH275\"", "\"HS\"", "\"HS263\"", "\"HS264\"", "\"HS265\"",
     "\"HS266\"", "\"HS267\"", "\"HS268\"", "\"HS269\"", "\"HS270\"", 
    "\"HS271\"", "\"HS272\"", "\"HS273\"", "\"HS274\"", "\"HS275\"", 
    "\"HS276\"", "\"HS277\"", "\"MT\"", "\"MT265\"", "\"MT266\"", "\"MT267\"",
     "\"MT268\"", "\"MT269\"", "\"MT270\"", "\"MT271\"", "\"MT272\"", 
    "\"MT273\"", "\"MT274\"", "\"MT275\"", "\"MT276\"", "\"MT277\"", 
    "\"MT278\"", "\"MT279\"", "\"DS\"", "\"DS267\"", "\"DS268\"", "\"DS269\"",
     "\"DS270\"", "\"DS271\"", "\"DS272\"", "\"DS273\"", "\"DS274\"", 
    "\"DS275\"", "\"DS276\"", "\"DS277\"", "\"DS278\"", "\"DS279\"", 
    "\"DS280\"", "\"DS281\"", "\"RG\"", "\"RG272\"", "\"RG273\"", "\"RG274\"",
     "\"RG275\"", "\"RG276\"", "\"RG277\"", "\"RG278\"", "\"RG279\"", 
    "\"RG280\"", "\"RG281\"", "\"RG282\"", "\"RG283\"", "\"UUB\"", 
    "\"UUB277\"", "\"UUB278\"", "\"UUB279\"", "\"UUB280\"", "\"UUB281\"", 
    "\"UUB282\"", "\"UUB283\"", "\"UUB284\"", "\"UUB285\"", "\"UUT\"", 
    "\"UUT283\"", "\"UUT284\"", "\"UUT285\"", "\"UUT286\"", "\"UUT287\"", 
    "\"UUQ\"", "\"UUQ285\"", "\"UUQ286\"", "\"UUQ287\"", "\"UUQ288\"", 
    "\"UUQ289\"", "\"UUP\"", "\"UUP287\"", "\"UUP288\"", "\"UUP289\"", 
    "\"UUP290\"", "\"UUP291\"", "\"UUH\"", "\"UUH289\"", "\"UUH290\"", 
    "\"UUH291\"", "\"UUH292\"", "\"UUS\"", "\"UUS291\"", "\"UUS292\"", 
    "\"UUO\"", "\"UUO293\""}],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581235839237*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"static double atomic_masses[] =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1.00782503207`12.000000000000004", ",", 
     "1.00782503207`12.000000000000004", ",", 
     "2.01410177785`11.999999999999998", ",", 
     "2.01410177785`11.999999999999998", ",", 
     "3.01604927767`11.999999999999998", ",", 
     "3.01604927767`11.999999999999998", ",", "4.027806424`10.", ",", 
     "5.035311488`10.000000000000004", ",", "6.044942594`10.000000000000004", 
     ",", "7.052749`7.000000000000001", ",", 
     "4.00260325415`12.000000000000004", ",", 
     "3.01602931914000000000000000001`11.999999999999998", ",", 
     "4.00260325415`12.000000000000004", ",", "5.012223624`9.999999999999998",
      ",", "6.018889124`10.000000000000004", ",", 
     "7.028020618`10.000000000000004", ",", "8.033921897`9.999999999999998", 
     ",", "9.043950286`10.000000000000004", ",", 
     "10.052398837`10.999999999999996", ",", "7.016004548`10.000000000000004",
      ",", "3.030775`7.000000000000001", ",", "4.027185558`10.", ",", 
     "5.0125378`7.999999999999999", ",", "6.015122794`10.000000000000004", 
     ",", "7.016004548`10.000000000000004", ",", 
     "8.022487362`10.000000000000004", ",", "9.026789505`9.999999999999998", 
     ",", "10.035481259`11.000000000000005", ",", "11.043797715`11.", ",", 
     "12.05378`7.999999999999999", ",", "9.012182201`9.999999999999998", ",", 
     "5.04079`7.000000000000001", ",", "6.019726317`9.999999999999998", ",", 
     "7.016929828`10.000000000000004", ",", "8.005305103`9.999999999999998", 
     ",", "9.012182201`9.999999999999998", ",", 
     "10.013533818`11.000000000000005", ",", "11.021657749`11.", ",", 
     "12.026920737`11.", ",", "13.035693007`11.", ",", 
     "14.04289292`10.000000000000004", ",", "15.05346`7.999999999999999", ",",
      "16.06192`7.999999999999999", ",", "11.009305406`11.", ",", 
     "6.04681`7.000000000000001", ",", "7.029917901`9.999999999999998", ",", 
     "8.024607233`10.000000000000004", ",", "9.013328782`10.", ",", 
     "10.012936992`11.000000000000005", ",", "11.009305406`11.", ",", 
     "12.014352104`11.", ",", "13.017780217`11.", ",", "14.025404009`11.", 
     ",", "15.031103021`11.", ",", "16.039808829`11.", ",", 
     "17.046989906`11.", ",", "18.05617`7.999999999999999", ",", 
     "19.06373`7.999999999999999", ",", "12", ",", 
     "8.037675025`10.000000000000004", ",", "9.031036689`9.999999999999998", 
     ",", "10.016853228`11.000000000000005", ",", "11.011433613`11.", ",", 
     "12", ",", "13.00335483778`13.", ",", "14.0032419887`12.000000000000004",
      ",", "15.010599256`11.000000000000005", ",", "16.014701252`11.", ",", 
     "17.022586116`10.999999999999998", ",", 
     "18.026759354`11.000000000000005", ",", 
     "19.034805018`11.000000000000004", ",", 
     "20.040319754`10.999999999999998", ",", "21.04934`7.999999999999999", 
     ",", "22.0572`7.999999999999999", ",", 
     "14.00307400477999999999999999999`13.", ",", 
     "10.041653674`10.999999999999996", ",", "11.026090956`11.", ",", 
     "12.018613197`11.000000000000005", ",", 
     "13.005738609`10.999999999999996", ",", 
     "14.00307400477999999999999999999`13.", ",", "15.00010889823`13.", ",", 
     "16.006101658`11.000000000000004", ",", "17.008450261`11.", ",", 
     "18.014078959`10.999999999999998", ",", 
     "19.017028697`11.000000000000005", ",", "20.023365807`11.", ",", 
     "21.02710824`10.", ",", "22.034394934`10.999999999999998", ",", 
     "23.04122`7.999999999999999", ",", "24.05104`7.999999999999999", ",", 
     "25.06066`7.999999999999999", ",", "15.99491461956`13.", ",", 
     "12.034404895`11.", ",", "13.02481221300000000000900726784`11.", ",", 
     "14.00859625`10.000000000000004", ",", 
     "15.00306561699999999998321229824`11.", ",", "15.99491461956`13.", ",", 
     "16.999131703`10.999999999999996", ",", 
     "17.999161001`10.999999999999998", ",", "19.00358013`10.", ",", 
     "20.004076742`11.", ",", "21.008655886`11.", ",", "22.009966947`11.", 
     ",", "23.015687659`11.", ",", "24.020472917`11.", ",", 
     "25.02946`7.999999999999999", ",", "26.03834`7.999999999999999", ",", 
     "27.04826`7.999999999999999", ",", "28.05781`7.999999999999999", ",", 
     "18.998403224`10.999999999999998", ",", "14.03506`7.999999999999999", 
     ",", "15.018009103`11.", ",", "16.011465724`11.", ",", 
     "17.002095237`11.", ",", "18.000937956`10.999999999999996", ",", 
     "18.998403224`10.999999999999998", ",", "19.999981315`11.", ",", 
     "20.999948951`11.", ",", "22.002998815`11.", ",", 
     "23.003574631`11.000000000000004", ",", "24.008115485`11.", ",", 
     "25.012101747`11.", ",", "26.019615555`11.", ",", "27.026760086`11.", 
     ",", "28.03567`7.999999999999999", ",", "29.04326`7.999999999999999", 
     ",", "30.0525`7.999999999999999", ",", "31.060429`7.999999999999999", 
     ",", "19.99244017542`13.", ",", "16.025761262`10.999999999999998", ",", 
     "17.017671504`11.", ",", "18.005708213`11.000000000000005", ",", 
     "19.001880248`11.", ",", "19.99244017542`13.", ",", 
     "20.993846684`11.000000000000004", ",", 
     "21.991385113`11.000000000000004", ",", "22.994466904`11.", ",", 
     "23.993610779`11.", ",", "24.997736888`11.000000000000005", ",", 
     "26.000461206`11.", ",", "27.007589903`11.", ",", "28.012071575`11.", 
     ",", "29.019385933`11.000000000000005", ",", "30.024801045`11.", ",", 
     "31.03311`7.999999999999999", ",", "32.04002`7.999999999999999", ",", 
     "33.04938`7.999999999999999", ",", "34.057028`7.999999999999999", ",", 
     "22.98976928087`13.", ",", "18.025969`7.999999999999999", ",", 
     "19.013877499`11.", ",", "20.007351328`11.", ",", "20.997655206`11.", 
     ",", "21.994436425`11.000000000000004", ",", "22.98976928087`13.", ",", 
     "23.990962782`11.", ",", "24.989953968`11.", ",", 
     "25.992633`7.999999999999999", ",", "26.994076788`11.000000000000005", 
     ",", "27.998938`7.999999999999999", ",", "29.002861`7.999999999999999", 
     ",", "30.008976`7.999999999999999", ",", "31.013585452`11.", ",", 
     "32.02046656`10.", ",", "33.026719756`11.", ",", 
     "34.03517`7.999999999999999", ",", "35.042493`7.999999999999999", ",", 
     "36.05148`7.999999999999999", ",", "37.05934`7.999999999999999", ",", 
     "23.985041699`11.000000000000005", ",", "19.03547`7.000000000000001", 
     ",", "20.018862545`11.", ",", "21.01171291`9.999999999999998", ",", 
     "21.999573843`11.", ",", "22.994123669`11.", ",", 
     "23.985041699`11.000000000000005", ",", 
     "24.985836917`11.000000000000005", ",", "25.982592929`11.", ",", 
     "26.984340585`11.", ",", "27.983876825`11.", ",", 
     "28.9886`6.0000000000000036", ",", "29.990434`7.999999999999999", ",", 
     "30.996546`7.999999999999999", ",", "31.998975`7.999999999999999", ",", 
     "33.005254`7.999999999999999", ",", "34.009456424`11.000000000000005", 
     ",", "35.01734`7.999999999999999", ",", "36.023`7.999999999999999", ",", 
     "37.0314`7.999999999999999", ",", "38.03757`7.999999999999999", ",", 
     "39.046772`7.999999999999999", ",", "40.05393`7.999999999999999", ",", 
     "26.981538627`11.", ",", "21.02804`7.999999999999999", ",", 
     "22.01952`7.999999999999999", ",", "23.007267432`11.", ",", 
     "23.999938865`11.", ",", "24.990428095`11.000000000000005", ",", 
     "25.986891692`11.000000000000005", ",", "26.981538627`11.", ",", 
     "27.981910306`10.999999999999996", ",", "28.980445046`11.", ",", 
     "29.982960256`11.", ",", "30.983946619`11.", ",", "31.988124489`11.", 
     ",", "32.990843336`11.", ",", "33.996851837`11.000000000000005", ",", 
     "34.999860235`11.", ",", "36.006207204`11.", ",", "37.01067782`10.", ",",
      "38.017231021`10.999999999999996", ",", "39.02297`7.000000000000001", 
     ",", "40.03145`7.999999999999999", ",", "41.03833`7.999999999999999", 
     ",", "42.04689`7.999999999999999", ",", "27.97692653246`13.", ",", 
     "22.03453`7.999999999999999", ",", "23.02552`7.999999999999999", ",", 
     "24.011545616`11.", ",", "25.004105574`10.999999999999996", ",", 
     "25.992329921`11.", ",", "26.986704905`11.", ",", "27.97692653246`13.", 
     ",", "28.9764947`9.000000000000002", ",", "29.973770171`11.", ",", 
     "30.975363226999998`17.", ",", "31.974148082`11.", ",", 
     "32.97800022`10.", ",", "33.978575524`11.", ",", 
     "34.984583575`11.000000000000005", ",", "35.986599477`11.", ",", 
     "36.99293608`10.", ",", "37.995633601`11.", ",", "39.002070013`11.", ",",
      "40.005869121`11.", ",", "41.01456`7.000000000000001", ",", 
     "42.01979`7.999999999999999", ",", "43.02866`7.999999999999999", ",", 
     "44.03526`7.999999999999999", ",", "30.973761629`10.999999999999996", 
     ",", "24.03435`7.999999999999999", ",", "25.02026`7.999999999999999", 
     ",", "26.01178`7.999999999999999", ",", "26.999230236`11.", ",", 
     "27.992314761`11.", ",", "28.981800606`11.", ",", "29.978313789`11.", 
     ",", "30.973761629`10.999999999999996", ",", 
     "31.973907274`11.000000000000005", ",", "32.971725543`11.", ",", 
     "33.973636257`11.", ",", "34.973314117`11.000000000000005", ",", 
     "35.97825968`10.", ",", "36.979608946`11.", ",", "37.984156827`11.", ",",
      "38.986179475`11.", ",", "39.991296951`11.", ",", "40.994335435`11.", 
     ",", "42.001007913`11.", ",", "43.00619`7.000000000000001", ",", 
     "44.01299`7.999999999999999", ",", "45.01922`7.999999999999999", ",", 
     "46.02738`7.999999999999999", ",", "31.972070999`11.", ",", 
     "26.02788`7.999999999999999", ",", "27.018833`7.999999999999999", ",", 
     "28.004372763`11.000000000000005", ",", "28.996608049`11.", ",", 
     "29.984903249`11.", ",", "30.979554728`11.", ",", "31.972070999`11.", 
     ",", "32.971458759`10.999999999999996", ",", "33.967866902`11.", ",", 
     "34.969032161`11.", ",", "35.96708076`10.", ",", "36.971125567`11.", ",",
      "37.971163317`10.999999999999996", ",", 
     "38.975134306`10.999999999999996", ",", "39.975451728`11.", ",", 
     "40.979582149`11.000000000000005", ",", "41.981022419`11.", ",", 
     "42.98715479`10.000000000000004", ",", "43.99021339`10.000000000000004", 
     ",", "44.996508112`11.", ",", "46.00075`7.999999999999999", ",", 
     "47.00859`7.999999999999999", ",", "48.01417`7.999999999999999", ",", 
     "49.023619`7.999999999999999", ",", "34.968852682`10.999999999999996", 
     ",", "28.02851`7.999999999999999", ",", "29.01411`7.999999999999999", 
     ",", "30.00477`7.999999999999999", ",", "30.992413086`11.", ",", 
     "31.985689901`11.", ",", "32.977451887`11.", ",", 
     "33.973762819`11.000000000000005", ",", 
     "34.968852682`10.999999999999996", ",", "35.968306981`11.", ",", 
     "36.965902591`11.", ",", "37.968010425`11.", ",", 
     "38.968008164`10.999999999999996", ",", "39.970415472`11.", ",", 
     "40.970684525`11.", ",", "41.973254804`11.", ",", "42.974054403`11.", 
     ",", "43.978281071`11.", ",", "44.980286886`11.000000000000005", ",", 
     "45.98421004`10.000000000000004", ",", "46.98871`7.999999999999999", ",",
      "47.99495`7.999999999999999", ",", "49.00032`7.999999999999999", ",", 
     "50.00784`7.999999999999999", ",", "51.01449`7.999999999999999", ",", 
     "39.96238312251`13.", ",", "30.02156`7.999999999999999", ",", 
     "31.012123`7.999999999999999", ",", "31.997637984`11.", ",", 
     "32.989925709`11.", ",", "33.980271244`11.000000000000005", ",", 
     "34.975257585`11.", ",", "35.967545105`11.", ",", 
     "36.96677632`9.999999999999998", ",", "37.962732394`11.000000000000005", 
     ",", "38.964313231`11.", ",", "39.96238312251`13.", ",", 
     "40.964500611`11.000000000000005", ",", "41.963045736`11.", ",", 
     "42.965636056`11.", ",", "43.964924033`11.", ",", "44.968039956`11.", 
     ",", "45.968094129`11.", ",", "46.972186792`11.", ",", 
     "47.97454`7.999999999999999", ",", "48.98052`7.999999999999999", ",", 
     "49.98443`7.999999999999999", ",", "50.99163`7.999999999999999", ",", 
     "51.99678`7.999999999999999", ",", "53.00494`7.999999999999999", ",", 
     "38.963706679`11.", ",", "32.02192`7.999999999999999", ",", 
     "33.00726`7.999999999999999", ",", "33.99841`7.999999999999999", ",", 
     "34.988009692`11.", ",", "35.981292235`11.", ",", "36.973375889`11.", 
     ",", "37.969081184`10.999999999999996", ",", "38.963706679`11.", ",", 
     "39.963998475`11.", ",", "40.961825762`11.", ",", "41.96240281`10.", ",",
      "42.96071554`9.999999999999998", ",", "43.961556804`11.", ",", 
     "44.960699493`11.", ",", "45.961976864`11.", ",", "46.961678473`11.", 
     ",", "47.965513535`11.", ",", "48.967450928`10.999999999999996", ",", 
     "49.972783355`11.", ",", "50.97638`7.999999999999999", ",", 
     "51.98261`7.999999999999999", ",", "52.98712`7.999999999999999", ",", 
     "53.9942`7.999999999999999", ",", "54.99971`7.999999999999999", ",", 
     "39.962590983`11.", ",", "34.01412`7.999999999999999", ",", 
     "35.00494`7.999999999999999", ",", "35.993087063`11.000000000000005", 
     ",", "36.985870269`11.", ",", "37.976318452`11.", ",", 
     "38.970719725`10.999999999999996", ",", "39.962590983`11.", ",", 
     "40.962278062`11.", ",", "41.958618014`11.", ",", "42.958766628`11.", 
     ",", "43.955481754`11.", ",", "44.956186566`11.", ",", 
     "45.953692587`11.", ",", "46.954546006`10.999999999999996", ",", 
     "47.952534177`11.", ",", "48.955674148`11.", ",", "49.957518962`11.", 
     ",", "50.961499214`11.", ",", "51.9651`5.999999999999999", ",", 
     "52.97005`7.999999999999999", ",", "53.97435`7.999999999999999", ",", 
     "54.98055`7.999999999999999", ",", "55.98557`7.999999999999999", ",", 
     "56.992356`7.999999999999999", ",", "44.955911909`11.", ",", 
     "36.01492`7.999999999999999", ",", "37.00305`7.999999999999999", ",", 
     "37.9947`7.999999999999999", ",", "38.984790002`11.", ",", 
     "39.977967407`10.999999999999996", ",", "40.969251125`11.", ",", 
     "41.965516429`10.999999999999996", ",", "42.961150658`11.", ",", 
     "43.959402752`11.", ",", "44.955911909`11.", ",", 
     "45.95517189`9.999999999999998", ",", "46.952407508`11.", ",", 
     "47.952231468`11.", ",", "48.950023975`11.", ",", "49.952187685`11.", 
     ",", "50.953603368`11.", ",", "51.956675468`10.999999999999996", ",", 
     "52.95961`7.999999999999999", ",", "53.963264561`11.", ",", 
     "54.968243949`11.", ",", "55.97287`7.999999999999999", ",", 
     "56.97779`7.999999999999999", ",", "57.98371`7.999999999999999", ",", 
     "58.98922`7.999999999999999", ",", "59.99571`7.999999999999999", ",", 
     "47.947946281`11.", ",", "38.00977`7.999999999999999", ",", 
     "39.00161`7.999999999999999", ",", "39.990498838`11.", ",", 
     "40.983145`7.999999999999999", ",", "41.973030902`11.", ",", 
     "42.968522499`11.", ",", "43.959690069`11.", ",", "44.958125616`11.", 
     ",", "45.952631555`11.", ",", "46.951763088`10.999999999999996", ",", 
     "47.947946281`11.", ",", "48.947869982`11.", ",", 
     "49.944791194`10.999999999999996", ",", "50.946614955`11.", ",", 
     "51.946897311`11.", ",", "52.949727171`10.999999999999996", ",", 
     "53.951052401`11.", ",", "54.955265056`10.999999999999996", ",", 
     "55.958199639`11.", ",", "56.963989137`11.000000000000005", ",", 
     "57.96697`7.999999999999999", ",", "58.97293`7.999999999999999", ",", 
     "59.97676`7.999999999999999", ",", "60.9832`7.999999999999999", ",", 
     "61.98749`7.999999999999999", ",", "62.99442`7.999999999999999", ",", 
     "50.943959507`11.", ",", "40.01109`7.999999999999999", ",", 
     "40.99978`7.999999999999999", ",", "41.99123`7.999999999999999", ",", 
     "42.98065`7.999999999999999", ",", "43.97411`7.000000000000001", ",", 
     "44.965775808`11.", ",", "45.960200481`11.", ",", 
     "46.95490894`10.000000000000004", ",", "47.952253707`10.999999999999996",
      ",", "48.948516101`11.", ",", "49.947158485`11.", ",", 
     "50.943959507`11.", ",", "51.944775479`11.", ",", 
     "52.944337979`10.999999999999996", ",", "53.946439854`11.", ",", 
     "54.947233701`11.", ",", "55.950530966`11.", ",", "56.952561432`11.", 
     ",", "57.956834136`11.", ",", "58.960207407`11.", ",", 
     "59.965026862`11.", ",", "60.96848`7.999999999999999", ",", 
     "61.97378`7.999999999999999", ",", "62.97755`7.999999999999999", ",", 
     "63.98347`7.999999999999999", ",", "64.98792`7.999999999999999", ",", 
     "51.940507472`11.", ",", "42.00643`7.999999999999999", ",", 
     "42.99771`7.999999999999999", ",", "43.985549`7.999999999999999", ",", 
     "44.97964`7.000000000000001", ",", "45.968358635`11.000000000000005", 
     ",", "46.962900046`10.999999999999996", ",", 
     "47.954031716`11.000000000000005", ",", "48.951335721`11.", ",", 
     "49.946044205`11.", ",", "50.944767431`11.", ",", "51.940507472`11.", 
     ",", "52.940649386`11.", ",", "53.938880395`11.", ",", 
     "54.940839672`11.", ",", "55.940653139`11.", ",", 
     "56.943613013`10.999999999999996", ",", "57.944353129`11.", ",", 
     "58.948586367`11.", ",", "59.950076033`11.", ",", "60.954717204`11.", 
     ",", "61.95661319`9.999999999999998", ",", "62.96186`7.999999999999999", 
     ",", "63.96441`7.999999999999999", ",", "64.97016`7.999999999999999", 
     ",", "65.97338`7.999999999999999", ",", "66.97955`7.999999999999999", 
     ",", "54.938045141`11.000000000000005", ",", 
     "44.00687`7.999999999999999", ",", "44.99451`7.999999999999999", ",", 
     "45.98672`7.999999999999999", ",", "46.9761`7.999999999999999", ",", 
     "47.96852`7.000000000000001", ",", "48.959618005`11.", ",", 
     "49.95423823`9.999999999999998", ",", "50.948210787`10.999999999999996", 
     ",", "51.945565464`11.", ",", "52.941290117`11.", ",", 
     "53.940358854`10.999999999999996", ",", 
     "54.938045141`11.000000000000005", ",", "55.93890491`10.000000000000004",
      ",", "56.938285378`11.", ",", "57.939981549`11.", ",", 
     "58.940440237`11.", ",", "59.942911246`11.", ",", "60.944652638`11.", 
     ",", "61.94842822`9.999999999999998", ",", 
     "62.95023999`10.000000000000004", ",", "63.95424909`9.999999999999998", 
     ",", "64.956336065`10.999999999999996", ",", 
     "65.96108`7.999999999999999", ",", "66.96414`7.999999999999999", ",", 
     "67.9693`7.999999999999999", ",", "68.97284`7.999999999999999", ",", 
     "55.934937475`11.", ",", "45.014578`7.999999999999999", ",", 
     "46.00081`7.999999999999999", ",", "46.99289`7.999999999999999", ",", 
     "47.980504`7.999999999999999", ",", "48.97361`7.999999999999999", ",", 
     "49.962988982`11.", ",", "50.956819538`11.", ",", "51.948113875`11.", 
     ",", "52.945307942`11.", ",", "53.939610501`11.", ",", 
     "54.938293357`11.", ",", "55.934937475`11.", ",", 
     "56.935393969`10.999999999999996", ",", 
     "57.933275558`10.999999999999996", ",", 
     "58.934875464`11.000000000000005", ",", "59.934071683`11.", ",", 
     "60.936745281`11.", ",", "61.936767442`11.", ",", "62.940369091`11.", 
     ",", "63.941201265`11.", ",", "64.94538027`9.999999999999998", ",", 
     "65.946780638`11.000000000000005", ",", 
     "66.950947244`11.000000000000005", ",", "67.9537`5.999999999999999", ",",
      "68.95878`7.999999999999999", ",", "69.96146`8.000000000000004", ",", 
     "70.96672`7.999999999999999", ",", "71.96962`7.999999999999999", ",", 
     "58.933195048`11.", ",", "47.01149`7.999999999999999", ",", 
     "48.00176`7.999999999999999", ",", "48.98972`7.999999999999999", ",", 
     "49.98154`7.999999999999999", ",", "50.97072`7.999999999999999", ",", 
     "51.96359`7.999999999999999", ",", "52.954218896`10.999999999999996", 
     ",", "53.948459635`11.", ",", "54.941999029`11.", ",", 
     "55.939839278`11.", ",", "56.936291373`11.", ",", "57.935752814`11.", 
     ",", "58.933195048`11.", ",", "59.933817059`11.", ",", 
     "60.932475763`11.", ",", "61.934050563`11.", ",", "62.933611611`11.", 
     ",", "63.935809908`11.", ",", "64.93647846`10.000000000000004", ",", 
     "65.939762004`11.", ",", "66.940889529`10.999999999999996", ",", 
     "67.944873058`11.", ",", "68.94632`7.000000000000001", ",", 
     "69.951`5.000000000000002", ",", "70.9529`5.999999999999999", ",", 
     "71.95781`8.000000000000004", ",", "72.96024`7.999999999999999", ",", 
     "73.96538`7.999999999999999", ",", "74.96833`7.999999999999999", ",", 
     "57.935342907`11.", ",", "48.01975`7.999999999999999", ",", 
     "49.00966`7.999999999999999", ",", "49.99593`7.999999999999999", ",", 
     "50.98772`7.999999999999999", ",", "51.97568`7.999999999999999", ",", 
     "52.96847`7.999999999999999", ",", "53.957905495`11.", ",", 
     "54.951330251`11.", ",", "55.942132022`11.", ",", "56.939793526`11.", 
     ",", "57.935342907`11.", ",", "58.934346705`11.", ",", 
     "59.930786372`11.", ",", "60.931056033`11.", ",", 
     "61.928345115`10.999999999999996", ",", "62.929669374`11.", ",", 
     "63.927965959`10.999999999999996", ",", "64.930084304`11.", ",", 
     "65.929139334`11.", ",", "66.931569414`11.000000000000005", ",", 
     "67.931868789`11.", ",", "68.935610269`11.", ",", 
     "69.9365`5.999999999999999", ",", "70.940736283`11.", ",", 
     "71.942092682`10.999999999999998", ",", "72.94647`7.999999999999999", 
     ",", "73.94807`7.999999999999999", ",", "74.95287`7.999999999999999", 
     ",", "75.95533`8.000000000000004", ",", "76.96055`7.999999999999999", 
     ",", "77.96318`7.999999999999999", ",", 
     "62.929597474`11.000000000000005", ",", "51.99718`7.999999999999999", 
     ",", "52.98555`7.999999999999999", ",", "53.97671`7.999999999999999", 
     ",", "54.96605`7.999999999999999", ",", "55.95856`7.999999999999999", 
     ",", "56.949211078`11.", ",", "57.944538499`11.", ",", 
     "58.939498028`11.", ",", "59.93736503`9.999999999999998", ",", 
     "60.933457821`11.", ",", "61.932583745`11.000000000000005", ",", 
     "62.929597474`11.000000000000005", ",", "63.929764183`11.", ",", 
     "64.927789485`11.", ",", "65.928868813`11.", ",", 
     "66.927730314`10.999999999999996", ",", "67.929610889`11.", ",", 
     "68.929429269`11.000000000000005", ",", "69.932392343`11.", ",", 
     "70.932676833`11.", ",", "71.935820307`11.", ",", "72.936675282`11.", 
     ",", "73.939874862`11.", ",", "74.9419`5.999999999999999", ",", 
     "75.945275026`10.999999999999998", ",", "76.94785`7.999999999999999", 
     ",", "77.95196`7.999999999999999", ",", "78.95456`7.999999999999999", 
     ",", "79.96087`7.999999999999999", ",", "63.929142222`11.", ",", 
     "53.99295`7.999999999999999", ",", "54.98398`7.999999999999999", ",", 
     "55.97238`7.999999999999999", ",", "56.964788`7.999999999999999", ",", 
     "57.954591555`11.", ",", "58.949263764`11.", ",", "59.941827035`11.", 
     ",", "60.939510635`11.", ",", "61.934329764`11.", ",", 
     "62.933211566`11.", ",", "63.929142222`11.", ",", 
     "64.929240984`10.999999999999996", ",", "65.926033419`11.", ",", 
     "66.927127345`11.", ",", "67.924844154`11.", ",", "68.926550281`11.", 
     ",", "69.925319274`11.", ",", "70.927721599`11.", ",", 
     "71.926857951`11.", ",", "72.929779104`10.999999999999998", ",", 
     "73.929458609`11.", ",", "74.932936741`11.", ",", 
     "75.93329357`9.999999999999998", ",", "76.936958967`11.", ",", 
     "77.938440216`11.", ",", "78.942652`8.000000000000004", ",", 
     "79.944342348`11.", ",", "80.95048`8.000000000000004", ",", 
     "81.95442`7.999999999999999", ",", "82.96103`7.999999999999999", ",", 
     "68.925573587`11.", ",", "55.99491`7.999999999999999", ",", 
     "56.98293`7.999999999999999", ",", "57.97425`7.999999999999999", ",", 
     "58.96337`7.999999999999999", ",", "59.95706`7.999999999999999", ",", 
     "60.949446287`11.000000000000005", ",", "61.944175238`11.", ",", 
     "62.939294196`10.999999999999996", ",", "63.936838747`11.", ",", 
     "64.932734754`11.", ",", "65.93158901`10.000000000000004", ",", 
     "66.928201703`11.000000000000005", ",", "67.927980084`11.", ",", 
     "68.925573587`11.", ",", "69.926021972`11.", ",", "70.924701349`11.", 
     ",", "71.926366268`11.", ",", "72.925174682`11.", ",", 
     "73.926945762`11.", ",", "74.926500246`11.", ",", "75.928827626`11.", 
     ",", "76.9291543`9.000000000000002", ",", 
     "77.93160818`10.000000000000004", ",", "78.93289326`9.999999999999998", 
     ",", "79.936515781`11.", ",", "80.937752355`10.999999999999998", ",", 
     "81.94299`7.999999999999999", ",", "82.94698`7.999999999999999", ",", 
     "83.95265`7.999999999999999", ",", "84.957`7.999999999999999", ",", 
     "85.96312`7.999999999999999", ",", "73.921177767`11.", ",", 
     "57.99101`7.999999999999999", ",", "58.98175`7.999999999999999", ",", 
     "59.97019`7.999999999999999", ",", "60.96379`7.999999999999999", ",", 
     "61.95465`7.999999999999999", ",", "62.94964`7.999999999999999", ",", 
     "63.941653`7.999999999999999", ",", "64.939436406`11.", ",", 
     "65.933843453`11.", ",", "66.93273407`9.999999999999998", ",", 
     "67.92809424`9.999999999999998", ",", "68.927964533`11.", ",", 
     "69.924247381`10.999999999999998", ",", "70.924950954`11.", ",", 
     "71.922075815`11.", ",", "72.923458945`11.", ",", "73.921177767`11.", 
     ",", "74.922858948`11.", ",", "75.921402557`11.", ",", 
     "76.923548591`11.", ",", "77.922852739`11.", ",", "78.925400995`11.", 
     ",", "79.925372392`11.", ",", "80.928820467`11.", ",", 
     "81.929549725`11.", ",", "82.93462`7.999999999999999", ",", 
     "83.93747`7.999999999999999", ",", "84.94303`7.999999999999999", ",", 
     "85.94649`7.999999999999999", ",", "86.95251`7.999999999999999", ",", 
     "87.95691`7.999999999999999", ",", "88.96383`7.999999999999999", ",", 
     "74.921596478`11.", ",", "59.99313`7.999999999999999", ",", 
     "60.98062`7.999999999999999", ",", "61.9732`7.999999999999999", ",", 
     "62.96369`7.999999999999999", ",", "63.957572`7.999999999999999", ",", 
     "64.949564`7.999999999999999", ",", "65.94471`7.000000000000001", ",", 
     "66.939186071`11.", ",", "67.936769069`11.", ",", "68.932273675`11.", 
     ",", "69.930924826`11.", ",", "70.927112428`11.", ",", 
     "71.926752283`11.000000000000005", ",", "72.923824844`11.", ",", 
     "73.923928692`11.", ",", "74.921596478`11.", ",", 
     "75.922394021`11.000000000000004", ",", 
     "76.920647286`11.000000000000005", ",", "77.921827281`11.", ",", 
     "78.920947934`11.", ",", "79.922533816`11.", ",", "80.922132287`11.", 
     ",", "81.924504067`11.", ",", "82.924980024`11.", ",", 
     "83.929058`7.999999999999999", ",", "84.93202`7.999999999999999", ",", 
     "85.9365`7.999999999999999", ",", "86.9399`7.999999999999999", ",", 
     "87.94494`7.999999999999999", ",", "88.94939`7.999999999999999", ",", 
     "89.9555`7.999999999999999", ",", "90.96043`7.999999999999999", ",", 
     "91.9668`7.999999999999999", ",", "79.916521271`11.", ",", 
     "64.96466`7.999999999999999", ",", "65.95521`7.999999999999999", ",", 
     "66.95009`7.999999999999999", ",", "67.941798`7.999999999999999", ",", 
     "68.939557817`11.", ",", "69.933390644`11.", ",", "70.932241822`11.", 
     ",", "71.927112352`11.", ",", "72.926765345`11.", ",", 
     "73.922476436`10.999999999999998", ",", "74.922523368`11.", ",", 
     "75.919213597`11.", ",", "76.919914038`11.", ",", 
     "77.91730909`10.000000000000004", ",", "78.918499098`11.", ",", 
     "79.916521271`11.", ",", "80.917992474`11.", ",", 
     "81.916699401`11.000000000000005", ",", "82.919118473`11.", ",", 
     "83.918462354`10.999999999999998", ",", "84.922245053`11.", ",", 
     "85.924271579`11.", ",", "86.928521358`11.", ",", "87.931423998`11.", 
     ",", "88.93645`8.000000000000004", ",", "89.93996`7.999999999999999", 
     ",", "90.94596`7.999999999999999", ",", "91.94992`7.999999999999999", 
     ",", "92.95629`7.999999999999999", ",", "93.96049`7.999999999999999", 
     ",", "78.918337087`11.", ",", "66.96479`7.999999999999999", ",", 
     "67.958516`7.999999999999999", ",", "68.950106`7.999999999999999", ",", 
     "69.944792`7.999999999999999", ",", "70.93874`7.000000000000001", ",", 
     "71.936644572`11.", ",", "72.931691524`11.", ",", "73.929891034`11.", 
     ",", "74.925776207`11.", ",", "75.924541469`11.", ",", 
     "76.921379082`11.", ",", "77.921145706`11.", ",", "78.918337087`11.", 
     ",", "79.918529296`11.", ",", "80.916290563`11.", ",", 
     "81.916804119`11.", ",", "82.915180421`11.000000000000005", ",", 
     "83.916478974`11.", ",", "84.915608403`11.", ",", "85.918797577`11.", 
     ",", "86.920711324`11.", ",", "87.924065926`11.", ",", 
     "88.926385334`11.", ",", "89.930627737`11.000000000000004", ",", 
     "90.933968095`11.000000000000004", ",", "91.939258714`11.", ",", 
     "92.94305`7.999999999999999", ",", "93.94868`7.999999999999999", ",", 
     "94.95287`7.999999999999999", ",", "95.95853`7.999999999999999", ",", 
     "96.9628`7.999999999999999", ",", "85.910610729`11.", ",", 
     "68.96518`7.999999999999999", ",", "69.955259`7.999999999999999", ",", 
     "70.949625738`11.", ",", "71.942092038`11.", ",", "72.939289195`11.", 
     ",", "73.933084369`11.000000000000004", ",", "74.930945746`11.", ",", 
     "75.925910078`11.", ",", "76.92467`7.000000000000001", ",", 
     "77.920364783`11.", ",", "78.920082431`11.", ",", "79.916378965`11.", 
     ",", "80.916592015`11.", ",", "81.9134836`9.000000000000002", ",", 
     "82.914136099`11.", ",", "83.911506687`11.", ",", "84.912527331`11.", 
     ",", "85.910610729`11.", ",", "86.913354862`11.000000000000004", ",", 
     "87.914446969`11.000000000000004", ",", "88.917630581`11.", ",", 
     "89.919516555`11.", ",", "90.923445215`11.", ",", 
     "91.92615621`9.999999999999998", ",", "92.931274357`11.000000000000005", 
     ",", "93.93436`7.999999999999999", ",", "94.93984`7.999999999999999", 
     ",", "95.94307`7.999999999999999", ",", "96.94856`7.999999999999999", 
     ",", "97.95191`7.999999999999999", ",", "98.9576`7.999999999999999", ",",
      "99.96114`7.999999999999999", ",", "84.911789737`11.", ",", 
     "70.96532`7.999999999999999", ",", "71.95908`8.000000000000004", ",", 
     "72.950561`7.999999999999999", ",", "73.944264751`10.999999999999998", 
     ",", "74.93857`7.000000000000001", ",", "75.935072226`11.", ",", 
     "76.930408`7.999999999999999", ",", "77.928141`7.999999999999999", ",", 
     "78.92398946`10.000000000000004", ",", "79.92251925`10.000000000000004", 
     ",", "80.918995913`11.", ",", "81.918208598`11.", ",", 
     "82.915109701`11.", ",", "83.914384821`11.", ",", "84.911789737`11.", 
     ",", "85.911167419`11.000000000000004", ",", "86.909180526`11.", ",", 
     "87.911315588`11.", ",", "88.912278016`11.", ",", "89.914801694`11.", 
     ",", "90.916536958`11.000000000000005", ",", 
     "91.9197289`9.000000000000002", ",", "92.922041876`11.", ",", 
     "93.926404946`11.", ",", "94.929302889`11.", ",", "95.934272637`11.", 
     ",", "96.937351916`11.", ",", "97.941790668`11.", ",", 
     "98.945379283`11.", ",", "99.94987`7.999999999999999", ",", 
     "100.95319644500000000000000000001`11.999999999999998", ",", 
     "101.95887`9.000000000000002", ",", "87.905612124`11.", ",", 
     "72.96597`7.999999999999999", ",", "73.95631`7.999999999999999", ",", 
     "74.949949568`11.000000000000004", ",", "75.941766782`11.", ",", 
     "76.937944782`11.", ",", "77.93218`6.999999999999997", ",", 
     "78.929708`7.999999999999999", ",", "79.924521013`11.", ",", 
     "80.923211846`11.", ",", "81.918401639`11.", ",", "82.917556701`11.", 
     ",", "83.913425275`10.999999999999998", ",", "84.912932803`11.", ",", 
     "85.909260204`11.", ",", "86.908877124`11.", ",", "87.905612124`11.", 
     ",", "88.907450675`11.", ",", "89.907737888`11.", ",", 
     "90.910203095`11.", ",", "91.911037858`11.000000000000004", ",", 
     "92.914025634`11.", ",", "93.915361312`11.", ",", "94.919358766`11.", 
     ",", "95.921696802`11.", ",", "96.926152923`11.", ",", 
     "97.928452934`11.", ",", "98.933240926`11.", ",", 
     "99.935351911`11.000000000000004", ",", 
     "100.940517888`11.999999999999998", ",", 
     "101.943018987`11.999999999999998", ",", "102.94895`9.000000000000002", 
     ",", "103.95233`9.000000000000002", ",", "104.95858`9.000000000000002", 
     ",", "88.905848295`11.", ",", "75.95845`7.999999999999999", ",", 
     "76.949645`7.999999999999999", ",", "77.94361`7.999999999999999", ",", 
     "78.937351634`11.", ",", "79.93428`7.000000000000001", ",", 
     "80.929127468`11.", ",", "81.926792451`11.", ",", "82.922354243`11.", 
     ",", "83.920388264`11.", ",", "84.916433039`11.000000000000005", ",", 
     "85.914885576`11.", ",", "86.91087573`9.999999999999998", ",", 
     "87.909501146`11.", ",", "88.905848295`11.", ",", 
     "89.907151886`11.000000000000005", ",", "90.907304791`11.", ",", 
     "91.908949143`11.", ",", "92.909582713`11.", ",", "93.911595245`11.", 
     ",", "94.912820621`10.999999999999998", ",", "95.915891343`11.", ",", 
     "96.918133995`11.", ",", "97.92220302`10.", ",", 
     "98.924636204`10.999999999999998", ",", "99.927756586`11.", ",", 
     "100.93031385`11.", ",", "101.933555695`12.000000000000004", ",", 
     "102.93673`9.000000000000002", ",", "103.94105`9.000000000000002", ",", 
     "104.94487`9.000000000000002", ",", "105.94979`9.000000000000002", ",", 
     "106.95414`9.000000000000002", ",", "107.95948`9.000000000000002", ",", 
     "89.904704416`11.", ",", "77.95523`7.999999999999999", ",", 
     "78.94916`7.999999999999999", ",", "79.9404`5.999999999999999", ",", 
     "80.937210026`11.", ",", "81.931087`7.999999999999999", ",", 
     "82.928653801`11.000000000000005", ",", "83.92325`7.999999999999999", 
     ",", "84.921471182`11.", ",", "85.916473591`11.", ",", 
     "86.914816252`11.", ",", "87.910226904`11.", ",", 
     "88.9088895`9.000000000000005", ",", "89.904704416`11.", ",", 
     "90.905645767`11.", ",", "91.905040847`11.", ",", "92.906476006`11.", 
     ",", "93.906315192`11.", ",", "94.9080426`9.000000000000002", ",", 
     "95.908273386`11.", ",", "96.910953109`11.000000000000005", ",", 
     "97.912734892`11.", ",", "98.916512106`11.", ",", 
     "99.917761889`10.999999999999998", ",", 
     "100.921140415`11.999999999999998", ",", 
     "101.922981285`12.000000000000004", ",", 
     "102.926599606`12.000000000000004", ",", "103.92878`9.000000000000002", 
     ",", "104.93305`9.000000000000002", ",", "105.93591`9.000000000000002", 
     ",", "106.94075`9.000000000000002", ",", "107.94396`9.000000000000002", 
     ",", "108.94924`9.000000000000002", ",", "109.95287`9.000000000000002", 
     ",", "92.906378058`11.", ",", "80.94903`7.999999999999999", ",", 
     "81.94313`7.999999999999999", ",", "82.936705382`11.", ",", 
     "83.93357`7.999999999999999", ",", "84.927912447`11.", ",", 
     "85.925038326`11.", ",", "86.920361108`11.", ",", "87.918332163`11.", 
     ",", "88.913418245`11.000000000000005", ",", "89.911264845`11.", ",", 
     "90.906996243`11.", ",", "91.907193888`11.000000000000004", ",", 
     "92.906378058`11.", ",", "93.907283888`11.000000000000005", ",", 
     "94.906835792`11.", ",", "95.908100647`11.", ",", 
     "96.908098556`11.000000000000004", ",", "97.910328412`11.", ",", 
     "98.911618375`11.", ",", "99.914181619`11.", ",", 
     "100.91525202500000000000000000001`11.999999999999998", ",", 
     "101.91803761400000000000253755392`12.000000000000004", ",", 
     "102.919143842`11.999999999999998", ",", 
     "103.922464701`11.999999999999998", ",", 
     "104.923936545`12.000000000000004", ",", "105.92797`9.000000000000002", 
     ",", "106.93031`9.000000000000002", ",", "107.93484`9.000000000000002", 
     ",", "108.93763`9.000000000000002", ",", "109.94244`9.000000000000002", 
     ",", "110.94565`9.000000000000002", ",", "111.95083`9.000000000000002", 
     ",", "112.9547`9.000000000000002", ",", 
     "97.905408169`11.000000000000005", ",", "82.94874`7.999999999999999", 
     ",", "83.94009`7.999999999999999", ",", "84.93655`7.999999999999999", 
     ",", "85.930695904`11.", ",", "86.927326502`11.", ",", 
     "87.921953241`11.", ",", "88.919480009`11.", ",", "89.913936896`11.", 
     ",", "90.911750194`10.999999999999998", ",", "91.906810991`11.", ",", 
     "92.90681261`9.999999999999998", ",", "93.905088269`11.", ",", 
     "94.905842129`11.", ",", "95.904679477`11.", ",", "96.906021465`11.", 
     ",", "97.905408169`11.000000000000005", ",", 
     "98.90771187`10.000000000000004", ",", "99.907477336`11.", ",", 
     "100.910347001`11.999999999999998", ",", "101.91029736`11.", ",", 
     "102.913207142`11.999999999999998", ",", 
     "103.913763625`11.999999999999998", ",", 
     "104.91697461`10.999999999999996", ",", 
     "105.918136802`12.000000000000004", ",", 
     "106.921692604`12.000000000000004", ",", "107.923453`9.000000000000002", 
     ",", "108.92781`9.000000000000002", ",", "109.92973`9.000000000000002", 
     ",", "110.93441`9.000000000000002", ",", "111.93684`9.000000000000002", 
     ",", "112.94188`9.000000000000002", ",", "113.94492`9.000000000000002", 
     ",", "114.95029`9.000000000000002", ",", "98.906254747`11.", ",", 
     "84.94883`7.999999999999999", ",", "85.94288`7.999999999999999", ",", 
     "86.93653`7.999999999999999", ",", "87.932678`7.999999999999999", ",", 
     "88.927167`7.999999999999999", ",", "89.923556564`11.", ",", 
     "90.918427639`11.", ",", "91.915260166`11.", ",", 
     "92.910248984`10.999999999999998", ",", "93.909657002`11.", ",", 
     "94.907657084`11.", ",", "95.907871383`10.999999999999998", ",", 
     "96.906365358`11.", ",", "97.907215966`11.000000000000004", ",", 
     "98.906254747`11.", ",", "99.90765778`10.000000000000004", ",", 
     "100.907314659`11.999999999999998", ",", 
     "101.909215019`11.999999999999998", ",", 
     "102.909181351`12.000000000000004", ",", 
     "103.911447454`12.000000000000004", ",", 
     "104.911660566`11.999999999999998", ",", 
     "105.914357927`12.000000000000004", ",", 
     "106.915079572`12.000000000000004", ",", 
     "107.91846122600000000000794820607`11.999999999999998", ",", 
     "108.919982665`12.000000000000004", ",", 
     "109.923820483`11.999999999999998", ",", "110.92569283`11.", ",", 
     "111.929146493`12.000000000000004", ",", "112.93159`9.000000000000002", 
     ",", "113.93588`9.000000000000002", ",", "114.93869`9.000000000000002", 
     ",", "115.94337`9.000000000000002", ",", "116.94648`9.000000000000002", 
     ",", "117.95148`9.000000000000002", ",", 
     "101.904349312`12.000000000000004", ",", "86.94918`8.000000000000004", 
     ",", "87.94026`7.999999999999999", ",", "88.93611`7.999999999999999", 
     ",", "89.92989`7.999999999999999", ",", "90.926292`7.999999999999999", 
     ",", "91.92012`7.999999999999999", ",", "92.917052034`11.", ",", 
     "93.911359711`11.000000000000005", ",", "94.910412929`11.", ",", 
     "95.907597835`11.", ",", "96.9075547`9.000000000000002", ",", 
     "97.905287132`11.", ",", "98.905939302`11.", ",", "99.904219476`11.", 
     ",", "100.90558208699999999999999999999`11.999999999999998", ",", 
     "101.904349312`12.000000000000004", ",", 
     "102.906323847`11.999999999999998", ",", 
     "103.905432701`12.000000000000004", ",", 
     "104.90775286599999999999997902847`12.000000000000004", ",", 
     "105.907329433`11.999999999999998", ",", 
     "106.909905089`11.999999999999998", ",", 
     "107.910173465`11.999999999999998", ",", 
     "108.9132032329999999999884132352`11.999999999999998", ",", 
     "109.914136041`11.999999999999998", ",", "110.917696`9.000000000000002", 
     ",", "111.918965`9.000000000000002", ",", 
     "112.922487194`11.999999999999998", ",", "113.924281`9.000000000000002", 
     ",", "114.928686173`11.999999999999998", ",", 
     "115.93081`9.000000000000002", ",", "116.93558`9.000000000000002", ",", 
     "117.93782`9.000000000000002", ",", "118.94284`9.000000000000002", ",", 
     "119.94531`9.000000000000002", ",", "102.905504292`11.999999999999998", 
     ",", "88.948837`8.000000000000004", ",", "89.94287`7.999999999999999", 
     ",", "90.93655`7.999999999999999", ",", "91.93198`7.999999999999999", 
     ",", "92.92574`7.999999999999999", ",", "93.921698`7.999999999999999", 
     ",", "94.91589874`9.999999999999998", ",", "95.914460631`11.", ",", 
     "96.911336797`11.000000000000005", ",", "97.910708158`11.", ",", 
     "98.908132104`11.", ",", "99.90812155`10.000000000000004", ",", 
     "100.906163625`12.000000000000004", ",", 
     "101.906843196`12.000000000000004", ",", 
     "102.905504292`11.999999999999998", ",", 
     "103.906655518`12.000000000000004", ",", 
     "104.905693821`12.000000000000004", ",", 
     "105.907287135`12.000000000000004", ",", 
     "106.906748423`12.000000000000004", ",", 
     "107.908728018`11.999999999999998", ",", 
     "108.908737289`11.999999999999998", ",", 
     "109.911136411`11.999999999999998", ",", 
     "110.911585913`11.999999999999998", ",", 
     "111.914394159`11.999999999999998", ",", 
     "112.915530627`11.999999999999998", ",", "113.918806`9.000000000000002", 
     ",", "114.920334`9.000000000000002", ",", "115.924062`9.000000000000002",
      ",", "116.92598`9.000000000000002", ",", "117.93007`9.000000000000002", 
     ",", "118.93211`9.000000000000002", ",", "119.93641`9.000000000000002", 
     ",", "120.93872`9.000000000000002", ",", "121.94321`9.000000000000002", 
     ",", "105.903485715`12.000000000000004", ",", 
     "90.94911`7.999999999999999", ",", "91.94042`7.999999999999999", ",", 
     "92.93591`7.999999999999999", ",", "93.92877`7.999999999999999", ",", 
     "94.92469`7.999999999999999", ",", "95.918164359`11.", ",", 
     "96.916479073`11.", ",", "97.912720902`11.", ",", "98.911767833`11.", 
     ",", "99.908505886`11.", ",", "100.908289242`11.999999999999998", ",", 
     "101.905608544`12.000000000000004", ",", 
     "102.906087307`11.999999999999998", ",", 
     "103.904035834`11.999999999999998", ",", "104.90508492`11.", ",", 
     "105.903485715`12.000000000000004", ",", 
     "106.905133481`12.000000000000004", ",", 
     "107.90389170099999999998686134272`11.999999999999998", ",", 
     "108.905950451`11.999999999999998", ",", 
     "109.905153254`11.999999999999998", ",", 
     "110.907670734`11.999999999999998", ",", 
     "111.907314058`11.999999999999998", ",", 
     "112.910152908`11.999999999999998", ",", 
     "113.910362638`11.999999999999998", ",", 
     "114.913683824`11.999999999999998", ",", 
     "115.914158662`12.000000000000004", ",", 
     "116.917841338`11.999999999999998", ",", "117.9189843`10.", ",", 
     "118.92311`9.000000000000002", ",", "119.924691878`12.000000000000004", 
     ",", "120.92887`9.000000000000002", ",", "121.93055`9.000000000000002", 
     ",", "122.93493`9.000000000000002", ",", "123.93688`9.000000000000002", 
     ",", "106.90509682`11.000000000000005", ",", 
     "92.94978`7.999999999999999", ",", "93.94278`8.000000000000004", ",", 
     "94.93548`7.999999999999999", ",", "95.93068`7.999999999999999", ",", 
     "96.923972412`11.", ",", "97.921566201`11.", ",", "98.917597178`11.", 
     ",", "99.916104255`11.000000000000004", ",", 
     "100.912802233`11.999999999999998", ",", "101.911685`9.000000000000002", 
     ",", "102.90897272`10.999999999999996", ",", 
     "103.908629157`11.999999999999998", ",", 
     "104.906528661`11.999999999999998", ",", 
     "105.906668921`11.999999999999998", ",", 
     "106.90509682`11.000000000000005", ",", 
     "107.905955556`12.000000000000004", ",", 
     "108.904752292`11.999999999999998", ",", 
     "109.906107231`12.000000000000004", ",", 
     "110.905291157`11.999999999999998", ",", 
     "111.907004814`11.999999999999998", ",", 
     "112.906566579`11.999999999999998", ",", 
     "113.908803704`12.000000000000004", ",", 
     "114.908762698`12.000000000000004", ",", 
     "115.911359933`11.999999999999998", ",", 
     "116.911684562`12.000000000000004", ",", 
     "117.914582768`11.999999999999998", ",", 
     "118.91566505900000000000751828992`11.999999999999998", ",", 
     "119.918787384`12.000000000000004", ",", 
     "120.919848046`12.000000000000004", ",", "121.92353`9.000000000000002", 
     ",", "122.9249`9.000000000000002", ",", "123.92864`9.000000000000002", 
     ",", "124.93043`9.000000000000002", ",", "125.9345`9.000000000000002", 
     ",", "126.93677`9.000000000000002", ",", "127.94117`9.000000000000002", 
     ",", "128.94369`9.000000000000002", ",", "129.950448`9.000000000000002", 
     ",", "113.90335854`11.", ",", "94.94987`7.999999999999999", ",", 
     "95.93977`7.999999999999999", ",", "96.93494`7.999999999999999", ",", 
     "97.927395546`11.", ",", "98.92501`7.999999999999999", ",", 
     "99.920289525`11.", ",", "100.918681538`11.999999999999998", ",", 
     "101.91446225800000000000652214272`12.000000000000004", ",", 
     "102.913419246`11.999999999999998", ",", 
     "103.909849475`11.999999999999998", ",", 
     "104.90946790499999999998069571584`11.999999999999998", ",", 
     "105.90645941`10.999999999999996", ",", 
     "106.90661792799999999998448107519`12.000000000000004", ",", 
     "107.904183683`11.999999999999998", ",", 
     "108.904982293`12.000000000000004", ",", "109.90300207`11.", ",", 
     "110.904178107`11.999999999999998", ",", 
     "111.90275780900000000001374683137`12.000000000000004", ",", 
     "112.904401662`12.000000000000004", ",", "113.90335854`11.", ",", 
     "114.905430969`12.000000000000004", ",", 
     "115.904755809`12.000000000000004", ",", 
     "116.907218618`12.000000000000004", ",", 
     "117.90691453`10.999999999999996", ",", 
     "118.9099215969999999999928172544`12.000000000000007", ",", 
     "119.909850129`11.999999999999998", ",", 
     "120.912977363`11.999999999999998", ",", 
     "121.913332432`12.000000000000004", ",", 
     "122.91700299899999999998046502912`11.999999999999998", ",", 
     "123.917647616`11.999999999999998", ",", "124.92124637`11.", ",", 
     "125.922353321`12.000000000000004", ",", 
     "126.926443864`11.999999999999998", ",", 
     "127.927762285`12.000000000000004", ",", "128.93215`9.000000000000002", 
     ",", "129.933901937`12.000000000000004", ",", 
     "130.94067`9.000000000000002", ",", "131.94555`9.000000000000002", ",", 
     "114.903878484`12.000000000000004", ",", "96.94954`7.999999999999999", 
     ",", "97.94214`7.999999999999999", ",", "98.93422`7.999999999999999", 
     ",", "99.931110851`11.", ",", "100.92634`9.000000000000002", ",", 
     "101.92409023800000000000773849089`12.000000000000004", ",", 
     "102.919914188`11.999999999999998", ",", 
     "103.918296171`12.000000000000004", ",", 
     "104.91467354`10.999999999999996", ",", 
     "105.913465411`11.999999999999998", ",", 
     "106.9102951`10.000000000000004", ",", "107.90969818`10.999999999999996",
      ",", "108.907150507`12.000000000000004", ",", 
     "109.9071652740000000000074448896`12.000000000000004", ",", 
     "110.905103278`11.999999999999998", ",", 
     "111.905532331`11.999999999999998", ",", 
     "112.904057761`12.000000000000004", ",", 
     "113.904913876`11.999999999999998", ",", 
     "114.903878484`12.000000000000004", ",", 
     "115.905259703`11.999999999999998", ",", 
     "116.904513564`11.999999999999998", ",", 
     "117.90635436700000000000386924544`12.000000000000004", ",", 
     "118.90584535`11.", ",", "119.907959608`11.999999999999998", ",", 
     "120.907845822`12.000000000000004", ",", "121.91027601`11.", ",", 
     "122.910438276`11.999999999999998", ",", 
     "123.913175231`11.999999999999998", ",", 
     "124.913600588`12.000000000000004", ",", 
     "125.916463857`12.000000000000004", ",", 
     "126.917353091`12.000000000000004", ",", 
     "127.920172328`11.999999999999998", ",", "128.92169698`11.", ",", 
     "129.924970049`11.999999999999996", ",", 
     "130.926851767`12.000000000000004", ",", 
     "131.93299026`11.000000000000005", ",", "132.93781`9.000000000000002", 
     ",", "133.94415`9.000000000000002", ",", "134.94933`9.000000000000002", 
     ",", "119.902194676`11.999999999999998", ",", 
     "98.94933`7.999999999999999", ",", "99.939044343`11.", ",", 
     "100.93606`9.000000000000002", ",", "101.930295324`11.999999999999998", 
     ",", "102.9281`9.000000000000002", ",", 
     "103.923143223`11.999999999999998", ",", 
     "104.921349437`12.000000000000004", ",", "105.91688062`11.", ",", 
     "106.91564432900000000001785724927`12.000000000000004", ",", 
     "107.911925378`11.999999999999998", ",", 
     "108.91128321399999999999280676864`12.000000000000004", ",", 
     "109.907842791`12.000000000000004", ",", "110.90773446`11.", ",", 
     "111.904818207`12.000000000000004", ",", 
     "112.90517057700000000000066060288`12.000000000000004", ",", 
     "113.902778869`11.999999999999998", ",", 
     "114.903342397`11.999999999999998", ",", "115.90174053`11.", ",", 
     "116.902951656`12.000000000000004", ",", 
     "117.901603167`12.000000000000004", ",", 
     "118.90330763`10.999999999999996", ",", 
     "119.902194676`11.999999999999998", ",", "120.90423548`11.", ",", 
     "121.903439046`11.999999999999998", ",", 
     "122.905720838`11.999999999999998", ",", 
     "123.905273946`12.000000000000004", ",", 
     "124.907784125`11.999999999999998", ",", "125.90765328`11.", ",", 
     "126.910360024`12.000000000000004", ",", 
     "127.91053662399999999998204837888`11.999999999999998", ",", 
     "128.913479`9.000000000000002", ",", "129.913967295`11.999999999999998", 
     ",", "130.916999769`12.000000000000004", ",", 
     "131.917815713`11.999999999999998", ",", 
     "132.923829249`11.999999999999996", ",", "133.928291765`12.", ",", 
     "134.93473`9.000000000000002", ",", "135.93934`9.000000000000002", ",", 
     "136.94599`9.000000000000002", ",", "120.903815686`12.000000000000004", 
     ",", "102.93969`9.000000000000002", ",", "103.936472`9.000000000000002", 
     ",", "104.931486348`11.999999999999998", ",", 
     "105.928791`9.000000000000002", ",", "106.92415`9.000000000000002", ",", 
     "107.92216`9.000000000000002", ",", "108.918132426`12.000000000000004", 
     ",", "109.916753`9.000000000000002", ",", "110.913163`9.000000000000002",
      ",", "111.9123980089999999999854772224`11.999999999999998", ",", 
     "112.90937167200000000000645922816`12.000000000000004", ",", 
     "113.909269`9.000000000000002", ",", "114.906598`9.000000000000002", ",",
      "115.906793629`11.999999999999998", ",", 
     "116.904835941`11.999999999999998", ",", 
     "117.90552873099999999998210080767`12.000000000000004", ",", 
     "118.90394200900000000002104492032`12.000000000000004", ",", 
     "119.905072427`12.000000000000004", ",", 
     "120.903815686`12.000000000000004", ",", 
     "121.90517365099999999999426428929`11.999999999999998", ",", 
     "122.90421397`11.", ",", "123.905935743`11.999999999999998", ",", 
     "124.90525381800000000001449132032`11.999999999999998", ",", 
     "125.90724748`11.", ",", "126.906923609`11.999999999999998", ",", 
     "127.90916900099999999999705350144`11.999999999999998", ",", 
     "128.909148442`12.000000000000004", ",", 
     "129.911656324`11.999999999999998", ",", "130.911982275`12.", ",", 
     "131.914466896`11.999999999999998", ",", 
     "132.91525163`10.999999999999996", ",", 
     "133.920379744`11.999999999999998", ",", 
     "134.925165771`11.999999999999998", ",", "135.93035`9.000000000000002", 
     ",", "136.93531`9.000000000000002", ",", "137.94079`9.000000000000002", 
     ",", "138.94598`9.000000000000002", ",", 
     "129.906224399`11.999999999999998", ",", "104.94364`9.000000000000002", 
     ",", "105.937504237`11.999999999999998", ",", 
     "106.935006`9.000000000000002", ",", "107.929444597`11.999999999999998", 
     ",", "108.927415515`11.999999999999998", ",", 
     "109.92240731599999999998032871423`11.999999999999998", ",", 
     "110.9211106920000000000123731968`11.999999999999998", ",", 
     "111.917013672`11.999999999999998", ",", "112.915891`9.000000000000002", 
     ",", "113.912089`9.000000000000002", ",", "114.911902`9.000000000000002",
      ",", "115.90846`7.999999999999999", ",", 
     "116.908644719`11.999999999999998", ",", 
     "117.905827581`11.999999999999998", ",", 
     "118.906403645`11.999999999999998", ",", 
     "119.90402022200000000001444937728`12.000000000000007", ",", 
     "120.904936424`12.000000000000004", ",", 
     "121.903043898`12.000000000000004", ",", 
     "122.904270029`11.999999999999998", ",", 
     "123.902817896`11.999999999999998", ",", 
     "124.904430731`11.999999999999998", ",", 
     "125.90331169599999999999379243008`12.000000000000004", ",", 
     "126.905226336`12.000000000000004", ",", 
     "127.904463056`11.999999999999998", ",", "128.906598238`12.", ",", 
     "129.906224399`11.999999999999998", ",", 
     "130.908523864`11.999999999999998", ",", "131.90855316`11.", ",", 
     "132.910955306`11.999999999999998", ",", 
     "133.911368737`11.999999999999996", ",", "134.916448592`12.", ",", 
     "135.920101246`11.999999999999998", ",", 
     "136.925322954`12.000000000000004", ",", "137.92922`9.000000000000002", 
     ",", "138.93473`9.000000000000002", ",", "139.93885`9.000000000000002", 
     ",", "140.94465`9.000000000000002", ",", "141.94908`9.000000000000002", 
     ",", "126.904472681`11.999999999999998", ",", 
     "107.943475`9.000000000000002", ",", 
     "108.93814941700000000001114636288`12.000000000000004", ",", 
     "109.935242`9.000000000000002", ",", "110.930276`9.000000000000002", ",",
      "111.92797`9.000000000000002", ",", 
     "112.923640583000000000004456448`11.999999999999998", ",", 
     "113.92185`9.000000000000002", ",", "114.918048`9.000000000000002", ",", 
     "115.916808633`11.999999999999998", ",", "116.91365`7.999999999999999", 
     ",", "117.913074`9.000000000000002", ",", "118.910074`9.000000000000002",
      ",", "119.91004817299999999999969591296`11.999999999999998", ",", 
     "120.907366811`12.000000000000004", ",", 
     "121.907589284`12.000000000000004", ",", 
     "122.905588965`12.000000000000004", ",", 
     "123.90620985200000000001212153855`12.000000000000004", ",", 
     "124.904630164`12.000000000000004", ",", 
     "125.905624153`11.999999999999998", ",", 
     "126.904472681`11.999999999999998", ",", 
     "127.905809443`12.000000000000004", ",", 
     "128.904987722`11.999999999999998", ",", "129.906674247`12.", ",", 
     "130.906124609`12.000000000000004", ",", 
     "131.907997381`12.000000000000004", ",", 
     "132.907796939`11.999999999999996", ",", 
     "133.909744465`11.999999999999998", ",", 
     "134.910048121`12.000000000000004", ",", 
     "135.914653993`11.999999999999998", ",", 
     "136.91787084`11.000000000000005", ",", 
     "137.922349591`12.000000000000004", ",", 
     "138.926099478`11.999999999999998", ",", "139.931`9.000000000000002", 
     ",", "140.93503`9.000000000000002", ",", "141.94018`9.000000000000002", 
     ",", "142.94456`9.000000000000002", ",", "143.94999`9.000000000000002", 
     ",", "131.904153457`11.999999999999996", ",", 
     "109.944278068`12.000000000000004", ",", "110.941602`9.000000000000002", 
     ",", "111.935623112`11.999999999999998", ",", 
     "112.933341174`12.000000000000004", ",", 
     "113.927980306`11.999999999999998", ",", 
     "114.92629392`10.999999999999996", ",", 
     "115.921581087`11.999999999999998", ",", 
     "116.920358735`11.999999999999998", ",", 
     "117.916178655`11.999999999999998", ",", 
     "118.915410688`12.000000000000004", ",", 
     "119.911784244`11.999999999999998", ",", 
     "120.911461829`12.000000000000004", ",", 
     "121.908367632`11.999999999999998", ",", "122.90848191`11.", ",", 
     "123.905893003`11.999999999999998", ",", 
     "124.906395464`12.000000000000004", ",", 
     "125.904273634`11.999999999999998", ",", 
     "126.905183723`11.999999999999998", ",", 
     "127.903531275`11.999999999999998", ",", 
     "128.904779435`11.999999999999998", ",", "129.903508007`12.", ",", 
     "130.905082362`11.999999999999998", ",", 
     "131.904153457`11.999999999999996", ",", 
     "132.905910722`12.000000000000004", ",", 
     "133.905394464`12.000000000000004", ",", 
     "134.907227495`12.000000000000004", ",", 
     "135.907218794`11.999999999999998", ",", "136.911562125`12.", ",", 
     "137.913954475`12.000000000000004", ",", 
     "138.918792936`12.000000000000004", ",", "139.921640943`12.", ",", 
     "140.926648049`12.000000000000004", ",", "141.92970959`11.", ",", 
     "142.93511`9.000000000000002", ",", "143.93851`9.000000000000002", ",", 
     "144.94407`9.000000000000002", ",", "145.94775`9.000000000000002", ",", 
     "146.95356`9.000000000000002", ",", "132.905451932`12.", ",", 
     "111.950301`9.000000000000002", ",", "112.944493274`12.000000000000004", 
     ",", "113.94145`9.000000000000002", ",", "114.93591`9.000000000000002", 
     ",", "115.933367`9.000000000000002", ",", 
     "116.928670701`11.999999999999998", ",", 
     "117.926559494`12.000000000000004", ",", 
     "118.92237730400000000001920991233`11.999999999999998", ",", 
     "119.920677253`12.000000000000004", ",", 
     "120.91722920899999999999655018496`11.999999999999998", ",", 
     "121.916113434`11.999999999999998", ",", 
     "122.91299603599999999997982539776`12.000000000000004", ",", 
     "123.912257798`11.999999999999998", ",", "124.90972827`11.", ",", 
     "125.90945197699999999999873122304`11.999999999999998", ",", 
     "126.907417525`11.999999999999998", ",", 
     "127.907748866`12.000000000000004", ",", 
     "128.906064426`11.999999999999998", ",", 
     "129.906708552`11.999999999999996", ",", 
     "130.905463926`11.999999999999998", ",", "131.90643426`11.", ",", 
     "132.905451932`12.", ",", "133.906718475`12.000000000000004", ",", 
     "134.905977008`12.000000000000004", ",", 
     "135.907311576`11.999999999999998", ",", 
     "136.907089473`11.999999999999996", ",", 
     "137.911016704`12.000000000000004", ",", "138.913363999`12.", ",", 
     "139.917282354`11.999999999999998", ",", 
     "140.920045752`11.999999999999998", ",", 
     "141.924298927`11.999999999999998", ",", "142.92735175`11.", ",", 
     "143.932076914`11.999999999999996", ",", "144.93552617`11.", ",", 
     "145.940289423`12.000000000000004", ",", 
     "146.944155008`12.000000000000004", ",", 
     "147.949218153`11.999999999999998", ",", "148.95293`9.000000000000002", 
     ",", "149.95817`9.000000000000002", ",", "150.96219`9.000000000000002", 
     ",", "137.905247237`12.000000000000004", ",", 
     "113.950675405`11.999999999999998", ",", "114.94737`9.000000000000002", 
     ",", "115.94138`9.000000000000002", ",", "116.938499`9.000000000000002", 
     ",", "117.93304`9.000000000000002", ",", 
     "118.930659661`12.000000000000004", ",", 
     "119.926044974`12.000000000000004", ",", 
     "120.924054499`11.999999999999998", ",", "121.919904`9.000000000000002", 
     ",", "122.918781036`12.000000000000004", ",", 
     "123.915093603`12.000000000000004", ",", 
     "124.914472912`12.000000000000004", ",", 
     "125.911250177`12.000000000000004", ",", 
     "126.911093797`11.999999999999998", ",", 
     "127.908317698`11.999999999999998", ",", 
     "128.908679439`11.999999999999998", ",", 
     "129.906320811`12.000000000000004", ",", 
     "130.906941118`12.000000000000004", ",", 
     "131.905061288`11.999999999999998", ",", "132.90600749`11.", ",", 
     "133.904508383`12.000000000000004", ",", "134.905688591`12.", ",", 
     "135.904575945`12.000000000000004", ",", "136.905827384`12.", ",", 
     "137.905247237`12.000000000000004", ",", 
     "138.908841341`11.999999999999998", ",", 
     "139.910604505`11.999999999999998", ",", "140.914411009`12.", ",", 
     "141.91645341`11.", ",", "142.920626719`12.", ",", "143.922952853`12.", 
     ",", "144.927627032`12.000000000000004", ",", 
     "145.930219572`11.999999999999998", ",", "146.934945`9.000000000000002", 
     ",", "147.937720047`12.000000000000004", ",", 
     "148.94258`9.000000000000002", ",", "149.94568`9.000000000000002", ",", 
     "150.95081`9.000000000000002", ",", "151.95427`9.000000000000002", ",", 
     "152.95961`9.000000000000002", ",", "138.906353267`11.999999999999998", 
     ",", "116.950068`9.000000000000002", ",", "117.94673`9.000000000000002", 
     ",", "118.94099`9.000000000000002", ",", "119.93807`9.000000000000002", 
     ",", "120.93301`9.000000000000002", ",", "121.93071`9.000000000000002", 
     ",", "122.92624`9.000000000000002", ",", 
     "123.92457427500000000000315621376`11.999999999999998", ",", 
     "124.920816034`11.999999999999998", ",", 
     "125.919512667`11.999999999999998", ",", 
     "126.916375448`12.000000000000004", ",", 
     "127.915585177`12.000000000000004", ",", 
     "128.912692815`12.000000000000004", ",", 
     "129.912368724`11.999999999999998", ",", "130.91007`7.999999999999999", 
     ",", "131.910101145`11.999999999999998", ",", 
     "132.908218`9.000000000000002", ",", "133.908514011`11.999999999999996", 
     ",", "134.906976844`12.000000000000004", ",", 
     "135.907635536`12.000000000000004", ",", 
     "136.906493598`12.000000000000004", ",", "137.90711193`11.", ",", 
     "138.906353267`11.999999999999998", ",", "139.909477645`12.", ",", 
     "140.910962152`11.999999999999998", ",", "141.91407913`11.", ",", 
     "142.91606272`11.", ",", "143.919599647`11.999999999999998", ",", 
     "144.921645401`11.999999999999996", ",", 
     "145.92579346`10.999999999999996", ",", 
     "146.928235284`11.999999999999998", ",", 
     "147.932228868`11.999999999999998", ",", "148.934734`9.000000000000002", 
     ",", "149.93877`9.000000000000002", ",", "150.94172`9.000000000000002", 
     ",", "151.94625`9.000000000000002", ",", "152.94962`9.000000000000002", 
     ",", "153.9545`9.000000000000002", ",", "154.95835`9.000000000000002", 
     ",", "139.905438706`11.999999999999996", ",", 
     "118.95276`9.000000000000002", ",", "119.94664`9.000000000000002", ",", 
     "120.94342`9.000000000000002", ",", "121.93791`9.000000000000002", ",", 
     "122.9354`9.000000000000002", ",", "123.93041`9.000000000000002", ",", 
     "124.92844`9.000000000000002", ",", "125.923971`9.000000000000002", ",", 
     "126.922731`9.000000000000002", ",", "127.918911`9.000000000000002", ",",
      "128.918102`9.000000000000002", ",", "129.914736`9.000000000000002", 
     ",", "130.914422`9.000000000000002", ",", 
     "131.911460487`11.999999999999996", ",", "132.91151502`11.", ",", 
     "133.908924821`11.999999999999998", ",", 
     "134.909151396`11.999999999999998", ",", 
     "135.907172422`11.999999999999998", ",", 
     "136.907805577`11.999999999999996", ",", 
     "137.905991321`12.000000000000004", ",", 
     "138.906652651`11.999999999999998", ",", 
     "139.905438706`11.999999999999996", ",", "140.90827627`11.", ",", 
     "141.909244205`12.", ",", "142.91238591`11.", ",", 
     "143.913647336`12.000000000000004", ",", "144.917233135`12.", ",", 
     "145.918759009`12.", ",", "146.922673954`11.999999999999998", ",", 
     "147.92443241`10.999999999999996", ",", 
     "148.928399883`11.999999999999996", ",", 
     "149.930408931`12.000000000000004", ",", 
     "150.933976196`12.000000000000004", ",", "151.93654`9.000000000000002", 
     ",", "152.94058`9.000000000000002", ",", "153.94342`9.000000000000002", 
     ",", "154.94804`9.000000000000002", ",", "155.95126`9.000000000000002", 
     ",", "156.95634`9.000000000000002", ",", 
     "140.907652769`11.999999999999996", ",", "120.955364`9.000000000000002", 
     ",", "121.95181`9.000000000000002", ",", "122.94596`9.000000000000002", 
     ",", "123.94296`9.000000000000002", ",", "124.93783`9.000000000000002", 
     ",", "125.93531`9.000000000000002", ",", "126.93083`9.000000000000002", 
     ",", "127.928791`9.000000000000002", ",", "128.925095`9.000000000000002",
      ",", "129.92359`7.999999999999999", ",", "130.920259`9.000000000000002",
      ",", "131.919255`9.000000000000002", ",", 
     "132.916330532`11.999999999999998", ",", 
     "133.915711737`11.999999999999998", ",", 
     "134.913111745`11.999999999999998", ",", 
     "135.912691611`11.999999999999996", ",", 
     "136.910705455`12.000000000000004", ",", 
     "137.910754636`11.999999999999998", ",", "138.908938399`12.", ",", 
     "139.909075874`11.999999999999998", ",", 
     "140.907652769`11.999999999999996", ",", "141.910044806`12.", ",", 
     "142.910816926`12.000000000000004", ",", 
     "143.913305245`12.000000000000004", ",", "144.9145117`9.999999999999998",
      ",", "145.917644336`12.000000000000004", ",", 
     "146.918995992`11.999999999999996", ",", 
     "147.922135026`11.999999999999996", ",", 
     "148.923717651`11.999999999999996", ",", "149.926672997`12.", ",", 
     "150.928318618`12.000000000000004", ",", 
     "151.931499225`11.999999999999998", ",", 
     "152.933838905`11.999999999999998", ",", 
     "153.937518153`11.999999999999998", ",", "154.94012`9.000000000000002", 
     ",", "155.94427`9.000000000000002", ",", "156.94743`9.000000000000002", 
     ",", "157.95198`9.000000000000002", ",", "158.9555`9.000000000000002", 
     ",", "141.907723297`12.000000000000004", ",", 
     "123.95223`9.000000000000002", ",", "124.94888`9.000000000000002", ",", 
     "125.94322`9.000000000000002", ",", "126.9405`9.000000000000002", ",", 
     "127.93539`9.000000000000002", ",", "128.933188`9.000000000000002", ",", 
     "129.928506`9.000000000000002", ",", "130.927247`9.000000000000002", ",",
      "131.923321237`12.000000000000004", ",", "132.922348`9.000000000000002",
      ",", "133.918790181`11.999999999999998", ",", "134.91818116`11.", ",", 
     "135.914976035`11.999999999999998", ",", 
     "136.914567137`11.999999999999998", ",", "137.911949961`12.", ",", 
     "138.911978288`12.000000000000004", ",", "139.909552`9.000000000000002", 
     ",", "140.909609854`12.000000000000004", ",", 
     "141.907723297`12.000000000000004", ",", "142.90981429`11.", ",", 
     "143.910087274`12.000000000000004", ",", "144.912573636`12.", ",", 
     "145.913116939`11.999999999999998", ",", 
     "146.916100441`11.999999999999998", ",", 
     "147.916893288`11.999999999999996", ",", 
     "148.920148842`12.000000000000004", ",", 
     "149.920890888`12.000000000000004", ",", 
     "150.923828929`12.000000000000004", ",", "151.924682219`12.", ",", 
     "152.927698232`12.000000000000004", ",", 
     "153.929477307`11.999999999999998", ",", "154.932932`9.000000000000002", 
     ",", "155.935018114`12.000000000000004", ",", 
     "156.93903`9.000000000000002", ",", "157.9416`9.000000000000002", ",", 
     "158.94609`9.000000000000002", ",", "159.94909`9.000000000000002", ",", 
     "160.95388`9.000000000000002", ",", "144.912749023`12.000000000000004", 
     ",", "125.95752`9.000000000000002", ",", "126.95163`9.000000000000002", 
     ",", "127.94842`9.000000000000002", ",", "128.94316`9.000000000000002", 
     ",", "129.94045`9.000000000000002", ",", "130.93587`9.000000000000002", 
     ",", "131.93375`9.000000000000002", ",", "132.929782`9.000000000000002", 
     ",", "133.928353`9.000000000000002", ",", "134.924876`9.000000000000002",
      ",", "135.923565829`11.999999999999998", ",", 
     "136.920479493`11.999999999999996", ",", 
     "137.919548281`11.999999999999996", ",", 
     "138.916804082`12.000000000000004", ",", 
     "139.916041789`11.999999999999998", ",", 
     "140.913555054`11.999999999999998", ",", "141.912874471`12.", ",", 
     "142.910932616`11.999999999999998", ",", 
     "143.912590843`11.999999999999998", ",", 
     "144.912749023`12.000000000000004", ",", 
     "145.914696305`12.000000000000004", ",", "146.915138545`12.", ",", 
     "147.917474618`11.999999999999996", ",", 
     "148.918334155`12.000000000000004", ",", "149.920983561`12.", ",", 
     "150.921206973`11.999999999999998", ",", 
     "151.923496795`12.000000000000004", ",", 
     "152.924116889`11.999999999999998", ",", 
     "153.926463943`11.999999999999998", ",", 
     "154.928101267`12.000000000000004", ",", 
     "155.931056736`11.999999999999998", ",", "156.933039369`12.", ",", 
     "157.936561407`11.999999999999998", ",", "158.93897`9.000000000000002", 
     ",", "159.94299`9.000000000000002", ",", "160.94586`9.000000000000002", 
     ",", "161.95029`9.000000000000002", ",", "162.95368`9.000000000000002", 
     ",", "151.919732425`12.000000000000004", ",", 
     "127.95808`9.000000000000002", ",", "128.95464`9.000000000000002", ",", 
     "129.94892`9.000000000000002", ",", "130.94611`9.000000000000002", ",", 
     "131.94069`9.000000000000002", ",", "132.93867`9.000000000000002", ",", 
     "133.93397`9.000000000000002", ",", "134.93252`7.999999999999999", ",", 
     "135.928275527`12.", ",", "136.926971746`12.000000000000004", ",", 
     "137.923243961`11.999999999999998", ",", 
     "138.922296605`12.000000000000004", ",", 
     "139.918994687`12.000000000000004", ",", 
     "140.918476488`12.000000000000004", ",", 
     "141.915197641`11.999999999999998", ",", 
     "142.914628338`11.999999999999996", ",", "143.911999478`12.", ",", 
     "144.913410353`12.000000000000004", ",", 
     "145.9130409`10.000000000000004", ",", 
     "146.914897923`11.999999999999998", ",", 
     "147.914822674`12.000000000000004", ",", 
     "148.917184735`11.999999999999996", ",", 
     "149.917275539`12.000000000000004", ",", 
     "150.919932409`12.000000000000004", ",", 
     "151.919732425`12.000000000000004", ",", 
     "152.922097356`12.000000000000004", ",", 
     "153.922209273`12.000000000000004", ",", 
     "154.924640161`11.999999999999998", ",", 
     "155.925527887`12.000000000000004", ",", 
     "156.928358717`12.000000000000004", ",", 
     "157.929991317`11.999999999999998", ",", 
     "158.933211271`11.999999999999998", ",", "159.93514`9.000000000000002", 
     ",", "160.93883`9.000000000000002", ",", "161.94122`9.000000000000002", 
     ",", "162.94536`9.000000000000002", ",", "163.94828`9.000000000000002", 
     ",", "164.95298`9.000000000000002", ",", "152.921230339`12.", ",", 
     "129.963569`9.000000000000002", ",", "130.957753`9.000000000000002", ",",
      "131.95437`9.000000000000002", ",", "132.94924`9.000000000000002", ",", 
     "133.94651`9.000000000000002", ",", "134.94182`9.000000000000002", ",", 
     "135.9396`9.000000000000002", ",", "136.93557`9.000000000000002", ",", 
     "137.933709`9.000000000000002", ",", "138.92979228`10.999999999999996", 
     ",", "139.928087607`11.999999999999998", ",", 
     "140.92493072`10.999999999999996", ",", 
     "141.923434945`11.999999999999998", ",", 
     "142.920297509`11.999999999999998", ",", 
     "143.918816823`11.999999999999996", ",", 
     "144.916265237`11.999999999999996", ",", 
     "145.917205817`12.000000000000004", ",", 
     "146.916746111`12.000000000000004", ",", 
     "147.918085895`11.999999999999998", ",", 
     "148.917931238`12.000000000000004", ",", 
     "149.919701819`11.999999999999998", ",", 
     "150.919850161`11.999999999999998", ",", 
     "151.921744534`11.999999999999996", ",", "152.921230339`12.", ",", 
     "153.922979237`11.999999999999996", ",", "154.92289326`11.", ",", 
     "155.924752249`11.999999999999998", ",", 
     "156.925423647`12.000000000000004", ",", 
     "157.927845302`11.999999999999998", ",", 
     "158.929088861`11.999999999999998", ",", "159.931971`9.000000000000002", 
     ",", "160.93368`9.000000000000002", ",", "161.93704`9.000000000000002", 
     ",", "162.93921`9.000000000000002", ",", "163.94299`9.000000000000002", 
     ",", "164.94572`9.000000000000002", ",", "165.94997`9.000000000000002", 
     ",", "166.95321`9.000000000000002", ",", 
     "157.924103912`11.999999999999998", ",", "133.95537`9.000000000000002", 
     ",", "134.95257`9.000000000000002", ",", "135.94734`9.000000000000002", 
     ",", "136.94502`9.000000000000002", ",", "137.94012`9.000000000000002", 
     ",", "138.93824`9.000000000000002", ",", "139.933674`9.000000000000002", 
     ",", "140.932126`9.000000000000002", ",", "141.928116`9.000000000000002",
      ",", "142.92674951`11.", ",", "143.922963`9.000000000000002", ",", 
     "144.921709252`11.999999999999998", ",", 
     "145.918310608`12.000000000000004", ",", "146.91909442`11.", ",", 
     "147.918114524`12.000000000000004", ",", 
     "148.919340915`11.999999999999998", ",", 
     "149.918658876`11.999999999999998", ",", 
     "150.920348482`11.999999999999998", ",", 
     "151.919790996`12.000000000000004", ",", "152.921749543`12.", ",", 
     "153.920865598`12.000000000000004", ",", 
     "154.922622022`12.000000000000004", ",", 
     "155.922122743`12.000000000000004", ",", 
     "156.923960135`11.999999999999998", ",", 
     "157.924103912`11.999999999999998", ",", 
     "158.926388658`11.999999999999996", ",", 
     "159.927054146`12.000000000000004", ",", 
     "160.929669211`11.999999999999998", ",", 
     "161.930984751`12.000000000000004", ",", "162.93399`9.000000000000002", 
     ",", "163.93586`9.000000000000002", ",", "164.93938`9.000000000000002", 
     ",", "165.9416`9.000000000000002", ",", "166.94557`9.000000000000002", 
     ",", "167.94836`9.000000000000002", ",", "168.95287`9.000000000000002", 
     ",", "158.925346757`11.999999999999998", ",", 
     "135.96138`9.000000000000002", ",", "136.95598`9.000000000000002", ",", 
     "137.95316`9.000000000000002", ",", "138.94829`9.000000000000002", ",", 
     "139.945805049`11.999999999999998", ",", "140.941448`9.000000000000002", 
     ",", "141.938744`9.000000000000002", ",", "142.935121`9.000000000000002",
      ",", "143.933045`9.000000000000002", ",", 
     "144.929274`9.000000000000002", ",", "145.927246584`11.999999999999998", 
     ",", "146.924044585`12.000000000000004", ",", "147.924271701`12.", ",", 
     "148.923245909`11.999999999999996", ",", 
     "149.923659686`12.000000000000004", ",", 
     "150.923102543`12.000000000000004", ",", 
     "151.924074438`12.000000000000004", ",", 
     "152.923434588`12.000000000000004", ",", 
     "153.924678019`11.999999999999998", ",", 
     "154.923505236`11.999999999999998", ",", 
     "155.924747213`11.999999999999998", ",", 
     "156.924024604`12.000000000000004", ",", 
     "157.925413137`11.999999999999998", ",", 
     "158.925346757`11.999999999999998", ",", 
     "159.927167606`11.999999999999996", ",", "160.927569919`12.", ",", 
     "161.929488234`12.000000000000004", ",", 
     "162.930647536`11.999999999999998", ",", 
     "163.933350838`11.999999999999998", ",", "164.93488`9.000000000000002", 
     ",", "165.937991959`11.999999999999998", ",", 
     "166.94005`9.000000000000002", ",", "167.94364`9.000000000000002", ",", 
     "168.94622`9.000000000000002", ",", "169.95025`9.000000000000002", ",", 
     "170.9533`9.000000000000002", ",", "163.929174751`11.999999999999998", 
     ",", "137.96249`9.000000000000002", ",", "138.95954`9.000000000000002", 
     ",", "139.95401`9.000000000000002", ",", "140.95135`9.000000000000002", 
     ",", "141.946366`9.000000000000002", ",", "142.94383`9.000000000000002", 
     ",", "143.939254`9.000000000000002", ",", "144.937425`9.000000000000002",
      ",", "145.932845369`11.999999999999996", ",", "146.9310915`10.", ",", 
     "147.927149831`12.000000000000004", ",", 
     "148.927304787`11.999999999999996", ",", "149.925585184`12.", ",", 
     "150.926184601`12.000000000000004", ",", "151.9247183`9.999999999999998",
      ",", "152.92576467`11.", ",", "153.924424457`11.999999999999998", ",", 
     "154.925753775`11.999999999999998", ",", "155.92428311`11.", ",", 
     "156.925466095`11.999999999999998", ",", 
     "157.924409487`12.000000000000004", ",", 
     "158.925739214`12.000000000000004", ",", 
     "159.925197517`11.999999999999996", ",", "160.926933364`12.", ",", 
     "161.926798447`12.", ",", "162.928731159`12.000000000000004", ",", 
     "163.929174751`11.999999999999998", ",", 
     "164.931703333`11.999999999999998", ",", 
     "165.932806741`11.999999999999998", ",", 
     "166.935655462`11.999999999999998", ",", 
     "167.937128769`11.999999999999998", ",", 
     "168.940307614`11.999999999999998", ",", "169.94239`9.000000000000002", 
     ",", "170.9462`9.000000000000002", ",", "171.94876`9.000000000000002", 
     ",", "172.953`9.000000000000002", ",", "164.93032207`11.", ",", 
     "139.968539`9.000000000000002", ",", "140.963098`9.000000000000002", ",",
      "141.95977`9.000000000000002", ",", "142.95461`9.000000000000002", ",", 
     "143.95148`9.000000000000002", ",", "144.9472`9.000000000000002", ",", 
     "145.94464`9.000000000000002", ",", "146.940056`9.000000000000002", ",", 
     "147.937718`9.000000000000002", ",", "148.933774771`11.999999999999998", 
     ",", "149.933496182`11.999999999999998", ",", 
     "150.931688142`12.000000000000004", ",", 
     "151.931713714`11.999999999999998", ",", 
     "152.930198789`12.000000000000004", ",", 
     "153.930601579`12.000000000000004", ",", 
     "154.929103491`12.000000000000004", ",", "155.929839`9.000000000000002", 
     ",", "156.928256188`12.000000000000004", ",", 
     "157.928941007`11.999999999999998", ",", 
     "158.927711959`11.999999999999998", ",", 
     "159.928729478`12.000000000000004", ",", 
     "160.927854776`12.000000000000004", ",", 
     "161.929095504`12.000000000000004", ",", 
     "162.928733903`12.000000000000004", ",", 
     "163.930233507`12.000000000000004", ",", "164.93032207`11.", ",", 
     "165.932284162`11.999999999999998", ",", 
     "166.933132633`11.999999999999998", ",", 
     "167.935515708`12.000000000000004", ",", 
     "168.936872273`11.999999999999998", ",", 
     "169.939618929`12.000000000000004", ",", "170.94146515`11.", ",", 
     "171.94482`9.000000000000002", ",", "172.94729`9.000000000000002", ",", 
     "173.95115`9.000000000000002", ",", "174.95405`9.000000000000002", ",", 
     "165.930293061`12.", ",", "142.96634`9.000000000000002", ",", 
     "143.96038`9.000000000000002", ",", "144.95739`9.000000000000002", ",", 
     "145.952`9.000000000000002", ",", "146.94949`9.000000000000002", ",", 
     "147.94455`9.000000000000002", ",", "148.942306`9.000000000000002", ",", 
     "149.937913839`12.000000000000004", ",", 
     "150.937448903`11.999999999999998", ",", 
     "151.935050389`11.999999999999996", ",", 
     "152.935063492`12.000000000000004", ",", 
     "153.932783081`11.999999999999998", ",", "154.933208949`12.", ",", 
     "155.931064698`11.999999999999998", ",", "156.931916`9.000000000000002", 
     ",", "157.929893474`11.999999999999998", ",", 
     "158.930684066`12.000000000000004", ",", 
     "159.929083292`11.999999999999998", ",", 
     "160.929995309`12.000000000000004", ",", 
     "161.928778264`11.999999999999996", ",", 
     "162.930032749`11.999999999999998", ",", 
     "163.929200229`12.000000000000004", ",", 
     "164.930726003`12.000000000000004", ",", "165.930293061`12.", ",", 
     "166.932048159`12.000000000000004", ",", "167.932370224`12.", ",", 
     "168.934590364`12.", ",", "169.935464312`11.999999999999998", ",", 
     "170.938029808`11.999999999999996", ",", 
     "171.939356113`12.000000000000004", ",", "172.9424`9.000000000000002", 
     ",", "173.94423`9.000000000000002", ",", "174.94777`9.000000000000002", 
     ",", "175.95008`9.000000000000002", ",", "176.95405`9.000000000000002", 
     ",", "168.93421325`11.000000000000005", ",", 
     "144.970073`9.000000000000002", ",", "145.966425`9.000000000000002", ",",
      "146.960961`9.000000000000002", ",", "147.95784`9.000000000000002", ",",
      "148.95272`9.000000000000002", ",", "149.94996`9.000000000000002", ",", 
     "150.94548349`11.000000000000005", ",", "151.944422`9.000000000000002", 
     ",", "152.942012112`12.000000000000004", ",", 
     "153.941567808`11.999999999999998", ",", 
     "154.939199459`12.000000000000004", ",", 
     "155.938979933`12.000000000000004", ",", "156.936973`9.000000000000002", 
     ",", "157.936979525`12.000000000000004", ",", 
     "158.934975`9.000000000000002", ",", "159.935262801`11.999999999999998", 
     ",", "160.933549`9.000000000000002", ",", 
     "161.933994682`11.999999999999996", ",", 
     "162.932651124`12.000000000000004", ",", "163.93356`7.999999999999999", 
     ",", "164.932435492`12.000000000000004", ",", 
     "165.933554131`12.000000000000004", ",", 
     "166.932851622`11.999999999999996", ",", 
     "167.934172776`11.999999999999998", ",", 
     "168.93421325`11.000000000000005", ",", 
     "169.935801397`12.000000000000004", ",", "170.93642944`11.", ",", 
     "171.938400044`12.", ",", "172.939603607`11.999999999999998", ",", 
     "173.942168605`12.", ",", "174.943836853`11.999999999999996", ",", 
     "175.946994685`11.999999999999996", ",", "176.94904`9.000000000000002", 
     ",", "177.95264`9.000000000000002", ",", "178.95534`9.000000000000002", 
     ",", "173.938862089`11.999999999999996", ",", 
     "147.96742`9.000000000000002", ",", "148.96404`9.000000000000002", ",", 
     "149.95842`9.000000000000002", ",", "150.955400769`11.999999999999998", 
     ",", "151.950288919`11.999999999999998", ",", 
     "152.94948`9.000000000000002", ",", "153.946393928`11.999999999999998", 
     ",", "154.945782332`12.000000000000004", ",", 
     "155.942818215`12.000000000000004", ",", 
     "156.942627848`12.000000000000004", ",", 
     "157.939865617`12.000000000000004", ",", "158.940050099`12.", ",", 
     "159.937552344`11.999999999999998", ",", 
     "160.937901678`11.999999999999996", ",", 
     "161.93576821`11.000000000000005", ",", 
     "162.936334305`12.000000000000004", ",", 
     "163.934489416`12.000000000000004", ",", "164.935279`9.000000000000002", 
     ",", "165.933882042`11.999999999999998", ",", 
     "166.934949605`12.000000000000004", ",", 
     "167.933896895`11.999999999999998", ",", 
     "168.935189802`12.000000000000004", ",", 
     "169.934761837`11.999999999999998", ",", 
     "170.936325799`11.999999999999998", ",", "171.936381469`12.", ",", 
     "172.938210787`11.999999999999998", ",", 
     "173.938862089`11.999999999999996", ",", "174.94127645`11.", ",", 
     "175.942571683`12.000000000000004", ",", 
     "176.945260822`11.999999999999998", ",", "177.94664668`11.", ",", 
     "178.95017`9.000000000000002", ",", "179.95233`9.000000000000002", ",", 
     "180.95615`9.000000000000002", ",", "174.940771819`12.000000000000004", 
     ",", "149.973228`9.000000000000002", ",", "150.967577`9.000000000000002",
      ",", "151.96412`9.000000000000002", ",", 
     "152.958767331`12.000000000000004", ",", "153.957522`9.000000000000002", 
     ",", "154.954316216`12.000000000000004", ",", 
     "155.953032523`11.999999999999998", ",", "156.9500983`10.", ",", 
     "157.949313283`11.999999999999996", ",", 
     "158.946628776`12.000000000000004", ",", "159.946033`9.000000000000002", 
     ",", "160.943572`9.000000000000002", ",", "161.943277288`12.", ",", 
     "162.941179`9.000000000000002", ",", "163.941339`9.000000000000002", ",",
      "164.939406724`12.", ",", "165.939859`9.000000000000002", ",", 
     "166.93827`7.999999999999999", ",", "167.938739111`12.000000000000004", 
     ",", "168.937651439`12.", ",", "169.938474968`12.000000000000004", ",", 
     "170.937913136`12.000000000000004", ",", 
     "171.939085669`11.999999999999998", ",", 
     "172.938930602`11.999999999999998", ",", "173.94033748`11.", ",", 
     "174.940771819`12.000000000000004", ",", "175.94268631`11.", ",", 
     "176.943758055`12.", ",", "177.945954559`12.", ",", "178.947327443`12.", 
     ",", "179.94988116`11.", ",", "180.95197`9.000000000000002", ",", 
     "181.95504`9.000000000000002", ",", "182.95757`9.000000000000002", ",", 
     "183.96091`9.000000000000002", ",", "179.946549953`12.000000000000004", 
     ",", "152.97069`9.000000000000002", ",", "153.96486`9.000000000000002", 
     ",", "154.96339`9.000000000000002", ",", 
     "155.959364025`12.000000000000004", ",", "156.958396`9.000000000000002", 
     ",", "157.954799366`12.", ",", "158.95399487`11.000000000000005", ",", 
     "159.950684379`11.999999999999996", ",", 
     "160.950274844`12.000000000000004", ",", 
     "161.947210498`12.000000000000004", ",", "162.947089`9.000000000000002", 
     ",", "163.944367284`11.999999999999996", ",", 
     "164.944567`9.000000000000002", ",", "165.94218`7.999999999999999", ",", 
     "166.9426`7.000000000000001", ",", "167.940568`9.000000000000002", ",", 
     "168.941259`9.000000000000002", ",", "169.939609`9.000000000000002", ",",
      "170.940492`9.000000000000002", ",", "171.939448301`11.999999999999996",
      ",", "172.940513`9.000000000000002", ",", 
     "173.940046178`12.000000000000004", ",", 
     "174.941509181`11.999999999999998", ",", 
     "175.941408631`11.999999999999996", ",", 
     "176.943220651`11.999999999999996", ",", 
     "177.943698766`12.000000000000004", ",", 
     "178.945816145`12.000000000000004", ",", 
     "179.946549953`12.000000000000004", ",", 
     "180.949101246`11.999999999999998", ",", 
     "181.950554096`11.999999999999998", ",", 
     "182.953530439`12.000000000000004", ",", 
     "183.955446515`12.000000000000004", ",", "184.95882`9.000000000000002", 
     ",", "185.96089`9.000000000000002", ",", "186.96459`9.000000000000002", 
     ",", "187.96685`9.000000000000002", ",", 
     "180.947995763`12.000000000000004", ",", "154.974592`9.000000000000002", 
     ",", "155.972303`9.000000000000002", ",", 
     "156.968192445`12.000000000000004", ",", "157.966699`9.000000000000002", 
     ",", "158.963018173`11.999999999999998", ",", 
     "159.961486056`12.000000000000004", ",", "160.958417`9.000000000000002", 
     ",", "161.957291859`12.000000000000004", ",", 
     "162.954330271`11.999999999999998", ",", "163.953534`9.000000000000002", 
     ",", "164.950772514`12.000000000000004", ",", 
     "165.950512`9.000000000000002", ",", "166.948093`9.000000000000002", ",",
      "167.948047`9.000000000000002", ",", "168.946011`9.000000000000002", 
     ",", "169.946175`9.000000000000002", ",", "170.944476`9.000000000000002",
      ",", "171.944895`9.000000000000002", ",", "172.94375`7.999999999999999",
      ",", "173.944454`9.000000000000002", ",", 
     "174.943737`9.000000000000002", ",", "175.944857`9.000000000000002", ",",
      "176.944472403`12.000000000000004", ",", 
     "177.945778221`12.000000000000004", ",", 
     "178.945929535`11.999999999999998", ",", "179.947464831`12.", ",", 
     "180.947995763`12.000000000000004", ",", 
     "181.950151849`11.999999999999996", ",", 
     "182.951372616`11.999999999999998", ",", 
     "183.954007966`11.999999999999998", ",", 
     "184.955559375`12.000000000000004", ",", 
     "185.958552023`11.999999999999996", ",", "186.96053`9.000000000000002", 
     ",", "187.9637`9.000000000000002", ",", "188.96583`9.000000000000002", 
     ",", "189.96923`9.000000000000002", ",", 
     "183.950931188`12.000000000000004", ",", "157.974562`9.000000000000002", 
     ",", "158.972918`9.000000000000002", ",", 
     "159.968478805`12.000000000000004", ",", "160.967357`9.000000000000002", 
     ",", "161.963497417`12.000000000000004", ",", 
     "162.962523542`12.000000000000004", ",", 
     "163.958954382`12.000000000000004", ",", 
     "164.958279949`11.999999999999998", ",", 
     "165.955027253`11.999999999999996", ",", 
     "166.954816014`11.999999999999996", ",", 
     "167.951808394`12.000000000000004", ",", "168.95177879`11.", ",", 
     "169.949228482`11.999999999999998", ",", "170.949451`9.000000000000002", 
     ",", "171.947292`9.000000000000002", ",", "172.947689`9.000000000000002",
      ",", "173.946079`9.000000000000002", ",", 
     "174.946717`9.000000000000002", ",", "175.945634`9.000000000000002", ",",
      "176.946643`9.000000000000002", ",", "177.945876236`11.999999999999996",
      ",", "178.947070447`12.000000000000004", ",", 
     "179.946704459`11.999999999999996", ",", 
     "180.948197248`12.000000000000004", ",", "181.948204156`12.", ",", 
     "182.950222951`12.", ",", "183.950931188`12.000000000000004", ",", 
     "184.953419264`11.999999999999998", ",", 
     "185.954364127`11.999999999999996", ",", 
     "186.957160466`12.000000000000004", ",", 
     "187.958489105`12.000000000000004", ",", 
     "188.961912868`12.000000000000004", ",", 
     "189.963181378`11.999999999999998", ",", "190.9666`9.000000000000002", 
     ",", "191.96817`9.000000000000002", ",", "186.955753109`12.", ",", 
     "159.982115`9.000000000000002", ",", "160.977589119`12.000000000000004", 
     ",", "161.976002`9.000000000000002", ",", 
     "162.972080535`12.000000000000004", ",", "163.970323`9.000000000000002", 
     ",", "164.967088557`12.", ",", "165.965808`9.000000000000002", ",", 
     "166.962601`9.000000000000002", ",", "167.961572608`12.000000000000004", 
     ",", "168.958791096`11.999999999999998", ",", 
     "169.958220071`11.999999999999996", ",", "170.955716`9.000000000000002", 
     ",", "171.955422961`12.000000000000004", ",", 
     "172.953243`9.000000000000002", ",", "173.953115`9.000000000000002", ",",
      "174.951381`9.000000000000002", ",", "175.951623`9.000000000000002", 
     ",", "176.950328`9.000000000000002", ",", "177.950989`9.000000000000002",
      ",", "178.949987641`12.000000000000004", ",", 
     "179.950789084`11.999999999999998", ",", "180.950067916`12.", ",", 
     "181.95121008`11.", ",", "182.950819841`11.999999999999998", ",", 
     "183.952520756`12.", ",", "184.952954982`12.", ",", 
     "185.954986084`11.999999999999998", ",", "186.955753109`12.", ",", 
     "187.958114438`11.999999999999998", ",", 
     "188.959229007`11.999999999999998", ",", 
     "189.961817977`11.999999999999998", ",", 
     "190.963125242`12.000000000000004", ",", "191.96596`9.000000000000002", 
     ",", "192.96747`9.000000000000002", ",", "193.97042`9.000000000000002", 
     ",", "191.96148069`11.", ",", "161.984431`9.000000000000002", ",", 
     "162.98269`9.000000000000002", ",", "163.978035649`12.000000000000004", 
     ",", "164.976762`9.000000000000002", ",", 
     "165.972690753`12.000000000000004", ",", 
     "166.971547969`11.999999999999998", ",", 
     "167.967803678`12.000000000000004", ",", "168.96701927`11.", ",", 
     "169.963577028`12.000000000000004", ",", 
     "170.963184819`12.000000000000004", ",", "171.960023303`12.", ",", 
     "172.959808409`11.999999999999998", ",", "173.957062202`12.", ",", 
     "174.956945835`12.000000000000004", ",", "175.954806`9.000000000000002", 
     ",", "176.954965324`12.000000000000004", ",", 
     "177.953251241`11.999999999999998", ",", 
     "178.953816017`12.000000000000004", ",", 
     "179.952378803`12.000000000000004", ",", "180.953244`9.000000000000002", 
     ",", "181.952110186`11.999999999999998", ",", 
     "182.953126102`11.999999999999998", ",", "183.952489071`12.", ",", 
     "184.954042265`11.999999999999998", ",", 
     "185.953838158`11.999999999999998", ",", 
     "186.955750458`11.999999999999996", ",", "187.955838228`12.", ",", 
     "188.95814747`10.999999999999996", ",", 
     "189.958447048`12.000000000000004", ",", 
     "190.960929718`11.999999999999998", ",", "191.96148069`11.", ",", 
     "192.964151563`11.999999999999998", ",", 
     "193.965182083`12.000000000000004", ",", 
     "194.968126661`11.999999999999998", ",", 
     "195.969639333`12.000000000000004", ",", 
     "192.96292643`11.000000000000005", ",", "163.992201`9.000000000000002", 
     ",", "164.98752`9.000000000000002", ",", "165.985824`9.000000000000002", 
     ",", "166.981665156`12.000000000000004", ",", 
     "167.979881`9.000000000000002", ",", "168.976294942`11.999999999999998", 
     ",", "169.974965`9.000000000000002", ",", 
     "170.971626042`12.000000000000004", ",", "171.970456`9.000000000000002", 
     ",", "172.967501739`11.999999999999998", ",", 
     "173.966861045`11.999999999999996", ",", 
     "174.964112895`12.000000000000004", ",", 
     "175.963648688`12.000000000000004", ",", "176.9613015`9.999999999999998",
      ",", "177.961082`9.000000000000002", ",", 
     "178.959122266`12.000000000000004", ",", "179.959229446`12.", ",", 
     "180.957625297`12.000000000000004", ",", 
     "181.958076296`12.000000000000004", ",", 
     "182.956846458`11.999999999999998", ",", "183.957476`9.000000000000002", 
     ",", "184.956698`9.000000000000002", ",", 
     "185.957946104`12.000000000000004", ",", 
     "186.957363361`11.999999999999998", ",", 
     "187.958853121`11.999999999999998", ",", 
     "188.958718935`11.999999999999996", ",", 
     "189.960545968`11.999999999999998", ",", 
     "190.960594046`12.000000000000004", ",", 
     "191.962605012`12.000000000000004", ",", 
     "192.96292643`11.000000000000005", ",", 
     "193.965078378`12.000000000000004", ",", 
     "194.965979573`12.000000000000004", ",", 
     "195.968396542`12.000000000000004", ",", "196.969653285`12.", ",", 
     "197.97228`9.000000000000002", ",", "198.973804583`11.999999999999998", 
     ",", "194.964791134`11.999999999999998", ",", 
     "165.994855`9.000000000000002", ",", "166.992979`9.000000000000002", ",",
      "167.988150742`11.999999999999998", ",", "168.986715`9.000000000000002",
      ",", "169.982495289`12.000000000000004", ",", 
     "170.981244542`12.000000000000004", ",", 
     "171.977347128`11.999999999999998", ",", 
     "172.976444754`11.999999999999998", ",", 
     "173.972818767`11.999999999999996", ",", 
     "174.972420552`11.999999999999996", ",", "175.968944622`12.", ",", 
     "176.968469481`11.999999999999998", ",", 
     "177.965648724`11.999999999999998", ",", 
     "178.965363404`12.000000000000004", ",", 
     "179.963031477`12.000000000000004", ",", 
     "180.963097285`12.000000000000004", ",", 
     "181.961170656`11.999999999999996", ",", 
     "182.961596703`12.000000000000004", ",", 
     "183.959922251`11.999999999999996", ",", "184.960619`9.000000000000002", 
     ",", "185.959350813`12.000000000000004", ",", 
     "186.960587`9.000000000000002", ",", "187.959395391`12.000000000000004", 
     ",", "188.960833686`12.000000000000004", ",", 
     "189.959931655`11.999999999999998", ",", "190.961676661`12.", ",", 
     "191.961038005`11.999999999999996", ",", 
     "192.962987401`11.999999999999996", ",", 
     "193.962680253`11.999999999999996", ",", 
     "194.964791134`11.999999999999998", ",", 
     "195.964951521`12.000000000000004", ",", "196.967340182`12.", ",", 
     "197.96789279`11.", ",", "198.970593094`12.000000000000004", ",", 
     "199.971440677`11.999999999999998", ",", 
     "200.974512868`11.999999999999998", ",", "201.97574`9.000000000000002", 
     ",", "196.966568662`12.000000000000004", ",", 
     "168.99808`9.000000000000002", ",", "169.996122`9.000000000000002", ",", 
     "170.991878881`12.", ",", "171.990035`9.000000000000002", ",", 
     "172.98623738`11.", ",", "173.984761`9.000000000000002", ",", 
     "174.981274107`11.999999999999998", ",", "175.980099`9.000000000000002", 
     ",", "176.976864908`11.999999999999998", ",", "177.97603192`11.", ",", 
     "178.973212812`12.", ",", "179.972521124`12.000000000000004", ",", 
     "180.970079048`11.999999999999998", ",", 
     "181.969617874`11.999999999999998", ",", 
     "182.967593034`12.000000000000004", ",", 
     "183.967451524`12.000000000000004", ",", 
     "184.965789411`11.999999999999998", ",", 
     "185.965952703`11.999999999999998", ",", 
     "186.964567541`11.999999999999996", ",", 
     "187.965323661`11.999999999999998", ",", 
     "188.963948286`11.999999999999998", ",", 
     "189.964700339`11.999999999999998", ",", 
     "190.963704225`11.999999999999998", ",", 
     "191.964812953`11.999999999999998", ",", 
     "192.964149715`12.000000000000004", ",", "193.96536525`11.", ",", 
     "194.96503464`11.", ",", "195.966569813`12.000000000000004", ",", 
     "196.966568662`12.000000000000004", ",", 
     "197.968242303`12.000000000000004", ",", 
     "198.968765193`11.999999999999996", ",", 
     "199.970725647`12.000000000000004", ",", "200.97165724`11.", ",", 
     "201.973805838`11.999999999999998", ",", 
     "202.975154542`12.000000000000004", ",", "203.977724`9.000000000000002", 
     ",", "204.97987`9.000000000000002", ",", 
     "201.970643011`12.000000000000004", ",", "171.00376`9.000000000000002", 
     ",", "171.998832686`12.", ",", "172.997242`9.000000000000002", ",", 
     "173.992863695`12.", ",", "174.99142327`11.000000000000005", ",", 
     "175.98735458`11.", ",", "176.986279158`12.", ",", "177.982483143`12.", 
     ",", "178.981833861`11.999999999999996", ",", 
     "179.978266394`11.999999999999998", ",", 
     "180.977819311`11.999999999999998", ",", 
     "181.974689964`12.000000000000004", ",", 
     "182.974449841`11.999999999999998", ",", 
     "183.971713051`12.000000000000004", ",", 
     "184.971899086`11.999999999999998", ",", "185.96936179`11.", ",", 
     "186.969814236`11.999999999999996", ",", "187.967577049`12.", ",", 
     "188.968190034`12.000000000000004", ",", 
     "189.966322449`12.000000000000004", ",", 
     "190.967157105`12.000000000000004", ",", 
     "191.965634327`12.000000000000004", ",", 
     "192.966665421`12.000000000000004", ",", 
     "193.965439409`12.000000000000004", ",", 
     "194.966720113`11.999999999999996", ",", 
     "195.965832649`11.999999999999998", ",", 
     "196.967212908`11.999999999999996", ",", 
     "197.966769032`11.999999999999998", ",", 
     "198.968279932`11.999999999999998", ",", 
     "199.968326004`12.000000000000004", ",", 
     "200.970302268`11.999999999999996", ",", 
     "201.970643011`12.000000000000004", ",", "202.972872484`12.", ",", 
     "203.973493933`11.999999999999998", ",", 
     "204.976073386`11.999999999999996", ",", 
     "205.977514066`12.000000000000004", ",", 
     "206.982588545`12.000000000000004", ",", "207.98594`9.000000000000002", 
     ",", "208.99104`9.000000000000002", ",", "209.99451`9.000000000000002", 
     ",", "204.974427541`11.999999999999996", ",", 
     "176.00059`9.000000000000002", ",", "176.996427286`11.999999999999998", 
     ",", "177.994897`9.000000000000002", ",", "178.991089082`12.", ",", 
     "179.989906`9.000000000000002", ",", "180.986257447`11.999999999999998", 
     ",", "181.985667104`12.000000000000004", ",", 
     "182.982192802`11.999999999999998", ",", 
     "183.981873122`11.999999999999996", ",", 
     "184.978791305`12.000000000000004", ",", "185.978325`9.000000000000002", 
     ",", "186.975905897`11.999999999999998", ",", 
     "187.976009782`11.999999999999998", ",", 
     "188.973588428`12.000000000000004", ",", 
     "189.973877149`11.999999999999996", ",", 
     "190.971786154`12.000000000000004", ",", "191.972225`9.000000000000002", 
     ",", "192.970672`9.000000000000002", ",", "193.9712`7.000000000000001", 
     ",", "194.969774335`12.000000000000004", ",", "195.970481151`12.", ",", 
     "196.969574511`11.999999999999998", ",", "197.970483495`12.", ",", 
     "198.969877`9.000000000000002", ",", "199.970962672`12.000000000000004", 
     ",", "200.970818891`11.999999999999998", ",", 
     "201.972105808`12.000000000000004", ",", "202.97234422`11.", ",", 
     "203.973863522`12.000000000000004", ",", 
     "204.974427541`11.999999999999996", ",", "205.97611032`11.", ",", 
     "206.977419429`11.999999999999998", ",", "207.9820187`10.", ",", 
     "208.985358952`12.000000000000004", ",", 
     "209.990073689`12.000000000000004", ",", "210.993477`9.000000000000002", 
     ",", "211.998228`9.000000000000002", ",", 
     "207.976652071`11.999999999999996", ",", 
     "178.003830191`11.999999999999998", ",", "179.00215`9.000000000000002", 
     ",", "179.997918173`12.000000000000004", ",", 
     "180.996623958`11.999999999999998", ",", 
     "181.992671842`11.999999999999998", ",", 
     "182.991874629`11.999999999999998", ",", 
     "183.988142339`11.999999999999996", ",", 
     "184.987609944`11.999999999999996", ",", "185.984238945`12.", ",", 
     "186.98391837`11.", ",", "187.980874338`11.999999999999996", ",", 
     "188.980807`9.000000000000002", ",", "189.978081517`11.999999999999998", 
     ",", "190.978265`9.000000000000002", ",", 
     "191.975785171`12.000000000000004", ",", 
     "192.976173234`11.999999999999998", ",", "193.97401207`11.", ",", 
     "194.97454205`11.", ",", "195.972774109`12.000000000000004", ",", 
     "196.973431124`11.999999999999998", ",", 
     "197.972033959`11.999999999999998", ",", "198.97291665`11.", ",", 
     "199.971826675`11.999999999999996", ",", 
     "200.972884511`11.999999999999996", ",", 
     "201.972159133`11.999999999999998", ",", 
     "202.973390521`12.000000000000004", ",", 
     "203.973043589`11.999999999999996", ",", 
     "204.974481755`12.000000000000004", ",", 
     "205.974465278`11.999999999999998", ",", 
     "206.975896887`11.999999999999998", ",", 
     "207.976652071`11.999999999999996", ",", "208.98109012`11.", ",", 
     "209.984188527`11.999999999999998", ",", 
     "210.988736964`12.000000000000004", ",", 
     "211.991897543`11.999999999999998", ",", "212.996581499`12.", ",", 
     "213.999805408`11.999999999999996", ",", "215.004807`9.000000000000002", 
     ",", "208.980398734`12.", ",", "184.001124`9.000000000000002", ",", 
     "184.997625`9.000000000000002", ",", "185.996597625`11.999999999999998", 
     ",", "186.993157835`11.999999999999998", ",", "187.992265154`12.", ",", 
     "188.989199012`11.999999999999998", ",", 
     "189.988295129`12.000000000000004", ",", 
     "190.985786119`11.999999999999998", ",", 
     "191.985457954`12.000000000000004", ",", "192.982959771`12.", ",", 
     "193.98283396`10.999999999999996", ",", "194.980650737`12.", ",", 
     "195.980666509`11.999999999999996", ",", 
     "196.978864454`12.000000000000004", ",", "197.979206`9.000000000000002", 
     ",", "198.977671961`11.999999999999998", ",", "199.978131829`12.", ",", 
     "200.977009036`11.999999999999998", ",", 
     "201.977742324`12.000000000000004", ",", "202.976876001`12.", ",", 
     "203.977812736`11.999999999999996", ",", "204.977389366`12.", ",", 
     "205.97849913`11.000000000000005", ",", 
     "206.978470679`11.999999999999998", ",", 
     "207.979742196`12.000000000000004", ",", "208.980398734`12.", ",", 
     "209.984120371`11.999999999999998", ",", "210.98726946`11.", ",", 
     "211.991285724`11.999999999999998", ",", 
     "212.994384666`11.999999999999998", ",", 
     "213.998711539`12.000000000000004", ",", 
     "215.001769776`11.999999999999998", ",", 
     "216.006305943`11.999999999999998", ",", "217.00947`9.000000000000002", 
     ",", "218.014316`9.000000000000002", ",", 
     "208.982430435`12.000000000000004", ",", 
     "187.999422048`11.999999999999998", ",", 
     "188.998480562`12.000000000000004", ",", 
     "189.995101185`11.999999999999998", ",", 
     "190.994574485`12.000000000000004", ",", 
     "191.991335149`11.999999999999998", ",", 
     "192.991025275`12.000000000000004", ",", 
     "193.988185606`11.999999999999998", ",", 
     "194.988110728`11.999999999999998", ",", 
     "195.98553458`10.999999999999996", ",", 
     "196.98565963`10.999999999999996", ",", 
     "197.983388616`11.999999999999998", ",", 
     "198.983666063`11.999999999999996", ",", 
     "199.981798604`11.999999999999998", ",", 
     "200.982259764`11.999999999999998", ",", 
     "201.980757541`11.999999999999996", ",", 
     "202.981420103`11.999999999999998", ",", 
     "203.980318121`11.999999999999996", ",", "204.981203322`12.", ",", 
     "205.980481099`11.999999999999998", ",", "206.981593173`12.", ",", 
     "207.981245702`11.999999999999998", ",", 
     "208.982430435`12.000000000000004", ",", 
     "209.982873673`12.000000000000004", ",", 
     "210.986653154`11.999999999999996", ",", 
     "211.988867969`12.000000000000004", ",", "212.99285728`11.", ",", 
     "213.99520135`11.", ",", "214.999419988`11.999999999999998", ",", 
     "216.001915035`11.999999999999998", ",", 
     "217.006334796`11.999999999999998", ",", 
     "218.008973037`11.999999999999998", ",", "219.013744`9.000000000000002", 
     ",", "220.016602`9.000000000000002", ",", "210.987496271`12.", ",", 
     "192.999843112`11.999999999999998", ",", 
     "193.998725085`11.999999999999996", ",", 
     "194.996268098`12.000000000000004", ",", 
     "195.995788077`12.000000000000004", ",", "196.993189215`12.", ",", 
     "197.992837202`11.999999999999998", ",", "198.990532254`12.", ",", 
     "199.990351264`11.999999999999996", ",", "200.988416999`12.", ",", 
     "201.988630236`11.999999999999998", ",", 
     "202.986941984`11.999999999999998", ",", 
     "203.987251326`12.000000000000004", ",", 
     "204.986074483`11.999999999999998", ",", 
     "205.986667036`11.999999999999998", ",", 
     "206.985783502`11.999999999999998", ",", 
     "207.986589977`11.999999999999996", ",", 
     "208.986173143`11.999999999999998", ",", "209.98714771`11.", ",", 
     "210.987496271`12.", ",", "211.990744771`11.999999999999998", ",", 
     "212.992936646`12.", ",", "213.996371733`11.999999999999998", ",", 
     "214.99865257`11.", ",", "216.002423257`11.999999999999998", ",", 
     "217.004718822`11.999999999999998", ",", "218.008694336`12.", ",", 
     "219.011161691`12.000000000000004", ",", 
     "220.015407682`11.999999999999998", ",", "221.01805`9.000000000000002", 
     ",", "222.02233`9.000000000000002", ",", "223.02519`9.000000000000002", 
     ",", "222.017577738`12.000000000000004", ",", "195.005437696`12.", ",", 
     "196.002115223`11.999999999999996", ",", "197.001584351`12.", ",", 
     "197.998678663`12.000000000000004", ",", 
     "198.998370297`12.000000000000004", ",", "199.9956993`9.999999999999998",
      ",", "200.995628335`12.000000000000004", ",", 
     "201.993263492`11.999999999999998", ",", 
     "202.993386687`12.000000000000004", ",", 
     "203.99142874`10.999999999999996", ",", "204.991718799`12.", ",", 
     "205.990214104`11.999999999999998", ",", 
     "206.990734225`11.999999999999998", ",", 
     "207.98964247`11.000000000000005", ",", 
     "208.990414742`12.000000000000004", ",", 
     "209.989696216`11.999999999999998", ",", 
     "210.990600523`12.000000000000004", ",", 
     "211.990703529`11.999999999999998", ",", 
     "212.993882668`12.000000000000004", ",", 
     "213.995362554`12.000000000000004", ",", 
     "214.998745483`12.000000000000004", ",", "216.00027437`11.", ",", 
     "217.003927675`11.999999999999998", ",", 
     "218.005601256`11.999999999999996", ",", 
     "219.009480204`12.000000000000004", ",", 
     "220.011393981`11.999999999999998", ",", 
     "221.015536782`11.999999999999998", ",", 
     "222.017577738`12.000000000000004", ",", "223.02179`9.000000000000002", 
     ",", "224.02409`9.000000000000002", ",", "225.02844`9.000000000000002", 
     ",", "226.03089`9.000000000000002", ",", "227.035407`9.000000000000002", 
     ",", "228.037986`9.000000000000002", ",", 
     "222.01755173`11.000000000000005", ",", "199.007258147`12.", ",", 
     "200.00657249`11.", ",", "201.003860867`12.", ",", 
     "202.003372847`12.000000000000004", ",", 
     "203.000924647`11.999999999999996", ",", 
     "204.000653204`12.000000000000004", ",", "204.99859396`11.", ",", 
     "205.998666066`11.999999999999996", ",", 
     "206.996949414`11.999999999999998", ",", 
     "207.997138783`12.000000000000004", ",", 
     "208.995953555`11.999999999999998", ",", 
     "209.996407738`11.999999999999998", ",", 
     "210.995536544`12.000000000000004", ",", 
     "211.996202244`11.999999999999998", ",", 
     "212.996189081`12.000000000000004", ",", 
     "213.998971145`11.999999999999998", ",", 
     "215.000341497`11.999999999999998", ",", "216.00319799`11.", ",", 
     "217.004631951`12.", ",", "218.007578322`11.999999999999998", ",", 
     "219.009252149`11.999999999999996", ",", 
     "220.012327405`11.999999999999998", ",", "221.014254762`12.", ",", 
     "222.01755173`11.000000000000005", ",", 
     "223.019735857`11.999999999999998", ",", 
     "224.023249951`12.000000000000004", ",", 
     "225.025565414`12.000000000000004", ",", 
     "226.029386231`12.000000000000004", ",", 
     "227.031835938`11.999999999999998", ",", "228.035729`9.000000000000002", 
     ",", "229.038450228`12.000000000000004", ",", 
     "230.04251`9.000000000000002", ",", "231.04544`9.000000000000002", ",", 
     "232.049772`9.000000000000002", ",", "228.031070292`11.999999999999998", 
     ",", "202.009890686`12.000000000000004", ",", 
     "203.009271619`11.999999999999998", ",", 
     "204.006499668`11.999999999999998", ",", 
     "205.00626857`11.000000000000005", ",", 
     "206.00382727`11.000000000000005", ",", 
     "207.003798105`11.999999999999998", ",", "208.00183994`11.", ",", 
     "209.001991373`12.000000000000004", ",", "210.000494978`12.", ",", 
     "211.000897987`12.000000000000004", ",", 
     "211.999794499`12.000000000000004", ",", 
     "213.000383959`11.999999999999998", ",", 
     "214.000107894`11.999999999999996", ",", 
     "215.002719834`12.000000000000004", ",", "216.003533035`12.", ",", 
     "217.006320327`12.", ",", "218.00714023`11.", ",", 
     "219.010085078`11.999999999999998", ",", "220.011028384`12.", ",", 
     "221.013917338`11.999999999999998", ",", "222.01537453`11.", ",", 
     "223.018502171`12.000000000000004", ",", 
     "224.020211821`11.999999999999998", ",", 
     "225.023611564`12.000000000000004", ",", 
     "226.025409823`12.000000000000004", ",", 
     "227.029177842`12.000000000000004", ",", 
     "228.031070292`11.999999999999998", ",", "229.034957577`12.", ",", 
     "230.037056394`12.000000000000004", ",", "231.04122`9.000000000000002", 
     ",", "232.043638`9.000000000000002", ",", "233.04806`9.000000000000002", 
     ",", "234.050704`9.000000000000002", ",", 
     "227.027752127`11.999999999999998", ",", "206.01450498`11.", ",", 
     "207.011949748`12.000000000000004", ",", 
     "208.011551551`11.999999999999998", ",", 
     "209.009494863`12.000000000000004", ",", 
     "210.009435986`11.999999999999998", ",", "211.007734835`12.", ",", 
     "212.007813822`11.999999999999998", ",", 
     "213.006607643`11.999999999999998", ",", 
     "214.006901798`11.999999999999998", ",", "215.006453625`12.", ",", 
     "216.008720075`12.000000000000004", ",", "217.009346914`12.", ",", 
     "218.011641453`11.999999999999998", ",", 
     "219.012420389`12.000000000000004", ",", 
     "220.014762979`12.000000000000004", ",", 
     "221.015591248`11.999999999999998", ",", 
     "222.017843851`11.999999999999998", ",", 
     "223.019137468`11.999999999999996", ",", "224.021722866`12.", ",", 
     "225.023229585`12.000000000000004", ",", 
     "226.026098089`11.999999999999998", ",", 
     "227.027752127`11.999999999999998", ",", 
     "228.031021112`11.999999999999998", ",", "229.033015243`12.", ",", 
     "230.036294178`11.999999999999998", ",", 
     "231.038558786`12.000000000000004", ",", 
     "232.042027438`11.999999999999998", ",", "233.04455`9.000000000000002", 
     ",", "234.04842`9.000000000000002", ",", "235.051232`9.000000000000002", 
     ",", "236.055296`9.000000000000002", ",", 
     "232.038055325`11.999999999999998", ",", 
     "209.017715682`11.999999999999998", ",", 
     "210.015075342`11.999999999999996", ",", 
     "211.014928413`11.999999999999998", ",", 
     "212.012980288`11.999999999999996", ",", "213.01301014`11.", ",", 
     "214.01149977`11.", ",", "215.01173033`11.", ",", 
     "216.011062115`11.999999999999996", ",", 
     "217.013114328`11.999999999999998", ",", "218.013284499`12.", ",", 
     "219.015536895`12.", ",", "220.015747762`12.000000000000004", ",", 
     "221.018183674`11.999999999999996", ",", 
     "222.018468121`12.000000000000004", ",", 
     "223.020811448`12.000000000000004", ",", 
     "224.021466895`11.999999999999998", ",", 
     "225.023951021`11.999999999999996", ",", 
     "226.024903069`12.000000000000004", ",", 
     "227.02770407`11.000000000000005", ",", 
     "228.028741127`12.000000000000004", ",", "229.03176243`11.", ",", 
     "230.033133843`11.999999999999996", ",", 
     "231.036304343`11.999999999999998", ",", 
     "232.038055325`11.999999999999998", ",", 
     "233.041581843`11.999999999999998", ",", "234.04360123`11.", ",", 
     "235.047510074`12.000000000000004", ",", "236.04987`9.000000000000002", 
     ",", "237.053894`9.000000000000002", ",", "238.056496`9.000000000000002",
      ",", "231.03588399`11.000000000000005", ",", 
     "212.023204138`11.999999999999998", ",", 
     "213.02110934`10.999999999999996", ",", 
     "214.020918417`11.999999999999998", ",", "215.019185865`12.", ",", 
     "216.019109564`11.999999999999998", ",", 
     "217.018323986`12.000000000000004", ",", "218.020041889`12.", ",", 
     "219.019883143`12.", ",", "220.021875303`11.999999999999998", ",", 
     "221.021877983`12.", ",", "222.023742`9.000000000000002", ",", 
     "223.023962273`11.999999999999998", ",", 
     "224.025625738`12.000000000000004", ",", "225.026130678`12.", ",", 
     "226.027947753`11.999999999999998", ",", 
     "227.028805072`11.999999999999998", ",", 
     "228.031051376`12.000000000000004", ",", 
     "229.032096793`12.000000000000004", ",", 
     "230.034540754`11.999999999999996", ",", 
     "231.03588399`11.000000000000005", ",", 
     "232.038591592`12.000000000000004", ",", 
     "233.040247277`12.000000000000004", ",", 
     "234.043308058`11.999999999999998", ",", 
     "235.045443615`11.999999999999998", ",", 
     "236.048681284`11.999999999999998", ",", 
     "237.051145659`11.999999999999998", ",", 
     "238.05450271`10.999999999999996", ",", "239.05726`9.000000000000002", 
     ",", "240.06098`9.000000000000002", ",", 
     "238.050788247`11.999999999999998", ",", 
     "217.024368791`11.999999999999998", ",", 
     "218.023535671`11.999999999999998", ",", "219.02491916`11.", ",", 
     "220.024723`9.000000000000002", ",", "221.026399`9.000000000000002", ",",
      "222.026086`9.000000000000002", ",", "223.0277386`9.999999999999998", 
     ",", "224.027604778`11.999999999999998", ",", 
     "225.029390717`12.000000000000004", ",", 
     "226.029338702`11.999999999999998", ",", 
     "227.031156367`12.000000000000004", ",", 
     "228.031374006`11.999999999999998", ",", 
     "229.033505939`12.000000000000004", ",", 
     "230.033939784`12.000000000000004", ",", 
     "231.036293704`11.999999999999998", ",", 
     "232.037156152`11.999999999999996", ",", 
     "233.039635207`12.000000000000004", ",", 
     "234.040952088`11.999999999999998", ",", 
     "235.043929918`11.999999999999998", ",", 
     "236.045568006`11.999999999999998", ",", 
     "237.048730184`12.000000000000004", ",", 
     "238.050788247`11.999999999999998", ",", 
     "239.054293299`11.999999999999998", ",", 
     "240.056591988`11.999999999999998", ",", "241.06033`9.000000000000002", 
     ",", "242.062931`9.000000000000002", ",", 
     "237.048173444`12.000000000000004", ",", "225.033913933`12.", ",", 
     "226.035145`9.000000000000002", ",", "227.034956789`11.999999999999998", 
     ",", "228.03618`9.000000000000002", ",", 
     "229.036263808`12.000000000000004", ",", 
     "230.037827597`12.000000000000004", ",", 
     "231.038245085`11.999999999999998", ",", "232.040108`9.000000000000002", 
     ",", "233.040740546`12.000000000000004", ",", 
     "234.042895038`12.000000000000004", ",", 
     "235.044063267`11.999999999999998", ",", "236.0465696`9.999999999999998",
      ",", "237.048173444`12.000000000000004", ",", 
     "238.050946405`11.999999999999998", ",", 
     "239.052939025`12.000000000000004", ",", 
     "240.056162182`12.000000000000004", ",", 
     "241.058252431`12.000000000000004", ",", "242.06164118`11.", ",", 
     "243.064279`9.000000000000002", ",", "244.06785`9.000000000000002", ",", 
     "242.058742611`11.999999999999998", ",", 
     "228.038742328`12.000000000000004", ",", 
     "229.040150212`11.999999999999998", ",", 
     "230.039649886`12.000000000000004", ",", 
     "231.041101107`12.000000000000004", ",", 
     "232.041187097`11.999999999999998", ",", 
     "233.042997375`12.000000000000004", ",", 
     "234.043317076`12.000000000000004", ",", "235.04528605`11.", ",", 
     "236.046057964`12.000000000000004", ",", 
     "237.048409658`11.999999999999998", ",", 
     "238.049559894`12.000000000000004", ",", 
     "239.052163381`12.000000000000004", ",", 
     "240.053813545`11.999999999999998", ",", 
     "241.056851456`12.000000000000004", ",", 
     "242.058742611`11.999999999999998", ",", 
     "243.062003092`11.999999999999998", ",", 
     "244.064203907`11.999999999999998", ",", 
     "245.067747154`11.999999999999998", ",", 
     "246.070204627`11.999999999999998", ",", "247.07407`9.000000000000002", 
     ",", "243.06138108`10.999999999999996", ",", 
     "231.04556`9.000000000000002", ",", "232.04659`9.000000000000002", ",", 
     "233.046348`9.000000000000002", ",", "234.047809`9.000000000000002", ",",
      "235.047946`9.000000000000002", ",", "236.049579`9.000000000000002", 
     ",", "237.049996`9.000000000000002", ",", 
     "238.051984324`11.999999999999998", ",", 
     "239.053024479`12.000000000000004", ",", 
     "240.055300179`12.000000000000004", ",", 
     "241.056829144`12.000000000000004", ",", 
     "242.059549159`11.999999999999998", ",", 
     "243.06138108`10.999999999999996", ",", 
     "244.064284847`12.000000000000004", ",", 
     "245.066452114`11.999999999999998", ",", 
     "246.069774619`11.999999999999998", ",", "247.072093`9.000000000000002", 
     ",", "248.075752`9.000000000000002", ",", "249.07848`9.000000000000002", 
     ",", "247.07035354`11.", ",", "233.050771232`11.999999999999998", ",", 
     "234.050159841`11.999999999999998", ",", "235.051434`9.000000000000002", 
     ",", "236.051413`9.000000000000002", ",", "237.052901`9.000000000000002",
      ",", "238.053028697`11.999999999999998", ",", 
     "239.054957`9.000000000000002", ",", "240.055529539`11.999999999999998", 
     ",", "241.057653001`11.999999999999998", ",", 
     "242.058835824`12.000000000000004", ",", 
     "243.061389114`11.999999999999998", ",", 
     "244.062752578`12.000000000000004", ",", 
     "245.065491249`12.000000000000004", ",", 
     "246.067223662`12.000000000000004", ",", "247.07035354`11.", ",", 
     "248.072348508`12.000000000000004", ",", 
     "249.075953413`12.000000000000004", ",", 
     "250.078356959`12.000000000000004", ",", 
     "251.082284605`12.000000000000004", ",", "252.08487`9.000000000000002", 
     ",", "247.07030708`10.999999999999996", ",", 
     "235.05658`9.000000000000002", ",", "236.05733`9.000000000000002", ",", 
     "237.057003`9.000000000000002", ",", "238.058281`9.000000000000002", ",",
      "239.058279`9.000000000000002", ",", "240.059759`9.000000000000002", 
     ",", "241.06023`9.000000000000002", ",", "242.061981`9.000000000000002", 
     ",", "243.063007572`11.999999999999998", ",", 
     "244.065180774`11.999999999999998", ",", 
     "245.066361616`11.999999999999998", ",", 
     "246.068672947`11.999999999999998", ",", 
     "247.07030708`10.999999999999996", ",", "248.073086`9.000000000000002", 
     ",", "249.074986657`11.999999999999998", ",", "250.07831652`11.", ",", 
     "251.080760172`12.000000000000004", ",", "252.08431`9.000000000000002", 
     ",", "253.08688`9.000000000000002", ",", "254.0906`9.000000000000002", 
     ",", "251.079586788`12.000000000000004", ",", 
     "237.06207`9.000000000000002", ",", "238.06141`9.000000000000002", ",", 
     "239.062422`9.000000000000002", ",", "240.062302`9.000000000000002", ",",
      "241.063726`9.000000000000002", ",", "242.063701552`12.000000000000004",
      ",", "243.065427`9.000000000000002", ",", 
     "244.066000689`11.999999999999998", ",", 
     "245.068048612`11.999999999999998", ",", 
     "246.068805309`12.000000000000004", ",", 
     "247.071000589`12.000000000000004", ",", 
     "248.072184861`11.999999999999998", ",", 
     "249.074853537`11.999999999999998", ",", 
     "250.076406066`12.000000000000004", ",", 
     "251.079586788`12.000000000000004", ",", 
     "252.081625846`12.000000000000004", ",", 
     "253.085133145`12.000000000000004", ",", 
     "254.087322909`11.999999999999998", ",", "255.091046`9.000000000000002", 
     ",", "256.09344`9.000000000000002", ",", 
     "252.082978512`11.999999999999998", ",", "240.06892`9.000000000000002", 
     ",", "241.068538`9.000000000000002", ",", "242.069745`9.000000000000002",
      ",", "243.069548`9.000000000000002", ",", 
     "244.070883`9.000000000000002", ",", "245.071324`9.000000000000002", ",",
      "246.072896`9.000000000000002", ",", "247.073656`9.000000000000002", 
     ",", "248.075471`9.000000000000002", ",", "249.076411`9.000000000000002",
      ",", "250.078612`9.000000000000002", ",", 
     "251.079992142`11.999999999999998", ",", 
     "252.082978512`11.999999999999998", ",", 
     "253.084824697`11.999999999999998", ",", 
     "254.088022021`12.000000000000004", ",", 
     "255.090273122`11.999999999999998", ",", "256.093598`9.000000000000002", 
     ",", "257.095979`9.000000000000002", ",", "258.09952`9.000000000000002", 
     ",", "257.095104724`12.000000000000004", ",", 
     "242.07343`9.000000000000002", ",", "243.074353`9.000000000000002", ",", 
     "244.074084`9.000000000000002", ",", "245.075385`9.000000000000002", ",",
      "246.075299023`11.999999999999998", ",", "247.076847`9.000000000000002",
      ",", "248.077194714`11.999999999999998", ",", 
     "249.079034`9.000000000000002", ",", "250.079521264`11.999999999999998", 
     ",", "251.081575017`12.000000000000004", ",", 
     "252.082466855`11.999999999999998", ",", 
     "253.085185236`12.000000000000004", ",", "254.08685422`11.", ",", 
     "255.089962202`11.999999999999998", ",", 
     "256.091773117`12.000000000000004", ",", 
     "257.095104724`12.000000000000004", ",", "258.097076`9.000000000000002", 
     ",", "259.100595`9.000000000000002", ",", "260.102678`9.000000000000002",
      ",", "258.098431319`11.999999999999998", ",", 
     "245.080829`9.000000000000002", ",", "246.081886`9.000000000000002", ",",
      "247.081635`9.000000000000002", ",", "248.082823`9.000000000000002", 
     ",", "249.083013`9.000000000000002", ",", "250.08442`9.000000000000002", 
     ",", "251.084839`9.000000000000002", ",", "252.08656`9.000000000000002", 
     ",", "253.08728`9.000000000000002", ",", "254.089656`9.000000000000002", 
     ",", "255.091082705`12.000000000000004", ",", 
     "256.094059025`11.999999999999998", ",", 
     "257.095541368`11.999999999999998", ",", 
     "258.098431319`11.999999999999998", ",", "259.100509`9.000000000000002", 
     ",", "260.103652`9.000000000000002", ",", "261.105721`9.000000000000002",
      ",", "262.108865`9.000000000000002", ",", 
     "255.093241131`12.000000000000004", ",", "248.086596`9.000000000000002", 
     ",", "249.087833`9.000000000000002", ",", "250.08751`9.000000000000002", 
     ",", "251.089012`9.000000000000002", ",", 
     "252.088976521`11.999999999999998", ",", "253.090678`9.000000000000002", 
     ",", "254.090955253`12.000000000000004", ",", 
     "255.093241131`12.000000000000004", ",", 
     "256.094282666`12.000000000000004", ",", "257.09687719`11.", ",", 
     "258.098207`9.000000000000002", ",", "259.101031`9.000000000000002", ",",
      "260.102643`9.000000000000002", ",", "261.105749`9.000000000000002", 
     ",", "262.107301`9.000000000000002", ",", "263.110552`9.000000000000002",
      ",", "264.112345`9.000000000000002", ",", 
     "260.105504`9.000000000000002", ",", "251.09436`9.000000000000002", ",", 
     "252.095371`9.000000000000002", ",", "253.09521`9.000000000000002", ",", 
     "254.096454`9.000000000000002", ",", "255.096681`9.000000000000002", ",",
      "256.098629`9.000000000000002", ",", "257.099555`9.000000000000002", 
     ",", "258.101814`9.000000000000002", ",", "259.102901`9.000000000000002",
      ",", "260.105504`9.000000000000002", ",", 
     "261.106883`9.000000000000002", ",", "262.109634`9.000000000000002", ",",
      "263.111293`9.000000000000002", ",", "264.114038`9.000000000000002", 
     ",", "265.115839`9.000000000000002", ",", "266.119305`9.000000000000002",
      ",", "263.112547`9.000000000000002", ",", 
     "253.100689`9.000000000000002", ",", "254.100184`9.000000000000002", ",",
      "255.10134`9.000000000000002", ",", "256.101166194`12.000000000000004", 
     ",", "257.10299`9.000000000000002", ",", "258.103489`9.000000000000002", 
     ",", "259.105637`9.000000000000002", ",", "260.10644`9.000000000000002", 
     ",", "261.108766556`12.000000000000004", ",", 
     "262.109925`9.000000000000002", ",", "263.112547`9.000000000000002", ",",
      "264.113985`9.000000000000002", ",", "265.116704`9.000000000000002", 
     ",", "266.117956`9.000000000000002", ",", "267.121529`9.000000000000002",
      ",", "268.123644`9.000000000000002", ",", 
     "255.107398`9.000000000000002", ",", "255.107398`9.000000000000002", ",",
      "256.108127`9.000000000000002", ",", "257.107722`9.000000000000002", 
     ",", "258.109231`9.000000000000002", ",", "259.10961`9.000000000000002", 
     ",", "260.1113`9.000000000000002", ",", "261.112056`9.000000000000002", 
     ",", "262.114084`9.000000000000002", ",", "263.114988`9.000000000000002",
      ",", "264.117404`9.000000000000002", ",", 
     "265.118601`9.000000000000002", ",", "266.121029`9.000000000000002", ",",
      "267.122377`9.000000000000002", ",", "268.125445`9.000000000000002", 
     ",", "269.12746`9.000000000000002", ",", "270.130712`9.000000000000002", 
     ",", "259.1145`9.000000000000002", ",", "258.113168`9.000000000000002", 
     ",", "259.1145`9.000000000000002", ",", 
     "260.114422071`12.000000000000004", ",", "261.116117`9.000000000000002", 
     ",", "262.116398`9.000000000000002", ",", "263.118322`9.000000000000002",
      ",", "264.118931`9.000000000000002", ",", 
     "265.121114693`12.000000000000004", ",", "266.122065`9.000000000000002", 
     ",", "267.124425`9.000000000000002", ",", "268.125606`9.000000000000002",
      ",", "269.128755`9.000000000000002", ",", 
     "270.130329`9.000000000000002", ",", "271.133472`9.000000000000002", ",",
      "272.135158`9.000000000000002", ",", "273.13822`9.000000000000002", ",",
      "262.122892`9.000000000000002", ",", "260.12197`9.000000000000002", ",",
      "261.121664`9.000000000000002", ",", "262.122892`9.000000000000002", 
     ",", "263.123035`9.000000000000002", ",", "264.124604`9.000000000000002",
      ",", "265.125147`9.000000000000002", ",", 
     "266.126942`9.000000000000002", ",", "267.12765`9.000000000000002", ",", 
     "268.129755`9.000000000000002", ",", "269.130694`9.000000000000002", ",",
      "270.133616`9.000000000000002", ",", "271.135179`9.000000000000002", 
     ",", "272.138032`9.000000000000002", ",", "273.139618`9.000000000000002",
      ",", "274.14244`9.000000000000002", ",", "275.14425`9.000000000000002", 
     ",", "263.128558`9.000000000000002", ",", "263.128558`9.000000000000002",
      ",", "264.128394885`11.999999999999998", ",", 
     "265.130085`9.000000000000002", ",", "266.130097`9.000000000000002", ",",
      "267.131789`9.000000000000002", ",", "268.132162`9.000000000000002", 
     ",", "269.134056`9.000000000000002", ",", "270.13465`9.000000000000002", 
     ",", "271.137657`9.000000000000002", ",", "272.139052`9.000000000000002",
      ",", "273.141986`9.000000000000002", ",", 
     "274.143131`9.000000000000002", ",", "275.145952`9.000000000000002", ",",
      "276.147208`9.000000000000002", ",", "277.149841`9.000000000000002", 
     ",", "265.136151`9.000000000000002", ",", "265.136151`9.000000000000002",
      ",", "266.137299`9.000000000000002", ",", 
     "267.137307`9.000000000000002", ",", "268.138728`9.000000000000002", ",",
      "269.139055`9.000000000000002", ",", "270.140657`9.000000000000002", 
     ",", "271.141139`9.000000000000002", ",", "272.143738`9.000000000000002",
      ",", "273.144913`9.000000000000002", ",", 
     "274.147492`9.000000000000002", ",", "275.148647`9.000000000000002", ",",
      "276.151156`9.000000000000002", ",", "277.15242`9.000000000000002", ",",
      "278.154812`9.000000000000002", ",", "279.156193`9.000000000000002", 
     ",", "281.162061`9.000000000000002", ",", "267.144341`9.000000000000002",
      ",", "268.143795`9.000000000000002", ",", 
     "269.145124`9.000000000000002", ",", "270.14472`9.000000000000002", ",", 
     "271.146062`9.000000000000002", ",", "272.146317`9.000000000000002", ",",
      "273.148863`9.000000000000002", ",", "274.149492`9.000000000000002", 
     ",", "275.152176`9.000000000000002", ",", "276.153034`9.000000000000002",
      ",", "277.155647`9.000000000000002", ",", 
     "278.156469`9.000000000000002", ",", "279.158861`9.000000000000002", ",",
      "280.159795`9.000000000000002", ",", "281.162061`9.000000000000002", 
     ",", "272.153615`9.000000000000002", ",", "272.153615`9.000000000000002",
      ",", "273.153682`9.000000000000002", ",", 
     "274.155713`9.000000000000002", ",", "275.156142`9.000000000000002", ",",
      "276.158493`9.000000000000002", ",", "277.159519`9.000000000000002", 
     ",", "278.161604`9.000000000000002", ",", "279.162468`9.000000000000002",
      ",", "280.164473`9.000000000000002", ",", 
     "281.165372`9.000000000000002", ",", "282.167486`9.000000000000002", ",",
      "283.168415`9.000000000000002", ",", "283.171792`9.000000000000002", 
     ",", "277.163943`9.000000000000002", ",", "278.164312`9.000000000000002",
      ",", "279.166546`9.000000000000002", ",", 
     "280.167039`9.000000000000002", ",", "281.169286`9.000000000000002", ",",
      "282.169765`9.000000000000002", ",", "283.171792`9.000000000000002", 
     ",", "284.172384`9.000000000000002", ",", "285.174105`9.000000000000002",
      ",", "283.176451`9.000000000000002", ",", 
     "283.176451`9.000000000000002", ",", "284.17808`9.000000000000002", ",", 
     "285.178732`9.000000000000002", ",", "286.180481`9.000000000000002", ",",
      "287.181045`9.000000000000002", ",", "285.183698`9.000000000000002", 
     ",", "285.183698`9.000000000000002", ",", "286.183855`9.000000000000002",
      ",", "287.185599`9.000000000000002", ",", 
     "288.185689`9.000000000000002", ",", "289.187279`9.000000000000002", ",",
      "287.191186`9.000000000000002", ",", "287.191186`9.000000000000002", 
     ",", "288.192492`9.000000000000002", ",", "289.192715`9.000000000000002",
      ",", "290.194141`9.000000000000002", ",", 
     "291.194384`9.000000000000002", ",", "292.199786`9.000000000000002", ",",
      "289.198862`9.000000000000002", ",", "290.19859`9.000000000000002", ",",
      "291.200011`9.000000000000002", ",", "292.199786`9.000000000000002", 
     ",", "291.206564`9.000000000000002", ",", "291.206564`9.000000000000002",
      ",", "292.207549`9.000000000000002", ",", "293.21467`9.000000000000002",
      ",", "293.21467`9.000000000000002"}], "}"}]}],
  SequenceForm[
  "static double atomic_masses[] =", {
   1.00782503207`12.000000000000004, 1.00782503207`12.000000000000004, 
    2.01410177785`11.999999999999998, 2.01410177785`11.999999999999998, 
    3.01604927767`11.999999999999998, 3.01604927767`11.999999999999998, 
    4.027806424`10., 5.035311488`10.000000000000004, 
    6.044942594`10.000000000000004, 7.052749`7.000000000000001, 
    4.00260325415`12.000000000000004, 3.01602931914`11.999999999999998, 
    4.00260325415`12.000000000000004, 5.012223624`9.999999999999998, 
    6.018889124`10.000000000000004, 7.028020618`10.000000000000004, 
    8.033921897`9.999999999999998, 9.043950286`10.000000000000004, 
    10.052398837`10.999999999999996, 7.016004548`10.000000000000004, 
    3.030775`7.000000000000001, 4.027185558`10., 5.0125378`7.999999999999999, 
    6.015122794`10.000000000000004, 7.016004548`10.000000000000004, 
    8.022487362`10.000000000000004, 9.026789505`9.999999999999998, 
    10.035481259`11.000000000000005, 11.043797715`11., 
    12.05378`7.999999999999999, 9.012182201`9.999999999999998, 
    5.04079`7.000000000000001, 6.019726317`9.999999999999998, 
    7.016929828`10.000000000000004, 8.005305103`9.999999999999998, 
    9.012182201`9.999999999999998, 10.013533818`11.000000000000005, 
    11.021657749`11., 12.026920737`11., 13.035693007`11., 
    14.04289292`10.000000000000004, 15.05346`7.999999999999999, 
    16.06192`7.999999999999999, 11.009305406`11., 6.04681`7.000000000000001, 
    7.029917901`9.999999999999998, 8.024607233`10.000000000000004, 
    9.013328782`10., 10.012936992`11.000000000000005, 11.009305406`11., 
    12.014352104`11., 13.017780217`11., 14.025404009`11., 15.031103021`11., 
    16.039808829`11., 17.046989906`11., 18.05617`7.999999999999999, 
    19.06373`7.999999999999999, 12, 8.037675025`10.000000000000004, 
    9.031036689`9.999999999999998, 10.016853228`11.000000000000005, 
    11.011433613`11., 12, 13.00335483778`13., 
    14.0032419887`12.000000000000004, 15.010599256`11.000000000000005, 
    16.014701252`11., 17.022586116`10.999999999999998, 
    18.026759354`11.000000000000005, 19.034805018`11.000000000000004, 
    20.040319754`10.999999999999998, 21.04934`7.999999999999999, 
    22.0572`7.999999999999999, 14.00307400478`13., 
    10.041653674`10.999999999999996, 11.026090956`11., 
    12.018613197`11.000000000000005, 13.005738609`10.999999999999996, 
    14.00307400478`13., 15.00010889823`13., 16.006101658`11.000000000000004, 
    17.008450261`11., 18.014078959`10.999999999999998, 
    19.017028697`11.000000000000005, 20.023365807`11., 21.02710824`10., 
    22.034394934`10.999999999999998, 23.04122`7.999999999999999, 
    24.05104`7.999999999999999, 25.06066`7.999999999999999, 
    15.99491461956`13., 12.034404895`11., 13.024812213`11., 
    14.00859625`10.000000000000004, 15.003065617`11., 15.99491461956`13., 
    16.999131703`10.999999999999996, 17.999161001`10.999999999999998, 
    19.00358013`10., 20.004076742`11., 21.008655886`11., 22.009966947`11., 
    23.015687659`11., 24.020472917`11., 25.02946`7.999999999999999, 
    26.03834`7.999999999999999, 27.04826`7.999999999999999, 
    28.05781`7.999999999999999, 18.998403224`10.999999999999998, 
    14.03506`7.999999999999999, 15.018009103`11., 16.011465724`11., 
    17.002095237`11., 18.000937956`10.999999999999996, 
    18.998403224`10.999999999999998, 19.999981315`11., 20.999948951`11., 
    22.002998815`11., 23.003574631`11.000000000000004, 24.008115485`11., 
    25.012101747`11., 26.019615555`11., 27.026760086`11., 
    28.03567`7.999999999999999, 29.04326`7.999999999999999, 
    30.0525`7.999999999999999, 31.060429`7.999999999999999, 
    19.99244017542`13., 16.025761262`10.999999999999998, 17.017671504`11., 
    18.005708213`11.000000000000005, 19.001880248`11., 19.99244017542`13., 
    20.993846684`11.000000000000004, 21.991385113`11.000000000000004, 
    22.994466904`11., 23.993610779`11., 24.997736888`11.000000000000005, 
    26.000461206`11., 27.007589903`11., 28.012071575`11., 
    29.019385933`11.000000000000005, 30.024801045`11., 
    31.03311`7.999999999999999, 32.04002`7.999999999999999, 
    33.04938`7.999999999999999, 34.057028`7.999999999999999, 
    22.98976928087`13., 18.025969`7.999999999999999, 19.013877499`11., 
    20.007351328`11., 20.997655206`11., 21.994436425`11.000000000000004, 
    22.98976928087`13., 23.990962782`11., 24.989953968`11., 
    25.992633`7.999999999999999, 26.994076788`11.000000000000005, 
    27.998938`7.999999999999999, 29.002861`7.999999999999999, 
    30.008976`7.999999999999999, 31.013585452`11., 32.02046656`10., 
    33.026719756`11., 34.03517`7.999999999999999, 35.042493`7.999999999999999,
     36.05148`7.999999999999999, 37.05934`7.999999999999999, 
    23.985041699`11.000000000000005, 19.03547`7.000000000000001, 
    20.018862545`11., 21.01171291`9.999999999999998, 21.999573843`11., 
    22.994123669`11., 23.985041699`11.000000000000005, 
    24.985836917`11.000000000000005, 25.982592929`11., 26.984340585`11., 
    27.983876825`11., 28.9886`6.0000000000000036, 29.990434`7.999999999999999,
     30.996546`7.999999999999999, 31.998975`7.999999999999999, 
    33.005254`7.999999999999999, 34.009456424`11.000000000000005, 
    35.01734`7.999999999999999, 36.023`7.999999999999999, 
    37.0314`7.999999999999999, 38.03757`7.999999999999999, 
    39.046772`7.999999999999999, 40.05393`7.999999999999999, 26.981538627`11.,
     21.02804`7.999999999999999, 22.01952`7.999999999999999, 23.007267432`11.,
     23.999938865`11., 24.990428095`11.000000000000005, 
    25.986891692`11.000000000000005, 26.981538627`11., 
    27.981910306`10.999999999999996, 28.980445046`11., 29.982960256`11., 
    30.983946619`11., 31.988124489`11., 32.990843336`11., 
    33.996851837`11.000000000000005, 34.999860235`11., 36.006207204`11., 
    37.01067782`10., 38.017231021`10.999999999999996, 
    39.02297`7.000000000000001, 40.03145`7.999999999999999, 
    41.03833`7.999999999999999, 42.04689`7.999999999999999, 
    27.97692653246`13., 22.03453`7.999999999999999, 
    23.02552`7.999999999999999, 24.011545616`11., 
    25.004105574`10.999999999999996, 25.992329921`11., 26.986704905`11., 
    27.97692653246`13., 28.9764947`9.000000000000002, 29.973770171`11., 
    30.975363226999998`17., 31.974148082`11., 32.97800022`10., 
    33.978575524`11., 34.984583575`11.000000000000005, 35.986599477`11., 
    36.99293608`10., 37.995633601`11., 39.002070013`11., 40.005869121`11., 
    41.01456`7.000000000000001, 42.01979`7.999999999999999, 
    43.02866`7.999999999999999, 44.03526`7.999999999999999, 
    30.973761629`10.999999999999996, 24.03435`7.999999999999999, 
    25.02026`7.999999999999999, 26.01178`7.999999999999999, 26.999230236`11., 
    27.992314761`11., 28.981800606`11., 29.978313789`11., 
    30.973761629`10.999999999999996, 31.973907274`11.000000000000005, 
    32.971725543`11., 33.973636257`11., 34.973314117`11.000000000000005, 
    35.97825968`10., 36.979608946`11., 37.984156827`11., 38.986179475`11., 
    39.991296951`11., 40.994335435`11., 42.001007913`11., 
    43.00619`7.000000000000001, 44.01299`7.999999999999999, 
    45.01922`7.999999999999999, 46.02738`7.999999999999999, 31.972070999`11., 
    26.02788`7.999999999999999, 27.018833`7.999999999999999, 
    28.004372763`11.000000000000005, 28.996608049`11., 29.984903249`11., 
    30.979554728`11., 31.972070999`11., 32.971458759`10.999999999999996, 
    33.967866902`11., 34.969032161`11., 35.96708076`10., 36.971125567`11., 
    37.971163317`10.999999999999996, 38.975134306`10.999999999999996, 
    39.975451728`11., 40.979582149`11.000000000000005, 41.981022419`11., 
    42.98715479`10.000000000000004, 43.99021339`10.000000000000004, 
    44.996508112`11., 46.00075`7.999999999999999, 47.00859`7.999999999999999, 
    48.01417`7.999999999999999, 49.023619`7.999999999999999, 
    34.968852682`10.999999999999996, 28.02851`7.999999999999999, 
    29.01411`7.999999999999999, 30.00477`7.999999999999999, 30.992413086`11., 
    31.985689901`11., 32.977451887`11., 33.973762819`11.000000000000005, 
    34.968852682`10.999999999999996, 35.968306981`11., 36.965902591`11., 
    37.968010425`11., 38.968008164`10.999999999999996, 39.970415472`11., 
    40.970684525`11., 41.973254804`11., 42.974054403`11., 43.978281071`11., 
    44.980286886`11.000000000000005, 45.98421004`10.000000000000004, 
    46.98871`7.999999999999999, 47.99495`7.999999999999999, 
    49.00032`7.999999999999999, 50.00784`7.999999999999999, 
    51.01449`7.999999999999999, 39.96238312251`13., 
    30.02156`7.999999999999999, 31.012123`7.999999999999999, 31.997637984`11.,
     32.989925709`11., 33.980271244`11.000000000000005, 34.975257585`11., 
    35.967545105`11., 36.96677632`9.999999999999998, 
    37.962732394`11.000000000000005, 38.964313231`11., 39.96238312251`13., 
    40.964500611`11.000000000000005, 41.963045736`11., 42.965636056`11., 
    43.964924033`11., 44.968039956`11., 45.968094129`11., 46.972186792`11., 
    47.97454`7.999999999999999, 48.98052`7.999999999999999, 
    49.98443`7.999999999999999, 50.99163`7.999999999999999, 
    51.99678`7.999999999999999, 53.00494`7.999999999999999, 38.963706679`11., 
    32.02192`7.999999999999999, 33.00726`7.999999999999999, 
    33.99841`7.999999999999999, 34.988009692`11., 35.981292235`11., 
    36.973375889`11., 37.969081184`10.999999999999996, 38.963706679`11., 
    39.963998475`11., 40.961825762`11., 41.96240281`10., 
    42.96071554`9.999999999999998, 43.961556804`11., 44.960699493`11., 
    45.961976864`11., 46.961678473`11., 47.965513535`11., 
    48.967450928`10.999999999999996, 49.972783355`11., 
    50.97638`7.999999999999999, 51.98261`7.999999999999999, 
    52.98712`7.999999999999999, 53.9942`7.999999999999999, 
    54.99971`7.999999999999999, 39.962590983`11., 34.01412`7.999999999999999, 
    35.00494`7.999999999999999, 35.993087063`11.000000000000005, 
    36.985870269`11., 37.976318452`11., 38.970719725`10.999999999999996, 
    39.962590983`11., 40.962278062`11., 41.958618014`11., 42.958766628`11., 
    43.955481754`11., 44.956186566`11., 45.953692587`11., 
    46.954546006`10.999999999999996, 47.952534177`11., 48.955674148`11., 
    49.957518962`11., 50.961499214`11., 51.9651`5.999999999999999, 
    52.97005`7.999999999999999, 53.97435`7.999999999999999, 
    54.98055`7.999999999999999, 55.98557`7.999999999999999, 
    56.992356`7.999999999999999, 44.955911909`11., 36.01492`7.999999999999999,
     37.00305`7.999999999999999, 37.9947`7.999999999999999, 38.984790002`11., 
    39.977967407`10.999999999999996, 40.969251125`11., 
    41.965516429`10.999999999999996, 42.961150658`11., 43.959402752`11., 
    44.955911909`11., 45.95517189`9.999999999999998, 46.952407508`11., 
    47.952231468`11., 48.950023975`11., 49.952187685`11., 50.953603368`11., 
    51.956675468`10.999999999999996, 52.95961`7.999999999999999, 
    53.963264561`11., 54.968243949`11., 55.97287`7.999999999999999, 
    56.97779`7.999999999999999, 57.98371`7.999999999999999, 
    58.98922`7.999999999999999, 59.99571`7.999999999999999, 47.947946281`11., 
    38.00977`7.999999999999999, 39.00161`7.999999999999999, 39.990498838`11., 
    40.983145`7.999999999999999, 41.973030902`11., 42.968522499`11., 
    43.959690069`11., 44.958125616`11., 45.952631555`11., 
    46.951763088`10.999999999999996, 47.947946281`11., 48.947869982`11., 
    49.944791194`10.999999999999996, 50.946614955`11., 51.946897311`11., 
    52.949727171`10.999999999999996, 53.951052401`11., 
    54.955265056`10.999999999999996, 55.958199639`11., 
    56.963989137`11.000000000000005, 57.96697`7.999999999999999, 
    58.97293`7.999999999999999, 59.97676`7.999999999999999, 
    60.9832`7.999999999999999, 61.98749`7.999999999999999, 
    62.99442`7.999999999999999, 50.943959507`11., 40.01109`7.999999999999999, 
    40.99978`7.999999999999999, 41.99123`7.999999999999999, 
    42.98065`7.999999999999999, 43.97411`7.000000000000001, 44.965775808`11., 
    45.960200481`11., 46.95490894`10.000000000000004, 
    47.952253707`10.999999999999996, 48.948516101`11., 49.947158485`11., 
    50.943959507`11., 51.944775479`11., 52.944337979`10.999999999999996, 
    53.946439854`11., 54.947233701`11., 55.950530966`11., 56.952561432`11., 
    57.956834136`11., 58.960207407`11., 59.965026862`11., 
    60.96848`7.999999999999999, 61.97378`7.999999999999999, 
    62.97755`7.999999999999999, 63.98347`7.999999999999999, 
    64.98792`7.999999999999999, 51.940507472`11., 42.00643`7.999999999999999, 
    42.99771`7.999999999999999, 43.985549`7.999999999999999, 
    44.97964`7.000000000000001, 45.968358635`11.000000000000005, 
    46.962900046`10.999999999999996, 47.954031716`11.000000000000005, 
    48.951335721`11., 49.946044205`11., 50.944767431`11., 51.940507472`11., 
    52.940649386`11., 53.938880395`11., 54.940839672`11., 55.940653139`11., 
    56.943613013`10.999999999999996, 57.944353129`11., 58.948586367`11., 
    59.950076033`11., 60.954717204`11., 61.95661319`9.999999999999998, 
    62.96186`7.999999999999999, 63.96441`7.999999999999999, 
    64.97016`7.999999999999999, 65.97338`7.999999999999999, 
    66.97955`7.999999999999999, 54.938045141`11.000000000000005, 
    44.00687`7.999999999999999, 44.99451`7.999999999999999, 
    45.98672`7.999999999999999, 46.9761`7.999999999999999, 
    47.96852`7.000000000000001, 48.959618005`11., 
    49.95423823`9.999999999999998, 50.948210787`10.999999999999996, 
    51.945565464`11., 52.941290117`11., 53.940358854`10.999999999999996, 
    54.938045141`11.000000000000005, 55.93890491`10.000000000000004, 
    56.938285378`11., 57.939981549`11., 58.940440237`11., 59.942911246`11., 
    60.944652638`11., 61.94842822`9.999999999999998, 
    62.95023999`10.000000000000004, 63.95424909`9.999999999999998, 
    64.956336065`10.999999999999996, 65.96108`7.999999999999999, 
    66.96414`7.999999999999999, 67.9693`7.999999999999999, 
    68.97284`7.999999999999999, 55.934937475`11., 45.014578`7.999999999999999,
     46.00081`7.999999999999999, 46.99289`7.999999999999999, 
    47.980504`7.999999999999999, 48.97361`7.999999999999999, 49.962988982`11.,
     50.956819538`11., 51.948113875`11., 52.945307942`11., 53.939610501`11., 
    54.938293357`11., 55.934937475`11., 56.935393969`10.999999999999996, 
    57.933275558`10.999999999999996, 58.934875464`11.000000000000005, 
    59.934071683`11., 60.936745281`11., 61.936767442`11., 62.940369091`11., 
    63.941201265`11., 64.94538027`9.999999999999998, 
    65.946780638`11.000000000000005, 66.950947244`11.000000000000005, 
    67.9537`5.999999999999999, 68.95878`7.999999999999999, 
    69.96146`8.000000000000004, 70.96672`7.999999999999999, 
    71.96962`7.999999999999999, 58.933195048`11., 47.01149`7.999999999999999, 
    48.00176`7.999999999999999, 48.98972`7.999999999999999, 
    49.98154`7.999999999999999, 50.97072`7.999999999999999, 
    51.96359`7.999999999999999, 52.954218896`10.999999999999996, 
    53.948459635`11., 54.941999029`11., 55.939839278`11., 56.936291373`11., 
    57.935752814`11., 58.933195048`11., 59.933817059`11., 60.932475763`11., 
    61.934050563`11., 62.933611611`11., 63.935809908`11., 
    64.93647846`10.000000000000004, 65.939762004`11., 
    66.940889529`10.999999999999996, 67.944873058`11., 
    68.94632`7.000000000000001, 69.951`5.000000000000002, 
    70.9529`5.999999999999999, 71.95781`8.000000000000004, 
    72.96024`7.999999999999999, 73.96538`7.999999999999999, 
    74.96833`7.999999999999999, 57.935342907`11., 48.01975`7.999999999999999, 
    49.00966`7.999999999999999, 49.99593`7.999999999999999, 
    50.98772`7.999999999999999, 51.97568`7.999999999999999, 
    52.96847`7.999999999999999, 53.957905495`11., 54.951330251`11., 
    55.942132022`11., 56.939793526`11., 57.935342907`11., 58.934346705`11., 
    59.930786372`11., 60.931056033`11., 61.928345115`10.999999999999996, 
    62.929669374`11., 63.927965959`10.999999999999996, 64.930084304`11., 
    65.929139334`11., 66.931569414`11.000000000000005, 67.931868789`11., 
    68.935610269`11., 69.9365`5.999999999999999, 70.940736283`11., 
    71.942092682`10.999999999999998, 72.94647`7.999999999999999, 
    73.94807`7.999999999999999, 74.95287`7.999999999999999, 
    75.95533`8.000000000000004, 76.96055`7.999999999999999, 
    77.96318`7.999999999999999, 62.929597474`11.000000000000005, 
    51.99718`7.999999999999999, 52.98555`7.999999999999999, 
    53.97671`7.999999999999999, 54.96605`7.999999999999999, 
    55.95856`7.999999999999999, 56.949211078`11., 57.944538499`11., 
    58.939498028`11., 59.93736503`9.999999999999998, 60.933457821`11., 
    61.932583745`11.000000000000005, 62.929597474`11.000000000000005, 
    63.929764183`11., 64.927789485`11., 65.928868813`11., 
    66.927730314`10.999999999999996, 67.929610889`11., 
    68.929429269`11.000000000000005, 69.932392343`11., 70.932676833`11., 
    71.935820307`11., 72.936675282`11., 73.939874862`11., 
    74.9419`5.999999999999999, 75.945275026`10.999999999999998, 
    76.94785`7.999999999999999, 77.95196`7.999999999999999, 
    78.95456`7.999999999999999, 79.96087`7.999999999999999, 63.929142222`11., 
    53.99295`7.999999999999999, 54.98398`7.999999999999999, 
    55.97238`7.999999999999999, 56.964788`7.999999999999999, 57.954591555`11.,
     58.949263764`11., 59.941827035`11., 60.939510635`11., 61.934329764`11., 
    62.933211566`11., 63.929142222`11., 64.929240984`10.999999999999996, 
    65.926033419`11., 66.927127345`11., 67.924844154`11., 68.926550281`11., 
    69.925319274`11., 70.927721599`11., 71.926857951`11., 
    72.929779104`10.999999999999998, 73.929458609`11., 74.932936741`11., 
    75.93329357`9.999999999999998, 76.936958967`11., 77.938440216`11., 
    78.942652`8.000000000000004, 79.944342348`11., 80.95048`8.000000000000004,
     81.95442`7.999999999999999, 82.96103`7.999999999999999, 68.925573587`11.,
     55.99491`7.999999999999999, 56.98293`7.999999999999999, 
    57.97425`7.999999999999999, 58.96337`7.999999999999999, 
    59.95706`7.999999999999999, 60.949446287`11.000000000000005, 
    61.944175238`11., 62.939294196`10.999999999999996, 63.936838747`11., 
    64.932734754`11., 65.93158901`10.000000000000004, 
    66.928201703`11.000000000000005, 67.927980084`11., 68.925573587`11., 
    69.926021972`11., 70.924701349`11., 71.926366268`11., 72.925174682`11., 
    73.926945762`11., 74.926500246`11., 75.928827626`11., 
    76.9291543`9.000000000000002, 77.93160818`10.000000000000004, 
    78.93289326`9.999999999999998, 79.936515781`11., 
    80.937752355`10.999999999999998, 81.94299`7.999999999999999, 
    82.94698`7.999999999999999, 83.95265`7.999999999999999, 
    84.957`7.999999999999999, 85.96312`7.999999999999999, 73.921177767`11., 
    57.99101`7.999999999999999, 58.98175`7.999999999999999, 
    59.97019`7.999999999999999, 60.96379`7.999999999999999, 
    61.95465`7.999999999999999, 62.94964`7.999999999999999, 
    63.941653`7.999999999999999, 64.939436406`11., 65.933843453`11., 
    66.93273407`9.999999999999998, 67.92809424`9.999999999999998, 
    68.927964533`11., 69.924247381`10.999999999999998, 70.924950954`11., 
    71.922075815`11., 72.923458945`11., 73.921177767`11., 74.922858948`11., 
    75.921402557`11., 76.923548591`11., 77.922852739`11., 78.925400995`11., 
    79.925372392`11., 80.928820467`11., 81.929549725`11., 
    82.93462`7.999999999999999, 83.93747`7.999999999999999, 
    84.94303`7.999999999999999, 85.94649`7.999999999999999, 
    86.95251`7.999999999999999, 87.95691`7.999999999999999, 
    88.96383`7.999999999999999, 74.921596478`11., 59.99313`7.999999999999999, 
    60.98062`7.999999999999999, 61.9732`7.999999999999999, 
    62.96369`7.999999999999999, 63.957572`7.999999999999999, 
    64.949564`7.999999999999999, 65.94471`7.000000000000001, 66.939186071`11.,
     67.936769069`11., 68.932273675`11., 69.930924826`11., 70.927112428`11., 
    71.926752283`11.000000000000005, 72.923824844`11., 73.923928692`11., 
    74.921596478`11., 75.922394021`11.000000000000004, 
    76.920647286`11.000000000000005, 77.921827281`11., 78.920947934`11., 
    79.922533816`11., 80.922132287`11., 81.924504067`11., 82.924980024`11., 
    83.929058`7.999999999999999, 84.93202`7.999999999999999, 
    85.9365`7.999999999999999, 86.9399`7.999999999999999, 
    87.94494`7.999999999999999, 88.94939`7.999999999999999, 
    89.9555`7.999999999999999, 90.96043`7.999999999999999, 
    91.9668`7.999999999999999, 79.916521271`11., 64.96466`7.999999999999999, 
    65.95521`7.999999999999999, 66.95009`7.999999999999999, 
    67.941798`7.999999999999999, 68.939557817`11., 69.933390644`11., 
    70.932241822`11., 71.927112352`11., 72.926765345`11., 
    73.922476436`10.999999999999998, 74.922523368`11., 75.919213597`11., 
    76.919914038`11., 77.91730909`10.000000000000004, 78.918499098`11., 
    79.916521271`11., 80.917992474`11., 81.916699401`11.000000000000005, 
    82.919118473`11., 83.918462354`10.999999999999998, 84.922245053`11., 
    85.924271579`11., 86.928521358`11., 87.931423998`11., 
    88.93645`8.000000000000004, 89.93996`7.999999999999999, 
    90.94596`7.999999999999999, 91.94992`7.999999999999999, 
    92.95629`7.999999999999999, 93.96049`7.999999999999999, 78.918337087`11., 
    66.96479`7.999999999999999, 67.958516`7.999999999999999, 
    68.950106`7.999999999999999, 69.944792`7.999999999999999, 
    70.93874`7.000000000000001, 71.936644572`11., 72.931691524`11., 
    73.929891034`11., 74.925776207`11., 75.924541469`11., 76.921379082`11., 
    77.921145706`11., 78.918337087`11., 79.918529296`11., 80.916290563`11., 
    81.916804119`11., 82.915180421`11.000000000000005, 83.916478974`11., 
    84.915608403`11., 85.918797577`11., 86.920711324`11., 87.924065926`11., 
    88.926385334`11., 89.930627737`11.000000000000004, 
    90.933968095`11.000000000000004, 91.939258714`11., 
    92.94305`7.999999999999999, 93.94868`7.999999999999999, 
    94.95287`7.999999999999999, 95.95853`7.999999999999999, 
    96.9628`7.999999999999999, 85.910610729`11., 68.96518`7.999999999999999, 
    69.955259`7.999999999999999, 70.949625738`11., 71.942092038`11., 
    72.939289195`11., 73.933084369`11.000000000000004, 74.930945746`11., 
    75.925910078`11., 76.92467`7.000000000000001, 77.920364783`11., 
    78.920082431`11., 79.916378965`11., 80.916592015`11., 
    81.9134836`9.000000000000002, 82.914136099`11., 83.911506687`11., 
    84.912527331`11., 85.910610729`11., 86.913354862`11.000000000000004, 
    87.914446969`11.000000000000004, 88.917630581`11., 89.919516555`11., 
    90.923445215`11., 91.92615621`9.999999999999998, 
    92.931274357`11.000000000000005, 93.93436`7.999999999999999, 
    94.93984`7.999999999999999, 95.94307`7.999999999999999, 
    96.94856`7.999999999999999, 97.95191`7.999999999999999, 
    98.9576`7.999999999999999, 99.96114`7.999999999999999, 84.911789737`11., 
    70.96532`7.999999999999999, 71.95908`8.000000000000004, 
    72.950561`7.999999999999999, 73.944264751`10.999999999999998, 
    74.93857`7.000000000000001, 75.935072226`11., 76.930408`7.999999999999999,
     77.928141`7.999999999999999, 78.92398946`10.000000000000004, 
    79.92251925`10.000000000000004, 80.918995913`11., 81.918208598`11., 
    82.915109701`11., 83.914384821`11., 84.911789737`11., 
    85.911167419`11.000000000000004, 86.909180526`11., 87.911315588`11., 
    88.912278016`11., 89.914801694`11., 90.916536958`11.000000000000005, 
    91.9197289`9.000000000000002, 92.922041876`11., 93.926404946`11., 
    94.929302889`11., 95.934272637`11., 96.937351916`11., 97.941790668`11., 
    98.945379283`11., 99.94987`7.999999999999999, 
    100.953196445`11.999999999999998, 101.95887`9.000000000000002, 
    87.905612124`11., 72.96597`7.999999999999999, 73.95631`7.999999999999999, 
    74.949949568`11.000000000000004, 75.941766782`11., 76.937944782`11., 
    77.93218`6.999999999999997, 78.929708`7.999999999999999, 79.924521013`11.,
     80.923211846`11., 81.918401639`11., 82.917556701`11., 
    83.913425275`10.999999999999998, 84.912932803`11., 85.909260204`11., 
    86.908877124`11., 87.905612124`11., 88.907450675`11., 89.907737888`11., 
    90.910203095`11., 91.911037858`11.000000000000004, 92.914025634`11., 
    93.915361312`11., 94.919358766`11., 95.921696802`11., 96.926152923`11., 
    97.928452934`11., 98.933240926`11., 99.935351911`11.000000000000004, 
    100.940517888`11.999999999999998, 101.943018987`11.999999999999998, 
    102.94895`9.000000000000002, 103.95233`9.000000000000002, 
    104.95858`9.000000000000002, 88.905848295`11., 75.95845`7.999999999999999,
     76.949645`7.999999999999999, 77.94361`7.999999999999999, 
    78.937351634`11., 79.93428`7.000000000000001, 80.929127468`11., 
    81.926792451`11., 82.922354243`11., 83.920388264`11., 
    84.916433039`11.000000000000005, 85.914885576`11., 
    86.91087573`9.999999999999998, 87.909501146`11., 88.905848295`11., 
    89.907151886`11.000000000000005, 90.907304791`11., 91.908949143`11., 
    92.909582713`11., 93.911595245`11., 94.912820621`10.999999999999998, 
    95.915891343`11., 96.918133995`11., 97.92220302`10., 
    98.924636204`10.999999999999998, 99.927756586`11., 100.93031385`11., 
    101.933555695`12.000000000000004, 102.93673`9.000000000000002, 
    103.94105`9.000000000000002, 104.94487`9.000000000000002, 
    105.94979`9.000000000000002, 106.95414`9.000000000000002, 
    107.95948`9.000000000000002, 89.904704416`11., 77.95523`7.999999999999999,
     78.94916`7.999999999999999, 79.9404`5.999999999999999, 80.937210026`11., 
    81.931087`7.999999999999999, 82.928653801`11.000000000000005, 
    83.92325`7.999999999999999, 84.921471182`11., 85.916473591`11., 
    86.914816252`11., 87.910226904`11., 88.9088895`9.000000000000005, 
    89.904704416`11., 90.905645767`11., 91.905040847`11., 92.906476006`11., 
    93.906315192`11., 94.9080426`9.000000000000002, 95.908273386`11., 
    96.910953109`11.000000000000005, 97.912734892`11., 98.916512106`11., 
    99.917761889`10.999999999999998, 100.921140415`11.999999999999998, 
    101.922981285`12.000000000000004, 102.926599606`12.000000000000004, 
    103.92878`9.000000000000002, 104.93305`9.000000000000002, 
    105.93591`9.000000000000002, 106.94075`9.000000000000002, 
    107.94396`9.000000000000002, 108.94924`9.000000000000002, 
    109.95287`9.000000000000002, 92.906378058`11., 80.94903`7.999999999999999,
     81.94313`7.999999999999999, 82.936705382`11., 83.93357`7.999999999999999,
     84.927912447`11., 85.925038326`11., 86.920361108`11., 87.918332163`11., 
    88.913418245`11.000000000000005, 89.911264845`11., 90.906996243`11., 
    91.907193888`11.000000000000004, 92.906378058`11., 
    93.907283888`11.000000000000005, 94.906835792`11., 95.908100647`11., 
    96.908098556`11.000000000000004, 97.910328412`11., 98.911618375`11., 
    99.914181619`11., 100.915252025`11.999999999999998, 
    101.918037614`12.000000000000004, 102.919143842`11.999999999999998, 
    103.922464701`11.999999999999998, 104.923936545`12.000000000000004, 
    105.92797`9.000000000000002, 106.93031`9.000000000000002, 
    107.93484`9.000000000000002, 108.93763`9.000000000000002, 
    109.94244`9.000000000000002, 110.94565`9.000000000000002, 
    111.95083`9.000000000000002, 112.9547`9.000000000000002, 
    97.905408169`11.000000000000005, 82.94874`7.999999999999999, 
    83.94009`7.999999999999999, 84.93655`7.999999999999999, 85.930695904`11., 
    86.927326502`11., 87.921953241`11., 88.919480009`11., 89.913936896`11., 
    90.911750194`10.999999999999998, 91.906810991`11., 
    92.90681261`9.999999999999998, 93.905088269`11., 94.905842129`11., 
    95.904679477`11., 96.906021465`11., 97.905408169`11.000000000000005, 
    98.90771187`10.000000000000004, 99.907477336`11., 
    100.910347001`11.999999999999998, 101.91029736`11., 
    102.913207142`11.999999999999998, 103.913763625`11.999999999999998, 
    104.91697461`10.999999999999996, 105.918136802`12.000000000000004, 
    106.921692604`12.000000000000004, 107.923453`9.000000000000002, 
    108.92781`9.000000000000002, 109.92973`9.000000000000002, 
    110.93441`9.000000000000002, 111.93684`9.000000000000002, 
    112.94188`9.000000000000002, 113.94492`9.000000000000002, 
    114.95029`9.000000000000002, 98.906254747`11., 84.94883`7.999999999999999,
     85.94288`7.999999999999999, 86.93653`7.999999999999999, 
    87.932678`7.999999999999999, 88.927167`7.999999999999999, 
    89.923556564`11., 90.918427639`11., 91.915260166`11., 
    92.910248984`10.999999999999998, 93.909657002`11., 94.907657084`11., 
    95.907871383`10.999999999999998, 96.906365358`11., 
    97.907215966`11.000000000000004, 98.906254747`11., 
    99.90765778`10.000000000000004, 100.907314659`11.999999999999998, 
    101.909215019`11.999999999999998, 102.909181351`12.000000000000004, 
    103.911447454`12.000000000000004, 104.911660566`11.999999999999998, 
    105.914357927`12.000000000000004, 106.915079572`12.000000000000004, 
    107.918461226`11.999999999999998, 108.919982665`12.000000000000004, 
    109.923820483`11.999999999999998, 110.92569283`11., 
    111.929146493`12.000000000000004, 112.93159`9.000000000000002, 
    113.93588`9.000000000000002, 114.93869`9.000000000000002, 
    115.94337`9.000000000000002, 116.94648`9.000000000000002, 
    117.95148`9.000000000000002, 101.904349312`12.000000000000004, 
    86.94918`8.000000000000004, 87.94026`7.999999999999999, 
    88.93611`7.999999999999999, 89.92989`7.999999999999999, 
    90.926292`7.999999999999999, 91.92012`7.999999999999999, 92.917052034`11.,
     93.911359711`11.000000000000005, 94.910412929`11., 95.907597835`11., 
    96.9075547`9.000000000000002, 97.905287132`11., 98.905939302`11., 
    99.904219476`11., 100.905582087`11.999999999999998, 
    101.904349312`12.000000000000004, 102.906323847`11.999999999999998, 
    103.905432701`12.000000000000004, 104.907752866`12.000000000000004, 
    105.907329433`11.999999999999998, 106.909905089`11.999999999999998, 
    107.910173465`11.999999999999998, 108.913203233`11.999999999999998, 
    109.914136041`11.999999999999998, 110.917696`9.000000000000002, 
    111.918965`9.000000000000002, 112.922487194`11.999999999999998, 
    113.924281`9.000000000000002, 114.928686173`11.999999999999998, 
    115.93081`9.000000000000002, 116.93558`9.000000000000002, 
    117.93782`9.000000000000002, 118.94284`9.000000000000002, 
    119.94531`9.000000000000002, 102.905504292`11.999999999999998, 
    88.948837`8.000000000000004, 89.94287`7.999999999999999, 
    90.93655`7.999999999999999, 91.93198`7.999999999999999, 
    92.92574`7.999999999999999, 93.921698`7.999999999999999, 
    94.91589874`9.999999999999998, 95.914460631`11., 
    96.911336797`11.000000000000005, 97.910708158`11., 98.908132104`11., 
    99.90812155`10.000000000000004, 100.906163625`12.000000000000004, 
    101.906843196`12.000000000000004, 102.905504292`11.999999999999998, 
    103.906655518`12.000000000000004, 104.905693821`12.000000000000004, 
    105.907287135`12.000000000000004, 106.906748423`12.000000000000004, 
    107.908728018`11.999999999999998, 108.908737289`11.999999999999998, 
    109.911136411`11.999999999999998, 110.911585913`11.999999999999998, 
    111.914394159`11.999999999999998, 112.915530627`11.999999999999998, 
    113.918806`9.000000000000002, 114.920334`9.000000000000002, 
    115.924062`9.000000000000002, 116.92598`9.000000000000002, 
    117.93007`9.000000000000002, 118.93211`9.000000000000002, 
    119.93641`9.000000000000002, 120.93872`9.000000000000002, 
    121.94321`9.000000000000002, 105.903485715`12.000000000000004, 
    90.94911`7.999999999999999, 91.94042`7.999999999999999, 
    92.93591`7.999999999999999, 93.92877`7.999999999999999, 
    94.92469`7.999999999999999, 95.918164359`11., 96.916479073`11., 
    97.912720902`11., 98.911767833`11., 99.908505886`11., 
    100.908289242`11.999999999999998, 101.905608544`12.000000000000004, 
    102.906087307`11.999999999999998, 103.904035834`11.999999999999998, 
    104.90508492`11., 105.903485715`12.000000000000004, 
    106.905133481`12.000000000000004, 107.903891701`11.999999999999998, 
    108.905950451`11.999999999999998, 109.905153254`11.999999999999998, 
    110.907670734`11.999999999999998, 111.907314058`11.999999999999998, 
    112.910152908`11.999999999999998, 113.910362638`11.999999999999998, 
    114.913683824`11.999999999999998, 115.914158662`12.000000000000004, 
    116.917841338`11.999999999999998, 117.9189843`10., 
    118.92311`9.000000000000002, 119.924691878`12.000000000000004, 
    120.92887`9.000000000000002, 121.93055`9.000000000000002, 
    122.93493`9.000000000000002, 123.93688`9.000000000000002, 
    106.90509682`11.000000000000005, 92.94978`7.999999999999999, 
    93.94278`8.000000000000004, 94.93548`7.999999999999999, 
    95.93068`7.999999999999999, 96.923972412`11., 97.921566201`11., 
    98.917597178`11., 99.916104255`11.000000000000004, 
    100.912802233`11.999999999999998, 101.911685`9.000000000000002, 
    102.90897272`10.999999999999996, 103.908629157`11.999999999999998, 
    104.906528661`11.999999999999998, 105.906668921`11.999999999999998, 
    106.90509682`11.000000000000005, 107.905955556`12.000000000000004, 
    108.904752292`11.999999999999998, 109.906107231`12.000000000000004, 
    110.905291157`11.999999999999998, 111.907004814`11.999999999999998, 
    112.906566579`11.999999999999998, 113.908803704`12.000000000000004, 
    114.908762698`12.000000000000004, 115.911359933`11.999999999999998, 
    116.911684562`12.000000000000004, 117.914582768`11.999999999999998, 
    118.915665059`11.999999999999998, 119.918787384`12.000000000000004, 
    120.919848046`12.000000000000004, 121.92353`9.000000000000002, 
    122.9249`9.000000000000002, 123.92864`9.000000000000002, 
    124.93043`9.000000000000002, 125.9345`9.000000000000002, 
    126.93677`9.000000000000002, 127.94117`9.000000000000002, 
    128.94369`9.000000000000002, 129.950448`9.000000000000002, 
    113.90335854`11., 94.94987`7.999999999999999, 95.93977`7.999999999999999, 
    96.93494`7.999999999999999, 97.927395546`11., 98.92501`7.999999999999999, 
    99.920289525`11., 100.918681538`11.999999999999998, 
    101.914462258`12.000000000000004, 102.913419246`11.999999999999998, 
    103.909849475`11.999999999999998, 104.909467905`11.999999999999998, 
    105.90645941`10.999999999999996, 106.906617928`12.000000000000004, 
    107.904183683`11.999999999999998, 108.904982293`12.000000000000004, 
    109.90300207`11., 110.904178107`11.999999999999998, 
    111.902757809`12.000000000000004, 112.904401662`12.000000000000004, 
    113.90335854`11., 114.905430969`12.000000000000004, 
    115.904755809`12.000000000000004, 116.907218618`12.000000000000004, 
    117.90691453`10.999999999999996, 118.909921597`12.000000000000007, 
    119.909850129`11.999999999999998, 120.912977363`11.999999999999998, 
    121.913332432`12.000000000000004, 122.917002999`11.999999999999998, 
    123.917647616`11.999999999999998, 124.92124637`11., 
    125.922353321`12.000000000000004, 126.926443864`11.999999999999998, 
    127.927762285`12.000000000000004, 128.93215`9.000000000000002, 
    129.933901937`12.000000000000004, 130.94067`9.000000000000002, 
    131.94555`9.000000000000002, 114.903878484`12.000000000000004, 
    96.94954`7.999999999999999, 97.94214`7.999999999999999, 
    98.93422`7.999999999999999, 99.931110851`11., 100.92634`9.000000000000002,
     101.924090238`12.000000000000004, 102.919914188`11.999999999999998, 
    103.918296171`12.000000000000004, 104.91467354`10.999999999999996, 
    105.913465411`11.999999999999998, 106.9102951`10.000000000000004, 
    107.90969818`10.999999999999996, 108.907150507`12.000000000000004, 
    109.907165274`12.000000000000004, 110.905103278`11.999999999999998, 
    111.905532331`11.999999999999998, 112.904057761`12.000000000000004, 
    113.904913876`11.999999999999998, 114.903878484`12.000000000000004, 
    115.905259703`11.999999999999998, 116.904513564`11.999999999999998, 
    117.906354367`12.000000000000004, 118.90584535`11., 
    119.907959608`11.999999999999998, 120.907845822`12.000000000000004, 
    121.91027601`11., 122.910438276`11.999999999999998, 
    123.913175231`11.999999999999998, 124.913600588`12.000000000000004, 
    125.916463857`12.000000000000004, 126.917353091`12.000000000000004, 
    127.920172328`11.999999999999998, 128.92169698`11., 
    129.924970049`11.999999999999996, 130.926851767`12.000000000000004, 
    131.93299026`11.000000000000005, 132.93781`9.000000000000002, 
    133.94415`9.000000000000002, 134.94933`9.000000000000002, 
    119.902194676`11.999999999999998, 98.94933`7.999999999999999, 
    99.939044343`11., 100.93606`9.000000000000002, 
    101.930295324`11.999999999999998, 102.9281`9.000000000000002, 
    103.923143223`11.999999999999998, 104.921349437`12.000000000000004, 
    105.91688062`11., 106.915644329`12.000000000000004, 
    107.911925378`11.999999999999998, 108.911283214`12.000000000000004, 
    109.907842791`12.000000000000004, 110.90773446`11., 
    111.904818207`12.000000000000004, 112.905170577`12.000000000000004, 
    113.902778869`11.999999999999998, 114.903342397`11.999999999999998, 
    115.90174053`11., 116.902951656`12.000000000000004, 
    117.901603167`12.000000000000004, 118.90330763`10.999999999999996, 
    119.902194676`11.999999999999998, 120.90423548`11., 
    121.903439046`11.999999999999998, 122.905720838`11.999999999999998, 
    123.905273946`12.000000000000004, 124.907784125`11.999999999999998, 
    125.90765328`11., 126.910360024`12.000000000000004, 
    127.910536624`11.999999999999998, 128.913479`9.000000000000002, 
    129.913967295`11.999999999999998, 130.916999769`12.000000000000004, 
    131.917815713`11.999999999999998, 132.923829249`11.999999999999996, 
    133.928291765`12., 134.93473`9.000000000000002, 
    135.93934`9.000000000000002, 136.94599`9.000000000000002, 
    120.903815686`12.000000000000004, 102.93969`9.000000000000002, 
    103.936472`9.000000000000002, 104.931486348`11.999999999999998, 
    105.928791`9.000000000000002, 106.92415`9.000000000000002, 
    107.92216`9.000000000000002, 108.918132426`12.000000000000004, 
    109.916753`9.000000000000002, 110.913163`9.000000000000002, 
    111.912398009`11.999999999999998, 112.909371672`12.000000000000004, 
    113.909269`9.000000000000002, 114.906598`9.000000000000002, 
    115.906793629`11.999999999999998, 116.904835941`11.999999999999998, 
    117.905528731`12.000000000000004, 118.903942009`12.000000000000004, 
    119.905072427`12.000000000000004, 120.903815686`12.000000000000004, 
    121.905173651`11.999999999999998, 122.90421397`11., 
    123.905935743`11.999999999999998, 124.905253818`11.999999999999998, 
    125.90724748`11., 126.906923609`11.999999999999998, 
    127.909169001`11.999999999999998, 128.909148442`12.000000000000004, 
    129.911656324`11.999999999999998, 130.911982275`12., 
    131.914466896`11.999999999999998, 132.91525163`10.999999999999996, 
    133.920379744`11.999999999999998, 134.925165771`11.999999999999998, 
    135.93035`9.000000000000002, 136.93531`9.000000000000002, 
    137.94079`9.000000000000002, 138.94598`9.000000000000002, 
    129.906224399`11.999999999999998, 104.94364`9.000000000000002, 
    105.937504237`11.999999999999998, 106.935006`9.000000000000002, 
    107.929444597`11.999999999999998, 108.927415515`11.999999999999998, 
    109.922407316`11.999999999999998, 110.921110692`11.999999999999998, 
    111.917013672`11.999999999999998, 112.915891`9.000000000000002, 
    113.912089`9.000000000000002, 114.911902`9.000000000000002, 
    115.90846`7.999999999999999, 116.908644719`11.999999999999998, 
    117.905827581`11.999999999999998, 118.906403645`11.999999999999998, 
    119.904020222`12.000000000000007, 120.904936424`12.000000000000004, 
    121.903043898`12.000000000000004, 122.904270029`11.999999999999998, 
    123.902817896`11.999999999999998, 124.904430731`11.999999999999998, 
    125.903311696`12.000000000000004, 126.905226336`12.000000000000004, 
    127.904463056`11.999999999999998, 128.906598238`12., 
    129.906224399`11.999999999999998, 130.908523864`11.999999999999998, 
    131.90855316`11., 132.910955306`11.999999999999998, 
    133.911368737`11.999999999999996, 134.916448592`12., 
    135.920101246`11.999999999999998, 136.925322954`12.000000000000004, 
    137.92922`9.000000000000002, 138.93473`9.000000000000002, 
    139.93885`9.000000000000002, 140.94465`9.000000000000002, 
    141.94908`9.000000000000002, 126.904472681`11.999999999999998, 
    107.943475`9.000000000000002, 108.938149417`12.000000000000004, 
    109.935242`9.000000000000002, 110.930276`9.000000000000002, 
    111.92797`9.000000000000002, 112.923640583`11.999999999999998, 
    113.92185`9.000000000000002, 114.918048`9.000000000000002, 
    115.916808633`11.999999999999998, 116.91365`7.999999999999999, 
    117.913074`9.000000000000002, 118.910074`9.000000000000002, 
    119.910048173`11.999999999999998, 120.907366811`12.000000000000004, 
    121.907589284`12.000000000000004, 122.905588965`12.000000000000004, 
    123.906209852`12.000000000000004, 124.904630164`12.000000000000004, 
    125.905624153`11.999999999999998, 126.904472681`11.999999999999998, 
    127.905809443`12.000000000000004, 128.904987722`11.999999999999998, 
    129.906674247`12., 130.906124609`12.000000000000004, 
    131.907997381`12.000000000000004, 132.907796939`11.999999999999996, 
    133.909744465`11.999999999999998, 134.910048121`12.000000000000004, 
    135.914653993`11.999999999999998, 136.91787084`11.000000000000005, 
    137.922349591`12.000000000000004, 138.926099478`11.999999999999998, 
    139.931`9.000000000000002, 140.93503`9.000000000000002, 
    141.94018`9.000000000000002, 142.94456`9.000000000000002, 
    143.94999`9.000000000000002, 131.904153457`11.999999999999996, 
    109.944278068`12.000000000000004, 110.941602`9.000000000000002, 
    111.935623112`11.999999999999998, 112.933341174`12.000000000000004, 
    113.927980306`11.999999999999998, 114.92629392`10.999999999999996, 
    115.921581087`11.999999999999998, 116.920358735`11.999999999999998, 
    117.916178655`11.999999999999998, 118.915410688`12.000000000000004, 
    119.911784244`11.999999999999998, 120.911461829`12.000000000000004, 
    121.908367632`11.999999999999998, 122.90848191`11., 
    123.905893003`11.999999999999998, 124.906395464`12.000000000000004, 
    125.904273634`11.999999999999998, 126.905183723`11.999999999999998, 
    127.903531275`11.999999999999998, 128.904779435`11.999999999999998, 
    129.903508007`12., 130.905082362`11.999999999999998, 
    131.904153457`11.999999999999996, 132.905910722`12.000000000000004, 
    133.905394464`12.000000000000004, 134.907227495`12.000000000000004, 
    135.907218794`11.999999999999998, 136.911562125`12., 
    137.913954475`12.000000000000004, 138.918792936`12.000000000000004, 
    139.921640943`12., 140.926648049`12.000000000000004, 141.92970959`11., 
    142.93511`9.000000000000002, 143.93851`9.000000000000002, 
    144.94407`9.000000000000002, 145.94775`9.000000000000002, 
    146.95356`9.000000000000002, 132.905451932`12., 
    111.950301`9.000000000000002, 112.944493274`12.000000000000004, 
    113.94145`9.000000000000002, 114.93591`9.000000000000002, 
    115.933367`9.000000000000002, 116.928670701`11.999999999999998, 
    117.926559494`12.000000000000004, 118.922377304`11.999999999999998, 
    119.920677253`12.000000000000004, 120.917229209`11.999999999999998, 
    121.916113434`11.999999999999998, 122.912996036`12.000000000000004, 
    123.912257798`11.999999999999998, 124.90972827`11., 
    125.909451977`11.999999999999998, 126.907417525`11.999999999999998, 
    127.907748866`12.000000000000004, 128.906064426`11.999999999999998, 
    129.906708552`11.999999999999996, 130.905463926`11.999999999999998, 
    131.90643426`11., 132.905451932`12., 133.906718475`12.000000000000004, 
    134.905977008`12.000000000000004, 135.907311576`11.999999999999998, 
    136.907089473`11.999999999999996, 137.911016704`12.000000000000004, 
    138.913363999`12., 139.917282354`11.999999999999998, 
    140.920045752`11.999999999999998, 141.924298927`11.999999999999998, 
    142.92735175`11., 143.932076914`11.999999999999996, 144.93552617`11., 
    145.940289423`12.000000000000004, 146.944155008`12.000000000000004, 
    147.949218153`11.999999999999998, 148.95293`9.000000000000002, 
    149.95817`9.000000000000002, 150.96219`9.000000000000002, 
    137.905247237`12.000000000000004, 113.950675405`11.999999999999998, 
    114.94737`9.000000000000002, 115.94138`9.000000000000002, 
    116.938499`9.000000000000002, 117.93304`9.000000000000002, 
    118.930659661`12.000000000000004, 119.926044974`12.000000000000004, 
    120.924054499`11.999999999999998, 121.919904`9.000000000000002, 
    122.918781036`12.000000000000004, 123.915093603`12.000000000000004, 
    124.914472912`12.000000000000004, 125.911250177`12.000000000000004, 
    126.911093797`11.999999999999998, 127.908317698`11.999999999999998, 
    128.908679439`11.999999999999998, 129.906320811`12.000000000000004, 
    130.906941118`12.000000000000004, 131.905061288`11.999999999999998, 
    132.90600749`11., 133.904508383`12.000000000000004, 134.905688591`12., 
    135.904575945`12.000000000000004, 136.905827384`12., 
    137.905247237`12.000000000000004, 138.908841341`11.999999999999998, 
    139.910604505`11.999999999999998, 140.914411009`12., 141.91645341`11., 
    142.920626719`12., 143.922952853`12., 144.927627032`12.000000000000004, 
    145.930219572`11.999999999999998, 146.934945`9.000000000000002, 
    147.937720047`12.000000000000004, 148.94258`9.000000000000002, 
    149.94568`9.000000000000002, 150.95081`9.000000000000002, 
    151.95427`9.000000000000002, 152.95961`9.000000000000002, 
    138.906353267`11.999999999999998, 116.950068`9.000000000000002, 
    117.94673`9.000000000000002, 118.94099`9.000000000000002, 
    119.93807`9.000000000000002, 120.93301`9.000000000000002, 
    121.93071`9.000000000000002, 122.92624`9.000000000000002, 
    123.924574275`11.999999999999998, 124.920816034`11.999999999999998, 
    125.919512667`11.999999999999998, 126.916375448`12.000000000000004, 
    127.915585177`12.000000000000004, 128.912692815`12.000000000000004, 
    129.912368724`11.999999999999998, 130.91007`7.999999999999999, 
    131.910101145`11.999999999999998, 132.908218`9.000000000000002, 
    133.908514011`11.999999999999996, 134.906976844`12.000000000000004, 
    135.907635536`12.000000000000004, 136.906493598`12.000000000000004, 
    137.90711193`11., 138.906353267`11.999999999999998, 139.909477645`12., 
    140.910962152`11.999999999999998, 141.91407913`11., 142.91606272`11., 
    143.919599647`11.999999999999998, 144.921645401`11.999999999999996, 
    145.92579346`10.999999999999996, 146.928235284`11.999999999999998, 
    147.932228868`11.999999999999998, 148.934734`9.000000000000002, 
    149.93877`9.000000000000002, 150.94172`9.000000000000002, 
    151.94625`9.000000000000002, 152.94962`9.000000000000002, 
    153.9545`9.000000000000002, 154.95835`9.000000000000002, 
    139.905438706`11.999999999999996, 118.95276`9.000000000000002, 
    119.94664`9.000000000000002, 120.94342`9.000000000000002, 
    121.93791`9.000000000000002, 122.9354`9.000000000000002, 
    123.93041`9.000000000000002, 124.92844`9.000000000000002, 
    125.923971`9.000000000000002, 126.922731`9.000000000000002, 
    127.918911`9.000000000000002, 128.918102`9.000000000000002, 
    129.914736`9.000000000000002, 130.914422`9.000000000000002, 
    131.911460487`11.999999999999996, 132.91151502`11., 
    133.908924821`11.999999999999998, 134.909151396`11.999999999999998, 
    135.907172422`11.999999999999998, 136.907805577`11.999999999999996, 
    137.905991321`12.000000000000004, 138.906652651`11.999999999999998, 
    139.905438706`11.999999999999996, 140.90827627`11., 141.909244205`12., 
    142.91238591`11., 143.913647336`12.000000000000004, 144.917233135`12., 
    145.918759009`12., 146.922673954`11.999999999999998, 
    147.92443241`10.999999999999996, 148.928399883`11.999999999999996, 
    149.930408931`12.000000000000004, 150.933976196`12.000000000000004, 
    151.93654`9.000000000000002, 152.94058`9.000000000000002, 
    153.94342`9.000000000000002, 154.94804`9.000000000000002, 
    155.95126`9.000000000000002, 156.95634`9.000000000000002, 
    140.907652769`11.999999999999996, 120.955364`9.000000000000002, 
    121.95181`9.000000000000002, 122.94596`9.000000000000002, 
    123.94296`9.000000000000002, 124.93783`9.000000000000002, 
    125.93531`9.000000000000002, 126.93083`9.000000000000002, 
    127.928791`9.000000000000002, 128.925095`9.000000000000002, 
    129.92359`7.999999999999999, 130.920259`9.000000000000002, 
    131.919255`9.000000000000002, 132.916330532`11.999999999999998, 
    133.915711737`11.999999999999998, 134.913111745`11.999999999999998, 
    135.912691611`11.999999999999996, 136.910705455`12.000000000000004, 
    137.910754636`11.999999999999998, 138.908938399`12., 
    139.909075874`11.999999999999998, 140.907652769`11.999999999999996, 
    141.910044806`12., 142.910816926`12.000000000000004, 
    143.913305245`12.000000000000004, 144.9145117`9.999999999999998, 
    145.917644336`12.000000000000004, 146.918995992`11.999999999999996, 
    147.922135026`11.999999999999996, 148.923717651`11.999999999999996, 
    149.926672997`12., 150.928318618`12.000000000000004, 
    151.931499225`11.999999999999998, 152.933838905`11.999999999999998, 
    153.937518153`11.999999999999998, 154.94012`9.000000000000002, 
    155.94427`9.000000000000002, 156.94743`9.000000000000002, 
    157.95198`9.000000000000002, 158.9555`9.000000000000002, 
    141.907723297`12.000000000000004, 123.95223`9.000000000000002, 
    124.94888`9.000000000000002, 125.94322`9.000000000000002, 
    126.9405`9.000000000000002, 127.93539`9.000000000000002, 
    128.933188`9.000000000000002, 129.928506`9.000000000000002, 
    130.927247`9.000000000000002, 131.923321237`12.000000000000004, 
    132.922348`9.000000000000002, 133.918790181`11.999999999999998, 
    134.91818116`11., 135.914976035`11.999999999999998, 
    136.914567137`11.999999999999998, 137.911949961`12., 
    138.911978288`12.000000000000004, 139.909552`9.000000000000002, 
    140.909609854`12.000000000000004, 141.907723297`12.000000000000004, 
    142.90981429`11., 143.910087274`12.000000000000004, 144.912573636`12., 
    145.913116939`11.999999999999998, 146.916100441`11.999999999999998, 
    147.916893288`11.999999999999996, 148.920148842`12.000000000000004, 
    149.920890888`12.000000000000004, 150.923828929`12.000000000000004, 
    151.924682219`12., 152.927698232`12.000000000000004, 
    153.929477307`11.999999999999998, 154.932932`9.000000000000002, 
    155.935018114`12.000000000000004, 156.93903`9.000000000000002, 
    157.9416`9.000000000000002, 158.94609`9.000000000000002, 
    159.94909`9.000000000000002, 160.95388`9.000000000000002, 
    144.912749023`12.000000000000004, 125.95752`9.000000000000002, 
    126.95163`9.000000000000002, 127.94842`9.000000000000002, 
    128.94316`9.000000000000002, 129.94045`9.000000000000002, 
    130.93587`9.000000000000002, 131.93375`9.000000000000002, 
    132.929782`9.000000000000002, 133.928353`9.000000000000002, 
    134.924876`9.000000000000002, 135.923565829`11.999999999999998, 
    136.920479493`11.999999999999996, 137.919548281`11.999999999999996, 
    138.916804082`12.000000000000004, 139.916041789`11.999999999999998, 
    140.913555054`11.999999999999998, 141.912874471`12., 
    142.910932616`11.999999999999998, 143.912590843`11.999999999999998, 
    144.912749023`12.000000000000004, 145.914696305`12.000000000000004, 
    146.915138545`12., 147.917474618`11.999999999999996, 
    148.918334155`12.000000000000004, 149.920983561`12., 
    150.921206973`11.999999999999998, 151.923496795`12.000000000000004, 
    152.924116889`11.999999999999998, 153.926463943`11.999999999999998, 
    154.928101267`12.000000000000004, 155.931056736`11.999999999999998, 
    156.933039369`12., 157.936561407`11.999999999999998, 
    158.93897`9.000000000000002, 159.94299`9.000000000000002, 
    160.94586`9.000000000000002, 161.95029`9.000000000000002, 
    162.95368`9.000000000000002, 151.919732425`12.000000000000004, 
    127.95808`9.000000000000002, 128.95464`9.000000000000002, 
    129.94892`9.000000000000002, 130.94611`9.000000000000002, 
    131.94069`9.000000000000002, 132.93867`9.000000000000002, 
    133.93397`9.000000000000002, 134.93252`7.999999999999999, 
    135.928275527`12., 136.926971746`12.000000000000004, 
    137.923243961`11.999999999999998, 138.922296605`12.000000000000004, 
    139.918994687`12.000000000000004, 140.918476488`12.000000000000004, 
    141.915197641`11.999999999999998, 142.914628338`11.999999999999996, 
    143.911999478`12., 144.913410353`12.000000000000004, 
    145.9130409`10.000000000000004, 146.914897923`11.999999999999998, 
    147.914822674`12.000000000000004, 148.917184735`11.999999999999996, 
    149.917275539`12.000000000000004, 150.919932409`12.000000000000004, 
    151.919732425`12.000000000000004, 152.922097356`12.000000000000004, 
    153.922209273`12.000000000000004, 154.924640161`11.999999999999998, 
    155.925527887`12.000000000000004, 156.928358717`12.000000000000004, 
    157.929991317`11.999999999999998, 158.933211271`11.999999999999998, 
    159.93514`9.000000000000002, 160.93883`9.000000000000002, 
    161.94122`9.000000000000002, 162.94536`9.000000000000002, 
    163.94828`9.000000000000002, 164.95298`9.000000000000002, 
    152.921230339`12., 129.963569`9.000000000000002, 
    130.957753`9.000000000000002, 131.95437`9.000000000000002, 
    132.94924`9.000000000000002, 133.94651`9.000000000000002, 
    134.94182`9.000000000000002, 135.9396`9.000000000000002, 
    136.93557`9.000000000000002, 137.933709`9.000000000000002, 
    138.92979228`10.999999999999996, 139.928087607`11.999999999999998, 
    140.92493072`10.999999999999996, 141.923434945`11.999999999999998, 
    142.920297509`11.999999999999998, 143.918816823`11.999999999999996, 
    144.916265237`11.999999999999996, 145.917205817`12.000000000000004, 
    146.916746111`12.000000000000004, 147.918085895`11.999999999999998, 
    148.917931238`12.000000000000004, 149.919701819`11.999999999999998, 
    150.919850161`11.999999999999998, 151.921744534`11.999999999999996, 
    152.921230339`12., 153.922979237`11.999999999999996, 154.92289326`11., 
    155.924752249`11.999999999999998, 156.925423647`12.000000000000004, 
    157.927845302`11.999999999999998, 158.929088861`11.999999999999998, 
    159.931971`9.000000000000002, 160.93368`9.000000000000002, 
    161.93704`9.000000000000002, 162.93921`9.000000000000002, 
    163.94299`9.000000000000002, 164.94572`9.000000000000002, 
    165.94997`9.000000000000002, 166.95321`9.000000000000002, 
    157.924103912`11.999999999999998, 133.95537`9.000000000000002, 
    134.95257`9.000000000000002, 135.94734`9.000000000000002, 
    136.94502`9.000000000000002, 137.94012`9.000000000000002, 
    138.93824`9.000000000000002, 139.933674`9.000000000000002, 
    140.932126`9.000000000000002, 141.928116`9.000000000000002, 
    142.92674951`11., 143.922963`9.000000000000002, 
    144.921709252`11.999999999999998, 145.918310608`12.000000000000004, 
    146.91909442`11., 147.918114524`12.000000000000004, 
    148.919340915`11.999999999999998, 149.918658876`11.999999999999998, 
    150.920348482`11.999999999999998, 151.919790996`12.000000000000004, 
    152.921749543`12., 153.920865598`12.000000000000004, 
    154.922622022`12.000000000000004, 155.922122743`12.000000000000004, 
    156.923960135`11.999999999999998, 157.924103912`11.999999999999998, 
    158.926388658`11.999999999999996, 159.927054146`12.000000000000004, 
    160.929669211`11.999999999999998, 161.930984751`12.000000000000004, 
    162.93399`9.000000000000002, 163.93586`9.000000000000002, 
    164.93938`9.000000000000002, 165.9416`9.000000000000002, 
    166.94557`9.000000000000002, 167.94836`9.000000000000002, 
    168.95287`9.000000000000002, 158.925346757`11.999999999999998, 
    135.96138`9.000000000000002, 136.95598`9.000000000000002, 
    137.95316`9.000000000000002, 138.94829`9.000000000000002, 
    139.945805049`11.999999999999998, 140.941448`9.000000000000002, 
    141.938744`9.000000000000002, 142.935121`9.000000000000002, 
    143.933045`9.000000000000002, 144.929274`9.000000000000002, 
    145.927246584`11.999999999999998, 146.924044585`12.000000000000004, 
    147.924271701`12., 148.923245909`11.999999999999996, 
    149.923659686`12.000000000000004, 150.923102543`12.000000000000004, 
    151.924074438`12.000000000000004, 152.923434588`12.000000000000004, 
    153.924678019`11.999999999999998, 154.923505236`11.999999999999998, 
    155.924747213`11.999999999999998, 156.924024604`12.000000000000004, 
    157.925413137`11.999999999999998, 158.925346757`11.999999999999998, 
    159.927167606`11.999999999999996, 160.927569919`12., 
    161.929488234`12.000000000000004, 162.930647536`11.999999999999998, 
    163.933350838`11.999999999999998, 164.93488`9.000000000000002, 
    165.937991959`11.999999999999998, 166.94005`9.000000000000002, 
    167.94364`9.000000000000002, 168.94622`9.000000000000002, 
    169.95025`9.000000000000002, 170.9533`9.000000000000002, 
    163.929174751`11.999999999999998, 137.96249`9.000000000000002, 
    138.95954`9.000000000000002, 139.95401`9.000000000000002, 
    140.95135`9.000000000000002, 141.946366`9.000000000000002, 
    142.94383`9.000000000000002, 143.939254`9.000000000000002, 
    144.937425`9.000000000000002, 145.932845369`11.999999999999996, 
    146.9310915`10., 147.927149831`12.000000000000004, 
    148.927304787`11.999999999999996, 149.925585184`12., 
    150.926184601`12.000000000000004, 151.9247183`9.999999999999998, 
    152.92576467`11., 153.924424457`11.999999999999998, 
    154.925753775`11.999999999999998, 155.92428311`11., 
    156.925466095`11.999999999999998, 157.924409487`12.000000000000004, 
    158.925739214`12.000000000000004, 159.925197517`11.999999999999996, 
    160.926933364`12., 161.926798447`12., 162.928731159`12.000000000000004, 
    163.929174751`11.999999999999998, 164.931703333`11.999999999999998, 
    165.932806741`11.999999999999998, 166.935655462`11.999999999999998, 
    167.937128769`11.999999999999998, 168.940307614`11.999999999999998, 
    169.94239`9.000000000000002, 170.9462`9.000000000000002, 
    171.94876`9.000000000000002, 172.953`9.000000000000002, 164.93032207`11., 
    139.968539`9.000000000000002, 140.963098`9.000000000000002, 
    141.95977`9.000000000000002, 142.95461`9.000000000000002, 
    143.95148`9.000000000000002, 144.9472`9.000000000000002, 
    145.94464`9.000000000000002, 146.940056`9.000000000000002, 
    147.937718`9.000000000000002, 148.933774771`11.999999999999998, 
    149.933496182`11.999999999999998, 150.931688142`12.000000000000004, 
    151.931713714`11.999999999999998, 152.930198789`12.000000000000004, 
    153.930601579`12.000000000000004, 154.929103491`12.000000000000004, 
    155.929839`9.000000000000002, 156.928256188`12.000000000000004, 
    157.928941007`11.999999999999998, 158.927711959`11.999999999999998, 
    159.928729478`12.000000000000004, 160.927854776`12.000000000000004, 
    161.929095504`12.000000000000004, 162.928733903`12.000000000000004, 
    163.930233507`12.000000000000004, 164.93032207`11., 
    165.932284162`11.999999999999998, 166.933132633`11.999999999999998, 
    167.935515708`12.000000000000004, 168.936872273`11.999999999999998, 
    169.939618929`12.000000000000004, 170.94146515`11., 
    171.94482`9.000000000000002, 172.94729`9.000000000000002, 
    173.95115`9.000000000000002, 174.95405`9.000000000000002, 
    165.930293061`12., 142.96634`9.000000000000002, 
    143.96038`9.000000000000002, 144.95739`9.000000000000002, 
    145.952`9.000000000000002, 146.94949`9.000000000000002, 
    147.94455`9.000000000000002, 148.942306`9.000000000000002, 
    149.937913839`12.000000000000004, 150.937448903`11.999999999999998, 
    151.935050389`11.999999999999996, 152.935063492`12.000000000000004, 
    153.932783081`11.999999999999998, 154.933208949`12., 
    155.931064698`11.999999999999998, 156.931916`9.000000000000002, 
    157.929893474`11.999999999999998, 158.930684066`12.000000000000004, 
    159.929083292`11.999999999999998, 160.929995309`12.000000000000004, 
    161.928778264`11.999999999999996, 162.930032749`11.999999999999998, 
    163.929200229`12.000000000000004, 164.930726003`12.000000000000004, 
    165.930293061`12., 166.932048159`12.000000000000004, 167.932370224`12., 
    168.934590364`12., 169.935464312`11.999999999999998, 
    170.938029808`11.999999999999996, 171.939356113`12.000000000000004, 
    172.9424`9.000000000000002, 173.94423`9.000000000000002, 
    174.94777`9.000000000000002, 175.95008`9.000000000000002, 
    176.95405`9.000000000000002, 168.93421325`11.000000000000005, 
    144.970073`9.000000000000002, 145.966425`9.000000000000002, 
    146.960961`9.000000000000002, 147.95784`9.000000000000002, 
    148.95272`9.000000000000002, 149.94996`9.000000000000002, 
    150.94548349`11.000000000000005, 151.944422`9.000000000000002, 
    152.942012112`12.000000000000004, 153.941567808`11.999999999999998, 
    154.939199459`12.000000000000004, 155.938979933`12.000000000000004, 
    156.936973`9.000000000000002, 157.936979525`12.000000000000004, 
    158.934975`9.000000000000002, 159.935262801`11.999999999999998, 
    160.933549`9.000000000000002, 161.933994682`11.999999999999996, 
    162.932651124`12.000000000000004, 163.93356`7.999999999999999, 
    164.932435492`12.000000000000004, 165.933554131`12.000000000000004, 
    166.932851622`11.999999999999996, 167.934172776`11.999999999999998, 
    168.93421325`11.000000000000005, 169.935801397`12.000000000000004, 
    170.93642944`11., 171.938400044`12., 172.939603607`11.999999999999998, 
    173.942168605`12., 174.943836853`11.999999999999996, 
    175.946994685`11.999999999999996, 176.94904`9.000000000000002, 
    177.95264`9.000000000000002, 178.95534`9.000000000000002, 
    173.938862089`11.999999999999996, 147.96742`9.000000000000002, 
    148.96404`9.000000000000002, 149.95842`9.000000000000002, 
    150.955400769`11.999999999999998, 151.950288919`11.999999999999998, 
    152.94948`9.000000000000002, 153.946393928`11.999999999999998, 
    154.945782332`12.000000000000004, 155.942818215`12.000000000000004, 
    156.942627848`12.000000000000004, 157.939865617`12.000000000000004, 
    158.940050099`12., 159.937552344`11.999999999999998, 
    160.937901678`11.999999999999996, 161.93576821`11.000000000000005, 
    162.936334305`12.000000000000004, 163.934489416`12.000000000000004, 
    164.935279`9.000000000000002, 165.933882042`11.999999999999998, 
    166.934949605`12.000000000000004, 167.933896895`11.999999999999998, 
    168.935189802`12.000000000000004, 169.934761837`11.999999999999998, 
    170.936325799`11.999999999999998, 171.936381469`12., 
    172.938210787`11.999999999999998, 173.938862089`11.999999999999996, 
    174.94127645`11., 175.942571683`12.000000000000004, 
    176.945260822`11.999999999999998, 177.94664668`11., 
    178.95017`9.000000000000002, 179.95233`9.000000000000002, 
    180.95615`9.000000000000002, 174.940771819`12.000000000000004, 
    149.973228`9.000000000000002, 150.967577`9.000000000000002, 
    151.96412`9.000000000000002, 152.958767331`12.000000000000004, 
    153.957522`9.000000000000002, 154.954316216`12.000000000000004, 
    155.953032523`11.999999999999998, 156.9500983`10., 
    157.949313283`11.999999999999996, 158.946628776`12.000000000000004, 
    159.946033`9.000000000000002, 160.943572`9.000000000000002, 
    161.943277288`12., 162.941179`9.000000000000002, 
    163.941339`9.000000000000002, 164.939406724`12., 
    165.939859`9.000000000000002, 166.93827`7.999999999999999, 
    167.938739111`12.000000000000004, 168.937651439`12., 
    169.938474968`12.000000000000004, 170.937913136`12.000000000000004, 
    171.939085669`11.999999999999998, 172.938930602`11.999999999999998, 
    173.94033748`11., 174.940771819`12.000000000000004, 175.94268631`11., 
    176.943758055`12., 177.945954559`12., 178.947327443`12., 179.94988116`11.,
     180.95197`9.000000000000002, 181.95504`9.000000000000002, 
    182.95757`9.000000000000002, 183.96091`9.000000000000002, 
    179.946549953`12.000000000000004, 152.97069`9.000000000000002, 
    153.96486`9.000000000000002, 154.96339`9.000000000000002, 
    155.959364025`12.000000000000004, 156.958396`9.000000000000002, 
    157.954799366`12., 158.95399487`11.000000000000005, 
    159.950684379`11.999999999999996, 160.950274844`12.000000000000004, 
    161.947210498`12.000000000000004, 162.947089`9.000000000000002, 
    163.944367284`11.999999999999996, 164.944567`9.000000000000002, 
    165.94218`7.999999999999999, 166.9426`7.000000000000001, 
    167.940568`9.000000000000002, 168.941259`9.000000000000002, 
    169.939609`9.000000000000002, 170.940492`9.000000000000002, 
    171.939448301`11.999999999999996, 172.940513`9.000000000000002, 
    173.940046178`12.000000000000004, 174.941509181`11.999999999999998, 
    175.941408631`11.999999999999996, 176.943220651`11.999999999999996, 
    177.943698766`12.000000000000004, 178.945816145`12.000000000000004, 
    179.946549953`12.000000000000004, 180.949101246`11.999999999999998, 
    181.950554096`11.999999999999998, 182.953530439`12.000000000000004, 
    183.955446515`12.000000000000004, 184.95882`9.000000000000002, 
    185.96089`9.000000000000002, 186.96459`9.000000000000002, 
    187.96685`9.000000000000002, 180.947995763`12.000000000000004, 
    154.974592`9.000000000000002, 155.972303`9.000000000000002, 
    156.968192445`12.000000000000004, 157.966699`9.000000000000002, 
    158.963018173`11.999999999999998, 159.961486056`12.000000000000004, 
    160.958417`9.000000000000002, 161.957291859`12.000000000000004, 
    162.954330271`11.999999999999998, 163.953534`9.000000000000002, 
    164.950772514`12.000000000000004, 165.950512`9.000000000000002, 
    166.948093`9.000000000000002, 167.948047`9.000000000000002, 
    168.946011`9.000000000000002, 169.946175`9.000000000000002, 
    170.944476`9.000000000000002, 171.944895`9.000000000000002, 
    172.94375`7.999999999999999, 173.944454`9.000000000000002, 
    174.943737`9.000000000000002, 175.944857`9.000000000000002, 
    176.944472403`12.000000000000004, 177.945778221`12.000000000000004, 
    178.945929535`11.999999999999998, 179.947464831`12., 
    180.947995763`12.000000000000004, 181.950151849`11.999999999999996, 
    182.951372616`11.999999999999998, 183.954007966`11.999999999999998, 
    184.955559375`12.000000000000004, 185.958552023`11.999999999999996, 
    186.96053`9.000000000000002, 187.9637`9.000000000000002, 
    188.96583`9.000000000000002, 189.96923`9.000000000000002, 
    183.950931188`12.000000000000004, 157.974562`9.000000000000002, 
    158.972918`9.000000000000002, 159.968478805`12.000000000000004, 
    160.967357`9.000000000000002, 161.963497417`12.000000000000004, 
    162.962523542`12.000000000000004, 163.958954382`12.000000000000004, 
    164.958279949`11.999999999999998, 165.955027253`11.999999999999996, 
    166.954816014`11.999999999999996, 167.951808394`12.000000000000004, 
    168.95177879`11., 169.949228482`11.999999999999998, 
    170.949451`9.000000000000002, 171.947292`9.000000000000002, 
    172.947689`9.000000000000002, 173.946079`9.000000000000002, 
    174.946717`9.000000000000002, 175.945634`9.000000000000002, 
    176.946643`9.000000000000002, 177.945876236`11.999999999999996, 
    178.947070447`12.000000000000004, 179.946704459`11.999999999999996, 
    180.948197248`12.000000000000004, 181.948204156`12., 182.950222951`12., 
    183.950931188`12.000000000000004, 184.953419264`11.999999999999998, 
    185.954364127`11.999999999999996, 186.957160466`12.000000000000004, 
    187.958489105`12.000000000000004, 188.961912868`12.000000000000004, 
    189.963181378`11.999999999999998, 190.9666`9.000000000000002, 
    191.96817`9.000000000000002, 186.955753109`12., 
    159.982115`9.000000000000002, 160.977589119`12.000000000000004, 
    161.976002`9.000000000000002, 162.972080535`12.000000000000004, 
    163.970323`9.000000000000002, 164.967088557`12., 
    165.965808`9.000000000000002, 166.962601`9.000000000000002, 
    167.961572608`12.000000000000004, 168.958791096`11.999999999999998, 
    169.958220071`11.999999999999996, 170.955716`9.000000000000002, 
    171.955422961`12.000000000000004, 172.953243`9.000000000000002, 
    173.953115`9.000000000000002, 174.951381`9.000000000000002, 
    175.951623`9.000000000000002, 176.950328`9.000000000000002, 
    177.950989`9.000000000000002, 178.949987641`12.000000000000004, 
    179.950789084`11.999999999999998, 180.950067916`12., 181.95121008`11., 
    182.950819841`11.999999999999998, 183.952520756`12., 184.952954982`12., 
    185.954986084`11.999999999999998, 186.955753109`12., 
    187.958114438`11.999999999999998, 188.959229007`11.999999999999998, 
    189.961817977`11.999999999999998, 190.963125242`12.000000000000004, 
    191.96596`9.000000000000002, 192.96747`9.000000000000002, 
    193.97042`9.000000000000002, 191.96148069`11., 
    161.984431`9.000000000000002, 162.98269`9.000000000000002, 
    163.978035649`12.000000000000004, 164.976762`9.000000000000002, 
    165.972690753`12.000000000000004, 166.971547969`11.999999999999998, 
    167.967803678`12.000000000000004, 168.96701927`11., 
    169.963577028`12.000000000000004, 170.963184819`12.000000000000004, 
    171.960023303`12., 172.959808409`11.999999999999998, 173.957062202`12., 
    174.956945835`12.000000000000004, 175.954806`9.000000000000002, 
    176.954965324`12.000000000000004, 177.953251241`11.999999999999998, 
    178.953816017`12.000000000000004, 179.952378803`12.000000000000004, 
    180.953244`9.000000000000002, 181.952110186`11.999999999999998, 
    182.953126102`11.999999999999998, 183.952489071`12., 
    184.954042265`11.999999999999998, 185.953838158`11.999999999999998, 
    186.955750458`11.999999999999996, 187.955838228`12., 
    188.95814747`10.999999999999996, 189.958447048`12.000000000000004, 
    190.960929718`11.999999999999998, 191.96148069`11., 
    192.964151563`11.999999999999998, 193.965182083`12.000000000000004, 
    194.968126661`11.999999999999998, 195.969639333`12.000000000000004, 
    192.96292643`11.000000000000005, 163.992201`9.000000000000002, 
    164.98752`9.000000000000002, 165.985824`9.000000000000002, 
    166.981665156`12.000000000000004, 167.979881`9.000000000000002, 
    168.976294942`11.999999999999998, 169.974965`9.000000000000002, 
    170.971626042`12.000000000000004, 171.970456`9.000000000000002, 
    172.967501739`11.999999999999998, 173.966861045`11.999999999999996, 
    174.964112895`12.000000000000004, 175.963648688`12.000000000000004, 
    176.9613015`9.999999999999998, 177.961082`9.000000000000002, 
    178.959122266`12.000000000000004, 179.959229446`12., 
    180.957625297`12.000000000000004, 181.958076296`12.000000000000004, 
    182.956846458`11.999999999999998, 183.957476`9.000000000000002, 
    184.956698`9.000000000000002, 185.957946104`12.000000000000004, 
    186.957363361`11.999999999999998, 187.958853121`11.999999999999998, 
    188.958718935`11.999999999999996, 189.960545968`11.999999999999998, 
    190.960594046`12.000000000000004, 191.962605012`12.000000000000004, 
    192.96292643`11.000000000000005, 193.965078378`12.000000000000004, 
    194.965979573`12.000000000000004, 195.968396542`12.000000000000004, 
    196.969653285`12., 197.97228`9.000000000000002, 
    198.973804583`11.999999999999998, 194.964791134`11.999999999999998, 
    165.994855`9.000000000000002, 166.992979`9.000000000000002, 
    167.988150742`11.999999999999998, 168.986715`9.000000000000002, 
    169.982495289`12.000000000000004, 170.981244542`12.000000000000004, 
    171.977347128`11.999999999999998, 172.976444754`11.999999999999998, 
    173.972818767`11.999999999999996, 174.972420552`11.999999999999996, 
    175.968944622`12., 176.968469481`11.999999999999998, 
    177.965648724`11.999999999999998, 178.965363404`12.000000000000004, 
    179.963031477`12.000000000000004, 180.963097285`12.000000000000004, 
    181.961170656`11.999999999999996, 182.961596703`12.000000000000004, 
    183.959922251`11.999999999999996, 184.960619`9.000000000000002, 
    185.959350813`12.000000000000004, 186.960587`9.000000000000002, 
    187.959395391`12.000000000000004, 188.960833686`12.000000000000004, 
    189.959931655`11.999999999999998, 190.961676661`12., 
    191.961038005`11.999999999999996, 192.962987401`11.999999999999996, 
    193.962680253`11.999999999999996, 194.964791134`11.999999999999998, 
    195.964951521`12.000000000000004, 196.967340182`12., 197.96789279`11., 
    198.970593094`12.000000000000004, 199.971440677`11.999999999999998, 
    200.974512868`11.999999999999998, 201.97574`9.000000000000002, 
    196.966568662`12.000000000000004, 168.99808`9.000000000000002, 
    169.996122`9.000000000000002, 170.991878881`12., 
    171.990035`9.000000000000002, 172.98623738`11., 
    173.984761`9.000000000000002, 174.981274107`11.999999999999998, 
    175.980099`9.000000000000002, 176.976864908`11.999999999999998, 
    177.97603192`11., 178.973212812`12., 179.972521124`12.000000000000004, 
    180.970079048`11.999999999999998, 181.969617874`11.999999999999998, 
    182.967593034`12.000000000000004, 183.967451524`12.000000000000004, 
    184.965789411`11.999999999999998, 185.965952703`11.999999999999998, 
    186.964567541`11.999999999999996, 187.965323661`11.999999999999998, 
    188.963948286`11.999999999999998, 189.964700339`11.999999999999998, 
    190.963704225`11.999999999999998, 191.964812953`11.999999999999998, 
    192.964149715`12.000000000000004, 193.96536525`11., 194.96503464`11., 
    195.966569813`12.000000000000004, 196.966568662`12.000000000000004, 
    197.968242303`12.000000000000004, 198.968765193`11.999999999999996, 
    199.970725647`12.000000000000004, 200.97165724`11., 
    201.973805838`11.999999999999998, 202.975154542`12.000000000000004, 
    203.977724`9.000000000000002, 204.97987`9.000000000000002, 
    201.970643011`12.000000000000004, 171.00376`9.000000000000002, 
    171.998832686`12., 172.997242`9.000000000000002, 173.992863695`12., 
    174.99142327`11.000000000000005, 175.98735458`11., 176.986279158`12., 
    177.982483143`12., 178.981833861`11.999999999999996, 
    179.978266394`11.999999999999998, 180.977819311`11.999999999999998, 
    181.974689964`12.000000000000004, 182.974449841`11.999999999999998, 
    183.971713051`12.000000000000004, 184.971899086`11.999999999999998, 
    185.96936179`11., 186.969814236`11.999999999999996, 187.967577049`12., 
    188.968190034`12.000000000000004, 189.966322449`12.000000000000004, 
    190.967157105`12.000000000000004, 191.965634327`12.000000000000004, 
    192.966665421`12.000000000000004, 193.965439409`12.000000000000004, 
    194.966720113`11.999999999999996, 195.965832649`11.999999999999998, 
    196.967212908`11.999999999999996, 197.966769032`11.999999999999998, 
    198.968279932`11.999999999999998, 199.968326004`12.000000000000004, 
    200.970302268`11.999999999999996, 201.970643011`12.000000000000004, 
    202.972872484`12., 203.973493933`11.999999999999998, 
    204.976073386`11.999999999999996, 205.977514066`12.000000000000004, 
    206.982588545`12.000000000000004, 207.98594`9.000000000000002, 
    208.99104`9.000000000000002, 209.99451`9.000000000000002, 
    204.974427541`11.999999999999996, 176.00059`9.000000000000002, 
    176.996427286`11.999999999999998, 177.994897`9.000000000000002, 
    178.991089082`12., 179.989906`9.000000000000002, 
    180.986257447`11.999999999999998, 181.985667104`12.000000000000004, 
    182.982192802`11.999999999999998, 183.981873122`11.999999999999996, 
    184.978791305`12.000000000000004, 185.978325`9.000000000000002, 
    186.975905897`11.999999999999998, 187.976009782`11.999999999999998, 
    188.973588428`12.000000000000004, 189.973877149`11.999999999999996, 
    190.971786154`12.000000000000004, 191.972225`9.000000000000002, 
    192.970672`9.000000000000002, 193.9712`7.000000000000001, 
    194.969774335`12.000000000000004, 195.970481151`12., 
    196.969574511`11.999999999999998, 197.970483495`12., 
    198.969877`9.000000000000002, 199.970962672`12.000000000000004, 
    200.970818891`11.999999999999998, 201.972105808`12.000000000000004, 
    202.97234422`11., 203.973863522`12.000000000000004, 
    204.974427541`11.999999999999996, 205.97611032`11., 
    206.977419429`11.999999999999998, 207.9820187`10., 
    208.985358952`12.000000000000004, 209.990073689`12.000000000000004, 
    210.993477`9.000000000000002, 211.998228`9.000000000000002, 
    207.976652071`11.999999999999996, 178.003830191`11.999999999999998, 
    179.00215`9.000000000000002, 179.997918173`12.000000000000004, 
    180.996623958`11.999999999999998, 181.992671842`11.999999999999998, 
    182.991874629`11.999999999999998, 183.988142339`11.999999999999996, 
    184.987609944`11.999999999999996, 185.984238945`12., 186.98391837`11., 
    187.980874338`11.999999999999996, 188.980807`9.000000000000002, 
    189.978081517`11.999999999999998, 190.978265`9.000000000000002, 
    191.975785171`12.000000000000004, 192.976173234`11.999999999999998, 
    193.97401207`11., 194.97454205`11., 195.972774109`12.000000000000004, 
    196.973431124`11.999999999999998, 197.972033959`11.999999999999998, 
    198.97291665`11., 199.971826675`11.999999999999996, 
    200.972884511`11.999999999999996, 201.972159133`11.999999999999998, 
    202.973390521`12.000000000000004, 203.973043589`11.999999999999996, 
    204.974481755`12.000000000000004, 205.974465278`11.999999999999998, 
    206.975896887`11.999999999999998, 207.976652071`11.999999999999996, 
    208.98109012`11., 209.984188527`11.999999999999998, 
    210.988736964`12.000000000000004, 211.991897543`11.999999999999998, 
    212.996581499`12., 213.999805408`11.999999999999996, 
    215.004807`9.000000000000002, 208.980398734`12., 
    184.001124`9.000000000000002, 184.997625`9.000000000000002, 
    185.996597625`11.999999999999998, 186.993157835`11.999999999999998, 
    187.992265154`12., 188.989199012`11.999999999999998, 
    189.988295129`12.000000000000004, 190.985786119`11.999999999999998, 
    191.985457954`12.000000000000004, 192.982959771`12., 
    193.98283396`10.999999999999996, 194.980650737`12., 
    195.980666509`11.999999999999996, 196.978864454`12.000000000000004, 
    197.979206`9.000000000000002, 198.977671961`11.999999999999998, 
    199.978131829`12., 200.977009036`11.999999999999998, 
    201.977742324`12.000000000000004, 202.976876001`12., 
    203.977812736`11.999999999999996, 204.977389366`12., 
    205.97849913`11.000000000000005, 206.978470679`11.999999999999998, 
    207.979742196`12.000000000000004, 208.980398734`12., 
    209.984120371`11.999999999999998, 210.98726946`11., 
    211.991285724`11.999999999999998, 212.994384666`11.999999999999998, 
    213.998711539`12.000000000000004, 215.001769776`11.999999999999998, 
    216.006305943`11.999999999999998, 217.00947`9.000000000000002, 
    218.014316`9.000000000000002, 208.982430435`12.000000000000004, 
    187.999422048`11.999999999999998, 188.998480562`12.000000000000004, 
    189.995101185`11.999999999999998, 190.994574485`12.000000000000004, 
    191.991335149`11.999999999999998, 192.991025275`12.000000000000004, 
    193.988185606`11.999999999999998, 194.988110728`11.999999999999998, 
    195.98553458`10.999999999999996, 196.98565963`10.999999999999996, 
    197.983388616`11.999999999999998, 198.983666063`11.999999999999996, 
    199.981798604`11.999999999999998, 200.982259764`11.999999999999998, 
    201.980757541`11.999999999999996, 202.981420103`11.999999999999998, 
    203.980318121`11.999999999999996, 204.981203322`12., 
    205.980481099`11.999999999999998, 206.981593173`12., 
    207.981245702`11.999999999999998, 208.982430435`12.000000000000004, 
    209.982873673`12.000000000000004, 210.986653154`11.999999999999996, 
    211.988867969`12.000000000000004, 212.99285728`11., 213.99520135`11., 
    214.999419988`11.999999999999998, 216.001915035`11.999999999999998, 
    217.006334796`11.999999999999998, 218.008973037`11.999999999999998, 
    219.013744`9.000000000000002, 220.016602`9.000000000000002, 
    210.987496271`12., 192.999843112`11.999999999999998, 
    193.998725085`11.999999999999996, 194.996268098`12.000000000000004, 
    195.995788077`12.000000000000004, 196.993189215`12., 
    197.992837202`11.999999999999998, 198.990532254`12., 
    199.990351264`11.999999999999996, 200.988416999`12., 
    201.988630236`11.999999999999998, 202.986941984`11.999999999999998, 
    203.987251326`12.000000000000004, 204.986074483`11.999999999999998, 
    205.986667036`11.999999999999998, 206.985783502`11.999999999999998, 
    207.986589977`11.999999999999996, 208.986173143`11.999999999999998, 
    209.98714771`11., 210.987496271`12., 211.990744771`11.999999999999998, 
    212.992936646`12., 213.996371733`11.999999999999998, 214.99865257`11., 
    216.002423257`11.999999999999998, 217.004718822`11.999999999999998, 
    218.008694336`12., 219.011161691`12.000000000000004, 
    220.015407682`11.999999999999998, 221.01805`9.000000000000002, 
    222.02233`9.000000000000002, 223.02519`9.000000000000002, 
    222.017577738`12.000000000000004, 195.005437696`12., 
    196.002115223`11.999999999999996, 197.001584351`12., 
    197.998678663`12.000000000000004, 198.998370297`12.000000000000004, 
    199.9956993`9.999999999999998, 200.995628335`12.000000000000004, 
    201.993263492`11.999999999999998, 202.993386687`12.000000000000004, 
    203.99142874`10.999999999999996, 204.991718799`12., 
    205.990214104`11.999999999999998, 206.990734225`11.999999999999998, 
    207.98964247`11.000000000000005, 208.990414742`12.000000000000004, 
    209.989696216`11.999999999999998, 210.990600523`12.000000000000004, 
    211.990703529`11.999999999999998, 212.993882668`12.000000000000004, 
    213.995362554`12.000000000000004, 214.998745483`12.000000000000004, 
    216.00027437`11., 217.003927675`11.999999999999998, 
    218.005601256`11.999999999999996, 219.009480204`12.000000000000004, 
    220.011393981`11.999999999999998, 221.015536782`11.999999999999998, 
    222.017577738`12.000000000000004, 223.02179`9.000000000000002, 
    224.02409`9.000000000000002, 225.02844`9.000000000000002, 
    226.03089`9.000000000000002, 227.035407`9.000000000000002, 
    228.037986`9.000000000000002, 222.01755173`11.000000000000005, 
    199.007258147`12., 200.00657249`11., 201.003860867`12., 
    202.003372847`12.000000000000004, 203.000924647`11.999999999999996, 
    204.000653204`12.000000000000004, 204.99859396`11., 
    205.998666066`11.999999999999996, 206.996949414`11.999999999999998, 
    207.997138783`12.000000000000004, 208.995953555`11.999999999999998, 
    209.996407738`11.999999999999998, 210.995536544`12.000000000000004, 
    211.996202244`11.999999999999998, 212.996189081`12.000000000000004, 
    213.998971145`11.999999999999998, 215.000341497`11.999999999999998, 
    216.00319799`11., 217.004631951`12., 218.007578322`11.999999999999998, 
    219.009252149`11.999999999999996, 220.012327405`11.999999999999998, 
    221.014254762`12., 222.01755173`11.000000000000005, 
    223.019735857`11.999999999999998, 224.023249951`12.000000000000004, 
    225.025565414`12.000000000000004, 226.029386231`12.000000000000004, 
    227.031835938`11.999999999999998, 228.035729`9.000000000000002, 
    229.038450228`12.000000000000004, 230.04251`9.000000000000002, 
    231.04544`9.000000000000002, 232.049772`9.000000000000002, 
    228.031070292`11.999999999999998, 202.009890686`12.000000000000004, 
    203.009271619`11.999999999999998, 204.006499668`11.999999999999998, 
    205.00626857`11.000000000000005, 206.00382727`11.000000000000005, 
    207.003798105`11.999999999999998, 208.00183994`11., 
    209.001991373`12.000000000000004, 210.000494978`12., 
    211.000897987`12.000000000000004, 211.999794499`12.000000000000004, 
    213.000383959`11.999999999999998, 214.000107894`11.999999999999996, 
    215.002719834`12.000000000000004, 216.003533035`12., 217.006320327`12., 
    218.00714023`11., 219.010085078`11.999999999999998, 220.011028384`12., 
    221.013917338`11.999999999999998, 222.01537453`11., 
    223.018502171`12.000000000000004, 224.020211821`11.999999999999998, 
    225.023611564`12.000000000000004, 226.025409823`12.000000000000004, 
    227.029177842`12.000000000000004, 228.031070292`11.999999999999998, 
    229.034957577`12., 230.037056394`12.000000000000004, 
    231.04122`9.000000000000002, 232.043638`9.000000000000002, 
    233.04806`9.000000000000002, 234.050704`9.000000000000002, 
    227.027752127`11.999999999999998, 206.01450498`11., 
    207.011949748`12.000000000000004, 208.011551551`11.999999999999998, 
    209.009494863`12.000000000000004, 210.009435986`11.999999999999998, 
    211.007734835`12., 212.007813822`11.999999999999998, 
    213.006607643`11.999999999999998, 214.006901798`11.999999999999998, 
    215.006453625`12., 216.008720075`12.000000000000004, 217.009346914`12., 
    218.011641453`11.999999999999998, 219.012420389`12.000000000000004, 
    220.014762979`12.000000000000004, 221.015591248`11.999999999999998, 
    222.017843851`11.999999999999998, 223.019137468`11.999999999999996, 
    224.021722866`12., 225.023229585`12.000000000000004, 
    226.026098089`11.999999999999998, 227.027752127`11.999999999999998, 
    228.031021112`11.999999999999998, 229.033015243`12., 
    230.036294178`11.999999999999998, 231.038558786`12.000000000000004, 
    232.042027438`11.999999999999998, 233.04455`9.000000000000002, 
    234.04842`9.000000000000002, 235.051232`9.000000000000002, 
    236.055296`9.000000000000002, 232.038055325`11.999999999999998, 
    209.017715682`11.999999999999998, 210.015075342`11.999999999999996, 
    211.014928413`11.999999999999998, 212.012980288`11.999999999999996, 
    213.01301014`11., 214.01149977`11., 215.01173033`11., 
    216.011062115`11.999999999999996, 217.013114328`11.999999999999998, 
    218.013284499`12., 219.015536895`12., 220.015747762`12.000000000000004, 
    221.018183674`11.999999999999996, 222.018468121`12.000000000000004, 
    223.020811448`12.000000000000004, 224.021466895`11.999999999999998, 
    225.023951021`11.999999999999996, 226.024903069`12.000000000000004, 
    227.02770407`11.000000000000005, 228.028741127`12.000000000000004, 
    229.03176243`11., 230.033133843`11.999999999999996, 
    231.036304343`11.999999999999998, 232.038055325`11.999999999999998, 
    233.041581843`11.999999999999998, 234.04360123`11., 
    235.047510074`12.000000000000004, 236.04987`9.000000000000002, 
    237.053894`9.000000000000002, 238.056496`9.000000000000002, 
    231.03588399`11.000000000000005, 212.023204138`11.999999999999998, 
    213.02110934`10.999999999999996, 214.020918417`11.999999999999998, 
    215.019185865`12., 216.019109564`11.999999999999998, 
    217.018323986`12.000000000000004, 218.020041889`12., 219.019883143`12., 
    220.021875303`11.999999999999998, 221.021877983`12., 
    222.023742`9.000000000000002, 223.023962273`11.999999999999998, 
    224.025625738`12.000000000000004, 225.026130678`12., 
    226.027947753`11.999999999999998, 227.028805072`11.999999999999998, 
    228.031051376`12.000000000000004, 229.032096793`12.000000000000004, 
    230.034540754`11.999999999999996, 231.03588399`11.000000000000005, 
    232.038591592`12.000000000000004, 233.040247277`12.000000000000004, 
    234.043308058`11.999999999999998, 235.045443615`11.999999999999998, 
    236.048681284`11.999999999999998, 237.051145659`11.999999999999998, 
    238.05450271`10.999999999999996, 239.05726`9.000000000000002, 
    240.06098`9.000000000000002, 238.050788247`11.999999999999998, 
    217.024368791`11.999999999999998, 218.023535671`11.999999999999998, 
    219.02491916`11., 220.024723`9.000000000000002, 
    221.026399`9.000000000000002, 222.026086`9.000000000000002, 
    223.0277386`9.999999999999998, 224.027604778`11.999999999999998, 
    225.029390717`12.000000000000004, 226.029338702`11.999999999999998, 
    227.031156367`12.000000000000004, 228.031374006`11.999999999999998, 
    229.033505939`12.000000000000004, 230.033939784`12.000000000000004, 
    231.036293704`11.999999999999998, 232.037156152`11.999999999999996, 
    233.039635207`12.000000000000004, 234.040952088`11.999999999999998, 
    235.043929918`11.999999999999998, 236.045568006`11.999999999999998, 
    237.048730184`12.000000000000004, 238.050788247`11.999999999999998, 
    239.054293299`11.999999999999998, 240.056591988`11.999999999999998, 
    241.06033`9.000000000000002, 242.062931`9.000000000000002, 
    237.048173444`12.000000000000004, 225.033913933`12., 
    226.035145`9.000000000000002, 227.034956789`11.999999999999998, 
    228.03618`9.000000000000002, 229.036263808`12.000000000000004, 
    230.037827597`12.000000000000004, 231.038245085`11.999999999999998, 
    232.040108`9.000000000000002, 233.040740546`12.000000000000004, 
    234.042895038`12.000000000000004, 235.044063267`11.999999999999998, 
    236.0465696`9.999999999999998, 237.048173444`12.000000000000004, 
    238.050946405`11.999999999999998, 239.052939025`12.000000000000004, 
    240.056162182`12.000000000000004, 241.058252431`12.000000000000004, 
    242.06164118`11., 243.064279`9.000000000000002, 
    244.06785`9.000000000000002, 242.058742611`11.999999999999998, 
    228.038742328`12.000000000000004, 229.040150212`11.999999999999998, 
    230.039649886`12.000000000000004, 231.041101107`12.000000000000004, 
    232.041187097`11.999999999999998, 233.042997375`12.000000000000004, 
    234.043317076`12.000000000000004, 235.04528605`11., 
    236.046057964`12.000000000000004, 237.048409658`11.999999999999998, 
    238.049559894`12.000000000000004, 239.052163381`12.000000000000004, 
    240.053813545`11.999999999999998, 241.056851456`12.000000000000004, 
    242.058742611`11.999999999999998, 243.062003092`11.999999999999998, 
    244.064203907`11.999999999999998, 245.067747154`11.999999999999998, 
    246.070204627`11.999999999999998, 247.07407`9.000000000000002, 
    243.06138108`10.999999999999996, 231.04556`9.000000000000002, 
    232.04659`9.000000000000002, 233.046348`9.000000000000002, 
    234.047809`9.000000000000002, 235.047946`9.000000000000002, 
    236.049579`9.000000000000002, 237.049996`9.000000000000002, 
    238.051984324`11.999999999999998, 239.053024479`12.000000000000004, 
    240.055300179`12.000000000000004, 241.056829144`12.000000000000004, 
    242.059549159`11.999999999999998, 243.06138108`10.999999999999996, 
    244.064284847`12.000000000000004, 245.066452114`11.999999999999998, 
    246.069774619`11.999999999999998, 247.072093`9.000000000000002, 
    248.075752`9.000000000000002, 249.07848`9.000000000000002, 
    247.07035354`11., 233.050771232`11.999999999999998, 
    234.050159841`11.999999999999998, 235.051434`9.000000000000002, 
    236.051413`9.000000000000002, 237.052901`9.000000000000002, 
    238.053028697`11.999999999999998, 239.054957`9.000000000000002, 
    240.055529539`11.999999999999998, 241.057653001`11.999999999999998, 
    242.058835824`12.000000000000004, 243.061389114`11.999999999999998, 
    244.062752578`12.000000000000004, 245.065491249`12.000000000000004, 
    246.067223662`12.000000000000004, 247.07035354`11., 
    248.072348508`12.000000000000004, 249.075953413`12.000000000000004, 
    250.078356959`12.000000000000004, 251.082284605`12.000000000000004, 
    252.08487`9.000000000000002, 247.07030708`10.999999999999996, 
    235.05658`9.000000000000002, 236.05733`9.000000000000002, 
    237.057003`9.000000000000002, 238.058281`9.000000000000002, 
    239.058279`9.000000000000002, 240.059759`9.000000000000002, 
    241.06023`9.000000000000002, 242.061981`9.000000000000002, 
    243.063007572`11.999999999999998, 244.065180774`11.999999999999998, 
    245.066361616`11.999999999999998, 246.068672947`11.999999999999998, 
    247.07030708`10.999999999999996, 248.073086`9.000000000000002, 
    249.074986657`11.999999999999998, 250.07831652`11., 
    251.080760172`12.000000000000004, 252.08431`9.000000000000002, 
    253.08688`9.000000000000002, 254.0906`9.000000000000002, 
    251.079586788`12.000000000000004, 237.06207`9.000000000000002, 
    238.06141`9.000000000000002, 239.062422`9.000000000000002, 
    240.062302`9.000000000000002, 241.063726`9.000000000000002, 
    242.063701552`12.000000000000004, 243.065427`9.000000000000002, 
    244.066000689`11.999999999999998, 245.068048612`11.999999999999998, 
    246.068805309`12.000000000000004, 247.071000589`12.000000000000004, 
    248.072184861`11.999999999999998, 249.074853537`11.999999999999998, 
    250.076406066`12.000000000000004, 251.079586788`12.000000000000004, 
    252.081625846`12.000000000000004, 253.085133145`12.000000000000004, 
    254.087322909`11.999999999999998, 255.091046`9.000000000000002, 
    256.09344`9.000000000000002, 252.082978512`11.999999999999998, 
    240.06892`9.000000000000002, 241.068538`9.000000000000002, 
    242.069745`9.000000000000002, 243.069548`9.000000000000002, 
    244.070883`9.000000000000002, 245.071324`9.000000000000002, 
    246.072896`9.000000000000002, 247.073656`9.000000000000002, 
    248.075471`9.000000000000002, 249.076411`9.000000000000002, 
    250.078612`9.000000000000002, 251.079992142`11.999999999999998, 
    252.082978512`11.999999999999998, 253.084824697`11.999999999999998, 
    254.088022021`12.000000000000004, 255.090273122`11.999999999999998, 
    256.093598`9.000000000000002, 257.095979`9.000000000000002, 
    258.09952`9.000000000000002, 257.095104724`12.000000000000004, 
    242.07343`9.000000000000002, 243.074353`9.000000000000002, 
    244.074084`9.000000000000002, 245.075385`9.000000000000002, 
    246.075299023`11.999999999999998, 247.076847`9.000000000000002, 
    248.077194714`11.999999999999998, 249.079034`9.000000000000002, 
    250.079521264`11.999999999999998, 251.081575017`12.000000000000004, 
    252.082466855`11.999999999999998, 253.085185236`12.000000000000004, 
    254.08685422`11., 255.089962202`11.999999999999998, 
    256.091773117`12.000000000000004, 257.095104724`12.000000000000004, 
    258.097076`9.000000000000002, 259.100595`9.000000000000002, 
    260.102678`9.000000000000002, 258.098431319`11.999999999999998, 
    245.080829`9.000000000000002, 246.081886`9.000000000000002, 
    247.081635`9.000000000000002, 248.082823`9.000000000000002, 
    249.083013`9.000000000000002, 250.08442`9.000000000000002, 
    251.084839`9.000000000000002, 252.08656`9.000000000000002, 
    253.08728`9.000000000000002, 254.089656`9.000000000000002, 
    255.091082705`12.000000000000004, 256.094059025`11.999999999999998, 
    257.095541368`11.999999999999998, 258.098431319`11.999999999999998, 
    259.100509`9.000000000000002, 260.103652`9.000000000000002, 
    261.105721`9.000000000000002, 262.108865`9.000000000000002, 
    255.093241131`12.000000000000004, 248.086596`9.000000000000002, 
    249.087833`9.000000000000002, 250.08751`9.000000000000002, 
    251.089012`9.000000000000002, 252.088976521`11.999999999999998, 
    253.090678`9.000000000000002, 254.090955253`12.000000000000004, 
    255.093241131`12.000000000000004, 256.094282666`12.000000000000004, 
    257.09687719`11., 258.098207`9.000000000000002, 
    259.101031`9.000000000000002, 260.102643`9.000000000000002, 
    261.105749`9.000000000000002, 262.107301`9.000000000000002, 
    263.110552`9.000000000000002, 264.112345`9.000000000000002, 
    260.105504`9.000000000000002, 251.09436`9.000000000000002, 
    252.095371`9.000000000000002, 253.09521`9.000000000000002, 
    254.096454`9.000000000000002, 255.096681`9.000000000000002, 
    256.098629`9.000000000000002, 257.099555`9.000000000000002, 
    258.101814`9.000000000000002, 259.102901`9.000000000000002, 
    260.105504`9.000000000000002, 261.106883`9.000000000000002, 
    262.109634`9.000000000000002, 263.111293`9.000000000000002, 
    264.114038`9.000000000000002, 265.115839`9.000000000000002, 
    266.119305`9.000000000000002, 263.112547`9.000000000000002, 
    253.100689`9.000000000000002, 254.100184`9.000000000000002, 
    255.10134`9.000000000000002, 256.101166194`12.000000000000004, 
    257.10299`9.000000000000002, 258.103489`9.000000000000002, 
    259.105637`9.000000000000002, 260.10644`9.000000000000002, 
    261.108766556`12.000000000000004, 262.109925`9.000000000000002, 
    263.112547`9.000000000000002, 264.113985`9.000000000000002, 
    265.116704`9.000000000000002, 266.117956`9.000000000000002, 
    267.121529`9.000000000000002, 268.123644`9.000000000000002, 
    255.107398`9.000000000000002, 255.107398`9.000000000000002, 
    256.108127`9.000000000000002, 257.107722`9.000000000000002, 
    258.109231`9.000000000000002, 259.10961`9.000000000000002, 
    260.1113`9.000000000000002, 261.112056`9.000000000000002, 
    262.114084`9.000000000000002, 263.114988`9.000000000000002, 
    264.117404`9.000000000000002, 265.118601`9.000000000000002, 
    266.121029`9.000000000000002, 267.122377`9.000000000000002, 
    268.125445`9.000000000000002, 269.12746`9.000000000000002, 
    270.130712`9.000000000000002, 259.1145`9.000000000000002, 
    258.113168`9.000000000000002, 259.1145`9.000000000000002, 
    260.114422071`12.000000000000004, 261.116117`9.000000000000002, 
    262.116398`9.000000000000002, 263.118322`9.000000000000002, 
    264.118931`9.000000000000002, 265.121114693`12.000000000000004, 
    266.122065`9.000000000000002, 267.124425`9.000000000000002, 
    268.125606`9.000000000000002, 269.128755`9.000000000000002, 
    270.130329`9.000000000000002, 271.133472`9.000000000000002, 
    272.135158`9.000000000000002, 273.13822`9.000000000000002, 
    262.122892`9.000000000000002, 260.12197`9.000000000000002, 
    261.121664`9.000000000000002, 262.122892`9.000000000000002, 
    263.123035`9.000000000000002, 264.124604`9.000000000000002, 
    265.125147`9.000000000000002, 266.126942`9.000000000000002, 
    267.12765`9.000000000000002, 268.129755`9.000000000000002, 
    269.130694`9.000000000000002, 270.133616`9.000000000000002, 
    271.135179`9.000000000000002, 272.138032`9.000000000000002, 
    273.139618`9.000000000000002, 274.14244`9.000000000000002, 
    275.14425`9.000000000000002, 263.128558`9.000000000000002, 
    263.128558`9.000000000000002, 264.128394885`11.999999999999998, 
    265.130085`9.000000000000002, 266.130097`9.000000000000002, 
    267.131789`9.000000000000002, 268.132162`9.000000000000002, 
    269.134056`9.000000000000002, 270.13465`9.000000000000002, 
    271.137657`9.000000000000002, 272.139052`9.000000000000002, 
    273.141986`9.000000000000002, 274.143131`9.000000000000002, 
    275.145952`9.000000000000002, 276.147208`9.000000000000002, 
    277.149841`9.000000000000002, 265.136151`9.000000000000002, 
    265.136151`9.000000000000002, 266.137299`9.000000000000002, 
    267.137307`9.000000000000002, 268.138728`9.000000000000002, 
    269.139055`9.000000000000002, 270.140657`9.000000000000002, 
    271.141139`9.000000000000002, 272.143738`9.000000000000002, 
    273.144913`9.000000000000002, 274.147492`9.000000000000002, 
    275.148647`9.000000000000002, 276.151156`9.000000000000002, 
    277.15242`9.000000000000002, 278.154812`9.000000000000002, 
    279.156193`9.000000000000002, 281.162061`9.000000000000002, 
    267.144341`9.000000000000002, 268.143795`9.000000000000002, 
    269.145124`9.000000000000002, 270.14472`9.000000000000002, 
    271.146062`9.000000000000002, 272.146317`9.000000000000002, 
    273.148863`9.000000000000002, 274.149492`9.000000000000002, 
    275.152176`9.000000000000002, 276.153034`9.000000000000002, 
    277.155647`9.000000000000002, 278.156469`9.000000000000002, 
    279.158861`9.000000000000002, 280.159795`9.000000000000002, 
    281.162061`9.000000000000002, 272.153615`9.000000000000002, 
    272.153615`9.000000000000002, 273.153682`9.000000000000002, 
    274.155713`9.000000000000002, 275.156142`9.000000000000002, 
    276.158493`9.000000000000002, 277.159519`9.000000000000002, 
    278.161604`9.000000000000002, 279.162468`9.000000000000002, 
    280.164473`9.000000000000002, 281.165372`9.000000000000002, 
    282.167486`9.000000000000002, 283.168415`9.000000000000002, 
    283.171792`9.000000000000002, 277.163943`9.000000000000002, 
    278.164312`9.000000000000002, 279.166546`9.000000000000002, 
    280.167039`9.000000000000002, 281.169286`9.000000000000002, 
    282.169765`9.000000000000002, 283.171792`9.000000000000002, 
    284.172384`9.000000000000002, 285.174105`9.000000000000002, 
    283.176451`9.000000000000002, 283.176451`9.000000000000002, 
    284.17808`9.000000000000002, 285.178732`9.000000000000002, 
    286.180481`9.000000000000002, 287.181045`9.000000000000002, 
    285.183698`9.000000000000002, 285.183698`9.000000000000002, 
    286.183855`9.000000000000002, 287.185599`9.000000000000002, 
    288.185689`9.000000000000002, 289.187279`9.000000000000002, 
    287.191186`9.000000000000002, 287.191186`9.000000000000002, 
    288.192492`9.000000000000002, 289.192715`9.000000000000002, 
    290.194141`9.000000000000002, 291.194384`9.000000000000002, 
    292.199786`9.000000000000002, 289.198862`9.000000000000002, 
    290.19859`9.000000000000002, 291.200011`9.000000000000002, 
    292.199786`9.000000000000002, 291.206564`9.000000000000002, 
    291.206564`9.000000000000002, 292.207549`9.000000000000002, 
    293.21467`9.000000000000002, 293.21467`9.000000000000002}],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581236150408*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581236258293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[mostcommonisotopemasslist]=\"\>", "\[InvisibleSpace]", 
   "119"}],
  SequenceForm["Length[mostcommonisotopemasslist]=", 119],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.4135812362925053`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[mostcommonisotopemasslistLabels]=\"\>", 
   "\[InvisibleSpace]", "119"}],
  SequenceForm["Length[mostcommonisotopemasslistLabels]=", 119],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581236342916*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[mostcommonisotopemasslistValues]=\"\>", 
   "\[InvisibleSpace]", "119"}],
  SequenceForm["Length[mostcommonisotopemasslistValues]=", 119],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.41358123639366*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[isotopemasslist]=\"\>", "\[InvisibleSpace]", "3298"}],
  SequenceForm["Length[isotopemasslist]=", 3298],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581236444653*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[isotopemasslistLabels]=\"\>", "\[InvisibleSpace]", 
   "3298"}],
  SequenceForm["Length[isotopemasslistLabels]=", 3298],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.413581236494122*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Length[isotopemasslistValues]=\"\>", "\[InvisibleSpace]", 
   "3298"}],
  SequenceForm["Length[isotopemasslistValues]=", 3298],
  Editable->False]], "Print",
 CellChangeTimes->{3.413567580921967*^9, 3.413567813791959*^9, 
  3.413567891226585*^9, 3.4135679898287487`*^9, 3.413568655073546*^9, 
  3.413568719790161*^9, 3.413570054665371*^9, 3.4135704339829693`*^9, 
  3.413570697996613*^9, 3.4135711526392927`*^9, 3.413571388703267*^9, 
  3.4135714331252813`*^9, 3.413571507066526*^9, 3.4135716879015636`*^9, 
  3.4135718040154753`*^9, 3.4135719755523167`*^9, 3.413572209152917*^9, 
  3.413572495431177*^9, 3.4135754203857107`*^9, 3.4135812365447206`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{751, 706},
WindowMargins->{{141, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 186, 2, 123, "Title"],
Cell[779, 27, 141, 1, 26, "Subsubtitle"],
Cell[923, 30, 1046, 21, 176, "Text"],
Cell[1972, 53, 47279, 1041, 3643, "Input"],
Cell[CellGroupData[{
Cell[49276, 1098, 2015, 29, 27, "Input"],
Cell[CellGroupData[{
Cell[51316, 1131, 693, 12, 20, "Print"],
Cell[52012, 1145, 686, 11, 20, "Print"],
Cell[52701, 1158, 731, 12, 20, "Print"],
Cell[53435, 1172, 5546, 90, 141, "Print"],
Cell[58984, 1264, 8814, 143, 321, "Print"],
Cell[67801, 1409, 729, 12, 20, "Print"],
Cell[68533, 1423, 152014, 2268, 5166, "Print"],
Cell[220550, 3693, 232974, 3603, 8496, "Print"],
Cell[453527, 7298, 528, 7, 20, "Print"],
Cell[454058, 7307, 708, 12, 20, "Print"],
Cell[454769, 7321, 718, 12, 20, "Print"],
Cell[455490, 7335, 717, 12, 20, "Print"],
Cell[456210, 7349, 684, 11, 20, "Print"],
Cell[456897, 7362, 700, 12, 20, "Print"],
Cell[457600, 7376, 702, 12, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
