/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.legacy;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.legacy.LinkedElement;
import net.sourceforge.plantuml.nwdiag.legacy.NetworkLegacy;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class NwGroupLegacy
extends NwGroup {
    private final NetworkLegacy network;

    @Override
    public String toString() {
        return this.getName() + " " + this.network + " " + this.names();
    }

    public NwGroupLegacy(String name, NetworkLegacy network) {
        super(name);
        this.network = network;
    }

    public int size() {
        return this.names().size();
    }

    public boolean matches(LinkedElement tested) {
        if (this.network != null && this.network != tested.getNetwork()) {
            return false;
        }
        return this.names().contains(tested.getElement().getName());
    }

    public void drawGroup(UGraphic ug, MinMax size, ISkinParam skinParam) {
        HColor color;
        TextBlock block = null;
        Dimension2D blockDim = null;
        if (this.getDescription() != null) {
            block = Display.getWithNewlines(this.getDescription()).create(this.getGroupDescriptionFontConfiguration(), HorizontalAlignment.LEFT, skinParam);
            blockDim = block.calculateDimension(ug.getStringBounder());
            double dy = size.getMinY() - blockDim.getHeight();
            size = size.addPoint(size.getMinX(), dy);
        }
        if ((color = this.getColor()) == null) {
            color = colors.getColorOrWhite(skinParam.getThemeStyle(), "#AAA");
        }
        size.draw(ug, color);
        if (block != null) {
            block.drawU(ug.apply(new UTranslate(size.getMinX() + 5.0, size.getMinY())));
        }
    }

    public final NetworkLegacy getNetwork() {
        return this.network;
    }
}

