%define PERSALYS_DesignOfExperiment_doc
"Design of experiments base class.

Available constructors:
    DesignOfExperiment(*name, physicalModel*)

Parameters
----------
name : str
    Name
physicalModel : :class:`~persalys.PhysicalModel`
    Physical model

Notes
-----
DesignOfExperiment is the base class of :class:`~persalys.DataModel`"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation
PERSALYS_DesignOfExperiment_doc


// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getPhysicalModel_doc
"Physical model accessor.

Returns
-------
model : :class:`~persalys.PhysicalModel`
    Physical model"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getPhysicalModel
PERSALYS_DesignOfExperiment_getPhysicalModel_doc

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getPythonScript_doc
"Python script accessor.

Returns
-------
script : str
    Python script to rebuild the design of experiments"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getPythonScript
PERSALYS_DesignOfExperiment_getPythonScript_doc

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_hasPhysicalModel_doc
"Whether it contains a physical model.

Returns
-------
hasPhysicalModel : bool
    Whether it contains a physical model"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::hasPhysicalModel
PERSALYS_DesignOfExperiment_hasPhysicalModel_doc

// ----------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getInputSample_doc
"Input sample accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Input sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getInputSample
PERSALYS_DesignOfExperiment_getInputSample_doc

// ----------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_setInputSample_doc
"Input sample accessor.

Parameters
----------
sample : :py:class:`openturns.Sample`
    Input sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::setInputSample
PERSALYS_DesignOfExperiment_setInputSample_doc

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getOutputSample_doc
"Output sample accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Output sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getOutputSample
PERSALYS_DesignOfExperiment_getOutputSample_doc

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_setOutputSample_doc
"Output sample accessor.

Parameters
----------
sample : :py:class:`openturns.Sample`
    Output sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::setOutputSample
PERSALYS_DesignOfExperiment_setOutputSample_doc

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getSample_doc
"Sample accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Input sample and output sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getSample
PERSALYS_DesignOfExperiment_getSample_doc

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::DesignOfExperimentImplementation::initialize
"Empty the input and output samples."

// ---------------------------------------------------------------------

%define PERSALYS_DesignOfExperiment_getEffectiveInputIndices_doc
"Effective indices accessor.

Indices of non-const variables in the design.

Returns
-------
indices : :py:class:`openturns.Indices`
    Input sample and output sample"
%enddef
%feature("docstring") PERSALYS::DesignOfExperimentImplementation::getEffectiveInputIndices
PERSALYS_DesignOfExperiment_getEffectiveInputIndices_doc
