#pragma once
#include "BaseCommunication.h"

#define IOCTL_CCID_INT        0x80722216L
#define IOCTL_CCID_ABORT      0x80722218L

typedef struct _USB_DEVICE_CE {
   WORD length;
   WORD USBVersion;
   WORD DeviceClass;
   WORD DeviceSubClass;
   WORD DeviceProtocol;
   WORD MaxPacketSize0;
   WORD VendorId;
   WORD ProductId;
   WORD DeviceVersion;
   WORD NumConfigurations;
   WORD ManufacturerLength;
   WORD ManufacturerOffs;
   WORD ProductLength;
   WORD ProductOffs;
   WORD SerialLength;
   WORD SerialOffs;
}USB_DEVICE_CE;


class CUSBCommunicationCe :
	public CBaseCommunication
{
public:
	CUSBCommunicationCe(const char *cDeviceName,CReader *Owner);
	virtual int Write(void *Message,uint32_t len);
	virtual int Read(void *Response,uint32_t *ResponseLen);
	virtual CBaseReader *BuildReaderObject(); 
	virtual void SetCommunicationString(cj_ReaderInfo *ReaderInfo);
	virtual bool IsConnected();

	virtual int Open();
	virtual void Close();


public:
	virtual ~CUSBCommunicationCe(void);
	DWORD IntPipeThreadRoutine();
private:
	virtual int StartInterruptPipe();
	virtual int HaltInterruptPipe();
	static DWORD __stdcall _IntPipeThreadRoutine(LPVOID ptr);
	void _Close();
private:
	HANDLE			m_hDevice;
	uint8_t*		m_pSBuffer;
	uint32_t		m_nSBufferLen;
	HANDLE			m_IntPipeThread;
	USB_DEVICE_CE*	m_pDriverInfo;


};
