// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <DBPluginInfoAttributes.h>
#include <DataNode.h>
#include <DBOptionsAttributes.h>
#include <DBOptionsAttributes.h>

// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Init utility for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DBPluginInfoAttributes::Init()
{
    host = "";

    DBPluginInfoAttributes::SelectAll();
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Copy utility for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void DBPluginInfoAttributes::Copy(const DBPluginInfoAttributes &obj)
{
    AttributeGroupVector::const_iterator pos;

    types = obj.types;
    hasWriter = obj.hasWriter;
    // *** Copy the dbReadOptions field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = dbReadOptions.begin(); pos != dbReadOptions.end(); ++pos)
        delete *pos;
    dbReadOptions.clear();
    if(obj.dbReadOptions.size() > 0)
        dbReadOptions.reserve(obj.dbReadOptions.size());
    // Duplicate the dbReadOptions from obj.
    for(pos = obj.dbReadOptions.begin(); pos != obj.dbReadOptions.end(); ++pos)
    {
        DBOptionsAttributes *oldDBOptionsAttributes = (DBOptionsAttributes *)(*pos);
        DBOptionsAttributes *newDBOptionsAttributes = new DBOptionsAttributes(*oldDBOptionsAttributes);
        dbReadOptions.push_back(newDBOptionsAttributes);
    }

    // *** Copy the dbWriteOptions field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = dbWriteOptions.begin(); pos != dbWriteOptions.end(); ++pos)
        delete *pos;
    dbWriteOptions.clear();
    if(obj.dbWriteOptions.size() > 0)
        dbWriteOptions.reserve(obj.dbWriteOptions.size());
    // Duplicate the dbWriteOptions from obj.
    for(pos = obj.dbWriteOptions.begin(); pos != obj.dbWriteOptions.end(); ++pos)
    {
        DBOptionsAttributes *oldDBOptionsAttributes = (DBOptionsAttributes *)(*pos);
        DBOptionsAttributes *newDBOptionsAttributes = new DBOptionsAttributes(*oldDBOptionsAttributes);
        dbWriteOptions.push_back(newDBOptionsAttributes);
    }

    typesFullNames = obj.typesFullNames;
    license = obj.license;
    host = obj.host;

    DBPluginInfoAttributes::SelectAll();
}

// Type map format string
const char *DBPluginInfoAttributes::TypeMapFormatString = DBPLUGININFOATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t DBPluginInfoAttributes::TmfsStruct = {DBPLUGININFOATTRIBUTES_TMFS};


// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Default constructor for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes::DBPluginInfoAttributes() :
    AttributeSubject(DBPluginInfoAttributes::TypeMapFormatString)
{
    DBPluginInfoAttributes::Init();
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Constructor for the derived classes of DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes::DBPluginInfoAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    DBPluginInfoAttributes::Init();
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Copy constructor for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes::DBPluginInfoAttributes(const DBPluginInfoAttributes &obj) :
    AttributeSubject(DBPluginInfoAttributes::TypeMapFormatString)
{
    DBPluginInfoAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::DBPluginInfoAttributes
//
// Purpose:
//   Copy constructor for derived classes of the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes::DBPluginInfoAttributes(const DBPluginInfoAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    DBPluginInfoAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::~DBPluginInfoAttributes
//
// Purpose:
//   Destructor for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes::~DBPluginInfoAttributes()
{
    AttributeGroupVector::iterator pos;

    // Destroy the dbReadOptions field.
    for(pos = dbReadOptions.begin(); pos != dbReadOptions.end(); ++pos)
        delete *pos;
    // Destroy the dbWriteOptions field.
    for(pos = dbWriteOptions.begin(); pos != dbWriteOptions.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::operator =
//
// Purpose:
//   Assignment operator for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBPluginInfoAttributes&
DBPluginInfoAttributes::operator = (const DBPluginInfoAttributes &obj)
{
    if (this == &obj) return *this;

    DBPluginInfoAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DBPluginInfoAttributes::operator == (const DBPluginInfoAttributes &obj) const
{
    bool dbReadOptions_equal = (obj.dbReadOptions.size() == dbReadOptions.size());
    for(size_t i = 0; (i < dbReadOptions.size()) && dbReadOptions_equal; ++i)
    {
        // Make references to DBOptionsAttributes from AttributeGroup *.
        const DBOptionsAttributes &dbReadOptions1 = *((const DBOptionsAttributes *)(dbReadOptions[i]));
        const DBOptionsAttributes &dbReadOptions2 = *((const DBOptionsAttributes *)(obj.dbReadOptions[i]));
        dbReadOptions_equal = (dbReadOptions1 == dbReadOptions2);
    }

    bool dbWriteOptions_equal = (obj.dbWriteOptions.size() == dbWriteOptions.size());
    for(size_t i = 0; (i < dbWriteOptions.size()) && dbWriteOptions_equal; ++i)
    {
        // Make references to DBOptionsAttributes from AttributeGroup *.
        const DBOptionsAttributes &dbWriteOptions1 = *((const DBOptionsAttributes *)(dbWriteOptions[i]));
        const DBOptionsAttributes &dbWriteOptions2 = *((const DBOptionsAttributes *)(obj.dbWriteOptions[i]));
        dbWriteOptions_equal = (dbWriteOptions1 == dbWriteOptions2);
    }

    // Create the return value
    return ((types == obj.types) &&
            (hasWriter == obj.hasWriter) &&
            dbReadOptions_equal &&
            dbWriteOptions_equal &&
            (typesFullNames == obj.typesFullNames) &&
            (license == obj.license) &&
            (host == obj.host));
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DBPluginInfoAttributes::operator != (const DBPluginInfoAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::TypeName
//
// Purpose:
//   Type name method for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
DBPluginInfoAttributes::TypeName() const
{
    return "DBPluginInfoAttributes";
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DBPluginInfoAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DBPluginInfoAttributes *tmp = (const DBPluginInfoAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DBPluginInfoAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DBPluginInfoAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the DBPluginInfoAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
DBPluginInfoAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DBPluginInfoAttributes(*this);
    else
        retval = new DBPluginInfoAttributes;

    return retval;
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::SelectAll()
{
    Select(ID_types,          (void *)&types);
    Select(ID_hasWriter,      (void *)&hasWriter);
    Select(ID_dbReadOptions,  (void *)&dbReadOptions);
    Select(ID_dbWriteOptions, (void *)&dbWriteOptions);
    Select(ID_typesFullNames, (void *)&typesFullNames);
    Select(ID_license,        (void *)&license);
    Select(ID_host,           (void *)&host);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::CreateSubAttributeGroup
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup *
DBPluginInfoAttributes::CreateSubAttributeGroup(int attr_id)
{
    AttributeGroup *retval = 0;
    switch(attr_id)
    {
    case ID_dbReadOptions:
        retval = new DBOptionsAttributes;
        break;
    case ID_dbWriteOptions:
        retval = new DBOptionsAttributes;
        break;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DBPluginInfoAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DBPluginInfoAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DBPluginInfoAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DBPluginInfoAttributes.
    DataNode *node = new DataNode("DBPluginInfoAttributes");

    if(completeSave || !FieldsEqual(ID_types, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("types", types));
    }

    if(completeSave || !FieldsEqual(ID_hasWriter, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hasWriter", hasWriter));
    }

    if(completeSave || !FieldsEqual(ID_dbReadOptions, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < dbReadOptions.size(); ++i)
            dbReadOptions[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_dbWriteOptions, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < dbWriteOptions.size(); ++i)
            dbWriteOptions[i]->CreateNode(node, completeSave, true);
    }

    if(completeSave || !FieldsEqual(ID_typesFullNames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("typesFullNames", typesFullNames));
    }

    if(completeSave || !FieldsEqual(ID_license, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("license", license));
    }

    if(completeSave || !FieldsEqual(ID_host, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("host", host));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DBPluginInfoAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    DataNode **children;
    if((node = searchNode->GetNode("types")) != 0)
        SetTypes(node->AsStringVector());
    if((node = searchNode->GetNode("hasWriter")) != 0)
        SetHasWriter(node->AsIntVector());

    // Clear all the DBOptionsAttributess if we got any.
    bool clearedDbReadOptions = false;
    // Go through all of the children and construct a new
    // DBOptionsAttributes for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("DBOptionsAttributes"))
            {
                if (!clearedDbReadOptions)
                {
                    ClearDbReadOptions();
                    clearedDbReadOptions = true;
                }
                DBOptionsAttributes temp;
                temp.SetFromNode(children[i]);
                AddDbReadOptions(temp);
            }
        }
    }


    // Clear all the DBOptionsAttributess if we got any.
    bool clearedDbWriteOptions = false;
    // Go through all of the children and construct a new
    // DBOptionsAttributes for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("DBOptionsAttributes"))
            {
                if (!clearedDbWriteOptions)
                {
                    ClearDbWriteOptions();
                    clearedDbWriteOptions = true;
                }
                DBOptionsAttributes temp;
                temp.SetFromNode(children[i]);
                AddDbWriteOptions(temp);
            }
        }
    }

    if((node = searchNode->GetNode("typesFullNames")) != 0)
        SetTypesFullNames(node->AsStringVector());
    if((node = searchNode->GetNode("license")) != 0)
        SetLicense(node->AsStringVector());
    if((node = searchNode->GetNode("host")) != 0)
        SetHost(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DBPluginInfoAttributes::SetTypes(const stringVector &types_)
{
    types = types_;
    Select(ID_types, (void *)&types);
}

void
DBPluginInfoAttributes::SetHasWriter(const intVector &hasWriter_)
{
    hasWriter = hasWriter_;
    Select(ID_hasWriter, (void *)&hasWriter);
}

void
DBPluginInfoAttributes::SetTypesFullNames(const stringVector &typesFullNames_)
{
    typesFullNames = typesFullNames_;
    Select(ID_typesFullNames, (void *)&typesFullNames);
}

void
DBPluginInfoAttributes::SetLicense(const stringVector &license_)
{
    license = license_;
    Select(ID_license, (void *)&license);
}

void
DBPluginInfoAttributes::SetHost(const std::string &host_)
{
    host = host_;
    Select(ID_host, (void *)&host);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
DBPluginInfoAttributes::GetTypes() const
{
    return types;
}

stringVector &
DBPluginInfoAttributes::GetTypes()
{
    return types;
}

const intVector &
DBPluginInfoAttributes::GetHasWriter() const
{
    return hasWriter;
}

intVector &
DBPluginInfoAttributes::GetHasWriter()
{
    return hasWriter;
}

const AttributeGroupVector &
DBPluginInfoAttributes::GetDbReadOptions() const
{
    return dbReadOptions;
}

AttributeGroupVector &
DBPluginInfoAttributes::GetDbReadOptions()
{
    return dbReadOptions;
}

const AttributeGroupVector &
DBPluginInfoAttributes::GetDbWriteOptions() const
{
    return dbWriteOptions;
}

AttributeGroupVector &
DBPluginInfoAttributes::GetDbWriteOptions()
{
    return dbWriteOptions;
}

const stringVector &
DBPluginInfoAttributes::GetTypesFullNames() const
{
    return typesFullNames;
}

stringVector &
DBPluginInfoAttributes::GetTypesFullNames()
{
    return typesFullNames;
}

const stringVector &
DBPluginInfoAttributes::GetLicense() const
{
    return license;
}

stringVector &
DBPluginInfoAttributes::GetLicense()
{
    return license;
}

const std::string &
DBPluginInfoAttributes::GetHost() const
{
    return host;
}

std::string &
DBPluginInfoAttributes::GetHost()
{
    return host;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DBPluginInfoAttributes::SelectTypes()
{
    Select(ID_types, (void *)&types);
}

void
DBPluginInfoAttributes::SelectHasWriter()
{
    Select(ID_hasWriter, (void *)&hasWriter);
}

void
DBPluginInfoAttributes::SelectDbReadOptions()
{
    Select(ID_dbReadOptions, (void *)&dbReadOptions);
}

void
DBPluginInfoAttributes::SelectDbWriteOptions()
{
    Select(ID_dbWriteOptions, (void *)&dbWriteOptions);
}

void
DBPluginInfoAttributes::SelectTypesFullNames()
{
    Select(ID_typesFullNames, (void *)&typesFullNames);
}

void
DBPluginInfoAttributes::SelectLicense()
{
    Select(ID_license, (void *)&license);
}

void
DBPluginInfoAttributes::SelectHost()
{
    Select(ID_host, (void *)&host);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DBPluginInfoAttributes::AddDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::AddDbReadOptions(const DBOptionsAttributes &obj)
{
    DBOptionsAttributes *newDBOptionsAttributes = new DBOptionsAttributes(obj);
    dbReadOptions.push_back(newDBOptionsAttributes);

    // Indicate that things have changed by selecting it.
    Select(ID_dbReadOptions, (void *)&dbReadOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::ClearDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::ClearDbReadOptions()
{
    AttributeGroupVector::iterator pos;

    for(pos = dbReadOptions.begin(); pos != dbReadOptions.end(); ++pos)
        delete *pos;
    dbReadOptions.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_dbReadOptions, (void *)&dbReadOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::RemoveDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::RemoveDbReadOptions(int index)
{
    AttributeGroupVector::iterator pos = dbReadOptions.begin();

    // Iterate through the vector "index" times.
    for(int i = 0; i < index; ++i)
        if(pos != dbReadOptions.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != dbReadOptions.end())
    {
        delete *pos;
        dbReadOptions.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_dbReadOptions, (void *)&dbReadOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetNumDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
DBPluginInfoAttributes::GetNumDbReadOptions() const
{
    return (int)dbReadOptions.size();
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBOptionsAttributes &
DBPluginInfoAttributes::GetDbReadOptions(int i)
{
    return *((DBOptionsAttributes *)dbReadOptions[i]);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetDbReadOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const DBOptionsAttributes &
DBPluginInfoAttributes::GetDbReadOptions(int i) const
{
    return *((DBOptionsAttributes *)dbReadOptions[i]);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::AddDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::AddDbWriteOptions(const DBOptionsAttributes &obj)
{
    DBOptionsAttributes *newDBOptionsAttributes = new DBOptionsAttributes(obj);
    dbWriteOptions.push_back(newDBOptionsAttributes);

    // Indicate that things have changed by selecting it.
    Select(ID_dbWriteOptions, (void *)&dbWriteOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::ClearDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::ClearDbWriteOptions()
{
    AttributeGroupVector::iterator pos;

    for(pos = dbWriteOptions.begin(); pos != dbWriteOptions.end(); ++pos)
        delete *pos;
    dbWriteOptions.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_dbWriteOptions, (void *)&dbWriteOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::RemoveDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
DBPluginInfoAttributes::RemoveDbWriteOptions(int index)
{
    AttributeGroupVector::iterator pos = dbWriteOptions.begin();

    // Iterate through the vector "index" times.
    for(int i = 0; i < index; ++i)
        if(pos != dbWriteOptions.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != dbWriteOptions.end())
    {
        delete *pos;
        dbWriteOptions.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_dbWriteOptions, (void *)&dbWriteOptions);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetNumDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
DBPluginInfoAttributes::GetNumDbWriteOptions() const
{
    return (int)dbWriteOptions.size();
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

DBOptionsAttributes &
DBPluginInfoAttributes::GetDbWriteOptions(int i)
{
    return *((DBOptionsAttributes *)dbWriteOptions[i]);
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetDbWriteOptions
//
// Purpose:
//   This class contains the attributes for all the database plugins.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const DBOptionsAttributes &
DBPluginInfoAttributes::GetDbWriteOptions(int i) const
{
    return *((DBOptionsAttributes *)dbWriteOptions[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DBPluginInfoAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_types:          return "types";
    case ID_hasWriter:      return "hasWriter";
    case ID_dbReadOptions:  return "dbReadOptions";
    case ID_dbWriteOptions: return "dbWriteOptions";
    case ID_typesFullNames: return "typesFullNames";
    case ID_license:        return "license";
    case ID_host:           return "host";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
DBPluginInfoAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_types:          return FieldType_stringVector;
    case ID_hasWriter:      return FieldType_intVector;
    case ID_dbReadOptions:  return FieldType_attVector;
    case ID_dbWriteOptions: return FieldType_attVector;
    case ID_typesFullNames: return FieldType_stringVector;
    case ID_license:        return FieldType_stringVector;
    case ID_host:           return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
DBPluginInfoAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_types:          return "stringVector";
    case ID_hasWriter:      return "intVector";
    case ID_dbReadOptions:  return "attVector";
    case ID_dbWriteOptions: return "attVector";
    case ID_typesFullNames: return "stringVector";
    case ID_license:        return "stringVector";
    case ID_host:           return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DBPluginInfoAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
DBPluginInfoAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DBPluginInfoAttributes &obj = *((const DBPluginInfoAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_types:
        {  // new scope
        retval = (types == obj.types);
        }
        break;
    case ID_hasWriter:
        {  // new scope
        retval = (hasWriter == obj.hasWriter);
        }
        break;
    case ID_dbReadOptions:
        {  // new scope
        bool dbReadOptions_equal = (obj.dbReadOptions.size() == dbReadOptions.size());
        for(size_t i = 0; (i < dbReadOptions.size()) && dbReadOptions_equal; ++i)
        {
            // Make references to DBOptionsAttributes from AttributeGroup *.
            const DBOptionsAttributes &dbReadOptions1 = *((const DBOptionsAttributes *)(dbReadOptions[i]));
            const DBOptionsAttributes &dbReadOptions2 = *((const DBOptionsAttributes *)(obj.dbReadOptions[i]));
            dbReadOptions_equal = (dbReadOptions1 == dbReadOptions2);
        }

        retval = dbReadOptions_equal;
        }
        break;
    case ID_dbWriteOptions:
        {  // new scope
        bool dbWriteOptions_equal = (obj.dbWriteOptions.size() == dbWriteOptions.size());
        for(size_t i = 0; (i < dbWriteOptions.size()) && dbWriteOptions_equal; ++i)
        {
            // Make references to DBOptionsAttributes from AttributeGroup *.
            const DBOptionsAttributes &dbWriteOptions1 = *((const DBOptionsAttributes *)(dbWriteOptions[i]));
            const DBOptionsAttributes &dbWriteOptions2 = *((const DBOptionsAttributes *)(obj.dbWriteOptions[i]));
            dbWriteOptions_equal = (dbWriteOptions1 == dbWriteOptions2);
        }

        retval = dbWriteOptions_equal;
        }
        break;
    case ID_typesFullNames:
        {  // new scope
        retval = (typesFullNames == obj.typesFullNames);
        }
        break;
    case ID_license:
        {  // new scope
        retval = (license == obj.license);
        }
        break;
    case ID_host:
        {  // new scope
        retval = (host == obj.host);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

