/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// VmResizeZone struct for VmResizeZone
type VmResizeZone struct {
	Id *string `json:"id,omitempty"`
	// desired memory zone size in bytes
	DesiredRam *int64 `json:"desired_ram,omitempty"`
}

// NewVmResizeZone instantiates a new VmResizeZone object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewVmResizeZone() *VmResizeZone {
	this := VmResizeZone{}
	return &this
}

// NewVmResizeZoneWithDefaults instantiates a new VmResizeZone object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewVmResizeZoneWithDefaults() *VmResizeZone {
	this := VmResizeZone{}
	return &this
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *VmResizeZone) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmResizeZone) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *VmResizeZone) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *VmResizeZone) SetId(v string) {
	o.Id = &v
}

// GetDesiredRam returns the DesiredRam field value if set, zero value otherwise.
func (o *VmResizeZone) GetDesiredRam() int64 {
	if o == nil || o.DesiredRam == nil {
		var ret int64
		return ret
	}
	return *o.DesiredRam
}

// GetDesiredRamOk returns a tuple with the DesiredRam field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmResizeZone) GetDesiredRamOk() (*int64, bool) {
	if o == nil || o.DesiredRam == nil {
		return nil, false
	}
	return o.DesiredRam, true
}

// HasDesiredRam returns a boolean if a field has been set.
func (o *VmResizeZone) HasDesiredRam() bool {
	if o != nil && o.DesiredRam != nil {
		return true
	}

	return false
}

// SetDesiredRam gets a reference to the given int64 and assigns it to the DesiredRam field.
func (o *VmResizeZone) SetDesiredRam(v int64) {
	o.DesiredRam = &v
}

func (o VmResizeZone) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.DesiredRam != nil {
		toSerialize["desired_ram"] = o.DesiredRam
	}
	return json.Marshal(toSerialize)
}

type NullableVmResizeZone struct {
	value *VmResizeZone
	isSet bool
}

func (v NullableVmResizeZone) Get() *VmResizeZone {
	return v.value
}

func (v *NullableVmResizeZone) Set(val *VmResizeZone) {
	v.value = val
	v.isSet = true
}

func (v NullableVmResizeZone) IsSet() bool {
	return v.isSet
}

func (v *NullableVmResizeZone) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableVmResizeZone(val *VmResizeZone) *NullableVmResizeZone {
	return &NullableVmResizeZone{value: val, isSet: true}
}

func (v NullableVmResizeZone) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableVmResizeZone) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
