# ITK 5.4 Release Candidate 4: ALL THE DICOMs

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.4 Release Candidate 4 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

🔦 Highlights
-------------------------

The Insight Toolkit (ITK) has further enhanced its DICOM capabilities in the latest release, building on over 25 years of extensive clinical usage and application. DICOM (Digital Imaging and Communications in Medicine) is a valuable standard handling, storing, printing, and transmitting information in medical imaging. It includes a wide range of medical data types and allows for various imaging modalities and workflow information, posing significant challenges due to its extensive support for diverse medical content and variations in vendor implementations and adherence to the standard.

This release introduces expanded support for additional modality features and crucial spatial metadata for Secondary Capture images. ITK significantly improves the way medical imaging data is processed and interpreted and ensures robust support for diverse DICOM applications.

![VisibleFemaleSpatialMetadata](https://github.com/InsightSoftwareConsortium/ITK/assets/25432/bf98c2b2-ae53-4c06-b247-0743b155ffc6)

*The impact of spatial metadata handling on the NLM Visible Human cryomacrotome anatomic secondary capture images, [available in the NIH Imaging Data Commons](https://portal.imaging.datacommons.cancer.gov/explore/filters/?collection_id=nlm_visible_human_project), when visualized in [3D Slicer](https://slicer.org). Left: before ITK v5.4rc04, Right: after. Screenshots courtesy Steve Pieper.*


The development of ITK’s DICOM support is a testament to a robust community-driven effort involving ITK developers, maintainers from DICOM library projects such as GDCM and DCMTK, and curators of the DICOM standard. This release includes collaborative contributions from notable community members including Mikhail Isakov, Jon Haitz Legarreta Gorroño, Sean McBride, Martin Hoßbach, Mathieu Malaterre, Michael Onken, Steve Pieper, Andras Lasso, David Clunie, and Andrey Fedorov.


This release candidate also expands on our support for elegant, performant, modern C++. For example, specializations of `std::tuple_size ` and `std::tuple_element` for `itk::ImageRegion` in order to support C++17 structured bindings enable compile-time optimized statements to provide a multidimenional region's index and size:

```cxx
auto [index, size] = image.GetRequestedRegion();
```

For more information on ITK 5.4's modern C++ support, see [the Release Candidate 1 release notes](https://docs.itk.org/en/latest/releases/5.4rc01.html).

Moreover, this release candidate extends the toolkit's sustainability and Python support through Stable ABI Python wheels. This is made possible by upgrades to SWIG and [scikit-build-core](https://scikit-build-core.readthedocs.io/en/latest/), the modern Python packaging standard evolution of scikit-build classic. Python 3.11 wheels will be recognized by `pip` and work with Python 3.11, 3.12, 3.13, 3.14, etc. While we also provide cross-platform wheels for Python 3.8-3.10, we can only use the Stable ABI with Python 3.11 because it is required for [`itk`'s NumPy support](https://docs.itk.org/en/latest/learn/python_quick_start.html#itk-and-numpy).

ITK Remote Modules now also have GitHub Action-driven mac ARM / Apple Silicon Python wheel generation support. While a Remote Module *setup.py* file is still supported in ITK 5.4, migration to a scikit-build-core *pyproject.toml* file is encouraged. One important advantage is the generation of Stable ABI wheels for Python 3.11+. To migrate to scikit-build-core, use [this pyproject.toml template](https://github.com/InsightSoftwareConsortium/ITKModuleTemplate/blob/main/%7B%7Bcookiecutter.project_name%7D%7D/pyproject.toml) and remove the *setup.py* file.

ITK 5.4 contains many additional improvements; highlights can be found below along with a more detailed changelog. For a summary of changes that continue our sustainability evolution with Web3 testing data, see the [5.4 Release Candidate 2 release notes](https://docs.itk.org/en/latest/releases/5.4rc02.html).

💾 Download
-------------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```bash
pip install --upgrade --pre itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4rc04.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightSoftwareGuide-Book1-5.4rc04.pdf)
- [InsightSoftwareGuide-Book2-5.4rc04.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightSoftwareGuide-Book2-5.4rc04.pdf)

**Library Sources**

- [InsightToolkit-5.4rc04.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightToolkit-5.4rc04.tar.gz)
- [InsightToolkit-5.4rc04.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightToolkit-5.4rc04.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4rc04.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightData-5.4rc04.tar.gz)
- [InsightData-5.4rc04.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/InsightData-5.4rc04.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc04/SHA512SUMS)

✨ Features
------------

### Python

- Wrapping for `itk.PhasedArray3DSpecialCoordinatesImage`
- Better support for multi-component images in `image_from_vtk_image`
- `itk.imread` supports a `series_uid` kwarg for DICOM series selection
- TBB version updated to latest stable version, disabled on Intel macOS
- Python binaries for 3.8-3.11 across platforms
- Python 3.11 uses the Stable ABI -- works with Python 3.11+
- Python 3.7 is no longer supported
- Apple Silicon Remote Module GitHub Action wheels
- Updated to the latest version of scikit-build-core
- Import time improvements with `torch`

### C++

- C++17 is now required
- Many style improvements for modern C++ and consistency
- GCC 13 support
- Name mangling prefix for third party libraries is configurable
- Update mangled 3rd-parties to use `MANGLE_PREFIX` CMake variable
- Many improvements to code coverage
- Enhanced NRRD and Nifti metadata support
- CMake `OPTIONAL_COMPONENTS` support
- Apply cmake-format for a consistent CMake style
- `get()` member function to `itk::SmartPointer`
- `itk::Size::CalculateProductOfElements()`, to compute number of pixels
- `Deref(T *)`, to ease dereferencing a pointer safely
- `itk::ShapedImageNeighborhoodRange` support C-array of offsets (by C++17)
- Add `itk::Copy(const T & original)`, which simply returns a copy
- Make `itk::ImageRegion` trivially copyable, remove inheritance (FUTURE)

### Performance

- Use index/point transforms without bounds checking
- Improved SSE2 detection
- Many improvements to how locks are handled
- Major `itk::SpatialObject` performance improvements

### Documentation

- New GitHub Action to check spelling
- Doxygen formatting cleanup
- Doxygen spelling fixes
- Doxygen Insight Journal links are consistent
- Many Doxygen improvements to the content
- Software Guide updated for style modernization
- Change the Insight Journal handle links to insight-journal links
- Replace `itkTypeMacro` with `itkOverrideGetNameOfClassMacro`

### Remote module updates

New modules:

- [FastBilateral](https://hackmd.io/I4AtOFiKSI6rvHKm1fYmeA) - A Fast Approximation to the Bilateral Filter for ITK. [Insight Journal article](https://insight-journal.org/browse/publication/692).

Updated modules:
- [BSplineGradient](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient.git)
- [BoneMorphometry](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry.git)
- [Cleaver](https://github.com/SCIInstitute/ITKCleaver.git)
- [Cuberille](https://github.com/InsightSoftwareConsortium/ITKCuberille.git),
- [CudaCommon](https://github.com/RTKConsortium/ITKCudaCommon.git)
- [FPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH.git)
- [GenericLabelInterpolator](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator.git)
- [HASI](https://github.com/KitwareMedical/HASI.git)
- [HigherOrderAccurateGradient](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient.git)
- [IOMeshSTL](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL.git)
- [IOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC.git)
- [IOScanco](https://github.com/KitwareMedical/ITKIOScanco.git)
- [LabelErodeDilate](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate.git)
- [MeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData.git)
- [MinimalPathExtraction](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction.git)
- [Montage](https://github.com/InsightSoftwareConsortium/ITKMontage.git)
- [MorphologicalContourInterpolation](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation.git)
- [ParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology.git)
- [RANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC.git)
- [RLEImage](https://github.com/KitwareMedical/ITKRLEImage.git)
- [RTK](https://github.com/RTKConsortium/RTK.git)
- [Shape](https://github.com/SlicerSALT/ITKShape.git)
- [SimpleITKFilters](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters.git)
- [SplitComponents](https://github.com/InsightSoftwareConsortium/ITKSplitComponents.git)
- [Strain](https://github.com/KitwareMedical/ITKStrain.git)
- [TextureFeatures](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures.git)
- [Thickness3D](https://github.com/InsightSoftwareConsortium/ITKThickness3D.git)
- [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK.git)
- [Ultrasound](https://github.com/KitwareMedical/ITKUltrasound.git)
- [VkFFTBackend](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend.git)
- [WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm.git)


### Third party library updates

- dcmtk
- eigen
- gdcm
- googletest
- kwsys
- minc
- meta-io
- nifti
- pygccxml
- vxl
- zlib-ng


🙏 Congratulations
------------------------

Congratulations and **thank you** to everyone who contributed to this release.

Of the *59 authors* who contributed since v5.3.0, we would like to specially recognize the new contributors:

*Nicklas Larsson, huangjxbq, Sankhesh Jhaveri, adrinkwater, FabioLolix, Vaibhaw, Ningfei Li, Max Aehle, Noah Egnatis, Federico Zivolo, Patrick Linnane, LAURENDEAU Matthieu, Shreeraj Jadhav, Shengpeng YU, Fernando Bordignon, Andras Lasso, Bernhard Froehler, Thomas BAUDIER, Matthieu LAURENDEAU, Fabian Wenzel, Mikhail Polkovnikov, Pritam Rungta, Florian de Gaulejac, Ramon Emiliani, Martin Hoßbach, Sadhana Ravikumar, and Gabriel Chartrand.*

🗣️ What's Next
---------------

This is the final release candidate before v5.4.0. An issue following the tagging of v5.4rc03 predicated the publication of this release. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**


ITK Changes Since v5.4rc02
---------------------------------------------

### Andras Lasso (2):

#### Enhancements

- Add GDCM test for 32 bits stored DICOM image ([7e350ef7cd](https://github.com/InsightSoftwareConsortium/ITK/commit/7e350ef7cd))

#### Style Changes

- Simplify itkDCMTKImageIO ([decc3e5977](https://github.com/InsightSoftwareConsortium/ITK/commit/decc3e5977))


### Bernhard Froehler (1):

#### Platform Fixes

- Add missing include (gcc13.2/clang17 build) ([f871250c8d](https://github.com/InsightSoftwareConsortium/ITK/commit/f871250c8d))


### Brad King (2):

#### Enhancements

- Improve messages when ITKInternalEigen3 fails to configure ([fd97c1034d](https://github.com/InsightSoftwareConsortium/ITK/commit/fd97c1034d))

#### Platform Fixes

- Fix installation of ITKInternalEigen3 with space in path ([278c398614](https://github.com/InsightSoftwareConsortium/ITK/commit/278c398614))


### Bradley Lowekamp (4):

#### Enhancements

- Add support for OPTIONAL_COMPONENTS ([ee84d1eb91](https://github.com/InsightSoftwareConsortium/ITK/commit/ee84d1eb91))
- Introduce constants for the default tolerances ([4881cee2e1](https://github.com/InsightSoftwareConsortium/ITK/commit/4881cee2e1))

#### Documentation Updates

- Clarify ThresholdImageFilter behavior ([e67365a805](https://github.com/InsightSoftwareConsortium/ITK/commit/e67365a805))

#### Bug Fixes

- Make JPEGImageIO const correct with m_FileName ([dba496d0c3](https://github.com/InsightSoftwareConsortium/ITK/commit/dba496d0c3))


### Dave Chen (1):

#### Enhancements

- Github Action to Spell Check Comments ([4a04d8f308](https://github.com/InsightSoftwareConsortium/ITK/commit/4a04d8f308))


### Dženan Zukić (25):

#### Enhancements

- Add ULL type to ConnectedComponentImageFilter wrapping ([3b5f76486d](https://github.com/InsightSoftwareConsortium/ITK/commit/3b5f76486d))
- Add a 3D regression test for FillholeImageFilter ([3d54107d0d](https://github.com/InsightSoftwareConsortium/ITK/commit/3d54107d0d))
- Update Montage remote module ([46454a1b48](https://github.com/InsightSoftwareConsortium/ITK/commit/46454a1b48))
- Fix problems introduced by the latest zlib-ng update ([b760b020cf](https://github.com/InsightSoftwareConsortium/ITK/commit/b760b020cf))
- Add CompositeTransform to DataObjectDecorator wrapping ([5d1455035a](https://github.com/InsightSoftwareConsortium/ITK/commit/5d1455035a))
- Update KWStyle to avoid a CMake warning during its configure step ([f58ccd1565](https://github.com/InsightSoftwareConsortium/ITK/commit/f58ccd1565))
- Wrap DataObjectDecorator<CompositeTransform<float>> ([b6a6b6b524](https://github.com/InsightSoftwareConsortium/ITK/commit/b6a6b6b524))
- Allow using std::vector<T> in itkSetMacro and friends ([71c5c83e10](https://github.com/InsightSoftwareConsortium/ITK/commit/71c5c83e10))
- Add IsSameImageGeometryAs convenience method to ImageBase ([92f6d10219](https://github.com/InsightSoftwareConsortium/ITK/commit/92f6d10219))
- Wrap AffineTransform for float parameters ([02c0181098](https://github.com/InsightSoftwareConsortium/ITK/commit/02c0181098))
- FlatStructuringElement and ShapedNeighborhoodIterator Interop ([bac09b0834](https://github.com/InsightSoftwareConsortium/ITK/commit/bac09b0834))
- Add FastBilateral remote module ([c9b15e5eec](https://github.com/InsightSoftwareConsortium/ITK/commit/c9b15e5eec))
- Improve numerical precision of weighted centroid computation ([db6114d322](https://github.com/InsightSoftwareConsortium/ITK/commit/db6114d322))
- Update remote modules using the script ([858329745b](https://github.com/InsightSoftwareConsortium/ITK/commit/858329745b))
- Switch MINC upstream branch from `develop` to `master` ([4b0874b9d1](https://github.com/InsightSoftwareConsortium/ITK/commit/4b0874b9d1))

#### Documentation Updates

- Show that we can pass a list of images via Python wrapping ([03f250ddd8](https://github.com/InsightSoftwareConsortium/ITK/commit/03f250ddd8))
- Remove commented-out `GetAllCounts` method declaration ([959ad044e0](https://github.com/InsightSoftwareConsortium/ITK/commit/959ad044e0))

#### Platform Fixes

- Add ULL wrapping for ScanlineFilterCommon ([9f54bb8bf2](https://github.com/InsightSoftwareConsortium/ITK/commit/9f54bb8bf2))
- Fix Warning for CMP0135 in remote modules (DownloadClangFormat) ([7972041148](https://github.com/InsightSoftwareConsortium/ITK/commit/7972041148))
- Address clang warnings in a remote module ([9e8f6a473d](https://github.com/InsightSoftwareConsortium/ITK/commit/9e8f6a473d))
- Update KWStyle to fix build warnings with MacOSX13.1.sdk ([ef6faa3ccc](https://github.com/InsightSoftwareConsortium/ITK/commit/ef6faa3ccc))
- Fix compile error in MSVC permissive mode ([634cbdc20e](https://github.com/InsightSoftwareConsortium/ITK/commit/634cbdc20e))
- Wrap IdentityTransform for float ([dd11c3a595](https://github.com/InsightSoftwareConsortium/ITK/commit/dd11c3a595))

#### Bug Fixes

- Fix computation of weighted centroid in LabelGeometryImageFilter ([daec066b7a](https://github.com/InsightSoftwareConsortium/ITK/commit/daec066b7a))

#### Style Changes

- Fix code indentation in pyBase.i to aid understanding ([1273d52141](https://github.com/InsightSoftwareConsortium/ITK/commit/1273d52141))


### Eigen Upstream (1):

#### Miscellaneous Changes

- Eigen3 2023-11-08 (2a86e97c) ([90301ece63](https://github.com/InsightSoftwareConsortium/ITK/commit/90301ece63))


### Fabian Wenzel (4):

#### Documentation Updates

- Fixed git hook commit error message if clang-format is not found ([9076f05bda](https://github.com/InsightSoftwareConsortium/ITK/commit/9076f05bda))

#### Platform Fixes

- Skip Python-Wrapping of ITKVtkGlue ([0b1fafe35f](https://github.com/InsightSoftwareConsortium/ITK/commit/0b1fafe35f))
- LBFGSOptimizerBasev4 explicit instantiation for wrapping shared libs ([607493ec1a](https://github.com/InsightSoftwareConsortium/ITK/commit/607493ec1a))
- Fix MultiThreaderSingle typos ([a5d9526829](https://github.com/InsightSoftwareConsortium/ITK/commit/a5d9526829))


### Florian de Gaulejac (2):

#### Platform Fixes

- Fix compilation of FEM module with VS2019 ([95a0d0e289](https://github.com/InsightSoftwareConsortium/ITK/commit/95a0d0e289))
- Fix compilation with VS2019 -std:c++20 (without BUILD_TESTING) ([1deea1ef93](https://github.com/InsightSoftwareConsortium/ITK/commit/1deea1ef93))


### GDCM Upstream (4):

#### Miscellaneous Changes

- GDCM 2023-10-30 (b578ec5d) ([577e3c3d13](https://github.com/InsightSoftwareConsortium/ITK/commit/577e3c3d13))
- GDCM 2023-10-30 (b578ec5d) ([e7657b4022](https://github.com/InsightSoftwareConsortium/ITK/commit/e7657b4022))
- GDCM 2024-03-25 (06091299) ([919cf42417](https://github.com/InsightSoftwareConsortium/ITK/commit/919cf42417))
- GDCM 2024-04-02 (8a6da61b) ([6b77ea23e1](https://github.com/InsightSoftwareConsortium/ITK/commit/6b77ea23e1))


### Google double-conversion Maintainers (1):

#### Miscellaneous Changes

- DoubleConversion 2023-11-01 (15b7e306) ([3dcbf20f73](https://github.com/InsightSoftwareConsortium/ITK/commit/3dcbf20f73))


### Hans Johnson (14):

#### Style Changes

- Remove unused function ([6a5b34609a](https://github.com/InsightSoftwareConsortium/ITK/commit/6a5b34609a))

#### Enhancements

- Wrap new variant of itkLBFGS2Optimizerv4 ([44c06f67ab](https://github.com/InsightSoftwareConsortium/ITK/commit/44c06f67ab))

#### Documentation Updates

- The example is a TranslationTransform ([604fb3b10f](https://github.com/InsightSoftwareConsortium/ITK/commit/604fb3b10f))
- Refine ExhausiveOptimizer documentation ([f7c54f853a](https://github.com/InsightSoftwareConsortium/ITK/commit/f7c54f853a))
- Add more explicit documentation for transform parameters ([ee160a9657](https://github.com/InsightSoftwareConsortium/ITK/commit/ee160a9657))

#### Platform Fixes

- Numerical computation precision limit in resampling ([877acbac08](https://github.com/InsightSoftwareConsortium/ITK/commit/877acbac08))
- Add test for correct value of GetNameOfClass() ([e126823ace](https://github.com/InsightSoftwareConsortium/ITK/commit/e126823ace))
- Simplify static array length checking ([eb7d3423c3](https://github.com/InsightSoftwareConsortium/ITK/commit/eb7d3423c3))
- Use the c++ 17 common [[fallthrough]] attribute ([9243a075cd](https://github.com/InsightSoftwareConsortium/ITK/commit/9243a075cd))

#### Bug Fixes

- SetIdentity must retain FixedParameters ([db9cfea74b](https://github.com/InsightSoftwareConsortium/ITK/commit/db9cfea74b))
- Fix removal of '-' from patientId ([085446af77](https://github.com/InsightSoftwareConsortium/ITK/commit/085446af77))

#### Style Changes

- Localize variables and use const ([d17f47d486](https://github.com/InsightSoftwareConsortium/ITK/commit/d17f47d486))
- Fix grammar in documentation for MattesMutualInformation ([de3974ca93](https://github.com/InsightSoftwareConsortium/ITK/commit/de3974ca93))
- Use gender-neutral language for example documentation ([a895d7f597](https://github.com/InsightSoftwareConsortium/ITK/commit/a895d7f597))


### Jon Haitz Legarreta Gorroño (67):

#### Enhancements

- Add RTTI to `itk::FEMScatteredDataPointSetToImageFilter` ([6409bce13a](https://github.com/InsightSoftwareConsortium/ITK/commit/6409bce13a))
- Increase coverage for `ìtk::BSplineTransformInitializer` ([e6e759b46e](https://github.com/InsightSoftwareConsortium/ITK/commit/e6e759b46e))
- Increase `itk::ParallelSparseFieldLevelSetImageFilter` coverage ([87c5a9ae5f](https://github.com/InsightSoftwareConsortium/ITK/commit/87c5a9ae5f))
- Increase `itk::SingleValuedNonLinearVnlOptimizer` coverage ([adb447f078](https://github.com/InsightSoftwareConsortium/ITK/commit/adb447f078))
- Increase coverage for `itk::ObjectToObjectOptimizerBaseTemplate` ([3324ef04a6](https://github.com/InsightSoftwareConsortium/ITK/commit/3324ef04a6))
- Increase coverage for `itk::TransformGeometryImageFilter` ([cd6c940975](https://github.com/InsightSoftwareConsortium/ITK/commit/cd6c940975))
- Increase itk::DiscreteGaussianCurvatureQuadEdgeMeshFilter coverage ([19726285ac](https://github.com/InsightSoftwareConsortium/ITK/commit/19726285ac))
- Increase coverage for `itk::FancyString` ([8a802d7091](https://github.com/InsightSoftwareConsortium/ITK/commit/8a802d7091))
- Increase the `itk::SingleValuedNonLinearVnlOptimizerv4` coverage ([215209f4f1](https://github.com/InsightSoftwareConsortium/ITK/commit/215209f4f1))
- Increase `itk::ShapeOpeningLabelMapFilter` coverage ([f74435d109](https://github.com/InsightSoftwareConsortium/ITK/commit/f74435d109))
- Add test for `itk::XMLFilterWatcher` ([3c37fe34aa](https://github.com/InsightSoftwareConsortium/ITK/commit/3c37fe34aa))
- Add test for `itk::MeshRegion` ([fd076e4db2](https://github.com/InsightSoftwareConsortium/ITK/commit/fd076e4db2))
- Add boolean macro to `TransformFileWriterTemplate::m_AppendMode` ([4b400752f9](https://github.com/InsightSoftwareConsortium/ITK/commit/4b400752f9))
- Fix workflow actions warnings linked to `Node.js` ([95b8a6fa07](https://github.com/InsightSoftwareConsortium/ITK/commit/95b8a6fa07))
- Fix macOS ARM workflow actions warnings linked to `Node.js` ([65306d5f62](https://github.com/InsightSoftwareConsortium/ITK/commit/65306d5f62))

#### Documentation Updates

- Remove `itk` prefix to class names in Doxygen `class` command ([2dd28a46a6](https://github.com/InsightSoftwareConsortium/ITK/commit/2dd28a46a6))
- Fix `QuadEdgeMeshScalarDataVTKPolyDataWriter` Doxygen `class` name ([f0019cb8f9](https://github.com/InsightSoftwareConsortium/ITK/commit/f0019cb8f9))
- Add missing closing bracket in contributing enforcement insert ([b63df69488](https://github.com/InsightSoftwareConsortium/ITK/commit/b63df69488))
- Fix diversity statement link in code of conduct ([d99753f4e0](https://github.com/InsightSoftwareConsortium/ITK/commit/d99753f4e0))
- Add link to documentation in `README` ([5ed8c4bb00](https://github.com/InsightSoftwareConsortium/ITK/commit/5ed8c4bb00))
- Improve `itk::GIPLImageIO` brief explanation ([7b1f4ba8a1](https://github.com/InsightSoftwareConsortium/ITK/commit/7b1f4ba8a1))
- Fix the `itk::MeshRegion::SetRegion` method doc description ([cf8c8c2c68](https://github.com/InsightSoftwareConsortium/ITK/commit/cf8c8c2c68))
- Add ITK scientific ecosystem section to documentation ([f5e17ca53f](https://github.com/InsightSoftwareConsortium/ITK/commit/f5e17ca53f))
- Transfer the wiki FAQ page to Markdown documentation ([7ced4cc337](https://github.com/InsightSoftwareConsortium/ITK/commit/7ced4cc337))
- Fix grammar in the ITK ecosystem documentation page ([8a4ab318ef](https://github.com/InsightSoftwareConsortium/ITK/commit/8a4ab318ef))
- Fix ITK class Doxygen documentation link Markdown syntax in FAQs ([e71aa71799](https://github.com/InsightSoftwareConsortium/ITK/commit/e71aa71799))
- Remove deprecated combined ITK/VTK use doc section in FAQs ([2167ca59ee](https://github.com/InsightSoftwareConsortium/ITK/commit/2167ca59ee))
- Transfer the wiki FDA SW guidelines page to Markdown documentation ([63045e7c1d](https://github.com/InsightSoftwareConsortium/ITK/commit/63045e7c1d))
- Honor `ITK-Wasm`'s case in documentation files ([6459a622c7](https://github.com/InsightSoftwareConsortium/ITK/commit/6459a622c7))
- Fix FAQ documentation heading typo ([ba49d436ec](https://github.com/InsightSoftwareConsortium/ITK/commit/ba49d436ec))
- Remove mention to deprecated `itk::DICOMImageIO` class in FAQs ([6e42f13e87](https://github.com/InsightSoftwareConsortium/ITK/commit/6e42f13e87))
- Remove mentions to deprecated `ITKApps` from FAQs ([4deead1f08](https://github.com/InsightSoftwareConsortium/ITK/commit/4deead1f08))
- Transfer the wiki HU page to Markdown documentation ([b4c1154686](https://github.com/InsightSoftwareConsortium/ITK/commit/b4c1154686))
- Transfer the wiki documenting ITK page to Markdown documentation ([5c730b1196](https://github.com/InsightSoftwareConsortium/ITK/commit/5c730b1196))
- Remove non-existing file from documentation TOC ([7d8b95d705](https://github.com/InsightSoftwareConsortium/ITK/commit/7d8b95d705))
- Transfer the wiki DICOM page to Markdown documentation ([676f80cc9b](https://github.com/InsightSoftwareConsortium/ITK/commit/676f80cc9b))
- Transfer the wiki 3rd party apps page to Markdown documentation ([e186d876b3](https://github.com/InsightSoftwareConsortium/ITK/commit/e186d876b3))
- Redirect to current location in docs transferred wiki links ([4543ba6dce](https://github.com/InsightSoftwareConsortium/ITK/commit/4543ba6dce))
- Rename the FDA SW development guidelines doc file ([bc135604b8](https://github.com/InsightSoftwareConsortium/ITK/commit/bc135604b8))
- Fix reStructuredText link syntax in `Documenting ITK` doc file ([64fff24627](https://github.com/InsightSoftwareConsortium/ITK/commit/64fff24627))
- Fix `itk::FEMSpatialObjectWriter` Doxygen `brief` description ([3b0a786c03](https://github.com/InsightSoftwareConsortium/ITK/commit/3b0a786c03))
- Fix grammar in binary data upload documentation file ([c1687e991a](https://github.com/InsightSoftwareConsortium/ITK/commit/c1687e991a))

#### Platform Fixes

- Fix name of class assertion failure in FEM module ([2999b59ebb](https://github.com/InsightSoftwareConsortium/ITK/commit/2999b59ebb))
- Remove unused `FEM` module test input arguments ([00e059ed52](https://github.com/InsightSoftwareConsortium/ITK/commit/00e059ed52))
- Fix test method signature in `FEM` module ([26f7fbb200](https://github.com/InsightSoftwareConsortium/ITK/commit/26f7fbb200))
- Remove unnecessary `itkFEMSpatialObjectWriter.h` includes ([e306437e56](https://github.com/InsightSoftwareConsortium/ITK/commit/e306437e56))
- Fix macro spelling in `itkOpenCVImageBridgeRGBTest.cxx` ([299ce20329](https://github.com/InsightSoftwareConsortium/ITK/commit/299ce20329))

#### Bug Fixes

- Fix `CachedCurrentPosition` ivar initialization numeric traits arg ([50b905a8ae](https://github.com/InsightSoftwareConsortium/ITK/commit/50b905a8ae))

#### Style Changes

- Increase `itk::ListSample::PrintSelf` consistency ([fe184c8d9a](https://github.com/InsightSoftwareConsortium/ITK/commit/fe184c8d9a))
- Conform to ITK style guidelines in test ending message ([1f80e3554e](https://github.com/InsightSoftwareConsortium/ITK/commit/1f80e3554e))
- Improve PSFLSIF test style ([45583cf29b](https://github.com/InsightSoftwareConsortium/ITK/commit/45583cf29b))
- Prefer using testing macros in miscellaneous tests ([043b0680cb](https://github.com/InsightSoftwareConsortium/ITK/commit/043b0680cb))
- Use medial capitals to name variables in test ([2cc791c2ef](https://github.com/InsightSoftwareConsortium/ITK/commit/2cc791c2ef))
- Rename test to honor the tested class ([28ef2f160b](https://github.com/InsightSoftwareConsortium/ITK/commit/28ef2f160b))
- Use testing macros in `itkFancyStringTest.cxx` ([2b8ce7799b](https://github.com/InsightSoftwareConsortium/ITK/commit/2b8ce7799b))
- Use the superclass name in itkTypeMacro ([fb8a573ef7](https://github.com/InsightSoftwareConsortium/ITK/commit/fb8a573ef7))
- Remove unnecessary whitespaces in Release doc code blocks ([15fc83174a](https://github.com/InsightSoftwareConsortium/ITK/commit/15fc83174a))
- Fix verbatim code syntax in Python quick start documentation ([906e69d6fa](https://github.com/InsightSoftwareConsortium/ITK/commit/906e69d6fa))
- Use inline verbatim code style for Python supported pixel types ([2f13f82f6f](https://github.com/InsightSoftwareConsortium/ITK/commit/2f13f82f6f))
- Increase consistency in doc code block highlight language names ([cd22deff6b](https://github.com/InsightSoftwareConsortium/ITK/commit/cd22deff6b))
- Remove prompt and spaces in Markdown documentation bash blocks ([a6036a8b6f](https://github.com/InsightSoftwareConsortium/ITK/commit/a6036a8b6f))
- Increase consistency in doc bash code block highlight name ([4d316b9380](https://github.com/InsightSoftwareConsortium/ITK/commit/4d316b9380))
- Prefer regular font in `Documenting ITK` doc file link text ([caab8d2384](https://github.com/InsightSoftwareConsortium/ITK/commit/caab8d2384))
- Remove commented statements with hard-coded filenames in `FEM` ([842c32cd39](https://github.com/InsightSoftwareConsortium/ITK/commit/842c32cd39))
- Start reader/writer `FEM` module local variables with lowercase ([d3cc8743d5](https://github.com/InsightSoftwareConsortium/ITK/commit/d3cc8743d5))
- Check properly `FEM` module test input arguments ([60067a656d](https://github.com/InsightSoftwareConsortium/ITK/commit/60067a656d))
- Use `ITK_TEST_EXPECT_EQUAL` to compare class names in QEMesh ([781cf0d33c](https://github.com/InsightSoftwareConsortium/ITK/commit/781cf0d33c))


### KWSys Upstream (1):

#### Miscellaneous Changes

- KWSys 2023-11-29 (433f3d23) ([20e98390b3](https://github.com/InsightSoftwareConsortium/ITK/commit/20e98390b3))


### LIBPNG Upstream (1):

#### Miscellaneous Changes

- PNG 2024-02-10 (7a614829) ([55292c9a5f](https://github.com/InsightSoftwareConsortium/ITK/commit/55292c9a5f))


### Martin Hoßbach (1):

#### Bug Fixes

- itkDCMTKFileReader Philips multi-frame MRI Z spacing ([dbd46b48bf](https://github.com/InsightSoftwareConsortium/ITK/commit/dbd46b48bf))


### Matt McCormick (83):

#### Enhancements

- Remove ContentLinkSynchronization.sh script ([80af986eca](https://github.com/InsightSoftwareConsortium/ITK/commit/80af986eca))
- Transition SourceTarball.bash script for .cid ([561383ed4a](https://github.com/InsightSoftwareConsortium/ITK/commit/561383ed4a))
- Update remote modules to their latest version ([521c2215a2](https://github.com/InsightSoftwareConsortium/ITK/commit/521c2215a2))
- Wrap CompositeTransform for float32 parameters ([7a6053fc72](https://github.com/InsightSoftwareConsortium/ITK/commit/7a6053fc72))
- Test to verify GDCM multi-frame MRI Z spacing ([106cd680d8](https://github.com/InsightSoftwareConsortium/ITK/commit/106cd680d8))
- Add DICOM preamble, no_preamble tests ([8427bbec0b](https://github.com/InsightSoftwareConsortium/ITK/commit/8427bbec0b))
- Test CanReadFile for DICOM files with a preamble ([a099f08c20](https://github.com/InsightSoftwareConsortium/ITK/commit/a099f08c20))
- Bump DCMTK to 2024-03-11 master ([db9c048921](https://github.com/InsightSoftwareConsortium/ITK/commit/db9c048921))
- Enable DCMTK_ENABLE_BUILTIN_OFICONV_DATA by default ([1ed8ead451](https://github.com/InsightSoftwareConsortium/ITK/commit/1ed8ead451))
- Enable SecondaryCaptureImagePlaneModel in GDCM ([f545dd8f5b](https://github.com/InsightSoftwareConsortium/ITK/commit/f545dd8f5b))
- Add test for reading DICOM secondary capture spatial metadata ([8eb077a113](https://github.com/InsightSoftwareConsortium/ITK/commit/8eb077a113))
- Bump SWIG to 2024-03-26-master ([d6c69f5eb7](https://github.com/InsightSoftwareConsortium/ITK/commit/d6c69f5eb7))
- Add macOS ARM SWIG binary ([2df824bdbf](https://github.com/InsightSoftwareConsortium/ITK/commit/2df824bdbf))
- Add macOS AMD64 SWIG binary ([b507643bf0](https://github.com/InsightSoftwareConsortium/ITK/commit/b507643bf0))
- Add Linux aarch64 SWIG binary ([82d8165eba](https://github.com/InsightSoftwareConsortium/ITK/commit/82d8165eba))
- Add Python Limited API support ([0c5e523c14](https://github.com/InsightSoftwareConsortium/ITK/commit/0c5e523c14))
- Update pygccxml-upstream branch version ([a7e6b3ce32](https://github.com/InsightSoftwareConsortium/ITK/commit/a7e6b3ce32))
- Add macOS ARM GitHub Actions configuration ([99d13a4677](https://github.com/InsightSoftwareConsortium/ITK/commit/99d13a4677))
- Add macOS ARM Python CI ([60756c28f0](https://github.com/InsightSoftwareConsortium/ITK/commit/60756c28f0))
- Add more tests for DICOM Secondary Capture Spacing ([a2447ab7c1](https://github.com/InsightSoftwareConsortium/ITK/commit/a2447ab7c1))

#### Documentation Updates

- Update Download page for release artifacts ([b4826a46b1](https://github.com/InsightSoftwareConsortium/ITK/commit/b4826a46b1))
- Update Download link in README ([fa38cbec52](https://github.com/InsightSoftwareConsortium/ITK/commit/fa38cbec52))
- Sphinx documentation subtitle: ITK's documentation ([530da05774](https://github.com/InsightSoftwareConsortium/ITK/commit/530da05774))
- Add Download page links to the release notes ([cd5dfade84](https://github.com/InsightSoftwareConsortium/ITK/commit/cd5dfade84))
- Improve documentation contribution documents ([83a94bbda4](https://github.com/InsightSoftwareConsortium/ITK/commit/83a94bbda4))
- Link to rendered docs for CODE_OF_CONDUCT.md, CONTRIBUTING.md ([af1fa27aeb](https://github.com/InsightSoftwareConsortium/ITK/commit/af1fa27aeb))
- Migrate the migration guide to Sphinx ([094213f076](https://github.com/InsightSoftwareConsortium/ITK/commit/094213f076))
- Migrate the NOTICE file to markdown ([9c91750e61](https://github.com/InsightSoftwareConsortium/ITK/commit/9c91750e61))
- Add CDash link ([8f1542fcd3](https://github.com/InsightSoftwareConsortium/ITK/commit/8f1542fcd3))
- Integrate supported compiler docs into sphinx ([357bee25ff](https://github.com/InsightSoftwareConsortium/ITK/commit/357bee25ff))
- Add Releases and Licenses to Download section ([feafcdbf9c](https://github.com/InsightSoftwareConsortium/ITK/commit/feafcdbf9c))
- Add documentation contribution docs to the docs ([6a751db842](https://github.com/InsightSoftwareConsortium/ITK/commit/6a751db842))
- Add note about RTD default rendered documentation version ([b658820c22](https://github.com/InsightSoftwareConsortium/ITK/commit/b658820c22))
- Add Release process documentation notes on release branches ([655889e22c](https://github.com/InsightSoftwareConsortium/ITK/commit/655889e22c))
- Move CDash link to Contributing section ([658d949d36](https://github.com/InsightSoftwareConsortium/ITK/commit/658d949d36))
- Add Dashboard documentation to contributing docs ([7d27bd1458](https://github.com/InsightSoftwareConsortium/ITK/commit/7d27bd1458))
- Move Git branches description into main docs ([db4b1d224e](https://github.com/InsightSoftwareConsortium/ITK/commit/db4b1d224e))
- Add GNU Guix package installation instruction ([1f1882f77a](https://github.com/InsightSoftwareConsortium/ITK/commit/1f1882f77a))
- Release manager data archiving process for 5.4 ([2387097235](https://github.com/InsightSoftwareConsortium/ITK/commit/2387097235))
- Add missing sphinx-autobuild link ([70bcd968ce](https://github.com/InsightSoftwareConsortium/ITK/commit/70bcd968ce))
- Add Python Quick Start guide ([6c210cb92d](https://github.com/InsightSoftwareConsortium/ITK/commit/6c210cb92d))
- Update and clarify binary data upload process ([4564b6f973](https://github.com/InsightSoftwareConsortium/ITK/commit/4564b6f973))
- Update ITK Python package quick start link ([094e888ba0](https://github.com/InsightSoftwareConsortium/ITK/commit/094e888ba0))
- Upload Binary Data grammar improvements ([751e9ca699](https://github.com/InsightSoftwareConsortium/ITK/commit/751e9ca699))
- Add 5.4 RC 02 Release Notes ([9ed6cad74a](https://github.com/InsightSoftwareConsortium/ITK/commit/9ed6cad74a))
- More background for supported compilers ([c46aaf30dc](https://github.com/InsightSoftwareConsortium/ITK/commit/c46aaf30dc))
- Update SetupForDevelopment.sh link to contributing documentation ([60a34147b3](https://github.com/InsightSoftwareConsortium/ITK/commit/60a34147b3))
- Add macOS ARM CI badge to README ([130d4f0990](https://github.com/InsightSoftwareConsortium/ITK/commit/130d4f0990))

#### Platform Fixes

- Remove diversity-statement cross-reference ([229be245ec](https://github.com/InsightSoftwareConsortium/ITK/commit/229be245ec))
- yaml language annotation on module_workflows.md ([c55b289587](https://github.com/InsightSoftwareConsortium/ITK/commit/c55b289587))
- Add itkSLICImageFilterTest1 baseline for macOS ARM ([aa93b4ac18](https://github.com/InsightSoftwareConsortium/ITK/commit/aa93b4ac18))
- Use signed char for SobelOperator convolution test ([32535078a3](https://github.com/InsightSoftwareConsortium/ITK/commit/32535078a3))
- Only support SWIG slice workaround for Python >= 3.2 ([fad5849468](https://github.com/InsightSoftwareConsortium/ITK/commit/fad5849468))
- Remove use of itkDebugMacro in static method ([843dba1678](https://github.com/InsightSoftwareConsortium/ITK/commit/843dba1678))
- Remove distutils imports ([423d6494e3](https://github.com/InsightSoftwareConsortium/ITK/commit/423d6494e3))
- include stdlib.h for SWIG free/malloc with the Stable ABI ([7e4c0c54b8](https://github.com/InsightSoftwareConsortium/ITK/commit/7e4c0c54b8))
- Python Stable ABI support configuration improvements ([8da6c2e338](https://github.com/InsightSoftwareConsortium/ITK/commit/8da6c2e338))
- Bump Validated CMake policies version to 3.29.0 ([6e88ab6fd9](https://github.com/InsightSoftwareConsortium/ITK/commit/6e88ab6fd9))
- Bump zlib-ng CMake max policy to 3.29.0 ([cdd8be3b91](https://github.com/InsightSoftwareConsortium/ITK/commit/cdd8be3b91))
- Apple Clang 15 duplicate libraries ([7231bf793f](https://github.com/InsightSoftwareConsortium/ITK/commit/7231bf793f))
- ResampleImageFilter9 baseline for ARM macOS ([75e08fcf43](https://github.com/InsightSoftwareConsortium/ITK/commit/75e08fcf43))
- Bump KWStyle to silence boost predefined-identifier warning ([566f9f531a](https://github.com/InsightSoftwareConsortium/ITK/commit/566f9f531a))
- Wrap 1D FFT classes before their Vnl implementations ([03643a3941](https://github.com/InsightSoftwareConsortium/ITK/commit/03643a3941))
- Specify second template parameter for 1D FFT wrapping ([44f3dc9971](https://github.com/InsightSoftwareConsortium/ITK/commit/44f3dc9971))
- Use both template parameters for ShapeLabelMapFilter wrapping ([b61d4ed7f1](https://github.com/InsightSoftwareConsortium/ITK/commit/b61d4ed7f1))
- Specify all template parameters for NarrowBandLevelSetImageFilter ([ee33f5ae1b](https://github.com/InsightSoftwareConsortium/ITK/commit/ee33f5ae1b))
- Bump CastXML to 0.6.5, LLVM to 18.1.3 ([44a6beec77](https://github.com/InsightSoftwareConsortium/ITK/commit/44a6beec77))

#### Bug Fixes

- Support serialization of an empty itk.Image ([0a08d16c2b](https://github.com/InsightSoftwareConsortium/ITK/commit/0a08d16c2b))
- Add pickle support for itk.Matrix and itk.ImageRegion ([4dec7917da](https://github.com/InsightSoftwareConsortium/ITK/commit/4dec7917da))
- Wrap LBFGSOptimizerBaseHelperv4 before LBFGSOptimizerBasev4 ([119e8da7b1](https://github.com/InsightSoftwareConsortium/ITK/commit/119e8da7b1))
- Fix protocol identification in UpdateRemoteModules.sh script ([b4c65b32e8](https://github.com/InsightSoftwareConsortium/ITK/commit/b4c65b32e8))
- Mark CMake variables as advanced ([3bd88cedd2](https://github.com/InsightSoftwareConsortium/ITK/commit/3bd88cedd2))
- Increase size limite for GDCM privatedicts.xml file ([11630a0436](https://github.com/InsightSoftwareConsortium/ITK/commit/11630a0436))
- Remove ArchiveTestingDataOnGirder.py ([62cf190608](https://github.com/InsightSoftwareConsortium/ITK/commit/62cf190608))
- CMake find_package for Python requires 3.8 or newer ([fd266a93a6](https://github.com/InsightSoftwareConsortium/ITK/commit/fd266a93a6))
- Check for Secondary Capture spacing following DICOM Part 3 Sect A.8.1.3 ([c23d6c730f](https://github.com/InsightSoftwareConsortium/ITK/commit/c23d6c730f))
- CastXML update Linux AArch64 binary ([270f726ba9](https://github.com/InsightSoftwareConsortium/ITK/commit/270f726ba9))
- Fix Py_LIMITED_API minor version spec ([8b4778732f](https://github.com/InsightSoftwareConsortium/ITK/commit/8b4778732f))

#### Style Changes

- Remote modules keep key-value on the same line ([7d94ec1790](https://github.com/InsightSoftwareConsortium/ITK/commit/7d94ec1790))
- Run ./Utilities/Maintenance/cmake-format.bash --tracked ([0a36430ea7](https://github.com/InsightSoftwareConsortium/ITK/commit/0a36430ea7))
- Replace ${git_protocol} with https ([8b22004029](https://github.com/InsightSoftwareConsortium/ITK/commit/8b22004029))
- Simplify SWIG CMake variables ([c12eaef63c](https://github.com/InsightSoftwareConsortium/ITK/commit/c12eaef63c))
- Use transformType in transform dict representation ([015c7546d6](https://github.com/InsightSoftwareConsortium/ITK/commit/015c7546d6))


### Matthew McCormick (2):

#### Documentation Updates

- Release version consistency ([b15e272796](https://github.com/InsightSoftwareConsortium/ITK/commit/b15e272796))
- Clarify latest vs release version in generated docs ([96f2299f22](https://github.com/InsightSoftwareConsortium/ITK/commit/96f2299f22))


### MetaIO Maintainers (2):

#### Miscellaneous Changes

- MetaIO 2024-02-15 (8bd99f13) ([7c8f3bbe40](https://github.com/InsightSoftwareConsortium/ITK/commit/7c8f3bbe40))
- MetaIO 2024-04-03 (ea08147a) ([4951dbc756](https://github.com/InsightSoftwareConsortium/ITK/commit/4951dbc756))


### Mihail Isakov (6):

#### Enhancements

- Fixed coverity warnings in itkImageRegion.h ([9d2364ffb5](https://github.com/InsightSoftwareConsortium/ITK/commit/9d2364ffb5))

#### Performance Improvements

- Fixed COPY_INSTEAD_OF_MOVE in MultiThreaderBase ([f486c3c2f7](https://github.com/InsightSoftwareConsortium/ITK/commit/f486c3c2f7))

#### Documentation Updates

- Fix typo in itkRGBPixel.h ([adcc46bf96](https://github.com/InsightSoftwareConsortium/ITK/commit/adcc46bf96))

#### Style Changes

- Update comments and parameter in the ImportImageContainer ([3ad51b4ac2](https://github.com/InsightSoftwareConsortium/ITK/commit/3ad51b4ac2))
- remove duplicated itkMath.h headers ([3cafe87c58](https://github.com/InsightSoftwareConsortium/ITK/commit/3cafe87c58))
- remove unnecessary itkImageFileWriter.h header ([8010fafde3](https://github.com/InsightSoftwareConsortium/ITK/commit/8010fafde3))


### NIFTI Upstream (3):

#### Miscellaneous Changes

- nifti 2023-09-11 (75180f77) ([6a88f6140b](https://github.com/InsightSoftwareConsortium/ITK/commit/6a88f6140b))
- nifti 2024-01-25 (f24bec50) ([a7f14bdff4](https://github.com/InsightSoftwareConsortium/ITK/commit/a7f14bdff4))
- nifti 2024-01-25 (f24bec50) ([458dbf6daa](https://github.com/InsightSoftwareConsortium/ITK/commit/458dbf6daa))


### Niels Dekker (149):

#### Enhancements

- Add `get()` member function to itk::SmartPointer ([f74950f493](https://github.com/InsightSoftwareConsortium/ITK/commit/f74950f493))
- ShapedImageNeighborhoodRange support C-array of offsets (by C++17) ([77e147bfa9](https://github.com/InsightSoftwareConsortium/ITK/commit/77e147bfa9))
- Add `Deref(T *)`, to ease dereferencing a pointer safely ([042d42327b](https://github.com/InsightSoftwareConsortium/ITK/commit/042d42327b))
- Add `Crop` unit tests to itkImageRegionGTest ([25afa49d45](https://github.com/InsightSoftwareConsortium/ITK/commit/25afa49d45))
- Add `itkImageRandomConstIteratorWithIndexGTest` unit test ([b48c999aab](https://github.com/InsightSoftwareConsortium/ITK/commit/b48c999aab))
- Add itkVirtualGetNameOfClassMacro + itkOverrideGetNameOfClassMacro ([94e7339da4](https://github.com/InsightSoftwareConsortium/ITK/commit/94e7339da4))
- Add Size::CalculateProductOfElements(), to compute number of pixels ([c4ef860638](https://github.com/InsightSoftwareConsortium/ITK/commit/c4ef860638))
- `ImageRegion` support C++17 structured binding ([72aa9a602b](https://github.com/InsightSoftwareConsortium/ITK/commit/72aa9a602b))
- Add class template argument deduction (CTAD) support to ImageRegion ([8de195f404](https://github.com/InsightSoftwareConsortium/ITK/commit/8de195f404))
- Check `thisClass` argument of `GetNameOfClass` macro calls ([d45127b5a3](https://github.com/InsightSoftwareConsortium/ITK/commit/d45127b5a3))
- Add `itk::Copy(const T & original)`, which simply returns a copy ([b2dacece7a](https://github.com/InsightSoftwareConsortium/ITK/commit/b2dacece7a))
- Add error message to static_assert in `GetNameOfClass()` macro ([16101c6eaa](https://github.com/InsightSoftwareConsortium/ITK/commit/16101c6eaa))
- Add `MultiThreaderBase::SetSingleMethodAndExecute` member function ([972b5779a5](https://github.com/InsightSoftwareConsortium/ITK/commit/972b5779a5))
- Let ImageSpatialObject update the image regions of its base class ([5e528ec174](https://github.com/InsightSoftwareConsortium/ITK/commit/5e528ec174))
- Add ValueInitializedIsZeroFilled tests for derived FixedArray types ([aa38dce1a5](https://github.com/InsightSoftwareConsortium/ITK/commit/aa38dce1a5))
- Add `AllocateInitialized()` to ImageBase ([47fe345cd8](https://github.com/InsightSoftwareConsortium/ITK/commit/47fe345cd8))
- Let `x::New()` initialize the created object by doing `new x()` ([1986b54f89](https://github.com/InsightSoftwareConsortium/ITK/commit/1986b54f89))
- Add `Array2D(numberOfRows, numberOfCols, initialValue)` constructor ([ec5223eb89](https://github.com/InsightSoftwareConsortium/ITK/commit/ec5223eb89))
- Add GoogleTest unit tests for GradientImageFilter ([17a221c0c1](https://github.com/InsightSoftwareConsortium/ITK/commit/17a221c0c1))
- Add protected helper function, `Transform::InvertTransform` ([5328c0242b](https://github.com/InsightSoftwareConsortium/ITK/commit/5328c0242b))

#### Performance Improvements

- Make `ImageRegion` trivially copyable, remove inheritance (FUTURE) ([1f3bbb6586](https://github.com/InsightSoftwareConsortium/ITK/commit/1f3bbb6586))
- Replace std::function w/ template argument ParallelizeImageRegion ([40f04a892c](https://github.com/InsightSoftwareConsortium/ITK/commit/40f04a892c))
- Let SetSingleMethod move its first argument (`f`) ([06629c249b](https://github.com/InsightSoftwareConsortium/ITK/commit/06629c249b))
- Let Singleton move its `deleteFunc` argument ([5276de74c8](https://github.com/InsightSoftwareConsortium/ITK/commit/5276de74c8))
- Let SpatialObject directly access m_ObjectToWorldTransformInverse ([1e0475cc6b](https://github.com/InsightSoftwareConsortium/ITK/commit/1e0475cc6b))
- Add SpatialObject IsInsideInWorldSpace(const PointType &) overload ([2ca2351340](https://github.com/InsightSoftwareConsortium/ITK/commit/2ca2351340))
- Make `m_ObjectToWorldTransformInverse->TransformPoint` non-virtual ([4ae04b35fa](https://github.com/InsightSoftwareConsortium/ITK/commit/4ae04b35fa))
- ImageMaskSpatialObject use image regions from its base class ([671d758ac3](https://github.com/InsightSoftwareConsortium/ITK/commit/671d758ac3))
- FUTURE: Default default-constructors of `RGBPixel` and `RGBAPixel` ([755cd10e54](https://github.com/InsightSoftwareConsortium/ITK/commit/755cd10e54))
- FUTURE: Default default-constructor of `SymmetricSecondRankTensor` ([0a30e7fc20](https://github.com/InsightSoftwareConsortium/ITK/commit/0a30e7fc20))

#### Documentation Updates

- Replace the word "overwrite" with "override" in SpatialObject doc ([f87fd913a7](https://github.com/InsightSoftwareConsortium/ITK/commit/f87fd913a7))
- Avoid the term "pure virtual function" in SpatialObject doc ([c9c7236457](https://github.com/InsightSoftwareConsortium/ITK/commit/c9c7236457))
- Replace examples of `SpatialObject` functions that one may override ([21e795bbf4](https://github.com/InsightSoftwareConsortium/ITK/commit/21e795bbf4))
- Add `GetNameOfClass` macro's to DOXYGEN_PREDEFINED ([77f5c6d6f5](https://github.com/InsightSoftwareConsortium/ITK/commit/77f5c6d6f5))
- Remove obsolete information about `Array2D` ([091a270b4b](https://github.com/InsightSoftwareConsortium/ITK/commit/091a270b4b))
- Document constructors and assignment operators of `Array2D` ([88e4f10628](https://github.com/InsightSoftwareConsortium/ITK/commit/88e4f10628))
- Update documentation of `GetNameOfClass` macro calls ([4d750726d0](https://github.com/InsightSoftwareConsortium/ITK/commit/4d750726d0))

#### Platform Fixes

- Use conjunction_v to check argument types of MakePoint, MakeVector ([da418c11c5](https://github.com/InsightSoftwareConsortium/ITK/commit/da418c11c5))
- Exclude Utilities/Debugger files from Azure Pipelines CI ([00badaeafb](https://github.com/InsightSoftwareConsortium/ITK/commit/00badaeafb))
- Fix XML namespace of Natvis file (Visual Studio Debug Visualizers) ([dccdf4b00a](https://github.com/InsightSoftwareConsortium/ITK/commit/dccdf4b00a))
- Examples: Replace itkTypeMacro with itkOverrideGetNameOfClassMacro ([e76c37287f](https://github.com/InsightSoftwareConsortium/ITK/commit/e76c37287f))
- PyUtils: Replace itkTypeMacro with itkOverrideGetNameOfClassMacro ([c1af2b7b16](https://github.com/InsightSoftwareConsortium/ITK/commit/c1af2b7b16))
- Locally ignore Clang `-Wmismatched-tags` warnings in `ImageRegion` ([9a35c2fdcd](https://github.com/InsightSoftwareConsortium/ITK/commit/9a35c2fdcd))

#### Bug Fixes

- Remove `numeric_limits<IndexValueType>::max` from ImageRegion GTest ([8e5d3f8788](https://github.com/InsightSoftwareConsortium/ITK/commit/8e5d3f8788))
- Fix name `BinaryImageToLevelSetImageAdaptor::GetNameOfClass()` ([038c7391e0](https://github.com/InsightSoftwareConsortium/ITK/commit/038c7391e0))
- Fix name returned by `GetNameOfClass()` in Optimizer tests ([4ee0617b5e](https://github.com/InsightSoftwareConsortium/ITK/commit/4ee0617b5e))
- Replace Math::Round template argument `double` with `int64_t` ([705f84f0fc](https://github.com/InsightSoftwareConsortium/ITK/commit/705f84f0fc))

#### Style Changes

- Use `volatile` to avoid global SingletonIndex being optimized out ([a661e0e74b](https://github.com/InsightSoftwareConsortium/ITK/commit/a661e0e74b))
- Fix XML namespace of natstepfilter file (Visual Studio Debugger) ([7f3f616137](https://github.com/InsightSoftwareConsortium/ITK/commit/7f3f616137))
- ResetNextSeed GTest should not use instance for GetNextSeed call ([fed6ed0f2a](https://github.com/InsightSoftwareConsortium/ITK/commit/fed6ed0f2a))
- Replace `Unused` calls with C++17 `[[maybe_unused]]` attribute ([a28242a155](https://github.com/InsightSoftwareConsortium/ITK/commit/a28242a155))
- Deprecate (ITK_FUTURE_LEGACY_REMOVE) `Unused(const T &)` ([2803ebbb05](https://github.com/InsightSoftwareConsortium/ITK/commit/2803ebbb05))
- Replace ASSERT_NE calls with `Deref` in VTKPolyDataMeshIO GTest ([85e29d0ad6](https://github.com/InsightSoftwareConsortium/ITK/commit/85e29d0ad6))
- ImageRegion replace GetIndex(), GetSize() calls with data access ([1b576481a7](https://github.com/InsightSoftwareConsortium/ITK/commit/1b576481a7))
- Remove local `cropPossible` variable from `ImageRegion::Crop` ([fc17f0bacb](https://github.com/InsightSoftwareConsortium/ITK/commit/fc17f0bacb))
- Reduce scope of local for-loop index `i` in `ImageRegion::Crop` ([6d86d1fb61](https://github.com/InsightSoftwareConsortium/ITK/commit/6d86d1fb61))
- Remove local `crop` variable from `ImageRegion::Crop` ([8439a2e4a7](https://github.com/InsightSoftwareConsortium/ITK/commit/8439a2e4a7))
- Remove unreachable `break` statements after `return` statements ([9fab1bcd9d](https://github.com/InsightSoftwareConsortium/ITK/commit/9fab1bcd9d))
- Replace std::min, std::max calls in "Colormap" with `std::clamp` ([83613f78de](https://github.com/InsightSoftwareConsortium/ITK/commit/83613f78de))
- Replace std::min, std::max in ProgressTransformer with std::clamp ([118581ebc2](https://github.com/InsightSoftwareConsortium/ITK/commit/118581ebc2))
- Replace std::min, std::max in SliceImageFilter with `std::clamp` ([007d93f8ec](https://github.com/InsightSoftwareConsortium/ITK/commit/007d93f8ec))
- Use `std::clamp` in GetGlobalDefaultNumberOfThreads() ([2ee5c8e60a](https://github.com/InsightSoftwareConsortium/ITK/commit/2ee5c8e60a))
- MersenneTwisterGlobals replace std::recursive_mutex w/ std::mutex ([dad0d82149](https://github.com/InsightSoftwareConsortium/ITK/commit/dad0d82149))
- Rename MersenneTwisterGlobals data member from "Lock" to "Mutex" ([476d9e7aee](https://github.com/InsightSoftwareConsortium/ITK/commit/476d9e7aee))
- Remove unused local `ImageRegion` variables ([1a2e2b3c0e](https://github.com/InsightSoftwareConsortium/ITK/commit/1a2e2b3c0e))
- Remove pre-C++17 definitions of static `constexpr` data members ([8061d3ce15](https://github.com/InsightSoftwareConsortium/ITK/commit/8061d3ce15))
- ITK_FUTURE_LEGACY_REMOVE, deprecate TemplatedThreadingFunctorType ([eef26b53fa](https://github.com/InsightSoftwareConsortium/ITK/commit/eef26b53fa))
- Use "constexpr if" in `ParallelizeImageRegionRestrictDirection` ([dd930155a1](https://github.com/InsightSoftwareConsortium/ITK/commit/dd930155a1))
- Remove `continue` from `ParallelizeImageRegionRestrictDirection` ([620b592353](https://github.com/InsightSoftwareConsortium/ITK/commit/620b592353))
- Remove splitRegion from `ParallelizeImageRegionRestrictDirection` ([e04d4c2b80](https://github.com/InsightSoftwareConsortium/ITK/commit/e04d4c2b80))
- Replace default capture `ParallelizeImageRegionRestrictDirection` ([f9d21aed07](https://github.com/InsightSoftwareConsortium/ITK/commit/f9d21aed07))
- Replace itkTypeMacroNoParent with itkVirtualGetNameOfClassMacro ([fa1f39a2b6](https://github.com/InsightSoftwareConsortium/ITK/commit/fa1f39a2b6))
- Replace itkTypeMacro calls with `itkOverrideGetNameOfClassMacro` ([2c264ea2ef](https://github.com/InsightSoftwareConsortium/ITK/commit/2c264ea2ef))
- ITK_FUTURE_LEGACY_REMOVE itkTypeMacro and itkTypeMacroNoParent ([36e9549880](https://github.com/InsightSoftwareConsortium/ITK/commit/36e9549880))
- ImageRegion GetNumberOfPixels() call CalculateProductOfElements() ([12f87f4924](https://github.com/InsightSoftwareConsortium/ITK/commit/12f87f4924))
- Let Neighborhood SetRadius call Size CalculateProductOfElements() ([af1182a98a](https://github.com/InsightSoftwareConsortium/ITK/commit/af1182a98a))
- Remove `std::` prefix from uint8_t in MathematicalMorphologyEnums ([ed4b29d271](https://github.com/InsightSoftwareConsortium/ITK/commit/ed4b29d271))
- Replace `#include <cstdint>` with `#include "itkIntTypes.h"` ([c8ec91c826](https://github.com/InsightSoftwareConsortium/ITK/commit/c8ec91c826))
- Add `itkInternalGetNameOfClassImplementationMacro` macro ([2cc371a93f](https://github.com/InsightSoftwareConsortium/ITK/commit/2cc371a93f))
- Use std::next in `LabelMap::GetNthLabelObject` ([f844df9f0e](https://github.com/InsightSoftwareConsortium/ITK/commit/f844df9f0e))
- Default LabelMap default-constructor ([c3639c232e](https://github.com/InsightSoftwareConsortium/ITK/commit/c3639c232e))
- Follow C++ Rule of Zero for LabelMap iterator classes ([630b6f4472](https://github.com/InsightSoftwareConsortium/ITK/commit/630b6f4472))
- Do not ignore return value of the initial GetInverseMatrix() call ([cfadfee253](https://github.com/InsightSoftwareConsortium/ITK/commit/cfadfee253))
- MatrixOffsetTransformBase take `GetInverseMatrix()` out of loops ([f8075a7e12](https://github.com/InsightSoftwareConsortium/ITK/commit/f8075a7e12))
- Remove itkSetObjectMacro if itkSetConstObjectMacro is also there ([813ddb3d52](https://github.com/InsightSoftwareConsortium/ITK/commit/813ddb3d52))
- Remove public defaulted default-constructor/destructor pairs ([a8f034dbf9](https://github.com/InsightSoftwareConsortium/ITK/commit/a8f034dbf9))
- Replace old `if` by "constexpr if" in `itk::Math` implementation ([444acec2c4](https://github.com/InsightSoftwareConsortium/ITK/commit/444acec2c4))
- Replace tuple with private GlobalObject struct, in SingletonIndex ([902d1f27d8](https://github.com/InsightSoftwareConsortium/ITK/commit/902d1f27d8))
- Use range-based `for` loop to iterate over children SpatialObject ([8bfeb9fb02](https://github.com/InsightSoftwareConsortium/ITK/commit/8bfeb9fb02))
- Add `const`to `pnt` (PointType) variables in SpatialObject ([f3e9b6dd0a](https://github.com/InsightSoftwareConsortium/ITK/commit/f3e9b6dd0a))
- Add `const` to `pos` (iterator) variables in SpatialObject ([bbeb397624](https://github.com/InsightSoftwareConsortium/ITK/commit/bbeb397624))
- Use "constexpr if" in ClampCast, before calling `Math::Round` ([6b984893fd](https://github.com/InsightSoftwareConsortium/ITK/commit/6b984893fd))
- FUTURE_LEGACY_REMOVE virtual SpatialObject InWorldSpace functions ([aa65f4b083](https://github.com/InsightSoftwareConsortium/ITK/commit/aa65f4b083))
- Replace SetSingleMethod, Execute with `SetSingleMethodAndExecute` ([436423d798](https://github.com/InsightSoftwareConsortium/ITK/commit/436423d798))
- Replace magic number SpatialObject `MaximumDepth = 9999999` ([ae081637f8](https://github.com/InsightSoftwareConsortium/ITK/commit/ae081637f8))
- Let itkFactorylessNewMacro(x) just call itkCreateAnotherMacro(x) ([fc880d4ab1](https://github.com/InsightSoftwareConsortium/ITK/commit/fc880d4ab1))
- Let itkFactorylessNewMacro directly initialize its `smartPtr` ([f70b1b1598](https://github.com/InsightSoftwareConsortium/ITK/commit/f70b1b1598))
- Let `x::CreateAnother()` just return `x::New().GetPointer()` ([848b5a4c76](https://github.com/InsightSoftwareConsortium/ITK/commit/848b5a4c76))
- Let SpatialObject directly access its m_ObjectToWorldTransform ([fa52dba3b6](https://github.com/InsightSoftwareConsortium/ITK/commit/fa52dba3b6))
- SpatialObject use `std::transform` to fill `transformedCorners` ([c516690253](https://github.com/InsightSoftwareConsortium/ITK/commit/c516690253))
- Replace MakeFilled<Self>(NumericTraits<T>::ZeroValue()) w/ Self{} ([2013902c3d](https://github.com/InsightSoftwareConsortium/ITK/commit/2013902c3d))
- Remove last argument (zero) from calls by FreeSurferAsciiMeshIO ([030d626a41](https://github.com/InsightSoftwareConsortium/ITK/commit/030d626a41))
- Replace `NumericTraits<unsigned int>::ZeroValue()` with `0U` ([5d746cc0bc](https://github.com/InsightSoftwareConsortium/ITK/commit/5d746cc0bc))
- Replace `NumericTraits<T>::ZeroValue()` with `T{}` ([13ccff6af8](https://github.com/InsightSoftwareConsortium/ITK/commit/13ccff6af8))
- Replace `expectZeroFilled` lambda's with ExpectEachElementIsZero ([b4f90bbd16](https://github.com/InsightSoftwareConsortium/ITK/commit/b4f90bbd16))
- Replace `itk::NumericTraits<unsigned int>::OneValue()` with `1` ([63b0c85990](https://github.com/InsightSoftwareConsortium/ITK/commit/63b0c85990))
- Remove duplicate `#include` directives ([ef28b0f9f5](https://github.com/InsightSoftwareConsortium/ITK/commit/ef28b0f9f5))
- Replace `if (x > f()) x = f()` with `x = std::min(x, f())` ([1b9fc82957](https://github.com/InsightSoftwareConsortium/ITK/commit/1b9fc82957))
- Replace `if (x < f()) x = f()` with `x = std::max(x, f())` ([b554b994e0](https://github.com/InsightSoftwareConsortium/ITK/commit/b554b994e0))
- Move GetStartIndex() and GetEndIndex() calls out of `for` loops ([ba1b2bd649](https://github.com/InsightSoftwareConsortium/ITK/commit/ba1b2bd649))
- Use `std::clamp` in NearestNeighborExtrapolateImageFunction ([032c7798f0](https://github.com/InsightSoftwareConsortium/ITK/commit/032c7798f0))
- Use `std::clamp` in itkZeroFluxNeumannPadImageFilterTest ([32c470a0ac](https://github.com/InsightSoftwareConsortium/ITK/commit/32c470a0ac))
- Replace `if (x > a[i]) x = a[i]` with `x = std::min(x, a[i])` ([93bef51dd1](https://github.com/InsightSoftwareConsortium/ITK/commit/93bef51dd1))
- Replace `if (x < a[i]) x = a[i]` with `x = std::max(x, a[i])` ([22d6bab560](https://github.com/InsightSoftwareConsortium/ITK/commit/22d6bab560))
- Replace `Allocate(true)` calls with `AllocateInitialized()` ([527843e9fc](https://github.com/InsightSoftwareConsortium/ITK/commit/527843e9fc))
- Remove temporary vnl_vector_ref from const GetVnlVector overloads ([3c1da644f2](https://github.com/InsightSoftwareConsortium/ITK/commit/3c1da644f2))
- Replace `PushBackInput`, `PushFrontInput` with using-declarations ([613c8f405e](https://github.com/InsightSoftwareConsortium/ITK/commit/613c8f405e))
- Let Point, RGBPixel, RGBAPixel operator== just call the BaseArray ([28f84ab956](https://github.com/InsightSoftwareConsortium/ITK/commit/28f84ab956))
- Remove `as_ref()` when calling `is_equal` on direction matrices ([69626afd8b](https://github.com/InsightSoftwareConsortium/ITK/commit/69626afd8b))
- Replace `Allocate(); FillBuffer(0)` with `AllocateInitialized()` ([cd49925a4e](https://github.com/InsightSoftwareConsortium/ITK/commit/cd49925a4e))
- Combine assignments to basei[i] in LinearInterpolateImageFunction ([b914646bbc](https://github.com/InsightSoftwareConsortium/ITK/commit/b914646bbc))
- Remove `&` from LinearInterpolateImageFunction distance variables ([876da25c17](https://github.com/InsightSoftwareConsortium/ITK/commit/876da25c17))
- Remove doxygen.config.in (superseded by DoxygenConfig.cmake) ([0c5c63890b](https://github.com/InsightSoftwareConsortium/ITK/commit/0c5c63890b))
- Remove outdated VERBOSE_DEBUGGING/RGEDEBUG support from "IO/GE" ([c9f43677eb](https://github.com/InsightSoftwareConsortium/ITK/commit/c9f43677eb))
- Remove ` == true` from Boolean expressions ([e7a60b6ca7](https://github.com/InsightSoftwareConsortium/ITK/commit/e7a60b6ca7))
- Simplify resetting `ScheduleType` objects ([110c25b3fc](https://github.com/InsightSoftwareConsortium/ITK/commit/110c25b3fc))
- Use `true` as default member initializer for m_UseImageSpacing ([ddea89f786](https://github.com/InsightSoftwareConsortium/ITK/commit/ddea89f786))
- Use `true` as default member initializer for m_UseImageDirection ([16456e1a08](https://github.com/InsightSoftwareConsortium/ITK/commit/16456e1a08))
- FUTURE_LEGACY_REMOVE ImageToImageMetric::m_InterpolatorIsBSpline ([8515928863](https://github.com/InsightSoftwareConsortium/ITK/commit/8515928863))
- FUTURE_LEGACY_REMOVE ImageToImageMetric::m_TransformIsBSpline ([2ff04804e4](https://github.com/InsightSoftwareConsortium/ITK/commit/2ff04804e4))
- Move `GetSpacing()` calls out of `for` loops ([c0ebd8e581](https://github.com/InsightSoftwareConsortium/ITK/commit/c0ebd8e581))
- Use std::unique_ptr for GradientImageFilter::m_BoundaryCondition ([db095cd630](https://github.com/InsightSoftwareConsortium/ITK/commit/db095cd630))
- Declare local `radius`, `center` variables in Filtering constexpr ([4535548a85](https://github.com/InsightSoftwareConsortium/ITK/commit/4535548a85))
- Replace "the the" with "the" in comments ([b4f0bb8a67](https://github.com/InsightSoftwareConsortium/ITK/commit/b4f0bb8a67))
- No longer set `hooks-max-size` for nifti2_io.c, doxygen.config.in ([88bfbfdc43](https://github.com/InsightSoftwareConsortium/ITK/commit/88bfbfdc43))
- Let GetInverseTransform() just call `Transform::InvertTransform` ([fb4b463b38](https://github.com/InsightSoftwareConsortium/ITK/commit/fb4b463b38))
- Replace BoundaryConditionPointerType w/ `BoundaryConditionType *` ([839955e939](https://github.com/InsightSoftwareConsortium/ITK/commit/839955e939))
- Remove unused `Superclass::BoundaryConditionPointerType` ([bb00c86f38](https://github.com/InsightSoftwareConsortium/ITK/commit/bb00c86f38))
- FUTURE_LEGACY_REMOVE BoundaryConditionPointerType type aliases ([226802f320](https://github.com/InsightSoftwareConsortium/ITK/commit/226802f320))
- Use (const) unique_ptr for `SparseFieldLayer::m_HeadNode` ([821024ae10](https://github.com/InsightSoftwareConsortium/ITK/commit/821024ae10))
- Allocate local GaussianOperator objects (`oper`) on the stack ([798675aafc](https://github.com/InsightSoftwareConsortium/ITK/commit/798675aafc))
- Use unique_ptr for MRIBiasEnergyFunction m_InternalEnergyFunction ([b7f0f1f8a3](https://github.com/InsightSoftwareConsortium/ITK/commit/b7f0f1f8a3))
- Remove `this->` when HDF5ImageIO accesses its own data ([ff17551212](https://github.com/InsightSoftwareConsortium/ITK/commit/ff17551212))
- Use unique_ptr for data members of HDF5ImageIO ([b3be83ab91](https://github.com/InsightSoftwareConsortium/ITK/commit/b3be83ab91))
- Do not declare CumulativeGaussianCostFunction data as pointer ([ed4cd5f303](https://github.com/InsightSoftwareConsortium/ITK/commit/ed4cd5f303))
- Put local matrix variables in FEM on the stack, remove new/delete ([2e1cfba4ec](https://github.com/InsightSoftwareConsortium/ITK/commit/2e1cfba4ec))
- Use (const) unique_ptr for `GiplImageIO::m_Internal` ([5969bc07c9](https://github.com/InsightSoftwareConsortium/ITK/commit/5969bc07c9))
- Remove `this->` when MINCImageIO accesses its own m_MINCPImpl ([67aadb18b3](https://github.com/InsightSoftwareConsortium/ITK/commit/67aadb18b3))
- Use (const) unique_ptr for `MINCImageIO::m_MINCPImpl` ([dc65864f45](https://github.com/InsightSoftwareConsortium/ITK/commit/dc65864f45))


### Pablo Hernandez-Cerdan (3):

#### Enhancements

- Update external eigen to upstream master ([cced7fdd66](https://github.com/InsightSoftwareConsortium/ITK/commit/cced7fdd66))

#### Style Changes

- Improve itkExternal_Eigen3.cmake ([ffbe09ba57](https://github.com/InsightSoftwareConsortium/ITK/commit/ffbe09ba57))
- Format itkExternal_Eigen3 command ([f79ec6473e](https://github.com/InsightSoftwareConsortium/ITK/commit/f79ec6473e))


### Sean McBride (3):

#### Enhancements

- added .codespellrc config file from GDCM ([8cf3707464](https://github.com/InsightSoftwareConsortium/ITK/commit/8cf3707464))
- Replaced a few remaining sprintf (comments only) ([267876bc5b](https://github.com/InsightSoftwareConsortium/ITK/commit/267876bc5b))

#### Platform Fixes

- Updated libpng symbol mangling ([7cf7ce035f](https://github.com/InsightSoftwareConsortium/ITK/commit/7cf7ce035f))


### Simon Rit (1):

#### Platform Fixes

- Fix CMake configuration for cmake versions without CMP0135 ([8d1fac474a](https://github.com/InsightSoftwareConsortium/ITK/commit/8d1fac474a))


### Stephen R. Aylward (1):

#### Enhancements

- Extend NearestNeighborInterpolateImageFunc wrapping for RGB ([bac8adfe89](https://github.com/InsightSoftwareConsortium/ITK/commit/bac8adfe89))


### Steve Pieper (1):

#### Bug Fixes

- DCMTK reader wrongly rejects file with preamble ([b04aed28b8](https://github.com/InsightSoftwareConsortium/ITK/commit/b04aed28b8))


### Thomas BAUDIER (1):

#### Performance Improvements

- Do not import torch to reduce itk import time ([963a6f426b](https://github.com/InsightSoftwareConsortium/ITK/commit/963a6f426b))


### Tom Birdsong (4):

#### Documentation Updates

- Clarify requirements installation for docs autobuild ([ddc1d2d019](https://github.com/InsightSoftwareConsortium/ITK/commit/ddc1d2d019))
- Add external module continuous integration discussion ([b05ba5ece2](https://github.com/InsightSoftwareConsortium/ITK/commit/b05ba5ece2))
- Migrate and update docs for building ITK Python wheels ([249e2d9238](https://github.com/InsightSoftwareConsortium/ITK/commit/249e2d9238))

#### Bug Fixes

- Remove `yml` tag from ITK module workflow documentation ([70a17d7b64](https://github.com/InsightSoftwareConsortium/ITK/commit/70a17d7b64))


### VXL Maintainers (1):

#### Miscellaneous Changes

- VXL 2023-11-01 (6456d120) ([85daed4d9f](https://github.com/InsightSoftwareConsortium/ITK/commit/85daed4d9f))


### Vladimir S. FONOV (2):

#### Miscellaneous Changes

- MINC 2023-11-14 (15d994de) ([c3952a86fc](https://github.com/InsightSoftwareConsortium/ITK/commit/c3952a86fc))
- MINC 2024-04-03 (a608a1bc) ([930156dd05](https://github.com/InsightSoftwareConsortium/ITK/commit/930156dd05))


### Ziv Yaniv (2):

#### Documentation Updates

- Adding pointer to SimpleITK in the ecosystem. ([4d322d8cf1](https://github.com/InsightSoftwareConsortium/ITK/commit/4d322d8cf1))

#### Bug Fixes

- Missing modality tag when reading meta-image format. ([ac3870efec](https://github.com/InsightSoftwareConsortium/ITK/commit/ac3870efec))


### Zlib-ng Upstream (2):

#### Miscellaneous Changes

- zlib-ng 2023-12-29 (fd5b20f4) ([8828612a49](https://github.com/InsightSoftwareConsortium/ITK/commit/8828612a49))
- zlib-ng 2024-01-10 (74253725) ([2ce4e124e7](https://github.com/InsightSoftwareConsortium/ITK/commit/2ce4e124e7))


### pygccxml Upstream (1):

#### Enhancements

- pygccxml v2.5.0 (reduced) ([b39a0bbb81](https://github.com/InsightSoftwareConsortium/ITK/commit/b39a0bbb81))




ITK Sphinx Examples Changes Since v5.4rc02
---------------------------------------------

### Matt McCormick (4):

#### Enhancements

- Bump ITK to 5.4 Release Candidate 2 ([e404022a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e404022a))
- Add PASS_REGULAR_EXPRESION to ConvertImageWithLabelsToShapeLabelMap ([84fb315d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/84fb315d))
- Bump ITK to 5.4 Release Candidate 3 ([7b882462](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7b882462))

#### Bug Fixes

- Disable ConvertImageWithLabelsToShapeLabelMapTest on Windows ([db481ba1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/db481ba1))




ITK Software Guide Changes Since v5.4rc02
---------------------------------------------

### Matt McCormick (5):

#### Enhancements

- Bump ITK Superbuild version to 5.4 RC 2 ([3b541a4](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/3b541a4))
- Bump ITK Superbuild version to 5.4 RC 3 ([cce6623](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/cce6623))
- Bump ITK Superbuild version to 5.4 RC 4 ([f37b396](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f37b396))
- Improve Actions PDF artifact name ([dd86548](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/dd86548))

#### Platform Fixes

- Bump actions versions ([7af04df](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7af04df))


### Niels Dekker (1):

#### Documentation Updates

- Replace `itkTypeMacro` with `itkOverrideGetNameOfClassMacro` ([5428594](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5428594))




Remote Module Changes Since v5.4rc02
---------------------------------------------


## Cleaver:
### dependabot[bot] (1):

#### Platform Fixes

- Bump actions/checkout from 3.5.2 to 3.5.3 ([a600444](https://github.com/SCIInstitute/ITKCleaver/commit/a600444))


## CudaCommon:
### LAURENDEAU Matthieu (1):

#### Bug Fixes

- Remove CudaContextManager class and use cudaSetDevice ([09a9645](https://github.com/RTKConsortium/ITKCudaCommon/commit/09a9645))


### Simon Rit (9):

#### Enhancements

- Upgrade CI to ITK v5.4rc01 ([4b362ac](https://github.com/RTKConsortium/ITKCudaCommon/commit/4b362ac))
- Upgrade CUDA packaging CI to ITK v5.4rc2 ([daf8676](https://github.com/RTKConsortium/ITKCudaCommon/commit/daf8676))

#### Documentation Updates

- Convert README to markdown ([bd8871e](https://github.com/RTKConsortium/ITKCudaCommon/commit/bd8871e))

#### Platform Fixes

- Fix new file name for README in itk-module.cmake ([c79cfc5](https://github.com/RTKConsortium/ITKCudaCommon/commit/c79cfc5))
- Add missing Python wrapping of ImageToImageFilter for CudaImage ([9d3fe9b](https://github.com/RTKConsortium/ITKCudaCommon/commit/9d3fe9b))

#### Bug Fixes

- Use older manylinux image with GCC 11 for Cuda 11.6 ([24266b1](https://github.com/RTKConsortium/ITKCudaCommon/commit/24266b1))
- Use newer CI packaging to exclude libraries ([0c20c4e](https://github.com/RTKConsortium/ITKCudaCommon/commit/0c20c4e))

#### Style Changes

- Replace itkTypeMacro calls with `itkOverrideGetNameOfClassMacro` ([dcc3401](https://github.com/RTKConsortium/ITKCudaCommon/commit/dcc3401))

#### Miscellaneous Changes

- Release of ITKCudaCommon v1.0.1 ([7073f37](https://github.com/RTKConsortium/ITKCudaCommon/commit/7073f37))


## GenericLabelInterpolator:
### Tom Birdsong (1):

#### Enhancements

- Bump for ITK v5.4rc02 ([257f4e8](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/257f4e8))



## GrowCut:
### Jon Haitz Legarreta Gorroño (1):

#### Platform Fixes

- Comment unused variable ([857bb0b](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/857bb0b))


### Tom Birdsong (3):

#### Enhancements

- Bump to v0.2.0 for ITK v5.3.0 ([0795886](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/0795886))
- Move to GitHub Actions ITK reusable workflow ([74e3561](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/74e3561))
- Bump to v0.2.1 for ITK v5.4rc2 ([1b2d1a2](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/1b2d1a2))


## HigherOrderAccurateGradient:
### Dženan Zukić (1):

#### Enhancements

- Bump minimum CMake version to 3.16.3 ([692f6b7](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/692f6b7))


## IOScanco:
### Matt McCormick (20):

#### Enhancements

- App initial import import from @itk-wasm/compress-stringify test ([a288ef2](https://github.com/KitwareMedical/ITKIOScanco/commit/a288ef2))
- App logo ([240f671](https://github.com/KitwareMedical/ITKIOScanco/commit/240f671))
- App title ([191a2e4](https://github.com/KitwareMedical/ITKIOScanco/commit/191a2e4))
- App output format options ([811ea48](https://github.com/KitwareMedical/ITKIOScanco/commit/811ea48))
- App check for input volume ([4638272](https://github.com/KitwareMedical/ITKIOScanco/commit/4638272))
- Download app sample data during build ([d0e19cd](https://github.com/KitwareMedical/ITKIOScanco/commit/d0e19cd))
- App conversion load sample inputs ([d4ed17e](https://github.com/KitwareMedical/ITKIOScanco/commit/d4ed17e))
- Display output image metadata ([55da53c](https://github.com/KitwareMedical/ITKIOScanco/commit/55da53c))
- App download output ([d1d98b8](https://github.com/KitwareMedical/ITKIOScanco/commit/d1d98b8))
- Bump itk-wasm to 1.0.0-b.132 ([1ebb742](https://github.com/KitwareMedical/ITKIOScanco/commit/1ebb742))
- App UI tweaks ([8daa8d5](https://github.com/KitwareMedical/ITKIOScanco/commit/8daa8d5))

#### Performance Improvements

- Update to @itk-wasm/image-io ([76c2414](https://github.com/KitwareMedical/ITKIOScanco/commit/76c2414))

#### Documentation Updates

- Add link to ORMIR ([c5eae32](https://github.com/KitwareMedical/ITKIOScanco/commit/c5eae32))
- Update app GitHub link to the repository ([6f26bd5](https://github.com/KitwareMedical/ITKIOScanco/commit/6f26bd5))
- Add tooltip on load sample input overwrite ([69cfd64](https://github.com/KitwareMedical/ITKIOScanco/commit/69cfd64))

#### Bug Fixes

- Fix imports of utilities in build output ([fc0ff9a](https://github.com/KitwareMedical/ITKIOScanco/commit/fc0ff9a))
- Remove old controller files ([e72b860](https://github.com/KitwareMedical/ITKIOScanco/commit/e72b860))
- Use network resource for sample data with production builds ([186bc96](https://github.com/KitwareMedical/ITKIOScanco/commit/186bc96))
- Fix sample data URL ([de2669d](https://github.com/KitwareMedical/ITKIOScanco/commit/de2669d))

#### Style Changes

- App button name tweaks ([7bd0c8a](https://github.com/KitwareMedical/ITKIOScanco/commit/7bd0c8a))


### dependabot[bot] (2):

#### Miscellaneous Changes

- Bump vite from 4.3.3 to 4.3.9 in /app ([7eafb95](https://github.com/KitwareMedical/ITKIOScanco/commit/7eafb95))
- Bump postcss from 8.4.27 to 8.4.31 in /app ([aaaee97](https://github.com/KitwareMedical/ITKIOScanco/commit/aaaee97))

## IsotropicWavelets:
### Matt McCormick (1):

#### Enhancements

- Update CI for reusable workflow, ITK 5.3.0 ([c926404](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/c926404))


### Sadhana Ravikumar (1):

#### Miscellaneous Changes

- Update README.rst ([abb7a6c](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/abb7a6c))


## MGHIO:
### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Add target to package build, test status badge ([e3226d9](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/e3226d9))

#### Bug Fixes

- Use the literal superclass name in itkTypeMacro ([5bb20b7](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/5bb20b7))


### Matt McCormick (1):

#### Enhancements

- Update CI to the remote module GitHub Action ([aec9dc7](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/aec9dc7))



## MeshToPolyData:
### Matt McCormick (18):

#### Enhancements

- Bump ITK version to 5.4 rc 1 ([5249698](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/5249698))
- Add wasm binding generation configuration ([e03f4f6](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/e03f4f6))
- Add node mesh-to-poly-data-test ([32ddf7d](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/32ddf7d))
- Add test_mesh_to_poly_data.py ([366d632](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/366d632))
- Add test_itkwasm_mesh_to_poly_data_async.py ([8e22066](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/8e22066))
- Add tests for itkwasm-mesh-to-poly-data python package ([cda516f](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/cda516f))
- Add pyproject.toml configurations ([0c96442](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/0c96442))
- Test typescript bindings in CI ([bc03309](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/bc03309))
- Add Wasm Python package CI testing ([e860aad](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/e860aad))
- Update package.json configuration to use itk-wasm pnpm-script ([5d88356](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/5d88356))
- Update Wasm CI configuration ([2bc68c1](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/2bc68c1))
- Build, deploy wasm documentation to GitHub Pages ([bdbb6f9](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/bdbb6f9))

#### Documentation Updates

- Correct base url to ITKMeshToPolyData ([2820496](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/2820496))
- Add WebAssembly and Documentation CI badges ([291a2c0](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/291a2c0))

#### Bug Fixes

- Update itkwasm-mesh-to-poly-data hatch test config ([2211d9e](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/2211d9e))
- Download pyodide before running tests ([912bc71](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/912bc71))
- Free up disk space for wasm CI runs ([5a156e4](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/5a156e4))

#### Miscellaneous Changes

- chore: bump package version to 1.0.0 ([0dc2522](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/0dc2522))




## Montage:
### Dženan Zukić (2):

#### Enhancements

- Update CI action ([4c7e5cd](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4c7e5cd))

#### Platform Fixes

- Fix HyperSphereImageSource class name in type macro (was Image) ([0825e46](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/0825e46))



## MorphologicalContourInterpolation:
### Matt McCormick (4):

#### Enhancements

- Add wasm configuration ([55ba23b](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/55ba23b))

#### Documentation Updates

- Update javascript API and add app, docs links ([c343d90](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/c343d90))
- Convert README to markdown, add wasm links ([115755f](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/115755f))

#### Style Changes

- Apply clang-format to morphological-contour-interpolation.cxx ([97645a6](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/97645a6))





## RLEImage:
### Matt McCormick (2):

#### Platform Fixes

- Uninitialized in GetNumberOfComponentsPerPixel ([5ce8cd1](https://github.com/KitwareMedical/ITKRLEImage/commit/5ce8cd1))
- Add compiler deduction guides RLEImage ImageScanlineConstIterator ([85559c9](https://github.com/KitwareMedical/ITKRLEImage/commit/85559c9))


### Stephen R. Aylward (1):

#### Enhancements

- Bump to ITKv5.4rc02. ([a3bdf29](https://github.com/KitwareMedical/ITKRLEImage/commit/a3bdf29))



## RTK:
### Antoine Robert (4):

#### Enhancements

- Add superior and inferior clip images for Joseph-based forward projector ([2a560d36](https://github.com/RTKConsortium/RTK/commit/2a560d36))
- Add new inputs for the iterative reconstruction filters ([2ab79c12](https://github.com/RTKConsortium/RTK/commit/2ab79c12))
- Step size accessors for Cuda ray tracing in iterative recon ([0a84555d](https://github.com/RTKConsortium/RTK/commit/0a84555d))
- add flag in rtkosem application to store the normalization images ([efdc4e14](https://github.com/RTKConsortium/RTK/commit/efdc4e14))


### Mikhail Polkovnikov (1):

#### Enhancements

- MIP image filter for DRR image calculation ([081e0178](https://github.com/RTKConsortium/RTK/commit/081e0178))


### Simon Rit (24):

#### Enhancements

- Add Cuda wrapping of Parker, scatter glare and ramp filters ([777b75a3](https://github.com/RTKConsortium/RTK/commit/777b75a3))
- Add Python command line tool for conjugate gradient ([07bcb369](https://github.com/RTKConsortium/RTK/commit/07bcb369))
- Made weights of weighted least squares optional in conjugate gradient ([f17a8ad2](https://github.com/RTKConsortium/RTK/commit/f17a8ad2))
- Add local weights map for conjugate gradient regularization ([8994dfe3](https://github.com/RTKConsortium/RTK/commit/8994dfe3))
- Allow compilation of CPU TV filter with RTK_USE_CUDA ON ([91fd0561](https://github.com/RTKConsortium/RTK/commit/91fd0561))
- Python wrapping of FourDROOSTERConeBeamReconstructionFilter ([17eab6d8](https://github.com/RTKConsortium/RTK/commit/17eab6d8))

#### Performance Improvements

- Use std::move inside itkSetMacro, declare parameter non-const ([d78d7778](https://github.com/RTKConsortium/RTK/commit/d78d7778))

#### Documentation Updates

- Clarify the applicability of projector options ([2f0e76a6](https://github.com/RTKConsortium/RTK/commit/2f0e76a6))

#### Platform Fixes

- Fix Windows compilations in non-CUDA CI ([ef740ffe](https://github.com/RTKConsortium/RTK/commit/ef740ffe))
- Move call to wrap_itk_python_bindings_install for in ITK config ([6109465c](https://github.com/RTKConsortium/RTK/commit/6109465c))
- Fix unknown class names in itkOverrideGetNameOfClassMacro ([95234d6a](https://github.com/RTKConsortium/RTK/commit/95234d6a))
- Remove inclusion of .hxx files as headers ([4badeef8](https://github.com/RTKConsortium/RTK/commit/4badeef8))
- Remove unitialized variable warning ([cd42bf3d](https://github.com/RTKConsortium/RTK/commit/cd42bf3d))
- Fix Python module compilation with default options ([0cc66399](https://github.com/RTKConsortium/RTK/commit/0cc66399))
- Fix Python redefinition warnings with default options ([c32c1e98](https://github.com/RTKConsortium/RTK/commit/c32c1e98))
- Upgrade GitHub actions for building wheels against ITK v5.4rc02 ([52c5d9ff](https://github.com/RTKConsortium/RTK/commit/52c5d9ff))
- Fix locally defined but not used warning ([0f7f84b7](https://github.com/RTKConsortium/RTK/commit/0f7f84b7))

#### Bug Fixes

- Fix Python wrappings warnings ([13aa42c4](https://github.com/RTKConsortium/RTK/commit/13aa42c4))
- Remove unused config option in rtksimulatedgeometry.py ([80f36682](https://github.com/RTKConsortium/RTK/commit/80f36682))
- Fix above array bounds access of image size in rtkamsterdamshroud ([6ddf14bf](https://github.com/RTKConsortium/RTK/commit/6ddf14bf))

#### Style Changes

- Rename template parameters according to ITK style ([deb0f0c8](https://github.com/RTKConsortium/RTK/commit/deb0f0c8))
- Replace itkTypeMacro calls with `itkOverrideGetNameOfClassMacro` ([eb90fb42](https://github.com/RTKConsortium/RTK/commit/eb90fb42))
- Replace additional itkTypeMacro calls with `itkOverrideGetNameOfClassMacro` ([65f0b66f](https://github.com/RTKConsortium/RTK/commit/65f0b66f))

#### Miscellaneous Changes

- Release of RTK v2.5.0 ([0f218d3c](https://github.com/RTKConsortium/RTK/commit/0f218d3c))


## SplitComponents:
### Matt McCormick (1):

#### Enhancements

- Bump build for ITK 5.4 RC 1 ([7cd30ea](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/7cd30ea))



## Strain:
### Dženan Zukić (2):

#### Enhancements

- Bump minimum CMake version to 3.16.3 ([4fff22b](https://github.com/KitwareMedical/ITKStrain/commit/4fff22b))
- Use https for submitting dashboard builds ([3cd298d](https://github.com/KitwareMedical/ITKStrain/commit/3cd298d))


## TotalVariation:
### Bryn Lloyd (1):

#### Enhancements

- bump itk version, use ITK github actions ([0bd90b9](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/0bd90b9))



## TubeTK:
### Matt McCormick (2):

#### Enhancements

- Bump itk-wasm for builds to 1.0.0-b.130 ([57f4a4c2](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/57f4a4c2))

#### Bug Fixes

- Free up disk space for wasm CI build ([3cd6bef6](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3cd6bef6))


### Stephen Aylward (2):

#### Enhancements

- Release v1.3.6 ([b3c3dd6a](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b3c3dd6a))

#### Bug Fixes

- ComputeTrainingMask preserve image info.  TubeExtractor count. ([73253995](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/73253995))


### Stephen R. Aylward (8):

#### Enhancements

- Replace incorrectly deleted MinimalPathExtractionExport.h (#142) ([8de02fed](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8de02fed))
- Bump to latest release of VTK and head of IPP (#147) ([56ccb9ea](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/56ccb9ea))
- Remove dependencies on VTK and simplify build-test-deploy process (#149) ([1dc871df](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/1dc871df))
- Update CI process to match ITK cookiecutter style, for better coverage of platforms (#152) ([0b68ed12](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/0b68ed12))

#### Bug Fixes

- update wasm build scripts (#146) ([414112ef](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/414112ef))
- Remove support for ARM/aarch64 and ENH: add support for caching CI VTK builds (#144) ([14b57785](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/14b57785))
- Building tests fails on github workflow machines (#153) ([454586b5](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/454586b5))

#### Miscellaneous Changes

- * ENH: Bump to latest release of VTK and disable IOSS compilation ([3ad175e0](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3ad175e0))


## Ultrasound:
### Dženan Zukić (12):

#### Enhancements

- Add wrapping for PhasedArray3DSpecialCoordinatesImage and filters ([8808f7a](https://github.com/KitwareMedical/ITKUltrasound/commit/8808f7a))
- Add Python tests for PhasedArray3DSpecialCoordinatesImage ([43179d3](https://github.com/KitwareMedical/ITKUltrasound/commit/43179d3))
- Bump version number to 0.6.2 ([6f6fc8f](https://github.com/KitwareMedical/ITKUltrasound/commit/6f6fc8f))
- Wrap IO factory for use from Python ([63fd45b](https://github.com/KitwareMedical/ITKUltrasound/commit/63fd45b))
- Add wrapping for itk::UltrasoundImageFileReader ([8bacc3d](https://github.com/KitwareMedical/ITKUltrasound/commit/8bacc3d))
- reorganize to ease removal of PhasedArray3DSpecialCoordinatesImage ([11b0ec8](https://github.com/KitwareMedical/ITKUltrasound/commit/11b0ec8))
- Add SSSCI wrapping with Python test and baseline ([637c0e7](https://github.com/KitwareMedical/ITKUltrasound/commit/637c0e7))
- Bump version number to 0.6.3 ([b351ac1](https://github.com/KitwareMedical/ITKUltrasound/commit/b351ac1))

#### Documentation Updates

- Correct itkCurvilinearArraySpecialCoordinatesImageFilters.wrap ([f5cc8f8](https://github.com/KitwareMedical/ITKUltrasound/commit/f5cc8f8))

#### Platform Fixes

- Fix warning C4834: discarding return value ([ce02933](https://github.com/KitwareMedical/ITKUltrasound/commit/ce02933))
- Fix warning C4834: discarding return value of function ([027b982](https://github.com/KitwareMedical/ITKUltrasound/commit/027b982))

#### Bug Fixes

- Fix a copy-paste bug in Python unit test ([6628586](https://github.com/KitwareMedical/ITKUltrasound/commit/6628586))


## WebAssemblyInterface:

**Many**. Removed for size constraints.
