# ITK 5.4.3 Release Notes

We are pleased to announce the release of [ITK 5.4.3](https://docs.itk.org), the latest maintenance update for this cross-platform, open-source toolkit supporting N-dimensional scientific image analysis with spatially-aware algorithms. 🎉 🍻 🥳 This patch release addresses several key issues identified since ITK 5.4.2 while maintaining API stability.

🔦 Highlights
-------------

As a maintenance update following 5.4.2, version 5.4.3 incorporates critical improvements including:

- **Bug Fixes**: Resolved issues affecting the default number of threads, particularly in multi-threaded image processing pipelines where thread limits were not respected, and corrected the b-spline size calculation for closed parametric dimensions, ensuring accurate interpolation in applications such as 3D image registration and deformation modeling.
- **License Fixes**: Removed unused VNL Netlib rpoly files to ensure compliance with our Apache 2.0 licensing requirements.
- **Software Guide Updates**: Spelling corrections for the [ITK Software Guide](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/releases).
- **Doxygen Documentation**: Updated Doxygen documentation to reflect the [latest changes and improvements in ITK](https://docs.itk.org/en/latest/releases/5.4.0.html), including links to the [ReadTheDocs site](https://docs.itk.org/projects/doxygen/).
- **Remote Module Updates**: Improvements to the [`LabelErodeDilate`](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate) and [`MeshToPolyData`](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData) remote modules, including bug fixes and enhancements.

A full list of changes can be found in the changelog below.

🔢 Versioning Note
------------------

For comprehensive details on ITK 5.4.0, please review the [ITK 5.4.0 Release Notes](https://docs.itk.org/en/latest/releases/5.4.0.html).

💾 Download
-----------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```bash
pip install itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4.3.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightSoftwareGuide-Book1-5.4.3.pdf)
- [InsightSoftwareGuide-Book2-5.4.3.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightSoftwareGuide-Book2-5.4.3.pdf)

**Library Sources**

- [InsightToolkit-5.4.3.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightToolkit-5.4.3.tar.gz)
- [InsightToolkit-5.4.3.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightToolkit-5.4.3.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4.3.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightData-5.4.3.tar.gz)
- [InsightData-5.4.3.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightData-5.4.3.zip)

**Checksums and Signatures**

- [InsightToolkit-5.4.3.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightToolkit-5.4.3.tar.gz.asc)
- [InsightToolkit-5.4.3.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightToolkit-5.4.3.zip.asc)

- [InsightData-5.4.3.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightData-5.4.3.tar.gz.asc)
- [InsightData-5.4.3.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/InsightData-5.4.3.zip.asc)

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.3/SHA512SUMS)

🙏 Congratulations
------------------

Congratulations and **thank you** to everyone who contributed to this release.

🗣️ What's Next
---------------

**ITK 6 Preparation**

The development community is currently focused on delivering **ITK 6**, a major modernization release featuring:

- Architectural upgrades for contemporary C++ development
- Enhanced template metaprogramming capabilities
- Streamlined build system configurations

Early access builds (alpha/beta releases) will become available during ongoing 5.4.x maintenance, enabling parallel evaluation of new features while maintaining production stability.

**5.4 Maintenance Commitment**

We remain dedicated to supporting current users through:

- Regular security and regression patches
- Critical bug resolution
- Platform compatibility updates

**Enjoy ITK!**

ITK Changes Since v5.4.2
------------------------

### Bradley Lowekamp (2):

#### Enhancements

- Use get_schedaffin to determine number of threads ([50ab3e0f6e](https://github.com/InsightSoftwareConsortium/ITK/commit/50ab3e0f6e))

#### Bug Fixes

- Update LabelErodeDilate remote module ([ea1ee3a961](https://github.com/InsightSoftwareConsortium/ITK/commit/ea1ee3a961))


### Dženan Zukić (1):

#### Documentation Updates

- Remove duplicate new author name (Matthieu LAURENDEAU) ([6d82d2bd8f](https://github.com/InsightSoftwareConsortium/ITK/commit/6d82d2bd8f))


### Matthew McCormick (10):

#### Enhancements

- Bump ITK version to 5.4.3 ([0913f2a962](https://github.com/InsightSoftwareConsortium/ITK/commit/0913f2a962))

#### Documentation Updates

- Update maintenance branch for 5.4 series ([146bc6de06](https://github.com/InsightSoftwareConsortium/ITK/commit/146bc6de06))
- Point to RTD Doxygen documentation, ITKDoxygen Docker build ([8ba1cfc8f2](https://github.com/InsightSoftwareConsortium/ITK/commit/8ba1cfc8f2))
- Update Doxygen class links to use ReadTheDocs ([d3189c245e](https://github.com/InsightSoftwareConsortium/ITK/commit/d3189c245e))
- Update versioned Doxygen links to point to ReadTheDocs ([ce4fa184e8](https://github.com/InsightSoftwareConsortium/ITK/commit/ce4fa184e8))
- ITK 5.4.0 release notes ([f2852f6ee9](https://github.com/InsightSoftwareConsortium/ITK/commit/f2852f6ee9))
- Add ITK 5.4.2 release notes ([f817e2f775](https://github.com/InsightSoftwareConsortium/ITK/commit/f817e2f775))

#### Platform Fixes

- Bump MeshToPolyData Remote Module to 2024-03-14 main ([7366509c1c](https://github.com/InsightSoftwareConsortium/ITK/commit/7366509c1c))

#### Bug Fixes

- Remove VNL Netlib rpoly files ([6894a1715c](https://github.com/InsightSoftwareConsortium/ITK/commit/6894a1715c))
- Clamp GlobalDefault threads with GlobalMaximum with initialization ([7e485eac71](https://github.com/InsightSoftwareConsortium/ITK/commit/7e485eac71))


### Simon Rit (1):

#### Bug Fixes

- Remove check on WrapITK.pth existence in itk_python_add_test ([71d5cce482](https://github.com/InsightSoftwareConsortium/ITK/commit/71d5cce482))


### Nick Tustison (1):

#### Bug Fixes

- Incorrect size for closed parametric dimension. ([0dd02ac9f1](https://github.com/InsightSoftwareConsortium/ITK/commit/0dd02ac9f1))


ITK Software Guide Changes Since v5.4.2
---------------------------------------

### Matthew McCormick (1):

#### Enhancements

- Bump ITK to v5.4.3 ([0db3df8](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/0db3df8))

### albert-github (1):

#### Documentation Updates

- Spelling corrections ([5849c78](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5849c78))




Remote Module Changes Since v5.4.2
---------------------------------------------

## LabelErodeDilate:
### Bradley Lowekamp (4):

#### Bug Fixes

- Addressed memory leak of progress object ([05a0a1c](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/05a0a1c))
- Address uninitialized value ([921aaab](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/921aaab))
- Fix Valgrind defect with uninitialized array in doOneDimensionErode ([b9567df](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/b9567df))

#### Miscellaneous Changes

- Update CI infrastructure to use 5.4.2 infrastructure ([c9f9037](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/c9f9037))


### Hans Johnson (4):

#### Enhancements

- Update to support the clang-format-linter CI ([b25c27e](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/b25c27e))
- Update to use local error message. ([22d8846](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/22d8846))

#### Style Changes

- Add itkVirtualGetNameOfClassMacro + itkOverrideGetNameOfClassMacro ([6a892cd](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/6a892cd))
- Update to match clang-format-19 from ITK ([32e7773](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/32e7773))


### Jon Haitz Legarreta Gorroño (12):

#### Enhancements

- Transition project configuration to `pyproject.toml` ([8197f14](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/8197f14))
- Initialize all arrays in `LabelSetUtils.h` file ([108b0ba](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/108b0ba))

#### Platform Fixes

- Bump to minimum CMake 3.16.3 ([f247673](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/f247673))

#### Style Changes

- Conform to ITK style guidelines in local variable naming ([61c7a93](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/61c7a93))
- Do no use `m_` to start function parameter names ([c347f23](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/c347f23))
- Use medial capitals for variable naming in C++ code ([518fab1](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/518fab1))
- Use `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([5f37494](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/5f37494))
- Make the input argument checking be the first task in tests ([1a5febf](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/1a5febf))
- Conform to ITK style guidelines in test arg check ([7f9ffc7](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/7f9ffc7))
- Remove unnecessary brackets around `EXIT_FAILURE` ([02de4bd](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/02de4bd))
- Remove unreachable `break` after `return` statement ([0fbfa1c](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/0fbfa1c))
- Remove unnecessary/empty comment statements in tests ([276b195](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/276b195))



## MeshToPolyData:
### Dženan Zukić (1):

#### Platform Fixes

- ITK_DISALLOW_COPY_AND_ASSIGN -> ITK_DISALLOW_COPY_AND_MOVE ([b866a68](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/b866a68))


### Hans Johnson (7):

#### Enhancements

- Use latest actions, do not pin to latest version ([8aed3c7](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/8aed3c7))
- Use tag v5.4.2 for the build packages tags ([9c0209b](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/9c0209b))

#### Style Changes

- Add itkVirtualGetNameOfClassMacro + itkOverrideGetNameOfClassMacro ([c3c0006](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/c3c0006))
- Replace itkStaticConstMacro with static constexpr ([86435bd](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/86435bd))
- CoordRepType -> CoordinateType code readability ([d90e542](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/d90e542))
- Update to match clang-format-19 from ITK ([6aa2abf](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/6aa2abf))
- Fix KWStyleError ([597c780](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/597c780))


### Jon Haitz Legarreta Gorroño (1):

#### Platform Fixes

- Bump to minimum CMake 3.16.3 ([97c575f](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/97c575f))


### Matt McCormick (12):

#### Enhancements

- Bump itk-wasm to 1.0.0-b.173 ([08779a7](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/08779a7))
- Bump itk-wasm version to 1.0.0-b.175 ([254a24d](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/254a24d))
- Add VTK C++ conversion example ([8153ecc](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/8153ecc))
- Update ITK to 5.4.0 ([4ce9813](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/4ce9813))
- Bump wasm package version to 1.1.1 ([a9d1fd7](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/a9d1fd7))
- Bump pnpm to 10.6.2 ([bd893e4](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/bd893e4))
- Update pyproject.toml for 0.11.1 ([8941ee1](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/8941ee1))

#### Documentation Updates

- Lines to Vertices in method description ([ff3cc60](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/ff3cc60))

#### Platform Fixes

- Provide backwards compatible CoordRepType in itk::PolyData ([c9e0aba](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/c9e0aba))
- Update wasm for ITK 5.4.2 ([1c2a0b5](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/1c2a0b5))

#### Bug Fixes

- Update Python package version to 0.11.0 ([5e8de5d](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/5e8de5d))
- Support Variable-Length-Vector in mesh-to-polydata ([e9b30dc](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/e9b30dc))

### dependabot[bot] (2):

#### Miscellaneous Changes

- Bump vite from 4.5.3 to 4.5.6 ([02b88a3](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/02b88a3))
- Bump esbuild from 0.19.12 to 0.25.0 ([edf43cb](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/edf43cb))
