#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 BetaRays <array@dotslashplay.it>
set -o errexit

###
# The Planet Crafter expansions:
# - Planet Humble
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250530.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-planet-crafter'
GAME_NAME='The Planet Crafter'

EXPANSION_ID_PLANETHUMBLE='planet-humble'
EXPANSION_NAME_PLANETHUMBLE='Planet Humble'

# Archives

## Planet Humble

ARCHIVE_BASE_PLANETHUMBLE_1_NAME='setup_the_planet_crafter_-_planet_humble_v1.518.1_(82237).exe'
ARCHIVE_BASE_PLANETHUMBLE_1_MD5='a09c262a769432eb8f0515f9a3bb441d'
ARCHIVE_BASE_PLANETHUMBLE_1_SIZE='7812'
ARCHIVE_BASE_PLANETHUMBLE_1_VERSION='1.518-gog82237'
ARCHIVE_BASE_PLANETHUMBLE_1_URL='https://www.gog.com/game/the_planet_crafter_planet_humble'

ARCHIVE_BASE_PLANETHUMBLE_0_NAME='setup_the_planet_crafter_-_planet_humble_v1.410_(79912).exe'
ARCHIVE_BASE_PLANETHUMBLE_0_MD5='a64fff4691566255f6b01021b4d56705'
ARCHIVE_BASE_PLANETHUMBLE_0_SIZE='6856'
ARCHIVE_BASE_PLANETHUMBLE_0_VERSION='1.410-gog79912'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
goggame-*.info'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
