/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPool;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;

final class JavaThreadPoolFactory {
    private static final WeakHashMap threadIdMap = new WeakHashMap();
    private final HashMap jobQueues = new HashMap();

    public IThreadPool createThreadPool() {
        return new JavaThreadPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobQueue(JobQueue jobQueue) {
        HashMap hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.put(jobQueue.getThreadId(), jobQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobQueue(JobQueue jobQueue) {
        HashMap hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.remove(jobQueue.getThreadId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobQueue getJobQueue(ThreadId threadId) {
        HashMap hashMap = this.jobQueues;
        synchronized (hashMap) {
            return (JobQueue)this.jobQueues.get(threadId);
        }
    }

    public JobQueue getAsyncJobQueue(ThreadId threadId) {
        JobQueue jobQueue = this.getJobQueue(threadId);
        return jobQueue == null ? null : jobQueue._async_jobQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Object object, Throwable throwable) {
        JobQueue[] jobQueueArray;
        HashMap hashMap = this.jobQueues;
        synchronized (hashMap) {
            Collection collection = this.jobQueues.values();
            jobQueueArray = collection.toArray(new JobQueue[collection.size()]);
        }
        for (int i = 0; i < jobQueueArray.length; ++i) {
            jobQueueArray[i].dispose(object, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadId getThreadId() {
        ThreadId threadId;
        Thread thread = Thread.currentThread();
        if (thread instanceof JobQueue.JobDispatcher) {
            return ((JobQueue.JobDispatcher)thread).getThreadId();
        }
        WeakHashMap weakHashMap = threadIdMap;
        synchronized (weakHashMap) {
            threadId = (ThreadId)threadIdMap.get(thread);
            if (threadId == null) {
                threadId = ThreadId.createFresh();
                threadIdMap.put(thread, threadId);
            }
        }
        return threadId;
    }
}

