/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemmer;

public final class GermanStemFilter
extends TokenFilter {
    private Token token = null;
    private GermanStemmer stemmer = new GermanStemmer();
    private Set exclusionSet = null;

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    public GermanStemFilter(TokenStream in, Set exclusionSet) {
        this(in);
        this.exclusionSet = exclusionSet;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusionSet != null && this.exclusionSet.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionSet(Set exclusionSet) {
        this.exclusionSet = exclusionSet;
    }
}

