/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.BitSet;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;

public class NormalizerData {
    static final String copyright = "Copyright \u00a9 1998-1999 Unicode, Inc.";
    public static final int NOT_COMPOSITE = 65535;
    private IntToIntHashMap canonicalClass;
    private IntHashMap decompose;
    private IntToIntHashMap compose;
    private BitSet isCompatibility = new BitSet();
    private BitSet isExcluded = new BitSet();

    public int getCanonicalClass(int ch) {
        return this.canonicalClass.get(ch);
    }

    public char getPairwiseComposition(int first, int second) {
        if (first < 0 || first > 0x10FFFF || second < 0 || second > 0x10FFFF) {
            return '\uffff';
        }
        return (char)this.compose.get(first << 16 | second);
    }

    public void getRecursiveDecomposition(boolean canonical, int ch, StringBuffer buffer) {
        String decomp = (String)this.decompose.get(ch);
        if (!(decomp == null || canonical && this.isCompatibility.get(ch))) {
            for (int i = 0; i < decomp.length(); ++i) {
                this.getRecursiveDecomposition(canonical, decomp.charAt(i), buffer);
            }
        } else if (ch < 65536) {
            buffer.append((char)ch);
        } else {
            buffer.append(UTF16.highSurrogate(ch));
            buffer.append(UTF16.lowSurrogate(ch));
        }
    }

    NormalizerData(IntToIntHashMap canonicalClass, IntHashMap decompose, IntToIntHashMap compose, BitSet isCompatibility, BitSet isExcluded) {
        this.canonicalClass = canonicalClass;
        this.decompose = decompose;
        this.compose = compose;
        this.isCompatibility = isCompatibility;
        this.isExcluded = isExcluded;
    }

    boolean getExcluded(char ch) {
        return this.isExcluded.get(ch);
    }

    String getRawDecompositionMapping(char ch) {
        return (String)this.decompose.get(ch);
    }
}

