# -*- perl -*-
BEGIN
{
    use strict;
    use warnings;
    use Cwd qw( abs_path );
    use lib abs_path( './lib' );
    use vars qw( $DEBUG );
    use Test::More qw( no_plan );
    our $DEBUG = exists( $ENV{AUTHOR_TESTING} ) ? $ENV{AUTHOR_TESTING} : 0;
};

use strict;
use warnings;

BEGIN
{
    use_ok( 'Module::Generic' ) || BAIL_OUT( 'Cannot load Module::Generic' );
};

# for sub in `egrep -E '^sub ' ./lib/Module/Generic.pm| awk '{print $2 }' | perl -pe 's/\;$//' | LC_COLLATE=C sort -uV`; do echo "can_ok( 'Module::Generic', '$sub' );"; done
can_ok( 'Module::Generic', 'DEBUG' );
can_ok( 'Module::Generic', 'FREEZE' );
can_ok( 'Module::Generic', 'THAW' );
can_ok( 'Module::Generic', 'VERBOSE' );
can_ok( 'Module::Generic', 'as_hash' );
can_ok( 'Module::Generic', 'clear' );
can_ok( 'Module::Generic', 'clear_error' );
can_ok( 'Module::Generic', 'clone' );
can_ok( 'Module::Generic', 'coloured' );
can_ok( 'Module::Generic', 'colour_close' );
can_ok( 'Module::Generic', 'colour_closest' );
can_ok( 'Module::Generic', 'colour_format' );
can_ok( 'Module::Generic', 'colour_open' );
can_ok( 'Module::Generic', 'colour_parse' );
can_ok( 'Module::Generic', 'colour_to_rgb' );
can_ok( 'Module::Generic', 'debug' );
can_ok( 'Module::Generic', 'deserialise' );
can_ok( 'Module::Generic', 'deserialize' );
can_ok( 'Module::Generic', 'dump' );
can_ok( 'Module::Generic', 'dumper' );
can_ok( 'Module::Generic', 'dumpto_dumper' );
can_ok( 'Module::Generic', 'dumpto_printer' );
can_ok( 'Module::Generic', 'dump_hex' );
can_ok( 'Module::Generic', 'dump_print' );
can_ok( 'Module::Generic', 'errno' );
can_ok( 'Module::Generic', 'error' );
can_ok( 'Module::Generic', 'error_handler' );
can_ok( 'Module::Generic', 'false' );
can_ok( 'Module::Generic', 'fatal' );
can_ok( 'Module::Generic', 'get' );
can_ok( 'Module::Generic', 'import' );
can_ok( 'Module::Generic', 'init' );
can_ok( 'Module::Generic', 'log_handler' );
can_ok( 'Module::Generic', 'message' );
can_ok( 'Module::Generic', 'messagef' );
can_ok( 'Module::Generic', 'messagef_colour' );
can_ok( 'Module::Generic', 'message_check' );
can_ok( 'Module::Generic', 'message_colour' );
can_ok( 'Module::Generic', 'message_frame' );
can_ok( 'Module::Generic', 'message_log' );
can_ok( 'Module::Generic', 'message_log_io' );
can_ok( 'Module::Generic', 'new' );
can_ok( 'Module::Generic', 'new_array' );
can_ok( 'Module::Generic', 'new_datetime' );
can_ok( 'Module::Generic', 'new_file' );
can_ok( 'Module::Generic', 'new_glob' );
can_ok( 'Module::Generic', 'new_hash' );
can_ok( 'Module::Generic', 'new_json' );
can_ok( 'Module::Generic', 'new_null' );
can_ok( 'Module::Generic', 'new_number' );
can_ok( 'Module::Generic', 'new_scalar' );
can_ok( 'Module::Generic', 'new_tempdir' );
can_ok( 'Module::Generic', 'new_tempfile' );
can_ok( 'Module::Generic', 'noexec' );
can_ok( 'Module::Generic', 'pass_error' );
can_ok( 'Module::Generic', 'printer' );
can_ok( 'Module::Generic', 'quiet' );
can_ok( 'Module::Generic', 'save' );
can_ok( 'Module::Generic', 'serialise' );
can_ok( 'Module::Generic', 'serialize' );
can_ok( 'Module::Generic', 'set' );
can_ok( 'Module::Generic', 'subclasses' );
can_ok( 'Module::Generic', 'true' );
can_ok( 'Module::Generic', 'verbose' );
can_ok( 'Module::Generic', 'will' );
can_ok( 'Module::Generic', '_autoload_subs' );
can_ok( 'Module::Generic', '_can' );
can_ok( 'Module::Generic', '_get_args_as_array' );
can_ok( 'Module::Generic', '_get_args_as_hash' );
can_ok( 'Module::Generic', '_get_stack_trace' );
can_ok( 'Module::Generic', '_has_base64' );
can_ok( 'Module::Generic', '_implement_freeze_thaw' );
can_ok( 'Module::Generic', '_instantiate_object' );
can_ok( 'Module::Generic', '_is_a' );
can_ok( 'Module::Generic', '_is_array' );
can_ok( 'Module::Generic', '_is_class_loadable' );
can_ok( 'Module::Generic', '_is_class_loaded' );
can_ok( 'Module::Generic', '_is_code' );
can_ok( 'Module::Generic', '_is_glob' );
can_ok( 'Module::Generic', '_is_hash' );
can_ok( 'Module::Generic', '_is_integer' );
can_ok( 'Module::Generic', '_is_ip' );
can_ok( 'Module::Generic', '_is_number' );
can_ok( 'Module::Generic', '_is_object' );
can_ok( 'Module::Generic', '_is_scalar' );
can_ok( 'Module::Generic', '_is_uuid' );
can_ok( 'Module::Generic', '_load_class' );
can_ok( 'Module::Generic', '_load_classes' );
can_ok( 'Module::Generic', '_lvalue' );
can_ok( 'Module::Generic', '_obj2h' );
can_ok( 'Module::Generic', '_parse_timestamp' );
can_ok( 'Module::Generic', '_refaddr' );
can_ok( 'Module::Generic', '_set_get' );
can_ok( 'Module::Generic', '_set_get_array' );
can_ok( 'Module::Generic', '_set_get_array_as_object' );
can_ok( 'Module::Generic', '_set_get_boolean' );
can_ok( 'Module::Generic', '_set_get_class' );
can_ok( 'Module::Generic', '_set_get_class_array' );
can_ok( 'Module::Generic', '_set_get_code' );
can_ok( 'Module::Generic', '_set_get_datetime' );
can_ok( 'Module::Generic', '_set_get_file' );
can_ok( 'Module::Generic', '_set_get_glob' );
can_ok( 'Module::Generic', '_set_get_hash' );
can_ok( 'Module::Generic', '_set_get_hash_as_mix_object' );
can_ok( 'Module::Generic', '_set_get_hash_as_object' );
can_ok( 'Module::Generic', '_set_get_ip' );
can_ok( 'Module::Generic', '_set_get_lvalue' );
can_ok( 'Module::Generic', '_set_get_number' );
can_ok( 'Module::Generic', '_set_get_number_as_object' );
can_ok( 'Module::Generic', '_set_get_number_as_scalar' );
can_ok( 'Module::Generic', '_set_get_number_or_object' );
can_ok( 'Module::Generic', '_set_get_object' );
can_ok( 'Module::Generic', '_set_get_object_array' );
can_ok( 'Module::Generic', '_set_get_object_array2' );
can_ok( 'Module::Generic', '_set_get_object_array_object' );
can_ok( 'Module::Generic', '_set_get_object_lvalue' );
can_ok( 'Module::Generic', '_set_get_object_variant' );
can_ok( 'Module::Generic', '_set_get_object_without_init' );
can_ok( 'Module::Generic', '_set_get_scalar' );
can_ok( 'Module::Generic', '_set_get_scalar_as_object' );
can_ok( 'Module::Generic', '_set_get_scalar_or_object' );
can_ok( 'Module::Generic', '_set_get_uri' );
can_ok( 'Module::Generic', '_set_get_uuid' );
can_ok( 'Module::Generic', '_to_array_object' );
can_ok( 'Module::Generic', '_warnings_is_enabled' );
can_ok( 'Module::Generic', '_warnings_is_registered' );
can_ok( 'Module::Generic', '__colour_data' );
can_ok( 'Module::Generic', '__create_class' );
can_ok( 'Module::Generic', '__dbh' );
can_ok( 'Module::Generic', '__instantiate_object' );

done_testing();

__END__
