package Daje::Database::View::VToolsParameterValues;
use Mojo::Base 'Daje::Database::View::Super::VToolsParameterValues', -base, -signatures, -async_await;
use v5.40;

# NAME
# ====
#
# Daje::Database::View::VToolsObjects - It creates perl code
#
# SYNOPSIS
# ========
#
#     use Daje::Database::View::VToolsObjects;
#
# DESCRIPTION
# ===========
#
# Daje::Database::View::VToolsObjects is a module that retrieves data from a View
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub load_parameters_from_group($self, $group, $tools_projects_pkey) {
    return $self->load_a_list(
        $self->view_name(), $self->fields(),
            {
                tools_projects_fkey => $tools_projects_pkey,
                parameter_group     => $group
            }
    );
}

sub load_parameters_from_group_and_parameter($self, $group, $parameter, $tools_projects_pkey) {
    return $self->load_a_list(
        $self->view_name(), $self->fields(),
        {
            tools_projects_fkey => $tools_projects_pkey,
            parameter_group     => $group,
            parameter           => $parameter,
        }
    );
}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Database::View::VToolsObjects - It creates perl code



=head1 SYNOPSIS


    use Daje::Database::View::VToolsObjects;



=head1 DESCRIPTION


Daje::Database::View::VToolsObjects is a module that retrieves data from a View



=head1 REQUIRES

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 load_parameters_from_group($self,

 load_parameters_from_group($self,();

NAME
====

Daje::Database::View::VToolsObjects - It creates perl code

SYNOPSIS
========

    use Daje::Database::View::VToolsObjects;

DESCRIPTION
===========

Daje::Database::View::VToolsObjects is a module that retrieves data from a View

LICENSE
=======

Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

AUTHOR
======

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head2 load_parameters_from_group_and_parameter($self,

 load_parameters_from_group_and_parameter($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

