#include <stdio.h>
#include "Toolbar.h"
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

void SetPixmap(Widget, char *);


void main(int argc,char *argv[])
{
Widget topLevel,newid;
Widget form;
Widget pb;


topLevel=XtInitialize(argv[0],"TB",NULL,0,&argc,argv);

form = XtVaCreateWidget("Form", xmFormWidgetClass, topLevel,
NULL);

newid=XtVaCreateWidget("Toolbar",xmToolbarWidgetClass,form,
		XmNtipPosition, XmTIP_BOTTOM_RIGHT,
		XtVaTypedArg, XmNbackground, XmRString, "#667788", 8,
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 20,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 20,
		XmNleftAttachment, XmATTACH_FORM,
		XmNleftOffset, 20,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 20,
		XtVaTypedArg, XmNtipForeground,XmRString, "black", 6,
		XtVaTypedArg, XmNtipBackground,XmRString, "yellow", 7,
		NULL);


pb = XtVaCreateManagedWidget("PushB1", xmPushButtonWidgetClass, newid,
		XtVaTypedArg, XmNtipLabel,XmRString, "X Logo", 7,
		NULL);

 SetPixmap(pb, "xlogo32");


   XtVaCreateManagedWidget("text", xmTextWidgetClass, newid,
		XmNconfigurable, False,
         	XtVaTypedArg, XmNtipLabel,XmRString,"Text", 5,
		XmNcolumns, 10,
		NULL);

pb = XtVaCreateManagedWidget("PushB2", xmPushButtonWidgetClass, newid,
		XtVaTypedArg, XmNtipLabel,XmRString, "Left", 5,
		NULL);
 SetPixmap(pb, "Left");
  
pb = XtVaCreateManagedWidget("PushB3", xmPushButtonWidgetClass, newid,
		XtVaTypedArg, XmNtipLabel,XmRString,"Right", 6,
		NULL);
 SetPixmap(pb, "Right");

pb = XtVaCreateManagedWidget("PushB4", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Down", 5,
             NULL);
 SetPixmap(pb, "Down");

pb = XtVaCreateManagedWidget("PushB4", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Up", 3,
             NULL);
 SetPixmap(pb, "Up");

pb = XtVaCreateManagedWidget("PushB5", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Rotate Left", 11,
		XmNnewGroup, True,
                  NULL);
 SetPixmap(pb, "RotateLeft");

pb = XtVaCreateManagedWidget("PushB6", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Rotate Right", 12,
                  NULL);
 SetPixmap(pb, "RotateRight");

pb = XtVaCreateManagedWidget("PushB5", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Flip Horizontal", 16,
		XmNnewGroup, True,
                  NULL);
 SetPixmap(pb, "FlipHoriz");

pb = XtVaCreateManagedWidget("PushB6", xmPushButtonWidgetClass, newid,
             XtVaTypedArg, XmNtipLabel,XmRString,"Flip Vertical", 14,
                  NULL);
 SetPixmap(pb, "FlipVert");

XtManageChild(newid);
XtManageChild(form);

XtRealizeWidget(topLevel);
XtMainLoop();
}



void SetPixmap(Widget w, char *filename)
{
Pixmap bitmap;
Pixel bg, fg;

XtVaGetValues(w,
		XmNbackground, &bg,
		XmNforeground, &fg,
		NULL);

bitmap = XmGetPixmap(XtScreen(w), filename, fg, bg);

if(bitmap)
XtVaSetValues(w,
	XmNlabelType, XmPIXMAP,
	XmNlabelPixmap, bitmap,
	NULL);
}
