.TH XmCenter 1
.SH NAME
\fBXmCenter\fR \-The Center widget class
.SH SYNOPSIS
.B #include <Center.h>
.SH DESCRIPTION
Center is a container widget used to layout child-widgets at the
center of it.

Following are some important considerations in using Center:

.IP o 4
There is no effect when using \fBXtSetValues\fR to change the 
\fBXmNx\fR and \fBXmNy\fR resources of a child, because the Center
itself decides the \fBXmNx\fR and \fBXmNy\fR resources of a child.

.IP o 4
Unmanaging a child unmaps it and Center again relayout its children. 

.IP o 4
It does not change the size of its child when it resizes. Instead it
again layout  to align its children.

.IP o 4
When any of the children changes its size, Center widget again layout
to align its children.


.SH Classes
Center inherits behavoir and resources from  \fBCore\fR, \fBComposite\fR,
\fBConstraint\fR and \fBXmManager\fR classes.

The class pointer is \fBxmCenterWidgetClass\fR.

The class name is \fBXmCenter\fR.

.SH New Resources
The following table defines s set of widget resources used by
the programmer to specify data. The programmer can also set the
resource values for the inherited classes to set attributes for this
widget.

.TS
c s s s
lfCW l.
\fBXmForm Resource Set\fR
\fBName\fR	\fBClass\fR	\fBType\fR	\fBDefault\fR
XmNorientation	XmROrientation	unsigned char	XmHORIZONTAL
XmNjustification	XmRJustification	unsigned char	XmJUSTIFICATION_CENTER
XmNspacing	XmRDimension	Dimension	0
XmNdistributed	XmRBoolean	Boolean	FALSE
.TE

.SS XmNorientation
Specify the orientation of the layout for the chidren.
.IP o 2
\fBXmHORIZONTAL\fR - arrange the children left to right.
This is the default.
.IP o 2
\fBXmVERTICAL\fR - arrange the children form top to bottom.

.SS XmNjustification 
Specify the relative alignment of the children.
.IP o 2
\fBXmJUSTIFICATION_CENTER\fR - All the center of the children are
at same line. This is the default.
.IP o 2
\fBXmJUSTIFICATION_BEGINNING\fR - If the \fBXmNorientation\fR is
\fBXmHORIZONTAL\fR the top of the children are justified - i.e.
the top of the children are at same horizontal line.
If \fBXmNorientation\fR is \fBXmVERTICAL\fR the children are left
justified.
.IP o 2
\fBXmJUSTIFICATION_END\fR - If the \fBXmNorientation\fR is \fBXmHORIZONTAL\fR
the bottom of the children are justified and for \fBXmVERTICAL\fR the children
are right justified.

.SS XmNspacing
Specify the space left between two children. It has no effect when 
\fBXmNdistributed\fR is \fITRUE\fR. The default value is \fI0\fR.

.SS XmNdistributed
Specify whether the children should be layout at the center of the Center.
If \fBXmNdistributed\fR is \fITRUE\fR, instead of keeping its children 
at the center children are distributed all over its space 
leaving equal spaces between them.  The default is \fIFALSE\fR.

.SH RELATED INFORMATION
.B Core, Composite, Constraint, XmManager.
