#include <stdio.h>
#include "data.h"
#include "defs.h"
#include "struct.h"

void playerwin_line(int l)
{
    char buf[80];
    W_Color color;

    if(players[l].p_status != PEMPTY) {
	sprintf(buf, "%c%2d: %-15s %3d.%02d %4d %4d", 
		(players[l].p_status == PALIVE) ? ' ' : 'D',
		l, players[l].p_name,
		players[l].p_kills/100, players[l].p_kills % 100,
		players[l].p_wins, players[l].p_losses);
	if(me == &players[l])
	    color = W_White;
	else if(players[l].p_team == 0)
	    color = W_Blue;
	else
	    color = W_Red;

	W_WriteText(playerwin, 0, l+1, color, buf, strlen(buf), W_RegularFont);
    } else {
	W_ClearArea(playerwin, 0, l+1, 80, 1);
    }
}

void redraw_player_win()
{
    int i;
    char buf[80];

    W_ClearWindow(playerwin);

    sprintf(buf, " Num Name             Kills Wins Losses");
    W_WriteText(playerwin, 0, 0, W_White, buf, strlen(buf), W_RegularFont);
    for(i=0;i<MAXPLAYERS;i++) {
	if(players[i].p_status != PEMPTY) {
	    playerwin_line(i);
	}
    }
}

void check_playerwin_updates()
{
    int i;

    if(me->p_updateplayers) {
	for(i = 0;i<MAXPLAYERS;i++) {
	    if(me->p_updateplayers & (1<<i)) {
		playerwin_line(i);
	    }
	}
	me->p_updateplayers = 0;
    }
}
