#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "data.h"
#include "struct.h"
#include "defs.h"

static char **motd=0;
static int motdLines=0, maxMotd=0, motdPage = 0;

void add_motd_line(int line, char *text)
{
    while(line >= maxMotd) {
		maxMotd += 10;
		if(motd) {
			motd = realloc(motd, maxMotd * sizeof(char *));
		} else
			motd = malloc(maxMotd * sizeof(char *));
    }

    motd[motdLines] = malloc(100);
    strncpy(motd[motdLines], text, 100);
    motdLines++;

    redrawMotd = 1;
}

void display_motd()
{
    int i, bold;
    W_Color color;
    int max;
    char *ptr;

    redrawMotd = 0;
    if(!motdwin) {
		motdwin = W_MakeTextWindow("Motd", 0, 0, 80, LINESPERPAGE, 0, 0, 0);
		W_Buffer(motdwin, 0);
		W_MapWindow(motdwin);
    }

    W_ClearWindow(motdwin);

    if(motdLines < (motdPage+1) * LINESPERPAGE)
		max = motdLines;
    else
		max = (motdPage+1) * LINESPERPAGE;

    for(i=motdPage * LINESPERPAGE;i<max;i++) {
		color = W_White;
		bold = 0;
		ptr = motd[i];
		if(motd[i][0] == '\\') {
			ptr = &motd[i][2];
			switch(motd[i][1]) {
			case 'r':
			case 'R':
				color = W_Red;
				break;
			case 'b':
			case 'B':
				color = W_Blue;
				break;
			case 'g':
			case 'G':
				color = W_Green;
				break;
			case 'y':
			case 'Y':
				color = W_Yellow;
				break;
			case 'c':
			case 'C':
				color = W_Cyan;
				break;
			case 'e':
			case 'E':
				color = W_Grey;
				break;
			default:
				color = W_White;
				break;
			}
			if(isupper(motd[i][1]))
				bold = 1;
		}
		W_WriteText(motdwin, 0, i % (LINESPERPAGE), color, ptr,
					strlen(ptr), bold ? W_BoldFont : W_RegularFont);
    }
}

void motd_key(int key)
{
    switch(key) {
	case ' ':
		if(me->p_status != POUTFIT) {
			W_DestroyWindow(motdwin);
			motdwin = 0;
		}
		return;
	case 'f':
		if(((motdPage+1) * LINESPERPAGE ) < motdLines) {
			motdPage++;
			display_motd();
		}
		return;
	case 'b':
		if(motdPage > 0) {
			motdPage--;
			display_motd();
		}
		return;
    }
}

		
