#include <stdio.h>
#include <string.h>
#include "Wlib.h"
#include "defs.h"
#include "data.h"
#include "struct.h"
#include "proto.h"

static char mess_buf[80];
static int mess_pos = 0, dest = -1;

void start_message()
{
    message_mode = 1;
    W_DefineTextCursor(cwin);
    W_DefineTextCursor(mapwin);
}

void end_message()
{
    message_mode = 0;
    W_RevertCursor(cwin);
    W_RevertCursor(mapwin);
}

void print_message(char *msg, int from, int to)
{
    char mbuf[100];
    W_Color color;
    W_Window mw;

    if(from == M_SRV) {
	strcpy(mbuf, "SRV->");
	color = W_White;
    } else if(from < MAXPLAYERS){
	sprintf(mbuf, "  %c->", players[from].p_char);
	if(from == me->p_num)
	    color = W_White;
	else if(players[from].p_team == 0)
	    color = W_Blue;
	else
	    color = W_Red;
    } else {
	sprintf(mbuf, "  ?->");
	color = W_White;
    }
    
    if(to == M_ALL) {
	strcat(mbuf, "All ");
	mw = messwin[MW_ALL];
    } else if(to < MAXPLAYERS) {
	sprintf(mbuf+5, "%c   ", players[to].p_char);
	mw = messwin[MW_INDIV];
    } else if(to == M_RED) {
	sprintf(mbuf+5, "Red ");
	mw = messwin[MW_TEAM];
    } else if(to == M_BLUE) {
	sprintf(mbuf+5, "Blu ");
	mw = messwin[MW_TEAM];
    } else {
	sprintf(mbuf+5, "?   ");
	mw = messwin[MW_ALL];
    }

    strcat(mbuf, msg);
    
    W_WriteText(mw, 0, 0, color, mbuf, strlen(mbuf), W_RegularFont);
    W_WriteText(messwin[MW_JOINED], 0, 0, color, mbuf, strlen(mbuf), W_RegularFont);
}

void redraw_message_win()
{
    char buf[81];
    char hdr_buf[10];

    W_ClearWindow(typewin);
    if(dest < 0)
	return;
    if(dest == M_ALL)
	strcpy(hdr_buf, "All");
    else if(dest < MAXPLAYERS)
	sprintf(hdr_buf, "%c  ", players[dest].p_char);
    else if(dest == M_RED)
	sprintf(hdr_buf, "Red");
    else if(dest == M_BLUE)
	sprintf(hdr_buf, "Blu");
    else
	sprintf(hdr_buf, "???");

    sprintf(buf, "You->%s %s_", hdr_buf, mess_buf);
    W_WriteText(typewin, 0, 0, W_White, buf, strlen(buf), W_RegularFont);
}

void message_event(W_Event *ev)
{
    if(ev->type == W_EV_KEY) {
	if(dest < 0) {
	    if(ev->Window == messwin[MW_ALL])
		dest = M_ALL;
	    else if(ev->Window == messwin[MW_TEAM])
		dest = (me->p_team == 0) ? M_BLUE : M_RED;
	    else {
		switch(ev->key) {
		  case '\033':
		    end_message();
		    break;
		  case 'A':
		    dest = M_ALL;
		    break;
		  case 'T':
		    if(me->p_team == 0)
			dest = M_BLUE;
		    else
			dest = M_RED;
		    break;
		  case 'R':
		    dest = M_RED;
		    break;
		  case 'B':
		    dest = M_BLUE;
		    break;
		  default:
		    if(ev->key >= '0' && ev->key <= '9')
			dest = ev->key - '0';
		    else if(ev->key >= 'a' && ev->key <= 'v')
			dest = ev->key - 'a' + 10;
		    else
			dest = -1;
		}
		redraw_message_win();
		return;
	    }
	}
	switch(ev->key) {
	  case 10:
	  case 13:
	    sendMessage(mess_buf, dest);
	    if(dest != M_ALL && dest != me->p_num && dest != me->p_team + M_BLUE)
		print_message(mess_buf, me->p_num, dest);
	    mess_pos = 0;
	    mess_buf[0] = 0;
	    dest = -1;
	    redraw_message_win();
	    if(message_mode)
		end_message();
	    return;
	  case 8:
	  case 127:
	    if(mess_pos > 0) {
		mess_pos--;
		mess_buf[mess_pos] = 0;
		redraw_message_win();
	    }
	    return;
	  case '\033':	
	    mess_pos = 0;
	    mess_buf[0] = 0;
	    dest = -1;
	    redraw_message_win();
	    if(message_mode)
		end_message();
	    return;
	  default:
	    if(mess_pos < 70) {
		mess_buf[mess_pos++] = ev->key;
		mess_buf[mess_pos] = 0;
		redraw_message_win();
	    }
	    return;
	}
    } else if(ev->type == W_EV_EXPOSE) {
	redraw_message_win();
    }
}
	
