#include <stdio.h>
#include <math.h>
#include "Wlib.h"
#include "struct.h"
#include "defs.h"
#include "data.h"
#include "proto.h"

int
getcourse(ww, x, y)
    W_Window ww;
    int     x, y;
{
    double result;

    if(ww == cwin)
	result = atan2((double) (x - my_dx),
		       (double) (my_dy - y)) / 3.14159 * 128.;
    else {
	x =(((map_info.m_width * GRIDWIDTH)<<4)*x)/(map_info.m_width * map_pixel);
	y =(((map_info.m_height * GRIDHEIGHT)<<4)*y)/(map_info.m_height * map_pixel);
	result = atan2((double) (x - me->p_x),
		       (double) (me->p_y - y)) / 3.14159 * 128.;
    }

    return (unsigned char) (int) floor (result + 0.5);
}

void do_input()
{
    W_Event ev;
    static int oldkeys, keys=0;

    while(W_EventsPending()) {
	W_NextEvent(&ev);
	oldkeys = keys;
	if(ev.Window == messwin[0] || 
	   ev.Window == messwin[1] ||
	   ev.Window == messwin[2] ||
	   ev.Window == messwin[3] ||
	   ev.Window == typewin)
	    message_event(&ev);
	else if(ev.Window == optionwin)
	    option_event(&ev);
	else {
	    switch(ev.type) {
	      case W_EV_KEY:
		if(ev.Window == motdwin) {
		    motd_key(ev.key);
		} else if(message_mode) {
		    message_event(&ev);
		} else {
		    ev.key = do_keymap(ev.key);
		    switch(ev.key) {
		      case 'f'+128:
			keys |= RKEY;
			break;
		      case 'b'+128:
			keys |= LKEY;
			break;
		      case 'n'+128:
			keys |= DKEY;
			break;
		      case 'p'+128:
			keys |= UKEY;
			break;
		      case 'Q':
			quit=1;
			break;
		      case 'D':
			displayoff = !displayoff;
			break;
		      case ' ':
			sendShell();
			break;
		      case '0':
		      case '1':
		      case '2':
		      case '3':
		      case '4':
		      case '5':
		      case '6':
		      case '7':
		      case '8':
		      case '9':
			sendSpeed(ev.key - '0');
			break;
		      case 'b':
			sendSpeed(-90);
			break;
		      case '+':
			if(udpSock < 0)
			    sendUdpRequest(1);
			else
			    closeUdpConn();
			break;
		      case 'M':
			if(W_IsMapped(motdwin)) {
			    W_DestroyWindow(motdwin);
			    motdwin = 0;
			} else {
			    display_motd();
			}
			break;
		      case '?':
			splitWindows = !splitWindows;
			check_variable(&splitWindows);
			break;
		      case 'O':
			map_option_win();
			break;
		      case 'm':
			sendMine();
			break;
		      case '\'':
			start_message();
			break;
		      case 'h': /* harvest a tree */
			sendBuild(T_GRASS);
			break;
		      case 'w':
			sendBuild(T_GWALL);
			break;
		      case 'r':
			sendBuild(T_ROAD);
			break;
		      case 'p':
			sendPing();
			break;
		      case '[':
			viewHeight-=10;
			printf("vh: %d, fd: %d\n", viewHeight, focalDist);
			break;
		      case ']':
			viewHeight+=10;
			printf("vh: %d, fd: %d\n", viewHeight, focalDist);
			break;
		      case '{':
			focalDist-=10;
			printf("vh: %d, fd: %d\n", viewHeight, focalDist);
			break;
		      case '}':
			focalDist+=10;
			printf("vh: %d, fd: %d\n", viewHeight, focalDist);
			break;
		      case 't':
			if(W_IsMapped(win3d))
			    W_UnmapWindow(win3d);
			else
			    W_MapWindow(win3d);
			break;
		      default:
			W_Beep();
			break;
			
		    }
		}
		break;
	      case W_EV_KEY_OFF:
		switch(ev.key) {
		  case 'f'+128:
		    keys &= ~RKEY;
		    break;
		  case 'b'+128:
		    keys &= ~LKEY;
		    break;
		  case 'n'+128:
		    keys &= ~DKEY;
		    break;
		  case 'p'+128:
		    keys &= ~UKEY;
		    break;
		}
		break;
	      case W_EV_EXPOSE:
		if(ev.Window == mapwin)
		    redraw_map();
		else if(ev.Window == typewin)
		    redraw_message_win();
		else if(ev.Window == playerwin)
		    redraw_player_win();
		else if(ev.Window == motdwin)
		    display_motd();
		else if(ev.Window == dashwin)
		    do_dash(1);
		break;
	      case W_EV_BUTTON:
		if(ev.Window == cwin || ev.Window == mapwin) {
		    if(message_mode)
			end_message();
		    switch(ev.key) {
		      case W_RBUTTON:
			sendCourse(getcourse(ev.Window, ev.x, ev.y));
			break;
		      case W_LBUTTON:
			sendShell();
			break;
		    }
			
		}
		break;
	    }
	}
	if(oldkeys != keys)
	    sendSteering(keys);
    }
}
