/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993-1997 Elan Feingold (elan@jeeves.net)                  *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _GAME
#define _GAME

#include "types.h"

#define PLACE_ONE       0
#define PLACE_MULTIPLE  1
#define PLACE_ALL       2

void     GAME_PlaceClick(Int32 iCountry, Int32 iPlaceType);
void     GAME_PlaceArmies(Int32 iCountry, Int32 iNumArmies);
Flag     GAME_ValidPlaceDst(Int32 iPlaceDst);

void     GAME_MoveArmies(Int32 iSrcCountry, Int32 iDstCountry, 
			 Int32 iNumArmies);
void     GAME_MoveClick(Int32 iCountry);
Flag     GAME_ValidMoveSrc(Int32 iMoveSrc);
Flag     GAME_ValidMoveDst(Int32 iMoveSrc, Int32 iMoveDst);

void     GAME_DoAttack(Int32 iSrcCountry, Int32 iDstCountry, 
		       Flag fCacheNotify);
void     GAME_Attack(Int32 iSrcCountry, Int32 iDstCountry);
void     GAME_AttackClick(Int32 iCountry);
Flag     GAME_ValidAttackSrc(Int32 iCountry, Flag fVerbose);
Flag     GAME_ValidAttackDst(Int32 iAttackSrc, Int32 iCountry, Flag fVerbose);
Flag     GAME_ValidAttackDice(Int32 iAttackDice, Int32 iCountry);
Flag     GAME_IsEnemyAdjacent(Int32 iCountry);
Flag     GAME_IsFrontierAdjacent(Int32 srcCountry, Int32 destCountry);
Int32    GAME_FindEnemyAdjacent(Int32 iCountry);


void     GAME_SetTurnArmiesOfPlayer(Int32 iCurrentPlayer);
Int32    GAME_GetContinentBonus(Int32 iPlayer);
void     GAME_PlayerDied(Int32 iDeadPlayer);
void     GAME_GetCard(Int32 iPlayer);
void     GAME_ExchangeCards(Int32 *piCards);
void     GAME_MissionAccomplied(Int32 iWinner, Int16 iTyp, Int32 iNum1, Int32 iNum2);
void     GAME_Victory(Int32 iWinner);
void     GAME_GameOverMan(void);
void     GAME_EndTurn(void);

Flag     GAME_IsMissionAccomplied(Int32 iPlayer, Int32 iKilledPlayer);
void     GAME_ShowMission(Int32 iPlayer);

extern Int32      iAttackSrc, iAttackDst;
extern Int32      iLastAttackSrc, iLastAttackDst;
extern Int32      iMoveSrc, iMoveDst;
extern Flag       fGetsCard, fCanExchange;

#endif
