/*****************************************************************************/
/*                               Pipe Command                                */
/*                                                                           */
/* pipe_command(progname, command, argv, input, output, error)               */
/*                                                                           */
/* progname is the name of the calling program                               */
/* command is the command to be executed                                     */
/* argv is the argument passed to the command (see execvp(3))                */
/* input is a function resembling read(2)                                    */
/* output is a function resembling write(2)                                  */
/* error is a function resembling write(2)                                   */
/*                                                                           */
/*****************************************************************************/
#ifndef PIPE_H
#define PIPE_H
void pipe_command(
		char *progname,
		char *command,
		char **argv,
		int input(char*, int),
		void output(const char*, int),
		void error(const char*, int)
				  );
#endif PIPE_H
