#include <stdio.h>
#include <unistd.h>
#include <sys/wait.h>
#define BUFSIZE 1024

void pipe_command(progname, command, argv, input,
				  output, error)
	char *progname;
	char *command;
	char **argv;
	int input(char*, int);
	void output(const char*, int);
	void error(const char*, int);
{
	int status;
	int in_pipe[2];
	int out_pipe[2];
	int err_pipe[2];
	int pid, bytes;
	char buffer[BUFSIZE];

	
 	if (pipe(in_pipe)==-1)
	{
		perror(progname);
		return;
	}
 	if (pipe(out_pipe)==-1)
	{
		perror(progname);
		return;
	}
 	if (pipe(err_pipe)==-1)
	{
		perror(progname);
		return;
	}
	
	pid = fork();
	if (pid==-1)
	{
		perror(progname);
		close(in_pipe[0]);
		close(in_pipe[1]);
		close(out_pipe[0]);
		close(out_pipe[1]);
		close(err_pipe[0]);
		close(err_pipe[1]);
		return;
	}
	
	if (!pid)
	{	/* child's thread */
		sprintf(buffer, "%s(child)", progname);
		close(in_pipe[1]); /* there's no writing on input pipe! */
		close(out_pipe[0]); /* there's no reading of output pipe! */
		close(err_pipe[0]); /* there's no reading of error pipe! */		
		/* redirect stdin */
		if (input)
		{			
			if (dup2(in_pipe[0], fileno(stdin))==-1)
			{
				perror(buffer);
				exit(1);
			}
		}
		/* redirect stdout */
		if (output)
		{			
			if (dup2(out_pipe[1], fileno(stdout))==-1)
			{
				perror(buffer);
				exit(1);
			}
		}
		/* redirect stderr */
		if (error)
		{
			if (dup2(err_pipe[1], fileno(stderr))==-1)
			{
				perror(buffer);
				exit(1);
			}
		}
		execvp(command, argv);
		perror(buffer);		
		exit(1);		
	}
	else
	{	/* parent's thread */
		close(in_pipe[0]); /* there's no reading of input pipe! */
		close(out_pipe[1]); /* there's no writing on output pipe! */
		close(err_pipe[1]); /* there's no writing on error pipe! */
		/* start writing to pipe */
		if (input)
		{			
			while((bytes=input(buffer, BUFSIZE-1))>0)
			{  
				bytes = write(in_pipe[1], buffer, bytes);
				if (bytes==-1)
				{  				
		  			perror(progname);
					break;
				}			
			}
		}
		close(in_pipe[1]);
		/* start reading pipe output */
		if (output)
		{
			while((bytes=read(out_pipe[0], buffer, BUFSIZE-1))>0)
				output(buffer, bytes);
			if (bytes==-1)
				perror(progname);
		}
		close(out_pipe[0]);
		/* start reading pipe error*/
		if (error)
		{
			while((bytes=read(err_pipe[0], buffer, BUFSIZE-1))>0)
				error(buffer, bytes);
			if (bytes==-1)
				perror(progname);
		}
		close(err_pipe[0]);
		waitpid(pid,&status,WNOHANG);
	
	}		
}
			
