<!--
SPDX-FileCopyrightText: 2019 Linus Jahn <lnj@kaidan.im>
SPDX-FileCopyrightText: 2021 Carl Schwan <carl@carlschwan.eu>

SPDX-License-Identifier: CC0-1.0
-->

# <img src="org.kde.plasmatube.svg" width="40"/> PlasmaTube

YouTube video player based on [mpv](https://mpv.io/), [yt-dlp](https://github.com/yt-dlp/yt-dlp), and [Invidious](https://github.com/iv-org/invidious).

<a href='https://flathub.org/apps/details/org.kde.plasmatube'><img width='190px' alt='Download on Flathub' src='https://flathub.org/assets/badges/flathub-badge-i-en.png'/></a>

![Screenshot](https://cdn.kde.org/screenshots/plasmatube/plasmatube.png)

## Features

* Invidious account support, and watching subscriptions.
* Related videos.
* Search and trending support.

## Supported Sources

PlasmaTube currently supports the following video sources:

* YouTube
  * [Invidious](https://invidious.io/)
  * [Piped](https://github.com/TeamPiped/Piped)
* [PeerTube](https://joinpeertube.org/)

Currently Invidious is the most mature source for YouTube. Only the latest versions of these sources are supported.

## Get It

Details on where to find stable releases of PlasmaTube can be found on it's
[homepage](https://apps.kde.org/plasmatube).

## Support

If you have an issue with PlasmaTube, please [open a support thread on KDE Discuss](https://discuss.kde.org/c/help/6).

## Building

The easiest way to make changes and test PlasmaTube during development is to [build it with kdesrc-build](https://community.kde.org/Get_Involved/development/Build_software_with_kdesrc-build).

## Contributing

Like other projects in the KDE ecosystem, contributions are welcome from all. This repository is managed in [KDE Invent](https://invent.kde.org/multimedia/plasmatube), our GitLab instance.

* Want to contribute code? See the [GitLab wiki page](https://community.kde.org/Infrastructure/GitLab) for a tutorial on how to send a merge request.
* Reporting a bug? Please submit it on the [KDE Bugtracking System](https://bugs.kde.org/enter_bug.cgi?format=guided&product=plasmatube). Please do not use the Issues
  tab to report bugs.
* Is there a part of PlasmaTube that's not translated? See the [Getting Involved in Translation wiki page](https://community.kde.org/Get_Involved/translation) to see how
  you can help translate!

If you get stuck or need help with anything at all, head over to the [KDE New Contributors room](https://go.kde.org/matrix/#/#kde-welcome:kde.org) on Matrix. For questions about PlasmaTube, please ask in the [Plasma Mobile room](https://go.kde.org/matrix/#/#plasmamobile:kde.org). See [Matrix](https://community.kde.org/Matrix) for more details.
