/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.JDEException;
import jde.debugger.gui.LVTreeNode;
import jde.debugger.gui.ReferenceModel;

class ArrayModel
extends ReferenceModel {
    private final ArrayReference m_value;
    private final DefaultTreeModel m_treeModel;

    ArrayModel(ArrayReference value, DefaultTreeModel treeModel) {
        if (null == value) {
            throw new IllegalArgumentException("Null value in constructor.");
        }
        if (null == treeModel) {
            throw new IllegalArgumentException("Null tree model in constructor.");
        }
        this.m_value = value;
        this.m_treeModel = treeModel;
    }

    int getChildCount() {
        return this.m_value.length();
    }

    boolean getAllowsChildren() {
        return true;
    }

    MutableTreeNode createChildAt(int index) throws JDEException {
        String name = ArrayModel.getIndexName(index);
        ArrayType arrayType = (ArrayType)this.m_value.type();
        MutableTreeNode node = LVTreeNode.makeTreeNode(name, arrayType.componentTypeName(), this.m_value.getValue(index), this.m_treeModel);
        return node;
    }

    String getValue() {
        return this.m_value.type().name() + "[" + this.m_value.length() + "]";
    }

    private static String getIndexName(int index) {
        return "[" + index + "]";
    }

    void updateChildren(TreeNode[] children) {
        TreeNode reloadParent = null;
        int index = 0;
        while (index < children.length && index < this.m_value.length()) {
            LVTreeNode child = ReferenceModel.asLVTreeNode(children[index]);
            if (null != child && child.getName().equals(ArrayModel.getIndexName(index))) {
                child.setValue(this.m_value.getValue(index));
            } else {
                if (null != children[index] && null != children[index].getParent()) {
                    reloadParent = children[index].getParent();
                }
                children[index] = null;
            }
            ++index;
        }
        if (null != reloadParent) {
            this.m_treeModel.reload(reloadParent);
        }
    }
}

