/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractLoader
extends DefaultHandler {
    private final String mPublicId;
    private final String mDtdResourceName;
    private final XMLReader mParser;

    protected AbstractLoader(String aPublicId, String aDtdResourceName) throws SAXException, ParserConfigurationException {
        this.mPublicId = aPublicId;
        this.mDtdResourceName = aDtdResourceName;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        this.mParser = factory.newSAXParser().getXMLReader();
        this.mParser.setContentHandler(this);
        this.mParser.setEntityResolver(this);
        this.mParser.setErrorHandler(this);
    }

    protected void parseInputSource(InputSource aInputSource) throws IOException, SAXException {
        this.mParser.parse(aInputSource);
    }

    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException {
        if (this.mPublicId.equals(aPublicId)) {
            InputStream dtdIS = this.getClass().getClassLoader().getResourceAsStream(this.mDtdResourceName);
            if (dtdIS == null) {
                throw new SAXException("Unable to load internal dtd " + this.mDtdResourceName);
            }
            return new InputSource(dtdIS);
        }
        return super.resolveEntity(aPublicId, aSystemId);
    }

    public void warning(SAXParseException aEx) throws SAXException {
        throw aEx;
    }

    public void error(SAXParseException aEx) throws SAXException {
        throw aEx;
    }

    public void fatalError(SAXParseException aEx) throws SAXException {
        throw aEx;
    }
}

