/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssPerspectiveOrigin
extends org.w3c.css.properties.css.CssPerspectiveOrigin {
    public static CssIdent[] allowed_values;
    public static CssIdent center;
    public static CssIdent top;
    public static CssIdent bottom;
    public static CssIdent left;
    public static CssIdent right;

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static boolean isVerticalIdent(CssIdent ident) {
        return top.equals(ident) || bottom.equals(ident);
    }

    public static boolean isHorizontalIdent(CssIdent ident) {
        return left.equals(ident) || right.equals(ident);
    }

    public CssPerspectiveOrigin() {
        this.value = initial;
    }

    public CssPerspectiveOrigin(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        int nb_val = expression.getCount();
        if (check && nb_val > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0 && CssIdent.isCssWide(val.getIdent())) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = val;
                expression.next();
                return;
            }
            values.add(val);
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        CssPerspectiveOrigin.parsePerspectiveOrigin(ac, values, this.getPropertyName());
        this.value = values.size() == 1 ? values.get(0) : new CssValueList(values);
    }

    protected static void parsePerspectiveOrigin(ApplContext ac, ArrayList<CssValue> values, String caller) throws InvalidParamException {
        int nb_keyword = 0;
        int nb_values = values.size();
        if (nb_values > 2 || nb_values == 0) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block5: for (CssValue aValue : values) {
            switch (aValue.getType()) {
                case 5: {
                    aValue.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 4: 
                case 6: {
                    continue block5;
                }
                case 0: {
                    ++nb_keyword;
                    continue block5;
                }
            }
            throw new InvalidParamException("value", aValue, caller, ac);
        }
        if (nb_keyword > 0 && nb_values == 2) {
            CssIdent id;
            boolean gothorizontal = false;
            boolean gotvertical = false;
            CssValue v = values.get(0);
            if (v.getType() == 0 && !(gothorizontal = CssPerspectiveOrigin.isHorizontalIdent(id = v.getIdent()))) {
                gotvertical = CssPerspectiveOrigin.isVerticalIdent(id);
            }
            if ((v = values.get(1)).getType() == 0) {
                id = v.getIdent();
                if (gothorizontal && CssPerspectiveOrigin.isHorizontalIdent(id)) {
                    throw new InvalidParamException("value", id, caller, ac);
                }
                if (gotvertical && CssPerspectiveOrigin.isVerticalIdent(id)) {
                    throw new InvalidParamException("value", id, caller, ac);
                }
            }
        }
    }

    public CssPerspectiveOrigin(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        top = CssIdent.getIdent("top");
        bottom = CssIdent.getIdent("bottom");
        left = CssIdent.getIdent("left");
        right = CssIdent.getIdent("right");
        center = CssIdent.getIdent("center");
        allowed_values = new CssIdent[5];
        CssPerspectiveOrigin.allowed_values[0] = top;
        CssPerspectiveOrigin.allowed_values[1] = bottom;
        CssPerspectiveOrigin.allowed_values[2] = left;
        CssPerspectiveOrigin.allowed_values[3] = right;
        CssPerspectiveOrigin.allowed_values[4] = center;
    }
}

