/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontVariantNumeric
extends org.w3c.css.properties.css.CssFontVariantNumeric {
    public static final CssIdent normal;
    public static final CssIdent slashedZero;
    public static final CssIdent ordinal;
    public static final CssIdent[] numericFigValues;
    public static final CssIdent[] numericSpaValues;
    public static final CssIdent[] numericFraValues;

    public static final CssIdent getNumericFigValues(CssIdent ident) {
        for (CssIdent id : numericFigValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getNumericSpaValues(CssIdent ident) {
        for (CssIdent id : numericSpaValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getNumericFraValues(CssIdent ident) {
        for (CssIdent id : numericFraValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (slashedZero.equals(ident)) {
            return slashedZero;
        }
        if (ordinal.equals(ident)) {
            return ordinal;
        }
        CssIdent id = CssFontVariantNumeric.getNumericFigValues(ident);
        if (id == null && (id = CssFontVariantNumeric.getNumericFraValues(ident)) == null) {
            id = CssFontVariantNumeric.getNumericSpaValues(ident);
        }
        return id;
    }

    public CssFontVariantNumeric() {
        this.value = initial;
    }

    public CssFontVariantNumeric(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 5) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue fraValue = null;
        CssValue figValue = null;
        CssValue spaValue = null;
        CssValue zerValue = null;
        CssValue ordValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0) {
                CssIdent ident = val.getIdent();
                if (CssIdent.isCssWide(ident) || normal.equals(ident)) {
                    if (expression.getCount() != 1) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    this.value = val;
                } else {
                    boolean match = false;
                    if (figValue == null) {
                        boolean bl = match = CssFontVariantNumeric.getNumericFigValues(ident) != null;
                        if (match) {
                            figValue = val;
                        }
                    }
                    if (!match && fraValue == null) {
                        boolean bl = match = CssFontVariantNumeric.getNumericFraValues(ident) != null;
                        if (match) {
                            fraValue = val;
                        }
                    }
                    if (!match && spaValue == null) {
                        boolean bl = match = CssFontVariantNumeric.getNumericSpaValues(ident) != null;
                        if (match) {
                            spaValue = val;
                        }
                    }
                    if (!match && zerValue == null && (match = slashedZero.equals(ident))) {
                        zerValue = val;
                    }
                    if (!match && ordValue == null && (match = ordinal.equals(ident))) {
                        ordValue = val;
                    }
                    if (!match) {
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                }
            } else {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (expression.getCount() == 1) {
            if (figValue != null) {
                this.value = figValue;
            } else if (fraValue != null) {
                this.value = fraValue;
            } else if (spaValue != null) {
                this.value = spaValue;
            } else if (zerValue != null) {
                this.value = zerValue;
            } else if (ordValue != null) {
                this.value = ordValue;
            }
        } else {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (figValue != null) {
                v.add(figValue);
            }
            if (fraValue != null) {
                v.add(fraValue);
            }
            if (spaValue != null) {
                v.add(spaValue);
            }
            if (zerValue != null) {
                v.add(zerValue);
            }
            if (ordValue != null) {
                v.add(ordValue);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssFontVariantNumeric(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _numericFigValues = new String[]{"lining-nums", "oldstyle-nums"};
        String[] _numericSpaValues = new String[]{"proportional-nums", "tabular-nums"};
        String[] _numericFraValues = new String[]{"diagonal-fractions", "stacked-fractions"};
        normal = CssIdent.getIdent("normal");
        slashedZero = CssIdent.getIdent("slashed-zero");
        ordinal = CssIdent.getIdent("ordinal");
        numericFigValues = new CssIdent[_numericFigValues.length];
        int i = 0;
        for (String s : _numericFigValues) {
            CssFontVariantNumeric.numericFigValues[i++] = CssIdent.getIdent(s);
        }
        numericSpaValues = new CssIdent[_numericSpaValues.length];
        i = 0;
        for (String s : _numericSpaValues) {
            CssFontVariantNumeric.numericSpaValues[i++] = CssIdent.getIdent(s);
        }
        numericFraValues = new CssIdent[_numericFraValues.length];
        i = 0;
        for (String s : _numericFraValues) {
            CssFontVariantNumeric.numericFraValues[i++] = CssIdent.getIdent(s);
        }
    }
}

