/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssColumnWidth
extends org.w3c.css.properties.css.CssColumnWidth {
    public static final CssIdent[] allowed_values;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssColumnWidth() {
        this.value = initial;
    }

    public CssColumnWidth(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, this);
            }
            case 6: {
                CssCheckableValue l = val.getCheckableValue();
                l.checkPositiveness(ac, this);
                if (l.isZero()) {
                    ac.getFrame().addWarning("greaterequal", new String[]{l.toString(), "1px"});
                }
                this.value = val;
                break;
            }
            case 11: {
                this.value = CssColumnWidth.parseFitContentFunction(ac, val, this);
                break;
            }
            case 0: {
                CssIdent ident = val.getIdent();
                if (CssIdent.isCssWide(ident)) {
                    this.value = val;
                    break;
                }
                if (CssColumnWidth.getAllowedIdent(ident) != null) {
                    this.value = val;
                    break;
                }
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssColumnWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == initial;
    }

    protected static CssFunction parseFitContentFunction(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        CssFunction function = value.getFunction();
        CssExpression exp = function.getParameters();
        if (!"fit-content".equals(function.getName())) {
            throw new InvalidParamException("function", ac);
        }
        if (exp.getCount() > 1) {
            throw new InvalidParamException("function", ac);
        }
        CssValue val = exp.getValue();
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, caller);
            }
            case 4: 
            case 6: {
                break;
            }
            default: {
                throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
            }
        }
        return function;
    }

    static {
        String[] _allowed_values = new String[]{"auto", "max-content", "min-content"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssColumnWidth.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

