/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public final class HeadBiasedSortedSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    private final Comparator<? super E> comparator;
    private final Node<E> head = new Node<Object>(null, null);
    private int size = 0;

    public HeadBiasedSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public HeadBiasedSortedSet() {
        this.comparator = null;
    }

    public HeadBiasedSortedSet(SortedSet<E> set) {
        this.comparator = set.comparator();
        for (Object e : set) {
            this.add(e);
        }
    }

    public HeadBiasedSortedSet(Collection<? extends E> collection) {
        this.comparator = null;
        for (E e : collection) {
            this.add(e);
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl(this.head.next);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E first() {
        Node first = this.head.next;
        if (first == null) {
            throw new NoSuchElementException();
        }
        return (E)first.value;
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E last() {
        Node first = this.head.next;
        if (first == null) {
            throw new NoSuchElementException();
        }
        Node prev = first;
        while (prev.next != null) {
            prev = prev.next;
        }
        return (E)prev.value;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        Node<Object> prev = this.head;
        while (prev.next != null) {
            int comp = this.compare(o, prev.next.value);
            if (comp < 0) {
                prev.next = new Node<E>(o, prev.next);
                ++this.size;
                return true;
            }
            if (comp == 0) {
                return false;
            }
            prev = prev.next;
        }
        prev.next = new Node<E>(o, null);
        ++this.size;
        return true;
    }

    private int compare(E one, E other) {
        if (this.comparator == null) {
            return ((Comparable)one).compareTo(other);
        }
        return this.comparator.compare(one, other);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head.next = null;
    }

    private final class Node<F> {
        public final F value;
        public Node<F> next;

        public Node(F value, Node<F> next) {
            this.value = value;
            this.next = next;
        }
    }

    private final class IteratorImpl
    implements Iterator<E> {
        private Node<E> next;

        IteratorImpl(Node<E> head) {
            this.next = head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object rv = this.next.value;
            this.next = this.next.next;
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

