/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;

public class ImportedFunctionLibrary
implements FunctionLibrary,
XQueryFunctionBinder {
    QueryModule importingModule;
    XQueryFunctionLibrary baseLibrary;
    HashSet namespaces = new HashSet(5);

    public ImportedFunctionLibrary(QueryModule importingModule, XQueryFunctionLibrary baseLibrary) {
        this.importingModule = importingModule;
        this.baseLibrary = baseLibrary;
    }

    public void addImportedNamespace(String namespace) {
        this.namespaces.add(namespace);
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        String uri = functionName.getNamespaceURI();
        if (this.namespaces.contains(uri)) {
            Expression call = this.baseLibrary.bind(functionName, staticArgs, env);
            if (call != null) {
                XQueryFunction def = this.baseLibrary.getDeclaration(functionName, staticArgs);
                this.importingModule.checkImportedFunctionSignature(def);
            }
            return call;
        }
        return null;
    }

    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        if (this.namespaces.contains(functionName.getNamespaceURI())) {
            return this.baseLibrary.getDeclaration(functionName, staticArgs);
        }
        return null;
    }

    public FunctionLibrary copy() {
        ImportedFunctionLibrary lib = new ImportedFunctionLibrary(this.importingModule, this.baseLibrary);
        Iterator iter = this.namespaces.iterator();
        while (iter.hasNext()) {
            String ns = (String)iter.next();
            lib.addImportedNamespace(ns);
        }
        return lib;
    }

    public void setImportingModule(QueryModule importingModule) {
        this.importingModule = importingModule;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        return this.namespaces.contains(functionName.getNamespaceURI()) && this.baseLibrary.isAvailable(functionName, arity);
    }
}

