/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class DefaultEMLookup
extends ProxyLookup
implements LookupListener,
PropertyChangeListener {
    private static final Object PRESENT = new Object();
    private ExplorerManager tc;
    private LookupListener listener;
    private Map<Lookup, Lookup.Result> attachedTo;
    private Lookup actionMap;

    public DefaultEMLookup(ExplorerManager explorerManager, ActionMap actionMap) {
        this.tc = explorerManager;
        this.listener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, null);
        this.actionMap = Lookups.singleton((Object)actionMap);
        explorerManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)explorerManager));
        this.updateLookups(explorerManager.getSelectedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookups(Node[] nodeArray) {
        Map<Object, Object> map;
        if (nodeArray == null) {
            nodeArray = new Node[]{};
        }
        Lookup[] lookupArray = new Lookup[nodeArray.length];
        DefaultEMLookup defaultEMLookup = this;
        synchronized (defaultEMLookup) {
            map = this.attachedTo == null ? Collections.emptyMap() : new HashMap<Lookup, Lookup.Result>(this.attachedTo);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            lookupArray[i] = nodeArray[i].getLookup();
            if (map == null) continue;
            map.remove(nodeArray[i]);
        }
        for (Lookup.Result result : map.values()) {
            result.removeLookupListener(this.listener);
        }
        DefaultEMLookup defaultEMLookup2 = this;
        synchronized (defaultEMLookup2) {
            this.attachedTo = null;
        }
        this.setLookups(new Lookup[]{new NoNodeLookup((Lookup)new ProxyLookup(lookupArray), nodeArray), Lookups.fixed((Object[])nodeArray), this.actionMap});
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.updateLookups(this.tc.getSelectedNodes());
    }

    private static boolean isNodeQuery(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Node.class);
    }

    protected synchronized void beforeLookup(Lookup.Template<?> template) {
        if (this.attachedTo == null && DefaultEMLookup.isNodeQuery(template.getType())) {
            Lookup[] lookupArray = this.getLookups();
            this.attachedTo = new WeakHashMap<Lookup, Lookup.Result>(lookupArray.length * 2);
            for (int i = 0; i < lookupArray.length - 2; ++i) {
                Lookup.Result result = lookupArray[i].lookup(template);
                result.addLookupListener(this.listener);
                this.attachedTo.put(lookupArray[i], result);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes" == propertyChangeEvent.getPropertyName()) {
            this.updateLookups((Node[])propertyChangeEvent.getNewValue());
        }
    }

    private static final class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;
        private final Map<Node, Object> verboten;

        public NoNodeLookup(Lookup lookup, Node[] nodeArray) {
            this.delegate = lookup;
            this.verboten = new IdentityHashMap<Node, Object>();
            int n = 0;
            while (n < nodeArray.length) {
                this.verboten.put(nodeArray[n++], PRESENT);
            }
        }

        public <T> T lookup(Class<T> clazz) {
            if (clazz == Node.class) {
                return null;
            }
            Object object = this.delegate.lookup(clazz);
            if (this.verboten.containsKey(object)) {
                for (Object e : this.lookup(new Lookup.Template(clazz)).allInstances()) {
                    if (this.verboten.containsKey(e)) continue;
                    return (T)e;
                }
                return null;
            }
            return (T)object;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Class clazz = template.getType();
            if (clazz == Node.class) {
                return Lookup.EMPTY.lookup(new Lookup.Template(clazz));
            }
            return new ExclusionResult(this.delegate.lookup(template), this.verboten);
        }

        private static final class ExclusionResult<T>
        extends Lookup.Result<T>
        implements LookupListener {
            private final Lookup.Result<T> delegate;
            private final Map<Node, Object> verboten;
            private final List<LookupListener> listeners = new ArrayList<LookupListener>();

            public ExclusionResult(Lookup.Result<T> result, Map<Node, Object> map) {
                this.delegate = result;
                this.verboten = map;
            }

            public Collection<? extends T> allInstances() {
                Collection collection = this.delegate.allInstances();
                ArrayList arrayList = new ArrayList(collection.size());
                for (Object e : collection) {
                    if (this.verboten.containsKey(e)) continue;
                    arrayList.add(e);
                }
                return arrayList;
            }

            public Set<Class<? extends T>> allClasses() {
                return this.delegate.allClasses();
            }

            public Collection<? extends Lookup.Item<T>> allItems() {
                Collection collection = this.delegate.allItems();
                ArrayList<Lookup.Item> arrayList = new ArrayList<Lookup.Item>(collection.size());
                for (Lookup.Item item : collection) {
                    if (Node.class.isAssignableFrom(item.getType()) && this.verboten.containsKey(item.getInstance())) continue;
                    arrayList.add(item);
                }
                return arrayList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener lookupListener) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    if (this.listeners.isEmpty()) {
                        this.delegate.addLookupListener((LookupListener)this);
                    }
                    this.listeners.add(lookupListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener lookupListener) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.remove(lookupListener);
                    if (this.listeners.isEmpty()) {
                        this.delegate.removeLookupListener((LookupListener)this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                LookupListener[] lookupListenerArray;
                LookupEvent lookupEvent2 = new LookupEvent((Lookup.Result)this);
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    lookupListenerArray = this.listeners.toArray(new LookupListener[0]);
                }
                for (int i = 0; i < lookupListenerArray.length; ++i) {
                    lookupListenerArray[i].resultChanged(lookupEvent2);
                }
            }
        }
    }
}

