/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openide.util.Parameters;

public abstract class CachedHiDPIIcon
implements Icon {
    private static final double MAX_CACHE_SIZE = 10.0;
    private final int width;
    private final int height;
    private final Map<CachedImageKey, Image> cache = new LinkedHashMap<CachedImageKey, Image>(16, 0.75f, true);
    private double cacheSize = 0.0;

    protected CachedHiDPIIcon(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.width = n;
        this.height = n2;
    }

    private synchronized Image getScaledImageCached(Component component, CachedImageKey cachedImageKey) {
        Image image = this.cache.get(cachedImageKey);
        if (image != null) {
            return image;
        }
        double d = cachedImageKey.getScale();
        int n = (int)Math.ceil((double)this.getIconWidth() * d);
        int n2 = (int)Math.ceil((double)this.getIconHeight() * d);
        Image image2 = this.createAndPaintImage(component, cachedImageKey.getColorModel(), n, n2, d);
        double d2 = cachedImageKey.getSize();
        if (d2 <= 10.0) {
            Iterator<CachedImageKey> iterator = this.cache.keySet().iterator();
            while (this.cacheSize + d2 > 10.0 && iterator.hasNext()) {
                CachedImageKey cachedImageKey2 = iterator.next();
                iterator.remove();
                this.cacheSize -= cachedImageKey2.getSize();
            }
            this.cache.put(cachedImageKey, image2);
            this.cacheSize += d2;
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.getIconWidth() == 0 || this.getIconHeight() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        CachedImageKey cachedImageKey = CachedImageKey.create(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            graphics2D.translate(n, n2);
            Image image = this.getScaledImageCached(component, cachedImageKey);
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)affineTransform2.getTranslateX(), (int)affineTransform2.getTranslateY()));
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    protected abstract Image createAndPaintImage(Component var1, ColorModel var2, int var3, int var4, double var5);

    protected static final BufferedImage createBufferedImage(ColorModel colorModel, int n, int n2) {
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
    }

    private static final class CachedImageKey {
        private final ColorModel colorModel;
        private final double scale;

        private CachedImageKey(ColorModel colorModel, double d) {
            Parameters.notNull((CharSequence)"colorModel", (Object)colorModel);
            if (d <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.colorModel = colorModel;
            this.scale = d;
        }

        public static CachedImageKey create(Graphics2D graphics2D) {
            AffineTransform affineTransform = graphics2D.getTransform();
            int n = affineTransform.getType();
            double d = n == 2 || n == 3 ? affineTransform.getScaleX() : 1.0;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            ColorModel colorModel = graphicsConfiguration.getColorModel(3);
            return new CachedImageKey(colorModel, d);
        }

        public double getScale() {
            return this.scale;
        }

        public double getSize() {
            return Math.pow(this.getScale(), 2.0);
        }

        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public int hashCode() {
            return Objects.hash(this.colorModel, this.scale);
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedImageKey)) {
                return false;
            }
            CachedImageKey cachedImageKey = (CachedImageKey)object;
            return this.colorModel.equals(cachedImageKey.colorModel) && this.scale == cachedImageKey.scale;
        }

        public String toString() {
            return "CachedImageKey(" + this.colorModel + ", " + this.scale + ")";
        }
    }
}

